'** open32_03.bas
'** Open Source Editor v32.02
'** Please add your name to
'** the list of authors and
'** give your version a unique filename:
'**
'** Authors:
'**
'** Alyce Watson
'** Brent Thorn      - tooltip routines and cascading popup menu
'** David Szafranski - launch browser with URL & launch email
'** September 2000   - added recent files menu list by Brent Thorn
'** January 2001     - adding runtime engine for LB2 w/command line
'** Doyle Whisenant  - array-maker similar to LB Workshop tool
'** AW-March 2001    - removed caret creation functions, which didn't always work correctly
'** AW-March 2001    - added recent files list to ini file
'** AW-March 2001    - modified recent files menu list to show filenames
'** AW-July 2001     - ported to LB3
'                    - * changed API calls for ShellExecuteA, SetWindowTextA,
'                    - *     and ModifyMenuA
'                    - * removed code library, which was LB2 syntax
'                    - * fixed look of array maker for LB3
'                    - * changed bmp dimension functions for bmp previewer
'                    - * fixed drawing bmpbutton for LB3 - added fill
'                    - *     and backcolor of buttonface
'                    - * condensed font commands for controls in bmp previewer
'                    - * added pen color tattletale to bmp previewer
'                    - * changed color choice in bmp previewer to colordialog
'** Brent Thorn      - Updated his tooltip routine, July, 2001
'** AW-January 2002  - Cleanup and more LB3 updating and comments
'                      * more updates to tooltips
'                      * removed help-tutorial menu and button
'                      * removed dummy EDIT menu
'                      * changed helpfile engine to winhlp32
'** AW-February 2002 - Added multiple textbox colors to bmp previewer and array maker
'** AW-March 2002    - Made XP compatible
'                      * changed externals winfile.exe to explorer.exe
'                      * changed externals paintbrush to SearchTreeForFile for mspaint.exe
'                      * added *.lba extension
'** AW-April 2002    - Added Icon Changer for runtime engine

'
'
'
'

    if val(Version$)<3 then
        notice "This program is meant for in LBv3.0!"
        end
    end if

    cursor hourglass
    nomainwin

    gosub [makebmpbutton]

    if FileExist(DefaultDir$,"\qbutton.bmp")<1 then
        notice "Error"+chr$(13)+"Unable to create bmpbutton!"
        end
    end if


    open "user32" for dll as #user
    open "comctl32.dll" for dll as #cctl

    dim info$(10,10)        'for file exist check
    dim branch$(100)        'array to hold branch labels
    dim code$(100)          'array to hold code titles
    dim recentfiles$(3)     'array to hold recent files


'variables:
'file$              name of file to open
'title$             titlebar caption
'h                  is window handle
'modflag$           is answer to modified query
'answer$            receiver variable for confirm messages
'tempfilename$      name to use when running and debugging code
'rowVar,columnVar   location of texteditor origin
'fileindex          used for counter in path/file separation
'filelength         used for counter in path/file separation
'shortFile$         just filename without path
'filePath$          path without filename
'saveit$            receiver for input from texteditor
'libertyexe$        path to Liberty.exe for running/tokenizing/debugging
'tknfile$           name of tkn to run
'hInstance          window instance handle
'rowcount           number of lines in editor
'line$              contents of line in editor
'bx                 counter variable for branch label loading
'branchlength       length of branch label
'branchselect$      branch label selection
'picFile$           filename for opened bitmap
'savebmpfile$       name to save bmp AS
'bmpwidth           width of bitmap
'bmpheight          height of bitmap
'xbmp               x location to draw bitmap in graphicbox
'ybmp               y location to draw bitmap in graphicbox
'bmploaded          flag to set when a bitmap is loaded
'message$           string variable to hold notice and confirm messages
'printFile$         temporary file for printing with Notepad
'wavPath$           path to last wav played
'wavFile$           name of wav file to play
'slash              counter variable to separate wav path from filename
'setFont$           LB fontname and size info for chosen font
'timemsg$           variable to hold time info
'datemsg$           variable to hold date info
'RunFile$           for ShellExecute
'lpOperation$       for ShellExecute
'lpParameters$      for ShellExecute
'lpDirectory$       for ShellExecute
'nShowCmd           show window flag for ShellExecute
'helpopen           flag for help window opening
'bString            flag for array string
'bNumeric           flag for array numeric
'i                  index var for general use
'a                  index var for general use
'arrayName$         name of array
'arrayItem$         individual array items
'myarray$()         variable for generating array items
'ArrayFileName$     name of file opened for creating array
'line$              file input variable
'rfile$             dummy file name for input from ini file
'hmenuRecent        handle of recent files menu popup
'menuString$        caption of menu item
'menuID             ID of menu item
'comExt$            extensions for running from command line
'RootPath$          for finding mspaint w/SearchTreeForFile
'InputPathName$     for finding mspaint w/SearchTreeForFile
'OutputPathBuffer$  for finding mspaint w/SearchTreeForFile
'icoFile$           filename for icon file
'runexe$            runtime engine name for icon changer



    ForegroundColor$=   "darkblue"
    TexteditorColor$=   "lightgray"
    drawcolor$=         "0 0 0"     'default color for drawing on bitmaps
    decnum$=            "255"       'default starter for number conversion
    decnum=             val(decnum$)
    hexnum$=            "FF"        'default starter for number conversion
    btnhigh =           15          'button height value
    btnwide =           30          'button width value
    btnY    =           2           'button y location


menu #1, "&File",_
    "&New",               [new],_
    "&Open",              [open],_
    "&Save",              [save],_
    "Save &As",           [saveas],|,_
    "&Print",             [print],_
    "E&xit",              [quit],_
    "&Recent",            [loop]

    Menu #1, "Recent",_
    "File 1",             [File_1],_
    "File 2",             [File_2],_
    "File 3",             [File_3]

menu #1, "Edit" 'LB supplies the Edit Menu


menu #1, "&Run",_
    "Ru&n",               [run],_
    "&Debug",             [debug],_
    "&Make TKN",          [maketkn],_
    "Run &TKN",           [runtkn]

menu #1, "E&xternals",_
    "&MS Paint",          [paint],_
    "&Explorer",          [winfile],_
    "&Notepad",           [notepad],_
    "&Calculator",        [calculator]

menu #1, "&Tools",_
    "&Branch Labels",        [branchlabels],_
    "Bit&map Preview",       [bmp],_
    "&Wav Preview",          [wav],_
    "&Array Maker",          [makeArrays],_
    "Font &Dialog",          [fontdialog],_
    "&Number Tools",         [numbertools],_
    "Time and Dat&e",        [timetools],|,_
    "Libert&y BASIC Website",[libertyhome],_
    "Email Carl &Gundel",    [emailcarl],_
    "&Change Runtime Icon",  [runtimeIcon]


menu #1, "&Help",_
    "&Liberty BASIC Help", [help],_
    "&Editor Help",        [edithelp],_
    "&About",              [about]

    texteditor #1.t, 0,40,600,400  'edit window

    button #1.new,     "New",   [new],       UL,3,btnY,btnwide,btnhigh
    button #1.open,    "Open",  [open],      UL,34,btnY,btnwide,btnhigh
    button #1.save,    "Save",  [save],      UL,65,btnY,btnwide,btnhigh
    button #1.saveas,  "..As",  [saveas],    UL,96,btnY,btnwide,btnhigh
    button #1.print,   "Print", [print],     UL,127,btnY,btnwide,btnhigh

    button #1.run,     "Run",   [run],       UL,167,btnY,btnwide,btnhigh
    button #1.debug,   "Debug", [debug],     UL,198,btnY,btnwide,btnhigh
    button #1.token,   "TKN",   [maketkn],   UL,229,btnY,btnwide,btnhigh
    button #1.runtkn,  "R tkn", [runtkn],    UL,260,btnY,btnwide,btnhigh

    button #1.paint,   "Paint", [paint],     UL,300,btnY,btnwide,btnhigh
    button #1.file,    "Explr", [winfile],   UL,331,btnY,btnwide,btnhigh
    button #1.note,    "Note",  [notepad],   UL,362,btnY,btnwide,btnhigh
    button #1.calc,    "Calc",  [calculator],UL,393,btnY,btnwide,btnhigh

    button #1.help,    "Help",  [help],      UL,433,btnY,btnwide,btnhigh
    button #1.about,   "About", [about],     UL,464,btnY,btnwide,btnhigh

    bmpbutton #1.quit, "qbutton.bmp",[quit], UL,504,btnY


open "Open Source LB Editor" for window as #1

    h=HWND(#1)
    hText=hwnd(#1.t)
    print #1, "trapclose [quit]"
    print #1, "resizehandler [resize]"


    calldll #user, "ShowWindow",h as long,_SW_MAXIMIZE as long,result As long

    print #1,     "font arial 0 12"
    print #1.t, "!setfocus";
    gosub [remove.menu]
    gosub [read.ini.file]
    gosub [addTooltips]

[check.command]  'if CommandLine$ contains a filename, it will be loaded at startup
    if CommandLine$<>"" then
        CommandLine$=lower$(trim$(CommandLine$))
        comExt$=right$(CommandLine$,3)
        if comExt$="bas" or comExt$="lba" then
            i=len(CommandLine$)
            while mid$(CommandLine$,i,1)<>" " and i>1
                i=i-1
            wend
            file$=mid$(CommandLine$,i)
            goto [loadFile]
        end if
    end if

    cursor normal

WAIT

[loop]
    wait

[quit]
    gosub [isModified]
    close #user: close #1 : close #cctl
    if tempfilename$<>"" then kill tempfilename$
    gosub [write.ini.file]
    END


[isModified]'** CHECK TO SEE IF FILE HAS BEEN MODIFIED
    print #1.t, "!modified?":input #1.t, modflag$
    if modflag$="true" then
        confirm "This file has been modified.  Save?";answer$
        if answer$="yes" then gosub [savesub]
    end if
    RETURN


[resize]'** LOCATE TEXT EDITOR
    '** LOCATE TEXTEDITOR 20 PIXELS FROM TOP OF CLIENT AREA
    print #1.t, "!locate 0 20 ";WindowWidth-1;" ";WindowHeight-21
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    '** UPDATE WINDOW
    print #1, "refresh"
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    wait


[new]'** CLEAR EDITOR CONTENTS, RESET VARIABLES
    'changed extension to lba
    gosub [isModified]
    print #1.t, "!cls"
    file$="untitled.lba"
    filePath$=""
    gosub [settext]
    wait



[open]
    gosub [isModified]
    filedialog "Open file..",filePath$+"*.bas;*.lba",file$ 
    if file$="" then wait
    gosub [recent.files]

[loadFile]'** OPEN FILE AND LOAD INTO TEXTEDITOR
    shortFile$=SeparateFile$(file$)
    filePath$=SeparatePath$(file$)

    if FileExist(filePath$,shortFile$)<1 then
        notice "Error"+chr$(13)+"File does not exist."
        wait
    end if

    cursor hourglass
    open file$ for input as #file
    print #1.t, "!contents #file"
    close #file
    gosub [settext]
    print #1.t, "!origin 1 1";
    cursor normal
    wait



[settext]'** ADD FILENAME TO TITLEBAR
    title$="Open Source LB Editor "+file$
    calldll #user, "SetWindowTextA", h as long, title$ as ptr, result as void
    return



[saveas]'** SAVES CONTENTS AS file$ - added lba extension
    filedialog "Save file as..",filePath$+"*.bas;*lba",file$ 
      if file$="" then
        notice "You must choose a file name."
        wait
      end if
    gosub [settext]

[save]'** SAVES CURRENT FILE
    gosub [savesub]
    wait


[savesub]
    cursor hourglass
    print #1.t, "!contents?";
    input #1.t, saveit$

    '** IF THERE IS NO CURRENT FILENAME, ASK USER FOR ONE
    if (right$(file$,12)="untitled.lba") or (file$="") then
        filedialog "Save file as...",filePath$+"*.bas;*.lba",file$ 
          if file$="" then
            notice "You must choose a file name."
            RETURN
          end if
    end if

    open file$ for output as #file
    print #file, saveit$
    close #file

    cursor normal
    notice "File saved as "+ file$
    RETURN


[print]
    'save file as a temporary file
    'and cause it to be printed with
    'the  user's default text editor
    cursor hourglass
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar
    print #1.t, "!contents?";
    input #1.t, saveit$ 

    open "tempedit.txt" for output as #tprint
        print #tprint, saveit$
    close #tprint

    printFile$ = "tempedit.txt"+chr$(0)

    open "shell32" for dll as #shell
    calldll #shell, "ShellExecuteA", _
        h as long, _
        "print" as ptr, _
        printFile$ as ptr, _
        "" as ptr, _
        DefaultDir$ as ptr, _
        _SW_HIDE as long, _
        result as long
    close #shell

    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    cursor normal
    wait


[readyRun]'** MAKE A TEMP FILE TO RUN IN LIBERTY BASIC
    '** GET CURRENT TEXTEDIT ORIGIN
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    '** GET CONTENTS OF TEXTEDITOR AND SAVE TO TEMPFILE
    if tempfilename$<>"" then kill tempfilename$
    print #1.t, "!contents?"
    input #1.t, saveit$ 
    tempfilename$=filePath$+"tempfile.bas"
    open tempfilename$ for output as #temp
    print #temp, saveit$
    close #temp

    if libertyexe$="" then gosub [findLiberty]
    RETURN


[findLiberty]'** FIND LIBERTY.EXE
    filedialog "Find Liberty.exe","*.*",libertyexe$ 
    RETURN


[run]
    gosub [readyRun]
    run libertyexe$+" -R -A -M "+tempfilename$ 
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    wait

[debug]
    gosub [readyRun]
    run libertyexe$+" -D -A -M "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    wait

[runtkn]
    filedialog "Choose TKN..","*.TKN",tknfile$
    run tknfile$
    wait

[maketkn]
    gosub [readyRun]
    run libertyexe$+" -T "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    wait



[paint]
    cursor hourglass
    RootPath$="c:\"
    InputPathName$="mspaint.exe" + chr$(0)   'filename only
    OutputPathBuffer$=space$(1023)+chr$(0)

    open "imagehlp" for dll as #ih
    calldll #ih, "SearchTreeForFile",_
        RootPath$ as ptr,_
        InputPathName$ as ptr,_
        OutputPathBuffer$ as ptr,_
        ret as long
        close #ih

    if ret=0 then
        notice InputPathName$;" not found."
    else
        run trim$(OutputPathBuffer$), SHOWNORMAL
    end if
    cursor normal
    wait


[notepad]
    run "notepad.exe", SHOWNORMAL
    wait

[winfile]
    'change to make XP compatible
    run "explorer.exe",SHOWNORMAL
    wait

[calculator]
    run "calc.exe" ,SHOWNORMAL
    wait



[help]
    run "winhlp32 liberty3.hlp"
    wait




[addTooltips]
    TTF.IDISHWND    = 1
    TTF.CENTERTIP   = 2
    TTF.SUBCLASS    = 16
    TTM.ADDTOOL     = 1028
    TTM.DELTOOL     = 1029
    TTS.ALWAYSTIP   = 1
    TTS.NOPREFIX    = 2
    style           = _WS_POPUP or TTS.NOPREFIX _
                      or TTS.ALWAYSTIP

    calldll #cctl, "InitCommonControls", _
        re as void

    calldll #user, "GetWindowLongA", _
        h as long, _GWL_HINSTANCE as long,_
        hInstance as long

    calldll #user, "CreateWindowExA",_
        _WS_EX_TOPMOST as long,_
        "TOOLTIPS_CLASS32" as ptr,_
        "" as ptr, style as long,_
        _CW_USEDEFAULT as long,_CW_USEDEFAULT as long,_
        _CW_USEDEFAULT as long,_CW_USEDEFAULT as long,_
        h as long, 0 as long, hInstance as long,_
        0 as long,hwndTT as long

    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    calldll #user, "SetWindowPos", hwndTT as long,_
        _HWND_TOPMOST as long, _
        0 as long, 0 as long,_
        0 as long, 0 as long,_
        flags as long, r as long


    '** LB3 NOW ONLY REQUIRES A SINGLE STRUCT
    '   FOR ALL TOOLTIPS
    struct toolinfo, cbSize as long, uFlags as long,_
        hwnd as long, uId as long, x as long, y as long,_
        w as long, h as long, _
        hInst as long, lpstrText$ as ptr

    'THESE STRUCT MEMBERS ONLY NEED TO BE FILLED ONCE:
    toolinfo.cbSize.struct = len(toolinfo.struct)
    toolinfo.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo.hwnd.struct = h

    'THESE STRUCT MEMBERS NEED TO BE FILLED ANEW
    'FOR EACH TOOTLIP ADDED:
    toolinfo.uId.struct = hwnd(#1.new)
    toolinfo.lpstrText$.struct = "New File"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long


    toolinfo.uId.struct = hwnd(#1.open)
    toolinfo.lpstrText$.struct = "Open File"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.save)
    toolinfo.lpstrText$.struct = "Save File"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.saveas)
    toolinfo.lpstrText$.struct = "Save File As..."
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.print)
    toolinfo.lpstrText$.struct = "Print File"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.run)
    toolinfo.lpstrText$.struct = "Run Program"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.debug)
    toolinfo.lpstrText$.struct = "Debug Program"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.token)
    toolinfo.lpstrText$.struct = "Tokenize Program"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.runtkn)
    toolinfo.lpstrText$.struct = "Run an existing TKN"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.paint)
    toolinfo.lpstrText$.struct = "Run MS Paint"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.file)
    toolinfo.lpstrText$.struct = "Run Windows Explorer"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.note)
    toolinfo.lpstrText$.struct = "Run Notepad"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.calc)
    toolinfo.lpstrText$.struct = "Run Windows Calculator"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.help)
    toolinfo.lpstrText$.struct = "Liberty BASIC Help"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.about)
    toolinfo.lpstrText$.struct = "About This Program"
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.t)
    toolinfo.lpstrText$.struct = "Right click here for an edit menu."
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.uId.struct = hwnd(#1.quit)
    toolinfo.lpstrText$.struct = "Close Program."
    calldll #user, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    RETURN


[branchlabels]
    '** OPEN DIALOG, FILL LISTBOX WITH BRANCH LABELS
    cursor hourglass
    WindowWidth=420:WindowHeight=440
    button #2.okay,   "OKAY",  [branch],      UL, 320,10,80,26
    button #2.cancel, "CANCEL",[cancelbranch],UL, 320,40,80,26
    combobox #2.branch, branch$(, [branch],10, 10, 300,380
    open "Branch Labels" for dialog_modal as #2

    print #2.branch,  "font Courier_New 0 16"
    print #2.okay,   "!font Courier_New 0 20"
    print #2.cancel, "!font Courier_New 0 20"

    Print #1.t,"!lines";
    Input #1.t, rowcount
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    rowcount=int(rowcount)
    REDIM branch$(rowcount)
    branch$(0)="<start>"

    bx=1
    for i=1 to rowcount
        print #1.t,"!line ";i;"";
        Input #1.t, line$ 
            if left$(trim$(line$),1)="[" then
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
            if lower$(word$(line$,1))="function" then  'improved by Carl Gundel
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
            if lower$(word$(line$,1))="sub" then  'improved by Carl Gundel
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
    next i

    SORT branch$(,0,bx

    Print #2.branch,"reload"
    print #2.branch, "selectindex 1";
    cursor normal
    print #2.branch, "setfocus"

    '** cause combobox to display in open drop position:
    hBranch=hwnd(#2.branch)
    calldll #user, "SendMessageA",_
        hBranch as long,_   'handle of combobox
        _CB_SHOWDROPDOWN as long, _
        1 as long,_         'repaint flag=yes
        0 as long,_         'always 0
        re as long

    wait


[cancelbranch]
    '** CANCEL, RETURN TO EDITOR
    close #2
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    print #1.t, "!setfocus";
    wait


[branch]
    '** CHOOSE BRANCH, SET EDITOR TO THAT POSITION
    cursor hourglass
    print #2.branch,"selection?"
    Input #2.branch,branchselect$ 

    if branchselect$="<start>" then
        print #1.t, "!origin 1 1";
        print #1.t, "!setfocus";
        cursor normal
        close #2
        wait
    end if

    branchlength=len(branchselect$)

    For i = 1 TO rowcount
       print #1.t,"!line ";i;
       Input #1.t,line$
          If trim$(line$)= branchselect$ Then
            Print #1.t, "!origin ";i;" ,0";
            i=rowcount
            close #2
            print #1.t, "!setfocus";
            cursor normal
            wait
          END If
    Next i
    cursor normal
    wait




[bmp] '** BITMAP PREVIEWER
    WindowWidth=640:WindowHeight=480
    UpperLeftX=int((DisplayWidth=WindowWidth)/2)
    UpperLeftY=int((DisplayHeight=WindowHeight)/2)

    button #bit.open, "Open",   [openbmp],  UL,330,5,80,26
    button #bit.save, "Save As",[savebmp],  UL,330,35,80,26
    button #bit.exit, "Exit",   [closebit], UL,330,65,80,26

    button #bit.draw, "Choose Pen Color",[colorChoice],UL,425,5,160,26
    graphicbox #bit.color, 425,35,160,26
    statictext #bit.ins, "Click and drag to draw on bitmap.",415,70,260,20

    TextboxColor$="blue"
    textbox #bit.t1, 20,35,300,26
    TextboxColor$="pink"
    textbox #bit.t2, 20,65,300,26
    graphicbox #bit.box1, 20,100,600,340
    statictext #bit.s, "Bitmap File:",20,5,150,20
    open "Bitmap Preview" for dialog_modal as #bit
    print #bit, "trapclose [closebit]"

    print #bit,  "font Times_New_Roman 0 16"
    print #bit.box1, "down"
    print #bit.box1, "size 2; color ";drawcolor$
    print #bit.box1, "setfocus; when leftButtonMove [drawit]"
    print #bit.box1, "when leftButtonDown [drawit]"
    print #bit.color, "down; fill ";drawcolor$
    print #bit.color, "flush"

    wait

[closebit]
    print #bit.box1, "cls"
    close #bit
    if bmploaded=1 then unloadbmp "tempPicture"
    bmploaded=0
    wait

[drawit]
    if bmploaded=0 then
        notice "You must choose a bitmap first."
        wait
    end if

    if MouseX>bmpwidth or MouseY>bmpheight then wait

    print #bit.box1, "set ";MouseX;" ";MouseY
    wait



[savebmp]
    if picFile$="" then
        notice "It is not possible to SAVE.  No Bitmap has been chosen."
        wait
    end if

    print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    print #bit.box1, "flush"

    filedialog "Save As..","*.bmp",savebmpfile$ 
    if savebmpfile$="" then wait

    BMPSAVE "tempPicture", savebmpfile$ 

    cursor normal
    notice "Bitmap saved as "+savebmpfile$ 
    wait


[openbmp]
    filedialog "Open Bitmap","*.bmp", picFile$
    if picFile$ = "" then wait

    print #bit.t1, lower$(picFile$)

    if bmploaded=1 then unloadbmp "tempPicture"
    loadbmp "tempPicture", picFile$
    bmploaded=1

    hPic=hbmp("tempPicture")
    bmpheight=BitmapHeight(hPic)
    bmpwidth=BitmapWidth(hPic)

    print #bit.t2, "Width:  ";bmpwidth;"    Height:  ";bmpheight;""

    print #bit.box1, "cls"
    print #bit.box1, "drawbmp tempPicture 0 0"
    print #bit.box1, "flush"
    wait

[colorChoice]
    print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    colordialog drawcolor$,drawcolor$
    print #bit.box1, "color "+drawcolor$
    print #bit.color, "cls"
    print #bit.color, "fill ";drawcolor$
    print #bit.color, "flush"
    wait

[about]
    message$="About this editor..."+chr$(13)+_
        chr$(169)+"The Liberty BASIC Community"
    notice message$
    wait

[wav]
    if wavPath$="" then wavPath$=DefaultDir$
    filedialog "Open WAV file",wavPath$+"\*.WAV",wavFile$
    if wavFile$="" then
        playwave ""
        wait
    end if

    slash=len(wavFile$)
        while instr(wavFile$, "\", slash)=0
            slash=slash-1
        wend
    wavPath$=left$(wavFile$,slash)
    playwave wavFile$,async
    goto [wav]



[write.ini.file]
    open DefaultDir$ + "\editor.ini" for output as #inifile
        print #inifile, setFont$ 
        print #inifile, recentfile$(1)
        print #inifile, recentfile$(2)
        print #inifile, recentfile$(3)
    close #inifile
    RETURN



[read.ini.file]
    open DefaultDir$ + "\editor.ini" for append as #inifile
        if lof(#inifile) <> 0 then
            close #inifile
            open DefaultDir$ + "\editor.ini" for input as #inifile
            line input #inifile, setFont$ 

           if not(eof(#inifile)) then
                line input #inifile, rfile$
                recentfile$(1)=rfile$
            end if

            if not(eof(#inifile)) then
                line input #inifile, rfile$
                recentfile$(2)=rfile$
            end if

            if not(eof(#inifile)) then
                line input #inifile, rfile$
                recentfile$(3)=rfile$
            end if
        end if
    close #inifile

    if setFont$="" then setFont$="Fixedsys 8 15"
    print #1.t, "!font ";setFont$  'set font in texteditor
    gosub [ResetMenu]
    RETURN


[ResetMenu]    'make sure filenames are shown in recent menu
    flags=_MF_STRING OR _MF_BYPOSITION

    for i = 0 to 2 'do for each of three recent files in menu

        menuString$=recentfile$(i+1)   'new caption from array = full path/filename

        calldll #user, "GetMenuItemID",_
            hmenuRecent as long,_     'handle of recent menu
            i as long,_               '0-based position of item
            menuID as long            'ID of item

        calldll #user, "ModifyMenuA",_
            hmenuRecent as long,_       'handle of recent menu
            i as long,_                 '0-based position of item
            flags as long,_             'instructions for call
            menuID as long,_            'ID of item to change
            menuString$ as ptr,_        'new caption
            result as long

    next i

    calldll #user, "DrawMenuBar",_        'redraw menu bar
        hWin as long, result as void

    RETURN


[numbertools]
    popupMenu "&Decimal to Hex Converter",[dectohex],_
        "&Hex to Decimal Converter",[hextodec]
    wait

[dectohex]
    prompt "Enter a number...";decnum$
    decnum=val(decnum$)
    notice dechex$(decnum)
    wait

[hextodec]
    prompt "Enter a hex number...";hexnum$
    notice hexdec(hexnum$)
    wait

[timetools]
    popupMenu "Current &Time",[timenow],_
        "Today's &Date",[datenow]
    wait

[timenow]
    timemsg$="Current time is:  "+chr$(13)+_
    time$()+chr$(13)+chr$(13)+_
    "Seconds since midnight:  "+str$(time$("seconds"))+chr$(13)+_
    "Milliseconds since midnight:  "+str$(time$("milliseconds"))
    notice timemsg$
    wait

[datenow]
    datemsg$="Date is" +chr$(13)+_
    date$() +chr$(13)+_
    date$("mm/dd/yyyy") +chr$(13)+_
    date$("mm/dd/yy") +chr$(13)+_
    date$("yyyy/mm/dd") +chr$(13)+_
    "Days since Jan 1, 1900:  "; date$("days")
    notice datemsg$
    wait



[fontdialog]
    fontdialog setFont$,setFont$
    print #1.t, "!font ";setFont$
    gosub [write.ini.file]
    wait


[makebmpbutton]
    WindowWidth=btnwide+40:WindowHeight=btnhigh+60
    graphicbox #b.g, 0,0,200,100
    open "BmpButton" for window_nf as #b
    print #b, "trapclose [closeb]"

    print #b.g, "font arial 0 12 bold"
    print #b.g, "down;color red ; place 5 10"
    print #b.g, "fill buttonface;backcolor buttonface"
    print #b.g, "|Quit"
    print #b.g, "color 230 230 230"
    print #b.g, "line 0 0 29 0;line 0 0 0 14"
    print #b.g, "color darkgray"
    print #b.g, "line 28 1 28 14;line 1 13 28 13"
    print #b.g, "color 45 45 45"
    print #b.g, "line 29 1 29 15;line 1 14 29 14"
    print #b.g, "getbmp quitbutton 0 0 30 15"
    BMPSAVE "quitbutton","qbutton.bmp"
[closeb]
    WindowWidth=600:WindowHeight=480
    close #b:return

[libertyhome]
    CALL RunThis "http://www.libertybasic.com/" ,h
    wait


[emailcarl]
    CALL RunThis "mailto:carlg@libertybasic.com?Subject=Liberty BASIC" ,h
    wait


[edithelp]
    if helpopen = 1 then
        notice "Help window is already open!"
        wait
    end if

    helpopen = 1
    WindowWidth=400:WindowHeight=300
    open "Help" for text as #help
    print #help, "Use this editor to write, edit and run"
    print #help, "Liberty BASIC source code."
    print #help, "Be sure to try out the many"
    print #help, "programming tools provided."
    print #help, "This program is in the public domain."
    print #help, "Feel free to use and modify."
    print #help, "!origin 1 1";
    print #help, "!trapclose [quit.edithelp]";

    input a$ 

    [quit.edithelp]
    close #help
    helpopen = 0
    wait

'** NEW for open32_04.bas
[runtimeIcon]
    filedialog "Choose Icon","*.ico",icoFile$
    if icoFile$="" then wait

    shortFile$=SeparateFile$(icoFile$)
    filePath$=SeparatePath$(icoFile$)
    files filePath$,shortFile$, info$()

    if info$(1,1) <> "766" then
        notice "Not a 16-color icon!"
        wait
    end if

    filedialog "Choose runtime engine","*.exe",runexe$
    if runexe$="" then wait

    open icoFile$ for input as #iconfile
    saveicon$=input$(#iconfile, lof(#iconfile))
    close #iconfile

    open runexe$ for binary as #bin
    seek #bin, 21664
    print #bin, right$(saveicon$,744)
    close #bin
    notice "Icon has been included in ";runexe$
    wait

'*************** FUNCTION LIBRARY **********************
Function BitmapWidth(hBmp)
    struct BITMAP,_ '14 bytes
    bmType as long,_
    bmWidth As long,_
    bmHeight As long,_
    bmWidthBytes As long,_
    bmPlanes as long,_
    bmBitsPixel as long,_
    bmBits as Long

    open "gdi32" for dll as #g
    calldll #g, "GetObjectA", hBmp as long,_
       14 as long,BITMAP as struct,_
       results as long
    close #g

    BitmapWidth=BITMAP.bmWidth.struct
End Function

Function BitmapHeight(hBmp)
    struct BITMAP,_ '14 bytes
    bmType as long,_
    bmWidth As long,_
    bmHeight As long,_
    bmWidthBytes As long,_
    bmPlanes as long,_
    bmBitsPixel as long,_
    bmBits as Long

    open "gdi32" for dll as #g
    calldll #g, "GetObjectA", hBmp as long,_
       14 as long,BITMAP as struct,_
       results as long
    close #g

    BitmapHeight=BITMAP.bmHeight.struct
End Function



function SeparateFile$(f$)
    fileindex=len(f$)
    filelength=len(f$)
      while mid$(f$, fileindex,1)<>"\"
        fileindex=fileindex-1
      wend
    SeparateFile$=right$(f$,filelength-fileindex)
end function


function SeparatePath$(f$)
    fileindex=len(f$)
    filelength=len(f$)
      while mid$(f$, fileindex,1)<>"\"
        fileindex=fileindex-1
      wend
    SeparatePath$=left$(f$,fileindex)
end function


function FileExist(fPath$,fFile$)
    files fPath$,fFile$,info$(
    FileExist=val(info$(0,0))
end function


sub RunThis RunFile$, hWindow
    RunFile$=RunFile$+chr$(0)
    lpOperation$ = "open" + chr$(0)
    lpParameters$ = "" + chr$(0)
    lpDirectory$ = "" + chr$(0)
    nShowCmd = _SW_SHOWNORMAL

    open "shell32" for dll as #shell
    calldll #shell, "ShellExecuteA", _
        hWindow as long, _          'parent window
        lpOperation$ as ptr, _      'open or print
        RunFile$ as ptr, _          'file name
        lpParameters$ as ptr, _     'null
        lpDirectory$ as ptr, _      'default directory
        nShowCmd as long, _        'show window flag
        result as long
    close #shell
    if result <= 32 then notice "Error, Address Failure!"
end sub


[remove.menu]
    CallDll #user, "GetMenu",_
        h as long,_     'window handle
        hMenu1 as long  'returns handle of menu bar

    CallDll #user, "GetSubMenu",_
        hMenu1 As long,_    'handle of menu bar
        0 As long,_         'position of sub menu desired 0 - first
        hmenuFile As long   'handle of sub menu for File menu

    CallDll #user, "GetSubMenu",_
        hMenu1 As long,_    'handle of menu bar
        1 As long,_         'position of recent menu 1 = second
        hmenuRecent As long 'returns handle of recent menu

    menuflags = _MF_BYPOSITION Or _MF_POPUP Or _MF_STRING
    CallDll #user, "ModifyMenuA",_
        hmenuFile As long, _    'handle of menu to modify
        7 As long,_             'position of item to change (8th item)
        menuflags As long, _    'flags for type of change
        hmenuRecent As long,_   'menu to add as a popup
        "&Recent" As ptr, _     'name of menu item
        result As long

    CallDll #user, "RemoveMenu",_   'remove recent menu from view
        hMenu1 As long, _           'handle of menu bar
        1 As long,_                 '1 = position of menu to remove
        _MF_BYPOSITION As long, _   'flag for remove by position
        result As long

    CallDll #user, "DrawMenuBar",_  'must redraw bar after change
        h As long,_                 'window handle
        result As void
       RETURN


[recent.files]
    recentfile$(3)=recentfile$(2)
    recentfile$(2)=recentfile$(1)
    recentfile$(1)=LOWER$(file$)
    gosub [ResetMenu]
    RETURN


[File_1]
    if recentfile$(1)="" then wait
    file$=recentfile$(1)
    GoTo [loadFile]

[File_2]
    if recentfile$(2)="" then wait
    file$=recentfile$(2)
    GoTo [loadFile]

[File_3]
    if recentfile$(3)="" then wait
    file$=recentfile$(3)
    GoTo [loadFile]


[makeArrays]
    DIM myarray$(1000)
    left=int((DisplayWidth-280)/2):top=int((DisplayHeight-215)/2)
    WindowWidth = 280
    WindowHeight = 215
    bString = 0
    bNumeric = 1
    i = 0
    statictext #am.static1, "Array Name:", 6, 11, 88, 20
    statictext #am.static2, "Item to Add:", 6, 67, 96, 20
    groupbox #am.groupbox3, "Type", 150, 11, 110, 70
    radiobutton #am.string, "String$",[stringSet],[loop],182,31,72,20
    radiobutton #am.numeric, "Numeric",[numericSet],[loop],182,56,72,20
    button #am.default, "Add Item", [ArrayAdd], UL, 150, 86, 112, 25
    TEXTEDITOR #am.text, 0, 0, 0, 0
    button #am.file, "File", [ArrayFile], UL, 150, 119, 112, 25
    button #am.create, "Create and Exit",[create],UL,150,151,112, 25
    button #am.cancel, "Cancel", [ArrayCancel], UL, 14, 151, 112, 25

'** New, separate colors for each textbox:
    TextboxColor$="cyan"
    textbox #am.arrayName, 6, 31, 136, 25
    TextboxColor$="yellow"
    textbox #am.arrayItem, 6, 86, 136, 25
    open "Array Maker" for dialog_nf_modal as #am
    print #am, "font ms_sans_serif 0 8"
    print #am.numeric, "set" 'flag bNumeric = 1
    wait


[ArrayAdd]   'Perform action for the button named 'add'
    print #am.arrayItem, "!contents?";
    input #am.arrayItem, arrayItem$

    myarray$(i)= arrayItem$ 
    i = i + 1
    print #am.arrayItem, "";
    print #am.arrayItem, "!setfocus";
    wait

[ArrayFile]
   i = 0
   filedialog "Open file", "*.*", ArrayFileName$
   if ArrayFileName$ = "" then
     notice "You must input a valid file name!"
     wait
   end if
   print #am.arrayName, "!contents?";
    input #am.arrayName, arrayName$ 
    if bString = 1 and right$(arrayName$, 1) <> "$" then
       arrayName$ = arrayName$ + "$"
    end if
   OPEN ArrayFileName$ for input as #arrayFile
     while eof(#arrayFile) = 0
       line input #arrayFile, ArrayLine$
       myarray$(i)= ArrayLine$ 
       i = i + 1
     wend
     close #arrayFile


[create]
    print #am.arrayName, "!contents?"
    input #am.arrayName, arrayName$ 

    if arrayName$="" then arrayName$="MyArray"
    if bString=1 and right$(arrayName$,1)<>"$" then
        arrayName$=arrayName$+"$"
    end if

    print #am.text, "!cls";
    print #am.text, "Dim ";arrayName$;"(";i;")"
    For a = 0 to i-1
    if right$(arrayName$, 1) = "$" then
      Print #am.text, arrayName$;"(";a;") = ";chr$(34);myarray$(a);chr$(34)
    else
      Print #am.text, arrayName$;"(";a;") = ";myarray$(a)
    end if
    Next a

    Print #am.text, "!selectall";
    Print #am.text, "!copy";
    Print #am.text, "!cls";
    notice "Array is copied into clipboard. Paste into your application."
[ArrayCancel]
    close #am
    wait

[stringSet]
    bString = 1
    bNumeric = 0
    wait

[numericSet]
    bNumeric = 1
    bString = 0
    wait



