'***********************************************
'
'Atan2.bas by Nally + April 2000
'Released as open source
'
'A function called ATAN2() is provided herein.
'ATAN2() takes two arguements: cartesian x and y
'coordinates.  It returns an angle, phi, in
'radians.
'
'ATAN2() differs from ATN() in this regard:
'while ATN() only returns an angle between
'-pi/2 and +pi/2, ATAN2() will return any
'angle in the full circle.
'
'The user should not call the function if both
'x and y = 0.  This corresponds to a point at
'the origin of the coordinate system where
'the angle phi has no meaning.
'
'***********************************************


pi = 3.14159265


Print " "
Print "Note: Input real numbers for"
Print "      x and y.  Either x or y"
Print "      or both must be non-zero."
Print " "
Print "** INPUT  **"
Print " "

Input "x = "; x
Input "y = "; y

Print " "
Print "** OUTPUT **"
Print " "

phiRads = ATAN2(x, y)
phiDegs = 360 * (phiRads / (2 * pi))
R = (x^2 + y^2)^(1/2)
Print "Cartesion Coordinates of Q....Q("; x; ", "; y; ")"
Print " "
print "ATAN2 in radians.............."; phiRads
print "ATAN2 in degrees.............."; phiDegs
print "Distance to Q................."; R
print " "
print "Polar Coordinates of Q........Q("; phiRads; ", "; R;")"




end

function ATAN2(x, y)
    pi = 3.14159265
    Result$ = "Undetermined"
    If (x = 0) and (y > 0) then
        ATAN2 = pi / 2
        Result$ = "Determined"
    end if
    if (x = 0) and (y < 0) then
        ATAN2 = 3 * pi / 2
        Result$ = "Determined"
    end if
    if (x > 0) and (y = 0) then
        ATAN2 = 0
        Result$ = "Determined"
    end if
    if (x < 0) and (y = 0) then
        ATAN2 = pi
        Result$ = "Determined"
    end if

    If Result$ = "Determined" then [End.of.function]


    BaseAngle = ATN(abs(y)/abs(x))
    If (x > 0) and (y > 0) then ATAN2 = BaseAngle
    If (x < 0) and (y > 0) then ATAN2 = pi - BaseAngle
    If (x < 0) and (y < 0) then ATAN2 = pi + BaseAngle
    If (x > 0) and (y < 0) then ATAN2 = 2*pi - BaseAngle

    [End.of.function]

End Function
