'ListView Report Example
'by Brent D. Thorn, 7/2002

NoMainWin

Call InitCommonControls

Open "ListView Report Example" For Window As #1
#1 "TrapClose [Quit]"

dwStyle = _WS_CHILD + _WS_VISIBLE + _
      1 + 4 + 8 + 32768 'LVS_REPORT + LVS_SINGLESEL + LVS_SHOWSELALWAYS + LVS_NOSORTHEADER
hLV = CreateListView(_WS_EX_CLIENTEDGE, dwStyle, 0, 0, 175, 150, hWnd(#1), 0)

Call InsertColumn hLV, 0, "English", 75
Call InsertColumn hLV, 1, "Espaol", 75

Restore [Data]
Read E$, S$: I = 0
While E$ <> "EOD"
    Call InsertItem hLV, I, E$
    Call SetItem hLV, I, 1, S$
    Read E$, S$: I = I + 1
Wend

Wait

[Quit]
Close #1
End

[Data]
Data "One", "Uno", "Two", "Dos", "Three", "Tres", "Four", "Cuatro", "Five", "Cinco"
Data "Six", "Seis", "Seven", "Siete", "Eight", "Ocho", "Nine", "Nueve", "Ten", "Diez"
Data "EOD", "EOD"

Sub InitCommonControls
    struct LVCOLUMN, _
        mask As ulong, _
        fmt As long, _
        cx As long, _
        pszText As ptr, _
        cchTextMax As long, _
        iSubItem As long, _
        iImage As long, _
        iOrder As long
    struct LVITEM, _
        mask As ulong, _
        iItem As long, _
        iSubItem As long, _
        state As ulong, _
        stateMask As ulong, _
        pszText As ptr, _
        cchTextMax As long, _
        iImage As long, _
        lParam As long, _
        iIndent As long
End Sub

Function CreateListView( dwExStyle, dwStyle, x, y, nWidth, nHeight, hWndParent, nID )
    CallDLL #user32, "GetWindowLongA", _
        hWndParent As long, _
        _GWL_HINSTANCE As long, _
        hInst As long
    CallDLL #user32, "CreateWindowExA", _
        dwExStyle As long, _
        "SysListView32" As ptr, _
        0 As long, _
        dwStyle As long, _
        x As long, _
        y As long, _
        nWidth As long, _
        nHeight As long, _
        hWndParent As long, _
        nID As long, _
        hInst As long, _
        0 As long, _
        CreateListView As long
End Function

Sub InsertColumn hLV, iCol, Text$, cx
    LVCOLUMN.mask.struct = 2 + 4 'LVCF_WIDTH + LVCF_TEXT
    LVCOLUMN.cx.struct = cx
    LVCOLUMN.pszText.struct = Text$
    CallDLL #user32, "SendMessageA", _
        hLV As long, _
        4123 As long, _ 'LVM_INSERTCOLUMN
        iCol As long, _
        LVCOLUMN As struct, _
        r As long
End Sub

Sub InsertItem hLV, iItem, Text$
    LVITEM.mask.struct = 1 'LVIF_TEXT
    LVITEM.iItem.struct = iItem
    LVITEM.iSubItem.struct = 0
    LVITEM.pszText.struct = Text$
    CallDLL #user32, "SendMessageA", _
        hLV As long, _
        4103 As long, _ 'LVM_INSERTITEM
        0 As long, _
        LVITEM As struct, _
        r As long
End Sub

Sub SetItem hLV, iItem, iSubItem, Text$
    LVITEM.mask.struct = 1 'LVIF_TEXT
    LVITEM.iItem.struct = iItem
    LVITEM.iSubItem.struct = iSubItem
    LVITEM.pszText.struct = Text$
    CallDLL #user32, "SendMessageA", _
        hLV As long, _
        4102 As long, _ 'LVM_SETITEM
        0 As long, _
        LVITEM As struct, _
        r As long
End Sub
 