
DTS.UPDOWN = 1          'shows updown arrows, no calendar
DTS.RIGHTALIGN = 32     'aligns calendar with right side of control
DTS.SHORTDATEFORMAT = 0 'default short date format:  9/22/02
DTS.LONGDATEFORMAT = 4  'long date format: Sunday, September 22, 2002
DTS.SHORTDATECENTURYFORMAT = 12 '                  9/22/2002
DTS.APPCANPARSE = 16    'double-clicking highlights entire date
                        'default-click highlights only one part of date

DTM.GETSYSTEMTIME = 4097'message flag to retrieve date/time chosen
DTM.FIRST = 4096        'first date/time message reserved number
DTM.SETMCCOLOR=4102     'message flag to set calendar background color
DTM.SETMCCOLOR=DTM.FIRST+6  'numbers are often expressed this way
DTM.SETSYSTEMTIME = 4098'message flag to set date/time displayed on control

MCSC.BACKGROUND = 0     'Set the background color displayed between months.
MCSC.TEXT = 1           'Set the color used to display Text within a month.
MCSC.TITLEBK = 2        'Set the background color displayed in the calendar's title.
MCSC.TITLETEXT = 3      'Set the color used to display Text within the calendar's title.
MCSC.MONTHBK=4          'Set the background color displayed within the month.
MCSC.TRAILINGTEXT = 5   'Set the color used to display header day and trailing day text.
                        'Header and trailing days are the days from the previous and
                        'following months that appear on the current month calendar.

    Struct SYSTEMTIME, _'struct to hold date time info to interact with control
        wYear As word, _
        wMonth As word, _
        wDayOfWeek As word, _ '0 = Sunday, 1 = Monday, etc.
        wDay As word, _
        wHour As word, _
        wMinute As word, _
        wSecond As word, _
        wMilliseconds As word



NoMainWin
    struct icex, _
    dwSize As ulong, _
    dwICC As ulong

    icex.dwSize.struct = Len(icex.struct)
    icex.dwICC.struct = Hexdec("100") 'ICC_DATE_CLASSES

    CallDLL #comctl32, "InitCommonControlsEx", _
    icex As struct, r As long

WindowWidth=160:WindowHeight=120
Button #1.date, "Get Date",[getDate],UL,10,15,66,24
Button #1.month, "Get Month", [getMonth],UL,80,15,66,24
Open "Calendar" For window As #1
    #1 "TrapClose [Quit]"

    h1 = hWnd(#1)
    hInst=InstanceHandle(h1)
    hwndDTP=CreateDateControl(h1,hInst,10,50,140,20)

    'make background of calendar pink, if desired
    'Call SetBGColor hwndDTP, 255 + (160*256) + (160*256*256)

    'set initial date displayed on control (optional), 
    'otherwise it will show today's date
    'r=SetDate(hwndDTP,2003,2,14)

    Wait


[Quit]
    Close #1:End


[getDate]
    t$=GetWindowText$(hwndDTP)  'easiest method
    t$=GetDate$(hwndDTP)        'alternate method
    Notice t$
    Wait

[getMonth]
    t$=GetMonth$(hwndDTP)
    notice "Month is ";t$
    wait

Function InstanceHandle(hW)
    CallDLL #user32, "GetWindowLongA", _
    hW As long, _GWL_HINSTANCE As long, _
    InstanceHandle As long
    End Function

Function CreateDateControl(hW,hInstance,x,y,w,h)
    DTS.SHORTDATECENTURYFORMAT = 12
    style = _WS_VISIBLE Or _WS_CHILD Or DTS.SHORTDATECENTURYFORMAT
    CallDLL #user32, "CreateWindowExA", _
    0 As long,_                     'extended style
    "SysDateTimePick32" As ptr, _   'class
    "DateTime" As ptr, _            'name
    style As long,_                 'window style flags
    x As long, y As long,_          'upper left x,y
    w As long, h As long,_          'width and height
    hW As long,_                    'parent window handle
    0 As long,_                     'menu handle
    hInstance As long,_             'instance handle of parent
    0 As long, _                    'not used here - extra data
    CreateDateControl As long       'handle of created control
    End Function


Function GetWindowText$(hW)
    a=GetWindowTextLength(hW)
    Title$=Space$(a)+Chr$(0)
    l=Len(Title$)
    CallDLL #user32, "GetWindowTextA", hW As long,_
    Title$ As ptr, l As long, result As long
    GetWindowText$=Trim$(Title$)
    End Function

Function GetWindowTextLength(hW)
    CallDLL #user32, "GetWindowTextLengthA",_
    hW As long, GetWindowTextLength As long
    End Function

Sub SetBGColor hW, col
    DTM.SETMCCOLOR=4102 'message flag to set calendar color
    MCSC.MONTHBK=4      'color to change=month background

    CallDLL #user32, "SendMessageA",_
    hW As long, _               'handle of control
    DTM.SETMCCOLOR As long,_    'set color message
    MCSC.MONTHBK As long,_      'part of control to set color on
    col As long,_               'color desired
    re As long
    End Sub

Function GetDate$(hW)
    DTM.GETSYSTEMTIME = 4097
    CallDLL #user32, "SendMessageA", _
        hW As long, _               'handle of control
        DTM.GETSYSTEMTIME As long,_ 'flag to get chosen date/time
        0 As long, _                'wparam=0
        SYSTEMTIME As struct,_      'name of struct
        ret As long
        GetDate$=SYSTEMTIME.wMonth.struct;"/";_
        SYSTEMTIME.wDay.struct;"/";_
        SYSTEMTIME.wYear.struct
    End Function


Function GetMonth$(hW)
    DTM.GETSYSTEMTIME = 4097
    CallDLL #user32, "SendMessageA", _
        hW As long, _               'handle of control
        DTM.GETSYSTEMTIME As long,_ 'flag to get chosen date/time
        0 As long, _                'wparam=0
        SYSTEMTIME As struct,_      'name of struct
        ret As long
        mon=SYSTEMTIME.wMonth.struct
        m$="JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC"
        GetMonth$=word$(m$,mon)
    End Function


Function SetDate(hW,year,month,day)
    DTM.SETSYSTEMTIME = 4098
    SYSTEMTIME.wMonth.struct=month
    SYSTEMTIME.wDay.struct=day
    SYSTEMTIME.wYear.struct=year

    CallDLL #user32, "SendMessageA", _
        hW As long, _               'handle of control
        DTM.SETSYSTEMTIME As long,_ 'flag to set chosen date/time
        0 As long, _                'wparam=0
        SYSTEMTIME As struct,_      'name of struct
        SetDate As long
    End Function


