'*************************************************
' Code for a custom control. (Liberty BASIC v3)  *
' A call to the function reTextBox() will        *
' create an input text box which can have        *
' any colour of text and background. The         *
' parameters of the function allows the size     *
' and position of the box to be set. Also        *
' parameters are used to set the text colour     *
' and background colour.The last parameter       *
' sets the maximum number of chars that can      *
' be entered. The function returns a handle      *
' so that you can interact with the text box,    *
' i.e. give it focus.                            *
' The example shown is sized and given a maximum *
' length so that it acts as a single line        *
' input box.                                     *
'*************************************************
' In the main prog only one function is called   *
' for each "reTextBox", this then calls all the  *
' necessary other functions.                     *
'*************************************************
' rmf (04.05.2002)                               *
'*************************************************

inkCol$(0)="&HA52A2A" ' brown
inkCol$(1)="&HFF1493" ' deeppink
inkCol$(2)="&H00008B" ' dark blue
inkCol$(3)="&HFF6347" ' tomato
inkCol$(4)="&HBDB76B" ' darkkhaki
inkCol$(5)="&HFF00FF" ' magenta
inkCol$(6)="&H1E90FF" ' dodgerblue
inkCol$(7)="&HFFA500" ' orange
inkCol$(8)="&H999999" ' grey
inkCol$(9)="&H008000" ' opening color
inkIndex=0

paperCol$(0)="&H00FFFF" ' aqua
paperCol$(1)="&HFFF8DC" ' cornsilk
paperCol$(2)="&H00BFFF" ' deepskyblue
paperCol$(3)="&HFFB6C1" ' lightpink
paperCol$(4)="&HDDA0DD" ' plum
paperCol$(5)="&HF0E68C" ' khaki
paperCol$(6)="&HC0C0CO" ' silver
paperCol$(7)="&HD8BFD8" ' thistle
paperCol$(8)="&HF0F8FF" ' aliceblue
paperCol$(9)="&HCCFFCC" ' opening color
paperIndex=0

nomainwin

'Size window and place in center
dw = DisplayWidth
dh = DisplayHeight
WindowWidth  = 320
WindowHeight = 160
UpperLeftX=(dw-WindowWidth)/2
UpperLeftY=(dh-WindowHeight)/2
'************************************************
'************************************************
'Note 8
'******
'This structure required for setting text colour
struct cf, _
  cbSize          as word, _
  wPad1           as word, _
  dwMask          as ulong, _
  dwEffects       as ulong, _
  yHeight         as long, _
  yOffset         as long, _
  crTextColor     as long, _
  bCharSet        as char[1],_
  bPitchAndFamily as char[1],_
  szFaceName      as char[32], _
  wPad2           as word
cf.cbSize.struct = len(cf.struct)
'***************************************************
'***************************************************
'Place controls
textbox    #w.tbink,                                    20,  15,  50, 25
textbox    #w.tbpaper,                                 243,  15,  50, 25
button     #w.btink,   "Font Color",  [setInkA],   UL,  10,  60,  70, 20
button     #w.btpaper, "Bkgnd Color", [setPaperA], UL, 235,  60,  70, 20
button     #w.btlabel, "Get Text",    [getText],   UL,  10, 100,  70, 20
button     #w.btexit,  "Exit",        [exit],      UL, 235, 100,  70, 20
statictext #w.st1,     "",                             110,  60, 120, 20
'Open window
open "Rich Edit Input Box for Liberty BASIC v3" for window as #w
#w "trapclose [exit]"

open "user32.dll"   for dll as #user32
open "kernel32.dll" for dll as #kernel32
'**********************************************
'**********************************************
'Note 1
'******
'Required for a rich edit control
'Winclass$ will be used as a parameter
'in each call to create a rich edit control.
calldll #kernel32,"LoadLibraryA", _
    "RICHED20.DLL" as ptr, _
    hRTFLIB        as long
  Winclass$ = "RICHEDIT20A"
if Not(hRTFLIB) then
   calldll #kernel32,"LoadLibraryA", _
       "RICHED32.DLL" as ptr, _
       hRTFLIB        as long
  Winclass$ = "RICHEDIT"
end if
'***********************************************
'************************************************
'Handle of parent window
h = hwnd(#w)
h.tbink = hwnd(#w.tbink)

'Call to create a new instance of the reTextBox,
'with coloured ink and paper and max # chars.
'This function returns a handle which can be used
'later as in reSetText() and setFocus().
hEdit = reTextBox(h, Winclass$, 107, 15, 107, 23, "&H008000", "&HCCFFCC", 10)

'Replace all text in reTextBox with text$
text$ = "Hello!"
ret=reSetText(hEdit, text$)

'Set focus on TextBox
h.tbink = hwnd(#w.tbink)
ret=setFocus(hEdit)
'****************************
'remove prompt text on first key press
calldll #user32, "SendMessageA", _
    hEdit         as ushort, _
    _EM_SETSEL    as ushort, _
    0             as ushort, _ 'first char will be start of selected text
    -1            as ulong, _  'all chars will be selected
    result        as ulong
'****************************
[loop]
wait

[exit]
close #user32
close #kernel32
close #w
end

[getText]
string$ = reGetText$(hEdit)
#w.st1, string$
goto [loop]

[setInkA]
#w.tbink "!contents?"
input #w.tbink, string$
if string$ = "" then goto [setInkB]
string$ = "&H" + string$
ret=reSetTextColor(hEdit,string$)
goto [loop]

[setInkB]
if inkIndex>9 then inkIndex=0
ret=reSetTextColor(hEdit,inkCol$(inkIndex))
inkIndex=inkIndex+1
goto [loop]

[setPaperA]
#w.tbpaper "!contents?"
input #w.tbpaper, string$
if string$ = "" then goto [setPaperB]
string$ = "&H" + string$
ret=reSetBkgndColor(hEdit,string$)
goto [loop]

[setPaperB]
if paperIndex>9 then paperIndex=0
ret=reSetBkgndColor(hEdit,paperCol$(paperIndex))
paperIndex=paperIndex+1
goto [loop]
'***********************************************
'************************************************
'Functions
'************************************************
'*****************************************************
'Note 9
'******
function reTextBox(handle, class$, x,y,w,h,inkHex$,paperHex$,ln)
  'This is the function that is called
  'from the main program code.
  '    requires:  getInstance()
  '               reOpenTextBox()
  '               reLimitText()
  '               convert()
  '               reBackgroundColor()
  '               reSetTextColor()
  '
  '    parameters:
  '               handle    = handle of parent window
  '               class$    = name of window class to be created, i.e."RICHEDIT"
  '               x         = x co-ord
 '                y         = y co-ord
  '               w         = width
  '               h         = height
  '               inkHex$   = ink colour as HEX value
  '               paperHex$ = paper colour as HEX value
  '               ln        = MAX # of chars

  'Create RichEdit Textbox
  hRichEd = reOpenTextBox(handle, class$, x, y, w, h)

  'Set limit to # of chars that can be
  'entered so that reTextBox can act as
  'a single line TextBox.
  ret = reLimitText(ln, hRichEd)

  'Set foreground colour
  ret = reSetTextColor(hRichEd,inkHex$)

  'Set background colour
  ret = reSetBkgndColor(hRichEd,paperHex$)

  'return handle to new myTextBox
  reTextBox = hRichEd
end function
'*****************************************************
'*****************************************************
'Note 2
'******
function getInstance(handle)
  calldll #user32, "GetWindowLongA",_
      handle         as long,_ 'handle of window that will contain controls
      _GWL_HINSTANCE as long,_ 'flag for word value desired=instance handle
      hInstance      as long   'instance handle of window is returned
    getInstance = hInstance
end function
'*****************************************************
'*****************************************************
'Note 3
'******
function reOpenTextBox(handle, class$, x, y, w, h)
  hInstance = getInstance(h)

  style = _WS_CHILD or _WS_VISIBLE or 16384

  calldll #user32, "CreateWindowExA",_
      _WS_EX_WINDOWEDGE as long,_ 'extended style
      class$            as ptr,_  'class name
      ""                as ptr,_  'title or string
      style             as long,_ 'window style
      x                 as long,_ 'x org
      y                 as long,_ 'y org
      w                 as long,_ 'width
      h                 as long,_ 'height
      handle            as long,_ 'parent window
      0                 as long,_ 'handle to menu = 0 for class menu
      hInstance         as long,_ 'instance handle of parent window
      ""                as ptr,_  'always NULL
      hControl          as long   'returns handle of this control
  reOpenTextBox = hControl
end function
'*****************************************************
'*****************************************************
'Note 4
'*******
function reLimitText(limit, handle)
  '**************************************
  '* This function over-ridden by later  *
  '* call to "SetRichEdText()" if string *
  '* send has more chars than limit set. *
  '***************************************
  'limit  = max chars input
  'handle = handle to object
  wTParam=hexdec("&H0L")    ' sets to null
  calldll #user32,  "SendMessageA", _
      handle        as long, _
      _EM_LIMITTEXT as long, _
      limit         as long, _
      wTParam       as long, _
      result        as long
  reLimitText = result
end function
'*****************************************************
'*****************************************************
'Note 5
'******
function convert$(string$)
  'The API calls require RGB values where the RED part
  'is the least significant part. With HEX colour numbers
  'the RED part is the most significant part, so this
  'convert() function is needed.
  newString$ = LEFT$(string$,2)
  newString$ = newString$ + RIGHT$(string$,2)
  newString$ = newString$ + MID$(string$,5,2)
  newString$ = newString$ + MID$(string$,3,2)
  convert$ = newString$
end function
'*****************************************************
'*****************************************************
'Note 6
'******
function reSetBkgndColor(hEd,paperHex$)
  'set background color for riched
  paperHex$=convert$(paperHex$)
  EM.SETBKGNDCOLOR = _WM_USER + 67
  backcolor=HEXDEC(paperHex$)
  calldll #user32,  "SendMessageA", _
      hEd              as word, _
      EM.SETBKGNDCOLOR as word, _
      0                as word, _
      backcolor        as long, _
      result           as long
  reSetBkgndColor=result
end function
'*****************************************************
'*****************************************************
'Note 7
'******
function reSetTextColor(hEd,inkHex$)
  'make either selected text or all text in riched the inkHex$ color
  'selectflag=4 for all, 1 for highlighted text
  inkHex$=convert$(inkHex$)
  EM.SETCHARFORMAT = _WM_USER + 68
  selectflag = 4
  CFM.COLOR = 1073741824
  cf.dwMask.struct = CFM.COLOR
  cf.dwEffects.struct = 0
  cf.crTextColor.struct = HEXDEC(inkHex$)
  calldll #user32, "SendMessageA", _
      hEd              as long, _
      EM.SETCHARFORMAT as long, _
      selectflag       as long, _
      cf               as struct, _
      result           as long
  reSetTextColor=result
end function
'************************************************
'*****************************************************
'These functions are used to demonstate the use
'of the rich edit control.
function reGetText$(hEd)
  'returns text in riched
  'first, get length of text
  calldll #user32,  "SendMessageA", _
      hEd               as word, _
      _WM_GETTEXTLENGTH as word, _
      0                 as word, _
      0                 as long, _
      TxtLen            as long
  'second, create buffer
  strTxt$ = space$(TxtLen) + chr$(0)
  TxtLen = TxtLen + 10
  'third, retrieve text
  calldll #user32,  "SendMessageA", _
      hEd         as word, _
      _WM_GETTEXT as word, _
      TxtLen      as word, _
      strTxt$     as ptr, _
      ret         as long
  strTxt$ = left$(strTxt$,ret)
  reGetText$ = strTxt$
end function
'*****************************************************
'*****************************************************
function setFocus(handle)
  calldll #user32, "SetFocus", _
      handle as word, _
      result as short
  SetFocus = 0
end function
'*****************************************************
'*****************************************************
function reSetText(hEd, text$)
  'replace all text in riched with text$
  '**************************************
  '* This function will over-ride any previous
  '* call to limitText() if text$ has more chars
  '* than the limit already set. The new limit
  '* will exist until any new call to limitText()
  '* or a new call to SetRichEditText()with a
  '* longer text$ string.
  '***************************************
  calldll #user32,  "SendMessageA", _
      hEd         as word, _
      _WM_SETTEXT as word, _
      0           as word, _
      text$       as ptr, _
      result      as long
  reSetText=result
end function
'*****************************************************
'*****************************************************

