'This code is for LB3, tested with WIN98SE/LB3.02
'Submitted for Newsletter inclusion by Mike Bradbury.
'Programmers sometimes need buttons to have a variety of appearances, depending upon
'the the function of the button.
'LibertyBASIC native code limits the type and style of button available.
'Included here is code to generate six different radiobutton syles plus the
'standard LB style.
'The groupbox style can also be changed (see comment within the code).
'A control of class BUTTON can be given a style of BS_AUTORADIOBUTTON
'and BS_PUSHLIKE for standard button appearance. Omitting the BS_PUSHLIKE
'style gives the standard radiobutton appearance.
'Regular buttons can also be given the same styles, just omit the style
'BS_AUTORADIOBUTTON to draw a standard (non radiobutton) button.


'Check that the user has version 3 of LibertyBASIC, if not then end program execution.
If Val(Left$(Version$,1))<>3 Then
            Notice "Sorry, LB version 3 only."
            End
End If

'Dim arrays for control handles
Dim hC(5)
Dim hr(6)

'set up window and standard LB controls
WindowWidth=450:WindowHeight=500
UpperLeftX=200:UpperLeftY=200

NoMainWin
Button #w.1, "",[rb1],UL,0,0,0,0 'these buttons are hidden and linked to
Button #w.2, "",[rb2],UL,0,0,0,0 'the api generated buttons for event handling
Button #w.3, "",[rb3],UL,0,0,0,0 'Although 25 radiobuttons are drawn, there are
Button #w.4, "",[rb4],UL,0,0,0,0 'only 5 branch labels (rb1 to rb5).Each row of
Button #w.5, "",[rb5],UL,0,0,0,0 'radiobuttons have the same function but different
                                 'styles.

'this sets up that five standard LB radio buttons
Groupbox #w.gb1, "LB Radiobuttons with flat groupbox",42,390,365,50
Radiobutton #w.rb1, "LBRB1",[rb1],UL,55,410,60,20
Radiobutton #w.rb2, "LBRB2",[rb2],UL,125,410,60,20
Radiobutton #w.rb3, "LBRB3",[rb3],UL,195,410,60,20
Radiobutton #w.rb4, "LBRB4",[rb4],UL,265,410,60,20
Radiobutton #w.rb5, "LBRB5",[rb5],UL,335,410,60,20

Open "Radiobutton & Groupbox styles." For Window_nf As #w
#w, "trapclose [quit]"

'get the handle of the window
h=hWnd(#w)

'get handles of hidden LB buttons
hC(1)=hWnd(#w.1)
hC(2)=hWnd(#w.2)
hC(3)=hWnd(#w.3)
hC(4)=hWnd(#w.4)
hC(5)=hWnd(#w.5)

'set font for window and statictext control
#w, "font arial 8"

'create font1 for api generated controls
    fontname$ = "Arial" + Chr$(0)
    fontheight = 14
    CallDLL #gdi32, "CreateFontA",_
         fontheight As long,_
         0 As long,0 As long,0 As long,_
         0 As long,0 As long,0 As long,_
         0 As long,0 As long,0 As long,_
         0 As long,0 As long,0 As long,_
         fontname$ As ptr,_
         hFont1 As long

'create font2  for api generated controls
    fontname$ = "arial" + Chr$(0)
    fontheight = 16
    CallDLL #gdi32, "CreateFontA",_
         fontheight As long,_
         0 As long,0 As long,0 As long,_
         0 As long,0 As long,0 As long,_
         0 As long,0 As long,0 As long,_
         0 As long,0 As long,0 As long,_
         fontname$ As ptr,_
         hFont2 As long

'make raised groupbox with empty string for caption
class$="BUTTON"
'this sets up the style for the groupbox
gboxstyle=_WS_CHILDWINDOW OR _WS_VISIBLE  or _BS_GROUPBOX

'set the size of the groupbox
gboxX=42
gboxY=10
gboxW=365
gboxH=365

'these two sets of calls create the groupbox
    CallDLL #user32, "GetWindowLongA",h As long,_GWL_HINSTANCE As long,hInst As long
    gbStyle=1 'groupbox style 1=raised, 0=flat
    CallDLL #user32, "CreateWindowExA",gbStyle As long,class$ As ptr,_
    "" As ptr, gboxstyle As long,gboxX As long,gboxY As long,gboxW As long,gboxH As long,_
    h As long, 0 As long, hInst As long, 0 As long,hGrb As long

'change font for groupbox control to the font that was created in the api calls above
    CallDLL #user32,  "SendMessageA",_
    hGrb As long,_    'handle
    _WM_SETFONT As word,hFont2 As long,1 As long,result As void

'set captions for groupbox
res=setText(hGrb,"RadioButton styles with raised groupbox")

'make buttons in different styles, omit legends till font has been changed
'Text position on control can be set with style BS_RIGHT/BS_LEFT/BS_CENTER/BS_TOP/BS_BOTTOM
'Radiobuttons 1 to 5
bstyle(1)=_WS_CHILDWINDOW OR _WS_VISIBLE  or _BS_PUSHLIKE or _BS_AUTORADIOBUTTON or _BS_LEFT
'Radiobuttons 6 to 10
bstyle(2)=_WS_CHILDWINDOW OR _WS_VISIBLE  or _BS_PUSHLIKE or _BS_AUTORADIOBUTTON or _BS_FLAT
'Radiobuttons 11 to 15
bstyle(3)=_WS_CHILDWINDOW OR _WS_VISIBLE  or _BS_PUSHLIKE or _BS_AUTORADIOBUTTON or _BS_RIGHT
'Radiobuttons 16 to 20
bstyle(4)=_WS_CHILDWINDOW OR _WS_VISIBLE  or _BS_PUSHLIKE or _BS_AUTORADIOBUTTON or _BS_FLAT
'Radiobuttons 21 to 25
bstyle(5)=_WS_CHILDWINDOW OR _WS_VISIBLE or _BS_AUTORADIOBUTTON or _BS_TOP
'Radiobuttons 26 to 30
bstyle(6)=_WS_CHILDWINDOW OR _WS_VISIBLE or _BS_AUTORADIOBUTTON or _BS_RIGHTBUTTON or_
          _BS_MULTILINE or _BS_BOTTOM or _BS_CENTER

'Set the starting positions and sizes for buttons
yOrg=35
bheight=25
count=1

'loop through creation of buttons
For row=1 to 6 'six rows of buttons, each row having a different style
   xOrg=55
   For n=1 to 5   'five buttons in each row
      'draw buttons and return handle of api button in one function
      hr(n)=drawButton(h,hC(n),row,class$,"",bstyle(row),xOrg,yOrg,60,bheight)
      xOrg=xOrg+70
   Next n
   'set font & captions for controls
   For n=1 to 5
     hCont=hr(n)
     CallDLL #user32,  "SendMessageA",_
                        hCont As long,_    'handle
                        _WM_SETFONT As word, _
                        hFont1 As long, _
                        1 As long, _
                        result As void
     legend$="RB"+Str$(count)
     If count>25 Then legend$=legend$+" ABC"
     res=setText(hr(n),legend$)
     count=count+1
   Next n
   yOrg=yOrg+55
   If count=26 Then bheight=35
Next row

'this completes the drawing of the window - wait for user input
Wait

'--------------------------------------------------------------------------------------
'  code to support triggered events

[rb1]
Notice "Left button clicked"
Wait

[rb2]
Wait

[rb3]
Wait

[rb4]
Wait

[rb5]
Notice "Right button clicked"
Wait


[quit]
    'remove fonts from memory
    CallDLL #gdi32, "DeleteObject", hFont1 As long, r As boolean
    CallDLL #gdi32, "DeleteObject", hFont2 As long, r As boolean
    Close #w
    End

'--------------------------------------------------------------------------------------
'  called functions

Function drawButton(hW,hB,p,class$,text$,style,x,y,w,h)
    'this function is the heart of the process.  It draws the
    'raidiobutton and returns the handle to the button

    'get instance handle of window
    CallDLL #user32, "GetWindowLongA", _
                     hW As long, _
                     _GWL_HINSTANCE As long, _
                     hInst As long

    'create button of specified style and get handle of button
    Select Case p
       Case 1,2,5,6: pro=1
       Case Else pro=0
    End Select

    'CreateWindowExA actually creates the control (a radiobutton)
    CallDLL #user32, "CreateWindowExA", _
                     pro As long, _
                     class$ As ptr,_
                     text$ As ptr, _
                     style As long, _
                     x As long, _
                     y As long, _
                     w As long, _
                     h As long,_
                     hW As long, _
                     0 As long, _
                     hInst As long, _
                     0 As long, _
                     hButton As long

    'get ID of hidden LB button
    CallDLL #user32, "GetWindowLongA", _
                     hB As long, _
                     _GWL_ID As long, _
                     bID As long

    'link clicked button with event for hidden button
    CallDLL #user32, "SetWindowLongA", _
                     hButton As long, _
                     _GWL_ID As long, _
                     bID As long,_
                     res As long

    'return the button handle
    drawButton=hButton
End Function

Function setText(h, caption$)
   CallDLL #user32, "SetWindowTextA", _
                     h As long, _        'handle
                     caption$ As ptr, _  'new string
                     result As void
End Function


