'** open32_04.bas
'** Open Source Editor v32.04
'** Please add your name to
'** the list of authors and
'** give your version a unique filename.
'** Filenames of the form open32_xx.bas
'** are used by the newsletters, so please
'** choose a completely different filename
'** for your version, to avoid confusion.
'** You might want to add your initials to
'** your filename - open32_cg.bas for instance.
'**
'** Authors:
'**
'** Alyce Watson
'** Brent Thorn      - tooltip routines and cascading popup menu
'** David Szafranski - launch browser with URL & launch email
'** September 2000   - added recent files menu list by Brent Thorn
'** January 2001     - adding runtime engine for LB2 w/command line
'** Doyle Whisenant  - array-maker similar to LB Workshop tool
'** AW-March 2001    - removed caret creation functions, which didn't always work correctly
'** AW-March 2001    - added recent files list to ini file
'** AW-March 2001    - modified recent files menu list to show filenames
'** AW-July 2001     - ported to LB3
'                    - * changed API calls for ShellExecuteA, SetWindowTextA,
'                    - *     and ModifyMenuA
'                    - * removed code library, which was LB2 syntax
'                    - * fixed look of array maker for LB3
'                    - * changed bmp dimension functions for bmp previewer
'                    - * fixed drawing bmpbutton for LB3 - added fill
'                    - *     and backcolor of buttonface
'                    - * condensed font commands for controls in bmp previewer
'                    - * added pen color tattletale to bmp previewer
'                    - * changed color choice in bmp previewer to colordialog
'** Brent Thorn      - Updated his tooltip routine, July, 2001
'** AW-January 2002  - Cleanup and more LB3 updating and comments
'                      * more updates to tooltips
'                      * removed help-tutorial menu and button
'                      * removed dummy EDIT menu
'                      * changed helpfile engine to winhlp32
'** AW-February 2002 - Added multiple textbox colors to bmp previewer and array maker
'** AW-March 2002    - Made XP compatible
'                      * changed externals winfile.exe to explorer.exe
'                      * changed externals paintbrush to SearchTreeForFile for mspaint.exe
'                      * added *.lba extension

'** AW-November 2002 - Added real windows toolbar
'                      * modified tooltips to work with toolbar
'                      * removed opening of dlls, used handles #user32, etc.
'                      * added error trapping if liberty.exe not found
'
'
'
'

    if val(Version$)<3 then
        notice "This program is meant for in LBv3.x!"
        end
    end if

    cursor hourglass
    nomainwin


    dim info$(10,10)        'for file exist check
    dim branch$(100)        'array to hold branch labels
    dim code$(100)          'array to hold code titles
    dim recentfiles$(3)     'array to hold recent files


'variables:
'file$              name of file to open
'title$             titlebar caption
'h                  is window handle
'hwndTT             is tooltip control handle
'hTB                is toolbar handle
'modflag$           is answer to modified query
'answer$            receiver variable for confirm messages
'tempfilename$      name to use when running and debugging code
'rowVar,columnVar   location of texteditor origin
'fileindex          used for counter in path/file separation
'filelength         used for counter in path/file separation
'shortFile$         just filename without path
'filePath$          path without filename
'saveit$            receiver for input from texteditor
'libertyexe$        path to Liberty.exe for running/tokenizing/debugging
'tknfile$           name of tkn to run
'hInstance          window instance handle
'rowcount           number of lines in editor
'line$              contents of line in editor
'bx                 counter variable for branch label loading
'branchlength       length of branch label
'branchselect$      branch label selection
'picFile$           filename for opened bitmap
'savebmpfile$       name to save bmp AS
'bmpwidth           width of bitmap
'bmpheight          height of bitmap
'xbmp               x location to draw bitmap in graphicbox
'ybmp               y location to draw bitmap in graphicbox
'bmploaded          flag to set when a bitmap is loaded
'message$           string variable to hold notice and confirm messages
'printFile$         temporary file for printing with Notepad
'wavPath$           path to last wav played
'wavFile$           name of wav file to play
'slash              counter variable to separate wav path from filename
'setFont$           LB fontname and size info for chosen font
'timemsg$           variable to hold time info
'datemsg$           variable to hold date info
'RunFile$           for ShellExecute
'lpOperation$       for ShellExecute
'lpParameters$      for ShellExecute
'lpDirectory$       for ShellExecute
'nShowCmd           show window flag for ShellExecute
'helpopen           flag for help window opening
'bString            flag for array string
'bNumeric           flag for array numeric
'i                  index var for general use
'a                  index var for general use
'arrayName$         name of array
'arrayItem$         individual array items
'myarray$()         variable for generating array items
'ArrayFileName$     name of file opened for creating array
'line$              file input variable
'rfile$             dummy file name for input from ini file
'hmenuRecent        handle of recent files menu popup
'menuString$        caption of menu item
'menuID             ID of menu item
'comExt$            extensions for running from command line
'RootPath$          for finding mspaint w/SearchTreeForFile
'InputPathName$     for finding mspaint w/SearchTreeForFile
'OutputPathBuffer$  for finding mspaint w/SearchTreeForFile



    ForegroundColor$=   "darkblue"
    TexteditorColor$=   "lightgray"
    drawcolor$=         "0 0 0"     'default color for drawing on bitmaps
    decnum$=            "255"       'default starter for number conversion
    decnum=             val(decnum$)
    hexnum$=            "FF"        'default starter for number conversion


menu #1, "&File",_
    "&New",               [new],_
    "&Open",              [open],_
    "&Save",              [save],_
    "Save &As",           [saveas],|,_
    "&Print",             [print],_
    "E&xit",              [quit],_
    "&Recent",            [loop]

menu #1, "Edit" 'LB supplies the Edit Menu

Menu #1, "Recent",_
    "File 1",             [File_1],_
    "File 2",             [File_2],_
    "File 3",             [File_3]

menu #1, "&Run",_
    "Ru&n",               [run],_
    "&Debug",             [debug],_
    "&Make TKN",          [maketkn],_
    "Run &TKN",           [runtkn]

menu #1, "E&xternals",_
    "&MS Paint",          [paint],_
    "&Explorer",          [winfile],_
    "&Notepad",           [notepad],_
    "&Calculator",        [calculator]

menu #1, "&Tools",_
    "&Branch Labels",        [branchlabels],_
    "Bit&map Preview",       [bmp],_
    "&Wav Preview",          [wav],_
    "&Array Maker",          [makeArrays],_
    "Font &Dialog",          [fontdialog],_
    "&Number Tools",         [numbertools],_
    "Time and D&ate",        [timetools],|,_
    "Libert&y BASIC Website",[libertyhome],_
    "Email Carl &Gundel",    [emailcarl]


menu #1, "&Help",_
    "&Liberty BASIC Help", [help],_
    "&Editor Help",        [edithelp],_
    "&About",              [about]



    WindowWidth=640:WindowHeight=480
    texteditor #1.t, 0,50,600,390  'edit window

'hidden buttons used by toolbar code:
    Button #1.hide0, "",  [new],        UL, -400, -400, 0, 0
    Button #1.hide1, "",  [open],       UL, -400, -400, 0, 0
    Button #1.hide2, "",  [save],       UL, -400, -400, 0, 0
    Button #1.hide3, "",  [saveas],     UL, -400, -400, 0, 0
    Button #1.hide4, "",  [print],      UL, -400, -400, 0, 0
    Button #1.hide5, "",  [run],        UL, -400, -400, 0, 0
    Button #1.hide6, "",  [debug],      UL, -400, -400, 0, 0
    Button #1.hide7, "",  [maketkn],    UL, -400, -400, 0, 0
    Button #1.hide8, "",  [paint],      UL, -400, -400, 0, 0
    Button #1.hide9, "",  [winfile],    UL, -400, -400, 0, 0
    Button #1.hide10, "", [notepad],    UL, -400, -400, 0, 0
    Button #1.hide11, "", [calculator], UL, -400, -400, 0, 0
    Button #1.hide12, "", [help],       UL, -400, -400, 0, 0
    Button #1.hide13, "", [quit],       UL, -400, -400, 0, 0


open "Open Source LB Editor" for window as #1

    h=HWND(#1)
    hText=hwnd(#1.t)
    print #1, "trapclose [quit]"
    print #1, "resizehandler [resize]"


    calldll #user32, "ShowWindow",h as long,_SW_MAXIMIZE as long,result As long

    print #1.t, "!font courier_new 10"
    print #1.t, "!setfocus";
    gosub [remove.menu]
    gosub [read.ini.file]
    GoSub [MakeToolbar]

[check.command]  'if CommandLine$ contains a filename, it will be loaded at startup
    if CommandLine$<>"" then
        CommandLine$=lower$(trim$(CommandLine$))
        comExt$=right$(CommandLine$,3)
        if comExt$="bas" or comExt$="lba" then
            i=len(CommandLine$)
            while mid$(CommandLine$,i,1)<>" " and i>1
                i=i-1
            wend
            file$=mid$(CommandLine$,i)
            goto [loadFile]
        end if
    end if

    cursor normal

WAIT

[loop]
    wait

[quit]
    gosub [isModified]
    close #1
    if tempfilename$<>"" then kill tempfilename$
    gosub [write.ini.file]
    CallDLL #gdi32, "DeleteObject",_
        hbmpTools As long, ret As boolean
    END


[isModified]'** CHECK TO SEE IF FILE HAS BEEN MODIFIED
    print #1.t, "!modified?":input #1.t, modflag$
    if modflag$="true" then
        confirm "This file has been modified.  Save?";answer$
        if answer$="yes" then gosub [savesub]
    end if
    RETURN


[resize]'** LOCATE TEXT EDITOR
    '** LOCATE TEXTEDITOR 30 PIXELS FROM TOP OF CLIENT AREA
    print #1.t, "!locate 0 30 ";WindowWidth-1;" ";WindowHeight-31
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    '** UPDATE WINDOW
    print #1, "refresh"
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    wait


[new]'** CLEAR EDITOR CONTENTS, RESET VARIABLES
    gosub [isModified]
    print #1.t, "!cls"
    file$="untitled.bas"
    filePath$=""
    gosub [settext]
    wait



[open]  'added lba extension
    gosub [isModified]
    filedialog "Open file..",filePath$+"*.bas;*.lba",file$ 
    if file$="" then wait
    gosub [recent.files]

[loadFile]'** OPEN FILE AND LOAD INTO TEXTEDITOR
    shortFile$=SeparateFile$(file$)
    filePath$=SeparatePath$(file$)

    if FileExist(filePath$,shortFile$)<1 then
        notice "Error"+chr$(13)+"File does not exist."
        wait
    end if

    cursor hourglass
    open file$ for input as #file
    print #1.t, "!contents #file"
    close #file
    gosub [settext]
    print #1.t, "!origin 1 1";
    cursor normal
    wait



[settext]'** ADD FILENAME TO TITLEBAR
    title$="Open Source LB Editor "+file$
    calldll #user32, "SetWindowTextA", h as long, title$ as ptr, result as void
    return



[saveas]'** SAVES CONTENTS AS file$ - added lba extension
    filedialog "Save file as..",filePath$+"*.bas;*lba",file$ 
      if file$="" then
        notice "You must choose a file name."
        wait
      end if
    gosub [settext]

[save]'** SAVES CURRENT FILE
    gosub [savesub]
    wait


[savesub]
    cursor hourglass
    print #1.t, "!contents?";
    input #1.t, saveit$

    '** IF THERE IS NO CURRENT FILENAME, ASK USER FOR ONE
    if (right$(file$,12)="untitled.lba") or (file$="") then
        filedialog "Save file as...",filePath$+"*.bas;*.lba",file$ 
          if file$="" then
            notice "You must choose a file name."
            RETURN
          end if
    end if

    open file$ for output as #file
    print #file, saveit$
    close #file

    cursor normal
    notice "File saved as "+ file$
    RETURN


[print]
    'save file as a temporary file
    'and cause it to be printed with
    'the  user's default text editor
    cursor hourglass
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar
    print #1.t, "!contents?";
    input #1.t, saveit$ 

    open "tempedit.txt" for output as #tprint
        print #tprint, saveit$
    close #tprint

    printFile$ = "tempedit.txt"+chr$(0)

    open "shell32" for dll as #shell
    calldll #shell, "ShellExecuteA", _
        h as long, _
        "print" as ptr, _
        printFile$ as ptr, _
        "" as ptr, _
        DefaultDir$ as ptr, _
        _SW_HIDE as long, _
        result as long
    close #shell

    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    cursor normal
    wait


[readyRun]'** MAKE A TEMP FILE TO RUN IN LIBERTY BASIC
    '** GET CURRENT TEXTEDIT ORIGIN
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    '** GET CONTENTS OF TEXTEDITOR AND SAVE TO TEMPFILE
    if tempfilename$<>"" then kill tempfilename$
    print #1.t, "!contents?"
    input #1.t, saveit$ 
    tempfilename$=filePath$+"tempfile.bas"
    open tempfilename$ for output as #temp
    print #temp, saveit$
    close #temp

    if libertyexe$="" then gosub [findLiberty]
    RETURN


[findLiberty]'** FIND LIBERTY.EXE
    filedialog "Find Liberty.exe","*.*",libertyexe$ 
    RETURN


[run]
    gosub [readyRun]
    if libertyexe$="" then
        notice "Liberty.exe not found."
    end if
    run libertyexe$+" -R -A -M "+tempfilename$ 
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    wait

[debug]
    gosub [readyRun]
    if libertyexe$="" then
        notice "Liberty.exe not found."
    end if
    run libertyexe$+" -D -A -M "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    wait

[runtkn]
    filedialog "Choose TKN..","*.TKN",tknfile$
    run tknfile$
    wait

[maketkn]
    gosub [readyRun]
    if libertyexe$="" then
        notice "Liberty.exe not found."
    end if
    run libertyexe$+" -T "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    wait



[paint]
    'change to make XP compatible
    cursor hourglass
    RootPath$="c:\"
    InputPathName$="mspaint.exe" + chr$(0)   'filename only
    OutputPathBuffer$=space$(1023)+chr$(0)

    open "imagehlp" for dll as #ih
    calldll #ih, "SearchTreeForFile",_
        RootPath$ as ptr,_
        InputPathName$ as ptr,_
        OutputPathBuffer$ as ptr,_
        ret as long
        close #ih

    if ret=0 then
        notice InputPathName$;" not found."
    else
        run trim$(OutputPathBuffer$), SHOWNORMAL
    end if
    cursor normal
    wait


[notepad]
    run "notepad.exe", SHOWNORMAL
    wait

[winfile]
    'change to make XP compatible
    run "explorer.exe",SHOWNORMAL
    wait

[calculator]
    run "calc.exe" ,SHOWNORMAL
    wait



[help]
    'changed help engine from
    'winhelp to winhlp32 for LB3,
    'which is 32-bit
    run "winhlp32 liberty3.hlp"
    wait


[branchlabels]
    '** OPEN DIALOG, FILL LISTBOX WITH BRANCH LABELS
    cursor hourglass
    WindowWidth=420:WindowHeight=440
    button #2.okay,   "OKAY",  [branch],      UL, 320,10,80,26
    button #2.cancel, "CANCEL",[cancelbranch],UL, 320,40,80,26
    combobox #2.branch, branch$(, [branch],10, 10, 300,380
    open "Branch Labels" for dialog_modal as #2

    print #2.branch,  "font Courier_New 0 16"
    print #2.okay,   "!font Courier_New 0 20"
    print #2.cancel, "!font Courier_New 0 20"

    Print #1.t,"!lines";
    Input #1.t, rowcount
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    rowcount=int(rowcount)
    REDIM branch$(rowcount)
    branch$(0)="<start>"

    bx=1
    for i=1 to rowcount
        print #1.t,"!line ";i;"";
        Input #1.t, line$ 
            if left$(trim$(line$),1)="[" then
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
            if lower$(word$(line$,1))="function" then  'improved by Carl Gundel
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
            if lower$(word$(line$,1))="sub" then  'improved by Carl Gundel
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
    next i

    SORT branch$(,0,bx

    Print #2.branch,"reload"
    print #2.branch, "selectindex 1";
    cursor normal
    print #2.branch, "setfocus"

    '** cause combobox to display in open drop position:
    hBranch=hwnd(#2.branch)
    calldll #user32, "SendMessageA",_
        hBranch as long,_   'handle of combobox
        _CB_SHOWDROPDOWN as long, _
        1 as long,_         'repaint flag=yes
        0 as long,_         'always 0
        re as long

    wait


[cancelbranch]
    '** CANCEL, RETURN TO EDITOR
    close #2
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    print #1.t, "!setfocus";
    wait


[branch]
    '** CHOOSE BRANCH, SET EDITOR TO THAT POSITION
    cursor hourglass
    print #2.branch,"selection?"
    Input #2.branch,branchselect$ 

    if branchselect$="<start>" then
        print #1.t, "!origin 1 1";
        print #1.t, "!setfocus";
        cursor normal
        close #2
        wait
    end if

    branchlength=len(branchselect$)

    For i = 1 TO rowcount
       print #1.t,"!line ";i;
       Input #1.t,line$
          If trim$(line$)= branchselect$ Then
            Print #1.t, "!origin ";i;" ,0";
            i=rowcount
            close #2
            print #1.t, "!setfocus";
            cursor normal
            wait
          END If
    Next i
    cursor normal
    wait




[bmp] '** BITMAP PREVIEWER
    WindowWidth=640:WindowHeight=480
    UpperLeftX=int((DisplayWidth=WindowWidth)/2)
    UpperLeftY=int((DisplayHeight=WindowHeight)/2)

    button #bit.open, "Open",   [openbmp],  UL,330,5,80,26
    button #bit.save, "Save As",[savebmp],  UL,330,35,80,26
    button #bit.exit, "Exit",   [closebit], UL,330,65,80,26

    button #bit.draw, "Choose Pen Color",[colorChoice],UL,425,5,160,26
    graphicbox #bit.color, 425,35,160,26
    statictext #bit.ins, "Click and drag to draw on bitmap.",415,70,260,20

'** New, separate colors for each textbox:
    TextboxColor$="blue"
    textbox #bit.t1, 20,35,300,26
    TextboxColor$="pink"
    textbox #bit.t2, 20,65,300,26
    graphicbox #bit.box1, 20,100,600,340
    statictext #bit.s, "Bitmap File:",20,5,150,20
    open "Bitmap Preview" for dialog_modal as #bit
    print #bit, "trapclose [closebit]"

    print #bit,  "font Times_New_Roman 0 16"
    print #bit.box1, "down"
    print #bit.box1, "size 2; color ";drawcolor$
    print #bit.box1, "setfocus; when leftButtonMove [drawit]"
    print #bit.box1, "when leftButtonDown [drawit]"
    print #bit.color, "down; fill ";drawcolor$
    print #bit.color, "flush"

    wait

[closebit]
    print #bit.box1, "cls"
    close #bit
    if bmploaded=1 then unloadbmp "tempPicture"
    bmploaded=0
    wait

[drawit]
    if bmploaded=0 then
        notice "You must choose a bitmap first."
        wait
    end if

    if MouseX>bmpwidth or MouseY>bmpheight then wait

    print #bit.box1, "set ";MouseX;" ";MouseY
    wait



[savebmp]
    if picFile$="" then
        notice "It is not possible to SAVE.  No Bitmap has been chosen."
        wait
    end if

    print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    print #bit.box1, "flush"

    filedialog "Save As..","*.bmp",savebmpfile$ 
    if savebmpfile$="" then wait

    BMPSAVE "tempPicture", savebmpfile$ 

    cursor normal
    notice "Bitmap saved as "+savebmpfile$ 
    wait


[openbmp]
    filedialog "Open Bitmap","*.bmp", picFile$
    if picFile$ = "" then wait

    print #bit.t1, lower$(picFile$)

    if bmploaded=1 then unloadbmp "tempPicture"
    loadbmp "tempPicture", picFile$
    bmploaded=1

    hPic=hbmp("tempPicture")
    bmpheight=BitmapHeight(hPic)
    bmpwidth=BitmapWidth(hPic)

    print #bit.t2, "Width:  ";bmpwidth;"    Height:  ";bmpheight;""

    print #bit.box1, "cls"
    print #bit.box1, "drawbmp tempPicture 0 0"
    print #bit.box1, "flush"
    wait

[colorChoice]
    print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    colordialog drawcolor$,drawcolor$
    print #bit.box1, "color "+drawcolor$
    print #bit.color, "cls"
    print #bit.color, "fill ";drawcolor$
    print #bit.color, "flush"
    wait

[about]
    message$="About this editor..."+chr$(13)+_
        chr$(169)+"The Liberty BASIC Community"
    notice message$
    wait

[wav]
    if wavPath$="" then wavPath$=DefaultDir$
    filedialog "Open WAV file",wavPath$+"\*.WAV",wavFile$
    if wavFile$="" then
        playwave ""
        wait
    end if

    slash=len(wavFile$)
        while instr(wavFile$, "\", slash)=0
            slash=slash-1
        wend
    wavPath$=left$(wavFile$,slash)
    playwave wavFile$,async
    goto [wav]



[write.ini.file]
    open DefaultDir$ + "\editor.ini" for output as #inifile
        print #inifile, setFont$ 
        print #inifile, recentfile$(1)
        print #inifile, recentfile$(2)
        print #inifile, recentfile$(3)
    close #inifile
    RETURN



[read.ini.file]
    open DefaultDir$ + "\editor.ini" for append as #inifile
        if lof(#inifile) <> 0 then
            close #inifile
            open DefaultDir$ + "\editor.ini" for input as #inifile
            line input #inifile, setFont$ 

           if not(eof(#inifile)) then
                line input #inifile, rfile$
                recentfile$(1)=rfile$
            end if

            if not(eof(#inifile)) then
                line input #inifile, rfile$
                recentfile$(2)=rfile$
            end if

            if not(eof(#inifile)) then
                line input #inifile, rfile$
                recentfile$(3)=rfile$
            end if
        end if
    close #inifile

    if setFont$="" then setFont$="courier_new 10"
    print #1.t, "!font ";setFont$  'set font in texteditor
    gosub [ResetMenu]
    RETURN


[ResetMenu]    'make sure filenames are shown in recent menu
    flags=_MF_STRING OR _MF_BYPOSITION

    for i = 0 to 2 'do for each of three recent files in menu

        menuString$=recentfile$(i+1)   'new caption from array = full path/filename

        calldll #user32, "GetMenuItemID",_
            hmenuRecent as long,_     'handle of recent menu
            i as long,_               '0-based position of item
            menuID as long            'ID of item

        calldll #user32, "ModifyMenuA",_
            hmenuRecent as long,_       'handle of recent menu
            i as long,_                 '0-based position of item
            flags as long,_             'instructions for call
            menuID as long,_            'ID of item to change
            menuString$ as ptr,_        'new caption
            result as long

    next i

    calldll #user32, "DrawMenuBar",_        'redraw menu bar
        hWin as long, result as void

    RETURN


[numbertools]
    popupMenu "&Decimal to Hex Converter",[dectohex],_
        "&Hex to Decimal Converter",[hextodec]
    wait

[dectohex]
    prompt "Enter a number...";decnum$
    decnum=val(decnum$)
    notice dechex$(decnum)
    wait

[hextodec]
    prompt "Enter a hex number...";hexnum$
    notice hexdec(hexnum$)
    wait

[timetools]
    popupMenu "Current &Time",[timenow],_
        "Today's &Date",[datenow]
    wait

[timenow]
    timemsg$="Current time is:  "+chr$(13)+_
    time$()+chr$(13)+chr$(13)+_
    "Seconds since midnight:  "+str$(time$("seconds"))+chr$(13)+_
    "Milliseconds since midnight:  "+str$(time$("milliseconds"))
    notice timemsg$
    wait

[datenow]
    datemsg$="Date is" +chr$(13)+_
    date$() +chr$(13)+_
    date$("mm/dd/yyyy") +chr$(13)+_
    date$("mm/dd/yy") +chr$(13)+_
    date$("yyyy/mm/dd") +chr$(13)+_
    "Days since Jan 1, 1901:  "; date$("days")
    notice datemsg$
    wait



[fontdialog]
    fontdialog setFont$,setFont$
    print #1.t, "!font ";setFont$
    gosub [write.ini.file]
    wait


[libertyhome]
    CALL RunThis "http://www.libertybasic.com/" ,h
    wait


[emailcarl]
    CALL RunThis "mailto:carlg@libertybasic.com?Subject=Liberty BASIC" ,h
    wait


[edithelp]
    if helpopen = 1 then
        notice "Help window is already open!"
        wait
    end if

    helpopen = 1
    WindowWidth=400:WindowHeight=300
    open "Help" for text as #help
    print #help, "Use this editor to write, edit and run"
    print #help, "Liberty BASIC source code."
    print #help, "Be sure to try out the many"
    print #help, "programming tools provided."
    print #help, "This program is in the public domain."
    print #help, "Feel free to use and modify."
    print #help, "!origin 1 1";
    print #help, "!trapclose [quit.edithelp]";

    input a$ 

    [quit.edithelp]
    close #help
    helpopen = 0
    wait



'*************** FUNCTION LIBRARY **********************
Function BitmapWidth(hBmp)
    struct BITMAP,_ '14 bytes
    bmType as long,_
    bmWidth As long,_
    bmHeight As long,_
    bmWidthBytes As long,_
    bmPlanes as long,_
    bmBitsPixel as long,_
    bmBits as Long

    open "gdi32" for dll as #g
    calldll #g, "GetObjectA", hBmp as long,_
       14 as long,BITMAP as struct,_
       results as long
    close #g

    BitmapWidth=BITMAP.bmWidth.struct
End Function

Function BitmapHeight(hBmp)
    struct BITMAP,_ '14 bytes
    bmType as long,_
    bmWidth As long,_
    bmHeight As long,_
    bmWidthBytes As long,_
    bmPlanes as long,_
    bmBitsPixel as long,_
    bmBits as Long

    open "gdi32" for dll as #g
    calldll #g, "GetObjectA", hBmp as long,_
       14 as long,BITMAP as struct,_
       results as long
    close #g

    BitmapHeight=BITMAP.bmHeight.struct
End Function



function SeparateFile$(f$)
    fileindex=len(f$)
    filelength=len(f$)
      while mid$(f$, fileindex,1)<>"\"
        fileindex=fileindex-1
      wend
    SeparateFile$=right$(f$,filelength-fileindex)
end function


function SeparatePath$(f$)
    fileindex=len(f$)
    filelength=len(f$)
      while mid$(f$, fileindex,1)<>"\"
        fileindex=fileindex-1
      wend
    SeparatePath$=left$(f$,fileindex)
end function


function FileExist(fPath$,fFile$)
    files fPath$,fFile$,info$(
    FileExist=val(info$(0,0))
end function


sub RunThis RunFile$, hWindow
    RunFile$=RunFile$+chr$(0)
    lpOperation$ = "open" + chr$(0)
    lpParameters$ = "" + chr$(0)
    lpDirectory$ = "" + chr$(0)
    nShowCmd = _SW_SHOWNORMAL

    open "shell32" for dll as #shell
    calldll #shell, "ShellExecuteA", _
        hWindow as long, _          'parent window
        lpOperation$ as ptr, _      'open or print
        RunFile$ as ptr, _          'file name
        lpParameters$ as ptr, _     'null
        lpDirectory$ as ptr, _      'default directory
        nShowCmd as long, _        'show window flag
        result as long
    close #shell
    if result <= 32 then notice "Error, Address Failure!"
end sub


[remove.menu]
    CallDll #user32, "GetMenu",_
        h as long,_     'window handle
        hMenu1 as long  'returns handle of menu bar

    CallDll #user32, "GetSubMenu",_
        hMenu1 As long,_    'handle of menu bar
        0 As long,_         'position of sub menu desired 0 - first
        hmenuFile As long   'handle of sub menu for File menu

    CallDll #user32, "GetSubMenu",_
        hMenu1 As long,_    'handle of menu bar
        2 As long,_         'position of recent menu 2 = third
        hmenuRecent As long 'returns handle of recent menu

    menuflags = _MF_BYPOSITION Or _MF_POPUP Or _MF_STRING
    CallDll #user32, "ModifyMenuA",_
        hmenuFile As long, _    'handle of menu to modify
        7 As long,_             'position of item to change (8th item)
        menuflags As long, _    'flags for type of change
        hmenuRecent As long,_   'menu to add as a popup
        "&Recent" As ptr, _     'name of menu item
        result As long

    CallDll #user32, "RemoveMenu",_   'remove recent menu from view
        hMenu1 As long, _           'handle of menu bar
        2 As long,_                 '2 = position of menu to remove
        _MF_BYPOSITION As long, _   'flag for remove by position
        result As long

    CallDll #user32, "DrawMenuBar",_  'must redraw bar after change
        h As long,_                 'window handle
        result As void
       RETURN


[recent.files]
    recentfile$(3)=recentfile$(2)
    recentfile$(2)=recentfile$(1)
    recentfile$(1)=LOWER$(file$)
    gosub [ResetMenu]
    RETURN


[File_1]
    if recentfile$(1)="" then wait
    file$=recentfile$(1)
    GoTo [loadFile]

[File_2]
    if recentfile$(2)="" then wait
    file$=recentfile$(2)
    GoTo [loadFile]

[File_3]
    if recentfile$(3)="" then wait
    file$=recentfile$(3)
    GoTo [loadFile]


[makeArrays]
    DIM myarray$(1000)
    left=int((DisplayWidth-280)/2):top=int((DisplayHeight-215)/2)
    WindowWidth = 280
    WindowHeight = 215
    bString = 0
    bNumeric = 1
    i = 0
    statictext #am.static1, "Array Name:", 6, 11, 88, 20
    statictext #am.static2, "Item to Add:", 6, 67, 96, 20
    groupbox #am.groupbox3, "Type", 150, 11, 110, 70
    radiobutton #am.string, "String$",[stringSet],[loop],182,31,72,20
    radiobutton #am.numeric, "Numeric",[numericSet],[loop],182,56,72,20
    button #am.default, "Add Item", [ArrayAdd], UL, 150, 86, 112, 25
    TEXTEDITOR #am.text, 0, 0, 0, 0
    button #am.file, "File", [ArrayFile], UL, 150, 119, 112, 25
    button #am.create, "Create and Exit",[create],UL,150,151,112, 25
    button #am.cancel, "Cancel", [ArrayCancel], UL, 14, 151, 112, 25

'** New, separate colors for each textbox:
    TextboxColor$="cyan"
    textbox #am.arrayName, 6, 31, 136, 25
    TextboxColor$="yellow"
    textbox #am.arrayItem, 6, 86, 136, 25
    open "Array Maker" for dialog_nf_modal as #am
    print #am, "font ms_sans_serif 0 8"
    print #am.numeric, "set" 'flag bNumeric = 1
    wait


[ArrayAdd]   'Perform action for the button named 'add'
    print #am.arrayItem, "!contents?";
    input #am.arrayItem, arrayItem$

    myarray$(i)= arrayItem$ 
    i = i + 1
    print #am.arrayItem, "";
    print #am.arrayItem, "!setfocus";
    wait

[ArrayFile]
   i = 0
   filedialog "Open file", "*.*", ArrayFileName$
   if ArrayFileName$ = "" then
     notice "You must input a valid file name!"
     wait
   end if
   print #am.arrayName, "!contents?";
    input #am.arrayName, arrayName$ 
    if bString = 1 and right$(arrayName$, 1) <> "$" then
       arrayName$ = arrayName$ + "$"
    end if
   OPEN ArrayFileName$ for input as #arrayFile
     while eof(#arrayFile) = 0
       line input #arrayFile, ArrayLine$
       myarray$(i)= ArrayLine$ 
       i = i + 1
     wend
     close #arrayFile


[create]
    print #am.arrayName, "!contents?"
    input #am.arrayName, arrayName$ 

    if arrayName$="" then arrayName$="MyArray"
    if bString=1 and right$(arrayName$,1)<>"$" then
        arrayName$=arrayName$+"$"
    end if

    print #am.text, "!cls";
    print #am.text, "Dim ";arrayName$;"(";i;")"
    For a = 0 to i-1
    if right$(arrayName$, 1) = "$" then
      Print #am.text, arrayName$;"(";a;") = ";chr$(34);myarray$(a);chr$(34)
    else
      Print #am.text, arrayName$;"(";a;") = ";myarray$(a)
    end if
    Next a

    Print #am.text, "!selectall";
    Print #am.text, "!copy";
    Print #am.text, "!cls";
    notice "Array is copied into clipboard. Paste into your application."
[ArrayCancel]
    close #am
    wait

[stringSet]
    bString = 1
    bNumeric = 0
    wait

[numericSet]
    bNumeric = 1
    bString = 0
    wait



'All code after this point is needed
'to create the toolbar.  Do not modify
'or remove anything below.
[MakeToolbar]
    'do not attempt to create toolbar if bmp is missing
    if FileExist(DefaultDir$,"opensrc.bmp")=0 then wait

    calldll #comctl32, "InitCommonControls", _
        re as void

    gosub [addTooltipControl] 'create tooltip control

    struct TBBUTTON,_
    bmpID As long,_ 'index of bitmap
    cID As long,_   'command ID
    State As long,_ 'button state
    Style As long,_ 'button style
    dwData As long,_'not used
    Str As long     'not used

    TB.ADDBUTTONS    = 1044
    TB.SETTOOLTIPS   = 1060
    TBSTYLE.BUTN     = 0
    TBSTYLE.FLAT     = 2048
    TBSTYLE.TOOLTIPS = 256


    hbmpTools=LoadBitmapSystemColors("opensrc.bmp")
    If hbmpTools=0 Then
        Notice "Error loading bitmap!"
        Return
    End If

    hID0 = GetWindowLong(hWnd(#1.hide0),_GWL_ID)
    hID1 = GetWindowLong(hWnd(#1.hide1),_GWL_ID)
    hID2 = GetWindowLong(hWnd(#1.hide2),_GWL_ID)
    hID3 = GetWindowLong(hWnd(#1.hide3),_GWL_ID)
    hID4 = GetWindowLong(hWnd(#1.hide4),_GWL_ID)
    hID5 = GetWindowLong(hWnd(#1.hide5),_GWL_ID)
    hID6 = GetWindowLong(hWnd(#1.hide6),_GWL_ID)
    hID7 = GetWindowLong(hWnd(#1.hide7),_GWL_ID)
    hID8 = GetWindowLong(hWnd(#1.hide8),_GWL_ID)
    hID9 = GetWindowLong(hWnd(#1.hide9),_GWL_ID)
    hID10 = GetWindowLong(hWnd(#1.hide10),_GWL_ID)
    hID11 = GetWindowLong(hWnd(#1.hide11),_GWL_ID)
    hID12 = GetWindowLong(hWnd(#1.hide12),_GWL_ID)
    hID13 = GetWindowLong(hWnd(#1.hide13),_GWL_ID)

    'fill toobar button struct for first button
    TBBUTTON.bmpID.struct = 0              'index of first bitmap
    TBBUTTON.cID.struct = hID0             'ID of first button
    TBBUTTON.State.struct = 4              'enabled
    TBBUTTON.Style.struct = TBSTYLE.BUTN   'style
    TBBUTTON.dwData.struct = 0             'not used
    TBBUTTON.Str.struct = 0                'not used

    style=_WS_CHILD Or _WS_VISIBLE Or TBSTYLE.FLAT _
        Or _WS_BORDER or TBSTYLE.TOOLTIPS
    uStructSize = Len(TBBUTTON.struct)
    CallDLL #comctl32, "CreateToolbarEx",_
        h As long,_         'parent handle
        style As long,_     'window style flags
        0 As long,_         'ID
        14 As long,_        'number of Bitmaps
        0 As long,_         'hBMInst-not used
        hbmpTools As long,_ 'bitmap handle
        TBBUTTON As struct,_'toolbar button struct
        1 As long,_         'number of buttons to start
        16 As long,_        'width buttons
        16 As long,_        'height buttons
        16 As long,_        'width bitmaps for buttons
        16 As long,_        'height bitmaps for buttons
        uStructSize As long,_
        hTB As long         'handle to toolbar

    'must add tooltip control before adding buttons to toolbar
    r=SendMessage(hTB,TB.SETTOOLTIPS,hwndTT,0)


    'fill toolbar button struct with new info to add buttons:
    TBBUTTON.bmpID.struct = 1  'bitmap image index
    TBBUTTON.cID.struct = hID1 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 2  'bitmap image index
    TBBUTTON.cID.struct = hID2 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 3  'bitmap image index
    TBBUTTON.cID.struct = hID3 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 4  'bitmap image index
    TBBUTTON.cID.struct = hID4 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 5  'bitmap image index
    TBBUTTON.cID.struct = hID5 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 6  'bitmap image index
    TBBUTTON.cID.struct = hID6 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 7  'bitmap image index
    TBBUTTON.cID.struct = hID7 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 8  'bitmap image index
    TBBUTTON.cID.struct = hID8 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 9  'bitmap image index
    TBBUTTON.cID.struct = hID9 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 10  'bitmap image index
    TBBUTTON.cID.struct = hID10 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 11  'bitmap image index
    TBBUTTON.cID.struct = hID11 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 12  'bitmap image index
    TBBUTTON.cID.struct = hID12 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 13  'bitmap image index
    TBBUTTON.cID.struct = hID13 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    'tell toolbar to resize with window
    ret = SendMessage(hTB, TB.AUTOSIZE, 0, 0)

    'add tooltips for toolbar buttons
    gosub [addTooltips]
    Return


Sub AddButton hndl,msg
    CallDLL #user32, "SendMessageA", hndl As long,_
    msg As long, 1 As long,_
    TBBUTTON As struct, r As long
    End Sub

Function SendMessage(hWin, msg, wParam, lParam)
    CallDLL #user32, "SendMessageA", hWin As long, msg As long, _
    wParam As long, lParam As long, SendMessage As long
    End Function

Function GetWindowLong(hWin, type)
    CallDLL #user32, "GetWindowLongA",_
    hWin As long,type As long,_
    GetWindowLong As long
    End Function

Function LoadBitmapSystemColors(bmp$)
    flags=_LR_LOADFROMFILE or _LR_LOADMAP3DCOLORS _
        or _LR_LOADTRANSPARENT
    CallDLL #user32, "LoadImageA",_
    0 As long, bmp$ As ptr, _IMAGE_BITMAP As ulong,_
    0 As long, 0 As long, flags As long,_
    LoadBitmapSystemColors As ulong
    End Function



[addTooltipControl]
    TTF.IDISHWND    = 1
    TTF.CENTERTIP   = 2
    TTF.SUBCLASS    = 16
    TTM.ADDTOOL     = 1028
    TTM.DELTOOL     = 1029
    TTS.ALWAYSTIP   = 1
    TTS.NOPREFIX    = 2
    style           = _WS_POPUP or TTS.NOPREFIX _
                      or TTS.ALWAYSTIP


    calldll #user32, "GetWindowLongA", _
        h as long, _GWL_HINSTANCE as long,_
        hInstance as long

    calldll #user32, "CreateWindowExA",_
        _WS_EX_TOPMOST as long,_
        "TOOLTIPS_CLASS32" as ptr,_
        "" as ptr, style as long,_
        _CW_USEDEFAULT as long,_CW_USEDEFAULT as long,_
        _CW_USEDEFAULT as long,_CW_USEDEFAULT as long,_
        h as long, 0 as long, hInstance as long,_
        0 as long,hwndTT as long


    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    calldll #user32, "SetWindowPos", hwndTT as long,_
        _HWND_TOPMOST as long, _
        0 as long, 0 as long,_
        0 as long, 0 as long,_
        flags as long, r as long
    return


[addTooltips]
    '** LB3 NOW ONLY REQUIRES A SINGLE STRUCT
    '   FOR ALL TOOLTIPS
    struct toolinfo, cbSize as long, uFlags as long,_
        hwnd as long, uId as long, left as long, top as long,_
        right as long, bottom as long, _
        hInst as long, lpstrText$ as ptr

    'THESE STRUCT MEMBERS ONLY NEED TO BE FILLED ONCE:
    toolinfo.cbSize.struct = len(toolinfo.struct)
    toolinfo.uFlags.struct = TTF.SUBCLASS
    toolinfo.hwnd.struct = hTB
    toolinfo.top.struct=0     'top location on toolbar
    toolinfo.bottom.struct=22 'bottom location on toolbar

    'THESE STRUCT MEMBERS NEED TO BE FILLED ANEW
    'FOR EACH TOOTLIP ADDED:
    toolinfo.lpstrText$.struct = "New File"
    toolinfo.left.struct=0      'initial left location
    toolinfo.right.struct=22    'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Open File"
    toolinfo.left.struct=23    'add 23 to previous left location
    toolinfo.right.struct=45   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Save File"
    toolinfo.left.struct=46    'add 23 to previous left location
    toolinfo.right.struct=68   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Save File As..."
    toolinfo.left.struct=69    'add 23 to previous left location
    toolinfo.right.struct=91   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Print File"
    toolinfo.left.struct=92    'add 23 to previous left location
    toolinfo.right.struct=114   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Run Program"
    toolinfo.left.struct=115    'add 23 to previous left location
    toolinfo.right.struct=137   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Debug Program"
    toolinfo.left.struct=138    'add 23 to previous left location
    toolinfo.right.struct=160   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Tokenize Program"
    toolinfo.left.struct=161    'add 23 to previous left location
    toolinfo.right.struct=183   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Run MS Paint"
    toolinfo.left.struct=184    'add 23 to previous left location
    toolinfo.right.struct=206   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Run Windows Explorer"
    toolinfo.left.struct=207    'add 23 to previous left location
    toolinfo.right.struct=229   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Run Notepad"
    toolinfo.left.struct=230    'add 23 to previous left location
    toolinfo.right.struct=252   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Run Windows Calculator"
    toolinfo.left.struct=253    'add 23 to previous left location
    toolinfo.right.struct=275   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Liberty BASIC Help"
    toolinfo.left.struct=276    'add 23 to previous left location
    toolinfo.right.struct=298   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    toolinfo.lpstrText$.struct = "Exit"
    toolinfo.left.struct=299    'add 23 to previous left location
    toolinfo.right.struct=521   'add 22 to left for right
    calldll #user32, "SendMessageA", hwndTT as long,_
    TTM.ADDTOOL as long, 0 as long,_
    toolinfo as struct, re as long

    RETURN

'** END TOOLBAR CODE **
'** END TOOLBAR CODE **


