null$(1)=chr$(0)
a$="THIS PROGRAM IS ALREADY RUNNING"
b$="Only one instance of this program is allowed"
ERROR.SUCCESS=0
ERROR.ALREADY.EXISTS=183
lpSecurityDescriptor$=null$(1)              'this is equal to a null parameter in C/C++

sizelpSD=len(lpSecurityDescriptor$)         'length of my null parameter
SecurityDescriptor=GlobalAlloc(sizelpSD)    'allocate a mem block where I will place my null charactor
lpSecurityDescriptor=GlobalLock(SecurityDescriptor)     'pointer to the first byte in my mem block

call fillMemory lpSecurityDescriptor,lpSecurityDescriptor$,sizelpSD     'fill my mem block with my null charactor

struct securityAttributes,_
    nLength as long,_                   'length of securityAttributes.struct
    lpSecurityDescriptor as long,_      'pointer to my null string
    bInheritHandle as long              'non 0 allows this to be inheritable

securityAttributes.bInheritHandle.struct=0
securityAttributes.nLength.struct=len(securityAttributes.struct)
securityAttributes.lpSecurityDescriptor.struct=lpSecurityDescriptor

    singleInstance=maintainOneInstance()
    if singleInstance=ERROR.ALREADY.EXISTS then
        notice a$+chr$(13)+b$
        end
    end if

'everything above this line needs to be at the very start of your program
'*****************************this represents your program*************************************
nomainwin

    'slotmach.bas - a sample program for Liberty BASIC v1.3

    'Here is a simple slot machine demo created by Carl Gundel
    'Copyright 1997 Shoptalk Systems
    'Feel free to use this code in any Liberty BASIC project

    'Here is our window code
    WindowWidth = 360
    WindowHeight = 255
    graphicbox #main.gb1, 22, 61, 88, 65
    graphicbox #main.gb2, 134, 61, 88, 65
    graphicbox #main.gb3, 238, 61, 88, 65
    button #main, "Pull", [pullLever], UL, 278, 186, 56, 25
    open "Slot Machine" for window_nf as #main
    print #main, "trapclose [quit]"


[mainLoop]  'Main input loop

wait
  goto [mainLoop]


[pullLever]   'the user pulled the lever

wait
  goto [mainLoop]

'**************************************************************************
'closeMutex and globalFree must be called when you quit your program
[quit]
    hMutex=hM(1)
    mClosed=closeMutex(hMutex)         'close the Mutex so our program will start next time
    if mClosed=0 then
        notice "mutex not closed"
    end if

    fM=GlobalFree(lpSecurityDescriptor)     'free the mem block we allocated
    close #main                             'close our program window
    end                                     'end and allow LB to do its cleanup

function maintainOneInstance()
    name$="MyLibertyBasicProgram"+chr$(0)   'CAUTION this name must be different for each program that
    iOwner=1                                'you place this code in, 
    calldll #kernel32,"CreateMutexA",_      'Mutex means MUTually EXclusive
        securityAttributes as struct,_      'it is a device used to prevent shared resources from
        iOwner as long,_                    'being used by multiple objects at the same time
        name$ as ptr,_                      'you wouldn't want two apps writing to the same memory
        hMutex as ulong                     'at the same time.

    hM(1)=hMutex                            'Here we create a Mutex with a specific name, then
                                            'when ever we start our program, if a Mutex with the
    if hMutex=0 then                        'same name exists, the setLastError function called by
        notice "unable to continue"         'createMutex, sets an, "ERROR_ALREADY_EXISTS", error
        end                                 'value. Then we just check to see if this error is set,
    end if                                  'if it is we know that this program is already running.

    maintainOneInstance=result()            'result() is the call to GetLastError
end function

function closeMutex(hMutex)
    calldll #kernel32,"CloseHandle",_
        hMutex as long,_
        closeMutex as long
end function

function GlobalAlloc(dwBytes)
    'returns the handle of the newly allocated memory object.
    CallDll #kernel32, "GlobalAlloc",_
        _GMEM_MOVEABLE as long,_
        dwBytes as ulong,_
        GlobalAlloc as long
end function

function GlobalLock(hMem)
    'returns a pointer to the first byte of the memory block.
    CallDll #kernel32, "GlobalLock",_
        hMem as long,_
        GlobalLock as long
end function

function GlobalFree(hMem)
    CallDll #kernel32, "GlobalFree",_
        hMem as ulong,_
        GlobalFree as long
end function

function result()
    calldll #kernel32,"GetLastError",_
        result as long
end function

sub fillMemory dest,contents$,sizeofMem
    CallDll #kernel32,"RtlMoveMemory",_
        dest as long,_
        contents$ as ptr,_
        sizeofMem as long,_
        ret as void
end sub


