' recurse files.bas for LB3
' Mark Parkinson
' 08/10/02

' This program will list all the files in the whole directory structure
' which match the given file spec. A process called recursion is used.

' Feel free to use and adapt the program eg to sum the filespace used or
' delete files or rename files or move them.
' It is also easy to adapt the program to delete empty subdirectories.


dim info$(10, 10)                                'Ready for the files command.

placetohunt$="c:"                                'Note no backslash - added later on.
thingtohuntfor$="*.bak"

print "now listing all files in ";placetohunt$;" which match ";thingtohuntfor$
print

call recurse placetohunt$, thingtohuntfor$
print
print "finished"

end

sub recurse pathspec$,mask$
    pathspec$=pathspec$+"\"                      'Put in the backslash separator.
    files pathspec$, mask$, info$(

    filecount=val(info$(0, 0))
    subdircount=val(info$(0, 1))

for i=1 to filecount
    filename$= pathspec$+info$(i, 0)
    filesize$= info$(i, 1)
    datestamp$=info$(i, 2)
    print filename$;"     ";filesize$
next i

list$=""                                        'Arrays cannot be local to subs so the subdirs
for i=1 to subdircount                          'are all put in a string separated by *'s which
    list$=list$+pathspec$+info$(f + i, 1)+"*"   'can't occur in filenames.
next i

while list$<>""                                 'The subdirs are now pulled out of the (local)
    p=instr(list$,"*")                          'string one at a time and the sub is called again.
    p$=left$(list$,p-1)                         'This process where a sub calls itself
    call recurse p$,mask$                       'is called recursion.
    list$=mid$(list$,p+1)
wend

end sub



