WindowWidth = 512
WindowHeight = 384

UpperLeftX=int((DisplayWidth-WindowWidth)/2)        'we want the splash screen
UpperLeftY=int((DisplayHeight-WindowHeight)/2)      'centered on the display
Display(1)=DisplayWidth
Display(2)=DisplayHeight


graphicbox #1.splash,0,0,WindowWidth,WindowHeight       'we are ready to describe and
open "LB Hot Key" for window_popup as #1              'open our program window
loadbmp "display","hotkey.bmp"                          'which is our splash screen
print #1.splash,"down;drawbmp display 0 0"
print #1.splash,"flush"

h1=hwnd(#1)                             'get the handle to our window
call setWindowPos h1                    'make sure our splash screen is on top

timer 10000,[hide]                     'I hope to use this soon
wait                                   'instead of the while/wend
[hide]
timer 0
call showWindow h1,0

gosub [info]

nomainwin

ss=regHotKey(h1,21,0,_VK_SNAPSHOT)                              'screen shot hot key
ws=regHotKey(h1,22,_MOD_SHIFT+_MOD_ALT,_VK_SNAPSHOT)            'client area hot key
ms=regHotKey(h1,23,_MOD_ALT,_VK_SNAPSHOT)                       'active window hot key
eX=regHotKey(h1,24,_MOD_SHIFT+_MOD_ALT,_VK_F11)                 'end program hot key
if (ss=0) or (ws=0) or (ms=0) or (eX=0) then
    notice "REGISTER HOTKEY FAILED !"+chr$(13)+"This program will now exit."
    call endProgram h1
end if

open "WMLiberty.dll" for dll as #wmlib                          'message handler

callback hotKeyNotice,hotKey(ulong,long,long,long),long        'callback for hot key notice
calldll #wmlib, "SetWMHandler",_
        h1 As long,_                    'handle to the program window
        _WM_HOTKEY As long,_            'message to intercept
        hotKeyNotice As long,_          'address of callback in memory
        0 As long,_         'value to send to wmliberty.dll to indicate success
        ret As long

wait

[quit]
    call endProgram h1

sub endProgram h1
    close #info
    if ss then call unregisterHotKey h1,21         'here we clean up when the program exits
    if ws then call unregisterHotKey h1,22         'first we release all the hot keys
    if ms then call unregisterHotKey h1,23
    if eX then call unregisterHotKey h1,24
    unloadbmp "display"                 'free memory resources
    close #1                            'I found that you have to close the window before
    close #wmlib                        'closing the dll or we get an error.
    notice "LB HotKey Unloaded"         'thought that we should let the user know that the
    end                                 'program had unloaded from memory and ended.
end sub

function hotKey(hwnd,uMsg,wParam,lParam)    'our main concern is the loWord and hiWord of the lParam
    if hiword(lParam)=_VK_F11 then          'the hiWord contains the virtual key code for the key pressed
        a$="the EXIT program HotKey was pressed"
        call sendNotice a$
        notice "if you saw the EXIT notice you have been to a sub and back"
        call endProgram hwnd                'the loWord contains the modifier keys that were pressed
    else                                    'F11 is the close program key
    select case loword(lParam)
        case 0                              'no modifier keys were pressed with the printScreen key
            a$="the PRT-SCR HotKey was pressed"
            call sendNotice a$
            notice "if you saw the PRT-SCR notice you have been to a sub and back"
        case 1                              'the ALT key was pressed with the printScreen key
            x=0
            a$="the ALT+PRT-SCR HotKey was pressed"
            x=sendANotice(a$)
            if x=1 then notice "you have been to a function and back"
        case 5                              'the ALT+SHIFT keys were pressed with the printScreen key
            x=0
            a$="the ALT+SHIFT+PRT-SCR HotKey was pressed"
            x=sendANotice(a$)
            if x=1 then notice "you have been to a function and back"
    end select
    hotKey=0        'value to denote to wmliberty.dll that message was handled successfully
end function

Function regHotKey(hwnd,id,fsMods,vk)
    calldll #user32,"RegisterHotKey",_
        hwnd As Long,_                  'handle to the window that is registering the hot key
        id As Long,_                    'unique Identifier for the specific hot key
        fsMods As uLong,_                'modifier keys necessary to activate the hot key
        vk As uLong,_                    'virtual key code of hot key
        regHotKey As boolean
end function

sub unregisterHotKey hwnd,id
    calldll #user32,"UnregisterHotKey",_
        hwnd As Long,_                  'handle of window that owns the hot key
        id As Long,_                    'Identifier assigned to the hot key
        ret As Long
end sub

function increment()
    count(1)=count(1)+1
    increment=count(1)
end function

function loword(dw)
    loword = dw-(hiword(dw)*65536)          'the hiWord is multiplied by 65536 then the loWord is added to it then
end function                                'windows passes this total as lParam here we separate the words

function hiword(dw)
    hiword = int(dw/65536)
end function

function sendANotice(a$)
    notice a$               'here we show that we can call subs and functions from a callback
    sendANotice=1
end function

sub sendNotice a$
    notice a$               'here we show that we can call subs and functions from a callback
end sub

sub setWindowPos hwnd
    wFlags=_SWP_NOMOVE or _SWP_NOSIZE
    place=0 or -1                       'negative numbers must be combined with 0 using the bitwise OR in order to pass them to the API function
    calldll #user32,"SetWindowPos",_
        hwnd as long,_                  'handle to window that is to be reordered
        place as long,_                 'in this case we will make it topmost
        0 as long,_                     'these values are ignored because of the
        0 as long,_                     'NOMOVE and NOSIZE flags
        0 as long,_
        0 as long,_
        wFlags as long,_                'window control and ordering flags
        ret as long
end sub

sub showWindow hwnd,nCmdShow
    calldll #user32, "ShowWindow",_
        hwnd as Long,_                  'handle of window to recieve message
        nCmdShow as Long,_              'message to send in this case 0=_SW_HIDE
        ret as Long
end sub

[info]
    nomainwin

    a$="This Window will Minimize in 20 seconds."
    a1$="Closing this window will exit the hotKey program"
    b$="The HotKeys for this program are as follows:"
    c$="PRT-SCR (the Print Screen key)"
    d$="ALT+PRT-SCR"
    e$="ALT+SHIFT+PRT-SCR"
    f$="ALT+SHIFT+F11  (EXIT this program)"

    WindowWidth=425
    WindowHeight=400

    statictext #info.a, a$, 10,25,400,25
    statictext #info.a1, a1$, 10,75,400,25
    statictext #info.b, b$, 10,125,400,25
    statictext #info.c, c$, 10,175,400,25
    statictext #info.d, d$, 10,225,400,25
    statictext #info.e, e$, 10,275,400,25
    statictext #info.f, f$, 10,325,400,25

    open "Information Window" for dialog as #info
    #info "trapclose [quit]"
    #info "font fixedsys 9"
    h2=hwnd(#info)

    timer 15000, [mini]
    wait
[mini]
    timer 0

    call showWindow h2,6
return


