'Tip of the Day Demonstration Code
'by David Drake

'===Create a plain window for demonstration purposes
    nomainwin
    WindowWidth = 200
    WindowHeight = 200
    UpperLeftX=int((DisplayWidth-WindowWidth)/2)
    UpperLeftY=int((DisplayHeight-WindowHeight)/2)

    menu #main, "Help","Show Tip of the Day",[showTips]
    open "untitled" for window as #main

    gosub [TipOfTheDay]
    wait


[showTips] 'This calls the tip window
    forceTips = 1 ' Set this value to 1 to make tips show regardless
                  'of "Show Tips at Startup" value. Useful for making
                  'tips accessible from a Help menu.
    gosub [TipOfTheDay]
    wait

[quit] 'End the program
    close #main
    end


'===============================
'===Start of Tip of The Day Code
'===============================
[TipOfTheDay] ' Tip of the Day window
    'Tip of the Day code
    'created November 2002 by David Drake (ddrake@foundrysearch.com)
    'DLL calls taken from Alyce Watson's Mastering LB3 book
    'Use this code freely

    '===Insert this code into your program.
    '===Assign your program's name to the AppName$ variable
    '===Create a file called "tips.dat" in the default directory of your program.
    '===Type in your tips placing a single carriage return between each tip.
    '===This routine keys off of the number of days since 1901.  Please do NOT
    '===put more than 100 tips in a tip.dat file.
    '===Call with a "gosub [TipOfTheDay].

    '===Set up variables
    AppName$ = "My Program" 'Alter this to suit you
    tipMessage$ = "Did you know..." 'Alter this to suit you
    dim tips$(99) ' No more than 100 tips, please
    dim tipInfo$(10,10) ' Used for checking file existance
    tipCount = -1 'Number of tips in file (do not alter this initial value!)
    todaysTip = 0 'Do not alter this initial value!

    '===Load tips.dat file
    files DefaultDir$, "tips.dat", tipInfo$(
    if val(tipInfo$(0, 0)) <= 0 then [skipTips] ' if file does not exist, return
    open "tips.dat" for input as #totd
    while not(eof(#totd))
        line input #totd, TEMP$
        tipCount = tipCount+1
        tips$(tipCount) = TEMP$
    wend
    close #totd

    '===Check whether tips are allowed to start
    '===If the last line in the tips file reads "no tips" then tips won't start
    '===unless forceTips = 1
    if tips$(tipCount) = "no tips" and forceTips = 0 then [skipTips]
    if tips$(tipCount) = "no tips" then tipCount = tipCount - 1

    '===Create the TOTD window
    tipsOpen = 1 ' Tips window is open - Check for it at exit of program!
    WindowWidth = 367
    WindowHeight = 248

    BackgroundColor$ = "buttonface"
    ForegroundColor$ = "black"

    graphicbox #totd.gb1, 5, 5, 270, 185
    statictext #totd.text, "Here is a faux tip which has quite a bit of text in it, don't you know.", 10, 45, 260, 140
    checkbox #totd.tipsOn, "Show Tips at Startup", [totd.noTipsAtStartup], [totd.tipsAtStartup], 5, 195, 171, 25
    button #totd.nextTip, "Next Tip", [nextTip], UL, 290, 40, 65, 25
    button #totd.default, "OK", [closeTips], UL, 290, 5, 65, 25

    '===This opens a modal window to ensure that the user closes it before moving on
    open AppName$+" Tip of the Day" for dialog_modal_nf as #totd

    '===Required centering workaround for modal windows
    hTip = hWnd(#totd)
    x = int((DisplayWidth-WindowWidth)/2)
    y = int((DisplayHeight-WindowHeight)/2)
    CallDLL #user32, "MoveWindow",_
        hTip As long,_
        x As long,_
        y As long,_
        367 As long,_
        248 As long,_
        1 As boolean,_
        result As boolean

    '===Add a few flourishes and wrap things up
    print #totd.gb1, "down;fill buttonface;backcolor buttonface;font arial 14;place 40 22;\";tipMessage$
    '===If you don't like the tip.bmp image, change it
    '===If you don't want an image, delete or rename the tip.bmp file
    files DefaultDir$, "tip.bmp", tipInfo$( 'Check for the tip.bmp picture
    if val(tipInfo$(0, 0)) > 0 then ' if file exists
        loadbmp "tip","tip.bmp"
        print #totd.gb1, "place 1 1;drawbmp tip;flush;"
        unloadbmp "tip"
    end if
    print #totd, "font ms_sans_serif 0 16"
    print #totd, "trapclose [closeTips]"

    '===Find today's tip (uses last two digits of the days since 1901)
    dayNumber = date$("days")
    dayNumber = val(right$(str$(dayNumber),2))
    for tipLoop = 1 to dayNumber
        todaysTip = todaysTip+1
        if todaysTip > tipCount then todaysTip = 0
    next tipLoop

    '===Set the Show Tips at Startup checkbox to the correct state
    if tips$(tipCount+1) = "no tips" then
        notips = 1
        #totd.tipsOn "reset"
    else
        notips = 0
        #totd.tipsOn "set"
    end if

    '===Write the tip to the texteditor control
    text$ = tips$(todaysTip)
    #totd.text text$

    #totd.default "!setfocus" 'Set focus to the CLOSE button

    [skipTips] '===Skip here if not showing tips
    return

    [totd.noTipsAtStartup] '===Set to not show tips at activation
        notips = 0
        wait

    [totd.tipsAtStartup] '===Set to show tips at activation
        notips = 1
        wait

    [nextTip] '===Show next tip
        todaysTip = todaysTip + 1
        if todaysTip > tipCount then todaysTip = 1
            text$ = tips$(todaysTip)
            #totd.text text$
        wait

    [closeTips] '===Close the tips window
        close #totd
        tipsOpen = 0

        '=== Alter tip file to prevent startup tips
        '=== by adding "no tips" to last line of tips.dat file
        if notips = 1 and tips$(tipCount+1) <> "no tips" then
            open "tips.dat" for append as #tips
            #tips "no tips"
            close #tips
        end if

        '=== Alter tip file to allow startup tips
        '=== by removing "no tips" from last line of tips.dat file
        if notips = 0 and tips$(tipCount+1) = "no tips" then
            open "tips.dat" for output as #tips
            for tipLoop = 1 to tipCount
                #tips tips$(tipLoop)
            next tipLoop
            close #tips
        end if
        wait
'===============================
'===End of Tip of The Day Code
'===============================

