'Tip of the Day Demonstration Code
'by David Drake

'===Create a plain window for demonstration purposes
    nomainwin
    WindowWidth = 200
    WindowHeight = 200
    UpperLeftX=int((DisplayWidth-WindowWidth)/2)
    UpperLeftY=int((DisplayHeight-WindowHeight)/2)

    menu #main, "Help","Show Tip of the Day",[showTips]
    open "untitled" for window as #main

    gosub [TipOfTheDay]
    wait


[showTips] 'This calls the tip window
    forceTips = 1 ' Set this value to 1 to make tips show regardless
                  'of "Show Tips at Startup" value. Useful for making
                  'tips accessible from a Help menu.
    gosub [TipOfTheDay]
    wait

[quit] 'End the program
    close #main
    end


'===============================
'===Start of Tip of The Day Code
'===============================
[TipOfTheDay] ' Tip of the Day window
    'Super Simple Tip of the Day code
    'created November 2002 by David Drake (ddrake@foundrysearch.com)
    'Use this code freely

    '===Insert this code into your program.
    '===Assign your program's name to the AppName$ variable
    '===Create a file called "tips.dat" in the default directory of your program.
    '===Type in your tips placing a single carriage return between each tip.
    '===This routine keys off of the number of days since 1901.  Please do NOT
    '===put more than 100 tips in a tip.dat file.
    '===Call with a "gosub [TipOfTheDay].

    '===Set up variables
    AppName$ = "My Program" 'Alter this to suit you
    tipMessage$ = "Did you know..." 'Alter this to suit you
    dim tips$(99) ' No more than 100 tips, please
    dim tipInfo$(10,10) ' Used for checking file existance
    tipCount = -1 'Number of tips in file (do not alter this initial value!)
    todaysTip = 0 'Do not alter this initial value!

    '===Load tips.dat file
    files DefaultDir$, "tips.dat", tipInfo$(
    if val(tipInfo$(0, 0)) <= 0 then [skipTips] ' if file does not exist, return
    open "tips.dat" for input as #totd
    while not(eof(#totd))
        line input #totd, TEMP$
        tipCount = tipCount+1
        tips$(tipCount) = TEMP$
    wend
    close #totd

    '===Find today's tip (uses last two digits of the days since 1901)
    dayNumber = date$("days")
    dayNumber = val(right$(str$(dayNumber),2))
    for tipLoop = 1 to dayNumber
        todaysTip = todaysTip+1
        if todaysTip > tipCount then todaysTip = 0
    next tipLoop

    tiptext$ = ""
    for tipLoop = 1 to 500
        TEMP$ = word$(tips$(todaysTip),tipLoop)
        if TEMP$<>"" then
            tiptext$ = tiptext$ + TEMP$ + " "
            tipWordCount = tipWordCount+1
            if tipWordCount > 4 then
                tipWordCount = 0
                tiptext$=tiptext$+chr$(13)
            end if
        if TEMP$ = "" then tipLoop = 1000
        end if
    next tipLoop

    text$ = AppName$+" Tip of the Day"+chr$(13)+tipMessage$+chr$(13)+tiptext$
    notice text$
    wait
