'** Platform for Tip-Of-The-Day
'** Tip of Day Module is at end of code.
'** Alyce Watson, 2002, Released to the Public Domain

[InitColors]
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"

[WindowSetup]
    NoMainWin
    WindowWidth = 300 : WindowHeight = 300
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Statictext  #main.static1, "Your Tip-Of-The-Day Demonstration!",_
    30, 95, 230, 20
Button      #main.btnExit, "Exit",[Exit.App],UL, 200, 235, 80, 25
Button      #main.show, "Show Tips",[startTips],UL,200,200,80,25

Open "Platform for Tip-Of-The-Day" For Window As #main

    Print #main, "trapclose [Exit.App]"
    Print #main, "font arial 10"

''''''''''''''''''''''''''''''''''''''''''''''''
'Since Tips of the Day usually appear after
'the main window of an application has been
'opened, your TOTD mini-app should probably
'be called from this location
''''''''''''''''''''''''''''''''''''''''''''''''
goto [doTip]

[loop]
    Wait

[Exit.App] Close #main : End

[startTips]'open the Tip Window manually
           'setting flag in ini file to
           'show tips at startup
    open "tipdayaw.ini" for output as #f
    print #f, "yes"
    if index<=0 then index=1
    print #f, index
    close #f


''''''''''''''''''''''''''''''''''''''''''''''''
'''''''''''''''Begin TOD Module'''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''''''
[doTip]

    'see if ini file exists by opening for append
    'and checking length:
    open "tipdayaw.ini" for append as #f
    fileLen=lof(#f)
    close #f

    'if ini file doesn't exist, create it
    'with default of *yes*, index of 1
    if fileLen=0 then
        open "tipdayaw.ini" for output as #f
        print #f, "yes"
        print #f, "1"
        close #f
    end if

    'now, check if user wants to see tips
    'at startup:
    open "tipdayaw.ini" for input as #f
    input #f, doTip$
    input #f, Index$
    index=val(Index$)
    close #f

    'if no tips at startup, then stop here
    doTip$=lower$(doTip$)
    if doTip$="no" then wait

    total=7 'set total number of tips
    dim tips$(total)
    if index>total then index=1 'index of tip to be displayed

    'set data reading to beginning of data statements:
    RESTORE

    'read tips into array, so they can be cycled easily
    for i = 1 to total
        read t$
        tips$(i)=t$
    next

    anifile$ =  "torchani.avi"  'avi file name

    'constants
    class$           = "SysAnimate32"
    ACS.TRANSPARENT  = 2    'transparent background
    ACS.AUTOPLAY     = 4    'play as soon as opened
    ACM.OPEN         = 1124 'open file

    'initialize common controls:
    calldll #comctl32, "InitCommonControls",_
    re as void

    ' Open tip window
    WindowWidth = 305: WindowHeight = 220
    UpperLeftX = 10  : UpperLeftY = 10
    BackgroundColor$="white"

button #totd.default, "Exit",[quitTip],UL,220,10,70,24
button #totd.next, "Next Tip",[next],UL,220,40,70,24
statictext #totd.tip, "Tip",40,10,160,130
checkbox #totd.show,"Show Tips at Startup?",[showTip],[noTip],_
    10,150,200,24
open "Tip of the Day! " for dialog_modal as #totd
print #totd, "trapclose [quitTip]"

    'print first tip:
    #totd.tip tips$(index)
    'check checkbox
    #totd.show "set"

    hwndParent = hwnd(#totd)

    ' Get window instance handle
    CallDLL #user32, "GetWindowLongA",_
    hwndParent As long,_GWL_HINSTANCE As long,_
    hInstance As long   'instance handle

    ' Create animation control, use autoplay flag
    style = _WS_CHILD or _WS_VISIBLE or ACS.AUTOPLAY or ACS.TRANSPARENT

    calldll #user32, "CreateWindowExA",_
    0 As long,_                  ' extended style
    class$ as ptr,_              ' class name
    "" as ptr,_
    style as long,_              ' style
    10 as long,_                 ' left x
    10 as long,_                 ' top y
    0 as long,_                  ' width
    0 as long,_                  ' height
    hwndParent as long,_         ' parent hWnd
    0 as long,_
    hInstance as long,_          ' hInstance
    "" as ptr,_
    hwndAC as long               ' animation control handle


    'send message to open file, which will play automatically
    calldll #user32, "SendMessageA",_
    hwndAC as long,ACM.OPEN as long,_
    0 as long,anifile$ as ptr,_
    re as long

    wait

[next]'increment index, show next tip
    index=index+1
    if index>total then index=1
    #totd.tip tips$(index)
    wait

[showTip]'user checked box to show tips at startup
    open "tipdayaw.ini" for output as #f
    print #f, "yes"
    print #f, index+1 'current tip number plus 1
    close #f
    wait

[noTip]'user unchecked box to show tips at startup
    open "tipdayaw.ini" for output as #f
    print #f, "no"
    print #f, index+1 'current tip number plus 1
    close #f
    wait

[quitTip]
    'does user want to show tips at startup?
    'retrieve value from checkbox:
    #totd.show "value? show$"
    if show$="set" then
        doTip$="yes"
    else
        doTip$="no"
    end if

    'update ini file
    open "tipdayaw.ini" for output as #f
    index=index+1
    print #f, doTip$
    print #f, index 'index for next tip
    close #f
    close #totd : wait

'data for tips
'you must have at least as many data items as
'set in variable called *total* at top of code
DATA "To create a window with no titlebar or sizing frame, use the window_popup style.  Fill it with a graphicbox to simulate a graphics window."
DATA "Specify an extension of .default for a button in a dialog window, and it will be activated when the user presses ENTER."
DATA "If your graphics disappear, you need to include a FLUSH command to make them persist."
DATA "Arguments for trig functions like COS() and SIN() should be in radians.  There are approximately 57 degrees in each radian."
DATA "Liberty BASIC texteditor controls are special Smalltalk widgets that do not respond to Windows EDIT control messages."
DATA "To learn more about using Animation Controls, which are Windows Common Controls created by API, check the eBook, 'Mastering Liberty BASIC 3'."
DATA "For lots of good articles, tutorials, tips, and demo programs, see The Liberty BASIC Newsletter!"

''''''''''''''''''''''''''''''''''''''''''''''''
''''''''''''''' End  TOD Module'''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''''''

