'** open32_06.bas
'** Open Source Editor v32.06
'** Please add your name to
'** the list of authors and
'** give your version a unique filename.
'** Filenames of the form open32_xx.bas
'** are used by the newsletters, so please
'** choose a completely different filename
'** for your version, to avoid confusion.
'** You might want to add your initials to
'** your filename - open32_cg.bas for instance.
'**
'** Authors:
'**
'** Alyce Watson
'** Brent Thorn      - tooltip routines and cascading popup menu
'** David Szafranski - launch browser with URL & launch email
'** September 2000   - added recent files menu list by Brent Thorn
'** January 2001     - adding runtime engine for LB2 w/command line
'** Doyle Whisenant  - array-maker similar to LB Workshop tool
'** AW-March 2001    - removed caret creation functions, which didn't always work correctly
'** AW-March 2001    - added recent files list to ini file
'** AW-March 2001    - modified recent files menu list to show filenames
'** AW-July 2001     - ported to LB3
'                    - * changed API calls for ShellExecuteA, SetWindowTextA,
'                    - *     and ModifyMenuA
'                    - * removed code library, which was LB2 syntax
'                    - * fixed look of array maker for LB3
'                    - * changed bmp dimension functions for bmp previewer
'                    - * fixed drawing bmpbutton for LB3 - added fill
'                    - *     and backcolor of buttonface
'                    - * condensed font commands for controls in bmp previewer
'                    - * added pen color tattletale to bmp previewer
'                    - * changed color choice in bmp previewer to colordialog
'** Brent Thorn      - Updated his tooltip routine, July, 2001
'** AW-January 2002  - Cleanup and more LB3 updating and comments
'                      * more updates to tooltips
'                      * removed help-tutorial menu and button
'                      * changed helpfile engine to winhlp32
'** AW-February 2002 - Added multiple textbox colors to bmp previewer and array maker
'** AW-March 2002    - Made XP compatible
'                      * changed externals winfile.exe to explorer.exe
'                      * changed externals paintbrush to SearchTreeForFile for mspaint.exe
'                      * added *.lba extension

'** AW-November 2002 - Added real windows toolbar
'                      * modified tooltips to work with toolbar
'                      * removed opening of dlls, used handles #user32, etc.
'                      * added error trapping if liberty.exe not found
'
'** AW-March 2003    - Added #include file capability
'                      * allows program with include files to be saved as project
'                      * checks for included files when program in editor is to run
'                      * now brings help window to top if already open
'                      * added project help window
'                      * tightened tooltip code
'
'
'

    If Val(Version$)<3 Then
        Notice "This program is meant for in LBv3.x!"
        End
    End If

    Cursor hourglass
    NoMainWin


    Dim info$(10,10)        'for file exist check
    Dim branch$(100)        'array to hold branch labels
    Dim code$(100)          'array to hold code titles
    Dim recentfiles$(3)     'array to hold recent files


'variables:
'file$              name of file to open
'title$             titlebar caption
'h                  is window handle
'hwndTT             is tooltip control handle
'hTB                is toolbar handle
'modflag$           is answer to modified query
'answer$            receiver variable for confirm messages
'tempfilename$      name to use when running and debugging code
'rowVar,columnVar   location of texteditor origin
'fileindex          used for counter in path/file separation
'filelength         used for counter in path/file separation
'shortFile$         just filename without path
'filePath$          path without filename
'saveit$            receiver for input from texteditor
'libertyexe$        path to Liberty.exe for running/tokenizing/debugging
'tknfile$           name of tkn to run
'hInstance          window instance handle
'rowcount           number of lines in editor
'line$              contents of line in editor
'bx                 counter variable for branch label loading
'branchlength       length of branch label
'branchselect$      branch label selection
'picFile$           filename for opened bitmap
'savebmpfile$       name to save bmp AS
'bmpwidth           width of bitmap
'bmpheight          height of bitmap
'xbmp               x location to draw bitmap in graphicbox
'ybmp               y location to draw bitmap in graphicbox
'bmploaded          flag to set when a bitmap is loaded
'message$           string variable to hold notice and confirm messages
'printFile$         temporary file for printing with Notepad
'wavPath$           path to last wav played
'wavFile$           name of wav file to play
'slash              counter variable to separate wav path from filename
'setFont$           LB fontname and size info for chosen font
'timemsg$           variable to hold time info
'datemsg$           variable to hold date info
'RunFile$           for ShellExecute
'lpOperation$       for ShellExecute
'lpParameters$      for ShellExecute
'lpDirectory$       for ShellExecute
'nShowCmd           show window flag for ShellExecute
'helpopen           flag for help window opening
'bString            flag for array string
'bNumeric           flag for array numeric
'i                  index var for general use
'a                  index var for general use
'arrayName$         name of array
'arrayItem$         individual array items
'myarray$()         variable for generating array items
'ArrayFileName$     name of file opened for creating array
'line$              file input variable
'rfile$             dummy file name for input from ini file
'hmenuRecent        handle of recent files menu popup
'menuString$        caption of menu item
'menuID             ID of menu item
'comExt$            extensions for running from command line
'RootPath$          for finding mspaint w/SearchTreeForFile
'InputPathName$     for finding mspaint w/SearchTreeForFile
'OutputPathBuffer$  for finding mspaint w/SearchTreeForFile



    ForegroundColor$=   "darkblue"
    TexteditorColor$=   "lightgray"
    drawcolor$=         "0 0 0"     'default color for drawing on bitmaps
    decnum$=            "255"       'default starter for number conversion
    decnum=             Val(decnum$)
    hexnum$=            "FF"        'default starter for number conversion


Menu #1, "&File",_
    "&New",               [new],_
    "&Open",              [open],_
    "&Save",              [save],_
    "Save &As",           [saveas],|,_
    "Save Pro&ject",      [project],|,_
    "&Print",             [print],_
    "E&xit",              [quit],_
    "&Recent",            [loop]

Menu #1, "Edit" 'LB supplies the Edit Menu

Menu #1, "Recent",_
    "File 1",             [File_1],_
    "File 2",             [File_2],_
    "File 3",             [File_3]

Menu #1, "&Run",_
    "Ru&n",               [run],_
    "&Debug",             [debug],_
    "&Make TKN",          [maketkn],_
    "Run &TKN",           [runtkn],_
    "&Change Icon",       [runtimeIcon]

Menu #1, "E&xternals",_
    "&MS Paint",          [paint],_
    "&Explorer",          [winfile],_
    "&Notepad",           [notepad],_
    "&Calculator",        [calculator]

Menu #1, "&Tools",_
    "&Branch Labels",        [branchlabels],_
    "Bit&map Preview",       [bmp],_
    "&Wav Preview",          [wav],_
    "&Array Maker",          [makeArrays],_
    "Font &Dialog",          [fontdialog],_
    "&Number Tools",         [numbertools],_
    "Time and D&ate",        [timetools],|,_
    "Libert&y BASIC Website",[libertyhome],_
    "Email Carl &Gundel",    [emailcarl]


Menu #1, "&Help",_
    "&Liberty BASIC Help", [help],_
    "&Editor Help",        [edithelp],_
    "&Project Help",       [projecthelp],_
    "&About",              [about]



    WindowWidth=640:WindowHeight=480
    Texteditor #1.t, 0,50,600,390  'edit window

'hidden buttons used by toolbar code:
    Button #1.hide0, "",  [new],        UL, -400, -400, 0, 0
    Button #1.hide1, "",  [open],       UL, -400, -400, 0, 0
    Button #1.hide2, "",  [save],       UL, -400, -400, 0, 0
    Button #1.hide3, "",  [saveas],     UL, -400, -400, 0, 0
    Button #1.hide4, "",  [print],      UL, -400, -400, 0, 0
    Button #1.hide5, "",  [run],        UL, -400, -400, 0, 0
    Button #1.hide6, "",  [debug],      UL, -400, -400, 0, 0
    Button #1.hide7, "",  [maketkn],    UL, -400, -400, 0, 0
    Button #1.hide8, "",  [paint],      UL, -400, -400, 0, 0
    Button #1.hide9, "",  [winfile],    UL, -400, -400, 0, 0
    Button #1.hide10, "", [notepad],    UL, -400, -400, 0, 0
    Button #1.hide11, "", [calculator], UL, -400, -400, 0, 0
    Button #1.hide12, "", [help],       UL, -400, -400, 0, 0
    Button #1.hide13, "", [quit],       UL, -400, -400, 0, 0


Open "Open Source LB Editor" For Window As #1

    h=hWnd(#1)
    hText=hWnd(#1.t)
    Print #1, "trapclose [quit]"
    Print #1, "resizehandler [resize]"


    CallDLL #user32, "ShowWindow",h As Long,_SW_MAXIMIZE As Long,result As Long

    Print #1.t, "!font courier_new 10"
    Print #1.t, "!setfocus";
    GoSub [remove.menu]
    GoSub [read.ini.file]
    GoSub [MakeToolbar]

[check.command]  'if CommandLine$ contains a filename, it will be loaded at startup
    If CommandLine$<>"" Then
        CommandLine$=Lower$(Trim$(CommandLine$))
        comExt$=Right$(CommandLine$,3)
        If comExt$="bas" or comExt$="lba" Then
            i=Len(CommandLine$)
            While Mid$(CommandLine$,i,1)<>" " and i>1
                i=i-1
            Wend
            file$=Mid$(CommandLine$,i)
            GoTo [loadFile]
        End If
    End If

    Cursor normal

Wait

[loop]
    Wait


[quit]
    GoSub [isModified]
    Close #1
    If tempfilename$<>"" Then Kill tempfilename$
    GoSub [write.ini.file]
    CallDLL #gdi32, "DeleteObject",_
        hbmpTools As Long, ret As Boolean
    End


[isModified]'** CHECK TO SEE IF FILE HAS BEEN MODIFIED
    Print #1.t, "!modified?":Input #1.t, modflag$
    If modflag$="true" Then
        Confirm "This file has been modified.  Save?";answer$
        If answer$="yes" Then GoSub [savesub]
    End If
    Return


[resize]'** LOCATE TEXT EDITOR
    '** LOCATE TEXTEDITOR 30 PIXELS FROM TOP OF CLIENT AREA
    Print #1.t, "!locate 0 30 ";WindowWidth-1;" ";WindowHeight-31
    Print #1.t, "!origin?";
    Input #1.t, rowVar,columnVar

    '** UPDATE WINDOW
    Print #1, "refresh"
    Print #1.t, "!origin ";rowVar;" ";columnVar;"";
    Wait


[new]'** CLEAR EDITOR CONTENTS, RESET VARIABLES
    GoSub [isModified]
    Print #1.t, "!cls"
    file$="untitled.bas"
    filePath$=""
    GoSub [settext]
    Wait


[open]  'added lba extension
    GoSub [isModified]
    FileDialog "Open file..",filePath$+"*.bas;*.lba",file$ 
    If file$="" Then Wait
    GoSub [recent.files]


[loadFile]'** OPEN FILE AND LOAD INTO TEXTEDITOR
    shortFile$=SeparateFile$(file$)
    filePath$=SeparatePath$(file$)

    If FileExist(filePath$,shortFile$)<1 Then
        Notice "Error"+Chr$(13)+"File does not exist."
        Wait
    End If

    Cursor hourglass
    Open file$ For Input As #file
    Print #1.t, "!contents #file"
    Close #file
    GoSub [settext]
    Print #1.t, "!origin 1 1";
    Cursor normal
    Wait


[settext]'** ADD FILENAME TO TITLEBAR
    title$="Open Source LB Editor "+file$
    CallDLL #user32, "SetWindowTextA", h As Long, title$ As Ptr, result As Void
    Return


[saveas]'** SAVES CONTENTS AS file$ - added lba extension
    FileDialog "Save file as..",filePath$+"*.bas;*lba",file$ 
      If file$="" Then
        Notice "You must choose a file name."
        Wait
      End If
    GoSub [settext]


[save]'** SAVES CURRENT FILE
    GoSub [savesub]
    Wait


[savesub]
    Cursor hourglass
    Print #1.t, "!contents? saveit$";

    '** IF THERE IS NO CURRENT FILENAME, ASK USER FOR ONE
    If (Right$(file$,12)="untitled.lba") or (file$="") Then
        FileDialog "Save file as...",filePath$+"*.bas;*.lba",file$ 
          If file$="" Then
            Notice "You must choose a file name."
            Return
          End If
    End If

    Open file$ For Output As #file
    Print #file, saveit$
    Close #file

    Cursor normal
    Notice "File saved as "+ file$
    Return


[project]
    #1.t "!Line 1 include$"
    If Instr(include$,"'include",1)=0 Then
        Notice "This file does not have included files.  Please save using the File->Save option."
        Wait
    End If

    FileDialog "Save file as...",filePath$+"*.bas;*.lba",project$ 
      If project$="" Then
        Notice "You must choose a file name."
        Wait
      End If

    GoSub [saveProject]  'save primary file with filename project$
    GoSub [addToProject] 'add included files
    Notice "Project saved as "+ project$
    Wait


[saveProject] 'saves contents of editor as project$
    Cursor hourglass
    Print #1.t, "!contents? saveit$";

    Open project$ For Output As #file
    Print #file, saveit$
    Close #file
    Cursor normal
    Return


[addToProject]  'appends files to project$
                'Add included files to disk file.
                'Included files must be in same folder
                'as main project file.
    i=1 'set counter var to first line
    While i>0
        #1.t "!Line ";i;" include$"
        If Instr(include$,"'include",1)>0 Then
            'get filename, after include directive:
            includeFile$=Right$(include$,Len(include$)-9)
            includeFile$=Trim$(includeFile$)    'trim blank spaces

            i=i+1   'increment line number to check for includes

            'see if such a file exists, abort if not
            If FileExist(DefaultDir$,includeFile$)<1 Then
                i=0
                Exit While
            End If

            'get contents of include file into var saveit$
            Open DefaultDir$ + "\" + includeFile$ For Input As #f
            saveit$=Input$(#f, Lof(#f))
            Close #f

            'add contents of include file to disk file
            Open project$ For Append As #f
            Print #f, saveit$
            Close #f
        Else
            i=0
            Exit While
        End If
    Wend
    Return


[print]
    'save file as a temporary file
    'and cause it to be printed with
    'the  user's default text editor
    Cursor hourglass
    Print #1.t, "!origin?";
    Input #1.t, rowVar,columnVar
    Print #1.t, "!contents?";
    Input #1.t, saveit$ 

    Open "tempedit.txt" For Output As #tprint
        Print #tprint, saveit$
    Close #tprint

    printFile$ = "tempedit.txt"+Chr$(0)

    Open "shell32" For DLL As #shell
    CallDLL #shell, "ShellExecuteA", _
        h As Long, _
        "print" As Ptr, _
        printFile$ As Ptr, _
        "" As Ptr, _
        DefaultDir$ As Ptr, _
        _SW_HIDE As Long, _
        result As Long
    Close #shell

    Print #1.t, "!origin ";rowVar;" ";columnVar;"";
    Cursor normal
    Wait


[readyRun]'** MAKE A TEMP FILE TO RUN IN LIBERTY BASIC
    '** GET CURRENT TEXTEDIT ORIGIN
    Print #1.t, "!origin? rowVar,columnVar";

    'first, check for included files:
    #1.t "!Line 1 include$"
    If Instr(include$,"'include",1)<>0 Then
        project$=filePath$+"tempfile.bas"
        GoSub [saveProject]     'save primary file with filename project$
        GoSub [addToProject]    'add included files
        tempfilename$=project$  'temp file name to run
    Else
         '** GET CONTENTS OF TEXTEDITOR AND SAVE TO TEMPFILE
        If tempfilename$<>"" Then Kill tempfilename$
        Print #1.t, "!contents? saveit$"
        tempfilename$=filePath$+"tempfile.bas"
        Open tempfilename$ For Output As #temp
        Print #temp, saveit$
        Close #temp
    End If

    If libertyexe$="" Then GoSub [findLiberty]
    Return


[findLiberty]'** FIND LIBERTY.EXE
    FileDialog "Find Liberty.exe","*.exe",libertyexe$ 
    Return

[run]
    GoSub [readyRun]
    If libertyexe$="" Then
        Notice "Liberty.exe not found."
        Wait
    End If
    Run libertyexe$+" -R -A  "+tempfilename$
    Print #1.t, "!origin ";rowVar;" ";columnVar;"";
    Wait

[debug]
    GoSub [readyRun]
    If libertyexe$="" Then
        Notice "Liberty.exe not found."
        Wait
    End If
    Run libertyexe$+" -D -A -M "+tempfilename$
    Print #1.t, "!origin ";rowVar;" ";columnVar;"";
    Wait

[runtkn]
    FileDialog "Choose TKN..","*.TKN",tknfile$
    Run tknfile$
    Wait

[maketkn]
    GoSub [readyRun]
    If libertyexe$="" Then
        Notice "Liberty.exe not found."
        Wait
    End If
    Run libertyexe$+" -T "+tempfilename$
    Print #1.t, "!origin ";rowVar;" ";columnVar;"";
    Wait



[paint]
    'change to make XP compatible
    Cursor hourglass
    RootPath$="c:\"
    InputPathName$="mspaint.exe" + Chr$(0)   'filename only
    OutputPathBuffer$=Space$(1023)+Chr$(0)

    Open "imagehlp" For DLL As #ih
    CallDLL #ih, "SearchTreeForFile",_
        RootPath$ As Ptr,_
        InputPathName$ As Ptr,_
        OutputPathBuffer$ As Ptr,_
        ret As Long
        Close #ih

    If ret=0 Then
        Notice InputPathName$;" not found."
    Else
        Run Trim$(OutputPathBuffer$), SHOWNORMAL
    End If
    Cursor normal
    Wait


[notepad]
    Run "notepad.exe", SHOWNORMAL
    Wait

[winfile]
    'change to make XP compatible
    Run "explorer.exe",SHOWNORMAL
    Wait

[calculator]
    Run "calc.exe" ,SHOWNORMAL
    Wait



[help]
    'changed help engine from
    'winhelp to winhlp32 for LB3,
    'which is 32-bit
    Run "winhlp32 liberty3.hlp"
    Wait


[branchlabels]
    '** OPEN DIALOG, FILL LISTBOX WITH BRANCH LABELS
    Cursor hourglass
    WindowWidth=420:WindowHeight=440
    Button #2.okay,   "OKAY",  [branch],      UL, 320,10,80,26
    Button #2.cancel, "CANCEL",[cancelbranch],UL, 320,40,80,26
    Combobox #2.branch, branch$(, [branch],10, 10, 300,380
    Open "Branch Labels" For Dialog_modal As #2

    Print #2.branch,  "font Courier_New 0 16"
    Print #2.okay,   "!font Courier_New 0 20"
    Print #2.cancel, "!font Courier_New 0 20"

    Print #1.t,"!lines";
    Input #1.t, rowcount
    Print #1.t, "!origin?";
    Input #1.t, rowVar,columnVar

    rowcount=Int(rowcount)
    REDIM branch$(rowcount)
    branch$(0)="<start>"

    bx=1
    For i=1 to rowcount
        Print #1.t,"!line ";i;"";
        Input #1.t, line$ 
            If Left$(Trim$(line$),1)="[" Then
                branch$(bx)=Trim$(line$)
                bx=bx+1
            End If
            If Lower$(Word$(line$,1))="function" Then  'improved by Carl Gundel
                branch$(bx)=Trim$(line$)
                bx=bx+1
            End If
            If Lower$(Word$(line$,1))="sub" Then  'improved by Carl Gundel
                branch$(bx)=Trim$(line$)
                bx=bx+1
            End If
    Next i

    Sort branch$(,0,bx

    Print #2.branch,"reload"
    Print #2.branch, "selectindex 1";
    Cursor normal
    Print #2.branch, "setfocus"

    '** cause combobox to display in open drop position:
    hBranch=hWnd(#2.branch)
    CallDLL #user32, "SendMessageA",_
        hBranch As Long,_   'handle of combobox
        _CB_SHOWDROPDOWN As Long, _
        1 As Long,_         'repaint flag=yes
        0 As Long,_         'always 0
        re As Long

    Wait


[cancelbranch]
    '** CANCEL, RETURN TO EDITOR
    Close #2
    Print #1.t, "!origin ";rowVar;" ";columnVar;"";
    Print #1.t, "!setfocus";
    Wait


[branch]
    '** CHOOSE BRANCH, SET EDITOR TO THAT POSITION
    Cursor hourglass
    Print #2.branch,"selection?"
    Input #2.branch,branchselect$ 

    If branchselect$="<start>" Then
        Print #1.t, "!origin 1 1";
        Print #1.t, "!setfocus";
        Cursor normal
        Close #2
        Wait
    End If

    branchlength=Len(branchselect$)

    For i = 1 TO rowcount
       Print #1.t,"!line ";i;
       Input #1.t,line$
          If Trim$(line$)= branchselect$ Then
            Print #1.t, "!origin ";i;" ,0";
            i=rowcount
            Close #2
            Print #1.t, "!setfocus";
            Cursor normal
            Wait
          End If
    Next i
    Cursor normal
    Wait




[bmp] '** BITMAP PREVIEWER
    WindowWidth=640:WindowHeight=480
    UpperLeftX=Int((DisplayWidth=WindowWidth)/2)
    UpperLeftY=Int((DisplayHeight=WindowHeight)/2)

    Button #bit.open, "Open",   [openbmp],  UL,330,5,80,26
    Button #bit.save, "Save As",[savebmp],  UL,330,35,80,26
    Button #bit.exit, "Exit",   [closebit], UL,330,65,80,26

    Button #bit.draw, "Choose Pen Color",[colorChoice],UL,425,5,160,26
    Graphicbox #bit.color, 425,35,160,26
    Statictext #bit.ins, "Click and drag to draw on bitmap.",415,70,260,20

'** New, separate colors for each textbox:
    TextboxColor$="blue"
    Textbox #bit.t1, 20,35,300,26
    TextboxColor$="pink"
    Textbox #bit.t2, 20,65,300,26
    Graphicbox #bit.box1, 20,100,600,340
    Statictext #bit.s, "Bitmap File:",20,5,150,20
    Open "Bitmap Preview" For Dialog_modal As #bit
    Print #bit, "trapclose [closebit]"

    Print #bit,  "font Times_New_Roman 0 16"
    Print #bit.box1, "down"
    Print #bit.box1, "size 2; color ";drawcolor$
    Print #bit.box1, "setfocus; when leftButtonMove [drawit]"
    Print #bit.box1, "when leftButtonDown [drawit]"
    Print #bit.color, "down; fill ";drawcolor$
    Print #bit.color, "flush"

    Wait

[closebit]
    Print #bit.box1, "cls"
    Close #bit
    If bmploaded=1 Then UnloadBmp "tempPicture"
    bmploaded=0
    Wait

[drawit]
    If bmploaded=0 Then
        Notice "You must choose a bitmap first."
        Wait
    End If

    If MouseX>bmpwidth or MouseY>bmpheight Then Wait

    Print #bit.box1, "set ";MouseX;" ";MouseY
    Wait



[savebmp]
    If picFile$="" Then
        Notice "It is not possible to SAVE.  No Bitmap has been chosen."
        Wait
    End If

    Print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    Print #bit.box1, "flush"

    FileDialog "Save As..","*.bmp",savebmpfile$ 
    If savebmpfile$="" Then Wait

    BmpSave "tempPicture", savebmpfile$ 

    Cursor normal
    Notice "Bitmap saved as "+savebmpfile$ 
    Wait


[openbmp]
    FileDialog "Open Bitmap","*.bmp", picFile$
    If picFile$ = "" Then Wait

    Print #bit.t1, Lower$(picFile$)

    If bmploaded=1 Then UnloadBmp "tempPicture"
    LoadBmp "tempPicture", picFile$
    bmploaded=1

    hPic=Hbmp("tempPicture")
    bmpheight=BitmapHeight(hPic)
    bmpwidth=BitmapWidth(hPic)

    Print #bit.t2, "Width:  ";bmpwidth;"    Height:  ";bmpheight;""

    Print #bit.box1, "cls"
    Print #bit.box1, "drawbmp tempPicture 0 0"
    Print #bit.box1, "flush"
    Wait

[colorChoice]
    Print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    ColorDialog drawcolor$,drawcolor$
    Print #bit.box1, "color "+drawcolor$
    Print #bit.color, "cls"
    Print #bit.color, "fill ";drawcolor$
    Print #bit.color, "flush"
    Wait

[about]
    message$="About this editor..."+Chr$(13)+_
        Chr$(169)+"The Liberty BASIC Community"
    Notice message$
    Wait

[wav]
    If wavPath$="" Then wavPath$=DefaultDir$
    FileDialog "Open WAV file",wavPath$+"\*.WAV",wavFile$
    If wavFile$="" Then
        PlayWave ""
        Wait
    End If

    slash=Len(wavFile$)
        While Instr(wavFile$, "\", slash)=0
            slash=slash-1
        Wend
    wavPath$=Left$(wavFile$,slash)
    PlayWave wavFile$,async
    GoTo [wav]



[write.ini.file]
    Open DefaultDir$ + "\editor.ini" For Output As #inifile
        Print #inifile, setFont$ 
        Print #inifile, recentfile$(1)
        Print #inifile, recentfile$(2)
        Print #inifile, recentfile$(3)
    Close #inifile
    Return



[read.ini.file]
    Open DefaultDir$ + "\editor.ini" For Append As #inifile
        If Lof(#inifile) <> 0 Then
            Close #inifile
            Open DefaultDir$ + "\editor.ini" For Input As #inifile
            Line Input #inifile, setFont$ 

           If not(eof(#inifile)) Then
                Line Input #inifile, rfile$
                recentfile$(1)=rfile$
            End If

            If not(eof(#inifile)) Then
                Line Input #inifile, rfile$
                recentfile$(2)=rfile$
            End If

            If not(eof(#inifile)) Then
                Line Input #inifile, rfile$
                recentfile$(3)=rfile$
            End If
        End If
    Close #inifile

    If setFont$="" Then setFont$="courier_new 10"
    Print #1.t, "!font ";setFont$  'set font in texteditor
    GoSub [ResetMenu]
    Return


[ResetMenu]    'make sure filenames are shown in recent menu
    flags=_MF_STRING OR _MF_BYPOSITION

    For i = 0 to 2 'do for each of three recent files in menu

        menuString$=recentfile$(i+1)   'new caption from array = full path/filename

        CallDLL #user32, "GetMenuItemID",_
            hmenuRecent As Long,_     'handle of recent menu
            i As Long,_               '0-based position of item
            menuID As Long            'ID of item

        CallDLL #user32, "ModifyMenuA",_
            hmenuRecent As Long,_       'handle of recent menu
            i As Long,_                 '0-based position of item
            flags As Long,_             'instructions for call
            menuID As Long,_            'ID of item to change
            menuString$ As Ptr,_        'new caption
            result As Long

    Next i

    CallDLL #user32, "DrawMenuBar",_        'redraw menu bar
        hWin As Long, result As Void

    Return


[numbertools]
    PopupMenu "&Decimal to Hex Converter",[dectohex],_
        "&Hex to Decimal Converter",[hextodec]
    Wait

[dectohex]
    Prompt "Enter a number...";decnum$
    decnum=Val(decnum$)
    Notice DecHex$(decnum)
    Wait

[hextodec]
    Prompt "Enter a hex number...";hexnum$
    Notice Hexdec(hexnum$)
    Wait

[timetools]
    PopupMenu "Current &Time",[timenow],_
        "Today's &Date",[datenow]
    Wait

[timenow]
    timemsg$="Current time is:  "+Chr$(13)+_
    Time$()+Chr$(13)+Chr$(13)+_
    "Seconds since midnight:  "+Str$(Time$("seconds"))+Chr$(13)+_
    "Milliseconds since midnight:  "+Str$(Time$("milliseconds"))
    Notice timemsg$
    Wait

[datenow]
    datemsg$="Date is" +Chr$(13)+_
    Date$() +Chr$(13)+_
    Date$("mm/dd/yyyy") +Chr$(13)+_
    Date$("mm/dd/yy") +Chr$(13)+_
    Date$("yyyy/mm/dd") +Chr$(13)+_
    "Days since Jan 1, 1901:  "; Date$("days")
    Notice datemsg$
    Wait



[fontdialog]
    FontDialog setFont$,setFont$
    Print #1.t, "!font ";setFont$
    GoSub [write.ini.file]
    Wait


[libertyhome]
    Call RunThis "http://www.libertybasic.com/" ,h
    Wait


[emailcarl]
    Call RunThis "mailto:carlg@libertybasic.com?Subject=Liberty BASIC" ,h
    Wait


[edithelp]
    If helpopen = 1 Then
        hHelp=hWnd(#help)
        CallDLL #user32, "GetParent",hHelp As Ulong,hParent As Ulong
        CallDLL #user32, "BringWindowToTop",hParent As Ulong, result As Boolean
        Wait
    End If

    If helpopen=2 Then Close #help

    helpopen = 1
    WindowWidth=400:WindowHeight=300
    Open "Help" For Text As #help
    Print #help, "Use this editor to write, edit and run"
    Print #help, "Liberty BASIC source code."
    Print #help, "Be sure to try out the many"
    Print #help, "programming tools provided."
    Print #help, "This program is in the public domain."
    Print #help, "Feel free to use and modify."
    Print #help, "!origin 1 1";
    Print #help, "!trapclose [quit.edithelp]";

    Wait

    [quit.edithelp]
    Close #help
    helpopen = 0
    Wait


[projecthelp]
    If helpopen = 2 Then
        hHelp=hWnd(#help)
        CallDLL #user32, "GetParent",hHelp As Ulong,hParent As Ulong
        CallDLL #user32, "BringWindowToTop",hParent As Ulong, result As Boolean
        Wait
    End If

    If helpopen=1 Then Close #help

    helpopen = 2
    WindowWidth=450:WindowHeight=300
    Open "Project Help" For Text As #help
    Print #help, "Projects are made by indicating"
    Print #help, "'include' files at the top of your code."
    Print #help, "Be sure to specify one filename on each line,"
    Print #help, "starting with the top line of code."
    Print #help, "Project files must be in the same folder as."
    Print #help, "the main code file."
    Print #help, "The format is to place "+Chr$(34)+"'include filename.bas"+Chr$(34)
    Print #help, "on the top line for the first included file."
    Print #help, "Use the same format on subsequent lines For more"
    Print #help, "additional included files."
    Print #help, "!origin 1 1";
    Print #help, "!trapclose [quit.projecthelp]";

    Wait

    [quit.projecthelp]
    Close #help
    helpopen = 0
    Wait


'*************** FUNCTION LIBRARY **********************
Function BitmapWidth(hBmp)
    struct BITMAP,_ '14 bytes
    bmType As Long,_
    bmWidth As Long,_
    bmHeight As Long,_
    bmWidthBytes As Long,_
    bmPlanes As Long,_
    bmBitsPixel As Long,_
    bmBits As Long,

    Open "gdi32" For DLL As #g
    CallDLL #g, "GetObjectA", hBmp As Long,_
       14 As Long,BITMAP As struct,_
       results As Long
    Close #g

    BitmapWidth=BITMAP.bmWidth.struct
End Function

Function BitmapHeight(hBmp)
    struct BITMAP,_ '14 bytes
    bmType As Long,_
    bmWidth As Long,_
    bmHeight As Long,_
    bmWidthBytes As Long,_
    bmPlanes As Long,_
    bmBitsPixel As Long,_
    bmBits As Long

    Open "gdi32" For DLL As #g
    CallDLL #g, "GetObjectA", hBmp As Long,_
       14 As Long,BITMAP As struct,_
       results As Long
    Close #g

    BitmapHeight=BITMAP.bmHeight.struct
End Function



Function SeparateFile$(f$)
    fileindex=Len(f$)
    filelength=Len(f$)
      While Mid$(f$, fileindex,1)<>"\"
        fileindex=fileindex-1
      Wend
    SeparateFile$=Right$(f$,filelength-fileindex)
End Function


Function SeparatePath$(f$)
    fileindex=Len(f$)
    filelength=Len(f$)
      While Mid$(f$, fileindex,1)<>"\"
        fileindex=fileindex-1
      Wend
    SeparatePath$=Left$(f$,fileindex)
End Function


Function FileExist(fPath$,fFile$)
    Files fPath$,fFile$,info$(
    FileExist=Val(info$(0,0))
End Function


Sub RunThis RunFile$, hWindow
    RunFile$=RunFile$+Chr$(0)
    lpOperation$ = "open" + Chr$(0)
    lpParameters$ = "" + Chr$(0)
    lpDirectory$ = "" + Chr$(0)
    nShowCmd = _SW_SHOWNORMAL

    Open "shell32" For DLL As #shell
    CallDLL #shell, "ShellExecuteA", _
        hWindow As Long, _          'parent window
        lpOperation$ As Ptr, _      'open or print
        RunFile$ As Ptr, _          'file name
        lpParameters$ As Ptr, _     'null
        lpDirectory$ As Ptr, _      'default directory
        nShowCmd As Long, _        'show window flag
        result As Long
    Close #shell
    If result <= 32 Then Notice "Error, Address Failure!"
End Sub


[remove.menu]
    CallDLL #user32, "GetMenu",_
        h As Long,_     'window handle
        hMenu1 As Long  'returns handle of menu bar

    CallDLL #user32, "GetSubMenu",_
        hMenu1 As Long,_    'handle of menu bar
        0 As Long,_         'position of sub menu desired 0 - first
        hmenuFile As Long   'handle of sub menu for File menu

    CallDLL #user32, "GetSubMenu",_
        hMenu1 As Long,_    'handle of menu bar
        2 As Long,_         'position of recent menu 2 = third
        hmenuRecent As Long 'returns handle of recent menu

    menuflags = _MF_BYPOSITION Or _MF_POPUP Or _MF_STRING
    CallDLL #user32, "ModifyMenuA",_
        hmenuFile As Long, _    'handle of menu to modify
        7 As Long,_             'position of item to change (8th item)
        menuflags As Long, _    'flags for type of change
        hmenuRecent As Long,_   'menu to add as a popup
        "&Recent" As Ptr, _     'name of menu item
        result As Long

    CallDLL #user32, "RemoveMenu",_   'remove recent menu from view
        hMenu1 As Long, _           'handle of menu bar
        2 As Long,_                 '2 = position of menu to remove
        _MF_BYPOSITION As Long, _   'flag for remove by position
        result As Long

    CallDLL #user32, "DrawMenuBar",_  'must redraw bar after change
        h As Long,_                 'window handle
        result As Void
       Return


[recent.files]
    recentfile$(3)=recentfile$(2)
    recentfile$(2)=recentfile$(1)
    recentfile$(1)=Lower$(file$)
    GoSub [ResetMenu]
    Return


[File_1]
    If recentfile$(1)="" Then Wait
    file$=recentfile$(1)
    GoTo [loadFile]

[File_2]
    If recentfile$(2)="" Then Wait
    file$=recentfile$(2)
    GoTo [loadFile]

[File_3]
    If recentfile$(3)="" Then Wait
    file$=recentfile$(3)
    GoTo [loadFile]


[makeArrays]
    Dim myarray$(1000)
    left=Int((DisplayWidth-280)/2):top=Int((DisplayHeight-215)/2)
    WindowWidth = 280
    WindowHeight = 215
    bString = 0
    bNumeric = 1
    i = 0
    Statictext #am.static1, "Array Name:", 6, 11, 88, 20
    Statictext #am.static2, "Item to Add:", 6, 67, 96, 20
    Groupbox #am.groupbox3, "Type", 150, 11, 110, 70
    Radiobutton #am.string, "String$",[stringSet],[loop],182,31,72,20
    Radiobutton #am.numeric, "Numeric",[numericSet],[loop],182,56,72,20
    Button #am.default, "Add Item", [ArrayAdd], UL, 150, 86, 112, 25
    Texteditor #am.text, 0, 0, 0, 0
    Button #am.file, "File", [ArrayFile], UL, 150, 119, 112, 25
    Button #am.create, "Create and Exit",[create],UL,150,151,112, 25
    Button #am.cancel, "Cancel", [ArrayCancel], UL, 14, 151, 112, 25

'** New, separate colors for each textbox:
    TextboxColor$="cyan"
    Textbox #am.arrayName, 6, 31, 136, 25
    TextboxColor$="yellow"
    Textbox #am.arrayItem, 6, 86, 136, 25
    Open "Array Maker" For Dialog_nf_modal As #am
    Print #am, "font ms_sans_serif 0 8"
    Print #am.numeric, "set" 'flag bNumeric = 1
    Wait


[ArrayAdd]   'Perform action for the button named 'add'
    Print #am.arrayItem, "!contents?";
    Input #am.arrayItem, arrayItem$

    myarray$(i)= arrayItem$ 
    i = i + 1
    Print #am.arrayItem, "";
    Print #am.arrayItem, "!setfocus";
    Wait

[ArrayFile]
   i = 0
   FileDialog "Open file", "*.*", ArrayFileName$
   If ArrayFileName$ = "" Then
     Notice "You must input a valid file name!"
     Wait
   End If
   Print #am.arrayName, "!contents?";
    Input #am.arrayName, arrayName$ 
    If bString = 1 and Right$(arrayName$, 1) <> "$" Then
       arrayName$ = arrayName$ + "$"
    End If
   Open ArrayFileName$ For Input As #arrayFile
     While eof(#arrayFile) = 0
       Line Input #arrayFile, ArrayLine$
       myarray$(i)= ArrayLine$ 
       i = i + 1
     Wend
     Close #arrayFile


[create]
    Print #am.arrayName, "!contents?"
    Input #am.arrayName, arrayName$ 

    If arrayName$="" Then arrayName$="MyArray"
    If bString=1 and Right$(arrayName$,1)<>"$" Then
        arrayName$=arrayName$+"$"
    End If

    Print #am.text, "!cls";
    Print #am.text, "Dim ";arrayName$;"(";i;")"
    For a = 0 to i-1
    If Right$(arrayName$, 1) = "$" Then
      Print #am.text, arrayName$;"(";a;") = ";Chr$(34);myarray$(a);Chr$(34)
    Else
      Print #am.text, arrayName$;"(";a;") = ";myarray$(a)
    End If
    Next a

    Print #am.text, "!selectall";
    Print #am.text, "!copy";
    Print #am.text, "!cls";
    Notice "Array is copied into clipboard. Paste into your application."
[ArrayCancel]
    Close #am
    Wait

[stringSet]
    bString = 1
    bNumeric = 0
    Wait

[numericSet]
    bNumeric = 1
    bString = 0
    Wait


[runtimeIcon]
    FileDialog "Choose Icon","*.ico",icoFile$
    If icoFile$="" Then Wait

    shortFile$=SeparateFile$(icoFile$)
    filePath$=SeparatePath$(icoFile$)
    Files filePath$,shortFile$, info$()
    'check file size - must be 766 for 16-color icon:
    If info$(1,1) <> "766" Then
        Notice "Not a 16-color icon!"
        Wait
    End If

    FileDialog "Choose runtime engine","*.exe",runexe$
    If runexe$="" Then Wait

    'open icon file and read into a string variable:
    Open icoFile$ For Input As #iconfile
    saveicon$=Input$(#iconfile, Lof(#iconfile))
    Close #iconfile

    'open the runtime engine, seek to the proper
    'location, and write the icon info at that spot:
    Open runexe$ For Binary As #bin
    Seek #bin, 21664
    Print #bin, Right$(saveicon$,744)
    Close #bin
    Notice "Icon has been included in ";runexe$
    Wait



'All code after this point is needed
'to create the toolbar.  Do not modify
'or remove anything below.
[MakeToolbar]
    'do not attempt to create toolbar if bmp is missing
    If FileExist(DefaultDir$,"opensrc.bmp")=0 Then return

    CallDLL #comctl32, "InitCommonControls", _
        re As Void

    GoSub [addTooltipControl] 'create tooltip control

    struct TBBUTTON,_
    bmpID As Long,_ 'index of bitmap
    cID As Long,_   'command ID
    State As Long,_ 'button state
    Style As Long,_ 'button style
    dwData As Long,_'not used
    Str As Long     'not used

    TB.ADDBUTTONS    = 1044
    TB.SETTOOLTIPS   = 1060
    TBSTYLE.BUTN     = 0
    TBSTYLE.FLAT     = 2048
    TBSTYLE.TOOLTIPS = 256


    hbmpTools=LoadBitmapSystemColors("opensrc.bmp")
    If hbmpTools=0 Then
        Notice "Error loading bitmap!"
        Return
    End If

    hID0 = GetWindowLong(hWnd(#1.hide0),_GWL_ID)
    hID1 = GetWindowLong(hWnd(#1.hide1),_GWL_ID)
    hID2 = GetWindowLong(hWnd(#1.hide2),_GWL_ID)
    hID3 = GetWindowLong(hWnd(#1.hide3),_GWL_ID)
    hID4 = GetWindowLong(hWnd(#1.hide4),_GWL_ID)
    hID5 = GetWindowLong(hWnd(#1.hide5),_GWL_ID)
    hID6 = GetWindowLong(hWnd(#1.hide6),_GWL_ID)
    hID7 = GetWindowLong(hWnd(#1.hide7),_GWL_ID)
    hID8 = GetWindowLong(hWnd(#1.hide8),_GWL_ID)
    hID9 = GetWindowLong(hWnd(#1.hide9),_GWL_ID)
    hID10 = GetWindowLong(hWnd(#1.hide10),_GWL_ID)
    hID11 = GetWindowLong(hWnd(#1.hide11),_GWL_ID)
    hID12 = GetWindowLong(hWnd(#1.hide12),_GWL_ID)
    hID13 = GetWindowLong(hWnd(#1.hide13),_GWL_ID)

    'fill toobar button struct for first button
    TBBUTTON.bmpID.struct = 0              'index of first bitmap
    TBBUTTON.cID.struct = hID0             'ID of first button
    TBBUTTON.State.struct = 4              'enabled
    TBBUTTON.Style.struct = TBSTYLE.BUTN   'style
    TBBUTTON.dwData.struct = 0             'not used
    TBBUTTON.Str.struct = 0                'not used

    style=_WS_CHILD Or _WS_VISIBLE Or TBSTYLE.FLAT _
        Or _WS_BORDER or TBSTYLE.TOOLTIPS
    uStructSize = Len(TBBUTTON.struct)
    CallDLL #comctl32, "CreateToolbarEx",_
        h As Long,_         'parent handle
        style As Long,_     'window style flags
        0 As Long,_         'ID
        14 As Long,_        'number of Bitmaps
        0 As Long,_         'hBMInst-not used
        hbmpTools As Long,_ 'bitmap handle
        TBBUTTON As struct,_'toolbar button struct
        1 As Long,_         'number of buttons to start
        16 As Long,_        'width buttons

        16 As Long,_        'height buttons
        16 As Long,_        'width bitmaps for buttons
        16 As Long,_        'height bitmaps for buttons
        uStructSize As Long,_
        hTB As Long         'handle to toolbar

    'must add tooltip control before adding buttons to toolbar
    r=SendMessage(hTB,TB.SETTOOLTIPS,hwndTT,0)


    'fill toolbar button struct with new info to add buttons:
    TBBUTTON.bmpID.struct = 1  'bitmap image index
    TBBUTTON.cID.struct = hID1 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 2  'bitmap image index
    TBBUTTON.cID.struct = hID2 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 3  'bitmap image index
    TBBUTTON.cID.struct = hID3 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 4  'bitmap image index
    TBBUTTON.cID.struct = hID4 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 5  'bitmap image index
    TBBUTTON.cID.struct = hID5 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 6  'bitmap image index
    TBBUTTON.cID.struct = hID6 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 7  'bitmap image index
    TBBUTTON.cID.struct = hID7 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 8  'bitmap image index
    TBBUTTON.cID.struct = hID8 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 9  'bitmap image index
    TBBUTTON.cID.struct = hID9 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 10  'bitmap image index
    TBBUTTON.cID.struct = hID10 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 11  'bitmap image index
    TBBUTTON.cID.struct = hID11 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 12  'bitmap image index
    TBBUTTON.cID.struct = hID12 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    TBBUTTON.bmpID.struct = 13  'bitmap image index
    TBBUTTON.cID.struct = hID13 'ID of button
    Call AddButton hTB, TB.ADDBUTTONS

    'tell toolbar to resize with window
    ret = SendMessage(hTB, TB.AUTOSIZE, 0, 0)

    'add tooltips for toolbar buttons
    GoSub [addTooltips]
    Return


Sub AddButton hndl,msg
    CallDLL #user32, "SendMessageA", hndl As Long,_
    msg As Long, 1 As Long,_
    TBBUTTON As struct, r As Long
    End Sub

Function SendMessage(hWin, msg, wParam, lParam)
    CallDLL #user32, "SendMessageA", hWin As Long, msg As Long, _
    wParam As Long, lParam As Long, SendMessage As Long
    End Function

Function GetWindowLong(hWin, type)
    CallDLL #user32, "GetWindowLongA",_
    hWin As Long,type As Long,_
    GetWindowLong As Long
    End Function

Function LoadBitmapSystemColors(bmp$)
    flags=_LR_LOADFROMFILE or _LR_LOADMAP3DCOLORS _
        or _LR_LOADTRANSPARENT
    CallDLL #user32, "LoadImageA",_
    0 As Long, bmp$ As Ptr, _IMAGE_BITMAP As Ulong,_
    0 As Long, 0 As Long, flags As Long,_
    LoadBitmapSystemColors As Ulong
    End Function



[addTooltipControl]
    TTF.IDISHWND    = 1
    TTF.CENTERTIP   = 2
    TTF.SUBCLASS    = 16
    TTM.ADDTOOL     = 1028
    TTM.DELTOOL     = 1029
    TTS.ALWAYSTIP   = 1
    TTS.NOPREFIX    = 2
    style           = _WS_POPUP or TTS.NOPREFIX _
                      or TTS.ALWAYSTIP


    CallDLL #user32, "GetWindowLongA", _
        h As Long, _GWL_HINSTANCE As Long,_
        hInstance As Long

    CallDLL #user32, "CreateWindowExA",_
        _WS_EX_TOPMOST As Long,_
        "TOOLTIPS_CLASS32" As Ptr,_
        "" As Ptr, style As Long,_
        _CW_USEDEFAULT As Long,_CW_USEDEFAULT As Long,_
        _CW_USEDEFAULT As Long,_CW_USEDEFAULT As Long,_
        h As Long, 0 As Long, hInstance As Long,_
        0 As Long,hwndTT As Long


    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    CallDLL #user32, "SetWindowPos", hwndTT As Long,_
        _HWND_TOPMOST As Long, _
        0 As Long, 0 As Long,_
        0 As Long, 0 As Long,_
        flags As Long, r As Long
    Return


[addTooltips]
    '** LB3 NOW ONLY REQUIRES A SINGLE STRUCT
    '   FOR ALL TOOLTIPS
    struct toolinfo, cbSize As Long, uFlags As Long,_
        hwnd As Long, uId As Long, left As Long, top As Long,_
        right As Long, bottom As Long, _
        hInst As Long, lpstrText$ As Ptr

    'THESE STRUCT MEMBERS ONLY NEED TO BE FILLED ONCE:
    toolinfo.cbSize.struct = Len(toolinfo.struct)
    toolinfo.uFlags.struct = TTF.SUBCLASS
    toolinfo.hwnd.struct = hTB
    toolinfo.top.struct=0     'top location on toolbar
    toolinfo.bottom.struct=22 'bottom location on toolbar

    'THESE STRUCT MEMBERS NEED TO BE FILLED ANEW
    'FOR EACH TOOTLIP ADDED:
    toolinfo.lpstrText$.struct = "New File"
    toolinfo.left.struct=0      'initial left location
    toolinfo.right.struct=22    'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Open File"
    toolinfo.left.struct=23    'add 23 to previous left location
    toolinfo.right.struct=45   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Save File"
    toolinfo.left.struct=46    'add 23 to previous left location
    toolinfo.right.struct=68   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Save File As..."
    toolinfo.left.struct=69    'add 23 to previous left location
    toolinfo.right.struct=91   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Print File"
    toolinfo.left.struct=92    'add 23 to previous left location
    toolinfo.right.struct=114   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Run Program"
    toolinfo.left.struct=115    'add 23 to previous left location
    toolinfo.right.struct=137   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Debug Program"
    toolinfo.left.struct=138    'add 23 to previous left location
    toolinfo.right.struct=160   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Tokenize Program"
    toolinfo.left.struct=161    'add 23 to previous left location
    toolinfo.right.struct=183   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Run MS Paint"
    toolinfo.left.struct=184    'add 23 to previous left location
    toolinfo.right.struct=206   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Run Windows Explorer"
    toolinfo.left.struct=207    'add 23 to previous left location
    toolinfo.right.struct=229   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Run Notepad"
    toolinfo.left.struct=230    'add 23 to previous left location
    toolinfo.right.struct=252   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Run Windows Calculator"
    toolinfo.left.struct=253    'add 23 to previous left location
    toolinfo.right.struct=275   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Liberty BASIC Help"
    toolinfo.left.struct=276    'add 23 to previous left location
    toolinfo.right.struct=298   'add 22 to left for right
    GoSub [addTooltip]

    toolinfo.lpstrText$.struct = "Exit"
    toolinfo.left.struct=299    'add 23 to previous left location
    toolinfo.right.struct=521   'add 22 to left for right
    GoSub [addTooltip]

    Return

[addTooltip]
    CallDLL #user32, "SendMessageA", hwndTT As Long,_
    TTM.ADDTOOL As Long, 0 As Long,_
    toolinfo As struct, re As Long
    Return

'** END TOOLBAR CODE **


