' LbNoteBoard - Liberty Note Board
' by Brad Moore - copyright 2003, all rights reserved
'
'    * This application is a demonstration pad to show how to integrate
'      Liberty Basic and dynamically generated HTML together as a single
'      Application Unit using JavaScript and Cookies as the middleware.
'
'    * Any programmer is welcome to use portions of this program
'      in their own work.  You are not permitted to use the entire
'      source package and distribute it as your own work.  See the
'      help file for more information on lisencing.
'
'    * Please note that this is a result of colabritive work of
'      other Liberty Basic programmers.  Specifically I wish to credit
'      Doyle Whisenant for LBBrowser
'      Alyce Watson for code components from Liberty Basic Workshop (tooltips,...)
'      Brent Thorn for the Date/Time Picker
'      David Drake is credited by Doyle for "some code", and so I thank him as well
'
'    * This program is written for Liberty Basic version 3.x
'      Learn more about Liberty Basic by visiting http://www.libertybasic.com
'
'--------------------------------------------------------------------------------
'    Version History
'--------------------------------------------------------------------------------
'    03.21.03  BJM  v.01 - Development version, integrating components
'
'--------------------------------------------------------------------------------

    True = 1 : False = 0

    'Open the dll that will let us find our cookies when we write them.
    Open "CookieUtil.dll" For DLL As #cookie

    'create the struct required by the calls to CookieUtil
    struct cookieSearch, _
           searchString$ As char[128], _
           resultString$ As char[2048], _
           hits As long

    'Findout what directory we are operating in
    CurrentDir$ = DefaultDir$

    'Track whether the edit window is open
    Edit.Is.Open = 0


'Setup some constants and the starting webpage for the webcontrol
'---------------------------------------------------------------------------------

    ' homepage - change to suit
    Home1$ = CurrentDir$ + "\Web\LbNBSplash.htm"
    Home$ = GetShortPathName$(Home1$)

    'Also set the location for the help file
    Help1$ = CurrentDir$ + "\Web\LbNBhelp.htm"
    Help$ = GetShortPathName$(Help1$)


    ' set up a few constants
    WEBPAGE.GOBACK     = 0          ' go to previous page
    WEBPAGE.GOFORWARD  = 1          ' go to next page
    WEBPAGE.GOHOME     = 2          ' go home
    WEBPAGE.SEARCH     = 3          ' search
    WEBPAGE.REFRESH    = 4          ' refresh the page
    WEBPAGE.STOP       = 5          ' stop loading the page
    BROWSE.IS.OPEN     = 0          ' the browse dll "open" flag
    VERSION.FLAG       = 0          ' versioninfo flag



'Intialize other system variables
'---------------------------------------------------------------------------------

[generalSetup]

   MaxNotes = 40

   dim NotesArray$(MaxNotes)
   dim Note2File$(MaxNotes,3)    '(n,1) = title, (n,2) = path, (n,3) = link name
   dim TempNotesArray$(MaxNotes)
   dim TempNote2File$(MaxNotes,3)

   NotesArray$(1) = "<Add New Note>"

   NoteCount = 1
   CurrentPage = 0 'zero is the page number for home



'Load the file containing the NoteBoard References and then call a routine to sort


'Intialize the main window
'---------------------------------------------------------------------------------

[InitColors]
    'It is suggested that default colors be used when possible.
    'Activate the following color statements only if
    'they are really necessary in the program.
    'ForegroundColor$ = "Black"
    'BackgroundColor$ = "Buttonface"
    'TexteditorColor$ = "White"
    'TextboxColor$    = "White"
    'ComboboxColor$   = "White"
    'ListboxColor$    = "White"

[WindowSetup]
    'NOMAINWIN
    WindowWidth = 700 : WindowHeight = 510
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

[ControlSetup]

graphicbox  #main.gr, 6, 45, 680, 430
groupbox    #main.gb1, "", 2,-7, 689, 43
COMBOBOX    #main.combo, NotesArray$(), [idle], 110, 6, 176, 120
bmpbutton   #main.new, "graphics\newnote.bmp",[new],UL, 5, 4
bmpbutton   #main.help, "graphics\help.bmp",[help],UL, 654, 4
bmpbutton   #main.go, "graphics\go.bmp",[go],UL, 290, 4
bmpbutton   #main.home, "graphics\home.bmp",[home],UL, 360, 4
bmpbutton   #main.edit, "graphics\edit.bmp",[edit],UL, 40, 4
bmpbutton   #main.delete, "graphics\delete.bmp",[delete],UL, 75, 4
bmpbutton   #main.refresh, "graphics\refresh.bmp",[refresh],UL, 325, 4

Open "LBNoteBoard" for Window_nf as #main


    h1 = hWnd(#main)

    #main "trapclose [quit]"
    #main "font ms_sans_serif 10"
    #main.combo "selectindex 1"

    gosub [killMyCookie]

    Call MakeTooltips HWND(#main)

    'change the background of the button bitmaps to the users color scheme

    ' button #4
    BmpBttnHwnd = FixBmp("graphics\newnote.bmp")
    LoadBmp "b4", BmpBttnHwnd
    #main.new "bitmap b4"
    ' button #6
    BmpBttnHwnd = FixBmp("graphics\help.bmp")
    LoadBmp "b6", BmpBttnHwnd
    #main.help "bitmap b6"
    ' button #7
    BmpBttnHwnd = FixBmp("graphics\go.bmp")
    LoadBmp "b7", BmpBttnHwnd
    #main.go "bitmap b7"
    ' button #8
    BmpBttnHwnd = FixBmp("graphics\home.bmp")
    LoadBmp "b8", BmpBttnHwnd
    #main.home "bitmap b8"
    ' button #9
    BmpBttnHwnd = FixBmp("graphics\edit.bmp")
    LoadBmp "b9", BmpBttnHwnd
    #main.edit "bitmap b9"
    ' button #10
    BmpBttnHwnd = FixBmp("graphics\delete.bmp")
    LoadBmp "b10", BmpBttnHwnd
    #main.delete "bitmap b10"
    ' button #11
    BmpBttnHwnd = FixBmp("graphics\refresh.bmp")
    LoadBmp "b11", BmpBttnHwnd
    #main.refresh "bitmap b11"

    ' get the handle of the container window (for browser) - #main.gr
    hWndCon = hWnd(#main.gr)

    ' open the browser dll and initilize it.
    ' ** This must be the first call to the browser dll **
    Open "browser.Dll" For DLL As #browse
    CallDLL #browse, "EmbedBrowserObject", hWndCon As long, ret As long
    BROWSE.IS.OPEN = 1

    CallDLL #browse, "DisplayHTMLPage", hWndCon As long, Home$ As ptr, ret As long

    'Now choose a new project or open an existing project
    gosub [getProject]
    CurrentPage = 0

    'Now change the application title to eflect the project title.
    WndTitle$ = "LbNoteBoard - " + ProjectTitle$ + Chr$(0)
    CallDLL #user32, "SetWindowTextA", h1 As long, WndTitle$ As ptr, ret As long


[loop]
    'Spawn a timer to search for cookies (every 1/4 second)
    timer 100, [look4cookie]
    Wait

[quit]
    timer 0
    If BROWSE.IS.OPEN Then
      CallDLL #browse, "UnEmbedBrowserObject", hWndCon As long, ret As long
      BROWSE.IS.OPEN = 0
    End If

    if Edit.Is.Open = 1 then
        close #edit
    end if

    ' unload button bitmaps
    UnloadBmp "b4"
    UnloadBmp "b6"
    UnloadBmp "b7"
    UnloadBmp "b8"
    UnloadBmp "b9"
    UnloadBmp "b10"
    UnloadBmp "b11"
    Close #browse
    close #cookie
    close #main
    END

[new]
    timer 0
    EditNoteFlag$ = "New"
    EditNoteTitle$ = ""
    goto [EditNote]

[help]
    timer 0
    'place code here
       url$ = Help$
       CallDLL #browse, "DisplayHTMLPage", hWndCon As long, url$ As ptr, ret As long
       CurrentPage = 0
    goto [loop]

[go]
    timer 0
    'place code here
    #main.combo "selection? selNote$"
    'see what has been chosen
    if selNote$ = "<Add New Note>" then
       'we want to add a new (and first) not
       goto [new]
    end if
    'we presume that a note page title has been choosen - search for it.
    fileName$ = ""
    for x = 1 to NoteCount
       if selNote$ = Note2File$(x,1) then
          fileName$ = Note2File$(x,2)
          exit for
       end if
    next x
    'If filename$ is null the item selected in combo is invalid
    if fileName$ = "" then
       notice "The item selected does not appear to be a valid note file " + _
              "for this project - please try again..."
       goto [loop]
    end if
    'We have a good file name - open the file and display
    CurrentPage = x
    url$ = fileName$
    CallDLL #browse, "DisplayHTMLPage", hWndCon As long, url$ As ptr, ret As long
    goto [loop]

[home]
    timer 0
    'place code here
       url$ = Home$
       CallDLL #browse, "DisplayHTMLPage", hWndCon As long, url$ As ptr, ret As long
       CurrentPage = 0
    goto [loop]

[edit]
    timer 0
    Notice "Edit is not supported in this version of the demonstration program.  " + _
           "Updated verions may be available at http://www.freewebz.com/lb-connection " + _
           "in the future.  Please check there for moe information."
    goto [loop]

[delete]
    timer 0
    'well we should know the page being viewed - we can remove it.
    'If we are on home then NO DELETE!
    if CurrentPage = 0 then
       notice "You can not delete the Home Page - Sorry!"
       goto [loop]
    end if
    confirm "Are you sure you want to DELETE the current note?"; answer$
    if answer$ = "no" then [loop]
    'get the filename of the file.
    fileName$ = Note2File$(CurrentPage,2)
    kill fileName$
    'Now the tricky part - removing the entry from the arrays
    for x = 1 to NoteCount - 1
       if x >= CurrentPage then
          Note2File$(x,1) = Note2File$(x+1,1)
          Note2File$(x,2) = Note2File$(x+1,2)
          Note2File$(x,3) = Note2File$(x+1,3)
          NotesArray$(x) = NotesArray$(x+1)
       end if
    next  x
    'Need to destroy the orphan entry at end in the combobox array
    NotesArray$(NoteCount) = ""
    'There is one less note now!
    NoteCount = NoteCount - 1
    'Now resave the results and reload the combo box
    open ProjectPath$+ProjectName$ for output as #projectMaster
    print #projectMaster, ProjectTitle$
    print #projectMaster, NoteCount
    for x = 1 to NoteCount
       print #projectMaster, Note2File$(x,1)
       print #projectMaster, Note2File$(x,2)
       print #projectMaster, Note2File$(x,3)
    next x
    close #projectMaster
    'Update combo
    #main.combo "reload"
    #main.combo "selectindex 1"
    'Finally switch view back to Home (do this by going there)
    goto [home]

[refresh]
    timer 0
    CallDLL #browse, "DoPageAction", hWndCon As long, WEBPAGE.REFRESH As short, ret As void
    goto [loop]

[idle]
    'place code here
    goto [loop]


'Supplemental processing routines
'-------------------------------------------------------------------------

[MoreNotes]
   'expand the array size for our notes arrays

   MaxNotes = MaxNotes + 20

   for x = 1 to NoteCount
      TempNotesArray$(x) = NotesArray$(x)
      TempNote2File$(x,1) = Note2File$(x,1)
      TempNote2File$(x,2) = Note2File$(x,2)
      TempNote2File$(x,3) = Note2File$(x,3)
   next x

   redim NotesArray$(MaxNotes)
   redim Note2File$(MaxNotes,3)

   for x = 1 to NoteCount
      NotesArray$(x) = TempNotesArray$(x)
      Note2File$(x,1) = TempNote2File$(x,1)
      Note2File$(x,2) = TempNote2File$(x,2)
      Note2File$(x,3) = TempNote2File$(x,3)
   next x

   redim TempNotesArray$(MaxNotes)
   redim TempNote2File$(MaxNotes,3)

   return



'-----------------------------------------------------------------
'** Edit Notes - Dialog Window
[EditNote]

    timer 0

    EditNoteFlag$ = "New"

    WindowWidth = 774 : WindowHeight = 439
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

[EditNoteWindow]

groupbox    #edit.gbx1, "Instructions", 10, 294, 630, 105
statictext  #edit.st1, "", 25, 310, 600, 84
statictext  #edit.st2, "Note Name: ", 10, 10, 100, 25
textbox     #edit.tbx1, 110, 8, 205, 25
texteditor  #edit.tedit, 10, 38, 745, 252
button      #edit.save, "Save",[en.save],UL, 650, 325, 105, 30
button      #edit.cancel, "Cancel",[en.cancel],UL, 650, 365, 105, 30


Open "Edit Notes" for Window_nf as #edit

    #edit "trapclose [en.quit]"
    #edit "font ms_sans_serif 10 bold"
    #edit.save "!font ms_sans_serif 10"
    #edit.cancel "!font ms_sans_serif 10"
    #edit.tbx1 "!font ms_sans_serif 10"
    #edit.st1 "!font arial_narrow 11"

    #edit.tbx1 EditNoteTitle$

    Edit.Is.Open = 1

    h=hwnd(#edit)
    call RemoveMenu h

    instruction$ = "Enter your note text.  Notes are displayed by a " + _
                   "web plugin and can be enhanced using HTML. " + _
                   "Embed HTML as normal, examples: <b> </b> = bold, " + _
                   "<i> </i> = italics, <u> /u> = underline.  For more " + _
                   "HTML encoding such as font, images and etc see HELP.  " + _
                   "Hyperlinks must added as <<link=notename||Human Readable Link " + _
                   "Name>> - Do not use HREF Links.  Please see the HELP file for " + _
                   "more on linking notes."

    #edit.st1 instruction$
    #edit.tbx1 "!setfocus"

[en.loop]
    Wait

[en.quit]
    close #edit
    Edit.Is.Open = 0
    goto [loop]

[en.save]
    'see if this a new note or an edited note
    if EditNoteFlag$ = "New" then
        'Get the title
        #edit.tbx1 "!contents? NoteTitle$"
        if NoteTitle$ = "" then
            Notice "A title is required for this note - please add one."
            goto [en.loop]
        else
            'Make sure this title is not already in use
            errorFlag = 0
            for x = 1 to NoteCount
               if NotesArray$(x) = NoteTitle$ then errorFlag = 1
            next x
            if errorFlag = 1 then
                notice "This note title ("+NotTitle$+") already exists - please choose another."
                goto [en.loop]
            end if
            'force title case onto the title string
            TitleTemp$ = ""
            for x = 1 to len(NoteTitle$)
               if x = 1 then
                  TitleTemp$ = TitleTemp$ + upper$(mid$(NoteTitle$,1,1))
                  keepLast$ = mid$(NoteTitle$,1,1)
               else
                  if keepLast$ = " " then
                     TitleTemp$ = TitleTemp$ + upper$(mid$(NoteTitle$,x,1))
                  else
                     TitleTemp$ = TitleTemp$ + lower$(mid$(NoteTitle$,x,1))
                  end if
                  keepLast$ = mid$(NoteTitle$,x,1)
               end if
            next x
            NoteTitle$ = TitleTemp$
            'Now replace spaces and concatinate for filename
            NoteFileName$ = NoteTitle$
            NFNLen = len(NoteFileName$)
            for x = 1 to NFNLen
               if mid$(NoteFileName$,x,1) = " " then
                  NoteTemp$ = left$(NoteFileName$,x-1) + "_" + mid$(NoteFileName$,x+1)
                  NoteFileName$ = NoteTemp$
               end if
            next x
            'limit length to 32 letters
            if NFNLen > 32 then NoteFileName$ = left$(NoteFileName$,32)
            'This is the link name keep it
            LinkTitleName$ = NoteFileName$
            'Now see if there is a file called this yet
            NoteFileName$ = ProjectPath$+NoteFileName$+".htm"
            'Need to resolve the short path name - not really...
            'NoteFileName$ = GetShortPathName$(work$)
            if IsFile(NoteFileName$) = 0 then
                Notice "A note with this title (" + NoteTitle$ + _
                       ") already exists - please choose another name."
                goto [en.loop]
            end if
            'Now get the text from the texteditor and code the html
            #edit.tedit "!contents? AllText$"
            'We need to do a couple things - scan for HREF's which are not
            'permitted, and find and convert NoteBoard Links
            TextLen = Len(AllText$)
            if TextLen = 0 then
                notice "The Note does not appear to contain any text.  Unable to save the note."
                goto [en.loop]
            end if
            'begin scanning for HREF's
            if instr(upper$(AllText$),"<A HREF=") > 0 then
               notice "An external hyper link '<a HREF=...' was located in the note.  " + _
                      "Exernal links are not permitted in NoteBoard - sorry.  " + _
                      "Please correct the error and save again."
               goto [en.loop]
            end if
            'Now scan for the intenal note links
            pointer = 0
            last = 1
            terminator = 0
            work$ = ""
            while terminator = 0
                'locate the begining of a link
                a = instr(upper$(AllText$),"<<LINK",pointer)
                if a > 0 then
                   'check for link format errors
                   if mid$(AllText$,a+6,1) <> "=" or mid$(AllText$,a+7,1) = " " then
                      notice "An internal link is ill-formatted.  Please fix before saving.  " + _
                             "See HELP reference on Internal Note Links for more information."
                      goto [en.loop]
                   end if
                   'locate the end of a link
                   b = instr(upper$(AllText$),"||",a)
                   if b <= a then
                      notice "An internal link is ill-formatted.  Please fix before saving.  " + _
                             "See HELP reference on Internal Note Links for more information."
                      goto [en.loop]
                   end if
                   'calculate the link name length and get the link name
                   c = b-a-7
                   if c > 32 or c < 1 then
                      notice "An internal link is more than 32 characters long, or it is " + _
                             "less than one character long.  Please fix error before saving.  " + _
                             "See HELP reference on Internal Note Links for more information."
                      goto [en.loop]
                   end if
                   'Link name
                   link$ = mid$(AllText$,a+7,c)
                   'Links should not have any spaces - make the user insure they do not...
                   if instr(link$," ") > 0 then
                      notice "An internal link is ill-formatted.  Link names should contain no " + _
                             "blank spaces - located a Note Link with spaces - Please fix before saving.  " + _
                             "See HELP reference on Internal Note Links for more information."
                      goto [en.loop]
                   end if
                   'Now extract the human readable (it is optional)
                   e = instr(upper$(AllText$),">>",a)
                   if e = b + 2 then
                       'there is no human redable - use the link text
                       HRlink$ = link$
                   else
                      if e <=b then
                          'This is an ill-formed link
                          notice "An internal link is ill-formatted.  Please fix before saving.  " + _
                                 "See HELP reference on Internal Note Links for more information."
                          goto [en.loop]
                      end if
                      'We know enough to extract the human readable now
                      f = e-b-2
                      HRlink$ = mid$(AllText$,b+2,f)
                   end if
                   'Now format the text with the link name - first include all prevous text.
                   'if a = 1 then skip this step...
                   if a > 1 then
                      count = a - last
                      work$ = work$ + mid$(AllText$,last,count)
                   end if
                   'Now encode the link using an href and java induced cookie...
                   work$ = work$ + "<a href=" + chr$(34) + "javascript:navViaCookie(" + _
                                   chr$(39) + link$ + chr$(39) +")" + chr$(34)
                   work$ = work$ + "><font color=" + chr$(34) + "#0000FF" + chr$(34)
                   work$ = work$ + "><strong>" + HRlink$ + "</strong></font></a>"
                   'We have succesfully encoded the link - now update pointers so
                   'we can find the next link
                   last = e+2
                   pointer = last - 1
                else
                   'there were no more links located - copy the rest of the text to the working buffer
                   work$ = work$ + mid$(AllText$,last)
                   terminator = 99
                end if
            wend
            'This is where we write the html file out to the hard disk
            'All edits have passed and we have a good file - add note to the array
            'and write an HTML file out to the hard disk.
            If NoteCount = 1 and NotesArray$(1) = "<Add New Note>" then
               NotesArray$(1) = NoteTitle$
               Note2File$(1,1) = NoteTitle$
               Note2File$(1,2) = NoteFileName$
               Note2File$(1,3) = LinkTitleName$
            else
               if NoteCount + 1 > MaxNotes then gosub [MoreNotes]
               NoteCount = NoteCount + 1
               NotesArray$(NoteCount) = NoteTitle$
               Note2File$(NoteCount,1) = NoteTitle$
               Note2File$(NoteCount,2) = NoteFileName$
               Note2File$(NoteCount,3) = LinkTitleName$
            end if
            'now sort the NotesArray string and reload the contents of the combobox
            sort NotesArray$(), 1, NoteCount
            sort Note2File$(), 1, NoteCount, 1
            'Write the new file information out the project Masterfile
            open ProjectPath$+ProjectName$ for output as #projectMaster
            print #projectMaster, ProjectTitle$
            print #projectMaster, NoteCount
            for x = 1 to NoteCount
               print #projectMaster, Note2File$(x,1)
               print #projectMaster, Note2File$(x,2)
               print #projectMaster, Note2File$(x,3)
            next x
            close #projectMaster
            'Ok lets open the file and save our note!
            OPEN NoteFileName$ FOR output AS #noteFile
            open CurrentDir$+"\head.inc" for input as #headFile
            'Now write the header out there
            while not(eof(#headFile))
                line input #headFile, a$
                if a$ = "****BackGround****" then
                   a$ = "<body background=" + chr$(34) + "#ECE7D2" + chr$(34) + ">"
                end if
                if a$ = "****Title****" then
                   a$ = NoteTitle$
                end if
                print #noteFile, a$
            wend
            'Now write the rest of the file out there...
            for x = 1 to len(work$)
               if asc(mid$(work$,x,1)) = 13 then
                  print #noteFile, "<BR>"                 '+ chr$(13)
               else
                  if asc(mid$(work$,x,1)) <> 10 then
                     print #noteFile, mid$(work$,x,1);
                  end if
               end if
            next x
            'Now finish it off
            print #noteFile, "</p>"
            print #noteFile, "</body>"
            print #noteFile, "</html>"
            'Now close the files
            close #noteFile
            close #headFile
            'Now show the new file
            url$ = NoteFileName$
            CallDLL #browse, "DisplayHTMLPage", hWndCon As long, url$ As ptr, ret As long
            'update the current page - since we resorted we do not know the exact
            'number of the current page - we will look for it again.
            for x = 1 to NoteCount
               if NoteTitle$ = Note2File$(x,1) then
                 CurrentPage = x
                 exit for
               end if
            next x
        end if
    end if

    close #edit
    Edit.Is.Open = 0
    'Finally, now that we have close the edit window, reload he array into combo
    #main.combo "reload"
    #main.combo "selectindex 1"

    goto [loop]


[en.cancel]
    'place code here
    goto [en.quit]



'-------------------------------------------------------------------------------------
'  Get new project or open a project
'-------------------------------------------------------------------------------------
[getProject]

WindowWidth = 203
WindowHeight = 189
button      #project.new, "Start New Project",[sp.new],UL, 25, 15, 145, 30
button      #project.existing, "Open Existing Project",[sp.existing],UL, 25, 60, 145, 30
button      #project.close, "Close NoteBoard",[sp.quit],UL, 25, 105, 145, 30

Open "Project Select" for Dialog_modal as #project

    print #project, "trapclose [quit]"
    print #project, "font ms_sans_serif 10"

[sp.loop]
    Wait

[sp.quit]
    close #project
    goto [quit]

[sp.new]
    'place code here
    prompt "Enter a name for your new project";ProjectTitle$
    if ProjectTitle$ = "" then [sp.loop]
    filedialog "Save Project As...", "*.lnb", fileName$
    if fileName$ = "" then [sp.loop]
    if upper$(right$(fileName$,4)) <> ".LNB" then fileName$ = fileName$ + ".lnb"
    cnt = 0
    for x = len(fileName$) to 1 step -1
        cnt = cnt + 1
        if mid$(fileName$,x,1) = "\" then
           ProjectName$ = right$(fileName$,cnt-1)
           ProjectPath$ = left$(fileName$,x)
           exit for
       end if
    next x
    'get the shortname for the path
    lPath$ = ProjectPath$
    ProjectPath$ = GetShortPathName$(lPath$)
    open ProjectPath$+ProjectName$ for output as #projectMaster
    print #projectMaster, ProjectTitle$
    print #projectMaster, "0"
    close #projectMaster
    close #project
    return

[sp.existing]
    'place code here
    filedialog "Open Project File", "*.lnb", fileName$
    if fileName$ = "" then [sp.loop]
    'get the short name for the file and path
    lPath$ = fileName$
    fileName$ = GetShortPathName$(lPath$)
    'make sure the file exists
    if IsFile(fileName$) <> 0 then
       notice "The file specified (" + lPath$ + ") does not exist.  " + _
              "Please select a file that exists or open a new project."
       goto [sp.loop]
    end if
    cnt = 0
    for x = len(fileName$) to 1 step -1
        cnt = cnt + 1
        if mid$(fileName$,x,1) = "\" then
           ProjectName$ = right$(fileName$,cnt-1)
           ProjectPath$ = left$(fileName$,x)
           exit for
       end if
    next x
    'Read the Existing Project file information out the project Masterfile
    open ProjectPath$+ProjectName$ for input as #projectMaster
    line input #projectMaster, ProjectTitle$
    line input #projectMaster, a$
    NoteCount = val(a$)
    for x = 1 to NoteCount
        line input #projectMaster, a$
        Note2File$(x,1) = a$
        NotesArray$(x) = a$
        line input #projectMaster, a$
        Note2File$(x,2) = a$
        line input #projectMaster, a$
        Note2File$(x,3) = a$
    next x
    close #projectMaster
    close #project
    'force the combo to reload
    #main.combo "reload"
    #main.combo "selectindex 1"
    return

'-----------------------------------------------------------------------------------------
' Cookie Processing
'-----------------------------------------------------------------------------------------
[look4cookie]

    timer 0

    cookie$ = "LbNoteBoard"

    cookieSearch.searchString$.struct = cookie$
    cookieSearch.resultString$.struct = Space$(2048)

    CallDLL #cookie, "FindCookie",cookieSearch As ptr, result As long

    hits = cookieSearch.hits.struct

    'if the dll returned no hits  - go back to loop and wait and tick some more
    if hits = 0 then [loop]

    'if we are here then there was a cookie and therefore a link to process
    cookiePath$ = ""

    'Use the following rotine to separate the individual filenames from the string
    'The first string will be the path, the second string will be the filename.
    working$ = cookieSearch.resultString$.struct
    for x = 1 to hits 'there should really only be one of these...
      'find next pipe character
      pos = instr(working$,"|")
      'extract filename toleft of semi-collin
      file$ = left$(working$,pos-1)
      'delete file string from the string of filenames
      working$ = mid$(working$,pos+1,len(working$)-pos-1)
      if x = 1 then
         cookiePath$ = file$
      else
         fileNameW$ = cookiePath$ + file$
         'call short filename in case any cookies have spaces in thier names
         fileName$ = GetShortPathName$(fileNameW$)
      end if
    next x
    'Now we know where that cookie is - lets open it up
    open fileName$ for input as #cookieRead
    'terminate = 0
    'while terminate = 0
       line input #cookieRead, a$
       'if instr(a$,"NoteSelect:") > 0 then terminate = 1
    'wend
    close #cookieRead
    'Now that we are done with the cookie - delete it
    kill fileName$
    'Ok we have the data from the cookie - let's extract the link file name
    a = instr(a$,"NoteSelect:",1)+11
    b = instr(a$,chr$(10),a)
    b$ = mid$(a$,a,b-a)
    'Find that Title in the NoteTitle array
    fileName$ = ""
    for x = 1 to NoteCount
       if upper$(b$) = upper$(Note2File$(x,3)) then
          fileName$ = Note2File$(x,2)
          CurrentPage = x
          exit for
       end if
    next x
    'Make sure we hit one...
    if fileName$ <> "" then
       'We have a good file name - open the file and display
       url$ = fileName$
       CallDLL #browse, "DisplayHTMLPage", hWndCon As long, url$ As ptr, ret As long
       goto [loop]
    else
       'so this is a link to a page that does not exist - offer to create it
       confirm "The link you clicked points to a page that does not exist.  " + _
               "Would you like to open the page editor and create the page now?"; answer$
       if answer$ = "yes" then
           EditNoteTitle$ = b$
           goto [EditNote]
       else
           goto [loop]
       end if
    end if
    'we should never get here, but here to percauion...
    goto [loop]


[killMyCookie]

    timer 0

    cookie$ = "LbNoteBoard"

    cookieSearch.searchString$.struct = cookie$
    cookieSearch.resultString$.struct = Space$(2048)

    CallDLL #cookie, "FindCookie",cookieSearch As ptr, result As long

    cookiePath$ = ""
    hits = cookieSearch.hits.struct


    If hits > 0 Then
       'Use the following rotine to separate the individual filenames from the string
       'The first string will be the path, the second string will be the filename.
       working$ = cookieSearch.resultString$.struct
       for x = 1 to hits 'there should really only be one of these...
          'find next pipe character
          pos = instr(working$,"|")
          'etract filename toleft of semi-collin
          file$ = left$(working$,pos-1)
          'delete file string from the string of filenames
          working$ = mid$(working$,pos+1)
          if x = 1 then
             cookiePath$ = file$
          else
             fileNameW$ = cookiePath$ + file$
             'call short filename in case any cookies have spaces in thier names
             fileName$ = GetShortPathName$(fileNameW$)
             'finally - remove the file
             kill fileName$
          end if
        next x
    end if
return






'functions to support the tooltips for most controls...
'-----------------------------------------------------------------------
SUB MakeTooltips hWin
    TTS.ALWAYSTIP = 1 : TTS.NOPREFIX = 2 : style = _WS_POPUP or TTS.NOPREFIX or TTS.ALWAYSTIP
    calldll #comctl32,"InitCommonControls", re as void
    calldll #user32, "GetWindowLongA", hWin as long, _GWL_HINSTANCE as long, hInstance as long
    calldll #user32, "CreateWindowExA", _WS_EX_TOPMOST as long,"tooltips_class32" as ptr, "" as ptr,_
        style as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long,_
        hWin as long, 0 as long, hInstance as long, "" as ptr, hwndTT as long
    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    calldll #user32, "SetWindowPos", hwndTT as long,_HWND_TOPMOST as long, 0 as long, 0 as long, 0 as long, 0 as long, flags as long, r as long

    'create a struct for the tooltips:
    struct toolinfo, cbSize as long, uFlags as long, hWindow as long, uId as long, x as long, y as long, w as long, h as long, hInst as long, lpstrText$ as ptr
    toolinfo.cbSize.struct = len(toolinfo.struct)
    toolinfo.uFlags.struct = 1 Or 16
    toolinfo.hWindow.struct = hWin


'Bmpbutton Tooltip:
    toolinfo.uId.struct = hwnd(#main.new)
    toolinfo.lpstrText$.struct = "Create a new note for the board"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Bmpbutton Tooltip:
    toolinfo.uId.struct = hwnd(#main.help)
    toolinfo.lpstrText$.struct = "Get HELP for this application"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Bmpbutton Tooltip:
    toolinfo.uId.struct = hwnd(#main.go)
    toolinfo.lpstrText$.struct = "Jump to the selected note"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Bmpbutton Tooltip:
    toolinfo.uId.struct = hwnd(#main.home)
    toolinfo.lpstrText$.struct = "Go to the NoteBoard Home Page"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Bmpbutton Tooltip:
    toolinfo.uId.struct = hwnd(#main.edit)
    toolinfo.lpstrText$.struct = "Edit the current note"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Bmpbutton Tooltip:
    toolinfo.uId.struct = hwnd(#main.delete)
    toolinfo.lpstrText$.struct = "Delete the current note"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Bmpbutton Tooltip:
    toolinfo.uId.struct = hwnd(#main.refresh)
    toolinfo.lpstrText$.struct = "Refresh the current view"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long


    END SUB



' Other functions
'-----------------------------------------------------------------------
'Remove edit menu created by texteditor - code by Alyce
sub RemoveMenu hWindow
    CallDll #user32, "GetMenu", _
        hWindow as word,_
        hMenuBar as word

    calldll #user32, "SetMenu",_
       hWindow as word,_
       0 as word,_
       results as ushort

    calldll #user32, "DrawMenuBar",_
        hWnd as word,_
        result as void

end sub

Function FixBmp(bmp$) 'courtesy of Alyce Watson, June 21, 2002
    hImage = 0
    flags=_LR_LOADFROMFILE or _LR_LOADMAP3DCOLORS
    CallDLL #user32, "LoadImageA",_
    0 As long,_                 'instance handle
    bmp$ As ptr,_               'filename
    _IMAGE_BITMAP As ulong,_    'image type
    0 As long,_                 'width, 0=use image's width
    0 As long,_                 'height, 0=use image's height
    flags As long,_             'load flags... very important
    hImage As ulong             'handle to loaded bmp
    FixBmp = hImage
End Function

Function GetShortPathName$(lPath$) 'courtesy of Alyce Watson
    lPath$=lPath$+Chr$(0)
    sPath$=Space$(256)
    lenPath=Len(sPath$)
    CallDLL #kernel32, "GetShortPathNameA",lPath$ As ptr,_
    sPath$ As ptr,lenPath As long,r As long
    GetShortPathName$=Left$(sPath$,r)
End Function

function IsFile(fileName$)
    'Returns a zero if the file was located
    Open "IsFile32.dll" For DLL As #ff
    fileName$ = fileName$ + Chr$(0)
    CallDLL #ff, "IsFile",fileName$ As ptr, result As long
    close #ff
    IsFile = result
end function


























