''''''''''''''''''''''''''''''''''''''''''''
'                                          '
' CollSim - The Collision Simulator        '
'                                          '
' (c) Copyright Tomas J. Nally             '
'     March 2003                           '
'     Steelweaver52@aol.com                '
'                                          '
'     Released as Open Source              '
'                                          '
''''''''''''''''''''''''''''''''''''''''''''
'                                          '
' Sure it's fun.  But please, no wagering! '
'                                          '
''''''''''''''''''''''''''''''''''''''''''''
'                                          '
' CollSim is made with                     '
' + Liberty BASIC by Carl Gundel           '
' + Liberty BASIC Workshop by Alyce Watson '
' + Microsoft Paint and Excel by MS        '
'                                          '
' CollSim Help File is made with           '
' + WikiWriter by Jerry Muelver            '
' + Easy Thumbnails                        '
' + ScreenPrint32                          '
'                                          '
' CollSim Help File Reader is the          '
' LB Newsletter Reader by                  '
' Alyce Watson, which itself is based      '
' on LB Browser 1.00 by                    '
' Doyle Whisenant - mechanic@sonet.net.    '
'                                          '
' Thanks!  That's great stuff, people.     '
'                                          '
''''''''''''''''''''''''''''''''''''''''''''

   ' The LB Newsletter Reader, in turn, is based on:
   ' LB Browser 1.00
   ' Doyle Whisenant - mechanic@sonet.net


     True = 1 : False = 0
    pi(1) = 4*atn(1)
    Pi(1) = 4*atn(1)
       pi = 4*atn(1)
       Pi = 4*atn(1)


    BallPosEnabledGeneral = 0
    Ball01PosEnabled = 1      'Begin the simulation with Ball01 enabled for positioning
    Ball02PosEnabled = 0      'within the arena.
    Ball03PosEnabled = 0
    Ball04PosEnabled = 0
    Ball05PosEnabled = 0
    Ball06PosEnabled = 0
     XhairPosEnabled = 0

    BallSelectionIndex = 1
          InstVelIndex = 6
        InstInitialVel = 200
       ElasticityIndex = 1
            Elasticity = 0.99
                    SR = 50/49   'SR is the "Stretch Ratio".  This factor is used to
                                 'creater greater separation between two balls that have
                                 'just collided, so that they do not get locked within
                                 'their zone of collision.

                   VDF = 0.9999  'This is the "Velocity decay factor".  It is used to reduce
                                 'the velocity of each ball by a tiny fraction during each
                                 'each cycle of analysis.

         TotalCompTime = 0       'This variable indicates to the user how long it
                                 'takes to process all the thousands of postions of
                                 'the balls.

                   BPC = 6000    'BPC is the "Ball Position Count".  This is the number of positions
                                 'counted during the simulation.  Faster computers can make use
                                 'of the higher counts without sacrificing the simulation
                                 'appearance.  Slower computers need to use the lower BPCs.
                                 'The BPC is set when the user changes the Simulation Speed
                                 'on the menu.

             SimSpeed$ = "Slowest"  'This is the indicator which tells the user the current
                                    'Simulation speed as set using the SimulationSpeed menu.

                   TSS = 100     'TSS stands for "Time Slices per Second".  This is an indicator
                                 'of how many times per second the ball positions are calculated.
                                 'Fast computers can calculate the ball position many times per
                                 'second without loss of simulation effect.  Slow computers must
                                 'calculate fewer positions of the ball per second.  The TSS is set
                                 'When the user sets the Simulation Speed from the menu.
                                 '
                                 'Simulation Speed     BPC    TSS
                                 '-------------------------------
                                 '1 - Slowest..........6000...100
                                 '2 - Slow.............5000... 80
                                 '3 - Medium...........4000... 60
                                 '4 - Fast.............3000... 40
                                 '5 - Fastest..........2000... 20

          ReplayEnabled = 0      'This variable determines whether the Replay button is enabled or
                                 'disabled.  At startup, it is disabled.  After a simulation is run,
                                 'the replay button is enabled.  Then, during the ball position calculating
                                 'process, the Replay button is disabled again until the simulation
                                 'is over.

     PhaseONEinProgress = 0      'These two variables are flags which tell program control
     PhaseTWOinProgress = 0      'whether the simulation is in progress or not.  If it is,
                                 'and if the mouse is moved in the arena, then the entire
                                 'system will be reset.


'Import Bitmaps for Sprites
LOADBMP "Ball01Inst",    "Ball01Inst.bmp"
LOADBMP "Ball02Blue",    "Ball02Blue.bmp"
LOADBMP "Ball03Red",     "Ball03Red.bmp"
LOADBMP "Ball04Green",   "Ball04Green.bmp"
LOADBMP "Ball05Purple",  "Ball05Purple.bmp"
LOADBMP "Ball06Gray",    "Ball06Gray.bmp"

'Import Bitmap for CrossHairs
LOADBMP "Xhair",    "Xhair.bmp"

'Import Bitmap for Background
LOADBMP "ArenaBkgd",     "ArenaBkgd.bmp"

'Dimension all arrays
Dim BallNames$(6)
BallNames$(1) = "The Instigator"
BallNames$(2) = "Blue Ball"
BallNames$(3) = "Red Ball"
BallNames$(4) = "Green Ball"
BallNames$(5) = "Purple Ball"
BallNames$(6) = "Gray Ball"

Dim InstVel(11)
Dim InstVel$(11)
For i = 1 to 11
     InstVel(i) = 100 + (i-1)*20
    InstVel$(i) = str$(InstVel(i)) + " per second"
next i

Dim Elasticity(10)
Dim Elasticity$(10)

For i = 1 to 10
    Elasticity(i) = 1.0 - (i * 0.01)
next i

Elasticity$(1)  = "99 %"
Elasticity$(2)  = "98 %"
Elasticity$(3)  = "97 %"
Elasticity$(4)  = "96 %"
Elasticity$(5)  = "95 %"
Elasticity$(6)  = "94 %"
Elasticity$(7)  = "93 %"
Elasticity$(8)  = "92 %"
Elasticity$(9)  = "91 %"
Elasticity$(10) = "90 %"

Dim BallX(6000,6)        'The X location of the ball in the arena
Dim BallY(6000,6)        'The Y location of the ball in the arena
Dim BallSpriteX(6000,6)  'The X location of the ball sprite in the graphic box
Dim BallSpriteY(6000,6)  'The Y location of the ball sprite in the graphic box
Dim BallVelMag(6)         'Magnitude of the ball velocity
Dim BallVelX(6)           'X component of the ball's velocity
Dim BallVelY(6)           'Y component of the ball's velocity
Dim BallTheta(6)          'The angle of the ball's path during the simulation

BallSpriteX(0,1) = 200    '
BallSpriteY(0,1) = 200    '
BallSpriteX(0,2) = 80     '
BallSpriteY(0,2) = 20     'Assign the initial position
BallSpriteX(0,3) = 140    'of the ball sprites for all
BallSpriteY(0,3) = 20     'six balls.
BallSpriteX(0,4) = 200    '
BallSpriteY(0,4) = 20     '
BallSpriteX(0,5) = 260    '
BallSpriteY(0,5) = 20     '
BallSpriteX(0,6) = 320    '
BallSpriteY(0,6) = 20     '

for i = 1 to 6                            'Determine the arena location of each
    BallX(0,i) = BallSpriteX(0,i) - 18    'of the six balls based on the sprite
    BallY(0,i) = 361 - BallSpriteY(0,i)   'location of the balls
next i                                '

XhairSpriteX = 300                 'Initial coordinates of the CrossHair Sprite.
XhairSpriteY = 120                 'These values are then used to find the
XhairArenaX = XhairSpriteX - 28    'arena coordinates of the CrossHair object
XhairArenaY = 371 - XhairSpriteY   '

'Find the initial angle of the Instigator in Radians
BallTheta(1) = ATAN2((XhairArenaX - BallX(0,1)),(XhairArenaY - BallY(0,1)))

For i = 2 to 6          'This loop sets the initial angle of
    BallTheta(i) = 0    'motion of balls 2 through 6 during the
next i                  'simulation.  The angle of Ball1, the Instigator, is
                        'set above.

For i = 2 to 6
    BallVelMag(i) = 0
    BallVelX(i)   = BallVelMag(i)*cos(BallTheta(i))
    BallVelY(i)   = BallVelMag(i)*sin(BallTheta(i))
next i

[InitColors]
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"

[WindowSetup]
    NOMAINWIN
    WindowWidth = 630 : WindowHeight = 560
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Menu        #BallSim, "&File" , "E&xit", [btnQuit.click]
Menu        #BallSim, "SimulationSpeed" , "1 - Slowest", [SimSpeed.Slowest], _
                                          "2 - Slow",    [SimSpeed.Slow], _
                                          "3 - Medium",  [SimSpeed.Medium], _
                                          "4 - Fast",    [SimSpeed.Fast], _
                                          "5 - Fastest", [SimSpeed.Fastest]

Menu        #BallSim, "Help" , "Collision Simulatior Help",    [Help.Help], |, _
                               "About Collision Simulator...", [Help.About]

graphicbox  #BallSim.GBox1, 180, 20, 422, 422



CHECKBOX    #BallSim.ckBallPos, "Enable Ball Positioning",  [BPset], [BPreset], 10, 10, 160, 20
CHECKBOX    #BallSim.ckXhairs,  "Enable Xhair Positioning", [XHset], [XHreset], 10, 180, 160, 20

listbox     #BallSim.BallListBox, BallNames$(,[BallListBox.click], 10, 35, 150, 135

statictext  #BallSim.Static02, "Set Instigator Velocity", 15, 210, 150, 20
statictext  #BallSim.Static03, "Set Collision Elasticity", 15, 265, 150, 20
statictext  #BallSim.Static05, "Sim Speed = Slowest     ", 15, 325, 150, 20
statictext  #BallSim.Static04, "Status:", 20, 465, 50, 20

button      #BallSim.btnGo, "GO!",[btnGo.click],UL, 15, 350, 85, 55
button      #BallSim.btnReplay, "Replay",[btnReplay.click],UL, 105, 350, 60, 55
button      #BallSim.cboStopSim, "Stop Simulation",[btnStopSim.click],UL, 15, 410, 150, 25
button      #BallSim.btnQuit, "Quit",[btnQuit.click],UL, 520, 455, 80, 30

combobox    #BallSim.cboInstVelocity,InstVel$(,[cboInstVelocity.click], 15, 230, 150, 180
combobox    #BallSim.cboCollElasticity,Elasticity$(,[cboCollElasticity.click], 15, 285, 150, 180

textbox     #BallSim.txtStatus, 80, 460, 435, 25


Open "CollSim - The Collision Simulator" for Window as #BallSim

    print #BallSim, "trapclose [btnQuit.click]"
    print #BallSim.GBox1, "down; fill White; flush"
    print #BallSim.GBox1, "setfocus; when mouseMove [MouseChange1]"
    print #BallSim.GBox1, "setfocus; when leftButtonUp [LeftButtonUp01]"
    print #BallSim, "font arial 10"

    'Add all sprites
    print #BallSim.GBox1, "addsprite Ball02Blue   Ball02Blue"
    print #BallSim.GBox1, "addsprite Ball03Red    Ball03Red"
    print #BallSim.GBox1, "addsprite Ball04Green  Ball04Green"
    print #BallSim.GBox1, "addsprite Ball05Purple Ball05Purple"
    print #BallSim.GBox1, "addsprite Ball06Gray   Ball06Gray"
    print #BallSim.GBox1, "addsprite Ball01Inst   Ball01Inst"

    'Add CrossHair Sprite
    print #BallSim.GBox1, "addsprite Xhair Xhair"

    'Add Background
    print #BallSim.GBox1, "background ArenaBkgd"

    'Position all sprites
    print #BallSim.GBox1, "spritexy Ball01Inst   200 200"
    print #BallSim.GBox1, "spritexy Ball02Blue    80  20"
    print #BallSim.GBox1, "spritexy Ball03Red    140  20"
    print #BallSim.GBox1, "spritexy Ball04Green  200  20"
    print #BallSim.GBox1, "spritexy Ball05Purple 260  20"
    print #BallSim.GBox1, "spritexy Ball06Gray   320  20"
    print #BallSim.GBox1, "spritexy Xhair        300 120"

    print #BallSim.GBox1, "drawsprites"


    Call MakeTooltips HWND(#BallSim)
    Gosub [Initialize.All.Controls]

[loop]
    Wait


[btnQuit.click]
    close #BallSim : END
    Wait

[Initialize.All.Controls]

    print #BallSim.BallListBox, "singleclickselect"
    print #BallSim.BallListBox, "selectindex "; BallSelectionIndex
    print #BallSim.cboInstVelocity, "selectindex "; InstVelIndex        '
    InstInitialVel = InstVel(InstVelIndex)                              'Instigator must have an initial
    BallVelMag(1)  = InstInitialVel                                     'velocity value
    BallVelX(1)    = BallVelMag(1)*cos(BallTheta(1))                    '
    BallVelY(1)    = BallVelMag(1)*sin(BallTheta(1))                    '

    print #BallSim.cboCollElasticity, "selectindex "; ElasticityIndex 'Make sure that Elasticity
    Elasticity = Elasticity(ElasticityIndex)                          'has an initial value

    Ball01SpriteX = 200                  'Initial coordinates of
    Ball01SpriteY = 200                  'the Instigator Sprite; and
    Ball01ArenaX  = Ball01SpriteX - 18   'initial coordinates of the Instigator
    Ball01ArenaY  = 361 - Ball01SpriteY  'in the arena.

    XhairSpriteX = 300                   'Initial coordinates of
    XhairSpriteY = 120                   'the CrossHair Sprite; and
    XhairArenaX  = XhairSpriteX - 28     'initial coordinates of the CrossHair
    XhairArenaY  = 371 - XhairSpriteY    'object in the arena.

    ReplayEnabled = 0                                            'Disable the "Replay" button at program
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled    'startup.

    Return

[MouseChange1]

    if ((PhaseONEinProgress = 1) or (PhaseTWOinProgress = 1)) then
        Notice "CollSim Simulation Stopped" + chr$(13) + _
               "Moving the mouse pointer into the         " + chr$(13) + _
               "arena once the simulation has begun       " + chr$(13) + _
               "will halt the simulation and confuse      " + chr$(13) + _
               "ball position tracking.  Please close     " + chr$(13) + _
               "and restart the application.              "

        PhaseONEinProgress = 0
        PhaseTWOinProgress = 0

    end if


    'MouseX and MouseY contain mouse coordinates.
    'Determine the arena coordinates of the mouse based on
    'MouseX and MouseY
    MouseArenaX = (MouseX - 38)
    MouseArenaY = (381- MouseY)


    If ((Ball01PosEnabled = 0) and (XhairPosEnabled = 0)) then
        print #BallSim.txtStatus, " MouseArenaX = "; MouseArenaX; " MouseArenaY = "; MouseArenaY
    end if

    'If ball positioning, in general is enabled, and
    'the positioning of Ball01 is enabled, then
    'attach the Ball01 sprite to the mouse pointer, and let
    'it track the mouse pointer around the arena.
    If ((Ball01PosEnabled = 1) and (BallPosEnabledGeneral = 1)) then
        Ball01SpriteX = MouseX - 20
        if (Ball01SpriteX < 39) then Ball01SpriteX = 39
        if (Ball01SpriteX > 378) then Ball01SpriteX = 378
        Ball01SpriteY = MouseY - 20
        if (Ball01SpriteY < 1) then Ball01SpriteY = 1
        if (Ball01SpriteY > 340) then Ball01SpriteY = 340
        Ball01ArenaX = Ball01SpriteX - 18
        Ball01ArenaY = 361 - Ball01SpriteY
        BallTheta(1) = ATAN2((XhairArenaX - Ball01ArenaX),(XhairArenaY - Ball01ArenaY))
        print #BallSim.GBox1, "spritexy Ball01Inst ";  Ball01SpriteX; " "; Ball01SpriteY
        print #BallSim.txtStatus, "InstigatorX = "; Ball01ArenaX; " InstigatorY = "; Ball01ArenaY; " Angle = "; BallTheta(1)*57.296
        print #BallSim.GBox1, "drawsprites"
        xx01 = (Ball01SpriteX + 20) : yy01 = (Ball01SpriteY + 20)
        xx02 = (XhairSpriteX + 10)  : yy02 = (XhairSpriteY + 10)
        print #BallSim.GBox1, "line "; xx01; " "; yy01; " "; xx02; " "; yy02
        BallSpriteX(0,1) = Ball01SpriteX
        BallSpriteY(0,1) = Ball01SpriteY
    End if

    'If ball positioning, in general is enabled, and
    'the positioning of Ball02 is enabled, then
    'attach the Ball02 sprite to the mouse pointer, and let
    'it track the mouse pointer around the arena.
    If ((Ball02PosEnabled = 1) and (BallPosEnabledGeneral = 1)) then
        Ball02SpriteX = MouseX - 20
        if (Ball02SpriteX < 39) then Ball02SpriteX = 39
        if (Ball02SpriteX > 378) then Ball02SpriteX = 378
        Ball02SpriteY = MouseY - 20
        if (Ball02SpriteY < 1) then Ball02SpriteY = 1
        if (Ball02SpriteY > 340) then Ball02SpriteY = 340
        Ball02ArenaX = Ball02SpriteX - 18
        Ball02ArenaY = 361 - Ball02SpriteY
        print #BallSim.GBox1, "spritexy Ball02Blue ";  Ball02SpriteX; " "; Ball02SpriteY
        print #BallSim.txtStatus, "BlueBallX = "; Ball02ArenaX; " BlueBallY = "; Ball02ArenaY
        print #BallSim.GBox1, "drawsprites"
        BallSpriteX(0,2) = Ball02SpriteX
        BallSpriteY(0,2) = Ball02SpriteY
    End if

    'If ball positioning, in general is enabled, and
    'the positioning of Ball03 is enabled, then
    'attach the Ball03 sprite to the mouse pointer, and let
    'it track the mouse pointer around the arena.
    If ((Ball03PosEnabled = 1) and (BallPosEnabledGeneral = 1)) then
        Ball03SpriteX = MouseX - 20
        if (Ball03SpriteX < 39) then Ball03SpriteX = 39
        if (Ball03SpriteX > 378) then Ball03SpriteX = 378
        Ball03SpriteY = MouseY - 20
        if (Ball03SpriteY < 1) then Ball03SpriteY = 1
        if (Ball03SpriteY > 340) then Ball03SpriteY = 340
        Ball03ArenaX = Ball03SpriteX - 18
        Ball03ArenaY = 361 - Ball03SpriteY
        print #BallSim.GBox1, "spritexy Ball03Red ";  Ball03SpriteX; " "; Ball03SpriteY
        print #BallSim.txtStatus, "RedBallX = "; Ball03ArenaX; " RedBallY = "; Ball03ArenaY
        print #BallSim.GBox1, "drawsprites"
        BallSpriteX(0,3) = Ball03SpriteX
        BallSpriteY(0,3) = Ball03SpriteY
    End if

    'If ball positioning, in general is enabled, and
    'the positioning of Ball04 is enabled, then
    'attach the Ball04 sprite to the mouse pointer, and let
    'it track the mouse pointer around the arena.
    If ((Ball04PosEnabled = 1) and (BallPosEnabledGeneral = 1)) then
        Ball04SpriteX = MouseX - 20
        if (Ball04SpriteX < 39) then Ball04SpriteX = 39
        if (Ball04SpriteX > 378) then Ball04SpriteX = 378
        Ball04SpriteY = MouseY - 20
        if (Ball04SpriteY < 1) then Ball04SpriteY = 1
        if (Ball04SpriteY > 340) then Ball04SpriteY = 340
        Ball04ArenaX = Ball04SpriteX - 18
        Ball04ArenaY = 361 - Ball04SpriteY
        print #BallSim.GBox1, "spritexy Ball04Green ";  Ball04SpriteX; " "; Ball04SpriteY
        print #BallSim.txtStatus, "GreenBallX = "; Ball04ArenaX; " GreenBallY = "; Ball04ArenaY
        print #BallSim.GBox1, "drawsprites"
        BallSpriteX(0,4) = Ball04SpriteX
        BallSpriteY(0,4) = Ball04SpriteY
    End if

    'If ball positioning, in general is enabled, and
    'the positioning of Ball05 is enabled, then
    'attach the Ball05 sprite to the mouse pointer, and let
    'it track the mouse pointer around the arena.
    If ((Ball05PosEnabled = 1) and (BallPosEnabledGeneral = 1)) then
        Ball05SpriteX = MouseX - 20
        if (Ball05SpriteX < 39) then Ball05SpriteX = 39
        if (Ball05SpriteX > 378) then Ball05SpriteX = 378
        Ball05SpriteY = MouseY - 20
        if (Ball05SpriteY < 1) then Ball05SpriteY = 1
        if (Ball05SpriteY > 340) then Ball05SpriteY = 340
        Ball05ArenaX = Ball05SpriteX - 18
        Ball05ArenaY = 361 - Ball05SpriteY
        print #BallSim.GBox1, "spritexy Ball05Purple ";  Ball05SpriteX; " "; Ball05SpriteY
        print #BallSim.txtStatus, "PurpleBallX = "; Ball05ArenaX; " PurpleBallY = "; Ball05ArenaY
        print #BallSim.GBox1, "drawsprites"
        BallSpriteX(0,5) = Ball05SpriteX
        BallSpriteY(0,5) = Ball05SpriteY
    End if

    'If ball positioning, in general is enabled, and
    'the positioning of Ball06 is enabled, then
    'attach the Ball06 sprite to the mouse pointer, and let
    'it track the mouse pointer around the arena.
    If ((Ball06PosEnabled = 1) and (BallPosEnabledGeneral = 1)) then
        Ball06SpriteX = MouseX - 20
        if (Ball06SpriteX < 39) then Ball06SpriteX = 39
        if (Ball06SpriteX > 378) then Ball06SpriteX = 378
        Ball06SpriteY = MouseY - 20
        if (Ball06SpriteY < 1) then Ball06SpriteY = 1
        if (Ball06SpriteY > 340) then Ball06SpriteY = 340
        Ball06ArenaX = Ball06SpriteX - 18
        Ball06ArenaY = 361 - Ball06SpriteY
        print #BallSim.GBox1, "spritexy Ball06Gray ";  Ball06SpriteX; " "; Ball06SpriteY
        print #BallSim.txtStatus, "GrayBallX = "; Ball06ArenaX; " GrayBallY = "; Ball06ArenaY
        print #BallSim.GBox1, "drawsprites"
        BallSpriteX(0,6) = Ball06SpriteX
        BallSpriteY(0,6) = Ball06SpriteY
    End if

    'If crosshair positioning is enabled, then attach the
    'crosshair sprite to the Mouse pointer, and let
    'crosshair sprite track the Mouse pointer around the arena.
    if (XhairPosEnabled = 1) then
        XhairSpriteX = MouseX - 10
        if (XhairSpriteX < 39) then XhairSpriteX = 39
        if (XhairSpriteX > 398) then XhairSpriteX = 398
        XhairSpriteY = MouseY - 10
        if (XhairSpriteY < 1) then XhairSpriteY = 1
        if (XhairSpriteY > 360) then XhairSpriteY = 360
        XhairArenaX = XhairSpriteX - 28
        XhairArenaY = 371 - XhairSpriteY
        BallTheta(1) = ATAN2((XhairArenaX - Ball01ArenaX),(XhairArenaY - Ball01ArenaY))
        print #BallSim.GBox1, "spritexy Xhair ";  XhairSpriteX; " "; XhairSpriteY
        print #BallSim.txtStatus, "CrossHairX = "; XhairArenaX; " CrossHairY = "; XhairArenaY; " Angle = "; BallTheta(1)*57.296
        print #BallSim.GBox1, "drawsprites"
        xx01 = (Ball01SpriteX + 20) : yy01 = (Ball01SpriteY + 20)
        xx02 = (XhairSpriteX + 10)  : yy02 = (XhairSpriteY + 10)
        print #BallSim.GBox1, "line "; xx01; " "; yy01; " "; xx02; " "; yy02
    end if

    Wait

[LeftButtonUp01]

    'If the Left Button is pressed while ball movement is
    'enabled, then the user is fixing a position of one of
    'the balls.  Therefore, disable movement of all balls
    'so that the user can select another ball to place
    'in position.

    If (BallPosEnabledGeneral = 1) then
        Ball01PosEnabled = 0
        Ball02PosEnabled = 0
        Ball03PosEnabled = 0
        Ball04PosEnabled = 0
        Ball05PosEnabled = 0
        Ball06PosEnabled = 0
    end if

    'If the Left Button is pressed while the Crosshair
    'is being moved around, then fix the position of
    'the crosshair, and disallow it from being
    'enabled, so that it remains in its current position.

    if (XhairPosEnabled = 1) then
        XhairPosEnabled = 0
    end if

    Wait

[BallListBox.click]
    print #BallSim.BallListBox, "selectionindex? BallSelectionIndex"
    print #BallSim.txtStatus, "Ball selected for positioning = "; BallSelectionIndex

    Ball01PosEnabled = 0
    Ball02PosEnabled = 0
    Ball03PosEnabled = 0
    Ball04PosEnabled = 0
    Ball05PosEnabled = 0
    Ball06PosEnabled = 0

    SELECT CASE BallSelectionIndex
    CASE 1
        Ball01PosEnabled = 1
    CASE 2
        Ball02PosEnabled = 1
    CASE 3
        Ball03PosEnabled = 1
    CASE 4
        Ball04PosEnabled = 1
    CASE 5
        Ball05PosEnabled = 1
    CASE 6
        Ball06PosEnabled = 1
    END SELECT

    Wait

[cboInstVelocity.click]
    print #BallSim.cboInstVelocity, "selectionindex? InstVelIndex"
    InstInitialVel = InstVel(InstVelIndex) 'Instigator's Initial Velocity
    BallVelMag(1)  = InstInitialVel
    print #BallSim.txtStatus, "Instigator initial velocity = "; InstInitialVel; " per second"

    ReplayEnabled = 0                                            'Disable the "Replay" button when the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled    'initial velocity combobox is selected

    Wait

[cboCollElasticity.click]
    print #BallSim.cboCollElasticity, "selectionindex? ElasticityIndex"
    Elasticity = Elasticity(ElasticityIndex)
    print #BallSim.txtStatus, "Collision elasticity = "; Elasticity

    ReplayEnabled = 0                                            'Disable the "Replay" button when the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled    'elasticity combobox is selected

    Wait




[BPset]
    BallPosEnabledGeneral = 1
    print #BallSim.txtStatus, "Ball positioning enabled; crosshair positioning disabled."
    print #BallSim.ckXhairs, "reset"
    XhairPosEnabled = 0

    ReplayEnabled = 0                                           'Disable Replay if the user wants
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'to reposition any of the balls.

    Wait

[BPreset]
    BallPosEnabledGeneral = 0
    print #BallSim.txtStatus, "Ball positioning disabled; crosshair positioning disabled."
    print #BallSim.ckXhairs, "reset"
    XhairPosEnabled = 0
    Wait

[XHset]
    XhairPosEnabled = 1
    print #BallSim.ckBallPos, "reset"
    BallPosEnabledGeneral = 0
    print #BallSim.txtStatus, "Crosshair positioning enabled; ball positioning disabled."

    ReplayEnabled = 0                                           'Disable Replay if the user wants to
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   're-position the crosshairs

    Wait

[XHreset]
    XhairPosEnabled = 0
    print #BallSim.ckBallPos, "reset"
    BallPosEnabledGeneral = 0
    print #BallSim.txtStatus, "Crosshair positioning disabled; ball positioning disabled."

    ReplayEnabled = 0                                           'Disable Replay if the user resets
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'the crosshairs

    Wait

[SimSpeed.Slowest]

    SimSpeed$ = "Slowest"
    BPC = 6000
    TSS = 100
    Print #BallSim.Static05, "Sim Speed = Slowest"
    print #BallSim.txtStatus, "Simulation speed = Slowest; BPC = 6000; TSS = 100"

    ReplayEnabled = 0                                           'Disable Replay when the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'SimSpeed is changed

    Wait

[SimSpeed.Slow]

    SimSpeed$ = "Slow"
    BPC = 5000
    TSS = 80
    Print #BallSim.Static05, "Sim Speed = Slow"
    print #BallSim.txtStatus, "Simulation speed = Slow; BPC = 5000; TSS = 80"

    ReplayEnabled = 0                                           'Disable Replay when the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'SimSpeed is changed

    Wait

[SimSpeed.Medium]

    SimSpeed$ = "Medium"
    BPC = 4000
    TSS = 60
    Print #BallSim.Static05, "Sim Speed = Medium"
    print #BallSim.txtStatus, "Simulation speed = Medium; BPC = 4000; TSS = 60"

    ReplayEnabled = 0                                           'Disable Replay when the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'SimSpeed is changed

    Wait

[SimSpeed.Fast]

    SimSpeed$ = "Fast"
    BPC = 3000
    TSS = 40
    Print #BallSim.Static05, "Sim Speed = Fast"
    print #BallSim.txtStatus, "Simulation speed = Fast; BPC = 3000; TSS = 40"

    ReplayEnabled = 0                                           'Disable Replay when the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'SimSpeed is changed

    Wait

[SimSpeed.Fastest]

    SimSpeed$ = "Fastest"
    BPC = 2000
    TSS = 20
    Print #BallSim.Static05, "Sim Speed = Fastest"
    print #BallSim.txtStatus, "Simulation speed = Fastest; BPC = 2000; TSS = 20"

    ReplayEnabled = 0                                           'Disable Replay when the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'SimSpeed is changed

    Wait



[Help.Help]

    Run "HelpReader.tkn"

    Wait

[Help.About]

    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"

    NOMAINWIN
    WindowWidth = 538 : WindowHeight = 320
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

button      #About.btnAlright, "Yeah, whatever",[btnAlright.click],UL, 400, 255, 115, 25
bmpbutton   #About.bmpAboutSplash, "AboutSplash.bmp",[bmpAboutSplash.click],UL, 10, 10

Open "About the Collision Simulator" for Dialog as #About

    print #About, "trapclose [btnAlright.click]"
    print #About, "font arial 10"

[About.loop]
    Wait

[btnAlright.click]
    close #About
    Wait

[bmpAboutSplash.click]
    'place code here
    Wait


[btnGo.click]

    ReplayEnabled = 0                                           'Disable the "Replay" button during the calculation of the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'ball positions and the simulation.

    for j = 1 to 6                            '
        BallX(0,j) = BallSpriteX(0,j) - 18    'Before collisions are simulated, make sure that
        BallY(0,j) = 361 - BallSpriteY(0,j)   'all of the ball sprite positions are consistent
    next j                                    'with the ball arena positions


    BallOverlap = 0                                      'Before proceeding with the collision
                                                         'simulation, makes sure that the user
    For i = 1 to 5                                       'has not placed any balls in any
        for j = (i + 1) to 6                             'overlapping positions.  If he has,
            DeltaXX = BallX(0,j) - BallX(0,i)            'then provide a Notice box asking the
            DeltaYY = BallY(0,j) - BallY(0,i)            'user to relocate the balls.
            CheckDistance = sqr(DeltaXX^2 + DeltaYY^2)
            If ( CheckDistance < 42 ) Then
                BallOverlap = 1
                i = 5
                j = 6
            end if
        next j
    next i

    If ( BallOverlap = 1 ) then
        Notice "The Collision Simulator" + chr$(13) + _
               "Two or more balls may be in overlapping     " + chr$(13) + _
               "positions.  Move one or more balls to       " + chr$(13) + _
               "a clear position.                           "
    end if

    If ( BallOverlap = 1 ) then wait

    'If control arrives at this point, then
    'no balls overlap at the start of the
    'simulation.

    PhaseONEinProgress = 1   'This indicates that Phase 1 is in progress, and
                             'a Mouse Move event should not disrupt the simulation.

    TI = 1/TSS  'Establish the Time Interval.  TSS is "Time Slices Per Second"
                'TSS is set during selection of the simulation speed.
                'Faster computers need slower simulation speeds, and can
                'process more Time Slices Per Second.  Slower computers want
                'a faster simulation speed, and will want to process fewer
                'Time Slices per second.  At startup, TSS is set to 100.

    StartCompTime = Time$("ms")

    For i = 1 to BPC
        SCAN
        print #BallSim.txtStatus, "Calculating ball position for Time Interval = "; i
        For j = 1 to 6
            BallVelMag(j) = BallVelMag(j)*VDF   'Reduce the velocity of the ball bay a very
                                                'small amount during each cycle of the analysis.
            BallX(i,j) = BallX((i-1),j) + (BallVelMag(j) * TI)*cos(BallTheta(j))
            BallY(i,j) = BallY((i-1),j) + (BallVelMag(j) * TI)*sin(BallTheta(j))
        next j

        'With the current X & Y locations of each of the six
        'balls established, use the positions of the others
        'balls and the locations of the walls to determine
        'where each of the balls will be during the next
        'iteration through the loop

        'First, for each of the six balls, determine if any
        'of the balls are making contact with any of the four
        'walls.  If they are, then adjust the BallVelMag()
        'and the BallTheta() accordingly.

        Gosub [Check.All.Six.Balls.For.Wall.Collisions]

        For j = 2 to 6
            MotionSolved(j) = 0
        next j

        'Determine if the Instigator undergoes any collisions with
        'the other five balls
        Gosub [Check.Instigator.For.Collisions.During.This.Time.Interval]

        If (MotionSolved(2) = 0) then
            Gosub [Check.BlueBall.For.Collisions.During.This.Time.Interval]
        end if

        If (MotionSolved(3) = 0) then
            Gosub [Check.RedBall.For.Collisions.During.This.Time.Interval]
        end if

        If (MotionSolved(4) = 0) then
            Gosub [Check.GreenBall.For.Collisions.During.This.Time.Interval]
        end if

        If (MotionSolved(5) = 0) then
            Gosub [Check.PurpleBall.For.Collisions.During.This.Time.Interval]
        end if


     Next i

    'Next, convert all ball positions in the
    'arena into sprite positions

    For i = 0 to BPC  'Remember: BPC is the "Ball Position Count"
        print #BallSim.txtStatus, "Calculating sprite position for Time Interval = "; i
        SCAN
        for j = 1 to 6
            BallSpriteX(i,j) = BallX(i,j) + 18
            BallSpriteY(i,j) = 361 - BallY(i,j)
        next j
    next i

    EndCompTime   =  Time$("ms")
    TotalCompTime =  (EndCompTime - StartCompTime)
    TotalCompSecs =  (TotalCompTime / 1000)

    gosub [Activate.Countdown.Timer]  'This provides a three-second countdown
                                      'prior to the commencement of ball movement.


     PhaseONEinProgress = 0
     PhaseTWOinProgress = 1

    'With all ball sprite positions calculated,
    'plot the colliding balls using sprite commands

    For i = 0 to BPC  'Remember: BPC is the "Ball Position Count"
        print #BallSim.txtStatus, "SimTime "; i
        SCAN
        print #BallSim.GBox1, "spritexy Ball01Inst   ";  BallSpriteX(i,1); " "; BallSpriteY(i,1)
        print #BallSim.GBox1, "spritexy Ball02Blue   ";  BallSpriteX(i,2); " "; BallSpriteY(i,2)
        print #BallSim.GBox1, "spritexy Ball03Red    ";  BallSpriteX(i,3); " "; BallSpriteY(i,3)
        print #BallSim.GBox1, "spritexy Ball04Green  ";  BallSpriteX(i,4); " "; BallSpriteY(i,4)
        print #BallSim.GBox1, "spritexy Ball05Purple ";  BallSpriteX(i,5); " "; BallSpriteY(i,5)
        print #BallSim.GBox1, "spritexy Ball06Gray   ";  BallSpriteX(i,6); " "; BallSpriteY(i,6)
        print #BallSim.GBox1, "drawsprites"

    next i

    'Reset all ball velocities to zero, except for the Instigator
    For i = 2 to 6
        BallVelMag(i) = 0
    next i

    'Reset the velocity of the Instigator back to
    'it's initial velocity

    BallVelMag(1) = InstInitialVel

    'Reset all ball angles to zero, except for the Instigator
    For i = 2 to 6
        BallTheta(i) = 0
    next i




    'Set the mouse control variables of the sprites to the
    'variables used during calculation of ball motion
    Ball01SpriteX =  BallSpriteX(BPC,1)
    Ball01SpriteY =  BallSpriteY(BPC,1)
    Ball02SpriteX =  BallSpriteX(BPC,2)
    Ball02SpriteY =  BallSpriteY(BPC,2)
    Ball03SpriteX =  BallSpriteX(BPC,3)
    Ball03SpriteY =  BallSpriteY(BPC,3)
    Ball04SpriteX =  BallSpriteX(BPC,4)
    Ball04SpriteY =  BallSpriteY(BPC,4)
    Ball05SpriteX =  BallSpriteX(BPC,5)
    Ball05SpriteY =  BallSpriteY(BPC,5)
    Ball06SpriteX =  BallSpriteX(BPC,6)
    Ball06SpriteY =  BallSpriteY(BPC,6)

    'Make sure that the arena coordinates
    'for the balls correspond to the sprite
    'coordinates for the balls
    Ball01ArenaX = Ball01SpriteX - 18
    Ball01ArenaY = 361 - Ball01SpriteY
    Ball02ArenaX = Ball02SpriteX - 18
    Ball02ArenaY = 361 - Ball02SpriteY
    Ball03ArenaX = Ball03SpriteX - 18
    Ball03ArenaY = 361 - Ball03SpriteY
    Ball04ArenaX = Ball04SpriteX - 18
    Ball04ArenaY = 361 - Ball04SpriteY
    Ball05ArenaX = Ball05SpriteX - 18
    Ball05ArenaY = 361 - Ball05SpriteY
    Ball06ArenaX = Ball06SpriteX - 18
    Ball06ArenaY = 361 - Ball06SpriteY

    'In case the "Go" button is pushed without rearranging the location
    'of the balls in the arena, set the "zero" location of each of
    'the six balls to the final location of each of the six balls
    'at the end of the last simulation.

    for i = 1 to 6
        BallSpriteX(0,i) = BallSpriteX(BPC,i)
        BallSpriteY(0,i) = BallSpriteY(BPC,i)
        BallX(0,i) = BallSpriteX(0,i) - 18
        BallY(0,i) = 361 - BallSpriteY(0,i)
    next i

    'The initial angle of the Instigator must be set.
    'Set it to the angle of the line between the Crosshairs
    'and the current initial position of the Instigator.

    BallTheta(1) = ATAN2((XhairArenaX - BallX(0,1)),(XhairArenaY - BallY(0,1)))


    ReplayEnabled = 1                                           'With the simulation now complete, enable the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   '"Replay" button.

    PhaseTWOinProgress = 0

    Wait

[btnReplay.click]

    ReplayEnabled = 0                                           'During Replay, disable the Replay button, then
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   're-enable it after Replay has finished

    For i = 0 to BPC  'Remember: BPC is the "Ball Position Count"
        print #BallSim.txtStatus, "SimTime "; i
        SCAN
        print #BallSim.GBox1, "spritexy Ball01Inst   ";  BallSpriteX(i,1); " "; BallSpriteY(i,1)
        print #BallSim.GBox1, "spritexy Ball02Blue   ";  BallSpriteX(i,2); " "; BallSpriteY(i,2)
        print #BallSim.GBox1, "spritexy Ball03Red    ";  BallSpriteX(i,3); " "; BallSpriteY(i,3)
        print #BallSim.GBox1, "spritexy Ball04Green  ";  BallSpriteX(i,4); " "; BallSpriteY(i,4)
        print #BallSim.GBox1, "spritexy Ball05Purple ";  BallSpriteX(i,5); " "; BallSpriteY(i,5)
        print #BallSim.GBox1, "spritexy Ball06Gray   ";  BallSpriteX(i,6); " "; BallSpriteY(i,6)
        print #BallSim.GBox1, "drawsprites"

    next i

    ReplayEnabled = 1                                           'Since Replay is finished, re-enable the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'Replay button.

    Wait

[btnStopSim.click]
    'place code here

    notice "The Collision Simulator" + chr$(13) + "Simulation stopped by user.       "

    ReplayEnabled = 0                                           'Disable Replay when the
    Call EnableWindow hWnd(#BallSim.btnReplay), ReplayEnabled   'Simulation is stopped by the user.

    Wait




''''''''''''''''''''''''''''''''''''''''''''
'
'Atan2.bas by Nally + April 2000
'Released as open source
'
'A function called ATAN2() is provided herein.
'ATAN2() takes two arguements: cartesian x and y
'coordinates.  It returns an angle, phi, in
'radians.
'
'ATAN2() differs from ATN() in this regard:
'while ATN() only returns an angle between
'-pi/2 and +pi/2, ATAN2() will return any
'angle in the full circle.
'
'The user should not call the function if both
'x and y = 0.  This corresponds to a point at
'the origin of the coordinate system where
'the angle phi has no meaning.
'

function ATAN2(x, y)
    pi = 3.14159265
    Result$ = "Undetermined"
    If (x = 0) and (y > 0) then
        ATAN2 = pi / 2
        Result$ = "Determined"
    end if
    if (x = 0) and (y < 0) then
        ATAN2 = 3 * pi / 2
        Result$ = "Determined"
    end if
    if (x > 0) and (y = 0) then
        ATAN2 = 0
        Result$ = "Determined"
    end if
    if (x < 0) and (y = 0) then
        ATAN2 = pi
        Result$ = "Determined"
    end if

    If Result$ = "Determined" then [End.of.function]


    BaseAngle = ATN(abs(y)/abs(x))
    If (x > 0) and (y > 0) then ATAN2 = BaseAngle
    If (x < 0) and (y > 0) then ATAN2 = pi - BaseAngle
    If (x < 0) and (y < 0) then ATAN2 = pi + BaseAngle
    If (x > 0) and (y < 0) then ATAN2 = 2*pi - BaseAngle

    [End.of.function]

End Function
''''''''''''''''''''''''''''''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''
'This function takes an angle which is
'either less than zero, or greater than
'or equal to 2*Pi, and converts it into
'an angle which is greater than or equal
'to zero, but less than or equal to 2*Pi
Function ConvAngle(Rads)
    Pi = 4*atn(1)

    [Keep.Adding.Two.Pi]
    If (Rads < 0) then Rads = (Rads + 2*Pi)
    If (Rads < 0) then [Keep.Adding.Two.Pi]

    [Keep.Subtracting.Two.Pi]
    If (Rads >= (2*Pi)) then Rads = (Rads - 2*Pi)
    If (Rads >= (2*Pi)) then [Keep.Subtracting.Two.Pi]

    ConvAngle = Rads

End Function
''''''''''''''''''''''''''''''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''
[Delay.Routine] 'This routine is currently unused, but
                'but will remain in CollSim for the
                'time being.

    timer DelayMagnitude, [Delay.Is.Complete]
    wait

    [Delay.Is.Complete]
    timer 0  'deactivate the timer

    Return


''''''''''''''''''''''''''''''''''''''''''''

SUB MakeTooltips hWin
    TTS.ALWAYSTIP = 1 : TTS.NOPREFIX = 2 : style = _WS_POPUP or TTS.NOPREFIX or TTS.ALWAYSTIP
    calldll #comctl32,"InitCommonControls", re as void
    calldll #user32, "GetWindowLongA", hWin as long, _GWL_HINSTANCE as long, hInstance as long
    calldll #user32, "CreateWindowExA", _WS_EX_TOPMOST as long,"tooltips_class32" as ptr, "" as ptr,_
        style as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long,_
        hWin as long, 0 as long, hInstance as long, "" as ptr, hwndTT as long
    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    calldll #user32, "SetWindowPos", hwndTT as long,_HWND_TOPMOST as long, 0 as long, 0 as long, 0 as long, 0 as long, flags as long, r as long

    'create a struct for the tooltips:
    struct toolinfo, cbSize as long, uFlags as long, hWindow as long, uId as long, x as long, y as long, w as long, h as long, hInst as long, lpstrText$ as ptr
    toolinfo.cbSize.struct = len(toolinfo.struct)
    toolinfo.uFlags.struct = 1 Or 16
    toolinfo.hWindow.struct = hWin

'Graphicbox Tooltip:
'    toolinfo.hWindow.struct = hWin
'    toolinfo.uId.struct = hwnd(#BallSim.GBox1)
'    toolinfo.lpstrText$.struct = "Ball Collision Arena"  '*** CHANGE TOOLTIP TEXT HERE!
'    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Checkbox Tooltip:
    toolinfo.uId.struct = hwnd(#BallSim.ckXhairs)
    toolinfo.lpstrText$.struct = "Enable Instigator Direction Xhairs"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Checkbox Tooltip:
    toolinfo.uId.struct = hwnd(#BallSim.ckBallPos)
    toolinfo.lpstrText$.struct = "Enable ball positioning"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#BallSim.btnGo)
    toolinfo.lpstrText$.struct = "Start Simulation"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#BallSim.btnReplay)
    toolinfo.lpstrText$.struct = "Replay last simulation"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#BallSim.cboStopSim)
    toolinfo.lpstrText$.struct = "Stop Simulation"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#BallSim.btnQuit)
    toolinfo.lpstrText$.struct = "Quit the Collision Simulator"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Textbox Tooltip:
    toolinfo.uId.struct = hwnd(#BallSim.txtStatus)
    toolinfo.lpstrText$.struct = "Simulation Status Information"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Listbox Tooltip:
    toolinfo.uId.struct = hwnd(#BallSim.BallListBox)
    toolinfo.lpstrText$.struct = "Ball List Box"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Combobox Tooltip:
    hwndCombo = hwnd(#BallSim.cboInstVelocity)
    calldll #user32, "GetWindow", hwndCombo as long, _GW_CHILD as long, hwndComboChild as long
    toolinfo.uId.struct = hwndComboChild
    toolinfo.lpstrText$.struct = "Instigator Velocity"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Combobox Tooltip:
    hwndCombo = hwnd(#BallSim.cboCollElasticity)
    calldll #user32, "GetWindow", hwndCombo as long, _GW_CHILD as long, hwndComboChild as long
    toolinfo.uId.struct = hwndComboChild
    toolinfo.lpstrText$.struct = "Set Collision Elasticity"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

    END SUB


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'From Alyce Watson, this routine allows the "Replay"
'button to be enabled or disabled.

Sub EnableWindow hW, flag
    'Enable=1 Disable=0
    CallDLL #user32, "EnableWindow",_
    hW As Long, flag As Boolean,_
    result As Boolean
    End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[Check.All.Six.Balls.For.Wall.Collisions]

        for j = 1 to 6
            'check for a collision against the LEFT wall
            If (BallX(i,j) <= 22) then
                BallX(i,j) = 22.5
                BallVelMag(j) = BallVelMag(j) * Elasticity
                BallTheta(j) = (Pi - BallTheta(j))
                If (BallTheta(j) < 0) then
                    BallTheta(j) = 2*Pi + BallTheta(j)
                end if
                If (BallTheta(j) >= (2*Pi)) then
                    BallTheta(j) = BallTheta(j) - 2*Pi
                end if
            end if
            'check for a collision against the RIGHT wall
            If (BallX(i,j) >= 360) then
                BallX(i,j) = 359.5
                BallVelMag(j) = BallVelMag(j) * Elasticity
                BallTheta(j) = (Pi - BallTheta(j))
                If (BallTheta(j) < 0) then
                    BallTheta(j) = 2*Pi + BallTheta(j)
                end if
                If (BallTheta(j) >= (2*Pi)) then
                    BallTheta(j) = BallTheta(j) - 2*Pi
                end if
            end if
            'check for a collision against the TOP wall
            If (BallY(i,j) >= 360) then
                BallY(i,j) = 359.5
                BallVelMag(j) = BallVelMag(j) * Elasticity
                BallTheta(j) = (2*Pi - BallTheta(j))
                If (BallTheta(j) < 0) then
                    BallTheta(j) = 2*Pi + BallTheta(j)
                end if
                If (BallTheta(j) >= (2*Pi)) then
                    BallTheta(j) = BallTheta(j) - 2*Pi
                end if
            end if
            'check for a collision against the BOTTOM wall
            If (BallY(i,j) <= 22) then
                BallY(i,j) = 22.5
                BallVelMag(j) = BallVelMag(j) * Elasticity
                BallTheta(j) = (2*Pi - BallTheta(j))
                If (BallTheta(j) < 0) then
                    BallTheta(j) = 2*Pi + BallTheta(j)
                end if
                If (BallTheta(j) >= (2*Pi)) then
                    BallTheta(j) = BallTheta(j) - 2*Pi
                end if
            end if
        next j

    Return


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[Check.Instigator.For.Collisions.During.This.Time.Interval]

        For j = 2 to 6
            BallCollisionOccured = 0
            CP = 0  'CP is short for "Collision Partner
            DeltaX = BallX(i,j) - BallX(i,1)
            DeltaY = BallY(i,j) - BallY(i,1)
            DistanceBetween = sqr(DeltaX^2 + DeltaY^2)

            'Test to see if a collision has occurred between the Instigator and any of
            'balls 2 through 6.  If a collision has occured, set the BallCollisionOccured
            'variable to 1, set CP equal to the number of the "collision partner", and
            'set j = 6, so that no other balls are tested for collisions.
            If ( DistanceBetween < 42 ) Then
                    BallCollisionOccured = 1
                    CP = j
                    j = 6
            end if

            'If a Ball collision has occurred, then find the angle of the line between the centers of
            'the two balls (B2BLine), as well as the angle of the "Virtual Collision Plane", VCP
            If ( BallCollisionOccured = 1 ) then
                B2BLinetheta = ATAN2(DeltaX, DeltaY)
                VCPtheta = B2BLinetheta + Pi/2
                'Make sure that VCPtheta, the angle of the Virtual Collision Plan, is an angle which
                'is greater than zero, and less than 360 degrees (2*Pi)
                VCPtheta  = ConvAngle(VCPtheta)
            end if

            'If a ball collision has occurred, then find Angle "c1".  "c1" is the angle defined as the
            'difference between the path angle of the ball, BallTheta(1), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                Anglec1 = BallTheta(1) - VCPtheta
                Anglec1 = ConvAngle(Anglec1)
                If ((Anglec1 >=0) and (Anglec1 < Pi/2)) then
                    Parallelxc1 =      BallVelMag(1)*cos(Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(1)*cos(Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(1)*sin(Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(1)*sin(Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi/2) and (Anglec1 < Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(1)*cos(Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(1)*cos(Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(1)*sin(Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(1)*sin(Pi - Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi) and (Anglec1 < 1.5*Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(1)*cos(Anglec1 - Pi)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(1)*cos(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(1)*sin(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(1)*sin(Anglec1 - Pi)*cos(VCPtheta)
                end if
                If ((Anglec1 >= 1.5*Pi) and (Anglec1 < 2*Pi)) then
                    Parallelxc1 =      BallVelMag(1)*cos(2*Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(1)*cos(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(1)*sin(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(1)*sin(2*Pi - Anglec1)*cos(VCPtheta)
                end if
            end if

            'If a ball collision has occurred, then find Angle "cCP".  "cCP" is the angle defined as the
            'difference between the path angle of the CollisionPartner, BallTheta(CP), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                AnglecCP = BallTheta(CP) - VCPtheta
                AnglecCP = ConvAngle(AnglecCP)
                If ((AnglecCP >=0) and (AnglecCP < Pi/2)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi/2) and (AnglecCP < Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(Pi - AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi) and (AnglecCP < 1.5*Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(AnglecCP - Pi)*cos(VCPtheta)
                end if
                If ((AnglecCP >= 1.5*Pi) and (AnglecCP < 2*Pi)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(2*Pi - AnglecCP)*cos(VCPtheta)
                end if
            end if

            'If a collision has occurred, it's time to find calculate the new motion of each of
            'the two balls.  A ball's momentum parallel to the virtual collision plane is
            'maintained.  However, when two balls collide, the two balls exchange their momentum
            'vectors which are perpendicular to the collision plane
            If ( BallCollisionOccured = 1 ) then
                NewXvectorc1  = Parallelxc1  + PerpendixcCP
                NewYvectorc1  = Parallelyc1  + PerpendiycCP
                NewXvectorcCP = ParallelxcCP + Perpendixc1
                NewYvectorcCP = ParallelycCP + Perpendiyc1
            end if

            'If a collision has occurred, then each pair of vectors can be used to find both
            'the new path angle of each of the two balls, BallTheta(), and the new
            'magnitude of the ball velocity, BallVelMag(j).  Make it so, Number 1.
            If ( BallCollisionOccured = 1 ) then
                BallVelMag(1) = sqr(NewXvectorc1^2 + NewYvectorc1^2)*Elasticity
                If ((NewXvectorc1 = 0) and (NewYvectorc1 = 0)) then
                    BallTheta(1) = 0
                else
                    BallTheta(1) = ATAN2(NewXvectorc1, NewYvectorc1)
                end if

                BallVelMag(CP) = sqr(NewXvectorcCP^2 + NewYvectorcCP^2)*Elasticity
                If ((NewXvectorcCP = 0) and (NewYvectorcCP = 0)) then
                    BallTheta(CP) = 0
                else
                    BallTheta(CP) = ATAN2(NewXvectorcCP, NewYvectorcCP)
                end if
            end if

            'Last, if a collision has occurred, then the ball's collision partner has already
            'had its motion evaluated.  So, set the MotionSolved() of the collision partner
            'to 1, which will cause it to be omitted later in the collision-detection loop.
            If ( BallCollisionOccured = 1 ) then
                MotionSolved(CP) = 1
            end if

            'If a collision has occured, then "stretch" the distance between the two
            'colliding balls by approximately one pixel.  The intention is to prevent
            'the two balls from being locked inside each other's zone of contact, in
            'which case the balls remain in contact with each other, unable to bounce away.

            If ( BallCollisionOccured = 1 ) then
                xmp = (BallX(i,1) + BallX(i,CP)) / 2
                ymp = (BallY(i,1) + BallY(i,CP)) / 2
                BallX(i,CP) = xmp + SR * (BallX(i,CP) - xmp)
                BallY(i,CP) = ymp + SR * (BallY(i,CP) - ymp)
                BallX(i,1)  = xmp - SR * (xmp - BallX(i,1))
                BallY(i,1)  = ymp - SR * (ymp - BallY(i,1))
            end if

        next j

    Return
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

[Check.BlueBall.For.Collisions.During.This.Time.Interval]

        For j = 3 to 6
            BallCollisionOccured = 0
            CP = 0  'CP is short for "Collision Partner
            DeltaX = BallX(i,j) - BallX(i,2)
            DeltaY = BallY(i,j) - BallY(i,2)
            DistanceBetween = sqr(DeltaX^2 + DeltaY^2)

            'Test to see if a collision has occurred between the Blue Ball and any of
            'balls 3 through 6.  If a collision has occured, set the BallCollisionOccured
            'variable to 1, set CP equal to the number of the "collision partner", and
            'set j = 6, so that no other balls are tested for collisions.
            If ( DistanceBetween < 42 ) Then
                    BallCollisionOccured = 1
                    CP = j
                    j = 6
            end if

            'If a Ball collision has occurred, then find the angle of the line between the centers of
            'the two balls (B2BLine), as well as the angle of the "Virtual Collision Plane", VCP
            If ( BallCollisionOccured = 1 ) then
                B2BLinetheta = ATAN2(DeltaX, DeltaY)
                VCPtheta = B2BLinetheta + Pi/2
                'Make sure that VCPtheta, the angle of the Virtual Collision Plan, is an angle which
                'is greater than zero, and less than 360 degrees (2*Pi)
                VCPtheta  = ConvAngle(VCPtheta)
            end if

            'If a ball collision has occurred, then find Angle "c1".  "c1" is the angle defined as the
            'difference between the path angle of the ball, BallTheta(1), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                Anglec1 = BallTheta(2) - VCPtheta
                Anglec1 = ConvAngle(Anglec1)
                If ((Anglec1 >=0) and (Anglec1 < Pi/2)) then
                    Parallelxc1 =      BallVelMag(2)*cos(Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(2)*cos(Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(2)*sin(Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(2)*sin(Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi/2) and (Anglec1 < Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(2)*cos(Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(2)*cos(Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(2)*sin(Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(2)*sin(Pi - Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi) and (Anglec1 < 1.5*Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(2)*cos(Anglec1 - Pi)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(2)*cos(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(2)*sin(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(2)*sin(Anglec1 - Pi)*cos(VCPtheta)
                end if
                If ((Anglec1 >= 1.5*Pi) and (Anglec1 < 2*Pi)) then
                    Parallelxc1 =      BallVelMag(2)*cos(2*Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(2)*cos(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(2)*sin(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(2)*sin(2*Pi - Anglec1)*cos(VCPtheta)
                end if
            end if

            'If a ball collision has occurred, then find Angle "cCP".  "cCP" is the angle defined as the
            'difference between the path angle of the CollisionPartner, BallTheta(CP), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                AnglecCP = BallTheta(CP) - VCPtheta
                AnglecCP = ConvAngle(AnglecCP)
                If ((AnglecCP >=0) and (AnglecCP < Pi/2)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi/2) and (AnglecCP < Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(Pi - AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi) and (AnglecCP < 1.5*Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(AnglecCP - Pi)*cos(VCPtheta)
                end if
                If ((AnglecCP >= 1.5*Pi) and (AnglecCP < 2*Pi)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(2*Pi - AnglecCP)*cos(VCPtheta)
                end if
            end if

            'If a collision has occurred, it's time to find calculate the new motion of each of
            'the two balls.  A ball's momentum parallel to the virtual collision plane is
            'maintained.  However, when two balls collide, the two balls exchange their momentum
            'vectors which are perpendicular to the collision plane
            If ( BallCollisionOccured = 1 ) then
                NewXvectorc1  = Parallelxc1  + PerpendixcCP
                NewYvectorc1  = Parallelyc1  + PerpendiycCP
                NewXvectorcCP = ParallelxcCP + Perpendixc1
                NewYvectorcCP = ParallelycCP + Perpendiyc1
            end if

            'If a collision has occurred, then each pair of vectors can be used to find both
            'the new path angle of each of the two balls, BallTheta(), and the new
            'magnitude of the ball velocity, BallVelMag(j).  Make it so, Number 1.
            If ( BallCollisionOccured = 1 ) then
                BallVelMag(2) = sqr(NewXvectorc1^2 + NewYvectorc1^2)*Elasticity
                If ((NewXvectorc1 = 0) and (NewYvectorc1 = 0)) then
                    BallTheta(2) = 0
                else
                    BallTheta(2) = ATAN2(NewXvectorc1, NewYvectorc1)
                end if

                BallVelMag(CP) = sqr(NewXvectorcCP^2 + NewYvectorcCP^2)*Elasticity
                If ((NewXvectorcCP = 0) and (NewYvectorcCP = 0)) then
                    BallTheta(CP) = 0
                else
                    BallTheta(CP) = ATAN2(NewXvectorcCP, NewYvectorcCP)
                end if
            end if

            'Last, if a collision has occurred, then the ball's collision partner has already
            'had its motion evaluated.  So, set the MotionSolved() of the collision partner
            'to 1, which will cause it to be omitted later in the collision-detection loop.
            If ( BallCollisionOccured = 1 ) then
                MotionSolved(CP) = 1
            end if

            'If a collision has occured, then "stretch" the distance between the two
            'colliding balls by approximately one pixel.  The intention is to prevent
            'the two balls from being locked inside each other's zone of contact, in
            'which case the balls remain in contact with each other, unable to bounce away.

            If ( BallCollisionOccured = 1 ) then
                xmp = (BallX(i,2) + BallX(i,CP)) / 2
                ymp = (BallY(i,2) + BallY(i,CP)) / 2
                BallX(i,CP) = xmp + SR * (BallX(i,CP) - xmp)
                BallY(i,CP) = ymp + SR * (BallY(i,CP) - ymp)
                BallX(i,2)  = xmp - SR * (xmp - BallX(i,2))
                BallY(i,2)  = ymp - SR * (ymp - BallY(i,2))
            end if

        next j

    Return

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[Check.RedBall.For.Collisions.During.This.Time.Interval]

        For j = 4 to 6
            BallCollisionOccured = 0
            CP = 0  'CP is short for "Collision Partner
            DeltaX = BallX(i,j) - BallX(i,3)
            DeltaY = BallY(i,j) - BallY(i,3)
            DistanceBetween = sqr(DeltaX^2 + DeltaY^2)

            'Test to see if a collision has occurred between the Red Ball and any of
            'balls 4 through 6.  If a collision has occured, set the BallCollisionOccured
            'variable to 1, set CP equal to the number of the "collision partner", and
            'set j = 6, so that no other balls are tested for collisions.
            If ( DistanceBetween < 42 ) Then
                    BallCollisionOccured = 1
                    CP = j
                    j = 6
            end if

            'If a Ball collision has occurred, then find the angle of the line between the centers of
            'the two balls (B2BLine), as well as the angle of the "Virtual Collision Plane", VCP
            If ( BallCollisionOccured = 1 ) then
                B2BLinetheta = ATAN2(DeltaX, DeltaY)
                VCPtheta = B2BLinetheta + Pi/2
                'Make sure that VCPtheta, the angle of the Virtual Collision Plan, is an angle which
                'is greater than zero, and less than 360 degrees (2*Pi)
                VCPtheta  = ConvAngle(VCPtheta)
            end if

            'If a ball collision has occurred, then find Angle "c1".  "c1" is the angle defined as the
            'difference between the path angle of the ball, BallTheta(1), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                Anglec1 = BallTheta(3) - VCPtheta
                Anglec1 = ConvAngle(Anglec1)
                If ((Anglec1 >=0) and (Anglec1 < Pi/2)) then
                    Parallelxc1 =      BallVelMag(3)*cos(Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(3)*cos(Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(3)*sin(Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(3)*sin(Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi/2) and (Anglec1 < Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(3)*cos(Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(3)*cos(Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(3)*sin(Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(3)*sin(Pi - Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi) and (Anglec1 < 1.5*Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(3)*cos(Anglec1 - Pi)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(3)*cos(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(3)*sin(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(3)*sin(Anglec1 - Pi)*cos(VCPtheta)
                end if
                If ((Anglec1 >= 1.5*Pi) and (Anglec1 < 2*Pi)) then
                    Parallelxc1 =      BallVelMag(3)*cos(2*Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(3)*cos(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(3)*sin(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(3)*sin(2*Pi - Anglec1)*cos(VCPtheta)
                end if
            end if

            'If a ball collision has occurred, then find Angle "cCP".  "cCP" is the angle defined as the
            'difference between the path angle of the CollisionPartner, BallTheta(CP), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                AnglecCP = BallTheta(CP) - VCPtheta
                AnglecCP = ConvAngle(AnglecCP)
                If ((AnglecCP >=0) and (AnglecCP < Pi/2)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi/2) and (AnglecCP < Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(Pi - AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi) and (AnglecCP < 1.5*Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(AnglecCP - Pi)*cos(VCPtheta)
                end if
                If ((AnglecCP >= 1.5*Pi) and (AnglecCP < 2*Pi)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(2*Pi - AnglecCP)*cos(VCPtheta)
                end if
            end if

            'If a collision has occurred, it's time to find calculate the new motion of each of
            'the two balls.  A ball's momentum parallel to the virtual collision plane is
            'maintained.  However, when two balls collide, the two balls exchange their momentum
            'vectors which are perpendicular to the collision plane
            If ( BallCollisionOccured = 1 ) then
                NewXvectorc1  = Parallelxc1  + PerpendixcCP
                NewYvectorc1  = Parallelyc1  + PerpendiycCP
                NewXvectorcCP = ParallelxcCP + Perpendixc1
                NewYvectorcCP = ParallelycCP + Perpendiyc1
            end if

            'If a collision has occurred, then each pair of vectors can be used to find both
            'the new path angle of each of the two balls, BallTheta(), and the new
            'magnitude of the ball velocity, BallVelMag(j).  Make it so, Number 1.
            If ( BallCollisionOccured = 1 ) then
                BallVelMag(3) = sqr(NewXvectorc1^2 + NewYvectorc1^2)*Elasticity
                If ((NewXvectorc1 = 0) and (NewYvectorc1 = 0)) then
                    BallTheta(3) = 0
                else
                    BallTheta(3) = ATAN2(NewXvectorc1, NewYvectorc1)
                end if

                BallVelMag(CP) = sqr(NewXvectorcCP^2 + NewYvectorcCP^2)*Elasticity
                If ((NewXvectorcCP = 0) and (NewYvectorcCP = 0)) then
                    BallTheta(CP) = 0
                else
                    BallTheta(CP) = ATAN2(NewXvectorcCP, NewYvectorcCP)
                end if
            end if

            'Last, if a collision has occurred, then the ball's collision partner has already
            'had its motion evaluated.  So, set the MotionSolved() of the collision partner
            'to 1, which will cause it to be omitted later in the collision-detection loop.
            If ( BallCollisionOccured = 1 ) then
                MotionSolved(CP) = 1
            end if

            'If a collision has occured, then "stretch" the distance between the two
            'colliding balls by approximately one pixel.  The intention is to prevent
            'the two balls from being locked inside each other's zone of contact, in
            'which case the balls remain in contact with each other, unable to bounce away.

            If ( BallCollisionOccured = 1 ) then
                xmp = (BallX(i,3) + BallX(i,CP)) / 2
                ymp = (BallY(i,3) + BallY(i,CP)) / 2
                BallX(i,CP) = xmp + SR * (BallX(i,CP) - xmp)
                BallY(i,CP) = ymp + SR * (BallY(i,CP) - ymp)
                BallX(i,3)  = xmp - SR * (xmp - BallX(i,3))
                BallY(i,3)  = ymp - SR * (ymp - BallY(i,3))
            end if

        next j

    Return

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[Check.GreenBall.For.Collisions.During.This.Time.Interval]

        For j = 5 to 6
            BallCollisionOccured = 0
            CP = 0  'CP is short for "Collision Partner
            DeltaX = BallX(i,j) - BallX(i,4)
            DeltaY = BallY(i,j) - BallY(i,4)
            DistanceBetween = sqr(DeltaX^2 + DeltaY^2)

            'Test to see if a collision has occurred between the Green Ball and any of
            'balls 5 through 6.  If a collision has occured, set the BallCollisionOccured
            'variable to 1, set CP equal to the number of the "collision partner", and
            'set j = 6, so that no other balls are tested for collisions.
            If ( DistanceBetween < 42 ) Then
                    BallCollisionOccured = 1
                    CP = j
                    j = 6
            end if

            'If a Ball collision has occurred, then find the angle of the line between the centers of
            'the two balls (B2BLine), as well as the angle of the "Virtual Collision Plane", VCP
            If ( BallCollisionOccured = 1 ) then
                B2BLinetheta = ATAN2(DeltaX, DeltaY)
                VCPtheta = B2BLinetheta + Pi/2
                'Make sure that VCPtheta, the angle of the Virtual Collision Plan, is an angle which
                'is greater than zero, and less than 360 degrees (2*Pi)
                VCPtheta  = ConvAngle(VCPtheta)
            end if

            'If a ball collision has occurred, then find Angle "c1".  "c1" is the angle defined as the
            'difference between the path angle of the ball, BallTheta(1), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                Anglec1 = BallTheta(4) - VCPtheta
                Anglec1 = ConvAngle(Anglec1)
                If ((Anglec1 >=0) and (Anglec1 < Pi/2)) then
                    Parallelxc1 =      BallVelMag(4)*cos(Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(4)*cos(Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(4)*sin(Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(4)*sin(Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi/2) and (Anglec1 < Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(4)*cos(Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(4)*cos(Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(4)*sin(Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(4)*sin(Pi - Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi) and (Anglec1 < 1.5*Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(4)*cos(Anglec1 - Pi)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(4)*cos(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(4)*sin(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(4)*sin(Anglec1 - Pi)*cos(VCPtheta)
                end if
                If ((Anglec1 >= 1.5*Pi) and (Anglec1 < 2*Pi)) then
                    Parallelxc1 =      BallVelMag(4)*cos(2*Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(4)*cos(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(4)*sin(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(4)*sin(2*Pi - Anglec1)*cos(VCPtheta)
                end if
            end if

            'If a ball collision has occurred, then find Angle "cCP".  "cCP" is the angle defined as the
            'difference between the path angle of the CollisionPartner, BallTheta(CP), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                AnglecCP = BallTheta(CP) - VCPtheta
                AnglecCP = ConvAngle(AnglecCP)
                If ((AnglecCP >=0) and (AnglecCP < Pi/2)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi/2) and (AnglecCP < Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(Pi - AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi) and (AnglecCP < 1.5*Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(AnglecCP - Pi)*cos(VCPtheta)
                end if
                If ((AnglecCP >= 1.5*Pi) and (AnglecCP < 2*Pi)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(2*Pi - AnglecCP)*cos(VCPtheta)
                end if
            end if

            'If a collision has occurred, it's time to find calculate the new motion of each of
            'the two balls.  A ball's momentum parallel to the virtual collision plane is
            'maintained.  However, when two balls collide, the two balls exchange their momentum
            'vectors which are perpendicular to the collision plane
            If ( BallCollisionOccured = 1 ) then
                NewXvectorc1  = Parallelxc1  + PerpendixcCP
                NewYvectorc1  = Parallelyc1  + PerpendiycCP
                NewXvectorcCP = ParallelxcCP + Perpendixc1
                NewYvectorcCP = ParallelycCP + Perpendiyc1
            end if

            'If a collision has occurred, then each pair of vectors can be used to find both
            'the new path angle of each of the two balls, BallTheta(), and the new
            'magnitude of the ball velocity, BallVelMag(j).  Make it so, Number 1.
            If ( BallCollisionOccured = 1 ) then
                BallVelMag(4) = sqr(NewXvectorc1^2 + NewYvectorc1^2)*Elasticity
                If ((NewXvectorc1 = 0) and (NewYvectorc1 = 0)) then
                    BallTheta(4) = 0
                else
                    BallTheta(4) = ATAN2(NewXvectorc1, NewYvectorc1)
                end if

                BallVelMag(CP) = sqr(NewXvectorcCP^2 + NewYvectorcCP^2)*Elasticity
                If ((NewXvectorcCP = 0) and (NewYvectorcCP = 0)) then
                    BallTheta(CP) = 0
                else
                    BallTheta(CP) = ATAN2(NewXvectorcCP, NewYvectorcCP)
                end if
            end if

            'Last, if a collision has occurred, then the ball's collision partner has already
            'had its motion evaluated.  So, set the MotionSolved() of the collision partner
            'to 1, which will cause it to be omitted later in the collision-detection loop.
            If ( BallCollisionOccured = 1 ) then
                MotionSolved(CP) = 1
            end if

            'If a collision has occured, then "stretch" the distance between the two
            'colliding balls by approximately one pixel.  The intention is to prevent
            'the two balls from being locked inside each other's zone of contact, in
            'which case the balls remain in contact with each other, unable to bounce away.

            If ( BallCollisionOccured = 1 ) then
                xmp = (BallX(i,4) + BallX(i,CP)) / 2
                ymp = (BallY(i,4) + BallY(i,CP)) / 2
                BallX(i,CP) = xmp + SR * (BallX(i,CP) - xmp)
                BallY(i,CP) = ymp + SR * (BallY(i,CP) - ymp)
                BallX(i,4)  = xmp - SR * (xmp - BallX(i,4))
                BallY(i,4)  = ymp - SR * (ymp - BallY(i,4))
            end if

        next j

    Return
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[Check.PurpleBall.For.Collisions.During.This.Time.Interval]

        For j = 6 to 6
            BallCollisionOccured = 0
            CP = 0  'CP is short for "Collision Partner
            DeltaX = BallX(i,j) - BallX(i,5)
            DeltaY = BallY(i,j) - BallY(i,5)
            DistanceBetween = sqr(DeltaX^2 + DeltaY^2)

            'Test to see if a collision has occurred between the Purple Ball and
            'ball 6.  If a collision has occured, set the BallCollisionOccured
            'variable to 1, set CP equal to the number of the "collision partner", and
            'set j = 6, so that no other balls are tested for collisions.
            If ( DistanceBetween < 42 ) Then
                    BallCollisionOccured = 1
                    CP = j
                    j = 6
            end if

            'If a Ball collision has occurred, then find the angle of the line between the centers of
            'the two balls (B2BLine), as well as the angle of the "Virtual Collision Plane", VCP
            If ( BallCollisionOccured = 1 ) then
                B2BLinetheta = ATAN2(DeltaX, DeltaY)
                VCPtheta = B2BLinetheta + Pi/2
                'Make sure that VCPtheta, the angle of the Virtual Collision Plan, is an angle which
                'is greater than zero, and less than 360 degrees (2*Pi)
                VCPtheta  = ConvAngle(VCPtheta)
            end if

            'If a ball collision has occurred, then find Angle "c1".  "c1" is the angle defined as the
            'difference between the path angle of the ball, BallTheta(1), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                Anglec1 = BallTheta(5) - VCPtheta
                Anglec1 = ConvAngle(Anglec1)
                If ((Anglec1 >=0) and (Anglec1 < Pi/2)) then
                    Parallelxc1 =      BallVelMag(5)*cos(Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(5)*cos(Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(5)*sin(Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(5)*sin(Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi/2) and (Anglec1 < Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(5)*cos(Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(5)*cos(Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 = (-1)*BallVelMag(5)*sin(Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 =      BallVelMag(5)*sin(Pi - Anglec1)*cos(VCPtheta)
                end if
                If ((Anglec1 >= Pi) and (Anglec1 < 1.5*Pi)) then
                    Parallelxc1 = (-1)*BallVelMag(5)*cos(Anglec1 - Pi)*cos(VCPtheta)
                    Parallelyc1 = (-1)*BallVelMag(5)*cos(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(5)*sin(Anglec1 - Pi)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(5)*sin(Anglec1 - Pi)*cos(VCPtheta)
                end if
                If ((Anglec1 >= 1.5*Pi) and (Anglec1 < 2*Pi)) then
                    Parallelxc1 =      BallVelMag(5)*cos(2*Pi - Anglec1)*cos(VCPtheta)
                    Parallelyc1 =      BallVelMag(5)*cos(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendixc1 =      BallVelMag(5)*sin(2*Pi - Anglec1)*sin(VCPtheta)
                    Perpendiyc1 = (-1)*BallVelMag(5)*sin(2*Pi - Anglec1)*cos(VCPtheta)
                end if
            end if

            'If a ball collision has occurred, then find Angle "cCP".  "cCP" is the angle defined as the
            'difference between the path angle of the CollisionPartner, BallTheta(CP), and VCPtheta.
            'After that, find the four component vectors associates with the collision.  The first
            'two vectors are the component vectors of the component of the ball's momentum
            'parallel to the virtual collision plane.  The second two vectors are the component
            'vectors of the component of the ball's momentum which is perpendicular to the
            'virtual collision plane.
            If ( BallCollisionOccured = 1 ) then
                AnglecCP = BallTheta(CP) - VCPtheta
                AnglecCP = ConvAngle(AnglecCP)
                If ((AnglecCP >=0) and (AnglecCP < Pi/2)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi/2) and (AnglecCP < Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP = (-1)*BallVelMag(CP)*sin(Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP =      BallVelMag(CP)*sin(Pi - AnglecCP)*cos(VCPtheta)
                end if
                If ((AnglecCP >= Pi) and (AnglecCP < 1.5*Pi)) then
                    ParallelxcCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*cos(VCPtheta)
                    ParallelycCP = (-1)*BallVelMag(CP)*cos(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(AnglecCP - Pi)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(AnglecCP - Pi)*cos(VCPtheta)
                end if
                If ((AnglecCP >= 1.5*Pi) and (AnglecCP < 2*Pi)) then
                    ParallelxcCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*cos(VCPtheta)
                    ParallelycCP =      BallVelMag(CP)*cos(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendixcCP =      BallVelMag(CP)*sin(2*Pi - AnglecCP)*sin(VCPtheta)
                    PerpendiycCP = (-1)*BallVelMag(CP)*sin(2*Pi - AnglecCP)*cos(VCPtheta)
                end if
            end if

            'If a collision has occurred, it's time to find calculate the new motion of each of
            'the two balls.  A ball's momentum parallel to the virtual collision plane is
            'maintained.  However, when two balls collide, the two balls exchange their momentum
            'vectors which are perpendicular to the collision plane
            If ( BallCollisionOccured = 1 ) then
                NewXvectorc1  = Parallelxc1  + PerpendixcCP
                NewYvectorc1  = Parallelyc1  + PerpendiycCP
                NewXvectorcCP = ParallelxcCP + Perpendixc1
                NewYvectorcCP = ParallelycCP + Perpendiyc1
            end if

            'If a collision has occurred, then each pair of vectors can be used to find both
            'the new path angle of each of the two balls, BallTheta(), and the new
            'magnitude of the ball velocity, BallVelMag(j).  Make it so, Number 1.
            If ( BallCollisionOccured = 1 ) then
                BallVelMag(5) = sqr(NewXvectorc1^2 + NewYvectorc1^2)*Elasticity
                If ((NewXvectorc1 = 0) and (NewYvectorc1 = 0)) then
                    BallTheta(5) = 0
                else
                    BallTheta(5) = ATAN2(NewXvectorc1, NewYvectorc1)
                end if

                BallVelMag(CP) = sqr(NewXvectorcCP^2 + NewYvectorcCP^2)*Elasticity
                If ((NewXvectorcCP = 0) and (NewYvectorcCP = 0)) then
                    BallTheta(CP) = 0
                else
                    BallTheta(CP) = ATAN2(NewXvectorcCP, NewYvectorcCP)
                end if
            end if

            'Last, if a collision has occurred, then the ball's collision partner has already
            'had its motion evaluated.  So, set the MotionSolved() of the collision partner
            'to 1, which will cause it to be omitted later in the collision-detection loop.
            If ( BallCollisionOccured = 1 ) then
                MotionSolved(CP) = 1
            end if

            'If a collision has occured, then "stretch" the distance between the two
            'colliding balls by approximately one pixel.  The intention is to prevent
            'the two balls from being locked inside each other's zone of contact, in
            'which case the balls remain in contact with each other, unable to bounce away.

            If ( BallCollisionOccured = 1 ) then
                xmp = (BallX(i,5) + BallX(i,CP)) / 2
                ymp = (BallY(i,5) + BallY(i,CP)) / 2
                BallX(i,CP) = xmp + SR * (BallX(i,CP) - xmp)
                BallY(i,CP) = ymp + SR * (BallY(i,CP) - ymp)
                BallX(i,5)  = xmp - SR * (xmp - BallX(i,5))
                BallY(i,5)  = ymp - SR * (ymp - BallY(i,5))
            end if

        next j

    Return

[Activate.Countdown.Timer]

    print #BallSim.txtStatus, "Ball position computational time = "; using("###.###", TotalCompSecs)

    Timer 1000, [Three.Seconds.Remaining]
    Wait

    [Three.Seconds.Remaining]
    Timer 0

    print #BallSim.txtStatus, "Simulation countdown: 3 seconds"

    Timer 1000, [Two.Seconds.Remaining]
    Wait

    [Two.Seconds.Remaining]

    Timer 0

    print #BallSim.txtStatus, "Simulation countdown: 2 seconds"

    Timer 1000, [One.Second.Remaining]
    Wait

    [One.Second.Remaining]

    print #BallSim.txtStatus, "Simulation countdown: 1 second"

    Timer 1000, [Zero.Seconds.Remaining]
    Wait

    [Zero.Seconds.Remaining]
    Timer 0



    return



