'############################################
'# Cryptor.dll demo                         #
'# Cryptor.dll by David Drake               #
'# Released as open-source August, 2002     #
'# Use at your own risk                     #
'#                                          #
'# This DLL produces a very low-level       #
'# encryption using character XOR functions.#
'# Thus, longer encryption keys produce     #
'# stronger encryption.  This would work    #
'# well for encrypting game data, etc.      #
'#                                          #
'# Cryptor.dll is a 32-bit DLL created with #
'# the help of BCX and LCC-WIN32, so it     #
'# is pretty fast.  On my 800MHz machine,   #
'# with a 10-character encryption key,      #
'# crypter.dll will process a 1MB file in   #
'# about five seconds.                      #
'#                                          #
'#                                          #
'# DLL package includes                     #
'# cryptor.dll - 32-bit dll                 #
'# cryptor.bas - BCX source code for DLL    #
'# cryptor.c   - C source code for DLL      #
'# cryptor_demo.bas - This file written for #
'#               Liberty BASIC 3.01         #
'############################################

'Main window of demo

    nomainwin
    WindowWidth = 300
    WindowHeight = 300
    UpperLeftX=int((DisplayWidth-WindowWidth)/2)
    UpperLeftY=int((DisplayHeight-WindowHeight)/2)

    statictext #main.statictext6, "Source File", 15, 2, 68, 20
    statictext #main.statictext7, "Destination File", 15, 57, 92, 20
    statictext #main.statictext8, "Encryption Key", 15, 112, 89, 20
    textbox #main.source, 15, 22, 180, 25
    button #main.browseSource, "Browse", [browseSource], UL, 200, 22, 60, 20
    textbox #main.destination, 15, 77, 180, 25
    button #main.browseDestination, "Browse", [browseDestination], UL, 200, 77, 60, 20
    textbox #main.key, 15, 132, 180, 25
    radiobutton #main.selectDecrypt, "Decrypt Source to Destination", [selectDecrypt], [reset], 15, 192, 202, 25
    radiobutton #main.selectEncrypt, "Encrypt Source to Destination", [selectEncrypt], [reset], 15, 172, 200, 25
    button #main.go, "Go", [go], UL, 95, 222, 85, 25

    open "Cryptor Demo" for window as #main
    print #main, "font ms_sans_serif 0 16"
    print #main, "trapclose [quit]"

    MODE = 1
    #main.selectEncrypt, "set"
    wait

'############################################
'# Meat of the program begins here          #
'#                                          #
'# function call:                           #
'# RESULT = ENCRYPTION(MODE,INFILE$,OUTFILE$,KEY$)
'#                                          #
'# dll call:                                #
'# calldll #en, "_ENCRYPT",_  **You must use the underscore before ENCRYPT**
'#            MODE as SHORT,_               #
'#            INFILE$ as PTR,_              #
'#            OUTFILE$ as PTR,_             #
'#            KEY$ as PTR,_                 #
'#            RESULT as SHORT               #
'#                                          #
'# The ENCRYPTION function calls the dll    #
'# MODE = 1: Encrypt source file and write  #
'#           to the destination file        #
'#                                          #
'# MODE = 2: Decrypt the source file and    #
'#           write to the destination file  #
'#                                          #
'# INFILE$:  The file spec for the source   #
'#           file                           #
'#                                          #
'# OUTFILE$: The file spec for the destin-  #
'#           ation file                     #
'#                                          #
'# KEY$:     A string of any length used to #
'#           encrypt the file               #
'#                                          #
'# Result codes:                            #
'#   1 = De/Encryption successful           #
'#   2 = Invalid MODE value (not 1 or 2)    #
'#   3 = Source file does not exist         #
'#   4 = Destination file already exists    #
'############################################


[browseSource]   'Search for source file
    filedialog "Select source file:","*.*",INFILE$
    if INFILE$ <> "" then #main.source, INFILE$
    wait

[browseDestination]   'Search for destination file
    filedialog "Select destination file:","*.*",OUTFILE$
    if OUTFILE$ <> "" then #main.destination, OUTFILE$
    wait

[selectDecrypt]   'Set mode to decryption
    MODE = 2
    wait


[selectEncrypt]   'Set mode to encryption
    MODE = 1
    wait

[reset]   'Perform action for the radiobutton named 'selectDecrypt'
    wait

[go]   'Do it!
    #main.key, "!contents? KEY$"
    #main.source, "!contents? INFILE$"
    #main.destination, "!contents? OUTFILE$"

    cursor hourglass
    RESULT = ENCRYPTION(MODE,INFILE$,OUTFILE$,KEY$)
    cursor normal
    if RESULT = 1 then notice "Action completed successfully"
    if RESULT = 2 then notice "Encrypt/decrypt mode not properly selected"
    if RESULT = 3 then notice "Source file does not exist"
    if RESULT = 4 then notice "Destination file already exists"
    if RESULT = 5 then notice "No de/encryption key specified"
    wait

[quit] 'End the program
    close #main
    end

function ENCRYPTION(MODE,INFILE$,OUTFILE$,KEY$)
    open "cryptor.dll" for dll as #en
    calldll #en, "_ENCRYPT",_
        MODE as short,_
        INFILE$ as ptr,_
        OUTFILE$ as ptr,_
        KEY$ as ptr,_
        RESULT as short
    close #en
    ENCRYPTION = RESULT
end function
