'''''''''''''''''''''''''''''''''''''''''''''''''
'  Flash-O-Rama                                 '
'  Yes, it could be more boring,                '
'  but I ran out of time!                       '
'''''''''''''''''''''''''''''''''''''''''''''''''
'  Copyright Tomas J. Nally  May 2003          '
'  Steelweaver52@aol.com                        '
'''''''''''''''''''''''''''''''''''''''''''''''''
'  Flash-O-Rama is made with the following:     '
'                                               '
'  Liberty BASIC - by Carl Gundel               '
'  Liberty BASIC Workshop - by Alyce Watson     '
'  HelpBlocks - by Julian Smart                 '
'  Easy Thumbnails - by Fookes Software         '
'  Paint, Excel and HTML Help Workshop          '
'       - by Microsoft                          '
'''''''''''''''''''''''''''''''''''''''''''''''''


'Load the Bitmap for the "About" box.
LOADBMP "AboutBox", "AboutBox.bmp"

'Initialize a few of the oft-used variables.
            True = 1
           False = 0
    TagTriggered = 0
     CurrentCard = 1
        NextCard = 2
      TotalCards = 5   'Note that when the program begins
                       'the total number of cards in the
                       'default stack is five.
      
   FriendlyName$ = "Untitled Flash Cards"
  FlashFileName$ = "Untitled.fls"
    PrintAllFlag = 1
   PicWindowOpen = 0
  PrintRangeOpen = 0

'Dimension the arrays.
Dim   Question$(200)
Dim     Answer$(200)
Dim BitMapName$(200)
Dim   HasBitMap(200)
Dim    Q4Print$(200)
Dim    A4Print$(200)

'Set the initial values for all of the BitMapNames.
'Until a bitmap is linked to a particular card, the
'BitMapName$() associated with that card is the
'empty string.

for i = 1 to 200
    BitMapName$(i) = ""
      HasBitMap(i) = 0
next i

'Below: at startup, the total number of cards is 5.
'Each of the 5 cards is given a default Question and
'Answer in the For...Next loop below.  During runtime,
'the user can change questions and answers as she
'sees fit.

For i = 1 to TotalCards
    Question$(i) = " " + chr$(13) + "Type question #" + str$(i) + " here." + chr$(13)
    Answer$(i)   = " " + chr$(13) + "Type the answer to question #" + str$(i) + " here." + chr$(13)
next i

'Below are commands which initialize some of the
'settings of the window controls.  Very skillfully
'and helpfully done by Liberty BASIC Workshop.

[InitColors]
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"

[WindowSetup]
    NOMAINWIN
    WindowWidth = 570 : WindowHeight = 475
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Menu        #main, "File", "Set Friendly Name...",    [Set.Friendly.Name], |, _
                           "New flash card stack",    [New.Flash.Card.Stack], |, _
                           "Open...",                 [Flash.Open], _
                           "Save",                    [Flash.Save], _
                           "Save As...",              [Flash.Save.As], |, _
                           "Print cards as notes...", [Print.As.Notes], |, _
                           "Exit",                    [Flash.Exit]
Menu        #main, "Edit"

Menu        #main, "Card", "Insert new card after this card",  [Insert.New.Card], _
                           "Add new card at end of stack", [New.Card.At.End], _
                           "Delete this card...",   [Delete.This.Card], |, _
                           "Link bitmap to this card...",  [Link.Bitmap], _
                           "Unlink bitmap to this card...", [UnLink.Bitmap]

Menu        #main, "Help", "Flash Card Help",     [Flash.Card.Help], |, _
                           "About Flash-O-Rama...", [About.Flash.O.Rama]

statictext  #main.statictext1,    "Question:", 20, 55, 80, 20
statictext  #main.statictext2,    "Answer:", 300, 55, 80, 20
statictext  #main.statictext4,    "Card", 485, 5, 30, 20
statictext  #main.statictext5,    "Stack Name:", 20, 5, 80, 20
statictext  #main.FriendlyName,   "Untitled Flash Cards", 105, 5, 360, 20

statictext  #main.statictext5a,   "File Name:", 32, 25, 70, 20
statictext  #main.FlashFileName,  "Flash Cards filename", 105, 25, 360, 20

statictext  #main.statictext7, "+    +    +    +    +    +    +    +    Flash Card Navigation   +    +    +    +    +    +    +    + ", 25, 355, 515, 20
statictext  #main.staticCurrentCard, "1", 520, 5, 30, 20
statictext  #main.staticOf, "of", 500, 25, 15, 20
statictext  #main.staticNoOfCards, "20", 520, 25, 30, 20

button      #main.btnShowAnswer,  "Show Answer",[Show.Answer],UL, 175, 310, 90, 25
button      #main.btnHideAnswer,  "Hide Answer",[Hide.Answer],UL, 290, 310, 90, 25
button      #main.btnShowGraphic, "Display Picture...",[Show.Graphic],UL, 45, 310, 120, 25

button      #main.btnSetQuestion, "S",[Set.Question],UL,  15, 310, 20, 25
button      #main.btnSetAnswer,   "S",[Set.Answer],  UL, 520, 310, 20, 25

button      #main.btnFirst, "First",[FirstCard.click],UL,    20,  380, 45, 25
button      #main.btnPrev,  "Prev", [PreviousCard.click],UL, 65,  380, 45, 25
button      #main.btnNext,  "Next", [NextCard.click],UL,     110, 380, 50, 25
button      #main.btnLast,  "Last", [LastCard.click],UL,     160, 380, 50, 25

button      #main.btnRandomCard, "Random",[Random.Card],UL, 220, 380, 70, 25

textbox     #main.txtCardNumber, 305, 380, 40, 24
button      #main.btnGoToCard, "Go To Card",[Go.To.Card],UL, 345, 380, 95, 25

button      #main.btnQuit, "Quit",[Flash.Exit],UL, 480, 380, 65, 25

texteditor  #main.textedQuestion, 15,  80, 250, 220
texteditor  #main.textedAnswer,   290, 80, 250, 220

TextboxColor$    = "darkgray"
textbox     #main.txtVLine, 274, 80, 8, 220  'This TextBox serves as a vertical line
                                             'between the two TextEditor Controls

Open "Flash-O-Rama" for Window as #main

    print #main, "trapclose [Flash.Exit]"
    print #main, "font arial 10"

    Call MakeTooltips HWND(#main)
    gosub [Initialize.All.Controls]

[loop]
    Wait


[Flash.Exit]

    UNLOADBMP "AboutBox"
    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed
    close #main : END
    Wait
    
[Initialize.All.Controls]

    CurrentCard = 1
    print #main.textedQuestion, "!cls"
    print #main.textedQuestion, Question$(CurrentCard)
    
    #main.textedAnswer, "!cls"
    print #main.staticCurrentCard, str$(CurrentCard)
    print #main.staticNoOfCards, str$(TotalCards)
    
    print #main.FriendlyName,  FriendlyName$
    print #main.FlashFileName, FlashFileName$
    print #main.txtCardNumber, "1"

    ShowGraphicEnabled = 0                                              'Disable the "Show Graphic" 
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled    'button at program startup.

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    return

[Set.Friendly.Name]
    
    'Flash-O-Rama stacks have a "Friendly Name" in
    'addition to their regular filename.  This routine
    'allows the user to set the Friendly Name of 
    'the stack.

    NewFriendlyName$ = FriendlyName$
    
    Prompt "New 'Friendly Name' for this stack:"; NewFriendlyName$
    
    If ( NewFriendlyName$ = "" ) then wait   'If the empty string is returned,
                                             'That means that the user pressed
                                             'Cancel in the prompt box.  So,
                                             'just wait for some other event.
    
    FriendlyName$ = NewFriendlyName$         'If program control has arrived at
    print #main.FriendlyName, FriendlyName$  'this point, then the user has 
                                             'entered a new Friendly name for the
    Wait                                     'Flash card stack.

[New.Flash.Card.Stack]

    'See the Confirm dialog box below.  Creating
    'a new flash card stack will essentially erase
    'the current stack from memory.  So, it's important
    'to advise the user that this operation will take
    'place before she goes through with it.

    Confirm "Creating a new flash card stack   " + chr$(13) + _
            "will delete the existing stack    " + chr$(13) + _
            "from memory.  Are you sure you    " + chr$(13) + _
            "want to create a new stack?       "; ConfirmNewStack$
            
    If ( ConfirmNewStack$ = "no" ) then wait   'This line causes program flow to
                                               'enter a wait state and wait for the
                                               'next event, since the user pressed "No".

     CurrentCard = 1                           'If control has fallen to this line, then
        NextCard = 2                           'the user has indicated Yes, a new stack
      TotalCards = 5                           'should be created.  Hereafter, all the
   FriendlyName$ = "Untitled Flash Cards"      'initial values of the new stack will be
  FlashFileName$ = "Untitled.fls"              'reset to zero, null or something similar.

    for i = 1 to 200
        BitMapName$(i) = "none"
          HasBitMap(i) = 0
          Question$(i) = ""
          Answer$(i)   = ""
    next i

    For i = 1 to TotalCards
        Question$(i) = chr$(13) + "Type question #" + str$(i) + " here." + chr$(13)
        Answer$(i)   = chr$(13) + "Type the answer to question #" + str$(i) + " here." + chr$(13)
    next i

    gosub [Initialize.All.Controls]

    Wait

[Flash.Save]
    
    SaveFileName$ = FlashFileName$
    goto [Begin.Save.Operation]
    
    Wait

[Flash.Save.As]
    
    filedialog "Save Flash Card file as...", "*.flc", SaveFileName$
    
    If ( SaveFileName$ = "") then wait     'A wait state is entered if the
                                           'presses "Cancel" at the File Dialog
                                           'box during a "Save as..." operation.
                                           'At this point, the program is merely
                                           'waiting for the next event.
                                           '
                                           'If "Cancel" was not pressed, then
                                           'the program begins to evaluate the
                                           'new filename provided by the user.
    
    SFNExtension$ = lower$(right$(SaveFileName$, 4))  'Here, the program is checking the
                                                      'the new filename entered to determine
    If (SFNExtension$ <> ".flc") then                 'if the user has appended the ".flc"
        SaveFileName$ = SaveFileName$ + ".flc"        'extension.  if the user has not appended
    end if                                            'the extension, then the program will
                                                      'add it to the end of the filename
                                                      'typed by the user.
    
    [Begin.Save.Operation]
    Open SaveFileName$ for output as #1
    
    'Before the save operation commences, take all
    'questions and answers, and strip the carriage
    'return characters that may have accumulated
    'at the end of string arrary variables.
    
    For i = 1 to TotalCards
        Question$(i) = StripEndingCarriageReturns$( Question$(i) )
          Answer$(i) = StripEndingCarriageReturns$( Answer$(i) )
    next i
    
    
    print #1, "<flashcard>"         'During the save process, the program
    print #1, " "                   'is organizing the flash card information
    print #1, "<friendlyname>"      'by placing tags in the .flc data files.
    print #1, FriendlyName$         'Like html tags, Flash-O-Rama tags are
    print #1, "</friendlyname>"     'enclosed in "<" and ">" characters.
    print #1, " "
    
    for i = 1 to TotalCards
        print #1, "<question>"
        if (HasBitMap(i) = 1) then
            print #1, "<bitmap>"
            print #1, BitMapName$(i)
            print #1, "</bitmap>"
        end if
        print #1, Question$(i)
        print #1, "</question>"
        print #1, " "
        print #1, "<answer>"
        print #1, Answer$(i)
        print #1, "</answer>"
        print #1, " "
    next i
    
    print #1, "</flashcard>"    'This is the closing tag, indicating
    print #1, " "               'that all the flash card data has now
                                'been written to the file.
    close #1
    
    FlashFileName$ = SaveFileName$
    print #main.FlashFileName, FlashFileName$
    
    Wait

[Print.As.Notes]

    'This little dialog window provides a way for the
    'user to indicate whether she wants all of her
    'flash cards printed, or only a subset of the cards.

    gosub [Ensure.DisplayGraf.Closed]

    NOMAINWIN
    WindowWidth = 260 : WindowHeight = 235
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)


statictext  #PrRange.staticAll, "Specify Flash-O-Rama cards to print...", 10, 10, 225, 16
statictext  #PrRange.staticFrom, "from Card #:", 40, 100, 75, 20
statictext  #PrRange.staticToCard, "to Card #:", 55, 125, 60, 16
button      #PrRange.btnPrint, "Print Cards",[btnRangePrint.click],UL, 35, 160, 90, 25
button      #PrRange.btnCancel, "Cancel",[btnPrCancel.click],UL, 135, 160, 90, 25
TextboxColor$    = "White"
textbox     #PrRange.txtFirstCard, 115, 95, 40, 24
textbox     #PrRange.txtToCard, 115, 120, 40, 24
radiobutton #PrRange.radioAll, "Print all cards in this stack",[radioAll.click],[PR.loop], 15, 45, 180, 20
radiobutton #PrRange.radioRange, "Print selected range:",[radioRange.click],[PR.loop], 15, 70, 180, 20

    Open "Flash-O-Rama Print Range" for Dialog as #PrRange
    PrintRangeOpen = 1

    print #PrRange, "trapclose [btnPrCancel.click]"
    print #PrRange, "font arial 10"
    gosub [Initialize.Print.Range.Controls]

    Call MakePrTooltips HWND(#PrRange)

[PR.loop]

    Wait


[Initialize.Print.Range.Controls]

    PrintAllFlag = 1                                  'When the dialog window opens, 
    print #PrRange.radioAll,   "set"                  'the default selection for printing
    print #PrRange.radioRange, "reset"                'cards is to print ALL cards.
    Call EnableWindow hWnd(#PrRange.txtFirstCard), 1  'Therefore, the "Print all" radiobutton
    Call EnableWindow hWnd(#PrRange.txtToCard), 1     'is "set", while the "Print range"
    print #PrRange.txtFirstCard, "1"                  'radiobutton is "reset".  Additionally,
    print #PrRange.txtToCard, str$(TotalCards)        'the print range Textboxes are deactivated
    Call EnableWindow hWnd(#PrRange.txtFirstCard), 0  'until the "Print range" radiobutton is
    Call EnableWindow hWnd(#PrRange.txtToCard), 0     '"set".
    FirstCard2Print = 1
    LastCard2Print  = TotalCards

    return


[btnPrCancel.click]
    close #PrRange
    PrintRangeOpen = 0
    Wait

[radioAll.click]
    
    PrintAllFlag = 1
    FirstCard2Print = 1
    LastCard2Print  = TotalCards
    Call EnableWindow hWnd(#PrRange.txtFirstCard), 1
    Call EnableWindow hWnd(#PrRange.txtToCard), 1
    print #PrRange.txtFirstCard, str$(FirstCard2Print)
    print #PrRange.txtToCard,    str$(LastCard2Print)
    Call EnableWindow hWnd(#PrRange.txtFirstCard), 0
    Call EnableWindow hWnd(#PrRange.txtToCard), 0
    
    Wait

[radioRange.click]
    
    PrintAllFlag = 0
    Call EnableWindow hWnd(#PrRange.txtFirstCard), 1
    Call EnableWindow hWnd(#PrRange.txtToCard), 1
    
    Wait

[btnRangePrint.click]
    
    'If the PrintAllFlag variable is set to zero,
    'this means that a smaller range of the cards
    'is going to be printed.  Determine what
    'that small range is.
    
    if (PrintAllFlag = 0) then
        print #PrRange.txtFirstCard, "!contents? FirstCard2Print$"
        print #PrRange.txtToCard,    "!contents? LastCard2Print$"
        
        FirstCard2Print = val(FirstCard2Print$)
         LastCard2Print = val(LastCard2Print$)
         
        If (FirstCard2Print < 1) then FirstCard2Print = 1                   'Much of the code in this
        If (FirstCard2Print > TotalCards) then FirstCard2Print = TotalCards 'section will adjust the
                                                                            'first and last cards to be
        If (LastCard2Print < 1) then LastCard2Print = 1                     'printed if the user accidentally
        If (LastCard2Print > TotalCards) then LastCard2Print = TotalCards   'indicates, for example, that the
                                                                            'first card to be printed is
        print #PrRange.txtFirstCard, str$(FirstCard2Print)                  ' card #10, and the last card to
        print #PrRange.txtToCard,    str$(LastCard2Print)                   'be printed is card #5.
                                                                            '
        If ( FirstCard2Print > LastCard2Print ) then                        '
                     TempID = FirstCard2Print                               '
            FirstCard2Print = LastCard2Print                                '
             LastCard2Print = TempID                                        '
            print #PrRange.txtFirstCard, str$(FirstCard2Print)              '
            print #PrRange.txtToCard,    str$(LastCard2Print)               '
        end if                                                              '
                                                                            '
    end if                                                                  '
    
    'Print range is determined.  Now, close the
    'print range window, and begin printing the cards.
    
    close #PrRange
    PrintRangeOpen = 0


    '''''''''''''''''''''''''''''''''''''''
    'First, process all the questions and answers for
    'printing by stripping away all of the extraneous
    'chr$(13) characters at the end of the string item.
    
    for i = 1 to TotalCards
        QSize = Len(Question$(i))
        for j = QSize to 1 step (-1)
            LastNonCR = 1
            If (MID$(Question$(i), j, 1) <> chr$(13)) then
                LastNonCR = j
                Q4Print$(i) = Left$(Question$(i), LastNonCR)
                j = 1
            end if
        next j
        
        ASize = Len(Answer$(i))
        for j = ASize to 1 step (-1)
            LastNonCR = 1
            If (MID$(Answer$(i), j, 1) <> chr$(13)) then
                LastNonCR = j
                A4Print$(i) = Left$(Answer$(i), LastNonCR)
                j = 1
            end if
        next j
        
    next i

    '''''''''''''''''''''''''''''''''''''''
    LPrint "FLASH CARD NOTES"
    LPrint " "
    Lprint "     Topic Name: "; FriendlyName$
    Lprint "     File Name:  "; FlashFileName$
    Lprint "Number of Cards: "; TotalCards
    LPrint " "

    for i = FirstCard2Print to LastCard2Print
        Lprint " "
        LPrint "---------------------------"
        LPrint "Question #"; i

        For j = 1 to Len(Q4Print$(i))        'In this section of code, the program
            CC$ = MID$(Q4Print$(i), j, 1)    'is looking at the question text one
            If (CC$ <> chr$(13)) then        'character at a time.  If the character
                LPrint CC$;                  'is not a carriage return, then the
            Else                             'program will send the character to the
                LPrint chr$(10);             'printer.
            end if
        next j
        
        Lprint " "
        LPrint " "
        LPrint "Answer #"; i
        
        For j = 1 to Len(A4Print$(i))
            CC$ = MID$(A4Print$(i), j, 1)
            If (CC$ <> chr$(13)) then
                LPrint CC$;
            Else
                LPrint chr$(10);
            end if
        next j
        
        LPrint " "
        
    next i
    
    Dump
    
    Wait


[Insert.New.Card]
    
    If (CurrentCard = TotalCards) then [New.Card.At.End]   'If the current card happens to be
                                                           'the last card in the stack, then
                                                           'inserting a new card after the
                                                           'current card is the same as placing
                                                           'a new card at the end of the stack.
                                                           'So, direct program control to the
                                                           'code that performs that operation.
    
    For i = (TotalCards + 1) to (CurrentCard + 2) step -1  'A new card is inserted by
        Question$(i) = Question$(i-1)                      'shifting downward all proceeding
          Answer$(i) = Answer$(i-1)                        'cards after the current card.
      BitMapName$(i) = BitMapName$(i-1)
        HasBitMap(i) = HasBitMap(i-1)
    Next i
    
    Question$(CurrentCard + 1) = "Enter new question here."
      Answer$(CurrentCard + 1) = "Enter new answer here."
      
    NextCard = CurrentCard + 1
    Print #main.textedQuestion, "!cls"
    Print #main.textedQuestion, Question$(NextCard)
    print #main.textedQuestion, "!origin 1 1"
    
    Print #main.textedAnswer, "!cls"
    Print #main.textedAnswer, Answer$(NextCard)
    print #main.textedAnswer, "!origin 1 1"
    
    print #main.staticCurrentCard, str$(NextCard)
    TotalCards = TotalCards + 1
    CurrentCard = NextCard
    print #main.staticNoOfCards, str$(TotalCards) 

    'Since the current card is a New Card, there is no
    'bitmap associated with it yet.  So, disable the
    '"Display Picture" button.
    ShowGraphicEnabled = 0
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled 

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    Wait


[New.Card.At.End]

    Question$(TotalCards + 1) = "Enter new question here."
      Answer$(TotalCards + 1) = "Enter new answer here."
      
      TotalCards = TotalCards + 1
      CurrentCard = TotalCards
    
    print #main.textedQuestion, "!cls"
    print #main.textedQuestion, Question$(CurrentCard)
    print #main.textedQuestion, "!origin 1 1"

    print #main.textedAnswer, "!cls"
    print #main.textedAnswer, Answer$(CurrentCard)
    print #main.textedAnswer, "!origin 1 1"
    
    print #main.staticCurrentCard, str$(CurrentCard)
    print #main.staticNoOfCards,   str$(TotalCards)

    'Since this routine creates a brand new
    'card at the end of the stack, it does not have a
    'bitmap associated with it yet.  So, disable the
    '"Display Picture" button.
    ShowGraphicEnabled = 0
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    Wait

[Link.Bitmap]
        
    filedialog "Link BitMap File to this card", "*.bmp", LinkBitMapFile$
    
    If ( LinkBitMapFile$ = "") then wait  'If the user has pressed "Cancel"
                                          'then place the program in a wait state
                                          'and wait for the next event.
    
    'If program control has fallen to this point,
    'then the user has selected a bitmap to link
    'to the current card.
    
    'Before the linking takes place, Flash-O-Rama will
    'strip the path information away from the bitmap name.
    'Flash-O-Rama's author does not wish to store the
    'path name in the *.flc files because the user
    'may wish to copy his flash card stack to a 
    'floppy disk.  Storing the path name would
    'create confusion when Flash-O-Rama looks for
    'the bitmap.
    
    LenBitMap = Len( LinkBitMapFile$ )
    BackSlashLocation = 0
    
    For i = LenBitMap to 1 Step (-1)
        If (mid$(LinkBitMapFile$, i, 1) = "\") then
            BackSlashLocation = i
            ShortBitMapName$ = Right$(LinkBitMapFile$, (LenBitMap - BackSlashLocation))
            LinkBitMapFile$ = ShortBitMapName$
            i = 1
        end if
    next i
    
    BitMapName$(CurrentCard) = LinkBitMapFile$
      HasBitMap(CurrentCard) = 1

    'The current card now has a new
    'bitmap associated with it.  So, enable the
    '"Display Picture" button.
    ShowGraphicEnabled = 1
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed
    
    Wait

[UnLink.Bitmap]
    
    If (HasBitMap(CurrentCard) = 0) then
        Notice "Flash-O-Rama Notice" + chr$(13) + _
               "There is no BitMap linked    " + chr$(13) + _
               "to card number " + str$(CurrentCard) + "."
    end if
    
    If (HasBitMap(CurrentCard) = 0) then wait
    
    Confirm "Confirm unlink of " + BitMapName$(CurrentCard) + _ 
            " from card " + str$(CurrentCard) + ".    "; ConfirmUnlink$
    
    if (ConfirmUnlink$ = "no") then wait
    
    BitMapName$(CurrentCard) = ""
      HasBitMap(CurrentCard) = 0

    'Having just de-linked a bitmap from the
    'current card, it's time to disable the
    '"Display picture" button.
    ShowGraphicEnabled = 0
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    Notice "Flash-O-Rama Notice               " + chr$(13) + _
           "BitMap is unlinked from card.     "
    
    Wait


[Delete.This.Card]
    
    'First, stop the delete card operation if there are
    'only three cards left in the stack.  This will prevent
    'problems that might occur by taking the number of
    'cards down to zero.

    If (TotalCards = 3) then
        Notice "Flash-O-Rama Error" + chr$(13) + _
               "Flash-O-Rama does not allow    " + chr$(13) + _
               "stacks with less than three    " + chr$(13) + _
               "cards.  If you must delete     " + chr$(13) + _
               "this card, insert or add a     " + chr$(13) + _
               "new card first.                "
    end if
    
    If (TotalCards = 3) then Wait
    
    'If control has fallen to this point, then the
    'number of cards must be greater than three.
    'Proceed by getting confirmation from the user
    'that she wants to delete this card.
    
    confirm "Are you sure you want to  " + chr$(13) + _
            "delete card #" + str$(CurrentCard) + " ?"; ConfirmDeleteCard$

    if ConfirmDeleteCard$ = "no" then Wait



    If (CurrentCard <> TotalCards) then
        For i = CurrentCard to (TotalCards - 1)   'This is the card
            Question$(i) = Question$(i + 1)       'deletion routine if
              Answer$(i) = Answer$(i + 1)         'the card being deleted
          BitMapName$(i) = BitMapName$(i + 1)     'is any card other than
            HasBitMap(i) = HasBitMap(i + 1)       'the last card.
        Next i
    End if
    
    If (CurrentCard = TotalCards) then            'If the card being deleted is the
        CurrentCard = (TotalCards - 1)            'last card in the stack, then none
    end if                                        'of the data shifting shown above
                                                  'needs to take place.

    TotalCards = TotalCards - 1
    Question$(TotalCards + 1) = ""
      Answer$(TotalCards + 1) = ""
    
    print #main.textedQuestion, "!cls"
    print #main.textedQuestion, Question$(CurrentCard)
    print #main.textedQuestion, "!origin 1 1"

    print #main.textedAnswer, "!cls"
    print #main.textedAnswer, "!origin 1 1"
    
    print #main.staticCurrentCard, str$(CurrentCard)
    print #main.staticNoOfCards,   str$(TotalCards)
    
    'If the current card has a bitmap
    'associated with it, then enable the
    '"Display picture" button.  Otherwise, 
    'disable the button.
    ShowGraphicEnabled = HasBitMap(CurrentCard)
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled
    
    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed
    
    Wait



[Flash.Card.Help]
    'Hat tip to Alyce Watson for her discussion of
    'the programming required to run a *.chm file.

    lpszOp$ =  "open"
    lpszFile$ = DefaultDir$+"\FlashHelp.chm"
    lpszDir$ = DefaultDir$ 
    lpszParams$=""

    CallDLL #shell32, "ShellExecuteA",_
    hWnd As long,_         'window handle or 0
    lpszOp$ As ptr,_       'operation to perform
    lpszFile$ As ptr,_     'file to run
    lpszParams$ As ptr,_   'any parameters needed
    lpszDir$ As ptr,_      'default directory
    _SW_SHOWNA As long,_   'show window parameter
    result As long         'success result > 32

    Wait

[About.Flash.O.Rama]

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    NOMAINWIN
    WindowWidth = 335 : WindowHeight = 431
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

graphicbox  #About.GBox1, 5, 5, 316, 318
statictext  #About.static001, "Copyright Tomas J. Nally                  May 2003", 5, 330, 300, 20
statictext  #About.static002, "Steelweaver52@aol.com", 5, 350, 150, 20
statictext  #About.static003, "Released as Open Source", 5, 370, 155, 20
button      #About.btnWhatever, "Yeah, whatever",[Whatever.click],UL, 175, 350, 140, 35

Open "About Flash-O-Rama" for Dialog as #About

    print #About, "trapclose [Whatever.click]"
    print #About.GBox1, "down; fill White; flush"
    print #About.GBox1, "setfocus "
    print #About, "font arial 10"
    
    print #About.GBox1, "drawbmp AboutBox 0 0"
    print #About.GBox1, "flush"

[About.loop]
    Wait


[Whatever.click]
    close #About
    Wait




[Set.Question]

    print #main.textedQuestion, "!contents? Quest$"  '"Setting the question" is an operation
    Question$(CurrentCard) = Quest$                  'which makes sure that the user's 
    print #main.textedQuestion, "!origin 1 1"        'recently-edited question gets stored in
                                                     'the Question$() array.  If it isn't stored
    Wait                                             'then the edit will disappear the next time
                                                     'the user navigates to this card.
                                                     
[Set.Answer]

    print #main.textedAnswer, "!contents? Answ$"     'See comments just above on 
    Answer$(CurrentCard) = Answ$                     '"Setting the question".
    print #main.textedAnswer, "!origin 1 1"

    Wait

[Show.Answer]
    print #main.textedAnswer, "!cls"
    print #main.textedAnswer, Answer$(CurrentCard)
    print #main.textedAnswer, "!origin 1 1"
    Wait

[Hide.Answer]
    print #main.textedAnswer, "!cls"
    
    Wait

[Show.Graphic]

    NOMAINWIN
    WindowWidth = 335 : WindowHeight = 415
    'UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftX = 40
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

graphicbox  #DispGraf.PicBox, 5, 5, 318, 318
statictext  #DispGraf.staticBMName,  "BitMap Name", 10, 330, 235, 20
statictext  #DispGraf.StaticFCN,     "For card # ", 10, 350, 65, 20
statictext  #DispGraf.staticCardNum, "001",         80, 350, 40, 20
button      #DispGraf.btnClose, "Close",[CloseDispGraf.click],UL, 250, 330, 70, 35

Open "Display Flash-O-Rama Picture" for Dialog as #DispGraf

    PicWindowOpen = 1

    print #DispGraf, "trapclose [CloseDispGraf.click]"
    print #DispGraf.PicBox, "down; fill Lightgray; flush"
    print #DispGraf.PicBox, "setfocus "
    print #DispGraf, "font arial 10"

    Call MakeTooltipsGRAF HWND(#DispGraf)
    
    LOADBMP "FlashPic", BitMapName$(CurrentCard)
    print #DispGraf.PicBox, "drawbmp FlashPic 0 0"
    print #DispGraf.PicBox, "flush"
    print #DispGraf.staticBMName, BitMapName$(CurrentCard)
    print #DispGraf.staticCardNum, str$(CurrentCard)


[Disp.Pic.loop]
    Wait

[CloseDispGraf.click]
    close #DispGraf 
    PicWindowOpen = 0
    UNLOADBMP "FlashPic"
    Wait



[FirstCard.click]
    
    PrevCard = 1
    
    Print #main.textedQuestion, "!cls"
    Print #main.textedQuestion, Question$(PrevCard)
    print #main.textedQuestion, "!origin 1 1"
    
    Print #main.textedAnswer, "!cls"
    
    print #main.staticCurrentCard, str$(PrevCard)
    
    CurrentCard = PrevCard    

    'If the current card has a bitmap
    'associated with it, then enable the
    '"Display picture" button.  Otherwise, 
    'disable the button.
    ShowGraphicEnabled = HasBitMap(CurrentCard)
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled
    
    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed
    
    Wait

[PreviousCard.click]
    
    PrevCard = CurrentCard - 1
    if (PrevCard = 0) then PrevCard = TotalCards
    Print #main.textedQuestion, "!cls"
    Print #main.textedQuestion, Question$(PrevCard)
    print #main.textedQuestion, "!origin 1 1"
    
    Print #main.textedAnswer, "!cls"
    
    print #main.staticCurrentCard, str$(PrevCard)
    
    CurrentCard = PrevCard
    
    'If the current card has a bitmap
    'associated with it, then enable the
    '"Display picture" button.  Otherwise, 
    'disable the button.
    ShowGraphicEnabled = HasBitMap(CurrentCard)
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    Wait

[NextCard.click]
    
    NextCard = CurrentCard + 1
    If (NextCard = (TotalCards + 1) ) then NextCard = 1
    Print #main.textedQuestion, "!cls"
    Print #main.textedQuestion, Question$(NextCard)
    print #main.textedQuestion, "!origin 1 1"
    
    Print #main.textedAnswer, "!cls"
    
    print #main.staticCurrentCard, str$(NextCard)
    
    CurrentCard = NextCard
    
    'If the current card has a bitmap
    'associated with it, then enable the
    '"Display picture" button.  Otherwise, 
    'disable the button.
    ShowGraphicEnabled = HasBitMap(CurrentCard)
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    Wait

[LastCard.click]

    NextCard = TotalCards

    Print #main.textedQuestion, "!cls"
    Print #main.textedQuestion, Question$(NextCard)
    print #main.textedQuestion, "!origin 1 1"
    
    Print #main.textedAnswer, "!cls"
    
    print #main.staticCurrentCard, str$(NextCard)
    
    CurrentCard = NextCard

    'If the current card has a bitmap
    'associated with it, then enable the
    '"Display picture" button.  Otherwise, 
    'disable the button.
    ShowGraphicEnabled = HasBitMap(CurrentCard)
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    Wait

[Random.Card]

    RandomCard = 1 + int( TotalCards * rnd(1))

    Print #main.textedQuestion, "!cls"
    Print #main.textedQuestion, Question$(RandomCard)
    print #main.textedQuestion, "!origin 1 1"
    
    Print #main.textedAnswer, "!cls"
    
    print #main.staticCurrentCard, str$(RandomCard)
    
    CurrentCard = RandomCard

    'If the current card has a bitmap
    'associated with it, then enable the
    '"Display picture" button.  Otherwise, 
    'disable the button.
    ShowGraphicEnabled = HasBitMap(CurrentCard)
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled

    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    Wait

[Go.To.Card]
    
    print #main.txtCardNumber, "!contents? TheGoToCard$"
    
    TheGoToCard = int(val(TheGoToCard$))
    print #main.txtCardNumber, str$(TheGoToCard)
    
    TheGoToCardInRange = 1
    
    If ((TheGoToCard < 1) or (TheGoToCard > TotalCards )) then
        TheGoToCardInRange = 0
        Notice "Flash Card Error" + Chr$(13) + _
               "The card number you selected is     " + chr$(13) + _
               "not in the range of this stack      " + chr$(13) + _
               "of flash cards.  Enter a different  " + chr$(13) + _
               "number.                             "
    end if
    
    If ( TheGoToCardInRange = 0 ) then wait
    
    Print #main.textedQuestion, "!cls"
    Print #main.textedQuestion, Question$(TheGoToCard)
    print #main.textedQuestion, "!origin 1 1"
    
    Print #main.textedAnswer, "!cls"
    
    print #main.staticCurrentCard, str$(TheGoToCard)
    
    CurrentCard = TheGoToCard
    
    'If the current card has a bitmap
    'associated with it, then enable the
    '"Display picture" button.  Otherwise, 
    'disable the button.
    ShowGraphicEnabled = HasBitMap(CurrentCard)
    Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled
    
    gosub [Ensure.DisplayGraf.Closed] 'Make sure the Display
                                      'Picture Window is closed

    Wait

''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[Flash.Open]


    filedialog "Open Flash Card file", "*.flc", FCFilename$

    If (FCFilename$ = "") then wait     'If the FileDialog operation returns
                                        'the empty string, then just wait for
                                        'the next event.

    gosub [Ensure.DisplayGraf.Closed]   'Make sure the Display
                                        'Picture Window is closed



    For i = 1 to 200                    'Since a new stack of flash cards is
        Question$(i) = ""               'going to be opened, then the array
          Answer$(i) = ""               'contents of the questions and answers
      BitMapName$(i) = ""               'must all be set to the null string,
        HasBitMap(i) = 0                'else the information read by the
    next i                              'input routine will be concatenated
                                        'onto the old question and answer data.

    Open FCFilename$ for Input as #1

    TotalCards = 0                      'The TotalCards variable is initially set
                                        'to zero.  Then, as each <question> tag is
                                        'encountered, the TotalCards variable is
                                        'incremented by 1.

    [Resume.Tag.Recognition]

    TagTriggered = 0
    Line input #1, LL$
    LL$ = word$(LL$, 1)

    If ( LL$ = "<friendlyname>" ) then   'If the <friendlyname> tag is encountered,
        TagTriggered = 1                 'then set the TagTriggered variable to 1,
        gosub [Evaluate.Friendly.Name]   'and go to the subroutine which captures the
    end if                               'friendly name of the flash card stack.

    If ( TagTriggered = 1 ) then [Resume.Tag.Recognition]

    If ( LL$ = "<question>" ) then
        TagTriggered = 1
        TotalCards = TotalCards + 1
        gosub [Evaluate.Question]
    end if

    If ( TagTriggered = 1 ) then [Resume.Tag.Recognition]

    If ( LL$ = "<answer>" ) then
        TagTriggered = 1
        gosub [Evaluate.Answer]
    end if

    If ( TagTriggered = 1 ) then [Resume.Tag.Recognition]

    If ( LL$ = "</flashcard>" ) then
        close #1
        print #main.textedQuestion,    "!cls"
        print #main.textedAnswer,      "!cls"
        print #main.textedQuestion,    Question$(1)
        print #main.textedQuestion,    "!origin 1 1"
        Print #main.staticNoOfCards,   str$(TotalCards)
        Print #main.staticCurrentCard, "1"
        CurrentCard = 1
        
        'At the end of an "Open" operation, card
        'number 1 is the CurrentCard.  If the CurrentCard
        'has a bitmap associated with it, then enable the 
        '"Display Bitmap" button; otherwise, disable it.
        ShowGraphicEnabled = HasBitMap(CurrentCard)
        Call EnableWindow hWnd(#main.btnShowGraphic), ShowGraphicEnabled        
        
        FlashFileName$ = FCFilename$
        print #main.FriendlyName,  FriendlyName$ 
        print #main.FlashFileName, FlashFileName$
    end if
                                                          'If the </flashcard> tag is encountered,
    If ( LL$ = "</flashcard>" ) then Wait                 'then this marks the end of the data for
                                                          'this flashcard stack.  The file will now
                                                          'be closed, and a Wait state will be
                                                          'initiated.

    If ( TagTriggered = 0 ) then [Resume.Tag.Recognition]  'If no tag has been encountered, then
                                                           'the TagTriggered variable remains at
                                                           'it's initial value of zero.  If this is
                                                           'the case, then read the next line in
                                                           'the file, which is done at the top
                                                           'of the routine.



    Wait

''''''''''''''''''''''''''''''''''''''''''''''''''''''''

[Evaluate.Friendly.Name]

    Line input #1, FF$        'This routine reads the "friendly" name
    FriendlyName$ = FF$       'of the current flash card stack, storing it
                              'in the variable called, FriendlyName$.

    Line input #1, Misc$      'This line merely reads the closing tag of
                              'the operation, which is </friendlyname>.
                              'There is no processing done on this little
                              'piece of data.

    Return

''''''''''''''''''''''''''''''''''''''''''''''''''''''''

[Evaluate.Question]

    ThisCard = TotalCards

    [Resume.Question.Evaluation]

    Line input #1, QQ$

    If (word$(QQ$, 1) = "<bitmap>") then  'If the first word on the line is
        gosub [Store.Bitmap.Name]         'the <bitmap> tag, then a bitmap is associated
    end if                                'with this card, and the bitmap name
                                          'must be captured.

    If (word$(QQ$, 1) = "<bitmap>") then [Resume.Question.Evaluation]

                                          'See line above.  If the <bitmap> tag has
                                          'been encountered, then the bitmap name has
                                          'already been evaluated, and control must
                                          'be returned to the top of routine.

    If (word$(QQ$, 1) = "</question>") then [Finished.Question.Evaluation]

                                          'See line above.  If the </question> tag is
                                          'encountered, then there is no more text
                                          'forming the question.  So, control must be
                                          'directed to the end of the routine.

    Question$(ThisCard) = Question$(ThisCard)+ QQ$ + chr$(13)
    Goto [Resume.Question.Evaluation]

                                          'See lines above.  If control has fallen to this
                                          'point, then none of the tags have been encountered.
                                          'Therefore, append the text line to Answer$(), and
                                          'go back to input the next line.

    [Finished.Question.Evaluation]        'Program control will fall to this location once
                                          'the </question> tag has been encountered.
    Return

''''''''''''''''''''''''''''''''''''''''''''''''''''''''

[Evaluate.Answer]

    'Note: the "ThisCard" variable will not be set, because

    [Resume.Answer.Evaluation]

    Line input #1, AA$

    If (word$(AA$, 1) = "</answer>") then [Finished.Answer.Evaluation]

                                          'See line above.  If the </answer> tag is
                                          'encountered, then there is no more text
                                          'forming the answer.  So, control must be
                                          'directed to the end of the routine.

    Answer$(ThisCard) = Answer$(ThisCard) + AA$ + chr$(13)
    Goto [Resume.Answer.Evaluation]

                                          'See lines above.  If the </answer> tag has
                                          'not been encountered, then this line must
                                          'be part of the text of the answer.  Append
                                          'this line to the other text captured, and
                                          'resume reading lines.


    [Finished.Answer.Evaluation]          'Program control will fall to this location once
                                          'the </question> tag has been encountered.

    Return

''''''''''''''''''''''''''''''''''''''''''''''''''''''''

[Store.Bitmap.Name]

    Line input #1, bmp$
    BitMapName$(ThisCard) = bmp$          'This stores the name of the bitmap
      HasBitMap(ThisCard) = 1             'associated with this card into an array.

    Line input #1, Misc$                  'This line merely reads the closing tag
                                          'of the bitmap identification, which
                                          'is "</bitmap>".  There is no processing of
                                          'this information.

    Return


    Wait

''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[Ensure.DisplayGraf.Closed]

    If ( PicWindowOpen = 1 ) then
        close #DispGraf
        PicWindowOpen = 0
        UNLOADBMP "FlashPic"
    end if

    If (PrintRangeOpen = 1) then
        close #PrRange 
        PrintRangeOpen = 0
    end if

    Return

''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'From Alyce Watson, this routine allows the "Display Graphic"
'button to be enabled or disabled.

Sub EnableWindow hW, flag
    'Enable=1 Disable=0
    CallDLL #user32, "EnableWindow",_
    hW As Long, flag As Boolean,_
    result As Boolean
    End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''




SUB MakeTooltips hWin
    TTS.ALWAYSTIP = 1 : TTS.NOPREFIX = 2 : style = _WS_POPUP or TTS.NOPREFIX or TTS.ALWAYSTIP
    calldll #comctl32,"InitCommonControls", re as void
    calldll #user32, "GetWindowLongA", hWin as long, _GWL_HINSTANCE as long, hInstance as long
    calldll #user32, "CreateWindowExA", _WS_EX_TOPMOST as long,"tooltips_class32" as ptr, "" as ptr,_
        style as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long,_
        hWin as long, 0 as long, hInstance as long, "" as ptr, hwndTT as long
    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    calldll #user32, "SetWindowPos", hwndTT as long,_HWND_TOPMOST as long, 0 as long, 0 as long, 0 as long, 0 as long, flags as long, r as long

    'create a struct for the tooltips:
    struct toolinfo, cbSize as long, uFlags as long, hWindow as long, uId as long, x as long, y as long, w as long, h as long, hInst as long, lpstrText$ as ptr
    toolinfo.cbSize.struct = len(toolinfo.struct)
    toolinfo.uFlags.struct = 1 Or 16
    toolinfo.hWindow.struct = hWin

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnFirst)
    toolinfo.lpstrText$.struct = "Go to first card"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnShowAnswer)
    toolinfo.lpstrText$.struct = "Show the Answer"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnHideAnswer)
    toolinfo.lpstrText$.struct = "Hide the Answer"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnShowGraphic)
    toolinfo.lpstrText$.struct = "Show graphic for this card"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnPrev)
    toolinfo.lpstrText$.struct = "Go to previous card"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnNext)
    toolinfo.lpstrText$.struct = "Go to next card"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnLast)
    toolinfo.lpstrText$.struct = "Go to last card"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnRandomCard)
    toolinfo.lpstrText$.struct = "Go to a random card"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnGoToCard)
    toolinfo.lpstrText$.struct = "Go to card number"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnQuit)
    toolinfo.lpstrText$.struct = "Quit Flash-O-Rama"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnSetQuestion)
    toolinfo.lpstrText$.struct = "Set the question"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#main.btnSetAnswer)
    toolinfo.lpstrText$.struct = "Set the answer"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Textbox Tooltip:
    toolinfo.uId.struct = hwnd(#main.txtVLine)
    toolinfo.lpstrText$.struct = "Vertical line"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Textbox Tooltip:
    toolinfo.uId.struct = hwnd(#main.txtCardNumber)
    toolinfo.lpstrText$.struct = "Enter card number"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Texteditor Tooltip:
    toolinfo.uId.struct = hwnd(#main.textedQuestion)
    toolinfo.lpstrText$.struct = "Right-click for an edit menu."  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Texteditor Tooltip:
    toolinfo.uId.struct = hwnd(#main.textedAnswer)
    toolinfo.lpstrText$.struct = "Right-click for an edit menu."  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long


    END SUB

'''''''''''''''''''''''''''''''''''''''''''''''''''''
'Tooltips for the dialog box showing
'the Flash-O-Rama graphics

SUB MakeTooltipsGRAF hWin
    TTS.ALWAYSTIP = 1 : TTS.NOPREFIX = 2 : style = _WS_POPUP or TTS.NOPREFIX or TTS.ALWAYSTIP
    calldll #comctl32,"InitCommonControls", re as void
    calldll #user32, "GetWindowLongA", hWin as long, _GWL_HINSTANCE as long, hInstance as long
    calldll #user32, "CreateWindowExA", _WS_EX_TOPMOST as long,"tooltips_class32" as ptr, "" as ptr,_
        style as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long,_
        hWin as long, 0 as long, hInstance as long, "" as ptr, hwndTT as long
    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    calldll #user32, "SetWindowPos", hwndTT as long,_HWND_TOPMOST as long, 0 as long, 0 as long, 0 as long, 0 as long, flags as long, r as long

    'create a struct for the tooltips:
    struct toolinfo, cbSize as long, uFlags as long, hWindow as long, uId as long, x as long, y as long, w as long, h as long, hInst as long, lpstrText$ as ptr
    toolinfo.cbSize.struct = len(toolinfo.struct)
    toolinfo.uFlags.struct = 1 Or 16
    toolinfo.hWindow.struct = hWin

'Graphicbox Tooltip:
    toolinfo.hWindow.struct = hWin
    toolinfo.uId.struct = hwnd(#DispGraf.PicBox)
    toolinfo.lpstrText$.struct = "Flash-O-Rama Picture"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#DispGraf.btnClose)
    toolinfo.lpstrText$.struct = "Close this window"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

    END SUB


''''''''''''''''''''''''''''''''''''''''''''''''''
'Tooltips for the dialog box
'prompting the user to indicate a print range

SUB MakePrTooltips hWin
    TTS.ALWAYSTIP = 1 : TTS.NOPREFIX = 2 : style = _WS_POPUP or TTS.NOPREFIX or TTS.ALWAYSTIP
    calldll #comctl32,"InitCommonControls", re as void
    calldll #user32, "GetWindowLongA", hWin as long, _GWL_HINSTANCE as long, hInstance as long
    calldll #user32, "CreateWindowExA", _WS_EX_TOPMOST as long,"tooltips_class32" as ptr, "" as ptr,_
        style as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long,_
        hWin as long, 0 as long, hInstance as long, "" as ptr, hwndTT as long
    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    calldll #user32, "SetWindowPos", hwndTT as long,_HWND_TOPMOST as long, 0 as long, 0 as long, 0 as long, 0 as long, flags as long, r as long

    'create a struct for the tooltips:
    struct toolinfo, cbSize as long, uFlags as long, hWindow as long, uId as long, x as long, y as long, w as long, h as long, hInst as long, lpstrText$ as ptr
    toolinfo.cbSize.struct = len(toolinfo.struct)
    toolinfo.uFlags.struct = 1 Or 16
    toolinfo.hWindow.struct = hWin

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#PrRange.btnPrint)
    toolinfo.lpstrText$.struct = "Send cards to printer"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#PrRange.btnCancel)
    toolinfo.lpstrText$.struct = "Cancel print cards"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Textbox Tooltip:
    toolinfo.uId.struct = hwnd(#PrRange.txtFirstCard)
    toolinfo.lpstrText$.struct = "Enter first card #"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Textbox Tooltip:
    toolinfo.uId.struct = hwnd(#PrRange.txtToCard)
    toolinfo.lpstrText$.struct = "Enter last card #"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Radiobutton Tooltip:
    toolinfo.uId.struct = hwnd(#PrRange.radioAll)
    toolinfo.lpstrText$.struct = "Print all cards"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Radiobutton Tooltip:
    toolinfo.uId.struct = hwnd(#PrRange.radioRange)
    toolinfo.lpstrText$.struct = "Print selected range"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

    END SUB

'''''''''''''''''''''''''''''''
'Function to strip any and
'all carriage returns that might
'occur at the end of a "multi-line"
'string variable.

Function StripEndingCarriageReturns$(Misc$)

    TempString$ = Misc$

    StringSize = Len(Misc$)
    for i = StringSize to 1 step (-1)
        LastNonCR = 1
        If (MID$(Misc$, i, 1) <> chr$(13)) then
            LastNonCR = i
            TempString$ = Left$(Misc$, LastNonCR)
            i = 1
        end if
    next i

    StripEndingCarriageReturns$ = TempString$

End Function





















