'SubCom2.bas
'Created by Richard Ryles April 2003
'rryles@jeff-davis.k12.ga.us
'http://jdexchange.jeff-davis.k12.ga.us/~rryles/

'Example file for Beginning Game Programming
'for use with the Beginning Game Programming Series - Article 2


'I.  Window Setup
nomainwin
WindowWidth = 500:WindowHeight =320
UpperLeftX=Int((DisplayWidth-WindowWidth)/2)
UpperLeftY=Int((DisplayHeight-WindowHeight)/2)

graphicbox #game.g, 0, 20, 500, 300
statictext #game.st, "You can put a score here",0,0,200,18 'adding the statictext along the top

'*** Open your window, put your title where it says "1st Game Window"
open "2nd Game Window" for window as #game  'here we are opening a basic window
print #game, "trapclose [quit]"

'II.  Load Bitmaps
loadbmp "bg", "subBG.bmp"
loadbmp "sub", "goodsub.bmp"
loadbmp "enemy", "enemysub.bmp"
loadbmp "ship", "ship.bmp"
loadbmp "torpedo", "torpedo.bmp"
loadbmp "mine", "mine.bmp"

'III.  Initialize Variables
sx=20:sy=75
'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "background bg";     'Now we set the bitmap "bg" that we loaded earlier as
                                                  'the background for our graphic box.

    'B.  Add Sprites to the Window - addsprite
print #game.g, "addsprite sub sub"
print #game.g, "addsprite enemy enemy"
print #game.g, "addsprite ship ship"
print #game.g, "addsprite torpedo torpedo"
print #game.g, "addsprite mine mine"

        'C.  Set Initial Location of Sprites - spritexy
    print #game.g, "spritexy sub ";sx;" ";sy
    print #game.g, "spritexy enemy 0 200"
    print #game.g, "spritexy ship 500 45"
    print #game.g, "spritexy torpedo 300 300"
    print #game.g, "spritexy mine 250 45"

        'D.  Set other Sprite Attributes
    print #game.g, "spritemovexy ship -5 0"
    print #game.g, "spritemovexy mine 0 6"
    print #game.g, "spritemovexy torpedo 0 -4"
    print #game.g, "spritemovexy enemy 3 0"

    print #game.g, "spriteorient torpedo rotate180"

    'V.  Initialize Timer, set no less than 56
    timer 100, [TimerBranch]

    'VI.  Initialize Keyboard and Mouse Events
    print #game.g, "setfocus"
    print #game.g, "when characterInput [MoveSub]"
    wait

    'VII.  Timer Branch
    [TimerBranch]
    gosub [TrapShip]
    gosub [TrapMine]
    gosub [TrapTorpedo]
    gosub [TrapEnemy]
    gosub [draw]
    wait

'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
    unloadbmp "bg"
    unloadbmp "sub"
    unloadbmp "enemy"
    unloadbmp "ship"
    unloadbmp "torpedo"
    unloadbmp "mine"
    close #game
    end

    'IX.  Branches called by Mouse and or Keyboard - user entity movement
    [MoveSub]
    k$=Inkey$   'assigning the Inkey$ another name - shortens what we have to type in
    if k$="1" or k$="4" or k$="7" then
        sx=sx-1      'move the sub left
        print #game.g, "spriteorient sub mirror"
    end if

    if k$="9" or k$="6" or k$="3" then
        sx=sx+1     'moves the sub right
        print #game.g, "spriteorient sub normal"
    end if

    if k$="7" or k$="8" or k$="9" then sy=sy-1      'moves the sub up
    if k$="1" or k$="2" or k$="3" then sy=sy+1     'moves the sub down

    if sx<1 then sx=1       'traps the left edge - sub won't move past 1
    if sx>425 then sx=425   'traps the right edge - sub won't move past 425
    if sy<55 then sy=55      'traps the top of the sub - will not move above the water line
    if sy>235 then sy=235   'traps the bottom edge - will not allow the sub to move past 235
    print #game.g, "spritexy sub "; sx; " ";sy 'prints the sub in the new location
    wait

'X.  Subs Called by Timer Branch
[TrapShip]
print #game.g, "spritexy? ship x y"
if x<-50 then print #game.g, "spritexy ship 500 45"
return

    [TrapMine]
    print #game.g, "spritexy? mine mineX mineY"
    if mineY>320 then print #game.g, "spritexy mine 250 45"
    return

    [TrapTorpedo]
    print #game.g, "spritexy? torpedo TX TY"
    if TY<-10 then print #game.g, "spritexy torpedo 300 300"
    return

    [TrapEnemy]
    print #game.g, "spritexy? enemy EX EY"
    if EX>550 then print #game.g, "spritexy enemy 0 200"
    return

[draw]
print #game.g, "drawsprites";
return
