'ShootGallery3.bas
'Example file for Beginning Game Programming
'for use with the Beginning Game Programming Series - Article 2
'Created by Richard Ryles April 2003


'I.  Window Setup
nomainwin
WindowWidth = 300:WindowHeight =340 'increased the height by 20 pixels
UpperLeftX=Int((DisplayWidth-WindowWidth)/2)
UpperLeftY=Int((DisplayHeight-WindowHeight)/2)


graphicbox #game.g, 0, 20, 300, 300  'dropped down 20 pixels from the top
statictext #game.st, "You can put a score here",0,0,200,18 'adding text at the top
                                'each control has to have it's own unique name.  Here the statictext
                                'belongs to window game and it's unique name is "st".

'*** Open your window, put your title where it says "Game Name"
open "LB Shooting Gallery" for window as #game  'once again we are opening a plain window
print #game, "trapclose [quit]"
cursor crosshair

'II.  Load Bitmaps
loadbmp "balloon", "balloon.bmp"      'here we have loaded the bitmap for the sprite we want
loadbmp "bottle", "bottle.bmp"
loadbmp "can", "can.bmp"
loadbmp "squirrel1", "squirl1.bmp"
loadbmp "squirrel2", "squirl2.bmp"
loadbmp "duck", "duck.bmp"
loadbmp "target", "target.bmp"
loadbmp "bullet", "bullet.bmp"
loadbmp "board", "board.bmp"

'III.  Initialize Variables

'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "down;fill black"
print #game.g, "flush"
print #game.g, "getbmp bg 0, 0, 300, 300";
print #game.g, "background bg";

    'B.  Add Sprites to the Window - addsprite
print #game.g, "addsprite balloon balloon";         'now we are adding our sprite.  The first Fred is what we
print #game.g, "addsprite bottle bottle";         'we are going to call our sprite in the program, the second
print #game.g, "addsprite squirrel squirrel1 squirrel2"; 'is the name we gave it when we loaded the bitmap.  These
print #game.g, "addsprite duck duck"; 'can be the name we give it can be the same as the loaded
print #game.g, "addsprite target target"; 'bitmap name or different
print #game.g, "addsprite bullet bullet";
print #game.g, "addsprite can can";
print #game.g, "addsprite board board";

    'C.  Set Initial Location of Sprites - spritexy
print #game.g, "spritexy balloon -10 300";       'This bit of code places Fred at a specific location within the
print #game.g, "spritexy bottle 0 700";       'window.  Play around with these numbers, try to get Fred to
print #game.g, "spritexy can 0 700";       'stand on the trampoline.
print #game.g, "spritexy squirrel 300 205";
print #game.g, "spritexy duck -5 170";
print #game.g, "spritexy target 130 -5";
print #game.g, "spritexy bullet 700 170";
print #game.g, "spritexy board 0 244";

   ' D.  Set other Sprite Attributes
print #game.g, "spritemovexy squirrel -7 0"
print #game.g, "spritemovexy target 0 5"
print #game.g, "spritemovexy duck 6 0"
print #game.g, "spritemovexy balloon 3 -5"
print #game.g, "cyclesprite squirrel 1"
print #game.g, "spriteorient duck mirror"

'V.  Initialize Timer, set no less than 56
timer 100, [TimerBranch]
wait

'VI.  Initialize Keyboard and Mouse Events

'VII.  Timer Branch
[TimerBranch]
gosub [draw]
wait

'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
'*** Unload all of your bitmaps
    unloadbmp "balloon"    'We can't forget to unload all of our bitmaps
    unloadbmp "bottle"  'This releases system resources (memory)
    unloadbmp "can"
    unloadbmp "squirrel1"
    unloadbmp "squirrel2"
    unloadbmp "duck"
    unloadbmp "bullet"
    unloadbmp "target"
    unloadbmp "board"
    close #game
    end

'IX.  Branches called by Mouse and or Keyboard - user entity movement

'X.  Subs Called by Timer Branch
[draw]
print #game.g, "drawsprites";   'redraws background and sprites every 1/10th of a second
return
