'SubCom2.bas
'Created by Richard Ryles April 2003
'rryles@jeff-davis.k12.ga.us
'http://jdexchange.jeff-davis.k12.ga.us/~rryles/

'Example file for Beginning Game Programming
'for use with the Beginning Game Programming Series - Article 2


'I.  Window Setup
nomainwin
WindowWidth = 700:WindowHeight =520
UpperLeftX=Int((DisplayWidth-WindowWidth)/2)
UpperLeftY=Int((DisplayHeight-WindowHeight)/2)

graphicbox #game.g, 0, 20, 700, 500
statictext #game.st, "You can put a score here",0,0,200,18 'adding the statictext along the top

'*** Open your window, put your title where it says "1st Game Window"
open "Sub Command Location Demo" for window as #game  'here we are opening a basic window
print #game, "trapclose [quit]"

'II.  Load Bitmaps
loadbmp "bg", "LocBG.bmp"
loadbmp "sub", "goodsub.bmp"
loadbmp "enemy", "enemysub.bmp"
loadbmp "ship", "ship.bmp"
loadbmp "torpedo", "torpedo.bmp"
loadbmp "mine", "mine.bmp"

'III.  Initialize Variables
sx=120:sy=175

'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "background bg";     'Now we set the bitmap "bg" that we loaded earlier as
                                                  'the background for our graphic box.

    'B.  Add Sprites to the Window - addsprite
print #game.g, "addsprite sub sub"
print #game.g, "addsprite enemy enemy"
print #game.g, "addsprite ship ship"
print #game.g, "addsprite torpedo torpedo"
print #game.g, "addsprite mine mine"

    'C.  Set Initial Location of Sprites - spritexy
print #game.g, "spritexy sub ";sx;" ";sy
print #game.g, "spritexy enemy 600 300"
print #game.g, "spritexy ship 600 145"
print #game.g, "spritexy torpedo 600 400"
print #game.g, "spritexy mine 400 145"

   ' D.  Set other Sprite Attributes
print #game.g, "spritemovexy ship -6 0"
print #game.g, "spritemovexy mine 0 6"

'V.  Initialize Timer, set no less than 56
timer 100, [TimerBranch]

'VI.  Initialize Keyboard and Mouse Events
    print #game.g, "setfocus"
    print #game.g, "when characterInput [MoveSub]"
    wait

'VII.  Timer Branch
[TimerBranch]
gosub [TrapShip]
gosub [TrapMine]
gosub [draw]
wait

'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
    unloadbmp "bg"
    unloadbmp "sub"
    unloadbmp "enemy"
    unloadbmp "ship"
    unloadbmp "torpedo"
    unloadbmp "mine"
    close #game
    end

'IX.  Branches called by Mouse and or Keyboard - user entity movement
    [MoveSub]
    k$=Inkey$   'assigning the Inkey$ another name - shortens what we have to type in
    if k$="1" or k$="4" or k$="7" then sx=sx-1      'move the sub left
    if k$="9" or k$="6" or k$="3" then sx=sx+1     'moves the sub right
    if k$="7" or k$="8" or k$="9" then sy=sy-1      'moves the sub up
    if k$="1" or k$="2" or k$="3" then sy=sy+1     'moves the sub down

    print "sx= ";sx     'prints the value of sx in the main window
    print "sy= ";sy     'prints the value of sy in the main window

    if sx<101 then sx=101       'traps the left edge - sub won't move past 1
    if sx>525 then sx=525   'traps the right edge - sub won't move past 425
    if sy<155 then sy=155      'traps the top of the sub - will not move above the water line
    if sy>335 then sy=335   'traps the bottom edge - will not allow the sub to move past 235
    print #game.g, "spritexy sub "; sx; " ";sy 'prints the sub in the new location
    wait


'X.  Subs Called by Timer Branch
[TrapShip]
print #game.g, "spritexy? ship x y"
if x <10 then print #game.g, "spritexy ship 600 145"

return

[TrapMine]
print #game.g, "spritexy? mine x y"
if y>420 then print #game.g, "spritexy mine 450 145"

return


[draw]
print #game.g, "drawsprites";
return
