''''''''''''''''''''''''''''''''''''
'  The Cloud Tool                  '
'  Copyright June 2003             '
'  Tomas J. Nally                  '
'  Steelweaver52@aol.com           '
''''''''''''''''''''''''''''''''''''
'  Released as open source         '
''''''''''''''''''''''''''''''''''''
'  Made with the following:        '
'                                  '
'  Liberty BASIC                   '
'  by Carl Gundel                  '
'  http://www.libertybasic.com     '
'                                  '
'  Liberty BASIC Workshop          '
'  by Alyce Watson                 '
'  http://alycesrestaurant.com     '
'                                  '
'  Windows Paint                   '
'  by Microsoft                    '
'  http://www.microsoft.com        '
''''''''''''''''''''''''''''''''''''


                True = 1
               False = 0
     CloudInProgress = 0
         NumVertices = 0
                  pi = 4 * ATN(1)
          AmpPercent = 0.40
        CurrentGrSeg = 0


         BillowIndex = 1
      NewBillowIndex = 1
   CurrentLineColor$ = "0 0 0"
       NewLineColor$ = CurrentLineColor$
     CurrentBGColor$ = "255 255 255"


'Dimension Arrays
Dim CloudX(200)   'CloudX() and CloudY() hold the vertices of the
Dim CloudY(200)   'clouds.  CloudX() will always take on the value
                  'of MouseX.  However, CloudY() will take on the
                  'value of (360 - MouseY) so that we can operate
                  'with Y = 0 at the bottom of the graphic box.

Dim xplot(200)    'These are arrays used by the user-defined
Dim yplot(200)    'function called GenArc() which draws an
                  'arc in the graphic box.


[WindowSetup]
    NOMAINWIN
    WindowWidth = 400 : WindowHeight = 520
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Menu        #CTool, "&File" , _ 
                    "Open sky bitmap...", [File.Open.Bitmap], _
                    "Save sky as bitmap...", [File.Save.Bitmap], |, _
                    "Print the sky...", [btnPrintSky.click], |, _
                    "E&xit", [btnQuit.click]

Menu        #CTool, "Sky" , _
                    "Redraw the sky", [Redraw.The.Sky], _
                    "Clear the sky", [btnClearSky.click], |, _ 
                    "Options...", [btnOptions.click]
                    
Menu        #CTool, "Help" , _
                    "Open CTHelp.txt with Notepad...", [Help.CTHelp.txt], |, _
                    "About the Cloud Tool", [Help.About]


graphicbox  #CTool.GrBox, 10, 20, 364, 364
button      #CTool.btnOptions, "Options...",[btnOptions.click],UL, 10, 395, 90, 25
button      #CTool.btnClearSky, "Clear the sky",[btnClearSky.click],UL, 110, 395, 90, 25
button      #CTool.btnPrintSky, "Print sky...",[btnPrintSky.click],UL, 210, 395, 90, 25
button      #CTool.btnQuit, "Quit",[btnQuit.click],UL, 310, 395, 60, 25

'STATICTEXT  #CTool.ST01, "Status: ", 10, 430, 60, 20
'TEXTBOX     #CTool.txtStatus, 80, 430, 290, 25



Open "Cloud Tool" for Window as #CTool

    print #CTool, "trapclose [btnQuit.click]"
    print #CTool.GrBox, "down; fill White; flush"
    print #CTool.GrBox, "setfocus; when mouseMove [MouseChange1]"
    print #CTool.GrBox, "setfocus; when leftButtonUp [LeftButtonUp01]"
    print #CTool.GrBox, "setfocus; when rightButtonUp [RightButtonUp01]"
    print #CTool, "font arial 10"

    print #CTool.GrBox, "Size 1"
    print #CTool.GrBox, "color "; CurrentLineColor$

    Call MakeTooltips HWND(#CTool)
    
    print #CTool.GrBox, "getbmp SkyImage01 0 0 362 362"      'These two lines merely make sure
    print #CTool.GrBox, "getbmp OpenSkyBmpName 0 0 362 362"  'that these two image names exist
                                                             'in order to prevent an error when
                                                             'an UNLOADBMP command is given at
                                                             'the close of the program.

[loop]
    Wait

[btnQuit.click]
    close #CTool 
    UNLOADBMP "SkyImage01"
    UNLOADBMP "OpenSkyBmpName"
    END
    
    
    Wait

[File.Open.Bitmap]

    Gosub [Capture.Sky.Graphic]
    
    Filedialog "Open Sky Bitmap File", "*.skybmp", OpenSkyBmpName$
    
    If (OpenSkyBmpName$ = "") then wait
    
    LOADBMP "OpenSkyBmpName", OpenSkyBmpName$
    print #CTool.GrBox, "drawbmp OpenSkyBmpName 0 0"
    Gosub [Capture.Sky.Graphic]
    
    Wait

[File.Save.Bitmap]
    
    gosub [Capture.Sky.Graphic]
    
    Filedialog "Save Sky as Bitmap", "*.skybmp", SkyBitMapName$
    
    If (SkyBitMapName$ = "") then wait
    
    BmpExt$ = lower$(right$(SkyBitMapName$, 7))
    If (BmpExt$ <> ".skybmp") then
        SkyBitMapName$ = SkyBitMapName$ + ".skybmp"
    end if 

    bmpsave "SkyImage01", SkyBitMapName$

    Wait

[Help.About]

    Notice "About the Cloud Tool" + chr$(13) + _
           "Made with Liberty BASIC               " + Chr$(13) + _
           "http://www.libertybasic.com           " + chr$(13) + _
           "                                      " + chr$(13) + _
           "Made with Liberty BASIC Workshop      " + chr$(13) + _
           "http://alycesrestaurant.com           " + chr$(13) + _
           "                                      " + chr$(13) + _
           "Copyright Tomas J. Nally June 2003    " + chr$(13) + _
           "Steelweaver52@aol.com                 " + chr$(13) + _
           "                                      " + chr$(13) + _
           "Released as open source.              "

    Wait
    
[Help.CTHelp.txt]

    Run "Notepad.exe CTHelp.txt"

    Wait

[RightButtonUp01]

    CloudInProgress = 0
    NumVertices = 0
    
    'print #CTool.GrBox, "flush"
    gosub [Capture.Sky.Graphic]
        

    Wait

[LeftButtonUp01]

    'A left button event will always mean that a
    'cloud vertex is being set.  It may be the first
    'vertex of a cloud or a vertex subsequent to the
    'first one.  In any event, set a flag indicating
    'that cloud drawing is in progress.

    If (CloudInProgress = 0) then
        CloudInProgress = 1
    end if

    'Every left click event indicates a vertex of the
    'cloud.  Capture these coordinates, and store them
    'in arrays.

    NewCloudPointX = MouseX
    NewCloudPointY = (360 - MouseY)
    CloudX(NumVertices + 1) = NewCloudPointX
    CloudY(NumVertices + 1) = NewCloudPointY

    NumVertices = NumVertices + 1

    LastFixedCloudVertexX = NewCloudPointX
    LastFixedCloudVertexY = NewCloudPointY

    'Also, if this vertex happens to be the
    'very first vertex of the new cloud, then
    'identify this as the first vertex.

    'Additionally, set OldXhairX and OldXhairY
    'to a nearby point.  This is an attempt to
    'prevent cloud segments from being drawn off
    'of the screen.

    If ( NumVertices = 1 ) then
        FirstCloudVertexX = NewCloudPointX
        FirstCloudVertexY = NewCloudPointY
        OldXhairX = FirstCloudVertexX + 1
        OldXhairY = FirstCloudVertexY + 1
    end if


    Wait

[MouseChange1]

    'This initial routine makes
    'sure that the proper cursor is being set while
    'the mouse pointer is inside of the graphic box.

    If ((MouseX >= 5) and (MouseX <= 355) and (MouseY >= 5) and (MouseY <= 355)) then
        cursor CROSSHAIR
    else
        cursor ARROW
    End if

    if (CloudInProgress = 1) then
        'First, capture the coordinates of the Mouse.
        'And, convert the Y coordinate into a value
        'consistent with y=0 being at the bottom
        'of the graphic box.

        NewXhairX = MouseX
        NewXhairY = (360 - MouseY)

        'Next, redraw the very last arc  drawn using
        'the XOR drawing rule.  This will have the effect
        'of erasing the arc prior to drawing the new arc.

        print #CTool.GrBox, "rule XOR"

        'The data sent to the the cloud segment drawing
        'routine include the x and y coordinates of the
        'two endpoints of the arc, and another piece of
        'data which I call the "amplitude percentage",
        'or AmpPercent.

        TempVar = DrawCloudSegment(LastFixedCloudVertexX, _
                                   LastFixedCloudVertexY, _
                                   OldXhairX, _
                                   OldXhairY, _
                                   AmpPercent)

        'The previously drawn cloud segment should now
        'be erased.

        'Next, erase the final cloud segment which is drawn
        'during each mouse movement in order to close
        'the loop on the cloud.

        TempVar = DrawCloudSegment(OldXhairX, _
                                   OldXhairY, _
                                   FirstCloudVertexX, _
                                   FirstCloudVertexY, _
                                   AmpPercent)

        'The two cloud segments just erased
        'will now be replaced with cloud segments
        'which are updated to reflect the current position
        'of the Xhair.

        'The first cloud segment will be
        'drawn between the LastFixedCloudVertex and the
        'current Xhair position.

        TempVar = DrawCloudSegment(LastFixedCloudVertexX, _
                                   LastFixedCloudVertexY, _
                                   NewXhairX, _
                                   NewXhairY, _
                                   AmpPercent)

        'The next cloud segment drawn will be drawn between
        'the current location of the Xhair and the very
        'first cloud vertex.

        TempVar = DrawCloudSegment(NewXhairX, _
                                   NewXhairY, _
                                   FirstCloudVertexX, _
                                   FirstCloudVertexY, _
                                   AmpPercent)

        'Now that the cloud segments have been updated,
        'it's time to reassign OldXhairX and OldXhairY
        'the current values of the Xhair, so that the
        'process can be repeated as the Xhair continues
        'to move within the graphicbox.

        OldXhairX = NewXhairX
        OldXhairY = NewXhairY

    end if

    Wait

[Redraw.The.Sky]

    print #CTool.GrBox, "drawbmp SkyImage01 0 0"
    gosub [Capture.Sky.Graphic]

    Wait


[btnClearSky.click]
    'place code here

    print #CTool.GrBox, "Fill "; CurrentBGColor$
    Wait

[btnPrintSky.click]

    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Printing operation crafted by Alyce Watson.  Hey, thanks!
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    print #CTool.GrBox, "getbmp SkyImage01 0 0 362 362"

    RunFile$=DefaultDir$+"\GrImage.bmp"
    bmpsave "SkyImage01", RunFile$
    lpOperation$ = "print"
    lpParameters$ = ""
    lpDirectory$ = ""
    nShowCmd = _SW_HIDE

    calldll #shell32, "ShellExecuteA",_
        hW as long,_           'window handle
        lpOperation$ as ptr,_  'open or print
        RunFile$ as ptr,_      'name of file on disk
        lpParameters$ as ptr,_ 'command line parameters
        lpDirectory$ as ptr,_  'default directory, can be null
        nShowCmd as ulong,_    'show window flag
        result as long         'result>32=success

    'if ShellExecuteA didn't work then print with mspaint.exe
    if result <= 32 then
        RunFile$=GetShortPathName$(RunFile$)
        run "mspaint.exe " + RunFile$ + " /p", HIDE
    end if

    notice "CloudTool Print Image" + Chr$(13) + _
           "The image has been sent to the printer      "

    Wait

    Wait

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[btnOptions.click]

    NOMAINWIN
    WindowWidth = 380 : WindowHeight = 240
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

statictext  #Options.STBillAmp, "Billow Amplitude:", 20, 20, 110, 20

radiobutton #Options.RadioLarge, " ",[RadioLarge.Set],[loop], 25, 55, 30, 25
radiobutton #Options.RadioMedium, " ",[RadioMedium.Set],[loop], 25, 100, 30, 25
radiobutton #Options.RadioSmall, " ",[RadioSmall.Set],[Options.Loop], 25, 145, 30, 25

bmpbutton   #Options.bmpBillLarge, "BillLarge.bmp",[bmpBillLarge.click],UL, 55, 45
bmpbutton   #Options.bmpBillMedium, "BillMedium.bmp",[bmpBillMedium.click],UL, 55, 90
bmpbutton   #Options.bmpBillSmall, "BillSmall.bmp",[bmpBillSmall.click],UL, 55, 135

statictext  #Options.STLineColor, "Line Color:", 180, 20, 65, 20
graphicbox  #Options.GBoxLC, 180, 45, 45, 25
button      #Options.btnChLC, "Change...",[btnChLC.click],UL, 230, 45, 80, 25


button      #Options.btnCancel, "Cancel",[btnCancel.click],UL, 185, 155, 80, 25
button      #Options.btnOkay,   "Okay",  [btnOkay.click],  UL, 270, 155, 80, 25

Open "Cloud Tool Options" for Dialog as #Options

    print #Options, "trapclose [btnOkay.click]"
    print #Options.GBoxLC, "down; fill Black; flush"
    print #Options, "font arial 10"
    
    cursor ARROW
    
    Gosub [Initialize.Options.Controls]

[Options.Loop]
    Wait


[Initialize.Options.Controls]

    If (BillowIndex = 1) then print #Options.RadioLarge, "set"
    If (BillowIndex = 2) then print #Options.RadioMedium, "set"
    If (BillowIndex = 3) then print #Options.RadioSmall, "set"
    NewBillowIndex = BillowIndex
    
    
    print #Options.GBoxLC, "Fill "; CurrentLineColor$
    NewLineColor$ = CurrentLineColor$

    Return


[btnChLC.click]
    
    COLORDIALOG  CurrentLineColor$, NewLineColor$
    
    If (NewLineColor$ = "") then wait

    print #Options.GBoxLC, "Fill "; NewLineColor$
    
    
    Wait


[btnOkay.click]

    close #Options  

    BillowIndex    = NewBillowIndex
    
    If (BillowIndex = 1) then
        AmpPercent = 0.40
    end if
    
    If (BillowIndex = 2) then
        AmpPercent = 0.30
    end if

    If (BillowIndex = 3) then
        AmpPercent = 0.20
    end if
    
    If (NewLineColor$ <> "") then
        CurrentLineColor$ = NewLineColor$
    End if
    
    print #CTool.GrBox, "color "; CurrentLineColor$
    
    Wait

[btnCancel.click]
    close #Options 
    Wait

[bmpBillLarge.click]
    
    print #Options.RadioLarge, "set"
    goto [RadioLarge.Set]
    Wait

[bmpBillMedium.click]
    
    print #Options.RadioMedium, "set"
    goto [RadioMedium.Set]
    Wait

[bmpBillSmall.click]
    
    print #Options.RadioSmall, "set"
    goto [RadioSmall.Set]
    Wait

[RadioLarge.Set]
    NewBillowIndex = 1
    Wait

[RadioMedium.Set]
    NewBillowIndex = 2
    Wait

[RadioSmall.Set]
    NewBillowIndex = 3
    Wait
    
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Subroutine for capturing the contents of the
'graphicbox, and drawing it again.
[Capture.Sky.Graphic]

    print #CTool.GrBox, "getbmp SkyImage01 0 0 362 362"
    print #CTool.GrBox, "drawbmp SkyImage01 0 0"
    print #CTool.GrBox, "flush"

    Return



''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

function ATAN2(x, y)
    pi = 3.14159265
    Result$ = "Undetermined"
    If (x = 0) and (y > 0) then
        ATAN2 = pi / 2
        Result$ = "Determined"
    end if
    if (x = 0) and (y < 0) then
        ATAN2 = 3 * pi / 2
        Result$ = "Determined"
    end if
    if (x > 0) and (y = 0) then
        ATAN2 = 0
        Result$ = "Determined"
    end if
    if (x < 0) and (y = 0) then
        ATAN2 = pi
        Result$ = "Determined"
    end if
    if (x = 0) and (y = 0) then
        ATAN2 = 0
        Result$ = "Determined"
    end if


    If Result$ = "Determined" then [End.of.function]


    BaseAngle = ATN(abs(y)/abs(x))
    If (x > 0) and (y > 0) then ATAN2 = BaseAngle
    If (x < 0) and (y > 0) then ATAN2 = pi - BaseAngle
    If (x < 0) and (y < 0) then ATAN2 = pi + BaseAngle
    If (x > 0) and (y < 0) then ATAN2 = 2*pi - BaseAngle

    [End.of.function]

End Function
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Function DrawCloudSegment(x1, y1, x2, y2, AmpPercent)
    pi = 4 * ATN(1)
    phi1 = ATAN2((x2 - x1), (y2 - y1))
    phi2 = phi1 - (pi/2)

    'If (phi2 < 0) then
    '    phi2 = (2 * pi) + phi2
    'end if

    phi3 = phi1 + (pi/2)



    'If (phi3 > (2 * pi)) then
    '    phi3 = phi3 - (2 * pi)
    'end if

    xa = (x1 + x2)/2
    ya = (y1 + y2)/2

    Delta1to2 = SQR((x2 - x1)^2 + (y2 - y1)^2)
    HalfDelta = (Delta1to2 / 2)
    AmpDist = AmpPercent * Delta1to2
    If (AmpDist = 0) then
        AmpDist = 0.0001
    end if


    r1 = (AmpDist^2 + HalfDelta^2) / (2 * AmpDist)
    Bdist = r1 - AmpDist

    xb = xa + AmpDist * cos(phi2)
    yb = ya + AmpDist * sin(phi2)

    xc = xa + Bdist * cos(phi3)
    yc = ya + Bdist * sin(phi3)

    phi4 = ATAN2((x1 - xc),(y1 - yc))
    phi5 = ATAN2((x2 - xc),(y2 - yc))

    If (phi5 <= phi4) then
        phi5 = phi5 + (2 * pi)
    end if

    DummyVariable = GenArc(xc,(360 - yc),r1,(phi4*57.296),(phi5*57.296),7)


End Function



''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Function GenArc(Xc, Yc, R, StartD, EndD, NLS)
    pi = 4*atn(1)
    StartR = (StartD/360)*(2*pi)
    EndR   = (EndD/360)*(2*pi)
    ArcElement = (EndR - StartR) / NLS

    xplot(0) = Xc + R * cos(StartR)
    yplot(0) = Yc - R * sin(StartR)

    For i = 1 to NLS
        xplot(i) = Xc + R * cos(StartR + i*ArcElement)
        yplot(i) = Yc - R * sin(StartR + i*ArcElement)
    Next i

    'Plot the Arc

    For i = 1 to NLS
        ArcString$ = Str$(xplot(i-1)) + " " + _
                     Str$(yplot(i-1)) + " " + _
                     Str$(xplot(i)) + " " + _
                     Str$(yplot(i))
        print #CTool.GrBox, "line " + ArcString$
    next i

End Function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Function GetShortPathName$() by alyce Watson
'This function ensures that the short name
'of the file to be printed is used in the printing
'operation so as to avoid any problems associated
'with parsing a filename containing empty spaces.
'
Function GetShortPathName$(lPath$)
     sPath$=Space$(256)    'create string buffer
     lenPath=Len(sPath$)   'length of buffer
     CallDLL #kernel32, "GetShortPathNameA",_
         lPath$ As ptr,_    'long pathname
         sPath$ As ptr,_    'buffer to receive short path name
         lenPath As long,_  'length of buffer
         r As long          'length of returned string
     GetShortPathName$=Left$(sPath$,r)
     End Function
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'This cool stuff is automatically generated
'by Liberty BASIC Workshop.
'Thanks again, Alyce!


SUB MakeTooltips hWin
    TTS.ALWAYSTIP = 1 : TTS.NOPREFIX = 2 : style = _WS_POPUP or TTS.NOPREFIX or TTS.ALWAYSTIP
    calldll #comctl32,"InitCommonControls", re as void
    calldll #user32, "GetWindowLongA", hWin as long, _GWL_HINSTANCE as long, hInstance as long
    calldll #user32, "CreateWindowExA", _WS_EX_TOPMOST as long,"tooltips_class32" as ptr, "" as ptr,_
        style as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long, _CW_USEDEFAULT as long,_
        hWin as long, 0 as long, hInstance as long, "" as ptr, hwndTT as long
    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    calldll #user32, "SetWindowPos", hwndTT as long,_HWND_TOPMOST as long, 0 as long, 0 as long, 0 as long, 0 as long, flags as long, r as long

    'create a struct for the tooltips:
    struct toolinfo, cbSize as long, uFlags as long, hWindow as long, uId as long, x as long, y as long, w as long, h as long, hInst as long, lpstrText$ as ptr
    toolinfo.cbSize.struct = len(toolinfo.struct)
    toolinfo.uFlags.struct = 1 Or 16
    toolinfo.hWindow.struct = hWin

'Graphicbox Tooltip:
    toolinfo.hWindow.struct = hWin
    toolinfo.uId.struct = hwnd(#CTool.GrBox)
    toolinfo.lpstrText$.struct = "The Sky!"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#CTool.btnOptions)
    toolinfo.lpstrText$.struct = "Cloud drawing options"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#CTool.btnClearSky)
    toolinfo.lpstrText$.struct = "Erase the clouds"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#CTool.btnPrintSky)
    toolinfo.lpstrText$.struct = "Print the sky"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

'Button Tooltip:
    toolinfo.uId.struct = hwnd(#CTool.btnQuit)
    toolinfo.lpstrText$.struct = "Quit Cloud Tool"  '*** CHANGE TOOLTIP TEXT HERE!
    calldll #user32, "SendMessageA", hwndTT as long, 1028 as long, 0 as long, toolinfo as struct, re as long

    END SUB


















