'This program is an example contributed by Liberty BASIC community
'member Alyce Watson,with modifications of a Kalidoscope added by Midi Boink!
'piano4.bas - a cool piano that uses Windows' built-in MIDI synthesizer
'plays one note at a time on channel 1 (channel 1 = 144)
'and auto switchs to one of two harmony modes added by Midi Boink with notes played on channel 1
'(144) and channel 2 (145)
'allows selection from 128 MIDI voices
'click lower right crystal to exit program
'moving mouse around in screen area will cause kalidoscope
'drawing with music muted
'You may also play with computer keyboard keys, (lower case only) added by Midi Boink
'
'run this code from LB folder,
'The following bmp files should be in LB bmp folder
'piano2 bmp
'pianoT1 bmp
'pianoT7 bmp
'pianoStrip bmp
'pexit5 bmp

        Dim kt(128) 'lower case key to midi note lookup table

    'lower keyboard

    kt(122)=48 'C
    kt(115)=49 'C#
    kt(120)=50 'D
    kt(100)=51 'D#
    kt(99)=52  'E
    kt(118)=53 'F
    kt(103)=54 'F#
    kt(98)=55  'G
    kt(104)=56 'G#
    kt(110)=57 'A
    kt(106)=58 'A#
    kt(109)=59 'B
    kt(44)=60  'C
    kt(108)=61 'C#
    kt(46)=62  'D
    kt(59)=63  'D#
    kt(47)=64   'E

    'Upper keyboard

    kt(113)=65   'F
    kt(50)=66    'F#
    kt(119)=67   'G
    kt(51)=68   'G#
    kt(101)=69   'A
    kt(52)=70   'A#
    kt(114)=71   'B
    kt(116)=72   'C
    kt(54)=73  'C#
    kt(121)=74   'D
    kt(55)=75   'D#
    kt(117)=76   'E
    kt(105)=77   'F
    kt(57)=78   'F#
    kt(111)=79   'G
    kt(48)=80   'G#
    kt(112)=81   'A
    kt(45)=82  'A#
    kt(91)=83   'B
    kt(93)=84   'C

    dim th(128)
    th(48)=45
    th(49)=46
    th(50)=47
    th(51)=48
    th(52)=48
    th(53)=50
    th(54)=51
    th(55)=52
    th(56)=53
    th(57)=53
    th(58)=54
    th(59)=55
    th(60)=57
    th(61)=58
    th(62)=59
    th(63)=60
    th(64)=60
    th(65)=62
    th(66)=63
    th(67)=64
    th(68)=65
    th(69)=65
    th(70)=66
    th(71)=67
    th(72)=69
    th(73)=70
    th(74)=71
    th(75)=72
    th(76)=72
    th(77)=74
    th(78)=75
    th(79)=76
    th(80)=77
    th(81)=77
    th(82)=78
    th(83)=79
    th(84)=81

    'Sixth lookup table
    dim si(128)
    si(48)=40
    si(49)=40
    si(50)=41
    si(51)=42
    si(52)=43
    si(53)=45
    si(54)=46
    si(55)=47
    si(56)=47
    si(57)=48
    si(58)=49
    si(59)=50
    si(60)=52
    si(61)=52
    si(62)=53
    si(63)=54
    si(64)=55
    si(65)=57
    si(66)=58
    si(67)=59
    si(68)=59
    si(69)=60
    si(70)=61
    si(71)=62
    si(72)=64
    si(73)=64
    si(74)=65
    si(75)=66
    si(76)=67
    si(77)=69
    si(78)=70
    si(79)=71
    si(80)=71
    si(81)=72
    si(82)=73
    si(83)=74
    si(84)=76


    Dim ins$(128)   'names of instruments

    'read instrument name data into array for combobox
    For vc = 0 to 127
        Read data$
        ins$(vc)=data$
    Next vc
    'Beethoven varibles
      dim scale(22)
    scale(1)=48 'C
    scale(2)=50 'D
    scale(3)=52 'E
    scale(4)=53 'F
    scale(5)=55 'G
    scale(6)=57 'A
    scale(7)=59 'B

    scale(8)=60 'C
    scale(9)=62 'D
    scale(10)=64 'E
    scale(11)=65 'F
    scale(12)=67 'G
    scale(13)=69 'A
    scale(14)=71 'B
    scale(15)=72 'C
    scale(16)=74 'D
    scale(17)=76 'E
    scale(18)=77 'F
    scale(19)=79 'G
    scale(20)=81 'A
    scale(21)=83 'B
    scale(22)=84 'C

    dim ryt(10)
    ryt(1)=96 'quarter
    ryt(2)=96
    ryt(3)=48 'eigth note
    ryt(4)=24 'sixteenth note
    ryt(5)=144 'dotted quarter
    ryt(6)=72 'dotted eighth

    Dim vo(22)
    vo(1)=60
    vo(2)=82
    vo(3)=88
    vo(4)=95
    vo(5)=97
    vo(6)=98
    vo(7)=100
    vo(8)=102
    vo(9)=108
    vo(10)=112
    vo(11)=9
    vo(12)=54
    vo(13)=11
    vo(14)=14
    vo(15)=19
    vo(16)=45
    vo(17)=46
    vo(18)=49
    vo(19)=50
    vo(20)=51




       dim song(100)
     dim rythem(100)


NoMainWin

[start]

    note=0                  'will contain value for note
    BLACK=0                 'color value for black keys
    WHITE=hexdec("FFFFFF")  'color value for white keys
    a=600:b=300:c=340:d=300

    WindowWidth=780:WindowHeight=600
    UpperLeftX=20:UpperLeftY=20

    'combobox index is 1-based, instrument voices are 0-based
    instrum=1 'select first instrument voice
    voice=0   'voice 0 = instrum 1

    msg$="To play the piano, click the keys with your mouse " _
    +"or type on keyboard. Select a voice from the combobox."


[windowSetup]
    bmpbutton #p.default, "pexit5.bmp",[quit],UL,670,515
    bmpbutton #p.default, "pexit5.bmp",[beethoven],UL,630,515
    'Statictext #p, "Select Instrument",65,300,330,20
    Combobox #p.ins, ins$(,[instrument],75, 520, 135,400
    Combobox #p.ins2, ins$(,[instrument2],210, 520, 135,400
    Graphicbox #p.g, 65, 0,640,602


Open "TAPISTRY" For Window_nf As #p

    loadbmp "tile1","PianoT1.bmp"
     #p.g "down;drawbmp tile1 550 0;flush"
     #p.g "down;drawbmp tile1 0 0;flush"
     #p.g "down;drawbmp tile1 0 202;flush"
     #p.g "down;drawbmp tile1 550 202;flush"
     loadbmp "tile2","pianoT7.bmp"
     #p.g "down;drawbmp tile2 0 101;flush"
     #p.g "down;drawbmp tile2 550 101;flush"
     #p.g "down;drawbmp tile2 550 303;flush"
     #p.g "down;drawbmp tile2 0 303;flush"
     '#p.g "down;drawbmp tile1 550 403;flush"
     '#p.g "down;drawbmp tile1 0 403;flush"
    LoadBmp "piano","piano2.bmp"

    #p.g   "down;drawbmp piano 0 380;flush"
    loadbmp "strip","PianoStrip1.bmp"
    #p.g "down;drawbmp strip 0 355;flush"
    #p.g "down;drawbmp strip 0 480;flush"
    #p.g   "setfocus; when leftButtonDown [newNote]"
    #p.g   "when leftButtonUp [endNote]"
    #p.g   "when leftButtonMove [moveNote]"
    #p.g   "when characterInput [keyNote]"
    #p.ins "select Grand Piano"
    #p.ins2 "select Grand Piano"
    #p     "trapclose [quit]"
    #p.g, "down"
    #p.g, "size 3"
    w=640
    h=300
      a=320
      b=150
      c=a:d=b


    Wnd=hWnd(#p.g)  'handle of graphicbox
    'get device context for graphicbox
    CallDLL #user32, "GetDC",_
        Wnd As long,  hDC As long

    'open midi device and obtain handle
    'midi functions return 0 if successful
    struct m, a$ As ptr
    CallDLL #winmm, "midiOutOpen",_
        m As struct,-1 As long,0 As long,_
        0 As long,0 As long,ret As long

    hMidiOut=m.a$.struct    'handle to midi device
    Wait

[quit]'stop note, close midi device, DLLs, window
    timer 0
    UnloadBmp "piano"
    UnloadBmp "tile1"
    UnloadBmp "tile2"
    UnloadBmp "strip"
    gosub [stopPlay]   'stop all output
    CallDLL #winmm, "midiOutClose", hMidiOut As ulong,_
        ret As ulong

    CallDLL#user32,"ReleaseDC",_
        Wnd As long,hDC As long,result As long
    Close #p
    End


[instrument]'user selected an instrument1 voice
    #p.ins "selectionindex? instrum"
    #p.g   "setfocus"
    gosub [doChange]   'change voice
    Wait

[instrument2]'user selected an instrument2 voice
    #p.ins2 "selectionindex? instrum"
    #p.g   "setfocus"
    gosub [doChange2]   'change voice
    Wait

[newNote] 'mouse clicked to start new note
    gosub [stopNote]   'stop previous note
    gosub [stopNote2]
    gosub [findNote]   'set new note value
    note=mnote         'set note to match piano key clicked by mouse
    if note=0 then goto [branch3]
    if harm=1 then note2=th(note)
    if harm=2 then note2=si(note)
    if harm=0 then note2=note
    gosub [playNewNote]'play new note
    gosub [playNewNote2]
[branch3]    Wait


[moveNote]'mouse moved while button was down
          'determine if it has moved to new note
          'and if it has, stop old note and sound new note
    gosub [findNote]         'set note value
    if mnote=note then wait  'mouse is on same key, do nothing
    gosub [stopNote]
    gosub [stopNote2]         'stop previous note
    note=mnote               'set note to match piano key clicked by mouse
    if note=0 then goto [branch2]
    gosub [playNewNote]      'play new note
    if harm=1 then note2=th(note)
    if harm=2 then note2=si(note)
    if harm=0 then note2=note
    gosub [playNewNote2]
 [branch2]   Wait


[keyNote]   'a keyboard key was pressed
    gosub [stopNote]      'stop previous note
    gosub [stopNote2]
    gosub [findKeyNote]   'set new note value
    if note=0 then goto [branch1]
    gosub [playNewNote]   'play new note
    gosub [playNewNote2]
[branch1]  timer 650, [cutOff]  'to stop notes played by typing on keyboard
    wait


[cutOff]'stop note played by typing on keyboard
    gosub [stopNote]
    gosub [stopNote2]
    Harm=int(rnd(1)*3)
    wait


[endNote]'stop note when mouse button is released
    gosub [stopNote]
    gosub [stopNote2]
    harm=int(rnd(1)*3)
    Wait


'GOSUBS:
[findKeyNote]'determine a note based on keyboard key pressed
    k = asc(Inkey$)
    note=kt(k)
    if k=32 then gosub [restart]:goto [start]
    gosub [kalido]
    gosub [kalido]
    gosub [kalido]
    if Harm=0 then note2=note:return
    if Harm=1 then note2=th(note):return
    if Harm=2 then note2=si(note):return


    'select case
   ' case  (k>96) and (k<123)
    '    note=k-50   'lowercase letters
    'case (k>64) and (k<91)
    '    note=k-18   'uppercase letters
    'case else
    '    note=48     'non-alpha key
    'end select
    RETURN


[playNewNote]'play new note:
    gosub [stopNote]
    event=144   'event 144 = play on channel 1
    low=(note*256)+event
    velocity=127
    hi=velocity*256*256
    dwMsg=low+hi
    CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
        dwMsg As ulong, ret As ulong
    RETURN

[playNewNote2]
    gosub [stopNote2]

    event=145   'event 145 = play on channel 2
    low=(note2*256)+event
    velocity=127
    hi=velocity*256*256
    dwMsg=low+hi
    CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
        dwMsg As ulong, ret As ulong

    RETURN



[stopNote]'stop note from playing
    timer 0
    event=144    'event 144 = play on channel 1
    low=(note*256)+event
    hiZero=0     'stop note from sounding by setting velocity to 0
    dwMsg=low+hiZero
    CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
        dwMsg As ulong, ret As ulong


        RETURN

[stopNote2]
       event=145   'event 145 = play on channel 2
    low=(note2*256)+event
    hiZero=0     'stop note from sounding by setting velocity to 0
    dwMsg=low+hiZero
    CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
        dwMsg As ulong, ret As ulong
     #p.g "setfocus; when characterInput [keyNote]"
   RETURN


[stopPlay]'stop all notes from playing
    event=128    'event 128 = stop play
    low=(note*256)+event
    dwMsg=low+hi
    CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
        dwMsg As ulong, ret As ulong
    timer 0
    RETURN


[doChange]'signal a voice change:
    event=192  'event 192 = voice change on channel 1
    voice=instrum-1
    velocity=255
    low=(voice*256)+event
    hi=velocity*256*256
    dwMsg=low+hi
    CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
        dwMsg As ulong, ret As ulong
    RETURN

[doChange2]'signal a voice change:
    event=193 'event 192 = voice change on channel 2
    voice=instrum-1
    velocity=255
    low=(voice*256)+event
    hi=velocity*256*256
    dwMsg=low+hi
    CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
        dwMsg As ulong, ret As ulong
    RETURN

[findNote]'determine piano key pressed by mouse to set note
          'note value will be in mnote
    MX=MouseX:MY=MouseY

    CallDLL #gdi32, "GetPixel",hDC As long,_
        MX As long,MY As long,keyColor As long
    if MY<=360 then gosub [kalido]:mnote=0:return 'dont play note, just draw
    If keyColor=BLACK Then  'black keys
        If MX<=54  Then mnote = 49 :gosub[kalido]: RETURN  'c#
        If MX<=97  Then mnote = 51 :gosub[kalido]:  RETURN  'd#
        If MX<=183 Then mnote = 54 :gosub[kalido]:  RETURN  'f#
        If MX<=226 Then mnote = 56 :gosub[kalido]:  RETURN  'g#
        If MX<=266 Then mnote = 58 :gosub[kalido]:  RETURN  'a#
        If MX<=354 Then mnote = 61 :gosub[kalido]:  RETURN  'c#
        If MX<=397 Then mnote = 63 :gosub[kalido]:  RETURN  'd#
        If MX<=483 Then mnote = 66 :gosub[kalido]:  RETURN  'f#
        If MX<=527 Then mnote = 68 :gosub[kalido]:  RETURN  'g#
        If MX<=566 Then mnote = 70 :gosub[kalido]:  RETURN  'a#
        return
    end if
    if keyColor=WHITE then  'white keys
        If MX<=43  Then mnote = 48 :gosub[kalido]:  RETURN  'c
        If MX<=86  Then mnote = 50 :gosub[kalido]:  RETURN  'd
        If MX<=129 Then mnote = 52 :gosub[kalido]:  RETURN  'e
        If MX<=172 Then mnote = 53 :gosub[kalido]:  RETURN  'f
        If MX<=215 Then mnote = 55 :gosub[kalido]:  RETURN  'g
        If MX<=258 Then mnote = 57 :gosub[kalido]:  RETURN  'a
        If MX<=300 Then mnote = 59 :gosub[kalido]:  RETURN  'b
        If MX<=343 Then mnote = 60 :gosub[kalido]:  RETURN  'c
        If MX<=386 Then mnote = 62 :gosub[kalido]:  RETURN  'd
        If MX<=429 Then mnote = 64 :gosub[kalido]:  RETURN  'e
        If MX<=472 Then mnote = 65 :gosub[kalido]:  RETURN  'f
        If MX<=515 Then mnote = 67 :gosub[kalido]:  RETURN  'g
        If MX<=558 Then mnote = 69 :gosub[kalido]:  RETURN  'a
        If MX<=600 Then mnote = 71 :gosub[kalido]:  RETURN  'b
        If MX<=643 Then mnote = 72 :gosub[kalido]:  RETURN  'c
        return
   End If
   RETURN


'list of 128 voices, in order of their MIDI indexes
Data "Grand Piano","Bright Grand","Electric Grand","Honky Tonk"
Data "Rhodes","Chorus Piano","Harpsichord","Clavinet"
Data "Celesta","Glockenspiel","Music Box","Vibraphone"
Data "Marimba","Xylophone","Tubular Bells","Dulcimer"
Data "Hammond Organ","Percussion Organ","Rock Organ"
Data "Church Organ","Reed Organ","Accordian","Harmonica"
Data "Tango Accordian","Accoustic Nylon Guitar"
Data "Accoustic Steel Guitar","Electric Jazz Guitar"
Data "Electric Clean Guitar","Electric Mute Guitar"
Data "Overdrive Guitar","Distorted Guitar","Guitar Harmonic"
Data "Accoustic Bass","Electric Bass Finger","Electric Bass Pick"
Data "Fretless Bass","Slap Bass One","Slap Bass Two"
Data "Synth Bass One","Synth Bass Two","Violin","Viola","Cello"
Data "Contrabass","Tremolo Strings","Pizzicato Strings"
Data "Orchestra Harp","Timpani","String Ensemble One"
Data "String Ensemble Two","Synth Strings One","Synth Strings Two"
Data "Choir Ahhs","Voice Oohs","Synth Voice","Orchestra Hit"
Data "Trumpet","Trombone","Tuba","Mute Trumpet","French Horn"
Data "Brass Section","Synth Brass One","Synth Brass Two"
Data "Soprano Sax","Alto Sax","Tenor Sax","Bari Sax","Oboe"
Data "English Horn","Bassoon","Clarinet","Piccolo","Flute"
Data "Recorder","Pan Flute","Bottle Blow","Shakuhachi","Whistle"
Data "Ocarina","Square Wave","Sawtooth","Caliope","Chiff Lead"
Data "Charang","Solo Synth VX","Brite Saw","Brass and Lead"
Data "Fantasia Pad","Warm Pad","Poly Synth Pad","Space Vox Pad"
Data "Bowd Glas Pad","Metal Pad","Halo Pad","Sweep Pad"
Data "Ice Rain","Sound Track","Crystal","Atmosphere","Brightness"
Data "Goblin","Echo Drops","Star Theme","Sitar","Banjo","Shamisen"
Data "Koto","Kalimba","Bagpipe","Fiddle","Shanai"
Data "Tinkle Bell","Agogo","Steel Drums","Wood Block","Taiko Drum"
Data "Melodic Tom","Synth Drum","Rev Cymbal"
Data "Guitar Fret Noise","Breath Noise","Sea Shore","Bird Tweet"
Data "Phone Ring","Helicopter","Applause","Gunshot"

[kalido]

            c=c+int(rnd(1)*16)-int(rnd(1)*16)
            if c<0 then c=0
            if c>340 then c=340

            d=d+int(rnd(1)*16)-int(rnd(1)*16)
            if d<0 then d=0
            if d>300 then d=300
            'cc=cc+1:if cc>400 then cc=0: gosub [restart]:goto [start]

                x=int(rnd(1)*255)
                y=int(rnd(1)*255)
                z=int(rnd(1)*255)
                #p.g, "color "; x;" ";y;" ";z

              #p.g, "line "; a+xx;" ";b+yy+24;" ";c+xx;" ";d+yy+24
              #p.g, "line ";w-a+xx;" ";b+yy+24;" ";w-c+xx;" ";d+yy+24
              #p.g, "line "; a+xx;" ";h-b+yy+24;" ";c+xx;" ";h-d+yy+24
              #p.g, "line ";w-a+xx;" ";h-b+yy+24;" ";w-c+xx;" ";h-d+yy+24
            a=c:b=d
        return

[restart]'stop note, close midi device, DLLs, window
    timer 0
    UnloadBmp "piano"
    gosub [stopPlay]   'stop all output
    CallDLL #winmm, "midiOutClose", hMidiOut As ulong,_
        ret As ulong

    CallDLL#user32,"ReleaseDC",_
        Wnd As long,hDC As long,result As long
    Close #p
    return

'========================Beethoven's Finger===========================
 [beethoven]

     w=640
     h=300
     a=320
     b=150
     c=a:d=b


[scratchPad]
    For x2=1 to 100
    index=index+int(rnd(1)*5)-int(rnd(1)*5)
    flip=int(rnd(1)*8):if flip=1 then index=index+int(rnd(1)*3)-int(rnd(1)*3)
    if index>22 then index=22
    if index<1 then index=3

    note=scale(index)
    randnum=int(rnd(1)*15)+1
    if randnum=1 then note=note-1
    if randnum>=14 then note=1 'rest
    song(x2)=note
    r=int(rnd(1)*6)+1
    ry=ryt(r)

    rythem(x2)=ry

    next x2


[start2]
          gosub [doChange3]
           timer 0
          cc=int(rnd(1)*4)
          high1=int(rnd(1)*70)+29:low1=high1-(int(rnd(1)*8)+15)
          high2=int(rnd(1)*70)+29:low2=high2-(int(rnd(1)*8)+15)
          high3=int(rnd(1)*70)+29:low3=high3-(int(rnd(1)*8)+15)
          high4=int(rnd(1)*70)+15:low4=high4-(int(rnd(1)*8)+5)
          high5=int(rnd(1)*70)+15:low5=high5-(int(rnd(1)*8)+5)
          high6=int(rnd(1)*70)+15:low6=high6-(int(rnd(1)*8)+5)


[first]
       cc=int(rnd(1)*3)
       if cc=1 goto [second]
       if cc=2 goto [third]
       high=high1:x=low1: gosub [playSong]
[second]       high=high1:x=low1:gosub[playSong]
[third]       high=high1:x=low1:gosub[playSong]

       high=high2:x=low2:gosub [playSong]
       high=high3:x=low3:gosub [playSong]
       cc=int(rnd(1)*3)
       if cc=1 then goto [fith]
       if cc=2 then goto [sixth]
[forth]       high=high2:x=low2:gosub [playSong]
       high=high4:x=low4:gosub [playSong]
       high=high5:x=low5:gosub [playSong]
[fith]       high=high4:x=low4:gosub [playSong]
       high=high4:x=low4:gosub [playSong]
[sixth]       high=high6:x=low6:gosub [playSong]

       high=high2:x=low2:gosub [playSong]
       high=high1:x=low1: gosub [playSong]



       timer 1500,[scratchPad]
    Wait



[playSong]   'a keyboard key was pressed
    timer 0
     if x=high then return
     note=song(x)
     print note
        event=144   'event 144 = play on channel 1
    low=(note*256)+event
    velocity=127
    if note=1 then velocity=0
    hi=velocity*256*256
    dwMsg=low+hi
    CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
        dwMsg As ulong, ret As ulong


    ry=rythem(x)
    ry=ry*2.5
    x=x+1

    timer ry,[stopNote3]
    wait

[stopNote3]

    event=144   'event 144 = play on channel 1
    low=(note*256)+event
    velocity=0
    hi=velocity*256*256
    dwMsg=low+hi
    CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
        dwMsg As ulong, ret As ulong


       goto [playSong]
       wait


[doChange3]'signal a voice change:
event=192 'event 192 = change
'voice=int(rnd(1)*128)
v=int(rnd(1)*20)+1
voice=vo(v)
print "Voice=";voice
velocity=127
low=(voice*256)+event
hi=velocity*256*256
dwMsg=low+hi
CallDLL #winmm, "midiOutShortMsg",hMidiOut As ulong,_
dwMsg As ulong, ret As ulong
RETURN














