'Bullet.bas
'Developed by Mr. Ryles Sept. 2001
'revised 7-2-03
'bullet sprite to show at Mouse XY for a fraction of a second
'when left mouse button is clicked

'Outline for Setting Up Liberty BASIC Games

'I.  Window Setup
nomainwin
WindowWidth=300:WindowHeight=270
UpperLeftX=Int((DisplayWidth-WindowWidth)/2)    'This line and the next center the window
UpperLeftY=Int((DisplayHeight-WindowHeight)/2)
graphicbox #w.g, 0,0,300,250

open "Press left Mouse button to shoot" for window_nf as #w
print #w, "trapclose [quit]"
cursor crosshair

'II.  Load Bitmaps
loadbmp "bullet", "bullet.bmp"

'III.  Initialize Variables
ShootFlag=0
count=0

'IV.  Setup Sprites
    'A.  Set Background
print #w.g, "down;fill black";
print #w.g, "flush";
print #w.g, "getbmp bg 0 0 300 250"
print #w.g, "background bg";

    'B.  Add Sprites to the Window - addsprite
print #w.g, "addsprite bullet bullet"

    'C.  Set Initial Location of Sprites - spritexy
print #w.g, "spritexy bullet 0 700" 'places bullet off screen

   ' D.  Set other Sprite Attributes
'print #w.g, "spritescale bullet 50"

'V.  Initialize Timer, set no less than 56
timer 100, [TimerBranch]

    'VI.  Initialize Keyboard and Mouse Events
    print #w.g, "setfocus"
    print #w.g, "when leftButtonDown [Shoot]"
    wait

    'VII.  Timer Branch
    [TimerBranch]
    gosub [count]
    gosub [draw]
    wait

'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
unloadbmp "bg"
unloadbmp "bullet"
close #w:end

    'IX.  Branches called by Mouse and or Keyboard - user entity movement
    [Shoot]
    if ShootFlag=0 then     'if a shot is not currently happening then do the following
        ShootFlag=1            'Says now there is a bullet on the screen
        bx=MouseX-11        'set's the bullets location in the center of the cursor
        by=MouseY-11        'will need to be changed if bullet size is changed
        print #w.g, "spritexy bullet "; bx; " " ;by     'placed the bullet on-screen relative
                                                                         ' to mouse location
        print #w.g, "drawsprites"
        playwave "shot", async      'plays a wav file
    end if
    wait

    'X.  Subs Called by Timer Branch
    [count]
    if ShootFlag=1 then         'if there is a bullet on the screen then do the following
        count=count+1           'add one to the count variable - happens each timer cycle
            if count>3 then        'if count is more than three then do the following
                ShootFlag=0         'reset variables to zero
                count=0
                print #w.g, "spritexy bullet 0 700"       'place the bullet sprite off screen again
            end if
    end if

[draw]
print #w.g, "drawsprites"
return
