(******************************************************************************)
(*                                                                            *)
(**)                        DEFINITION Windows;                             (**)
(*                                                                            *)
(******************************************************************************)
(* Copyright (c) 1993, Robinson Associates                                    *)
(*                     Red Lion House                                         *)
(*                     St Mary's Street                                       *)
(*                     PAINSWICK                                              *)
(*                     Glos                                                   *)
(*                     GL6  6QR                                               *)
(*                     Tel:    (+44) (0)452 813 699                           *)
(*                     Fax:    (+44) (0)452 812 912                           *)
(*                     e-Mail: robin0@cix.compulink.co.uk                     *)
(******************************************************************************)
(* PURPOSE: Full Windows 3.1 Interface module                                 *)
(******************************************************************************)
(* REVISION: 1.1  4. 4.1995                                                   *)
(*           1.2 15. 5.1996 types for windows and dialog call-back procedures *)
(*                          changed to eliminate type casts                   *)
(******************************************************************************)
(* COMMENTS:                                                                  *)
(*   For a full description of the types and functions refer to the           *)
(*     "Microsoft Windows 3.1 Software Developers Kit"                        *)
(******************************************************************************)

CONST
  ABORTDOC                    =          2;
  ABSOLUTE                    =          1;
  ALTERNATE                   =          1;
  ASPECTX                     =         40;
  ASPECTXY                    =         44;
  ASPECTY                     =         42;
  BANDINFO                    =         24;
  BITSPIXEL                   =         12;
  BLACKNESS                   =        42H;
  BLACKONWHITE                =          1;
  CLIPCAPS                    =         36;
  CLRDTR                      =          6;
  CLRRTS                      =          4;
  COLORONCOLOR                =          3;
  COLORRES                    =        108;
  COMPLEXREGION               =          3;
  CURVECAPS                   =         28;
  DEVICEDATA                  =         19;
  DLGWINDOWEXTRA              =         30;
  DRAFTMODE                   =          7;
  DRAWPATTERNRECT             =         25;
  DRIVERVERSION               =          0;
  DSTINVERT                   =    550009H;
  ENABLEDUPLEX                =         28;
  ENABLEPAIRKERNING           =        769;
  ENABLERELATIVEWIDTHS        =        768;
  ENDDOC                      =         11;
  ENUMPAPERBINS               =         31;
  ENUMPAPERMETRICS            =         34;
  EPSPRINTING                 =         33;
  ERROR                       =          0;
  EVENPARITY                  =          2;
  EXTTEXTOUT                  =        512;
  false                       =          0;
  FLOODFILLBORDER             =          0;
  FLOODFILLSURFACE            =          1;
  FLUSHOUTPUT                 =          6;
  GETBASEIRQ                  =         10;
  GETCOLORTABLE               =          5;
  GETEXTENDEDTEXTMETRICS      =        256;
  GETEXTENTTABLE              =        257;
  GETFACENAME                 =        513;
  GETMAXCOM                   =          9;
  GETMAXLPT                   =          8;
  GETPAIRKERNTABLE            =        258;
  GETPENWIDTH                 =         16;
  GETPHYSPAGESIZE             =         12;
  GETPRINTINGOFFSET           =         13;
  GETSCALINGFACTOR            =         14;
  GETSETPAPERBINS             =         29;
  GETSETPAPERMETRICS          =         35;
  GETSETPRINTORIENT           =         30;
  GETSETSCREENPARAMS          =       3072;
  GETTECHNOLGY                =         20;
  GETTECHNOLOGY               =         20;
  GETTRACKKERNTABLE           =        259;
  GETVECTORBRUSHSIZE          =         27;
  GETVECTORPENSIZE            =         26;
  GHND                        =        42H;
  GPTR                        =        40H;
  HORZRES                     =          8;
  HORZSIZE                    =          4;
  HTBORDER                    =         18;
  HTBOTTOM                    =         15;
  HTBOTTOMLEFT                =         16;
  HTBOTTOMRIGHT               =         17;
  HTCAPTION                   =          2;
  HTCLIENT                    =          1;
  HTERROR                     =         -2;
  HTGROWBOX                   =          4;
  HTHSCROLL                   =          6;
  HTLEFT                      =         10;
  HTMAXBUTTON                 =          9;
  HTMENU                      =          5;
  HTMINBUTTON                 =          8;
  HTNOWHERE                   =          0;
  HTREDUCE                    =          8;
  HTRIGHT                     =         11;
  HTSIZE                      =          4;
  HTSYSMENU                   =          3;
  HTTOP                       =         12;
  HTTOPLEFT                   =         13;
  HTTOPRIGHT                  =         14;
  HTTRANSPARENT               =         -1;
  HTVSCROLL                   =          7;
  HTZOOM                      =          9;
  IDABORT                     =          3;
  IDCANCEL                    =          2;
  IDIGNORE                    =          5;
  IDNO                        =          7;
  IDOK                        =          1;
  IDRETRY                     =          4;
  IDYES                       =          6;
  IGNORE                      =          0;
  INFINITE                    =         -1 (*     0FFFFH *);
  LHND                        =        42H;
  LINECAPS                    =         30;
  LOGPIXELSX                  =         88;
  LOGPIXELSY                  =         90;
  LPTR                        =        40H;
  LPTx                        =        80H;
  MARKPARITY                  =          3;
  MERGECOPY                   =   0C000CAH;
  MERGEPAINT                  =   0BB0226H;
  MFCOMMENT                   =         15;
  MOUSETRAILS                 =         39;
  NEWFRAME                    =          1;
  NEXTBAND                    =          3;
  NONZEROLHND                 =         2H;
  NONZEROLPTR                 =         0H;
  NOPARITY                    =          0;
  NOTSRCCOPY                  =    330008H;
  NOTSRCERASE                 =    1100A6H;
  NULL                        =          0;
  NULLREGION                  =          1;
  NUMBRUSHES                  =         16;
  NUMCOLORS                   =         24;
  NUMFONTS                    =         22;
  NUMMARKERS                  =         20;
  NUMPENS                     =         18;
  NUMRESERVED                 =        106;
  ODDPARITY                   =          1;
  ONE5STOPBITS                =          1;
  ONESTOPBIT                  =          0;
  OPAQUE                      =          2;
  PASSTHROUGH                 =         19;
  PATCOPY                     =   0F00021H;
  PATINVERT                   =    5A0049H;
  PATPAINT                    =   0FB0A09H;
  PDEVICESIZE                 =         26;
  PLANES                      =         14;
  POLYGONALCAPS               =         32;
  QUERYESCSUPPORT             =          8;
  RASTERCAPS                  =         38;
  READ                        =          0;
  RELATIVE                    =          2;
  RESETDEV                    =          7;
  SELECTPAPERSOURCE           =         18;
  SETABORTPROC                =          9;
  SETALLJUSTVALUES            =        771;
  SETCHARSET                  =        772;
  SETCOLORTABLE               =          4;
  SETCOPYCOUNT                =         17;
  SETDIBSCALING               =         32;
  SETDTR                      =          5;
  SETKERNTRACK                =        770;
  SETLINECAP                  =         21;
  SETLINEJOIN                 =         22;
  SETMITERLIMIT               =         23;
  SETRTS                      =          3;
  SETXOFF                     =          1;
  SETXON                      =          2;
  SIMPLEREGION                =          2;
  SIZEFULLSCREEN              =          2;
  SIZEICONIC                  =          1;
  SIZENORMAL                  =          0;
  SIZEPALETTE                 =        104;
  SIZEZOOMHIDE                =          4;
  SIZEZOOMSHOW                =          3;
  SPACEPARITY                 =          4;
  SRCAND                      =    8800C6H;
  SRCCOPY                     =   0CC0020H;
  SRCERASE                    =    440328H;
  SRCINVERT                   =    660046H;
  SRCPAINT                    =   0EE0086H;
  STARTDOC                    =         10;
  STRETCHBLT                  =       2048;
  TECHNOLOGY                  =          2;
  TEXTCAPS                    =         34;
  TRANSPARENT                 =          1;
  true                        =          1;
  TWOSTOPBITS                 =          2;
  VERTRES                     =         10;
  VERTSIZE                    =          6;
  WHITENESS                   =   0FF0062H;
  WHITEONBLACK                =          2;
  WINDING                     =          2;
  WINVER                      =       30AH;
  WRITE                       =          1;

  ANSI_CHARSET                =          0;
  ANSI_FIXED_FONT             =         11;
  ANSI_VAR_FONT               =         12;
  ASPECT_FILTERING            =         1H;
  BEGIN_PATH                  =       4096;
  BI_RGB                      =          0;
  BI_RLE4                     =          2;
  BI_RLE8                     =          1;
  BLACK_BRUSH                 =          4;
  BLACK_PEN                   =          7;
  BM_GETCHECK                 =       400H;
  BM_GETSTATE                 =       402H;
  BM_SETCHECK                 =       401H;
  BM_SETSTATE                 =       403H;
  BM_SETSTYLE                 =       404H;
  BN_CLICKED                  =          0;
  BN_DISABLE                  =          4;
  BN_DOUBLECLICKED            =          5;
  BN_HILITE                   =          2;
  BN_PAINT                    =          1;
  BN_UNHILITE                 =          3;
  BS_3STATE                   =         5H;
  BS_AUTO3STATE               =         6H;
  BS_AUTOCHECKBOX             =         3H;
  BS_AUTORADIOBUTTON          =         9H;
  BS_CHECKBOX                 =         2H;
  BS_DEFPUSHBUTTON            =         1H;
  BS_DIBPATTERN               =          5;
  BS_GROUPBOX                 =         7H;
  BS_HATCHED                  =          2;
  BS_HOLLOW                   =          1;
  BS_INDEXED                  =          4;
  BS_LEFTTEXT                 =        20H;
  BS_NULL                     =          1;
  BS_OWNERDRAW                =        0BH;
  BS_PATTERN                  =          3;
  BS_PUSHBUTTON               =         0H;
  BS_RADIOBUTTON              =         4H;
  BS_SOLID                    =          0;
  BS_USERBUTTON               =         8H;
  CBM_INIT                    =         4H;
  CBN_CLOSEUP                 =          8;
  CBN_DBLCLK                  =          2;
  CBN_DROPDOWN                =          7;
  CBN_EDITCHANGE              =          5;
  CBN_EDITUPDATE              =          6;
  CBN_ERRSPACE                =         -1;
  CBN_KILLFOCUS               =          4;
  CBN_SELCHANGE               =          1;
  CBN_SELENDCANCEL            =         10;
  CBN_SELENDOK                =          9;
  CBN_SETFOCUS                =          3;
  CBR_110                     =       -240 (*     0FF10H *);
  CBR_1200                    =       -237 (*     0FF13H *);
  CBR_128000                  =       -221 (*     0FF23H *);
  CBR_14400                   =       -233 (*     0FF17H *);
  CBR_19200                   =       -232 (*     0FF18H *);
  CBR_2400                    =       -236 (*     0FF14H *);
  CBR_256000                  =       -217 (*     0FF27H *);
  CBR_300                     =       -239 (*     0FF11H *);
  CBR_38400                   =       -229 (*     0FF1BH *);
  CBR_4800                    =       -235 (*     0FF15H *);
  CBR_56000                   =       -225 (*     0FF1FH *);
  CBR_600                     =       -238 (*     0FF12H *);
  CBR_9600                    =       -234 (*     0FF16H *);
  CBS_AUTOHSCROLL             =        40H;
  CBS_DISABLENOSCROLL         =       800H;
  CBS_DROPDOWN                =         2H;
  CBS_DROPDOWNLIST            =         3H;
  CBS_HASSTRINGS              =       200H;
  CBS_NOINTEGRALHEIGHT        =       400H;
  CBS_OEMCONVERT              =        80H;
  CBS_OWNERDRAWFIXED          =        10H;
  CBS_OWNERDRAWVARIABLE       =        20H;
  CBS_SIMPLE                  =         1H;
  CBS_SORT                    =       100H;
  CB_ADDSTRING                =       403H;
  CB_DELETESTRING             =       404H;
  CB_DIR                      =       405H;
  CB_ERR                      =         -1;
  CB_ERRSPACE                 =         -2;
  CB_FINDSTRING               =       40CH;
  CB_FINDSTRINGEXACT          =       418H;
  CB_GETCOUNT                 =       406H;
  CB_GETCURSEL                =       407H;
  CB_GETDROPPEDCONTROLRECT    =       412H;
  CB_GETDROPPEDSTATE          =       417H;
  CB_GETEDITSEL               =       400H;
  CB_GETEXTENDEDUI            =       416H;
  CB_GETITEMDATA              =       410H;
  CB_GETITEMHEIGHT            =       414H;
  CB_GETLBTEXT                =       408H;
  CB_GETLBTEXTLEN             =       409H;
  CB_INSERTSTRING             =       40AH;
  CB_LIMITTEXT                =       401H;
  CB_OKAY                     =          0;
  CB_RESETCONTENT             =       40BH;
  CB_SELECTSTRING             =       40DH;
  CB_SETCURSEL                =       40EH;
  CB_SETEDITSEL               =       402H;
  CB_SETEXTENDEDUI            =       415H;
  CB_SETITEMDATA              =       411H;
  CB_SETITEMHEIGHT            =       413H;
  CB_SHOWDROPDOWN             =       40FH;
  CC_CHORD                    =         4H;
  CC_CIRCLES                  =         1H;
  CC_ELLIPSES                 =         8H;
  CC_INTERIORS                =        80H;
  CC_NONE                     =         0H;
  CC_PIE                      =         2H;
  CC_ROUNDRECT                =       100H;
  CC_STYLED                   =        20H;
  CC_WIDE                     =        10H;
  CC_WIDESTYLED               =        40H;
  CE_BREAK                    =        10H;
  CE_CTSTO                    =        20H;
  CE_DNS                      =       800H;
  CE_DSRTO                    =        40H;
  CE_FRAME                    =         8H;
  CE_IOE                      =       400H;
  CE_MODE                     =     -32768 (*      8000H *);
  CE_OOP                      =      1000H;
  CE_OVERRUN                  =         2H;
  CE_PTO                      =       200H;
  CE_RLSDTO                   =        80H;
  CE_RXOVER                   =         1H;
  CE_RXPARITY                 =         4H;
  CE_TXFULL                   =       100H;
  CF_BITMAP                   =          2;
  CF_DIB                      =          8;
  CF_DIF                      =          5;
  CF_DSPBITMAP                =        82H;
  CF_DSPMETAFILEPICT          =        83H;
  CF_DSPTEXT                  =        81H;
  CF_GDIOBJFIRST              =       300H;
  CF_GDIOBJLAST               =       3FFH;
  CF_METAFILEPICT             =          3;
  CF_OEMTEXT                  =          7;
  CF_OWNERDISPLAY             =        80H;
  CF_PALETTE                  =          9;
  CF_PENDATA                  =         10;
  CF_PRIVATEFIRST             =       200H;
  CF_PRIVATELAST              =       2FFH;
  CF_RIFF                     =         11;
  CF_SYLK                     =          4;
  CF_TEXT                     =          1;
  CF_TIFF                     =          6;
  CF_WAVE                     =         12;
  CHINESEBIG5_CHARSET         =        136;
  CLIP_CHARACTER_PRECIS       =         1H;
  CLIP_DEFAULT_PRECIS         =         0H;
  CLIP_EMBEDDED               =        80H;
  CLIP_LH_ANGLES              =        10H;
  CLIP_MASK                   =        0FH;
  CLIP_STROKE_PRECIS          =         2H;
  CLIP_TO_PATH                =       4097;
  CLIP_TT_ALWAYS              =        20H;
  CN_EVENT                    =         4H;
  CN_RECEIVE                  =         1H;
  CN_TRANSMIT                 =         2H;
  COLOR_ACTIVEBORDER          =         10;
  COLOR_ACTIVECAPTION         =          2;
  COLOR_APPWORKSPACE          =         12;
  COLOR_BACKGROUND            =          1;
  COLOR_BTNFACE               =         15;
  COLOR_BTNHIGHLIGHT          =         20;
  COLOR_BTNSHADOW             =         16;
  COLOR_BTNTEXT               =         18;
  COLOR_CAPTIONTEXT           =          9;
  COLOR_GRAYTEXT              =         17;
  COLOR_HIGHLIGHT             =         13;
  COLOR_HIGHLIGHTTEXT         =         14;
  COLOR_INACTIVEBORDER        =         11;
  COLOR_INACTIVECAPTION       =          3;
  COLOR_INACTIVECAPTIONTEXT   =         19;
  COLOR_MENU                  =          4;
  COLOR_MENUTEXT              =          7;
  COLOR_SCROLLBAR             =          0;
  COLOR_WINDOW                =          5;
  COLOR_WINDOWFRAME           =          6;
  COLOR_WINDOWTEXT            =          8;
  CP_NONE                     =         0H;
  CP_RECTANGLE                =         1H;
  CP_REGION                   =         2H;
  CSTF_CTSHOLD                =         1H;
  CSTF_DSRHOLD                =         2H;
  CSTF_EOF                    =        20H;
  CSTF_RLSDHOLD               =         4H;
  CSTF_TXIM                   =        40H;
  CSTF_XOFFHOLD               =         8H;
  CSTF_XOFFSENT               =        10H;
  CS_BYTEALIGNCLIENT          =      1000H;
  CS_BYTEALIGNWINDOW          =      2000H;
  CS_CLASSDC                  =        40H;
  CS_DBLCLKS                  =         8H;
  CS_GLOBALCLASS              =      4000H;
  CS_HREDRAW                  =         2H;
  CS_KEYCVTWINDOW             =         4H;
  CS_NOCLOSE                  =       200H;
  CS_NOKEYCVT                 =       100H;
  CS_OWNDC                    =        20H;
  CS_PARENTDC                 =        80H;
  CS_SAVEBITS                 =       800H;
  CS_VREDRAW                  =         1H;
  CTLCOLOR_BTN                =          3;
  CTLCOLOR_DLG                =          4;
  CTLCOLOR_EDIT               =          1;
  CTLCOLOR_LISTBOX            =          2;
  CTLCOLOR_MSGBOX             =          0;
  CTLCOLOR_SCROLLBAR          =          5;
  CTLCOLOR_STATIC             =          6;
  CW_USEDEFAULT               =     -32768 (*      8000H *);
  DBF_APPLICATION             =         8H;
  DBF_DRIVER                  =        10H;
  DBF_ERROR                   =     -32768 (*      8000H *);
  DBF_FATAL                   =     -16384 (*     0C000H *);
  DBF_GDI                     =       400H;
  DBF_KERNEL                  =      1000H;
  DBF_KRN_LOADMODULE          =         2H;
  DBF_KRN_MEMMAN              =         1H;
  DBF_KRN_SEGMENTLOAD         =         4H;
  DBF_MMSYSTEM                =        40H;
  DBF_PENWIN                  =        20H;
  DBF_TRACE                   =         0H;
  DBF_USER                    =       800H;
  DBF_WARNING                 =      4000H;
  DBO_BUFFERFILL              =         4H;
  DBO_CHECKFREE               =        20H;
  DBO_CHECKHEAP               =         1H;
  DBO_DISABLEGPTRAPPING       =        10H;
  DBO_INT3BREAK               =       100H;
  DBO_NOERRORBREAK            =       800H;
  DBO_NOFATALBREAK            =       400H;
  DBO_SILENT                  =     -32768 (*      8000H *);
  DBO_TRACEBREAK              =      2000H;
  DBO_WARNINGBREAK            =      1000H;
  DCB_ACCUMULATE              =         2H;
  DCB_DIRTY                   =         2H;
  DCB_DISABLE                 =         8H;
  DCB_ENABLE                  =         4H;
  DCB_RESET                   =         1H;
  DCB_SET                     =         3H;
  DCX_CACHE                   =         2H;
  DCX_CLIPCHILDREN            =         8H;
  DCX_CLIPSIBLINGS            =        10H;
  DCX_EXCLUDERGN              =        40H;
  DCX_INTERSECTRGN            =        80H;
  DCX_LOCKWINDOWUPDATE        =       400H;
  DCX_PARENTCLIP              =        20H;
  DCX_USESTYLE                =     10000H;
  DCX_WINDOW                  =         1H;
  DC_HASDEFID                 =      534BH;
  DDL_ARCHIVE                 =        20H;
  DDL_DIRECTORY               =        10H;
  DDL_DRIVES                  =      4000H;
  DDL_EXCLUSIVE               =     -32768 (*      8000H *);
  DDL_HIDDEN                  =         2H;
  DDL_POSTMSGS                =      2000H;
  DDL_READONLY                =         1H;
  DDL_READWRITE               =         0H;
  DDL_SYSTEM                  =         4H;
  DEFAULT_CHARSET             =          1;
  DEFAULT_PALETTE             =         15;
  DEFAULT_PITCH               =         0H;
  DEFAULT_QUALITY             =          0;
  DEVICE_DEFAULT_FONT         =         14;
  DEVICE_FONTTYPE             =         2H;
  DIB_PAL_COLORS              =          1;
  DIB_RGB_COLORS              =          0;
  DKGRAY_BRUSH                =          3;
  DLGC_BUTTON                 =      2000H;
  DLGC_DEFPUSHBUTTON          =        10H;
  DLGC_HASSETSEL              =         8H;
  DLGC_RADIOBUTTON            =        40H;
  DLGC_STATIC                 =       100H;
  DLGC_UNDEFPUSHBUTTON        =        20H;
  DLGC_WANTALLKEYS            =         4H;
  DLGC_WANTARROWS             =         1H;
  DLGC_WANTCHARS              =        80H;
  DLGC_WANTMESSAGE            =         4H;
  DLGC_WANTTAB                =         2H;
  DM_GETDEFID                 =       400H;
  DM_SETDEFID                 =       401H;
  DRAFT_QUALITY               =          1;
  DRIVE_FIXED                 =          3;
  DRIVE_REMOTE                =          4;
  DRIVE_REMOVABLE             =          2;
  DRVCNF_CANCEL               =         0H;
  DRVCNF_OK                   =         1H;
  DRVCNF_RESTART              =         2H;
  DRVEA_ABNORMALEXIT          =         2H;
  DRVEA_NORMALEXIT            =         1H;
  DRV_CLOSE                   =         4H;
  DRV_CONFIGURE               =         7H;
  DRV_DISABLE                 =         5H;
  DRV_ENABLE                  =         2H;
  DRV_EXITAPPLICATION         =        0CH;
  DRV_EXITSESSION             =        0BH;
  DRV_FREE                    =         6H;
  DRV_INSTALL                 =         9H;
  DRV_LOAD                    =         1H;
  DRV_OPEN                    =         3H;
  DRV_POWER                   =        0FH;
  DRV_QUERYCONFIGURE          =         8H;
  DRV_REMOVE                  =        0AH;
  DRV_RESERVED                =       800H;
  DRV_USER                    =      4000H;
  DS_ABSALIGN                 =         1H;
  DS_LOCALEDIT                =        20H;
  DS_MODALFRAME               =        80H;
  DS_NOIDLEMSG                =       100H;
  DS_SETFONT                  =        40H;
  DS_SYSMODAL                 =         2H;
  DT_BOTTOM                   =         8H;
  DT_CALCRECT                 =       400H;
  DT_CENTER                   =         1H;
  DT_CHARSTREAM               =          4;
  DT_DISPFILE                 =          6;
  DT_EXPANDTABS               =        40H;
  DT_EXTERNALLEADING          =       200H;
  DT_INTERNAL                 =      1000H;
  DT_LEFT                     =         0H;
  DT_METAFILE                 =          5;
  DT_NOCLIP                   =       100H;
  DT_NOPREFIX                 =       800H;
  DT_PLOTTER                  =          0;
  DT_RASCAMERA                =          3;
  DT_RASDISPLAY               =          1;
  DT_RASPRINTER               =          2;
  DT_RIGHT                    =         2H;
  DT_SINGLELINE               =        20H;
  DT_TABSTOP                  =        80H;
  DT_TOP                      =         0H;
  DT_VCENTER                  =         4H;
  DT_WORDBREAK                =        10H;
  DWL_DLGPROC                 =          4;
  DWL_MSGRESULT               =          0;
  DWL_USER                    =          8;
  EM_CANUNDO                  =       416H;
  EM_EMPTYUNDOBUFFER          =       41DH;
  EM_FMTLINES                 =       418H;
  EM_GETFIRSTVISIBLELINE      =       41EH;
  EM_GETHANDLE                =       40DH;
  EM_GETLINE                  =       414H;
  EM_GETLINECOUNT             =       40AH;
  EM_GETMODIFY                =       408H;
  EM_GETPASSWORDCHAR          =       422H;
  EM_GETRECT                  =       402H;
  EM_GETSEL                   =       400H;
  EM_GETWORDBREAKPROC         =       421H;
  EM_LIMITTEXT                =       415H;
  EM_LINEFROMCHAR             =       419H;
  EM_LINEINDEX                =       40BH;
  EM_LINELENGTH               =       411H;
  EM_LINESCROLL               =       406H;
  EM_REPLACESEL               =       412H;
  EM_SETFONT                  =       413H;
  EM_SETHANDLE                =       40CH;
  EM_SETMODIFY                =       409H;
  EM_SETPASSWORDCHAR          =       41CH;
  EM_SETREADONLY              =       41FH;
  EM_SETRECT                  =       403H;
  EM_SETRECTNP                =       404H;
  EM_SETSEL                   =       401H;
  EM_SETTABSTOPS              =       41BH;
  EM_SETWORDBREAK             =       41AH;
  EM_SETWORDBREAKPROC         =       420H;
  EM_UNDO                     =       417H;
  END_PATH                    =       4098;
  EN_CHANGE                   =       300H;
  EN_ERRSPACE                 =       500H;
  EN_HSCROLL                  =       601H;
  EN_KILLFOCUS                =       200H;
  EN_MAXTEXT                  =       501H;
  EN_SETFOCUS                 =       100H;
  EN_UPDATE                   =       400H;
  EN_VSCROLL                  =       602H;
  ERR_ALLOCRES                =         7H;
  ERR_BADINDEX                =        49H;
  ERR_BAD_ATOM                =      6024H;
  ERR_BAD_CID                 =      6045H;
  ERR_BAD_COORDS              =      7060H;
  ERR_BAD_DFLAGS              =      7005H;
  ERR_BAD_DINDEX              =      7006H;
  ERR_BAD_DVALUE              =      7004H;
  ERR_BAD_FLAGS               =      6002H;
  ERR_BAD_FUNC_PTR            =      7008H;
  ERR_BAD_GDI_OBJECT          =      6061H;
  ERR_BAD_GLOBAL_HANDLE       =      6022H;
  ERR_BAD_HANDLE              =      600BH;
  ERR_BAD_HBITMAP             =      6066H;
  ERR_BAD_HBRUSH              =      6065H;
  ERR_BAD_HCURSOR             =      6042H;
  ERR_BAD_HDC                 =      6062H;
  ERR_BAD_HDRVR               =      6046H;
  ERR_BAD_HDWP                =      6044H;
  ERR_BAD_HFILE               =      6025H;
  ERR_BAD_HFONT               =      6064H;
  ERR_BAD_HICON               =      6043H;
  ERR_BAD_HINSTANCE           =      6020H;
  ERR_BAD_HMENU               =      6041H;
  ERR_BAD_HMETAFILE           =      6069H;
  ERR_BAD_HMODULE             =      6021H;
  ERR_BAD_HPALETTE            =      6068H;
  ERR_BAD_HPEN                =      6063H;
  ERR_BAD_HRGN                =      6067H;
  ERR_BAD_HWND                =      6040H;
  ERR_BAD_INDEX               =      6003H;
  ERR_BAD_LOCAL_HANDLE        =      6023H;
  ERR_BAD_PTR                 =      7007H;
  ERR_BAD_SELECTOR            =      6009H;
  ERR_BAD_STRING_PTR          =      700AH;
  ERR_BAD_VALUE               =      6001H;
  ERR_BYTE                    =      1000H;
  ERR_CREATEDC                =        80H;
  ERR_CREATEDLG               =        40H;
  ERR_CREATEDLG2              =        41H;
  ERR_CREATEMENU              =        4AH;
  ERR_CREATEMETA              =        81H;
  ERR_CREATEWND               =        44H;
  ERR_DCBUSY                  =        43H;
  ERR_DELOBJSELECTED          =        82H;
  ERR_DWORD                   =      3000H;
  ERR_GALLOC                  =         1H;
  ERR_GLOCK                   =         3H;
  ERR_GREALLOC                =         2H;
  ERR_LALLOC                  =         4H;
  ERR_LLOCK                   =         6H;
  ERR_LOADMENU                =        47H;
  ERR_LOADMODULE              =         9H;
  ERR_LOADSTR                 =        46H;
  ERR_LOCKRES                 =         8H;
  ERR_LREALLOC                =         5H;
  ERR_NESTEDBEGINPAINT        =        48H;
  ERR_PARAM                   =      4000H;
  ERR_REGISTERCLASS           =        42H;
  ERR_SELBITMAP               =        83H;
  ERR_SIZE_MASK               =      3000H;
  ERR_STRUCEXTRA              =        45H;
  ERR_WARNING                 =     -32768 (*      8000H *);
  ERR_WORD                    =      2000H;
  ESB_DISABLE_BOTH            =         3H;
  ESB_DISABLE_DOWN            =         2H;
  ESB_DISABLE_LEFT            =         1H;
  ESB_DISABLE_LTUP            =         1H;
  ESB_DISABLE_RIGHT           =         2H;
  ESB_DISABLE_RTDN            =         2H;
  ESB_DISABLE_UP              =         1H;
  ESB_ENABLE_BOTH             =         0H;
  ES_AUTOHSCROLL              =        80H;
  ES_AUTOVSCROLL              =        40H;
  ES_CENTER                   =         1H;
  ES_LEFT                     =         0H;
  ES_LOWERCASE                =        10H;
  ES_MULTILINE                =         4H;
  ES_NOHIDESEL                =       100H;
  ES_OEMCONVERT               =       400H;
  ES_PASSWORD                 =        20H;
  ES_READONLY                 =       800H;
  ES_RIGHT                    =         2H;
  ES_UPPERCASE                =         8H;
  ES_WANTRETURN               =      1000H;
  ETO_CLIPPED                 =         4H;
  ETO_GRAYED                  =         1H;
  ETO_OPAQUE                  =         2H;
  EV_BREAK                    =        40H;
  EV_CTS                      =         8H;
  EV_CTSS                     =       400H;
  EV_DSR                      =        10H;
  EV_DSRS                     =       800H;
  EV_ERR                      =        80H;
  EV_PERR                     =       200H;
  EV_RING                     =       100H;
  EV_RINGTE                   =      2000H;
  EV_RLSD                     =        20H;
  EV_RLSDS                    =      1000H;
  EV_RXCHAR                   =         1H;
  EV_RXFLAG                   =         2H;
  EV_RingTe                   =      2000H;
  EV_TXEMPTY                  =         4H;
  EW_REBOOTSYSTEM             =        43H;
  EW_RESTARTWINDOWS           =        42H;
  EXT_DEVICE_CAPS             =       4099;
  FF_DECORATIVE               =        50H;
  FF_DONTCARE                 =         0H;
  FF_MODERN                   =        30H;
  FF_ROMAN                    =        10H;
  FF_SCRIPT                   =        40H;
  FF_SWISS                    =        20H;
  FIXED_PITCH                 =         1H;
  FW_BLACK                    =        900;
  FW_BOLD                     =        700;
  FW_DEMIBOLD                 =        600;
  FW_DONTCARE                 =          0;
  FW_EXTRABOLD                =        800;
  FW_EXTRALIGHT               =        200;
  FW_HEAVY                    =        900;
  FW_LIGHT                    =        300;
  FW_MEDIUM                   =        500;
  FW_NORMAL                   =        400;
  FW_REGULAR                  =        400;
  FW_SEMIBOLD                 =        600;
  FW_THIN                     =        100;
  FW_ULTRABOLD                =        800;
  FW_ULTRALIGHT               =        200;
  GCL_MENUNAME                =         -8;
  GCL_WNDPROC                 =        -24;
  GCW_ATOM                    =        -32;
  GCW_CBCLSEXTRA              =        -20;
  GCW_CBWNDEXTRA              =        -18;
  GCW_HBRBACKGROUND           =        -10;
  GCW_HCURSOR                 =        -12;
  GCW_HICON                   =        -14;
  GCW_HMODULE                 =        -16;
  GCW_STYLE                   =        -26;
  GFSR_GDIRESOURCES           =         1H;
  GFSR_SYSTEMRESOURCES        =         0H;
  GFSR_USERRESOURCES          =         2H;
  GGO_BITMAP                  =          1;
  GGO_METRICS                 =          0;
  GGO_NATIVE                  =          2;
  GMEM_DDESHARE               =      2000H;
  GMEM_DISCARDABLE            =       100H;
  GMEM_DISCARDED              =      4000H;
  GMEM_FIXED                  =         0H;
  GMEM_LOCKCOUNT              =       0FFH;
  GMEM_LOWER                  =      1000H;
  GMEM_MODIFY                 =        80H;
  GMEM_MOVEABLE               =         2H;
  GMEM_NOCOMPACT              =        10H;
  GMEM_NODISCARD              =        20H;
  GMEM_NOTIFY                 =      4000H;
  GMEM_NOT_BANKED             =      1000H;
  GMEM_SHARE                  =      2000H;
  GMEM_ZEROINIT               =        40H;
  GND_FIRSTINSTANCEONLY       =         1H;
  GND_FORWARD                 =         0H;
  GND_REVERSE                 =         2H;
  GRAY_BRUSH                  =          2;
  GWL_EXSTYLE                 =        -20;
  GWL_STYLE                   =        -16;
  GWL_WNDPROC                 =         -4;
  GWW_HINSTANCE               =         -6;
  GWW_HWNDPARENT              =         -8;
  GWW_ID                      =        -12;
  GW_CHILD                    =          5;
  GW_HWNDFIRST                =          0;
  GW_HWNDLAST                 =          1;
  GW_HWNDNEXT                 =          2;
  GW_HWNDPREV                 =          3;
  GW_OWNER                    =          4;
  HANGEUL_CHARSET             =        129;
  HCBT_ACTIVATE               =          5;
  HCBT_CLICKSKIPPED           =          6;
  HCBT_CREATEWND              =          3;
  HCBT_DESTROYWND             =          4;
  HCBT_KEYSKIPPED             =          7;
  HCBT_MINMAX                 =          1;
  HCBT_MOVESIZE               =          0;
  HCBT_QS                     =          2;
  HCBT_SETFOCUS               =          9;
  HCBT_SYSCOMMAND             =          8;
  HC_ACTION                   =          0;
  HC_GETLPLPFN                =         -3;
  HC_GETNEXT                  =          1;
  HC_LPFNNEXT                 =         -1;
  HC_LPLPFNNEXT               =         -2;
  HC_NOREM                    =          3;
  HC_NOREMOVE                 =          3;
  HC_SKIP                     =          2;
  HC_SYSMODALOFF              =          5;
  HC_SYSMODALON               =          4;
  HELP_COMMAND                =       102H;
  HELP_CONTENTS               =         3H;
  HELP_CONTEXT                =         1H;
  HELP_CONTEXTPOPUP           =         8H;
  HELP_FORCEFILE              =         9H;
  HELP_HELPONHELP             =         4H;
  HELP_INDEX                  =         3H;
  HELP_KEY                    =       101H;
  HELP_MULTIKEY               =       201H;
  HELP_PARTIALKEY             =       105H;
  HELP_QUIT                   =         2H;
  HELP_SETCONTENTS            =         5H;
  HELP_SETINDEX               =         5H;
  HELP_SETWINPOS              =       203H;
  HFILE_ERROR                 =         -1;
  HIDE_WINDOW                 =          0;
  HINSTANCE_ERROR             =         32;
  HOLLOW_BRUSH                =          5;
  HSHELL_ACTIVATESHELLWINDOW  =          3;
  HSHELL_WINDOWCREATED        =          1;
  HSHELL_WINDOWDESTROYED      =          2;
  HS_BDIAGONAL                =          3;
  HS_CROSS                    =          4;
  HS_DIAGCROSS                =          5;
  HS_FDIAGONAL                =          2;
  HS_HORIZONTAL               =          0;
  HS_VERTICAL                 =          1;
  HWND_BOTTOM                 =          1;
  HWND_BROADCAST              =         -1 (*     0FFFFH *);
  HWND_DESKTOP                =          0;
  HWND_NOTOPMOST              =         -2;
  HWND_TOP                    =          0;
  HWND_TOPMOST                =         -1;
  IDC_ARROW                   =      32512;
  IDC_CROSS                   =      32515;
  IDC_IBEAM                   =      32513;
  IDC_ICON                    =      32641;
  IDC_SIZE                    =      32640;
  IDC_SIZENESW                =      32643;
  IDC_SIZENS                  =      32645;
  IDC_SIZENWSE                =      32642;
  IDC_SIZEWE                  =      32644;
  IDC_UPARROW                 =      32516;
  IDC_WAIT                    =      32514;
  IDI_APPLICATION             =      32512;
  IDI_ASTERISK                =      32516;
  IDI_EXCLAMATION             =      32515;
  IDI_HAND                    =      32513;
  IDI_QUESTION                =      32514;
  IE_BADID                    =         -1;
  IE_BAUDRATE                 =        -12;
  IE_BYTESIZE                 =        -11;
  IE_DEFAULT                  =         -5;
  IE_HARDWARE                 =        -10;
  IE_MEMORY                   =         -4;
  IE_NOPEN                    =         -3;
  IE_OPEN                     =         -2;
  KF_ALTDOWN                  =      2000H;
  KF_DLGMODE                  =       800H;
  KF_EXTENDED                 =       100H;
  KF_MENUMODE                 =      1000H;
  KF_REPEAT                   =      4000H;
  KF_UP                       =     -32768 (*      8000H *);
  LBN_DBLCLK                  =          2;
  LBN_ERRSPACE                =         -2;
  LBN_KILLFOCUS               =          5;
  LBN_SELCANCEL               =          3;
  LBN_SELCHANGE               =          1;
  LBN_SETFOCUS                =          4;
  LBS_DISABLENOSCROLL         =      1000H;
  LBS_EXTENDEDSEL             =       800H;
  LBS_HASSTRINGS              =        40H;
  LBS_MULTICOLUMN             =       200H;
  LBS_MULTIPLESEL             =         8H;
  LBS_NOINTEGRALHEIGHT        =       100H;
  LBS_NOREDRAW                =         4H;
  LBS_NOTIFY                  =         1H;
  LBS_OWNERDRAWFIXED          =        10H;
  LBS_OWNERDRAWVARIABLE       =        20H;
  LBS_SORT                    =         2H;
  LBS_STANDARD                =   0A00003H;
  LBS_USETABSTOPS             =        80H;
  LBS_WANTKEYBOARDINPUT       =       400H;
  LB_ADDSTRING                =       401H;
  LB_CTLCODE                  =          0;
  LB_DELETESTRING             =       403H;
  LB_DIR                      =       40EH;
  LB_ERR                      =         -1;
  LB_ERRSPACE                 =         -2;
  LB_FINDSTRING               =       410H;
  LB_FINDSTRINGEXACT          =       423H;
  LB_GETCARETINDEX            =       420H;
  LB_GETCOUNT                 =       40CH;
  LB_GETCURSEL                =       409H;
  LB_GETHORIZONTALEXTENT      =       414H;
  LB_GETITEMDATA              =       41AH;
  LB_GETITEMHEIGHT            =       422H;
  LB_GETITEMRECT              =       419H;
  LB_GETSEL                   =       408H;
  LB_GETSELCOUNT              =       411H;
  LB_GETSELITEMS              =       412H;
  LB_GETTEXT                  =       40AH;
  LB_GETTEXTLEN               =       40BH;
  LB_GETTOPINDEX              =       40FH;
  LB_INSERTSTRING             =       402H;
  LB_OKAY                     =          0;
  LB_RESETCONTENT             =       405H;
  LB_SELECTSTRING             =       40DH;
  LB_SELITEMRANGE             =       41CH;
  LB_SETCARETINDEX            =       41FH;
  LB_SETCOLUMNWIDTH           =       416H;
  LB_SETCURSEL                =       407H;
  LB_SETHORIZONTALEXTENT      =       415H;
  LB_SETITEMDATA              =       41BH;
  LB_SETITEMHEIGHT            =       421H;
  LB_SETSEL                   =       406H;
  LB_SETTABSTOPS              =       413H;
  LB_SETTOPINDEX              =       418H;
  LC_INTERIORS                =        80H;
  LC_MARKER                   =         4H;
  LC_NONE                     =         0H;
  LC_POLYLINE                 =         2H;
  LC_POLYMARKER               =         8H;
  LC_STYLED                   =        20H;
  LC_WIDE                     =        10H;
  LC_WIDESTYLED               =        40H;
  LF_FACESIZE                 =         32;
  LF_FULLFACESIZE             =         64;
  LMEM_DISCARDABLE            =      0F00H;
  LMEM_DISCARDED              =      4000H;
  LMEM_FIXED                  =         0H;
  LMEM_LOCKCOUNT              =       0FFH;
  LMEM_MODIFY                 =        80H;
  LMEM_MOVEABLE               =         2H;
  LMEM_NOCOMPACT              =        10H;
  LMEM_NODISCARD              =        20H;
  LMEM_ZEROINIT               =        40H;
  LTGRAY_BRUSH                =          1;
  MA_ACTIVATE                 =          1;
  MA_ACTIVATEANDEAT           =          2;
  MA_NOACTIVATE               =          3;
  MA_NOACTIVATEANDEAT         =          4;
  MB_ABORTRETRYIGNORE         =         2H;
  MB_APPLMODAL                =         0H;
  MB_DEFBUTTON1               =         0H;
  MB_DEFBUTTON2               =       100H;
  MB_DEFBUTTON3               =       200H;
  MB_DEFMASK                  =      0F00H;
  MB_ICONASTERISK             =        40H;
  MB_ICONEXCLAMATION          =        30H;
  MB_ICONHAND                 =        10H;
  MB_ICONINFORMATION          =        40H;
  MB_ICONMASK                 =       0F0H;
  MB_ICONQUESTION             =        20H;
  MB_ICONSTOP                 =        10H;
  MB_NOFOCUS                  =     -32768 (*      8000H *);
  MB_OK                       =         0H;
  MB_OKCANCEL                 =         1H;
  MB_RETRYCANCEL              =         5H;
  MB_SYSTEMMODAL              =      1000H;
  MB_TASKMODAL                =      2000H;
  MB_TYPEMASK                 =        0FH;
  MB_YESNO                    =         4H;
  MB_YESNOCANCEL              =         3H;
  MDIS_ALLCHILDSTYLES         =         1H;
  MDITILE_HORIZONTAL          =         1H;
  MDITILE_SKIPDISABLED        =         2H;
  MDITILE_VERTICAL            =         0H;
  META_ABORTDOC               =        52H;
  META_ANIMATEPALETTE         =       436H;
  META_ARC                    =       817H;
  META_BITBLT                 =       922H;
  META_CHORD                  =       830H;
  META_CREATEBITMAP           =       6FEH;
  META_CREATEBITMAPINDIRECT   =       2FDH;
  META_CREATEBRUSH            =       0F8H;
  META_CREATEBRUSHINDIRECT    =       2FCH;
  META_CREATEFONTINDIRECT     =       2FBH;
  META_CREATEPALETTE          =       0F7H;
  META_CREATEPATTERNBRUSH     =       1F9H;
  META_CREATEPENINDIRECT      =       2FAH;
  META_CREATEREGION           =       6FFH;
  META_DELETEOBJECT           =       1F0H;
  META_DIBBITBLT              =       940H;
  META_DIBCREATEPATTERNBRUSH  =       142H;
  META_DIBSTRETCHBLT          =      0B41H;
  META_DRAWTEXT               =       62FH;
  META_ELLIPSE                =       418H;
  META_ENDDOC                 =        5EH;
  META_ENDPAGE                =        50H;
  META_ESCAPE                 =       626H;
  META_EXCLUDECLIPRECT        =       415H;
  META_EXTFLOODFILL           =       548H;
  META_EXTTEXTOUT             =      0A32H;
  META_FILLREGION             =       228H;
  META_FLOODFILL              =       419H;
  META_FRAMEREGION            =       429H;
  META_INTERSECTCLIPRECT      =       416H;
  META_INVERTREGION           =       12AH;
  META_LINETO                 =       213H;
  META_MOVETO                 =       214H;
  META_OFFSETCLIPRGN          =       220H;
  META_OFFSETVIEWPORTORG      =       211H;
  META_OFFSETWINDOWORG        =       20FH;
  META_PAINTREGION            =       12BH;
  META_PATBLT                 =       61DH;
  META_PIE                    =       81AH;
  META_POLYGON                =       324H;
  META_POLYLINE               =       325H;
  META_POLYPOLYGON            =       538H;
  META_REALIZEPALETTE         =        35H;
  META_RECTANGLE              =       41BH;
  META_RESETDC                =       14CH;
  META_RESIZEPALETTE          =       139H;
  META_RESTOREDC              =       127H;
  META_ROUNDRECT              =       61CH;
  META_SAVEDC                 =        1EH;
  META_SCALEVIEWPORTEXT       =       412H;
  META_SCALEWINDOWEXT         =       410H;
  META_SELECTCLIPREGION       =       12CH;
  META_SELECTOBJECT           =       12DH;
  META_SELECTPALETTE          =       234H;
  META_SETBKCOLOR             =       201H;
  META_SETBKMODE              =       102H;
  META_SETDIBTODEV            =      0D33H;
  META_SETMAPMODE             =       103H;
  META_SETMAPPERFLAGS         =       231H;
  META_SETPALENTRIES          =        37H;
  META_SETPIXEL               =       41FH;
  META_SETPOLYFILLMODE        =       106H;
  META_SETRELABS              =       105H;
  META_SETROP2                =       104H;
  META_SETSTRETCHBLTMODE      =       107H;
  META_SETTEXTALIGN           =       12EH;
  META_SETTEXTCHAREXTRA       =       108H;
  META_SETTEXTCOLOR           =       209H;
  META_SETTEXTJUSTIFICATION   =       20AH;
  META_SETVIEWPORTEXT         =       20EH;
  META_SETVIEWPORTORG         =       20DH;
  META_SETWINDOWEXT           =       20CH;
  META_SETWINDOWORG           =       20BH;
  META_STARTDOC               =       14DH;
  META_STARTPAGE              =        4FH;
  META_STRETCHBLT             =      0B23H;
  META_STRETCHDIB             =      0F43H;
  META_TEXTOUT                =       521H;
  MF_APPEND                   =       100H;
  MF_BITMAP                   =         4H;
  MF_BYCOMMAND                =         0H;
  MF_BYPOSITION               =       400H;
  MF_CHANGE                   =        80H;
  MF_CHECKED                  =         8H;
  MF_DELETE                   =       200H;
  MF_DISABLED                 =         2H;
  MF_ENABLED                  =         0H;
  MF_END                      =        80H;
  MF_GRAYED                   =         1H;
  MF_HELP                     =      4000H;
  MF_HILITE                   =        80H;
  MF_INSERT                   =         0H;
  MF_MENUBARBREAK             =        20H;
  MF_MENUBREAK                =        40H;
  MF_MOUSESELECT              =     -32768 (*      8000H *);
  MF_OWNERDRAW                =       100H;
  MF_POPUP                    =        10H;
  MF_REMOVE                   =      1000H;
  MF_SEPARATOR                =       800H;
  MF_STRING                   =         0H;
  MF_SYSMENU                  =      2000H;
  MF_UNCHECKED                =         0H;
  MF_UNHILITE                 =         0H;
  MF_USECHECKBITMAPS          =       200H;
  MK_CONTROL                  =         8H;
  MK_LBUTTON                  =         1H;
  MK_MBUTTON                  =        10H;
  MK_RBUTTON                  =         2H;
  MK_SHIFT                    =         4H;
  MM_ANISOTROPIC              =          8;
  MM_HIENGLISH                =          5;
  MM_HIMETRIC                 =          3;
  MM_ISOTROPIC                =          7;
  MM_LOENGLISH                =          4;
  MM_LOMETRIC                 =          2;
  MM_TEXT                     =          1;
  MM_TWIPS                    =          6;
  MSGF_DIALOGBOX              =          0;
  MSGF_MAINLOOP               =          8;
  MSGF_MENU                   =          2;
  MSGF_MOVE                   =          3;
  MSGF_NEXTWINDOW             =          6;
  MSGF_SCROLLBAR              =          5;
  MSGF_SIZE                   =          4;
  MSGF_USER                   =       4096;
  NTM_BOLD                    =        20H;
  NTM_ITALIC                  =         1H;
  NTM_REGULAR                 =        40H;
  NULL_BRUSH                  =          5;
  NULL_PEN                    =          8;
  OBJ_BRUSH                   =          2;
  OBJ_PEN                     =          1;
  OBM_BTNCORNERS              =      32758;
  OBM_BTSIZE                  =      32761;
  OBM_CHECK                   =      32760;
  OBM_CHECKBOXES              =      32759;
  OBM_CLOSE                   =      32754;
  OBM_COMBO                   =      32738;
  OBM_DNARROW                 =      32752;
  OBM_DNARROWD                =      32742;
  OBM_DNARROWI                =      32736;
  OBM_LFARROW                 =      32750;
  OBM_LFARROWD                =      32740;
  OBM_LFARROWI                =      32734;
  OBM_MNARROW                 =      32739;
  OBM_OLD_CLOSE               =      32767;
  OBM_OLD_DNARROW             =      32764;
  OBM_OLD_LFARROW             =      32762;
  OBM_OLD_REDUCE              =      32757;
  OBM_OLD_RESTORE             =      32755;
  OBM_OLD_RGARROW             =      32763;
  OBM_OLD_UPARROW             =      32765;
  OBM_OLD_ZOOM                =      32756;
  OBM_REDUCE                  =      32749;
  OBM_REDUCED                 =      32746;
  OBM_RESTORE                 =      32747;
  OBM_RESTORED                =      32744;
  OBM_RGARROW                 =      32751;
  OBM_RGARROWD                =      32741;
  OBM_RGARROWI                =      32735;
  OBM_SIZE                    =      32766;
  OBM_UPARROW                 =      32753;
  OBM_UPARROWD                =      32743;
  OBM_UPARROWI                =      32737;
  OBM_ZOOM                    =      32748;
  OBM_ZOOMD                   =      32745;
  OCR_CROSS                   =      32515;
  OCR_IBEAM                   =      32513;
  OCR_ICOCUR                  =      32647;
  OCR_ICON                    =      32641;
  OCR_NORMAL                  =      32512;
  OCR_SIZE                    =      32640;
  OCR_SIZEALL                 =      32646;
  OCR_SIZENESW                =      32643;
  OCR_SIZENS                  =      32645;
  OCR_SIZENWSE                =      32642;
  OCR_SIZEWE                  =      32644;
  OCR_UP                      =      32516;
  OCR_WAIT                    =      32514;
  ODA_DRAWENTIRE              =         1H;
  ODA_FOCUS                   =         4H;
  ODA_SELECT                  =         2H;
  ODS_CHECKED                 =         8H;
  ODS_DISABLED                =         4H;
  ODS_FOCUS                   =        10H;
  ODS_GRAYED                  =         2H;
  ODS_SELECTED                =         1H;
  ODT_BUTTON                  =          4;
  ODT_COMBOBOX                =          3;
  ODT_LISTBOX                 =          2;
  ODT_MENU                    =          1;
  OEM_CHARSET                 =        255;
  OEM_FIXED_FONT              =         10;
  OF_CANCEL                   =       800H;
  OF_CREATE                   =      1000H;
  OF_DELETE                   =       200H;
  OF_EXIST                    =      4000H;
  OF_PARSE                    =       100H;
  OF_PROMPT                   =      2000H;
  OF_READ                     =         0H;
  OF_READWRITE                =         2H;
  OF_REOPEN                   =     -32768 (*      8000H *);
  OF_SEARCH                   =       400H;
  OF_SHARE_COMPAT             =         0H;
  OF_SHARE_DENY_NONE          =        40H;
  OF_SHARE_DENY_READ          =        30H;
  OF_SHARE_DENY_WRITE         =        20H;
  OF_SHARE_EXCLUSIVE          =        10H;
  OF_VERIFY                   =       400H;
  OF_WRITE                    =         1H;
  OIC_BANG                    =      32515;
  OIC_HAND                    =      32513;
  OIC_NOTE                    =      32516;
  OIC_QUES                    =      32514;
  OIC_SAMPLE                  =      32512;
  OUT_CHARACTER_PRECIS        =          2;
  OUT_DEFAULT_PRECIS          =          0;
  OUT_DEVICE_PRECIS           =          5;
  OUT_RASTER_PRECIS           =          6;
  OUT_STRING_PRECIS           =          1;
  OUT_STROKE_PRECIS           =          3;
  OUT_TT_ONLY_PRECIS          =          7;
  OUT_TT_PRECIS               =          4;
  PC_EXPLICIT                 =         2H;
  PC_INTERIORS                =        80H;
  PC_NOCOLLAPSE               =         4H;
  PC_NONE                     =         0H;
  PC_POLYGON                  =         1H;
  PC_RECTANGLE                =         2H;
  PC_RESERVED                 =         1H;
  PC_SCANLINE                 =         8H;
  PC_STYLED                   =        20H;
  PC_WIDE                     =        10H;
  PC_WIDESTYLED               =        40H;
  PC_WINDPOLYGON              =         4H;
  PM_NOREMOVE                 =         0H;
  PM_NOYIELD                  =         2H;
  PM_REMOVE                   =         1H;
  POSTSCRIPT_DATA             =         37;
  POSTSCRIPT_IGNORE           =         38;
  PROOF_QUALITY               =          2;
  PR_JOBSTATUS                =         0H;
  PS_DASH                     =          1;
  PS_DASHDOT                  =          3;
  PS_DASHDOTDOT               =          4;
  PS_DOT                      =          2;
  PS_INSIDEFRAME              =          6;
  PS_NULL                     =          5;
  PS_SOLID                    =          0;
  PWR_CRITICALRESUME          =          3;
  PWR_FAIL                    =         -1;
  PWR_OK                      =          1;
  PWR_SUSPENDREQUEST          =          1;
  PWR_SUSPENDRESUME           =          2;
  QS_ALLINPUT                 =        7FH;
  QS_KEY                      =         1H;
  QS_MOUSE                    =         6H;
  QS_MOUSEBUTTON              =         4H;
  QS_MOUSEMOVE                =         2H;
  QS_PAINT                    =        20H;
  QS_POSTMESSAGE              =         8H;
  QS_SENDMESSAGE              =        40H;
  QS_TIMER                    =        10H;
  R2_BLACK                    =          1;
  R2_COPYPEN                  =         13;
  R2_MASKNOTPEN               =          3;
  R2_MASKPEN                  =          9;
  R2_MASKPENNOT               =          5;
  R2_MERGENOTPEN              =         12;
  R2_MERGEPEN                 =         15;
  R2_MERGEPENNOT              =         14;
  R2_NOP                      =         11;
  R2_NOT                      =          6;
  R2_NOTCOPYPEN               =          4;
  R2_NOTMASKPEN               =          8;
  R2_NOTMERGEPEN              =          2;
  R2_NOTXORPEN                =         10;
  R2_WHITE                    =         16;
  R2_XORPEN                   =          7;
  RASTER_FONTTYPE             =         1H;
  RC_BANDING                  =         2H;
  RC_BIGFONT                  =       400H;
  RC_BITBLT                   =         1H;
  RC_BITMAP64                 =         8H;
  RC_DEVBITS                  =     -32768 (*      8000H *);
  RC_DIBTODEV                 =       200H;
  RC_DI_BITMAP                =        80H;
  RC_FLOODFILL                =      1000H;
  RC_GDI20_OUTPUT             =        10H;
  RC_GDI20_STATE              =        20H;
  RC_OP_DX_OUTPUT             =      4000H;
  RC_PALETTE                  =       100H;
  RC_SAVEBITMAP               =        40H;
  RC_SCALING                  =         4H;
  RC_STRETCHBLT               =       800H;
  RC_STRETCHDIB               =      2000H;
  RDW_ALLCHILDREN             =        80H;
  RDW_ERASE                   =         4H;
  RDW_ERASENOW                =       200H;
  RDW_FRAME                   =       400H;
  RDW_INTERNALPAINT           =         2H;
  RDW_INVALIDATE              =         1H;
  RDW_NOCHILDREN              =        40H;
  RDW_NOERASE                 =        20H;
  RDW_NOFRAME                 =       800H;
  RDW_NOINTERNALPAINT         =        10H;
  RDW_UPDATENOW               =       100H;
  RDW_VALIDATE                =         8H;
  READ_WRITE                  =          2;
  RESTORE_CTM                 =       4100;
  RGN_AND                     =          1;
  RGN_COPY                    =          5;
  RGN_DIFF                    =          4;
  RGN_OR                      =          2;
  RGN_XOR                     =          3;
  RT_ACCELERATOR              =          9;
  RT_BITMAP                   =          2;
  RT_CURSOR                   =          1;
  RT_DIALOG                   =          5;
  RT_FONT                     =          8;
  RT_FONTDIR                  =          7;
  RT_GROUP_CURSOR             =         12;
  RT_GROUP_ICON               =         14;
  RT_ICON                     =          3;
  RT_MENU                     =          4;
  RT_RCDATA                   =         10;
  RT_STRING                   =          6;
  SAVE_CTM                    =       4101;
  SBS_BOTTOMALIGN             =         4H;
  SBS_HORZ                    =         0H;
  SBS_LEFTALIGN               =         2H;
  SBS_RIGHTALIGN              =         4H;
  SBS_SIZEBOX                 =         8H;
  SBS_SIZEBOXBOTTOMRIGHTALIGN =         4H;
  SBS_SIZEBOXTOPLEFTALIGN     =         2H;
  SBS_TOPALIGN                =         2H;
  SBS_VERT                    =         1H;
  SB_BOTH                     =          3;
  SB_BOTTOM                   =          7;
  SB_CTL                      =          2;
  SB_ENDSCROLL                =          8;
  SB_HORZ                     =          0;
  SB_LEFT                     =          6;
  SB_LINEDOWN                 =          1;
  SB_LINELEFT                 =          0;
  SB_LINERIGHT                =          1;
  SB_LINEUP                   =          0;
  SB_PAGEDOWN                 =          3;
  SB_PAGELEFT                 =          2;
  SB_PAGERIGHT                =          3;
  SB_PAGEUP                   =          2;
  SB_RIGHT                    =          7;
  SB_THUMBPOSITION            =          4;
  SB_THUMBTRACK               =          5;
  SB_TOP                      =          6;
  SB_VERT                     =          1;
  SC_ARRANGE                  =      -3824 (*     0F110H *);
  SC_CLOSE                    =      -4000 (*     0F060H *);
  SC_HOTKEY                   =      -3760 (*     0F150H *);
  SC_HSCROLL                  =      -3968 (*     0F080H *);
  SC_ICON                     =      -4064 (*     0F020H *);
  SC_KEYMENU                  =      -3840 (*     0F100H *);
  SC_MAXIMIZE                 =      -4048 (*     0F030H *);
  SC_MINIMIZE                 =      -4064 (*     0F020H *);
  SC_MOUSEMENU                =      -3952 (*     0F090H *);
  SC_MOVE                     =      -4080 (*     0F010H *);
  SC_NEXTWINDOW               =      -4032 (*     0F040H *);
  SC_PREVWINDOW               =      -4016 (*     0F050H *);
  SC_RESTORE                  =      -3808 (*     0F120H *);
  SC_SCREENSAVE               =      -3776 (*     0F140H *);
  SC_SIZE                     =      -4096 (*     0F000H *);
  SC_TASKLIST                 =      -3792 (*     0F130H *);
  SC_VSCROLL                  =      -3984 (*     0F070H *);
  SC_ZOOM                     =      -4048 (*     0F030H *);
  SDS_DIALOG                  =         8H;
  SDS_MENU                    =         1H;
  SDS_NOTASKQUEUE             =         4H;
  SDS_SYSMODAL                =         2H;
  SDS_TASKLOCKED              =        10H;
  SEEK_CUR                    =          1;
  SEEK_END                    =          2;
  SEEK_SET                    =          0;
  SEM_FAILCRITICALERRORS      =         1H;
  SEM_NOGPFAULTERRORBOX       =         2H;
  SEM_NOOPENFILEERRORBOX      =     -32768 (*      8000H *);
  SET_ARC_DIRECTION           =       4102;
  SET_BACKGROUND_COLOR        =       4103;
  SET_BOUNDS                  =       4109;
  SET_CLIP_BOX                =       4108;
  SET_POLY_MODE               =       4104;
  SET_SCREEN_ANGLE            =       4105;
  SET_SPREAD                  =       4106;
  SHIFTJIS_CHARSET            =        128;
  SHOW_FULLSCREEN             =          3;
  SHOW_ICONWINDOW             =          2;
  SHOW_OPENNOACTIVATE         =          4;
  SHOW_OPENWINDOW             =          1;
  SIZE_MAXHIDE                =          4;
  SIZE_MAXIMIZED              =          2;
  SIZE_MAXSHOW                =          3;
  SIZE_MINIMIZED              =          1;
  SIZE_RESTORED               =          0;
  SM_CMETRICS                 =         43;
  SM_CXBORDER                 =          5;
  SM_CXCURSOR                 =         13;
  SM_CXDLGFRAME               =          7;
  SM_CXDOUBLECLK              =         36;
  SM_CXFRAME                  =         32;
  SM_CXFULLSCREEN             =         16;
  SM_CXHSCROLL                =         21;
  SM_CXHTHUMB                 =         10;
  SM_CXICON                   =         11;
  SM_CXICONSPACING            =         38;
  SM_CXMIN                    =         28;
  SM_CXMINTRACK               =         34;
  SM_CXSCREEN                 =          0;
  SM_CXSIZE                   =         30;
  SM_CXVSCROLL                =          2;
  SM_CYBORDER                 =          6;
  SM_CYCAPTION                =          4;
  SM_CYCURSOR                 =         14;
  SM_CYDLGFRAME               =          8;
  SM_CYDOUBLECLK              =         37;
  SM_CYFRAME                  =         33;
  SM_CYFULLSCREEN             =         17;
  SM_CYHSCROLL                =          3;
  SM_CYICON                   =         12;
  SM_CYICONSPACING            =         39;
  SM_CYKANJIWINDOW            =         18;
  SM_CYMENU                   =         15;
  SM_CYMIN                    =         29;
  SM_CYMINTRACK               =         35;
  SM_CYSCREEN                 =          1;
  SM_CYSIZE                   =         31;
  SM_CYVSCROLL                =         20;
  SM_CYVTHUMB                 =          9;
  SM_DBCSENABLED              =         42;
  SM_DEBUG                    =         22;
  SM_MENUDROPALIGNMENT        =         40;
  SM_MOUSEPRESENT             =         19;
  SM_PENWINDOWS               =         41;
  SM_RESERVED1                =         24;
  SM_RESERVED2                =         25;
  SM_RESERVED3                =         26;
  SM_RESERVED4                =         27;
  SM_SWAPBUTTON               =         23;
  SPIF_SENDWININICHANGE       =         2H;
  SPIF_UPDATEINIFILE          =         1H;
  SPI_GETBEEP                 =          1;
  SPI_GETBORDER               =          5;
  SPI_GETFASTTASKSWITCH       =         35;
  SPI_GETGRIDGRANULARITY      =         18;
  SPI_GETICONTITLELOGFONT     =         31;
  SPI_GETICONTITLEWRAP        =         25;
  SPI_GETKEYBOARDDELAY        =         22;
  SPI_GETKEYBOARDSPEED        =         10;
  SPI_GETMENUDROPALIGNMENT    =         27;
  SPI_GETMOUSE                =          3;
  SPI_GETSCREENSAVEACTIVE     =         16;
  SPI_GETSCREENSAVETIMEOUT    =         14;
  SPI_ICONHORIZONTALSPACING   =         13;
  SPI_ICONVERTICALSPACING     =         24;
  SPI_LANGDRIVER              =         12;
  SPI_SETBEEP                 =          2;
  SPI_SETBORDER               =          6;
  SPI_SETDESKPATTERN          =         21;
  SPI_SETDESKWALLPAPER        =         20;
  SPI_SETDOUBLECLICKTIME      =         32;
  SPI_SETDOUBLECLKHEIGHT      =         30;
  SPI_SETDOUBLECLKWIDTH       =         29;
  SPI_SETFASTTASKSWITCH       =         36;
  SPI_SETGRIDGRANULARITY      =         19;
  SPI_SETICONTITLELOGFONT     =         34;
  SPI_SETICONTITLEWRAP        =         26;
  SPI_SETKEYBOARDDELAY        =         23;
  SPI_SETKEYBOARDSPEED        =         11;
  SPI_SETMENUDROPALIGNMENT    =         28;
  SPI_SETMOUSE                =          4;
  SPI_SETMOUSEBUTTONSWAP      =         33;
  SPI_SETSCREENSAVEACTIVE     =         17;
  SPI_SETSCREENSAVETIMEOUT    =         15;
  SP_APPABORT                 =         -2;
  SP_ERROR                    =         -1;
  SP_NOTREPORTED              =      4000H;
  SP_OUTOFDISK                =         -4;
  SP_OUTOFMEMORY              =         -5;
  SP_USERABORT                =         -3;
  SS_BLACKFRAME               =         7H;
  SS_BLACKRECT                =         4H;
  SS_CENTER                   =         1H;
  SS_GRAYFRAME                =         8H;
  SS_GRAYRECT                 =         5H;
  SS_ICON                     =         3H;
  SS_LEFT                     =         0H;
  SS_LEFTNOWORDWRAP           =        0CH;
  SS_NOPREFIX                 =        80H;
  SS_RIGHT                    =         2H;
  SS_SIMPLE                   =        0BH;
  SS_WHITEFRAME               =         9H;
  SS_WHITERECT                =         6H;
  STM_GETICON                 =       401H;
  STM_SETICON                 =       400H;
  STRETCH_ANDSCANS            =          1;
  STRETCH_DELETESCANS         =          3;
  STRETCH_ORSCANS             =          2;
  SWP_DEFERERASE              =      2000H;
  SWP_DRAWFRAME               =        20H;
  SWP_FRAMECHANGED            =        20H;
  SWP_HIDEWINDOW              =        80H;
  SWP_NOACTIVATE              =        10H;
  SWP_NOCOPYBITS              =       100H;
  SWP_NOMOVE                  =         2H;
  SWP_NOOWNERZORDER           =       200H;
  SWP_NOREDRAW                =         8H;
  SWP_NOREPOSITION            =       200H;
  SWP_NOSENDCHANGING          =       400H;
  SWP_NOSIZE                  =         1H;
  SWP_NOZORDER                =         4H;
  SWP_SHOWWINDOW              =        40H;
  SW_ERASE                    =         4H;
  SW_HIDE                     =          0;
  SW_INVALIDATE               =         2H;
  SW_MAXIMIZE                 =          3;
  SW_MINIMIZE                 =          6;
  SW_NORMAL                   =          1;
  SW_OTHERMAXIMIZED           =          2;
  SW_OTHERRESTORED            =          4;
  SW_OTHERUNZOOM              =          4;
  SW_OTHERZOOM                =          2;
  SW_PARENTCLOSING            =          1;
  SW_PARENTOPENING            =          3;
  SW_RESTORE                  =          9;
  SW_SCROLLCHILDREN           =         1H;
  SW_SHOW                     =          5;
  SW_SHOWMAXIMIZED            =          3;
  SW_SHOWMINIMIZED            =          2;
  SW_SHOWMINNOACTIVE          =          7;
  SW_SHOWNA                   =          8;
  SW_SHOWNOACTIVATE           =          4;
  SW_SHOWNORMAL               =          1;
  SYMBOL_CHARSET              =          2;
  SYSPAL_NOSTATIC             =          2;
  SYSPAL_STATIC               =          1;
  SYSTEM_FIXED_FONT           =         16;
  SYSTEM_FONT                 =         13;
  S_ALLTHRESHOLD              =          2;
  S_LEGATO                    =          1;
  S_NORMAL                    =          0;
  S_PERIOD1024                =          1;
  S_PERIOD2048                =          2;
  S_PERIOD512                 =          0;
  S_PERIODVOICE               =          3;
  S_QUEUEEMPTY                =          0;
  S_SERBDNT                   =         -5;
  S_SERDCC                    =         -7;
  S_SERDDR                    =        -14;
  S_SERDFQ                    =        -13;
  S_SERDLN                    =         -6;
  S_SERDMD                    =        -10;
  S_SERDPT                    =        -12;
  S_SERDSH                    =        -11;
  S_SERDSR                    =        -15;
  S_SERDST                    =        -16;
  S_SERDTP                    =         -8;
  S_SERDVL                    =         -9;
  S_SERDVNA                   =         -1;
  S_SERMACT                   =         -3;
  S_SEROFM                    =         -2;
  S_SERQFUL                   =         -4;
  S_STACCATO                  =          2;
  S_THRESHOLD                 =          1;
  S_WHITE1024                 =          5;
  S_WHITE2048                 =          6;
  S_WHITE512                  =          4;
  S_WHITEVOICE                =          7;
  TA_BASELINE                 =        18H;
  TA_BOTTOM                   =         8H;
  TA_CENTER                   =         6H;
  TA_LEFT                     =         0H;
  TA_NOUPDATECP               =         0H;
  TA_RIGHT                    =         2H;
  TA_TOP                      =         0H;
  TA_UPDATECP                 =         1H;
  TC_CP_STROKE                =         4H;
  TC_CR_90                    =         8H;
  TC_CR_ANY                   =        10H;
  TC_EA_DOUBLE                =       200H;
  TC_IA_ABLE                  =       400H;
  TC_OP_CHARACTER             =         1H;
  TC_OP_STROKE                =         2H;
  TC_RA_ABLE                  =      2000H;
  TC_RESERVED                 =     -32768 (*      8000H *);
  TC_SA_CONTIN                =       100H;
  TC_SA_DOUBLE                =        40H;
  TC_SA_INTEGER               =        80H;
  TC_SF_X_YINDEP              =        20H;
  TC_SO_ABLE                  =      1000H;
  TC_UA_ABLE                  =       800H;
  TC_VA_ABLE                  =      4000H;
  TF_FORCEDRIVE               =        80H;
  TMPF_DEVICE                 =         8H;
  TMPF_FIXED_PITCH            =         1H;
  TMPF_TRUETYPE               =         4H;
  TMPF_VECTOR                 =         2H;
  TPM_CENTERALIGN             =         4H;
  TPM_LEFTALIGN               =         0H;
  TPM_LEFTBUTTON              =         0H;
  TPM_RIGHTALIGN              =         8H;
  TPM_RIGHTBUTTON             =         2H;
  TRANSFORM_CTM               =       4107;
  TRUETYPE_FONTTYPE           =         4H;
  TT_AVAILABLE                =         1H;
  TT_ENABLED                  =         2H;
  TT_POLYGON_TYPE             =         24;
  TT_PRIM_LINE                =          1;
  TT_PRIM_QSPLINE             =          2;
  VARIABLE_PITCH              =         2H;
  VK_ADD                      =        6BH;
  VK_BACK                     =         8H;
  VK_CANCEL                   =         3H;
  VK_CAPITAL                  =        14H;
  VK_CLEAR                    =        0CH;
  VK_CONTROL                  =        11H;
  VK_DECIMAL                  =        6EH;
  VK_DELETE                   =        2EH;
  VK_DIVIDE                   =        6FH;
  VK_DOWN                     =        28H;
  VK_END                      =        23H;
  VK_ESCAPE                   =        1BH;
  VK_EXECUTE                  =        2BH;
  VK_F1                       =        70H;
  VK_F10                      =        79H;
  VK_F11                      =        7AH;
  VK_F12                      =        7BH;
  VK_F13                      =        7CH;
  VK_F14                      =        7DH;
  VK_F15                      =        7EH;
  VK_F16                      =        7FH;
  VK_F17                      =        80H;
  VK_F18                      =        81H;
  VK_F19                      =        82H;
  VK_F2                       =        71H;
  VK_F20                      =        83H;
  VK_F21                      =        84H;
  VK_F22                      =        85H;
  VK_F23                      =        86H;
  VK_F24                      =        87H;
  VK_F3                       =        72H;
  VK_F4                       =        73H;
  VK_F5                       =        74H;
  VK_F6                       =        75H;
  VK_F7                       =        76H;
  VK_F8                       =        77H;
  VK_F9                       =        78H;
  VK_HELP                     =        2FH;
  VK_HOME                     =        24H;
  VK_INSERT                   =        2DH;
  VK_LBUTTON                  =         1H;
  VK_LEFT                     =        25H;
  VK_MBUTTON                  =         4H;
  VK_MENU                     =        12H;
  VK_MULTIPLY                 =        6AH;
  VK_NEXT                     =        22H;
  VK_NUMLOCK                  =        90H;
  VK_NUMPAD0                  =        60H;
  VK_NUMPAD1                  =        61H;
  VK_NUMPAD2                  =        62H;
  VK_NUMPAD3                  =        63H;
  VK_NUMPAD4                  =        64H;
  VK_NUMPAD5                  =        65H;
  VK_NUMPAD6                  =        66H;
  VK_NUMPAD7                  =        67H;
  VK_NUMPAD8                  =        68H;
  VK_NUMPAD9                  =        69H;
  VK_PAUSE                    =        13H;
  VK_PRINT                    =        2AH;
  VK_PRIOR                    =        21H;
  VK_RBUTTON                  =         2H;
  VK_RETURN                   =        0DH;
  VK_RIGHT                    =        27H;
  VK_SCROLL                   =        91H;
  VK_SELECT                   =        29H;
  VK_SEPARATOR                =        6CH;
  VK_SHIFT                    =        10H;
  VK_SNAPSHOT                 =        2CH;
  VK_SPACE                    =        20H;
  VK_SUBTRACT                 =        6DH;
  VK_TAB                      =         9H;
  VK_UP                       =        26H;
  WA_ACTIVE                   =          1;
  WA_CLICKACTIVE              =          2;
  WA_INACTIVE                 =          0;
  WB_ISDELIMITER              =          2;
  WB_LEFT                     =          0;
  WB_RIGHT                    =          1;
  WC_DIALOG                   =     -32766 (*      8002H *);
  WDI_ALLOCBREAK              =         4H;
  WDI_FILTER                  =         2H;
  WDI_OPTIONS                 =         1H;
  WEP_FREE_DLL                =          0;
  WEP_SYSTEM_EXIT             =          1;
  WF_80x87                    =       400H;
  WF_CPU086                   =        40H;
  WF_CPU186                   =        80H;
  WF_CPU286                   =         2H;
  WF_CPU386                   =         4H;
  WF_CPU486                   =         8H;
  WF_ENHANCED                 =        20H;
  WF_LARGEFRAME               =       100H;
  WF_PAGING                   =       800H;
  WF_PMODE                    =         1H;
  WF_SMALLFRAME               =       200H;
  WF_STANDARD                 =        10H;
  WF_WIN286                   =        10H;
  WF_WIN386                   =        20H;
  WF_WLO                      =     -32768 (*      8000H *);
  WHITE_BRUSH                 =          0;
  WHITE_PEN                   =          6;
  WH_CALLWNDPROC              =          4;
  WH_CBT                      =          5;
  WH_DEBUG                    =          9;
  WH_GETMESSAGE               =          3;
  WH_HARDWARE                 =          8;
  WH_JOURNALPLAYBACK          =          1;
  WH_JOURNALRECORD            =          0;
  WH_KEYBOARD                 =          2;
  WH_MOUSE                    =          7;
  WH_MSGFILTER                =         -1;
  WH_SHELL                    =         10;
  WH_SYSMSGFILTER             =          6;
  WM_ACTIVATE                 =         6H;
  WM_ACTIVATEAPP              =        1CH;
  WM_ASKCBFORMATNAME          =       30CH;
  WM_CANCELMODE               =        1FH;
  WM_CHANGECBCHAIN            =       30DH;
  WM_CHAR                     =       102H;
  WM_CHARTOITEM               =        2FH;
  WM_CHILDACTIVATE            =        22H;
  WM_CLEAR                    =       303H;
  WM_CLOSE                    =        10H;
  WM_COALESCE_FIRST           =       390H;
  WM_COALESCE_LAST            =       39FH;
  WM_COMMAND                  =       111H;
  WM_COMMNOTIFY               =        44H;
  WM_COMPACTING               =        41H;
  WM_COMPAREITEM              =        39H;
  WM_COPY                     =       301H;
  WM_CREATE                   =         1H;
  WM_CTLCOLOR                 =        19H;
  WM_CUT                      =       300H;
  WM_DEADCHAR                 =       103H;
  WM_DELETEITEM               =        2DH;
  WM_DESTROY                  =         2H;
  WM_DESTROYCLIPBOARD         =       307H;
  WM_DEVMODECHANGE            =        1BH;
  WM_DRAWCLIPBOARD            =       308H;
  WM_DRAWITEM                 =        2BH;
  WM_DROPFILES                =       233H;
  WM_ENABLE                   =        0AH;
  WM_ENDSESSION               =        16H;
  WM_ENTERIDLE                =       121H;
  WM_ERASEBKGND               =        14H;
  WM_FONTCHANGE               =        1DH;
  WM_GETDLGCODE               =        87H;
  WM_GETFONT                  =        31H;
  WM_GETMINMAXINFO            =        24H;
  WM_GETTEXT                  =        0DH;
  WM_GETTEXTLENGTH            =        0EH;
  WM_HSCROLL                  =       114H;
  WM_HSCROLLCLIPBOARD         =       30EH;
  WM_ICONERASEBKGND           =        27H;
  WM_INITDIALOG               =       110H;
  WM_INITMENU                 =       116H;
  WM_INITMENUPOPUP            =       117H;
  WM_KEYDOWN                  =       100H;
  WM_KEYFIRST                 =       100H;
  WM_KEYLAST                  =       108H;
  WM_KEYUP                    =       101H;
  WM_KILLFOCUS                =         8H;
  WM_LBUTTONDBLCLK            =       203H;
  WM_LBUTTONDOWN              =       201H;
  WM_LBUTTONUP                =       202H;
  WM_MBUTTONDBLCLK            =       209H;
  WM_MBUTTONDOWN              =       207H;
  WM_MBUTTONUP                =       208H;
  WM_MDIACTIVATE              =       222H;
  WM_MDICASCADE               =       227H;
  WM_MDICREATE                =       220H;
  WM_MDIDESTROY               =       221H;
  WM_MDIGETACTIVE             =       229H;
  WM_MDIICONARRANGE           =       228H;
  WM_MDIMAXIMIZE              =       225H;
  WM_MDINEXT                  =       224H;
  WM_MDIRESTORE               =       223H;
  WM_MDISETMENU               =       230H;
  WM_MDITILE                  =       226H;
  WM_MEASUREITEM              =        2CH;
  WM_MENUCHAR                 =       120H;
  WM_MENUSELECT               =       11FH;
  WM_MOUSEACTIVATE            =        21H;
  WM_MOUSEFIRST               =       200H;
  WM_MOUSELAST                =       209H;
  WM_MOUSEMOVE                =       200H;
  WM_MOVE                     =         3H;
  WM_NCACTIVATE               =        86H;
  WM_NCCALCSIZE               =        83H;
  WM_NCCREATE                 =        81H;
  WM_NCDESTROY                =        82H;
  WM_NCHITTEST                =        84H;
  WM_NCLBUTTONDBLCLK          =       0A3H;
  WM_NCLBUTTONDOWN            =       0A1H;
  WM_NCLBUTTONUP              =       0A2H;
  WM_NCMBUTTONDBLCLK          =       0A9H;
  WM_NCMBUTTONDOWN            =       0A7H;
  WM_NCMBUTTONUP              =       0A8H;
  WM_NCMOUSEMOVE              =       0A0H;
  WM_NCPAINT                  =        85H;
  WM_NCRBUTTONDBLCLK          =       0A6H;
  WM_NCRBUTTONDOWN            =       0A4H;
  WM_NCRBUTTONUP              =       0A5H;
  WM_NEXTDLGCTL               =        28H;
  WM_NULL                     =         0H;
  WM_PAINT                    =        0FH;
  WM_PAINTCLIPBOARD           =       309H;
  WM_PALETTECHANGED           =       311H;
  WM_PALETTEISCHANGING        =       310H;
  WM_PARENTNOTIFY             =       210H;
  WM_PASTE                    =       302H;
  WM_PENWINFIRST              =       380H;
  WM_PENWINLAST               =       38FH;
  WM_POWER                    =        48H;
  WM_QUERYDRAGICON            =        37H;
  WM_QUERYENDSESSION          =        11H;
  WM_QUERYNEWPALETTE          =       30FH;
  WM_QUERYOPEN                =        13H;
  WM_QUEUESYNC                =        23H;
  WM_QUIT                     =        12H;
  WM_RBUTTONDBLCLK            =       206H;
  WM_RBUTTONDOWN              =       204H;
  WM_RBUTTONUP                =       205H;
  WM_RENDERALLFORMATS         =       306H;
  WM_RENDERFORMAT             =       305H;
  WM_SETCURSOR                =        20H;
  WM_SETFOCUS                 =         7H;
  WM_SETFONT                  =        30H;
  WM_SETREDRAW                =        0BH;
  WM_SETTEXT                  =        0CH;
  WM_SHOWWINDOW               =        18H;
  WM_SIZE                     =         5H;
  WM_SIZECLIPBOARD            =       30BH;
  WM_SPOOLERSTATUS            =        2AH;
  WM_SYSCHAR                  =       106H;
  WM_SYSCOLORCHANGE           =        15H;
  WM_SYSCOMMAND               =       112H;
  WM_SYSDEADCHAR              =       107H;
  WM_SYSKEYDOWN               =       104H;
  WM_SYSKEYUP                 =       105H;
  WM_SYSTEMERROR              =        17H;
  WM_TIMECHANGE               =        1EH;
  WM_TIMER                    =       113H;
  WM_UNDO                     =       304H;
  WM_USER                     =       400H;
  WM_VKEYTOITEM               =        2EH;
  WM_VSCROLL                  =       115H;
  WM_VSCROLLCLIPBOARD         =       30AH;
  WM_WINDOWPOSCHANGED         =        47H;
  WM_WINDOWPOSCHANGING        =        46H;
  WM_WININICHANGE             =        1AH;
  WN_ACCESS_DENIED            =         7H;
  WN_ALREADY_CONNECTED        =        34H;
  WN_BAD_LOCALNAME            =        33H;
  WN_BAD_NETNAME              =        32H;
  WN_BAD_PASSWORD             =         6H;
  WN_BAD_POINTER              =         4H;
  WN_BAD_USER                 =        0AH;
  WN_BAD_VALUE                =         5H;
  WN_CANCEL                   =        0CH;
  WN_CONNECTION_CLOSED        =        36H;
  WN_CONTINUE                 =        0DH;
  WN_DEVICE_ERROR             =        35H;
  WN_FUNCTION_BUSY            =         8H;
  WN_MORE_DATA                =         3H;
  WN_NET_ERROR                =         2H;
  WN_NOT_CONNECTED            =        30H;
  WN_NOT_SUPPORTED            =         1H;
  WN_OPEN_FILES               =        31H;
  WN_OUT_OF_MEMORY            =        0BH;
  WN_SUCCESS                  =         0H;
  WN_WINDOWS_ERROR            =         9H;
  WPF_RESTORETOMAXIMIZED      =         2H;
  WPF_SETMINPOSITION          =         1H;
  WS_BORDER                   =    800000H;
  WS_CAPTION                  =   0C00000H;
  WS_CHILD                    =  40000000H;
  WS_CHILDWINDOW              =  40000000H;
  WS_CLIPCHILDREN             =   2000000H;
  WS_CLIPSIBLINGS             =   4000000H;
  WS_DISABLED                 =   8000000H;
  WS_DLGFRAME                 =    400000H;
  WS_EX_ACCEPTFILES           =        10H;
  WS_EX_DLGMODALFRAME         =         1H;
  WS_EX_NOPARENTNOTIFY        =         4H;
  WS_EX_TOPMOST               =         8H;
  WS_EX_TRANSPARENT           =        20H;
  WS_GROUP                    =     20000H;
  WS_HSCROLL                  =    100000H;
  WS_ICONIC                   =  20000000H;
  WS_MAXIMIZE                 =   1000000H;
  WS_MAXIMIZEBOX              =     10000H;
  WS_MINIMIZE                 =  20000000H;
  WS_MINIMIZEBOX              =     20000H;
  WS_OVERLAPPED               =         0H;
  WS_OVERLAPPEDWINDOW         =   0CF0000H;
  WS_SYSMENU                  =     80000H;
  WS_POPUP                    = MIN(LONGINT); (* 80000000H *)
  WS_POPUPWINDOW              =  WS_POPUP + WS_BORDER + WS_SYSMENU;
  WS_SIZEBOX                  =     40000H;
  WS_TABSTOP                  =     10000H;
  WS_THICKFRAME               =     40000H;
  WS_TILED                    =         0H;
  WS_TILEDWINDOW              =   0CF0000H;
  WS_VISIBLE                  =  10000000H;
  WS_VSCROLL                  =    200000H;
  WVR_ALIGNBOTTOM             =        40H;
  WVR_ALIGNLEFT               =        20H;
  WVR_ALIGNRIGHT              =        80H;
  WVR_ALIGNTOP                =        10H;
  WVR_HREDRAW                 =       100H;
  WVR_REDRAW                  =       300H;
  WVR_VALIDRECTS              =       400H;
  WVR_VREDRAW                 =       200H;

TYPE
  BYTE = SHORTINT;
  WORD = INTEGER;
  DWORD = LONGINT;
  BOOL = INTEGER;
  ADR = LONGINT;
  PSTR = LONGINT;
  LPSTR = LONGINT;
  LPCSTR = LONGINT;
  FARPROC = LONGINT;
  SHORINT = BYTE;
  UINT = WORD;

  ATOM = UINT;
  CATCHBUF = ARRAY 9 OF INTEGER;
  COLORREF = DWORD;
  GLOBALHANDLE = UINT;
  HACCEL = UINT;
  HANDLE = UINT;
  HBITMAP = UINT;
  HBRUSH = UINT;
  HCURSOR = UINT;
  HDC = UINT;
  HDRVR = UINT;
  HDWP = UINT;
  HFILE = INTEGER;
  HFONT = UINT;
  HGDIOBJ = UINT;
  HGLOBAL = HANDLE;
  HHOOK = DWORD;
  HICON = UINT;
  HINSTANCE = UINT;
  HLOCAL = HANDLE;
  HMENU = UINT;
  HMETAFILE = UINT;
  HMODULE = HINSTANCE;
  HPALETTE = UINT;
  HPEN = UINT;
  HRGN = UINT;
  HRSRC = UINT;
  HSTR = UINT;
  HTASK = UINT;
  HWND = UINT;
  LOCALHANDLE = HANDLE;
  LPARAM = LONGINT;
  LRESULT = LONGINT;
  WPARAM = UINT;
  WNDPROC=PROCEDURE [WINDOWS] (hInst:HWND; message: WORD; wParam: WORD; lParam: LONGINT):LONGINT;
  DLGPROC=PROCEDURE [WINDOWS] (hDlg: HWND; message: WORD; wParam: WORD; lParam: LONGINT): BOOL;

  WINDEBUGINFO = RECORD [WINDOWS]
    flags: UINT;
    dwOptions: DWORD;
    dwFilter: DWORD;
    achAllocModule: ARRAY 8 OF CHAR;
    dwAllocBreak: DWORD;
    dwAllocCount: DWORD;
  END;

  SEGINFO = RECORD [WINDOWS]
    offSegment: UINT;
    cbSegment: UINT;
    flags: UINT;
    cbAlloc: UINT;
    h: HGLOBAL;
    alignShift: UINT;
    reserved: ARRAY 2 OF UINT;
  END;

  OFSTRUCT = RECORD [WINDOWS]
    cBytes: BYTE;
    fFixedDisk: BYTE;
    nErrCode: UINT;
    reserved: ARRAY 4 OF BYTE;
    szPathName: ARRAY 128 OF CHAR;
  END;

  RECT = RECORD [WINDOWS]
    left: INTEGER;
    top: INTEGER;
    right: INTEGER;
    bottom: INTEGER;
  END;

  POINT = RECORD [WINDOWS]
    x: INTEGER;
    y: INTEGER;
  END;

  SIZE = RECORD [WINDOWS]
    cx: INTEGER;
    cy: INTEGER;
  END;

  LOGPEN = RECORD [WINDOWS]
    lopnStyle: UINT;
    lopnWidth: POINT;
    lopnColor: COLORREF;
  END;

  LOGBRUSH = RECORD [WINDOWS]
    lbStyle: UINT;
    lbColor: COLORREF;
    lbHatch: INTEGER;
  END;

  PALETTEENTRY = RECORD [WINDOWS]
    peRed: BYTE;
    peGreen: BYTE;
    peBlue: BYTE;
    peFlags: BYTE;
  END;

  LOGPALETTE = RECORD [WINDOWS]
    palVersion: WORD;
    palNumEntries: WORD;
    palPalEntry: ARRAY 1 OF PALETTEENTRY;
  END;

  LOGPALETTE2 = RECORD [WINDOWS]
    palVersion: WORD;
    palNumEntries: WORD;
    palPalEntry: ARRAY 2 OF PALETTEENTRY;
  END;

  LOGPALETTE16 = RECORD [WINDOWS]
    palVersion: WORD;
    palNumEntries: WORD;
    palPalEntry: ARRAY 16 OF PALETTEENTRY;
  END;

  LOGPALETTE256 = RECORD [WINDOWS]
    palVersion: WORD;
    palNumEntries: WORD;
    palPalEntry: ARRAY 256 OF PALETTEENTRY;
  END;

  LOGFONT = RECORD [WINDOWS]
    lfHeight: INTEGER;
    lfWidth: INTEGER;
    lfEscapement: INTEGER;
    lfOrientation: INTEGER;
    lfWeight: INTEGER;
    lfItalic: BYTE;
    lfUnderline: BYTE;
    lfStrikeOut: BYTE;
    lfCharSet: BYTE;
    lfOutPrecision: BYTE;
    lfClipPrecision: BYTE;
    lfQuality: BYTE;
    lfPitchAndFamily: BYTE;
    lfFaceName: ARRAY 32 OF CHAR;
  END;

  TEXTMETRIC = RECORD [WINDOWS]
    tmHeight: INTEGER;
    tmAscent: INTEGER;
    tmDescent: INTEGER;
    tmInternalLeading: INTEGER;
    tmExternalLeading: INTEGER;
    tmAveCharWidth: INTEGER;
    tmMaxCharWidth: INTEGER;
    tmWeight: INTEGER;
    tmItalic: BYTE;
    tmUnderlined: BYTE;
    tmStruckOut: BYTE;
    tmFirstChar: BYTE;
    tmLastChar: BYTE;
    tmDefaultChar: BYTE;
    tmBreakChar: BYTE;
    tmPitchAndFamily: BYTE;
    tmCharSet: BYTE;
    tmOverhang: INTEGER;
    tmDigitizedAspectX: INTEGER;
    tmDigitizedAspectY: INTEGER;
  END;

  PANOSE = RECORD [WINDOWS]
    bFamilyType: BYTE;
    bSerifStyle: BYTE;
    bWeight: BYTE;
    bProportion: BYTE;
    bContrast: BYTE;
    bStrokeVariation: BYTE;
    bArmStyle: BYTE;
    bLetterform: BYTE;
    bMidline: BYTE;
    bXHeight: BYTE;
  END;

  OUTLINETEXTMETRIC = RECORD [WINDOWS]
    otmSize: UINT;
    otmTextMetrics: TEXTMETRIC;
    otmFiller: BYTE;
    otmPanoseNumber: PANOSE;
    otmfsSelection: UINT;
    otmfsType: UINT;
    otmsCharSlopeRise: INTEGER;
    otmsCharSlopeRun: INTEGER;
    otmItalicAngle: INTEGER;
    otmEMSquare: UINT;
    otmAscent: INTEGER;
    otmDescent: INTEGER;
    otmLineGap: UINT;
    otmsCapEmHeight: UINT;
    otmsXHeight: UINT;
    otmrcFontBox: RECT;
    otmMacAscent: INTEGER;
    otmMacDescent: INTEGER;
    otmMacLineGap: UINT;
    otmusMinimumPPEM: UINT;
    otmptSubscriptSize: POINT;
    otmptSubscriptOffset: POINT;
    otmptSuperscriptSize: POINT;
    otmptSuperscriptOffset: POINT;
    otmsStrikeoutSize: UINT;
    otmsStrikeoutPosition: INTEGER;
    otmsUnderscorePosition: INTEGER;
    otmsUnderscoreSize: INTEGER;
    otmpFamilyName: PSTR;
    otmpFaceName: PSTR;
    otmpStyleName: PSTR;
    otmpFullName: PSTR;
  END;

  NEWTEXTMETRIC = RECORD [WINDOWS]
    tmHeight: INTEGER;
    tmAscent: INTEGER;
    tmDescent: INTEGER;
    tmInternalLeading: INTEGER;
    tmExternalLeading: INTEGER;
    tmAveCharWidth: INTEGER;
    tmMaxCharWidth: INTEGER;
    tmWeight: INTEGER;
    tmItalic: BYTE;
    tmUnderlined: BYTE;
    tmStruckOut: BYTE;
    tmFirstChar: BYTE;
    tmLastChar: BYTE;
    tmDefaultChar: BYTE;
    tmBreakChar: BYTE;
    tmPitchAndFamily: BYTE;
    tmCharSet: BYTE;
    tmOverhang: INTEGER;
    tmDigitizedAspectX: INTEGER;
    tmDigitizedAspectY: INTEGER;
    ntmFlags: DWORD;
    ntmSizeEM: UINT;
    ntmCellHeight: UINT;
    ntmAvgWidth: UINT;
  END;

  ENUMLOGFONT = RECORD [WINDOWS]
    elfLogFont: LOGFONT;
    elfFullName: ARRAY 64 OF CHAR;
    elfStyle: ARRAY 32 OF CHAR;
  END;

  GLYPHMETRICS = RECORD [WINDOWS]
    gmBlackBoxX: UINT;
    gmBlackBoxY: UINT;
    gmptGlyphOrigin: POINT;
    gmCellIncX: INTEGER;
    gmCellIncY: INTEGER;
  END;

  FIXED = RECORD [WINDOWS]
    fract: UINT;
    value: INTEGER;
  END;

  MAT2 = RECORD [WINDOWS]
    eM11: FIXED;
    eM12: FIXED;
    eM21: FIXED;
    eM22: FIXED;
  END;

  POINTFX = RECORD [WINDOWS]
    x: FIXED;
    y: FIXED;
  END;

  TTPOLYCURVE = RECORD [WINDOWS]
    wType: UINT;
    cpfx: UINT;
    apfx: ARRAY 1 OF POINTFX;
  END;

  TTPOLYGONHEADER = RECORD [WINDOWS]
    cb: DWORD;
    dwType: DWORD;
    pfxStart: POINTFX;
  END;

  ABC = RECORD [WINDOWS]
    abcA: INTEGER;
    abcB: UINT;
    abcC: INTEGER;
  END;

  KERNINGPAIR = RECORD [WINDOWS]
    wFirst: WORD;
    wSecond: WORD;
    iKernAmount: INTEGER;
  END;

  RASTERIZER_STATUS = RECORD [WINDOWS]
    nSize: INTEGER;
    wFlags: INTEGER;
    nLanguageID: INTEGER;
  END;

  BITMAP = RECORD [WINDOWS]
    bmType: INTEGER;
    bmWidth: INTEGER;
    bmHeight: INTEGER;
    bmWidthBytes: INTEGER;
    bmPlanes: BYTE;
    bmBitsPixel: BYTE;
    bmBits: ADR;
  END;

  RGBTRIPLE = RECORD [WINDOWS]
    rgbtBlue: BYTE;
    rgbtGreen: BYTE;
    rgbtRed: BYTE;
  END;

  RGBQUAD = RECORD [WINDOWS]
    rgbBlue: BYTE;
    rgbGreen: BYTE;
    rgbRed: BYTE;
    rgbReserved: BYTE;
  END;

  BITMAPCOREHEADER = RECORD [WINDOWS]
    bcSize: DWORD;
    bcWidth: SHORINT;
    bcHeight: SHORINT;
    bcPlanes: WORD;
    bcBitCount: WORD;
  END;

  BITMAPINFOHEADER = RECORD [WINDOWS]
    biSize: DWORD;
    biWidth: LONGINT;
    biHeight: LONGINT;
    biPlanes: WORD;
    biBitCount: WORD;
    biCompression: DWORD;
    biSizeImage: DWORD;
    biXPelsPerMeter: LONGINT;
    biYPelsPerMeter: LONGINT;
    biClrUsed: DWORD;
    biClrImportant: DWORD;
  END;

  BITMAPINFO = RECORD [WINDOWS]
    bmiHeader: BITMAPINFOHEADER;
    bmiColors: ARRAY 1 OF RGBQUAD;
  END;

  BITMAPINFO2 = RECORD [WINDOWS]
    bmiHeader: BITMAPINFOHEADER;
    bmiColors: ARRAY 2 OF RGBQUAD;
  END;

  BITMAPINFO16 = RECORD [WINDOWS]
    bmiHeader: BITMAPINFOHEADER;
    bmiColors: ARRAY 16 OF RGBQUAD;
  END;

  BITMAPINFO256 = RECORD [WINDOWS]
    bmiHeader: BITMAPINFOHEADER;
    bmiColors: ARRAY 256 OF RGBQUAD;
  END;

  BITMAPCOREINFO = RECORD [WINDOWS]
    bmciHeader: BITMAPCOREHEADER;
    bmciColors: ARRAY 1 OF RGBTRIPLE;
  END;

  BITMAPFILEHEADER = RECORD [WINDOWS]
    bfType: UINT;
    bfSize: DWORD;
    bfReserved1: UINT;
    bfReserved2: UINT;
    bfOffBits: DWORD;
  END;

  METAFILEPICT = RECORD [WINDOWS]
    mm: INTEGER;
    xExt: INTEGER;
    yExt: INTEGER;
    hMF: HMETAFILE;
  END;

  METAHEADER = RECORD [WINDOWS]
    mtType: UINT;
    mtHeaderSize: UINT;
    mtVersion: UINT;
    mtSize: DWORD;
    mtNoObjects: UINT;
    mtMaxRecord: DWORD;
    mtNoParameters: UINT;
  END;

  HANDLETABLE = RECORD [WINDOWS]
    objectHandle: ARRAY 1 OF HGDIOBJ;
  END;

  METARECORD = RECORD [WINDOWS]
    rdSize: DWORD;
    rdFunction: UINT;
    rdParm: ARRAY 1 OF UINT;
  END;

  DOCINFO = RECORD [WINDOWS]
    cbSize: INTEGER;
    lpszDocName: LPCSTR;
    lpszOutput: LPCSTR;
  END;

  MSG = RECORD [WINDOWS]
    hwnd: HWND;
    message: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
    time: DWORD;
    pt: POINT;
  END;

  WNDCLASS = RECORD [WINDOWS]
    style: UINT;
    lpfnWndProc: WNDPROC;
    cbClsExtra: INTEGER;
    cbWndExtra: INTEGER;
    hInstance: HINSTANCE;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: LPCSTR;
    lpszClassName: LPCSTR;
  END;

  CREATESTRUCT = RECORD [WINDOWS]
    lpCreateParams: ADR;
    hInstance: HINSTANCE;
    hMenu: HMENU;
    hwndParent: HWND;
    cy: INTEGER;
    cx: INTEGER;
    y: INTEGER;
    x: INTEGER;
    style: LONGINT;
    lpszName: LPCSTR;
    lpszClass: LPCSTR;
    dwExStyle: DWORD;
  END;

  WINDOWPLACEMENT = RECORD [WINDOWS]
    length: UINT;
    flags: UINT;
    showCmd: UINT;
    ptMinPosition: POINT;
    ptMaxPosition: POINT;
    rcNormalPosition: RECT;
  END;

  WINDOWPOS = RECORD [WINDOWS]
    hwnd: HWND;
    hwndInsertAfter: HWND;
    x: INTEGER;
    y: INTEGER;
    cx: INTEGER;
    cy: INTEGER;
    flags: UINT;
  END;

  MINMAXINFO = RECORD [WINDOWS]
    ptReserved: POINT;
    ptMaxSize: POINT;
    ptMaxPosition: POINT;
    ptMinTrackSize: POINT;
    ptMaxTrackSize: POINT;
  END;

  PAINTSTRUCT = RECORD [WINDOWS]
    hdc: HDC;
    fErase: BOOL;
    rcPaint: RECT;
    fRestore: BOOL;
    fIncUpdate: BOOL;
    rgbReserved: ARRAY 16 OF BYTE;
  END;

  NCCALCSIZE_PARAMS = RECORD [WINDOWS]
    rgrc: ARRAY 3 OF RECT;
    lppos: POINTER TO WINDOWPOS;
  END;

  MOUSEHOOKSTRUCT = RECORD [WINDOWS]
    pt: POINT;
    hwnd: HWND;
    wHitTestCode: UINT;
    dwExtraInfo: DWORD;
  END;

  MENUITEMTEMPLATEHEADER = RECORD [WINDOWS]
    versionNumber: UINT;
    offset: UINT;
  END;

  MENUITEMTEMPLATE = RECORD [WINDOWS]
    mtOption: UINT;
    mtID: UINT;
    mtString: ARRAY 1 OF CHAR;
  END;

  CLIENTCREATESTRUCT = RECORD [WINDOWS]
    hWindowMenu: HMENU;
    idFirstChild: UINT;
  END;

  MDICREATESTRUCT = RECORD [WINDOWS]
    szClass: LPCSTR;
    szTitle: LPCSTR;
    hOwner: HINSTANCE;
    x: INTEGER;
    y: INTEGER;
    cx: INTEGER;
    cy: INTEGER;
    style: DWORD;
    lParam: LPARAM;
  END;

  DRAWITEMSTRUCT = RECORD [WINDOWS]
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    itemAction: UINT;
    itemState: UINT;
    hwndItem: HWND;
    hDC: HDC;
    rcItem: RECT;
    itemData: DWORD;
  END;

  MEASUREITEMSTRUCT = RECORD [WINDOWS]
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    itemWidth: UINT;
    itemHeight: UINT;
    itemData: DWORD;
  END;

  DELETEITEMSTRUCT = RECORD [WINDOWS]
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    hwndItem: HWND;
    itemData: DWORD;
  END;

  COMPAREITEMSTRUCT = RECORD [WINDOWS]
    CtlType: UINT;
    CtlID: UINT;
    hwndItem: HWND;
    itemID1: UINT;
    itemData1: DWORD;
    itemID2: UINT;
    itemData2: DWORD;
  END;

  CBT_CREATEWND = RECORD [WINDOWS]
    lpcs: POINTER TO CREATESTRUCT;
    hwndInsertAfter: HWND;
  END;

  CBTACTIVATESTRUCT = RECORD [WINDOWS]
    fMouse: BOOL;
    hWndActive: HWND;
  END;

  HARDWAREHOOKSTRUCT = RECORD [WINDOWS]
    hWnd: HWND;
    wMessage: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
  END;

  EVENTMSG = RECORD [WINDOWS]
    message: UINT;
    paramL: UINT;
    paramH: UINT;
    time: DWORD;
  END;

  DEBUGHOOKINFO = RECORD [WINDOWS]
    hModuleHook: HMODULE;
    reserved: LPARAM;
    lParam: LPARAM;
    wParam: WPARAM;
    code: INTEGER;
  END;

  MULTIKEYHELP = RECORD [WINDOWS]
    mkSize: UINT;
    mkKeylist: BYTE;
    szKeyphrase: ARRAY 1 OF BYTE;
  END;

  HELPWININFO = RECORD [WINDOWS]
    wStructSize: INTEGER;
    x: INTEGER;
    y: INTEGER;
    dx: INTEGER;
    dy: INTEGER;
    wMax: INTEGER;
    rgchMember: ARRAY 2 OF CHAR;
  END;

  DCB = RECORD [WINDOWS]
    Id: BYTE;
    BaudRate: UINT;
    ByteSize: BYTE;
    Parity: BYTE;
    StopBits: BYTE;
    RlsTimeout: UINT;
    CtsTimeout: UINT;
    DsrTimeout: UINT;
    flags: UINT;
    XonChar: CHAR;
    XoffChar: CHAR;
    XonLim: UINT;
    XoffLim: UINT;
    PeChar: CHAR;
    EofChar: CHAR;
    EvtChar: CHAR;
    TxDelay: UINT;
  END;

  COMSTAT = RECORD [WINDOWS]
    status: BYTE;
    cbInQue: UINT;
    cbOutQue: UINT;
  END;

  DRVCONFIGINFO = RECORD [WINDOWS]
    dwDCISize: DWORD;
    lpszDCISectionName: LPCSTR;
    lpszDCIAliasName: LPCSTR;
  END;

  DRIVERINFOSTRUCT = RECORD [WINDOWS]
    length: UINT;
    hDriver: HDRVR;
    hModule: HINSTANCE;
    szAliasName: ARRAY 128 OF CHAR;
  END;

  PATTERN = LOGBRUSH;

  LPABC = POINTER TO ABC;
  LPBITMAP = POINTER TO BITMAP;
  LPBITMAPCOREHEADER = POINTER TO BITMAPCOREHEADER;
  LPBITMAPCOREINFO = POINTER TO BITMAPCOREINFO;
  LPBITMAPFILEHEADER = POINTER TO BITMAPFILEHEADER;
  LPBITMAPINFO = POINTER TO BITMAPINFO;
  LPBITMAPINFOHEADER = POINTER TO BITMAPINFOHEADER;
  LPCBT_CREATEWND = POINTER TO CBT_CREATEWND;
  LPCLIENTCREATESTRUCT = POINTER TO CLIENTCREATESTRUCT;
  LPCOMPAREITEMSTRUCT = POINTER TO COMPAREITEMSTRUCT;
  LPCOMSTAT = POINTER TO COMSTAT;
  LPCREATESTRUCT = POINTER TO CREATESTRUCT;
  LPDCB = POINTER TO DCB;
  LPDEBUGHOOKINFO = POINTER TO DEBUGHOOKINFO;
  LPDELETEITEMSTRUCT = POINTER TO DELETEITEMSTRUCT;
  LPDOCINFO = POINTER TO DOCINFO;
  LPDRAWITEMSTRUCT = POINTER TO DRAWITEMSTRUCT;
  LPDRIVERINFOSTRUCT = POINTER TO DRIVERINFOSTRUCT;
  LPDRVCONFIGINFO = POINTER TO DRVCONFIGINFO;
  LPENUMLOGFONT = POINTER TO ENUMLOGFONT;
  LPEVENTMSG = POINTER TO EVENTMSG;
  LPFIXED = POINTER TO FIXED;
  LPGLYPHMETRICS = POINTER TO GLYPHMETRICS;
  LPHANDLETABLE = POINTER TO HANDLETABLE;
  LPHELPWININFO = POINTER TO HELPWININFO;
  LPKERNINGPAIR = POINTER TO KERNINGPAIR;
  LPLOGBRUSH = POINTER TO LOGBRUSH;
  LPLOGFONT = POINTER TO LOGFONT;
  LPLOGPALETTE = POINTER TO LOGPALETTE;
  LPLOGPEN = POINTER TO LOGPEN;
  LPMAT2 = POINTER TO MAT2;
  LPMDICREATESTRUCT = POINTER TO MDICREATESTRUCT;
  LPMEASUREITEMSTRUCT = POINTER TO MEASUREITEMSTRUCT;
  LPMETAFILEPICT = POINTER TO METAFILEPICT;
  LPMETARECORD = POINTER TO METARECORD;
  LPMOUSEHOOKSTRUCT = POINTER TO MOUSEHOOKSTRUCT;
  LPMSG = POINTER TO MSG;
  LPNCCALCSIZE_PARAMS = POINTER TO NCCALCSIZE_PARAMS;
  LPNEWTEXTMETRIC = POINTER TO NEWTEXTMETRIC;
  LPOFSTRUCT = POINTER TO OFSTRUCT;
  LPOUTLINETEXTMETRIC = POINTER TO OUTLINETEXTMETRIC;
  LPPAINTSTRUCT = POINTER TO PAINTSTRUCT;
  LPPALETTEENTRY = POINTER TO PALETTEENTRY;
  LPPANOSE = POINTER TO PANOSE;
  LPPATTERN = POINTER TO PATTERN;
  LPPOINT = POINTER TO POINT;
  LPPOINTFX = POINTER TO POINTFX;
  LPRASTERIZER_STATUS = POINTER TO RASTERIZER_STATUS;
  LPRECT = POINTER TO RECT;
  LPRGBQUAD = POINTER TO RGBQUAD;
  LPRGBTRIPLE = POINTER TO RGBTRIPLE;
  LPSEGINFO = POINTER TO SEGINFO;
  LPSIZE = POINTER TO SIZE;
  LPTEXTMETRIC = POINTER TO TEXTMETRIC;
  LPTTPOLYCURVE = POINTER TO TTPOLYCURVE;
  LPTTPOLYGONHEADER = POINTER TO TTPOLYGONHEADER;
  LPWINDEBUGINFO = POINTER TO WINDEBUGINFO;
  LPWINDOWPLACEMENT = POINTER TO WINDOWPLACEMENT;
  LPWINDOWPOS = POINTER TO WINDOWPOS;
  LPWNDCLASS = POINTER TO WNDCLASS;
  PBITMAP = POINTER TO BITMAP;
  PBITMAPCOREHEADER = POINTER TO BITMAPCOREHEADER;
  PBITMAPCOREINFO = POINTER TO BITMAPCOREINFO;
  PBITMAPFILEHEADER = POINTER TO BITMAPFILEHEADER;
  PBITMAPINFO = POINTER TO BITMAPINFO;
  PBITMAPINFOHEADER = POINTER TO BITMAPINFOHEADER;
  PEVENTMSG = POINTER TO EVENTMSG;
  PHANDLETABLE = POINTER TO HANDLETABLE;
  PLOGBRUSH = POINTER TO LOGBRUSH;
  PLOGFONT = POINTER TO LOGFONT;
  PLOGPALETTE = POINTER TO LOGPALETTE;
  PLOGPEN = POINTER TO LOGPEN;
  PMETARECORD = POINTER TO METARECORD;
  PMSG = POINTER TO MSG;
  PNEWTEXTMETRIC = POINTER TO NEWTEXTMETRIC;
  POFSTRUCT = POINTER TO OFSTRUCT;
  PPAINTSTRUCT = POINTER TO PAINTSTRUCT;
  PPATTERN = POINTER TO PATTERN;
  PPOINT = POINTER TO POINT;
  PRECT = POINTER TO RECT;
  PSIZE = POINTER TO SIZE;
  PTEXTMETRIC = POINTER TO TEXTMETRIC;
  PWINDOWPLACEMENT = POINTER TO WINDOWPLACEMENT;
  PWNDCLASS = POINTER TO WNDCLASS;

PROCEDURE [WINDOWS] AbortDoc (a: HDC): INTEGER;
PROCEDURE [WINDOWS] AccessResource (a: HINSTANCE; b: HRSRC): INTEGER;
PROCEDURE [WINDOWS] AddAtom (a: ADR): ATOM;
PROCEDURE [WINDOWS] AddFontResource (a: ADR): INTEGER;
PROCEDURE [WINDOWS] AdjustWindowRect (a: ADR; b: DWORD; c: BOOL);
PROCEDURE [WINDOWS] AdjustWindowRectEx (a: ADR; b: DWORD; c: BOOL; d: DWORD);
PROCEDURE [WINDOWS] AllocDStoCSAlias (a: UINT): UINT;
PROCEDURE [WINDOWS] AllocResource (a: HINSTANCE; b: HRSRC; c: DWORD): HGLOBAL;
PROCEDURE [WINDOWS] AllocSelector (a: UINT): UINT;
PROCEDURE [WINDOWS] AnimatePalette (a: HPALETTE; b: UINT; c: UINT; d: ADR);
PROCEDURE [WINDOWS] AnsiLower (a: ADR): ADR;
PROCEDURE [WINDOWS] AnsiLowerBuff (a: ADR; b: UINT): UINT;
PROCEDURE [WINDOWS] AnsiNext (a: ADR): ADR;
PROCEDURE [WINDOWS] AnsiPrev (a: ADR; b: ADR): ADR;
PROCEDURE [WINDOWS] AnsiUpper (a: ADR): ADR;
PROCEDURE [WINDOWS] AnsiUpperBuff (a: ADR; b: UINT): UINT;
PROCEDURE [WINDOWS] AnyPopup (): BOOL;
PROCEDURE [WINDOWS] AppendMenu (a: HMENU; b: UINT; c: UINT; d: ADR): BOOL;
PROCEDURE [WINDOWS] Arc (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: INTEGER; g: INTEGER; h: INTEGER; i: INTEGER): BOOL;
PROCEDURE [WINDOWS] ArrangeIconicWindows (a: HWND): UINT;
PROCEDURE [WINDOWS] BeginDeferWindowPos (a: INTEGER): HDWP;
PROCEDURE [WINDOWS] BeginPaint (a: HWND; b: ADR): HDC;
PROCEDURE [WINDOWS] BitBlt (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: HDC; g: INTEGER; h: INTEGER; i: DWORD): BOOL;
PROCEDURE [WINDOWS] BringWindowToTop (a: HWND): BOOL;
PROCEDURE [WINDOWS] BuildCommDCB (a: ADR; b: ADR): INTEGER;
PROCEDURE [WINDOWS] CallMsgFilter (a: ADR; b: INTEGER): BOOL;
PROCEDURE [WINDOWS] CallNextHookEx (hHook: HHOOK; code: INTEGER; wParam: WPARAM; lParam: ADR): LRESULT;
PROCEDURE [WINDOWS] CallWindowProc (a: WNDPROC; b: HWND; c: UINT; d: WPARAM; e: ADR): LRESULT;
PROCEDURE [WINDOWS] Catch (a: ADR): INTEGER;
PROCEDURE [WINDOWS] ChangeClipboardChain (a: HWND; b: HWND): BOOL;
PROCEDURE [WINDOWS] ChangeMenu (a: HMENU; b: UINT; c: ADR; d: UINT; e: UINT): BOOL;
PROCEDURE [WINDOWS] CheckDlgButton (a: HWND; b: INTEGER; c: UINT);
PROCEDURE [WINDOWS] CheckMenuItem (a: HMENU; b: UINT; c: UINT): BOOL;
PROCEDURE [WINDOWS] CheckRadioButton (a: HWND; b: INTEGER; c: INTEGER; d: INTEGER);
PROCEDURE [WINDOWS] ChildWindowFromPoint (a: HWND; b: POINT): HWND;
PROCEDURE [WINDOWS] Chord (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: INTEGER; g: INTEGER; h: INTEGER; i: INTEGER): BOOL;
PROCEDURE [WINDOWS] ClearCommBreak (a: INTEGER): INTEGER;
PROCEDURE [WINDOWS] ClientToScreen (a: HWND; b: ADR);
PROCEDURE [WINDOWS] ClipCursor (a: ADR);
PROCEDURE [WINDOWS] CloseClipboard (): BOOL;
PROCEDURE [WINDOWS] CloseComm (a: INTEGER): INTEGER;
PROCEDURE [WINDOWS] CloseDriver (hDriver: HDRVR; lParam1: ADR; lParam2: ADR): LRESULT;
PROCEDURE [WINDOWS] CloseMetaFile (a: HDC): HMETAFILE;
PROCEDURE [WINDOWS] CloseSound ();
PROCEDURE [WINDOWS] CloseWindow (a: HWND);
PROCEDURE [WINDOWS] CombineRgn (a: HRGN; b: HRGN; c: HRGN; d: INTEGER): INTEGER;
PROCEDURE [WINDOWS] CopyCursor (a: HINSTANCE; b: HCURSOR): HCURSOR;
PROCEDURE [WINDOWS] CopyIcon (a: HINSTANCE; b: HICON): HICON;
PROCEDURE [WINDOWS] CopyMetaFile (a: HMETAFILE; b: ADR): HMETAFILE;
PROCEDURE [WINDOWS] CopyRect (a: ADR; b: ADR);
PROCEDURE [WINDOWS] CountClipboardFormats (): INTEGER;
PROCEDURE [WINDOWS] CountVoiceNotes (a: INTEGER): INTEGER;
PROCEDURE [WINDOWS] CreateBitmap (a: INTEGER; b: INTEGER; c: UINT; d: UINT; e: ADR): HBITMAP;
PROCEDURE [WINDOWS] CreateBitmapIndirect (a: ADR): HBITMAP;
PROCEDURE [WINDOWS] CreateBrushIndirect (a: ADR): HBRUSH;
PROCEDURE [WINDOWS] CreateCaret (a: HWND; b: HBITMAP; c: INTEGER; d: INTEGER);
PROCEDURE [WINDOWS] CreateCompatibleBitmap (a: HDC; b: INTEGER; c: INTEGER): HBITMAP;
PROCEDURE [WINDOWS] CreateCompatibleDC (a: HDC): HDC;
PROCEDURE [WINDOWS] CreateCursor (a: HINSTANCE; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: ADR; g: ADR): HCURSOR;
PROCEDURE [WINDOWS] CreateDC (a: ADR; b: ADR; c: ADR; d: ADR): HDC;
PROCEDURE [WINDOWS] CreateDIBitmap (a: HDC; b: ADR; c: DWORD; d: ADR; e: ADR; f: UINT): HBITMAP;
PROCEDURE [WINDOWS] CreateDIBPatternBrush (a: HGLOBAL; b: UINT): HBRUSH;
PROCEDURE [WINDOWS] CreateDialog (a: HINSTANCE; b: ADR; c: HWND; d: DLGPROC): HWND;
PROCEDURE [WINDOWS] CreateDialogIndirect (a: HINSTANCE; b: ADR; c: HWND; d: DLGPROC): HWND;
PROCEDURE [WINDOWS] CreateDialogIndirectParam (a: HINSTANCE; b: ADR; c: HWND; d: DLGPROC; e: ADR): HWND;
PROCEDURE [WINDOWS] CreateDialogParam (a: HINSTANCE; b: ADR; c: HWND; d: DLGPROC; e: ADR): HWND;
PROCEDURE [WINDOWS] CreateDiscardableBitmap (a: HDC; b: INTEGER; c: INTEGER): HBITMAP;
PROCEDURE [WINDOWS] CreateEllipticRgn (a: INTEGER; b: INTEGER; c: INTEGER; d: INTEGER): HRGN;
PROCEDURE [WINDOWS] CreateEllipticRgnIndirect (a: ADR): HRGN;
PROCEDURE [WINDOWS] CreateFont (a: INTEGER; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: BYTE; g: BYTE; h: BYTE; i: BYTE; j: BYTE; k: BYTE; l: BYTE; m: BYTE; n: ADR): HFONT;
PROCEDURE [WINDOWS] CreateFontIndirect (a: ADR): HFONT;
PROCEDURE [WINDOWS] CreateHatchBrush (a: INTEGER; b: COLORREF): HBRUSH;
PROCEDURE [WINDOWS] CreateIC (a: ADR; b: ADR; c: ADR; d: ADR): HDC;
PROCEDURE [WINDOWS] CreateIcon (a: HINSTANCE; b: INTEGER; c: INTEGER; d: BYTE; e: BYTE; f: ADR; g: ADR): HICON;
PROCEDURE [WINDOWS] CreateMenu (): HMENU;
PROCEDURE [WINDOWS] CreateMetaFile (a: ADR): HDC;
PROCEDURE [WINDOWS] CreatePalette (a: ADR): HPALETTE;
PROCEDURE [WINDOWS] CreatePatternBrush (a: HBITMAP): HBRUSH;
PROCEDURE [WINDOWS] CreatePen (a: INTEGER; b: INTEGER; c: COLORREF): HPEN;
PROCEDURE [WINDOWS] CreatePenIndirect (a: ADR): HPEN;
PROCEDURE [WINDOWS] CreatePolygonRgn (a: ADR; b: INTEGER; c: INTEGER): HRGN;
PROCEDURE [WINDOWS] CreatePolyPolygonRgn (a: ADR; b: ADR; c: INTEGER; d: INTEGER): HRGN;
PROCEDURE [WINDOWS] CreatePopupMenu (): HMENU;
PROCEDURE [WINDOWS] CreateRectRgn (a: INTEGER; b: INTEGER; c: INTEGER; d: INTEGER): HRGN;
PROCEDURE [WINDOWS] CreateRectRgnIndirect (a: ADR): HRGN;
PROCEDURE [WINDOWS] CreateRoundRectRgn (a: INTEGER; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: INTEGER): HRGN;
PROCEDURE [WINDOWS] CreateScalableFontResource (a: UINT; b: ADR; c: ADR; d: ADR): BOOL;
PROCEDURE [WINDOWS] CreateSolidBrush (a: COLORREF): HBRUSH;
PROCEDURE [WINDOWS] CreateWindow (a: ADR; b: ADR; c: DWORD; d: INTEGER; e: INTEGER; f: INTEGER; g: INTEGER; h: HWND; i: HMENU; j: HINSTANCE; k: ADR): HWND;
PROCEDURE [WINDOWS] CreateWindowEx (a: DWORD; b: ADR; c: ADR; d: DWORD; e: INTEGER; f: INTEGER; g: INTEGER; h: INTEGER; i: HWND; j: HMENU; k: HINSTANCE; l: ADR): HWND;
PROCEDURE [WINDOWS] DebugBreak ();
PROCEDURE [WINDOWS] DefDlgProc (a: HWND; b: UINT; c: WPARAM; d: ADR): LRESULT;
PROCEDURE [WINDOWS] DefDriverProc (dwDriverIdentifier: DWORD; driverID: HDRVR; message: UINT; lParam1: ADR; lParam2: ADR): LRESULT;
PROCEDURE [WINDOWS] DeferWindowPos (a: HDWP; b: HWND; c: HWND; d: INTEGER; e: INTEGER; f: INTEGER; g: INTEGER; h: UINT): HDWP;
PROCEDURE [WINDOWS] DefFrameProc (a: HWND; b: HWND; c: UINT; d: WPARAM; e: ADR): LRESULT;
PROCEDURE [WINDOWS] DefHookProc (a: INTEGER; b: WPARAM; c: ADR; d: ADR): LRESULT;
PROCEDURE [WINDOWS] DefMDIChildProc (a: HWND; b: UINT; c: WPARAM; d: ADR): LRESULT;
PROCEDURE [WINDOWS] DefWindowProc (a: HWND; b: UINT; c: WPARAM; d: ADR): LRESULT;
PROCEDURE [WINDOWS] DeleteAtom (a: ATOM): ATOM;
PROCEDURE [WINDOWS] DeleteDC (a: HDC): BOOL;
PROCEDURE [WINDOWS] DeleteMenu (a: HMENU; b: UINT; c: UINT): BOOL;
PROCEDURE [WINDOWS] DeleteMetaFile (a: HMETAFILE): BOOL;
PROCEDURE [WINDOWS] DeleteObject (a: HGDIOBJ): BOOL;
PROCEDURE [WINDOWS] DestroyCaret ();
PROCEDURE [WINDOWS] DestroyCursor (a: HCURSOR): BOOL;
PROCEDURE [WINDOWS] DestroyIcon (a: HICON): BOOL;
PROCEDURE [WINDOWS] DestroyMenu (a: HMENU): BOOL;
PROCEDURE [WINDOWS] DestroyWindow (a: HWND): BOOL;
PROCEDURE [WINDOWS] DialogBox (a: HINSTANCE; b: ADR; c: HWND; d: DLGPROC): INTEGER;
PROCEDURE [WINDOWS] DialogBoxIndirect (a: HINSTANCE; b: HGLOBAL; c: HWND; d: DLGPROC): INTEGER;
PROCEDURE [WINDOWS] DialogBoxIndirectParam (a: HINSTANCE; b: HGLOBAL; c: HWND; d: DLGPROC; e: ADR): INTEGER;
PROCEDURE [WINDOWS] DialogBoxParam (a: HINSTANCE; b: ADR; c: HWND; d: DLGPROC; e: ADR): INTEGER;
PROCEDURE [WINDOWS] DirectedYield (a: HTASK);
PROCEDURE [WINDOWS] DispatchMessage (a: ADR): LONGINT;
PROCEDURE [WINDOWS] DlgDirList (a: HWND; b: ADR; c: INTEGER; d: INTEGER; e: UINT): INTEGER;
PROCEDURE [WINDOWS] DlgDirListComboBox (a: HWND; b: ADR; c: INTEGER; d: INTEGER; e: UINT): INTEGER;
PROCEDURE [WINDOWS] DlgDirSelect (a: HWND; b: ADR; c: INTEGER): BOOL;
PROCEDURE [WINDOWS] DlgDirSelectComboBox (a: HWND; b: ADR; c: INTEGER): BOOL;
PROCEDURE [WINDOWS] DlgDirSelectComboBoxEx (a: HWND; b: ADR; c: INTEGER; d: INTEGER): BOOL;
PROCEDURE [WINDOWS] DlgDirSelectEx (a: HWND; b: ADR; c: INTEGER; d: INTEGER): BOOL;
PROCEDURE [WINDOWS] DPtoLP (a: HDC; b: ADR; c: INTEGER): BOOL;
PROCEDURE [WINDOWS] DrawFocusRect (a: HDC; b: ADR);
PROCEDURE [WINDOWS] DrawIcon (a: HDC; b: INTEGER; c: INTEGER; d: HICON): BOOL;
PROCEDURE [WINDOWS] DrawMenuBar (a: HWND);
PROCEDURE [WINDOWS] DrawText (a: HDC; b: ADR; c: INTEGER; d: ADR; e: UINT): INTEGER;
PROCEDURE [WINDOWS] Ellipse (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER): BOOL;
PROCEDURE [WINDOWS] EmptyClipboard (): BOOL;
PROCEDURE [WINDOWS] EnableCommNotification (a: INTEGER; b: HWND; c: INTEGER; d: INTEGER): BOOL;
PROCEDURE [WINDOWS] EnableHardwareInput (a: BOOL): BOOL;
PROCEDURE [WINDOWS] EnableMenuItem (a: HMENU; b: UINT; c: UINT): BOOL;
PROCEDURE [WINDOWS] EnableScrollBar (a: HWND; b: INTEGER; c: UINT): BOOL;
PROCEDURE [WINDOWS] EnableWindow (a: HWND; b: BOOL): BOOL;
PROCEDURE [WINDOWS] EndDeferWindowPos (a: HDWP): BOOL;
PROCEDURE [WINDOWS] EndDialog (a: HWND; b: INTEGER);
PROCEDURE [WINDOWS] EndDoc (a: HDC): INTEGER;
PROCEDURE [WINDOWS] EndPage (a: HDC): INTEGER;
PROCEDURE [WINDOWS] EndPaint (a: HWND; b: ADR);
PROCEDURE [WINDOWS] EnumChildWindows (a: HWND; b: FARPROC; c: ADR): BOOL;
PROCEDURE [WINDOWS] EnumClipboardFormats (a: UINT): UINT;
PROCEDURE [WINDOWS] EnumFontFamilies (a: HDC; b: ADR; c: FARPROC; d: ADR): INTEGER;
PROCEDURE [WINDOWS] EnumFonts (a: HDC; b: ADR; c: FARPROC; d: ADR): INTEGER;
PROCEDURE [WINDOWS] EnumMetaFile (a: HDC; b: HMETAFILE; c: FARPROC; d: ADR): BOOL;
PROCEDURE [WINDOWS] EnumObjects (a: HDC; b: INTEGER; c: FARPROC; d: ADR): INTEGER;
PROCEDURE [WINDOWS] EnumProps (a: HWND; b: FARPROC): INTEGER;
PROCEDURE [WINDOWS] EnumTaskWindows (a: HTASK; b: FARPROC; c: ADR): BOOL;
PROCEDURE [WINDOWS] EnumWindows (a: FARPROC; b: ADR): BOOL;
PROCEDURE [WINDOWS] EqualRect (a: ADR; b: ADR): BOOL;
PROCEDURE [WINDOWS] EqualRgn (a: HRGN; b: HRGN): BOOL;
PROCEDURE [WINDOWS] Escape (a: HDC; b: INTEGER; c: INTEGER; d: ADR; e: ADR): INTEGER;
PROCEDURE [WINDOWS] EscapeCommFunction (a: INTEGER; b: INTEGER): LONGINT;
PROCEDURE [WINDOWS] ExcludeClipRect (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER): INTEGER;
PROCEDURE [WINDOWS] ExcludeUpdateRgn (a: HDC; b: HWND): INTEGER;
PROCEDURE [WINDOWS] ExitWindows (dwReturnCode: DWORD; wReserved: UINT): BOOL;
PROCEDURE [WINDOWS] ExitWindowsExec (a: ADR; b: ADR): BOOL;
PROCEDURE [WINDOWS] ExtFloodFill (a: HDC; b: INTEGER; c: INTEGER; d: COLORREF; e: UINT): BOOL;
PROCEDURE [WINDOWS] ExtTextOut (a: HDC; b: INTEGER; c: INTEGER; d: UINT; e: ADR; f: ADR; g: UINT; h: ADR): BOOL;
PROCEDURE [WINDOWS] FatalAppExit (a: UINT; b: ADR);
PROCEDURE [WINDOWS] FatalExit (a: INTEGER);
PROCEDURE [WINDOWS] FillRect (a: HDC; b: ADR; c: HBRUSH): INTEGER;
PROCEDURE [WINDOWS] FillRgn (a: HDC; b: HRGN; c: HBRUSH): BOOL;
PROCEDURE [WINDOWS] FindAtom (a: ADR): ATOM;
PROCEDURE [WINDOWS] FindResource (a: HINSTANCE; b: ADR; c: ADR): HRSRC;
PROCEDURE [WINDOWS] FindWindow (a: ADR; b: ADR): HWND;
PROCEDURE [WINDOWS] FlashWindow (a: HWND; b: BOOL): BOOL;
PROCEDURE [WINDOWS] FloodFill (a: HDC; b: INTEGER; c: INTEGER; d: COLORREF): BOOL;
PROCEDURE [WINDOWS] FlushComm (a: INTEGER; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] FrameRect (a: HDC; b: ADR; c: HBRUSH): INTEGER;
PROCEDURE [WINDOWS] FrameRgn (a: HDC; b: HRGN; c: HBRUSH; d: INTEGER; e: INTEGER): BOOL;
PROCEDURE [WINDOWS] FreeLibrary (a: HINSTANCE);
PROCEDURE [WINDOWS] FreeModule (a: HINSTANCE): BOOL;
PROCEDURE [WINDOWS] FreeProcInstance (a: FARPROC);
PROCEDURE [WINDOWS] FreeResource (a: HGLOBAL): BOOL;
PROCEDURE [WINDOWS] FreeSelector (a: UINT): UINT;
PROCEDURE [WINDOWS] GetActiveWindow (): HWND;
PROCEDURE [WINDOWS] GetAspectRatioFilter (a: HDC): DWORD;
PROCEDURE [WINDOWS] GetAspectRatioFilterEx (a: HDC; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetAsyncKeyState (a: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetAtomHandle (a: ATOM): HLOCAL;
PROCEDURE [WINDOWS] GetAtomName (a: ATOM; b: ADR; c: INTEGER): UINT;
PROCEDURE [WINDOWS] GetBitmapBits (a: HBITMAP; b: LONGINT; c: ADR): LONGINT;
PROCEDURE [WINDOWS] GetBitmapDimension (a: HBITMAP): DWORD;
PROCEDURE [WINDOWS] GetBitmapDimensionEx (a: HBITMAP; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetBkColor (a: HDC): COLORREF;
PROCEDURE [WINDOWS] GetBkMode (a: HDC): INTEGER;
PROCEDURE [WINDOWS] GetBoundsRect (hDC: HDC; lprcBounds: ADR; flags: UINT): UINT;
PROCEDURE [WINDOWS] GetBrushOrg (a: HDC): DWORD;
PROCEDURE [WINDOWS] GetBrushOrgEx (a: HDC; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetCapture (): HWND;
PROCEDURE [WINDOWS] GetCaretBlinkTime (): UINT;
PROCEDURE [WINDOWS] GetCaretPos (a: ADR);
PROCEDURE [WINDOWS] GetCharABCWidths (a: HDC; b: UINT; c: UINT; d: ADR): BOOL;
PROCEDURE [WINDOWS] GetCharWidth (a: HDC; b: UINT; c: UINT; d: ADR): BOOL;
PROCEDURE [WINDOWS] GetClassInfo (a: HINSTANCE; b: ADR; c: ADR): BOOL;
PROCEDURE [WINDOWS] GetClassLong (a: HWND; b: INTEGER): LONGINT;
PROCEDURE [WINDOWS] GetClassName (a: HWND; b: ADR; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetClassWord (a: HWND; b: INTEGER): WORD;
PROCEDURE [WINDOWS] GetClientRect (a: HWND; b: ADR);
PROCEDURE [WINDOWS] GetClipBox (a: HDC; b: ADR): INTEGER;
PROCEDURE [WINDOWS] GetClipboardData (a: UINT): HANDLE;
PROCEDURE [WINDOWS] GetClipboardFormatName (a: UINT; b: ADR; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetClipboardOwner (): HWND;
PROCEDURE [WINDOWS] GetClipboardViewer (): HWND;
PROCEDURE [WINDOWS] GetClipCursor (a: ADR);
PROCEDURE [WINDOWS] GetCodeHandle (a: FARPROC): HGLOBAL;
PROCEDURE [WINDOWS] GetCodeInfo (lpProc: FARPROC; lpSegInfo: ADR);
PROCEDURE [WINDOWS] GetCommError (a: INTEGER; b: ADR): INTEGER;
PROCEDURE [WINDOWS] GetCommEventMask (a: INTEGER; b: INTEGER): UINT;
PROCEDURE [WINDOWS] GetCommState (a: INTEGER; b: ADR): INTEGER;
PROCEDURE [WINDOWS] GetCurrentPDB (): UINT;
PROCEDURE [WINDOWS] GetCurrentPosition (a: HDC): DWORD;
PROCEDURE [WINDOWS] GetCurrentPositionEx (a: HDC; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetCurrentTask (): HTASK;
PROCEDURE [WINDOWS] GetCurrentTime (): DWORD;
PROCEDURE [WINDOWS] GetCursor (): HCURSOR;
PROCEDURE [WINDOWS] GetCursorPos (a: ADR);
PROCEDURE [WINDOWS] GetDC (a: HWND): HDC;
PROCEDURE [WINDOWS] GetDCOrg (a: HDC): DWORD;
PROCEDURE [WINDOWS] GetDesktopWindow (): HWND;
PROCEDURE [WINDOWS] GetDeviceCaps (a: HDC; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetDIBits (a: HDC; b: HBITMAP; c: UINT; d: UINT; e: ADR; f: ADR; g: UINT): INTEGER;
PROCEDURE [WINDOWS] GetDialogBaseUnits (): DWORD;
PROCEDURE [WINDOWS] GetDlgCtrlID (a: HWND): INTEGER;
PROCEDURE [WINDOWS] GetDlgItem (a: HWND; b: INTEGER): HWND;
PROCEDURE [WINDOWS] GetDlgItemInt (a: HWND; b: INTEGER; c: ADR; d: BOOL): UINT;
PROCEDURE [WINDOWS] GetDlgItemText (a: HWND; b: INTEGER; c: ADR; d: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetDOSEnvironment (): ADR;
PROCEDURE [WINDOWS] GetDoubleClickTime (): UINT;
PROCEDURE [WINDOWS] GetDriverInfo (a: HDRVR; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetDriverModuleHandle (hDriver: HDRVR): HINSTANCE;
PROCEDURE [WINDOWS] GetDriveType (a: INTEGER): UINT;
PROCEDURE [WINDOWS] GetEnvironment (a: ADR; b: ADR; c: UINT): INTEGER;
PROCEDURE [WINDOWS] GetFocus (): HWND;
PROCEDURE [WINDOWS] GetFontData (a: HDC; b: DWORD; c: DWORD; d: ADR; e: DWORD): DWORD;
PROCEDURE [WINDOWS] GetFreeSpace (a: UINT): DWORD;
PROCEDURE [WINDOWS] GetFreeSystemResources (a: UINT): UINT;
PROCEDURE [WINDOWS] GetGlyphOutline (a: HDC; b: UINT; c: UINT; d: ADR; e: DWORD; f: ADR; g: ADR): DWORD;
PROCEDURE [WINDOWS] GetInputState (): BOOL;
PROCEDURE [WINDOWS] GetInstanceData (a: HINSTANCE; b: ADR; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetKBCodePage (): INTEGER;
PROCEDURE [WINDOWS] GetKerningPairs (a: HDC; b: INTEGER; c: ADR): INTEGER;
PROCEDURE [WINDOWS] GetKeyboardState (a: ADR);
PROCEDURE [WINDOWS] GetKeyboardType (a: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetKeyNameText (a: LONGINT; b: ADR; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetKeyState (a: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetLastActivePopup (a: HWND): HWND;
PROCEDURE [WINDOWS] GetMapMode (a: HDC): INTEGER;
PROCEDURE [WINDOWS] GetMenu (a: HWND): HMENU;
PROCEDURE [WINDOWS] GetMenuCheckMarkDimensions (): DWORD;
PROCEDURE [WINDOWS] GetMenuItemCount (a: HMENU): INTEGER;
PROCEDURE [WINDOWS] GetMenuItemID (a: HMENU; b: INTEGER): UINT;
PROCEDURE [WINDOWS] GetMenuState (a: HMENU; b: UINT; c: UINT): UINT;
PROCEDURE [WINDOWS] GetMenuString (a: HMENU; b: UINT; c: ADR; d: INTEGER; e: UINT): INTEGER;
PROCEDURE [WINDOWS] GetMessage (a: ADR; b: HWND; c: UINT; d: UINT): BOOL;
PROCEDURE [WINDOWS] GetMessageExtraInfo (): ADR;
PROCEDURE [WINDOWS] GetMessagePos (): DWORD;
PROCEDURE [WINDOWS] GetMessageTime (): LONGINT;
PROCEDURE [WINDOWS] GetMetaFile (a: ADR): HMETAFILE;
PROCEDURE [WINDOWS] GetMetaFileBits (a: HMETAFILE): HGLOBAL;
PROCEDURE [WINDOWS] GetModuleFileName (a: HINSTANCE; b: ADR; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetModuleHandle (a: ADR): HMODULE;
PROCEDURE [WINDOWS] GetModuleUsage (a: HINSTANCE): INTEGER;
PROCEDURE [WINDOWS] GetNearestColor (a: HDC; b: COLORREF): COLORREF;
PROCEDURE [WINDOWS] GetNearestPaletteIndex (a: HPALETTE; b: COLORREF): UINT;
PROCEDURE [WINDOWS] GetNextDlgGroupItem (a: HWND; b: HWND; c: BOOL): HWND;
PROCEDURE [WINDOWS] GetNextDlgTabItem (a: HWND; b: HWND; c: BOOL): HWND;
PROCEDURE [WINDOWS] GetNextDriver (a: HDRVR; b: DWORD): HDRVR;
PROCEDURE [WINDOWS] GetNextWindow (a: HWND; b: UINT): HWND;
PROCEDURE [WINDOWS] GetNumTasks (): UINT;
PROCEDURE [WINDOWS] GetObject (a: HGDIOBJ; b: INTEGER; c: ADR): INTEGER;
PROCEDURE [WINDOWS] GetOpenClipboardWindow (): HWND;
PROCEDURE [WINDOWS] GetOutlineTextMetrics (a: HDC; b: UINT; c: ADR): WORD;
PROCEDURE [WINDOWS] GetPaletteEntries (a: HPALETTE; b: UINT; c: UINT; d: ADR): UINT;
PROCEDURE [WINDOWS] GetParent (a: HWND): HWND;
PROCEDURE [WINDOWS] GetPixel (a: HDC; b: INTEGER; c: INTEGER): COLORREF;
PROCEDURE [WINDOWS] GetPolyFillMode (a: HDC): INTEGER;
PROCEDURE [WINDOWS] GetPriorityClipboardFormat (a: ADR; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetPrivateProfileInt (a: ADR; b: ADR; c: INTEGER; d: ADR): UINT;
PROCEDURE [WINDOWS] GetPrivateProfileString (a: ADR; b: ADR; c: ADR; d: ADR; e: INTEGER; f: ADR): INTEGER;
PROCEDURE [WINDOWS] GetProcAddress (a: HINSTANCE; b: ADR): FARPROC;
PROCEDURE [WINDOWS] GetProfileInt (a: ADR; b: ADR; c: INTEGER): UINT;
PROCEDURE [WINDOWS] GetProfileString (a: ADR; b: ADR; c: ADR; d: ADR; e: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetProp (a: HWND; b: ADR): HANDLE;
PROCEDURE [WINDOWS] GetQueueStatus (flags: UINT): DWORD;
PROCEDURE [WINDOWS] GetRasterizerCaps (a: ADR; b: INTEGER): BOOL;
PROCEDURE [WINDOWS] GetRgnBox (a: HRGN; b: ADR): INTEGER;
PROCEDURE [WINDOWS] GetROP2 (a: HDC): INTEGER;
PROCEDURE [WINDOWS] GetScrollPos (a: HWND; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetScrollRange (a: HWND; b: INTEGER; c: ADR; d: ADR);
PROCEDURE [WINDOWS] GetSelectorBase (a: UINT): DWORD;
PROCEDURE [WINDOWS] GetSelectorLimit (a: UINT): DWORD;
PROCEDURE [WINDOWS] GetStockObject (a: INTEGER): HGDIOBJ;
PROCEDURE [WINDOWS] GetStretchBltMode (a: HDC): INTEGER;
PROCEDURE [WINDOWS] GetSubMenu (a: HMENU; b: INTEGER): HMENU;
PROCEDURE [WINDOWS] GetSysColor (a: INTEGER): COLORREF;
PROCEDURE [WINDOWS] GetSysModalWindow (): HWND;
PROCEDURE [WINDOWS] GetSystemDebugState (): LONGINT;
PROCEDURE [WINDOWS] GetSystemDirectory (a: ADR; b: UINT): UINT;
PROCEDURE [WINDOWS] GetSystemMenu (a: HWND; b: BOOL): HMENU;
PROCEDURE [WINDOWS] GetSystemMetrics (a: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetSystemPaletteEntries (a: HDC; b: UINT; c: UINT; d: ADR): UINT;
PROCEDURE [WINDOWS] GetSystemPaletteUse (a: HDC): UINT;
PROCEDURE [WINDOWS] GetTabbedTextExtent (a: HDC; b: ADR; c: INTEGER; d: INTEGER; e: ADR): DWORD;
PROCEDURE [WINDOWS] GetTempDrive (a: CHAR): BYTE;
PROCEDURE [WINDOWS] GetTextAlign (a: HDC): UINT;
PROCEDURE [WINDOWS] GetTextCharacterExtra (a: HDC): INTEGER;
PROCEDURE [WINDOWS] GetTextColor (a: HDC): COLORREF;
PROCEDURE [WINDOWS] GetTextExtent (a: HDC; b: ADR; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] GetTextExtentPoint (a: HDC; b: ADR; c: INTEGER; d: ADR): BOOL;
PROCEDURE [WINDOWS] GetTextFace (a: HDC; b: INTEGER; c: ADR): INTEGER;
PROCEDURE [WINDOWS] GetTextMetrics (a: HDC; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetThresholdEvent (): ADR;
PROCEDURE [WINDOWS] GetThresholdStatus (): INTEGER;
PROCEDURE [WINDOWS] GetTickCount (): DWORD;
PROCEDURE [WINDOWS] GetTimerResolution (): DWORD;
PROCEDURE [WINDOWS] GetTopWindow (a: HWND): HWND;
PROCEDURE [WINDOWS] GetUpdateRect (a: HWND; b: ADR; c: BOOL): BOOL;
PROCEDURE [WINDOWS] GetUpdateRgn (a: HWND; b: HRGN; c: BOOL): INTEGER;
PROCEDURE [WINDOWS] GetVersion (): DWORD;
PROCEDURE [WINDOWS] GetViewportExt (a: HDC): DWORD;
PROCEDURE [WINDOWS] GetViewportExtEx (a: HDC; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetViewportOrg (a: HDC): DWORD;
PROCEDURE [WINDOWS] GetViewportOrgEx (a: HDC; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetWinDebugInfo (lpwdi: ADR; flags: UINT): BOOL;
PROCEDURE [WINDOWS] GetWindow (a: HWND; b: UINT): HWND;
PROCEDURE [WINDOWS] GetWindowDC (a: HWND): HDC;
PROCEDURE [WINDOWS] GetWindowExt (a: HDC): DWORD;
PROCEDURE [WINDOWS] GetWindowExtEx (a: HDC; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetWindowLong (a: HWND; b: INTEGER): LONGINT;
PROCEDURE [WINDOWS] GetWindowOrg (a: HDC): DWORD;
PROCEDURE [WINDOWS] GetWindowOrgEx (a: HDC; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetWindowPlacement (a: HWND; b: ADR): BOOL;
PROCEDURE [WINDOWS] GetWindowRect (a: HWND; b: ADR);
PROCEDURE [WINDOWS] GetWindowsDirectory (a: ADR; b: UINT): UINT;
PROCEDURE [WINDOWS] GetWindowTask (a: HWND): HTASK;
PROCEDURE [WINDOWS] GetWindowText (a: HWND; b: ADR; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] GetWindowTextLength (a: HWND): INTEGER;
PROCEDURE [WINDOWS] GetWindowWord (a: HWND; b: INTEGER): WORD;
PROCEDURE [WINDOWS] GetWinFlags (): DWORD;
PROCEDURE [WINDOWS] GlobalAddAtom (a: ADR): ATOM;
PROCEDURE [WINDOWS] GlobalAlloc (a: UINT; b: DWORD): HGLOBAL;
PROCEDURE [WINDOWS] GlobalCompact (a: DWORD): DWORD;
PROCEDURE [WINDOWS] GlobalDeleteAtom (a: ATOM): ATOM;
PROCEDURE [WINDOWS] GlobalDosAlloc (a: DWORD): DWORD;
PROCEDURE [WINDOWS] GlobalDosFree (a: UINT): UINT;
PROCEDURE [WINDOWS] GlobalFindAtom (a: ADR): ATOM;
PROCEDURE [WINDOWS] GlobalFix (a: HGLOBAL);
PROCEDURE [WINDOWS] GlobalFlags (a: HGLOBAL): UINT;
PROCEDURE [WINDOWS] GlobalFree (a: HGLOBAL): HGLOBAL;
PROCEDURE [WINDOWS] GlobalGetAtomName (a: ATOM; b: ADR; c: INTEGER): UINT;
PROCEDURE [WINDOWS] GlobalHandle (a: UINT): DWORD;
PROCEDURE [WINDOWS] GlobalLock (a: HGLOBAL): ADR;
PROCEDURE [WINDOWS] GlobalLRUNewest (a: HGLOBAL): HGLOBAL;
PROCEDURE [WINDOWS] GlobalLRUOldest (a: HGLOBAL): HGLOBAL;
PROCEDURE [WINDOWS] GlobalNotify (a: FARPROC);
PROCEDURE [WINDOWS] GlobalPageLock (a: HGLOBAL): UINT;
PROCEDURE [WINDOWS] GlobalPageUnlock (a: HGLOBAL): UINT;
PROCEDURE [WINDOWS] GlobalReAlloc (a: HGLOBAL; b: DWORD; c: UINT): HGLOBAL;
PROCEDURE [WINDOWS] GlobalSize (a: HGLOBAL): DWORD;
PROCEDURE [WINDOWS] GlobalUnfix (a: HGLOBAL);
PROCEDURE [WINDOWS] GlobalUnlock (a: HGLOBAL): BOOL;
PROCEDURE [WINDOWS] GlobalUnWire (a: HGLOBAL): BOOL;
PROCEDURE [WINDOWS] GlobalWire (a: HGLOBAL): ADR;
PROCEDURE [WINDOWS] GrayString (a: HDC; b: HBRUSH; c: FARPROC; d: ADR; e: INTEGER; f: INTEGER; g: INTEGER; h: INTEGER; i: INTEGER): BOOL;
PROCEDURE [WINDOWS] HideCaret (a: HWND);
PROCEDURE [WINDOWS] HiliteMenuItem (a: HWND; b: HMENU; c: UINT; d: UINT): BOOL;
PROCEDURE [WINDOWS] InflateRect (a: ADR; b: INTEGER; c: INTEGER);
PROCEDURE [WINDOWS] InitAtomTable (a: INTEGER): BOOL;
PROCEDURE [WINDOWS] InSendMessage (): BOOL;
PROCEDURE [WINDOWS] InsertMenu (a: HMENU; b: UINT; c: UINT; d: UINT; e: ADR): BOOL;
PROCEDURE [WINDOWS] IntersectClipRect (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER): INTEGER;
PROCEDURE [WINDOWS] IntersectRect (a: ADR; b: ADR; c: ADR): BOOL;
PROCEDURE [WINDOWS] InvalidateRect (a: HWND; b: ADR; c: BOOL);
PROCEDURE [WINDOWS] InvalidateRgn (a: HWND; b: HRGN; c: BOOL);
PROCEDURE [WINDOWS] InvertRect (a: HDC; b: ADR);
PROCEDURE [WINDOWS] InvertRgn (a: HDC; b: HRGN): BOOL;
PROCEDURE [WINDOWS] IsBadReadPtr (lp: ADR; cb: UINT): BOOL;
PROCEDURE [WINDOWS] IsBadStringPtr (lpsz: ADR; cchMax: UINT): BOOL;
PROCEDURE [WINDOWS] IsBadWritePtr (lp: ADR; cb: UINT): BOOL;
PROCEDURE [WINDOWS] IsCharAlpha (a: CHAR): BOOL;
PROCEDURE [WINDOWS] IsCharAlphaNumeric (a: CHAR): BOOL;
PROCEDURE [WINDOWS] IsCharLower (a: CHAR): BOOL;
PROCEDURE [WINDOWS] IsCharUpper (a: CHAR): BOOL;
PROCEDURE [WINDOWS] IsChild (a: HWND; b: HWND): BOOL;
PROCEDURE [WINDOWS] IsClipboardFormatAvailable (a: UINT): BOOL;
PROCEDURE [WINDOWS] IsDBCSLeadByte (a: BYTE): BOOL;
PROCEDURE [WINDOWS] IsDialogMessage (a: HWND; b: ADR): BOOL;
PROCEDURE [WINDOWS] IsDlgButtonChecked (a: HWND; b: INTEGER): UINT;
PROCEDURE [WINDOWS] IsGDIObject (a: HGDIOBJ): BOOL;
PROCEDURE [WINDOWS] IsIconic (a: HWND): BOOL;
PROCEDURE [WINDOWS] IsMenu (a: HMENU): BOOL;
PROCEDURE [WINDOWS] IsRectEmpty (a: ADR): BOOL;
PROCEDURE [WINDOWS] IsTask (a: HTASK): BOOL;
PROCEDURE [WINDOWS] IsWindow (a: HWND): BOOL;
PROCEDURE [WINDOWS] IsWindowEnabled (a: HWND): BOOL;
PROCEDURE [WINDOWS] IsWindowVisible (a: HWND): BOOL;
PROCEDURE [WINDOWS] IsZoomed (a: HWND): BOOL;
PROCEDURE [WINDOWS] KillTimer (a: HWND; b: UINT): BOOL;
PROCEDURE [WINDOWS] LimitEmsPages (a: DWORD);
PROCEDURE [WINDOWS] LineDDA (a: INTEGER; b: INTEGER; c: INTEGER; d: INTEGER; e: FARPROC; f: ADR);
PROCEDURE [WINDOWS] LineTo (a: HDC; b: INTEGER; c: INTEGER): BOOL;
PROCEDURE [WINDOWS] LoadAccelerators (a: HINSTANCE; b: ADR): HACCEL;
PROCEDURE [WINDOWS] LoadBitmap (a: HINSTANCE; b: ADR): HBITMAP;
PROCEDURE [WINDOWS] LoadCursor (a: HINSTANCE; b: ADR): HCURSOR;
PROCEDURE [WINDOWS] LoadIcon (a: HINSTANCE; b: ADR): HICON;
PROCEDURE [WINDOWS] LoadLibrary (a: ADR): HINSTANCE;
PROCEDURE [WINDOWS] LoadMenu (a: HINSTANCE; b: ADR): HMENU;
PROCEDURE [WINDOWS] LoadMenuIndirect (a: ADR): HMENU;
PROCEDURE [WINDOWS] LoadModule (a: ADR; b: ADR): HINSTANCE;
PROCEDURE [WINDOWS] LoadResource (a: HINSTANCE; b: HRSRC): HGLOBAL;
PROCEDURE [WINDOWS] LoadString (a: HINSTANCE; b: UINT; c: ADR; d: INTEGER): INTEGER;
PROCEDURE [WINDOWS] LocalAlloc (a: UINT; b: UINT): HLOCAL;
PROCEDURE [WINDOWS] LocalCompact (a: UINT): UINT;
PROCEDURE [WINDOWS] LocalFlags (a: HLOCAL): UINT;
PROCEDURE [WINDOWS] LocalFree (a: HLOCAL): HLOCAL;
PROCEDURE [WINDOWS] LocalHandle (a: UINT): HLOCAL;
PROCEDURE [WINDOWS] LocalInit (a: UINT; b: UINT; c: UINT): BOOL;
PROCEDURE [WINDOWS] LocalLock (a: HLOCAL): UINT;
PROCEDURE [WINDOWS] LocalReAlloc (a: HLOCAL; b: UINT; c: UINT): HLOCAL;
PROCEDURE [WINDOWS] LocalShrink (a: HLOCAL; b: UINT): UINT;
PROCEDURE [WINDOWS] LocalSize (a: HLOCAL): UINT;
PROCEDURE [WINDOWS] LocalUnlock (a: HLOCAL): BOOL;
PROCEDURE [WINDOWS] LockInput (h1: HANDLE; hwndInput: HWND; fLock: BOOL): BOOL;
PROCEDURE [WINDOWS] LockResource (a: HGLOBAL): ADR;
PROCEDURE [WINDOWS] LockSegment (a: UINT): HGLOBAL;
PROCEDURE [WINDOWS] LockWindowUpdate (hwndLock: HWND): BOOL;
PROCEDURE [WINDOWS] LogError (err: UINT; lpInfo: ADR);
PROCEDURE [WINDOWS] LogParamError (err: UINT; lpfn: FARPROC; param: ADR);
PROCEDURE [WINDOWS] LPtoDP (a: HDC; b: ADR; c: INTEGER): BOOL;
PROCEDURE [WINDOWS] lstrcat (a: ADR; b: ADR): ADR;
PROCEDURE [WINDOWS] lstrcmp (a: ADR; b: ADR): INTEGER;
PROCEDURE [WINDOWS] lstrcmpi (a: ADR; b: ADR): INTEGER;
PROCEDURE [WINDOWS] lstrcpy (a: ADR; b: ADR): ADR;
PROCEDURE [WINDOWS] lstrcpyn (a: ADR; b: ADR; c: INTEGER): ADR;
PROCEDURE [WINDOWS] lstrlen (a: ADR): INTEGER;
PROCEDURE [WINDOWS] MakeProcInstance (a: FARPROC; b: HINSTANCE): FARPROC;
PROCEDURE [WINDOWS] MapDialogRect (a: HWND; b: ADR);
PROCEDURE [WINDOWS] MapVirtualKey (a: UINT; b: UINT): UINT;
PROCEDURE [WINDOWS] MapWindowPoints (hwndFrom: HWND; hwndTo: HWND; lppt: ADR; cpt: UINT);
PROCEDURE [WINDOWS] MessageBeep (a: UINT);
PROCEDURE [WINDOWS] MessageBox (a: HWND; b: ADR; c: ADR; d: UINT): INTEGER;
PROCEDURE [WINDOWS] ModifyMenu (a: HMENU; b: UINT; c: UINT; d: UINT; e: ADR): BOOL;
PROCEDURE [WINDOWS] MoveTo (a: HDC; b: INTEGER; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] MoveToEx (a: HDC; b: INTEGER; c: INTEGER; d: ADR): BOOL;
PROCEDURE [WINDOWS] MoveWindow (a: HWND; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: BOOL): BOOL;
PROCEDURE [WINDOWS] MulDiv (a: INTEGER; b: INTEGER; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] OemKeyScan (a: UINT): DWORD;
PROCEDURE [WINDOWS] OemToAnsiBuff (a: ADR; b: ADR; c: UINT);
PROCEDURE [WINDOWS] OffsetClipRgn (a: HDC; b: INTEGER; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] OffsetRect (a: ADR; b: INTEGER; c: INTEGER);
PROCEDURE [WINDOWS] OffsetRgn (a: HRGN; b: INTEGER; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] OffsetViewportOrg (a: HDC; b: INTEGER; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] OffsetViewportOrgEx (a: HDC; b: INTEGER; c: INTEGER; d: ADR): BOOL;
PROCEDURE [WINDOWS] OffsetWindowOrg (a: HDC; b: INTEGER; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] OffsetWindowOrgEx (a: HDC; b: INTEGER; c: INTEGER; d: ADR): BOOL;
PROCEDURE [WINDOWS] OpenClipboard (a: HWND): BOOL;
PROCEDURE [WINDOWS] OpenComm (a: ADR; b: UINT; c: UINT): INTEGER;
PROCEDURE [WINDOWS] OpenDriver (szDriverName: ADR; szSectionName: ADR; lParam2: ADR): HDRVR;
PROCEDURE [WINDOWS] OpenFile (a: ADR; b: ADR; c: UINT): HFILE;
PROCEDURE [WINDOWS] OpenIcon (a: HWND): BOOL;
PROCEDURE [WINDOWS] OpenSound (): INTEGER;
PROCEDURE [WINDOWS] OutputDebugString (a: ADR);
PROCEDURE [WINDOWS] PaintRgn (a: HDC; b: HRGN): BOOL;
PROCEDURE [WINDOWS] PatBlt (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: DWORD): BOOL;
PROCEDURE [WINDOWS] PeekMessage (a: ADR; b: HWND; c: UINT; d: UINT; e: UINT): BOOL;
PROCEDURE [WINDOWS] Pie (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: INTEGER; g: INTEGER; h: INTEGER; i: INTEGER): BOOL;
PROCEDURE [WINDOWS] PlayMetaFile (a: HDC; b: HMETAFILE): BOOL;
PROCEDURE [WINDOWS] PlayMetaFileRecord (a: HDC; b: ADR; c: ADR; d: UINT);
PROCEDURE [WINDOWS] Polygon (a: HDC; b: ADR; c: INTEGER): BOOL;
PROCEDURE [WINDOWS] Polyline (a: HDC; b: ADR; c: INTEGER): BOOL;
PROCEDURE [WINDOWS] PolyPolygon (a: HDC; b: ADR; c: ADR; d: INTEGER): BOOL;
PROCEDURE [WINDOWS] PostAppMessage (a: HTASK; b: UINT; c: WPARAM; d: ADR): BOOL;
PROCEDURE [WINDOWS] PostMessage (a: HWND; b: UINT; c: WPARAM; d: ADR): BOOL;
PROCEDURE [WINDOWS] PostQuitMessage (a: INTEGER);
PROCEDURE [WINDOWS] PrestoChangoSelector (sourceSel: UINT; destSel: UINT): UINT;
PROCEDURE [WINDOWS] ProfClear ();
PROCEDURE [WINDOWS] ProfFinish ();
PROCEDURE [WINDOWS] ProfFlush ();
PROCEDURE [WINDOWS] ProfInsChk (): INTEGER;
PROCEDURE [WINDOWS] ProfSampRate (a: INTEGER; b: INTEGER);
PROCEDURE [WINDOWS] ProfSetup (a: INTEGER; b: INTEGER);
PROCEDURE [WINDOWS] ProfStart ();
PROCEDURE [WINDOWS] ProfStop ();
PROCEDURE [WINDOWS] PtInRect (a: ADR; b: POINT): BOOL;
PROCEDURE [WINDOWS] PtInRegion (a: HRGN; b: INTEGER; c: INTEGER): BOOL;
PROCEDURE [WINDOWS] PtVisible (a: HDC; b: INTEGER; c: INTEGER): BOOL;
PROCEDURE [WINDOWS] QueryAbort (a: HDC; b: INTEGER): BOOL;
PROCEDURE [WINDOWS] QuerySendMessage (h1: HANDLE; h2: HANDLE; h3: HANDLE; lpmsg: ADR): BOOL;
PROCEDURE [WINDOWS] ReadComm (a: INTEGER; b: ADR; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] RealizePalette (a: HDC): UINT;
PROCEDURE [WINDOWS] Rectangle (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER): BOOL;
PROCEDURE [WINDOWS] RectInRegion (a: HRGN; b: ADR): BOOL;
PROCEDURE [WINDOWS] RectVisible (a: HDC; b: ADR): BOOL;
PROCEDURE [WINDOWS] RedrawWindow (hwnd: HWND; lprcUpdate: ADR; hrgnUpdate: HRGN; flags: UINT): BOOL;
PROCEDURE [WINDOWS] RegisterClass (a: ADR): ATOM;
PROCEDURE [WINDOWS] RegisterClipboardFormat (a: ADR): UINT;
PROCEDURE [WINDOWS] RegisterWindowMessage (a: ADR): UINT;
PROCEDURE [WINDOWS] ReleaseCapture ();
PROCEDURE [WINDOWS] ReleaseDC (a: HWND; b: HDC): INTEGER;
PROCEDURE [WINDOWS] RemoveFontResource (a: ADR): BOOL;
PROCEDURE [WINDOWS] RemoveMenu (a: HMENU; b: UINT; c: UINT): BOOL;
PROCEDURE [WINDOWS] RemoveProp (a: HWND; b: ADR): HANDLE;
PROCEDURE [WINDOWS] ReplyMessage (a: LRESULT);
PROCEDURE [WINDOWS] ResizePalette (a: HPALETTE; b: UINT): BOOL;
PROCEDURE [WINDOWS] RestoreDC (a: HDC; b: INTEGER): BOOL;
PROCEDURE [WINDOWS] RoundRect (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: INTEGER; g: INTEGER): BOOL;
PROCEDURE [WINDOWS] SaveDC (a: HDC): INTEGER;
PROCEDURE [WINDOWS] ScaleViewportExt (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER): DWORD;
PROCEDURE [WINDOWS] ScaleViewportExtEx (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: ADR): BOOL;
PROCEDURE [WINDOWS] ScaleWindowExt (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER): DWORD;
PROCEDURE [WINDOWS] ScaleWindowExtEx (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: ADR): BOOL;
PROCEDURE [WINDOWS] ScreenToClient (a: HWND; b: ADR);
PROCEDURE [WINDOWS] ScrollDC (a: HDC; b: INTEGER; c: INTEGER; d: ADR; e: ADR; f: HRGN; g: ADR): BOOL;
PROCEDURE [WINDOWS] ScrollWindow (a: HWND; b: INTEGER; c: INTEGER; d: ADR; e: ADR);
PROCEDURE [WINDOWS] ScrollWindowEx (hwnd: HWND; dx: INTEGER; dy: INTEGER; prcScroll: ADR; prcClip: ADR; hrgnUpdate: HRGN; prcUpdate: ADR; flags: UINT): INTEGER;
PROCEDURE [WINDOWS] SelectClipRgn (a: HDC; b: HRGN): INTEGER;
PROCEDURE [WINDOWS] SelectObject (a: HDC; b: HGDIOBJ): HGDIOBJ;
PROCEDURE [WINDOWS] SelectPalette (a: HDC; b: HPALETTE; c: BOOL): HPALETTE;
PROCEDURE [WINDOWS] SendDlgItemMessage (a: HWND; b: INTEGER; c: UINT; d: WPARAM; e: ADR): LRESULT;
PROCEDURE [WINDOWS] SendDriverMessage (hDriver: HDRVR; message: UINT; lParam1: ADR; lParam2: ADR): LRESULT;
PROCEDURE [WINDOWS] SendMessage (a: HWND; b: UINT; c: WPARAM; d: ADR): LRESULT;
PROCEDURE [WINDOWS] SetAbortProc (a: HDC; b: FARPROC): INTEGER;
PROCEDURE [WINDOWS] SetActiveWindow (a: HWND): HWND;
PROCEDURE [WINDOWS] SetBitmapBits (a: HBITMAP; b: DWORD; c: ADR): LONGINT;
PROCEDURE [WINDOWS] SetBitmapDimension (a: HBITMAP; b: INTEGER; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] SetBitmapDimensionEx (a: HBITMAP; b: INTEGER; c: INTEGER; d: ADR): BOOL;
PROCEDURE [WINDOWS] SetBkColor (a: HDC; b: COLORREF): COLORREF;
PROCEDURE [WINDOWS] SetBkMode (a: HDC; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetBoundsRect (hDC: HDC; lprcBounds: ADR; flags: UINT): UINT;
PROCEDURE [WINDOWS] SetBrushOrg (a: HDC; b: INTEGER; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] SetCapture (a: HWND): HWND;
PROCEDURE [WINDOWS] SetCaretBlinkTime (a: UINT);
PROCEDURE [WINDOWS] SetCaretPos (a: INTEGER; b: INTEGER);
PROCEDURE [WINDOWS] SetClassLong (a: HWND; b: INTEGER; c: LONGINT): LONGINT;
PROCEDURE [WINDOWS] SetClassWord (a: HWND; b: INTEGER; c: WORD): WORD;
PROCEDURE [WINDOWS] SetClipboardData (a: UINT; b: HANDLE): HANDLE;
PROCEDURE [WINDOWS] SetClipboardViewer (a: HWND): HWND;
PROCEDURE [WINDOWS] SetCommBreak (a: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetCommEventMask (a: INTEGER; b: UINT): ADR;
PROCEDURE [WINDOWS] SetCommState (a: ADR): INTEGER;
PROCEDURE [WINDOWS] SetCursor (a: HCURSOR): HCURSOR;
PROCEDURE [WINDOWS] SetCursorPos (a: INTEGER; b: INTEGER);
PROCEDURE [WINDOWS] SetDIBits (a: HDC; b: HBITMAP; c: UINT; d: UINT; e: ADR; f: ADR; g: UINT): INTEGER;
PROCEDURE [WINDOWS] SetDIBitsToDevice (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: INTEGER; g: INTEGER; h: UINT; i: UINT; j: ADR; k: ADR; l: UINT): INTEGER;
PROCEDURE [WINDOWS] SetDlgItemInt (a: HWND; b: INTEGER; c: UINT; d: BOOL);
PROCEDURE [WINDOWS] SetDlgItemText (a: HWND; b: INTEGER; c: ADR);
PROCEDURE [WINDOWS] SetDoubleClickTime (a: UINT);
PROCEDURE [WINDOWS] SetEnvironment (a: ADR; b: ADR; c: UINT): INTEGER;
PROCEDURE [WINDOWS] SetErrorMode (a: UINT): UINT;
PROCEDURE [WINDOWS] SetFocus (a: HWND): HWND;
PROCEDURE [WINDOWS] SetHandleCount (a: UINT): UINT;
PROCEDURE [WINDOWS] SetKeyboardState (a: ADR);
PROCEDURE [WINDOWS] SetMapMode (a: HDC; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetMapperFlags (a: HDC; b: DWORD): DWORD;
PROCEDURE [WINDOWS] SetMenu (a: HWND; b: HMENU): BOOL;
PROCEDURE [WINDOWS] SetMenuItemBitmaps (a: HMENU; b: UINT; c: UINT; d: HBITMAP; e: HBITMAP): BOOL;
PROCEDURE [WINDOWS] SetMessageQueue (a: INTEGER): BOOL;
PROCEDURE [WINDOWS] SetMetaFileBits (a: HGLOBAL): HMETAFILE;
PROCEDURE [WINDOWS] SetMetaFileBitsBetter (a: HGLOBAL): HMETAFILE;
PROCEDURE [WINDOWS] SetPaletteEntries (a: HPALETTE; b: UINT; c: UINT; d: ADR): UINT;
PROCEDURE [WINDOWS] SetParent (a: HWND; b: HWND): HWND;
PROCEDURE [WINDOWS] SetPixel (a: HDC; b: INTEGER; c: INTEGER; d: COLORREF): COLORREF;
PROCEDURE [WINDOWS] SetPolyFillMode (a: HDC; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetProp (a: HWND; b: ADR; c: HANDLE): BOOL;
PROCEDURE [WINDOWS] SetRect (a: ADR; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER);
PROCEDURE [WINDOWS] SetRectEmpty (a: ADR);
PROCEDURE [WINDOWS] SetRectRgn (a: HRGN; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER);
PROCEDURE [WINDOWS] SetResourceHandler (a: HINSTANCE; b: ADR; c: FARPROC): FARPROC;
PROCEDURE [WINDOWS] SetROP2 (a: HDC; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetScrollPos (a: HWND; b: INTEGER; c: INTEGER; d: BOOL): INTEGER;
PROCEDURE [WINDOWS] SetScrollRange (a: HWND; b: INTEGER; c: INTEGER; d: INTEGER; e: BOOL);
PROCEDURE [WINDOWS] SetSelectorBase (a: UINT; b: DWORD): UINT;
PROCEDURE [WINDOWS] SetSelectorLimit (a: UINT; b: DWORD): UINT;
PROCEDURE [WINDOWS] SetSoundNoise (a: INTEGER; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetStretchBltMode (a: HDC; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetSwapAreaSize (a: UINT): LONGINT;
PROCEDURE [WINDOWS] SetSysColors (a: INTEGER; b: ADR; c: ADR);
PROCEDURE [WINDOWS] SetSysModalWindow (a: HWND): HWND;
PROCEDURE [WINDOWS] SetSystemPaletteUse (a: HDC; b: UINT): UINT;
PROCEDURE [WINDOWS] SetTextAlign (a: HDC; b: UINT): UINT;
PROCEDURE [WINDOWS] SetTextCharacterExtra (a: HDC; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetTextColor (a: HDC; b: COLORREF): COLORREF;
PROCEDURE [WINDOWS] SetTextJustification (a: HDC; b: INTEGER; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetTimer (a: HWND; b: UINT; c: UINT; d: FARPROC): UINT;
PROCEDURE [WINDOWS] SetViewportExt (a: HDC; b: INTEGER; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] SetViewportExtEx (a: HDC; b: INTEGER; c: INTEGER; d: ADR): BOOL;
PROCEDURE [WINDOWS] SetViewportOrg (a: HDC; b: INTEGER; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] SetViewportOrgEx (a: HDC; b: INTEGER; c: INTEGER; d: ADR): BOOL;
PROCEDURE [WINDOWS] SetVoiceAccent (a: INTEGER; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetVoiceEnvelope (a: INTEGER; b: INTEGER; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetVoiceNote (a: INTEGER; b: INTEGER; c: INTEGER; d: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetVoiceQueueSize (a: INTEGER; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetVoiceSound (a: INTEGER; b: DWORD; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetVoiceThreshold (a: INTEGER; b: INTEGER): INTEGER;
PROCEDURE [WINDOWS] SetWinDebugInfo (lpwdi: ADR): BOOL;
PROCEDURE [WINDOWS] SetWindowExt (a: HDC; b: INTEGER; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] SetWindowExtEx (a: HDC; b: INTEGER; c: INTEGER; d: ADR): BOOL;
PROCEDURE [WINDOWS] SetWindowLong (a: HWND; b: INTEGER; c: LONGINT): LONGINT;
PROCEDURE [WINDOWS] SetWindowOrg (a: HDC; b: INTEGER; c: INTEGER): DWORD;
PROCEDURE [WINDOWS] SetWindowOrgEx (a: HDC; b: INTEGER; c: INTEGER; d: ADR): BOOL;
PROCEDURE [WINDOWS] SetWindowPlacement (a: HWND; b: ADR): BOOL;
PROCEDURE [WINDOWS] SetWindowPos (a: HWND; b: HWND; c: INTEGER; d: INTEGER; e: INTEGER; f: INTEGER; g: UINT): BOOL;
PROCEDURE [WINDOWS] SetWindowsHook (a: INTEGER; b: FARPROC): FARPROC;
PROCEDURE [WINDOWS] SetWindowsHookEx (idHook: INTEGER; lpfn: FARPROC; hInstance: HINSTANCE; hTask: HTASK): HHOOK;
PROCEDURE [WINDOWS] SetWindowText (a: HWND; b: ADR);
PROCEDURE [WINDOWS] SetWindowWord (a: HWND; b: INTEGER; c: WORD): WORD;
PROCEDURE [WINDOWS] ShowCaret (a: HWND);
PROCEDURE [WINDOWS] ShowCursor (a: BOOL): INTEGER;
PROCEDURE [WINDOWS] ShowOwnedPopups (a: HWND; b: BOOL);
PROCEDURE [WINDOWS] ShowScrollBar (a: HWND; b: INTEGER; c: BOOL);
PROCEDURE [WINDOWS] ShowWindow (a: HWND; b: INTEGER): BOOL;
PROCEDURE [WINDOWS] SizeofResource (a: HINSTANCE; b: HRSRC): DWORD;
PROCEDURE [WINDOWS] SpoolFile (a: ADR; b: ADR; c: ADR; d: ADR): HANDLE;
PROCEDURE [WINDOWS] StartDoc (a: HDC; b: ADR): INTEGER;
PROCEDURE [WINDOWS] StartPage (a: HDC): INTEGER;
PROCEDURE [WINDOWS] StartSound (): INTEGER;
PROCEDURE [WINDOWS] StopSound (): INTEGER;
PROCEDURE [WINDOWS] StretchBlt (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: HDC; g: INTEGER; h: INTEGER; i: INTEGER; j: INTEGER; k: DWORD): BOOL;
PROCEDURE [WINDOWS] StretchDIBits (a: HDC; b: INTEGER; c: INTEGER; d: INTEGER; e: INTEGER; f: INTEGER; g: INTEGER; h: INTEGER; i: INTEGER; j: ADR; k: ADR; l: UINT; m: DWORD): INTEGER;
PROCEDURE [WINDOWS] SubtractRect (a: ADR; b: ADR; c: ADR): BOOL;
PROCEDURE [WINDOWS] SwapMouseButton (a: BOOL): BOOL;
PROCEDURE [WINDOWS] SwapRecording (a: UINT);
PROCEDURE [WINDOWS] SwitchStackBack ();
PROCEDURE [WINDOWS] SwitchStackTo (a: UINT; b: UINT; c: UINT);
PROCEDURE [WINDOWS] SyncAllVoices (): INTEGER;
PROCEDURE [WINDOWS] SystemParametersInfo (a: UINT; b: UINT; c: ADR; d: UINT): BOOL;
PROCEDURE [WINDOWS] TabbedTextOut (a: HDC; b: INTEGER; c: INTEGER; d: ADR; e: INTEGER; f: INTEGER; g: ADR; h: INTEGER): LONGINT;
PROCEDURE [WINDOWS] TextOut (a: HDC; b: INTEGER; c: INTEGER; d: ADR; e: INTEGER): BOOL;
PROCEDURE [WINDOWS] Throw (a: ADR; b: INTEGER);
PROCEDURE [WINDOWS] ToAscii (wVirtKey: UINT; wScanCode: UINT; lpKeyState: ADR; lpChar: ADR; wFlags: UINT): INTEGER;
PROCEDURE [WINDOWS] TrackPopupMenu (a: HMENU; b: UINT; c: INTEGER; d: INTEGER; e: INTEGER; f: HWND; g: ADR): BOOL;
PROCEDURE [WINDOWS] TranslateAccelerator (a: HWND; b: HACCEL; c: ADR): INTEGER;
PROCEDURE [WINDOWS] TranslateMDISysAccel (a: HWND; b: ADR): BOOL;
PROCEDURE [WINDOWS] TranslateMessage (a: ADR): BOOL;
PROCEDURE [WINDOWS] TransmitCommChar (a: INTEGER; b: CHAR): INTEGER;
PROCEDURE [WINDOWS] UngetCommChar (a: INTEGER; b: CHAR): INTEGER;
PROCEDURE [WINDOWS] UnhookWindowsHook (a: INTEGER; b: FARPROC): BOOL;
PROCEDURE [WINDOWS] UnhookWindowsHookEx (hHook: HHOOK): BOOL;
PROCEDURE [WINDOWS] UnionRect (a: ADR; b: ADR; c: ADR): BOOL;
PROCEDURE [WINDOWS] UnlockSegment (a: UINT);
PROCEDURE [WINDOWS] UnrealizeObject (a: HGDIOBJ): BOOL;
PROCEDURE [WINDOWS] UnregisterClass (a: ADR; b: HINSTANCE): BOOL;
PROCEDURE [WINDOWS] UpdateColors (a: HDC): INTEGER;
PROCEDURE [WINDOWS] UpdateWindow (a: HWND);
PROCEDURE [WINDOWS] ValidateCodeSegments ();
PROCEDURE [WINDOWS] ValidateFreeSpaces ();
PROCEDURE [WINDOWS] ValidateRect (a: HWND; b: ADR);
PROCEDURE [WINDOWS] ValidateRgn (a: HWND; b: HRGN);
PROCEDURE [WINDOWS] VkKeyScan (a: UINT): UINT;
PROCEDURE [WINDOWS] WaitMessage ();
PROCEDURE [WINDOWS] WaitSoundState (a: INTEGER): INTEGER;
PROCEDURE [WINDOWS] WindowFromPoint (a: POINT): HWND;
PROCEDURE [WINDOWS] WinExec (a: ADR; b: UINT): UINT;
PROCEDURE [WINDOWS] WinHelp (hwndMain: HWND; lpszHelp: ADR; usCommand: UINT; ulData: DWORD): BOOL;
PROCEDURE [WINDOWS] WNetAddConnection (a: ADR; b: ADR; c: ADR): UINT;
PROCEDURE [WINDOWS] WNetCancelConnection (a: ADR; b: BOOL): UINT;
PROCEDURE [WINDOWS] WNetGetConnection (a: ADR; b: ADR; c: ADR): UINT;
PROCEDURE [WINDOWS] WriteComm (a: INTEGER; b: ADR; c: INTEGER): INTEGER;
PROCEDURE [WINDOWS] WritePrivateProfileString (a: ADR; b: ADR; c: ADR; d: ADR): BOOL;
PROCEDURE [WINDOWS] WriteProfileString (a: ADR; b: ADR; c: ADR): BOOL;
PROCEDURE [WINDOWS] wvsprintf (lpszOut: ADR; lpszFmt: ADR; lpParams: ADR): INTEGER;
PROCEDURE [WINDOWS] Yield ();
PROCEDURE [WINDOWS] _lclose (a: HFILE): HFILE;
PROCEDURE [WINDOWS] _lcreat (a: ADR; b: INTEGER): HFILE;
PROCEDURE [WINDOWS] _llseek (a: HFILE; b: LONGINT; c: INTEGER): LONGINT;
PROCEDURE [WINDOWS] _lopen (a: ADR; b: INTEGER): HFILE;
PROCEDURE [WINDOWS] _lread (a: HFILE; b: ADR; c: UINT): UINT;
PROCEDURE [WINDOWS] _lwrite (a: HFILE; b: ADR; c: UINT): UINT;

END Windows.
