' Sample program to update a database
' plus automatically re-use deleted space.
' plus add DBdll indexing
' Brosco - June 98 (Newsletter #10)
'

'    nomainwin        'Comment this out if you want to see the
                     'Database after each update

    open "dbdll.dll" for dll as #db
                        ' Use version displayed here when reporting
                        ' any bugs / comments about DBdll
    calldll #db, "GetVersion", result as short
    print "DBdll Version: ";result


    open "video4.txt" for random as #f len=55
    field #f, _
        1 as active$, _
        6 as casNum$, _          ' The KEY to the DB
        24 as name$, _
        24 as mainActor$

    fn$ = "video4.idx" + chr$(0)

    if lof(#f)/55 = 0 then       ' Empty DB - create CONTROL Rec
        casNum$ = "0"
        mainActor$ = "(Control Record)"
        put #f, 1
                            ' Create the Index -

        calldll #db, "CreateIndex", _
            fn$ as ptr,_     ' Full path to the index file
            6 as word, _     ' Length of the key - maximum 127 bytes
            0 as word, _     ' 0 = No duplicates , 1=Duplicates OK
            result as word   ' 0 = OK, anything else is a file error
        print "Create Index returned:";result
        end if

' Open the Index file for processing

    calldll #db, "OpenIndex", _
        fn$ as ptr, _      ' File name used in CreateIndex
        0 as word, _       ' Share mode
        0 as word, _       ' Normal operation
        hx as word         ' Handle of the Index file to be
                           ' used in subsequent calls
    print "Open Index returned:";hx




    WindowWidth = 320
    WindowHeight = 230

    statictext #w.1, "Cassette Number:", 10, 40, 130, 20
    statictext #w.2, "Movie Name:", 10, 70, 130, 20
    statictext #w.3, "Main Star:", 10, 100, 130, 20
    statictext #w.4, "Status:", 10, 175, 65, 20
    statictext #w.status, "", 80, 175, 240, 20

    textbox #w.cn, 150, 40, 50, 25
    textbox #w.movie, 150, 70, 150, 25
    textbox #w.star, 150, 100, 150, 25

    button #w.add, "Add", [add.movie], UL, 70, 140, 50, 25
    button #w.upd, "Update", [update.movie], UL, 130, 140, 50, 25
    button #w.del, "Delete", [delete.movie], UL, 190, 140, 50, 25
    button #w.exit, "Quit", [close.w], UL, 250, 140, 50, 25

    button #w.prev, "<--Prev", [previous], UL, 70, 5, 60, 25
    button #w.next, "Next -->", [next], UL, 160, 5, 60, 25

    button #w.default, "Get", [get.movie], UL, 10, 140, 50, 25

    open "Movie Database" for dialog as #w
    print #w, "trapclose [close.w]"
    print #w.cn, "!setfocus"

    print "DB at start of program"
    gosub [print.db]

'  Position the browser at the start of the database
    calldll #db, "GetFirst", hx as word, "" as ptr, cNum as long
    if cNum > 1 then
        get #f, cNum
        gosub [display.movie]
        end if

[loop]
    print #w.cn, "!setfocus"
    input var$
    goto [loop]

' Notice below that Next and Previous retrieves the record in Key 
' sequence - NOT the sequence that they exist in the database.

[previous]
    CallDll #db, "GetPrevious", hx as word, cNum as long
    if cNum < 2 then     ' Control rec = 1.  cNum = -1  Not Found!
        casNum$ = ""
        name$ = ""
        mainActor$ = ""
    else
        get #f, cNum
        end if
    gosub [display.movie]
    if cNum < 2 then print #w.status, "You are at the start of the database"
    goto [loop]

[next]
    CallDll #db, "GetNext", hx as word, cNum as long
    if cNum < 2 then            ' cNum = -1   - Not Found!
        casNum$ = ""
        name$ = ""
        mainActor$ = ""
    else
        get #f, cNum
        end if
    gosub [display.movie]
    if cNum < 2 then print #w.status, "You are at the end of the database"
    goto [loop]

[display.movie]
    print #w.cn, casNum$
    print #w.movie, name$
    print #w.star, mainActor$ 
    print #w.status, ""
    print #w.cn, "!setfocus"
    return

[print.db]
    print " R# Active casNum Name  "
    for i = 1 to lof(#f) / 55
        get #f,i
        rn$ = right$("000" + str$(i),3) + " "
        print rn$;active$;"      ";casNum$;" ";name$;mainActor$
        next i
    print
    return

[get.movie]
    print #w.cn, "!contents?"
    input #w.cn, casNum$
'                           You can access a record by typing in the
'                           casNum  and clicking on "Get"
    key$ = trim$(casNum$) + chr$(0) + "          "
    CallDll #db, "GetKey", hx as word, key$ as ptr, cNum as long
    if cNum < 2 then
        notice "This key doesn't exist in the database!"
        goto [loop]
        end if

    get #f, cNum
    gosub [display.movie]

'  Keep our Browser in Sync with the position in the DB we are working on
    calldll #db, "GetFirst", hx as word, key$ as ptr, result as long

    goto [loop]


[GetEmptyRec]
    get #f, 1               ' Get the Control rec
    cNum = val(casNum$)
    if cNum = 0 then     ' No deleted space available
        cNum = lof(#f) / 55 + 1
        return
        end if
    get #f, cNum        ' Get the deleted rec
    mainActor$ = "(Control Record)"
    put #f, 1           ' write the Deleted rec as the new Control
    return

[update.movie]
    if cNum < 2 or cNum > lof(#f) / 55 then
        notice "Update Error!" + chr$(13) + _
            "No record to Update!"
        goto [loop]
        end if

    key2delete$ = trim$(casNum$) + chr$(0)

    print #w.cn, "!contents?"
    input #w.cn, casNum$
    key$ = trim$(casNum$) + chr$(0)
    if key$ <> key2delete$ then     ' Check that the new key doesnt exist
        CallDll #db, "GetKey", hx as word, key$ as ptr, result as long
        if result > 0 then
            notice "This key exists  - duplicates not allowed"
            goto [loop]
            end if

        end if
    gosub [write.record]


'  if the 'key' was changed - we musst delete the old and add the new
    if key$ <> key2delete then
        CallDll #db, "DeleteKey", hx as word, key2delete$ as ptr, 0 as long, result as word
        CallDll #db, "AddKey", hx as word, key$ as ptr, cNum as long, result as word
        end if

    print #w.status, "Movie: " + casNum$ + " has been updated."
    goto [loop]

[delete.movie]
    if cNum < 2 or cNum > lof(#f) / 55 then
        notice "Delete Error!" + chr$(13) + _
            "No record to delete!"
        goto [loop]
        end if
    key$ = trim$(casNum$) + chr$(0)
    CallDll #db, "DeleteKey", hx as word, key$ as ptr, 0 as long, result as word

    get #f, 1           ' Get the Control record
    mainActor$ = "(deleted)"
    put #f, cNum        ' Write it to the Deleted space
    casNum$ = str$(cNum)
    mainActor$ = "(Control Record)"
    put #f, 1           ' Write a new control record
    active$ = ""
    name$ = ""
    mainActor$ = ""
    print #w.cn, "!contents?"
    input #w.cn , casNum$
    gosub [display.movie]
    print #w.status, "Movie: " + casNum$ + " has been deleted."
    print "DB After DELETE Record:"
    gosub [print.db]
    goto [loop]

[write.record]
    print #w.movie, "!contents?"
    input #w.movie, name$
    print #w.star, "!contents?"
    input #w.star, mainActor$
    active$ = "1"               ' show the entry is valid
    put #f, cNum
    return

[close.w]
    calldll #db, "CloseIndex", _
        hx as word, _
        result as word

    close #db
    close #w
    close #f
    end

