'  Data Dictionary and DataBase generator
'  Brosco - July 98
'

    open "ctl3dv2.dll" for dll as #ctl3d
    calldll #ctl3d,"Ctl3dRegister",0 as short,result as short
    calldll #ctl3d,"Ctl3dAutoSubclass",0 as short,result as short

    nomainwin
    WindowWidth = 400
    WindowHeight = 480

    dim fields$(50)
    dim idx$(10)
    idx$(1) = "Index # 1"
    idx$(2) = "Index # 2"
    idx$(3) = "Index # 3"
    idx$(4) = "Index # 4"
    idx$(5) = "Index # 5"
    idx$(6) = "Index # 6"
    idx$(7) = "Index # 7"
    idx$(8) = "Index # 8"
    idx$(9) = "Index # 9"
    idx$(10) = "Not Indexed"

    dim kf$(10,3)

    dim info$(10,10)


    statictext #w, "Data File name", 10, 10, 120, 20
    statictext #w, "Description:", 10, 75, 100, 20
    statictext #w, "Field names:", 10, 130, 120, 20

    TextBox #w.fn, 10, 40, 90, 25
    TextBox #w.d, 10, 100, 300, 25

    listbox #w.f, fields$(, [field.click], 10, 155, 250, 250

    button #w.default, "OK", [ok], UL, 110, 40, 50, 25
    button #w.prev, "<-- Prev", [prev], UL, 170, 40, 60, 25
    button #w.next, "Next -->", [next], UL, 240, 40, 60, 25

    button #w.gen, "Generate", [generate], UL, 300, 155, 80, 25

    button #w.help, "Help", [w.help], UL, 300, 240, 80, 25
    button #w.close, "Close", [close.window], UL, 300, 340, 80, 25

    staticText #w.status, "", 10, 415, 380, 50

    open "Data Dictionary" for dialog as #w
    print #w, "trapclose [close.window]"
    Print #w.status, "Enter new file name and 'OK' - or Double-Click fieldName to Update"

    open "dbdll.dll" for dll as #db

    gosub [open.files]
    goto [display.dd]


[loop]
    input var$
    goto [loop]

[w.help]
    helpfile$ = "DD.txt"
    goto [display.help]

[prev]
    callDll #db, "GetPrevious", hdd as word, kref as long
    dbname$ = ""
    desc$ = ""
    flds$ = ""
    if kref > 1 then
        gettrim #dd, kref
        Print #w.status, "Enter new file name and 'OK' - or Double-Click fieldName to Update"
    else
        Print #w.status, "You are at the start of the Database"
        end if
    goto [display.dd]

[next]
    callDll #db, "GetNext", hdd as word, kref as long
    dbname$ = ""
    desc$ = ""
    flds$ = ""
    if kref > 1 then
        gettrim #dd, kref
        Print #w.status, "Enter new file name and 'OK' - or Double-Click fieldName to Update"
    else
        Print #w.status, "You are at the end of the Database"
        end if
    goto [display.dd]

[ok]
    print #w.fn, "!contents?"
    input #w.fn, dbname$
    if dbname$ = "" then [loop]
    if instr(dbname$, ".", 1) > 0 or len(dbname$) > 8 then
        notice "File name: maximum of 8 characters and no extension!"
        goto [ok]
        end if
    dbname$ = upper$(dbname$)
    calldll #db, "GetKey", hdd as word, dbname$ as ptr, kref as long
    redim fields$(50)
    numF = 0
    print #w.f, "reload"

    if kref < 2 then
        Confirm "This Data File is not defined!" + chr$(13) + _
            "Do you want to create it?"; ans$
        if ans$ = "no" then [loop]
        goto [get.fields]
        end if

    gettrim #dd, kref
[display.dd]
    print #w.fn, dbname$ 
    print #w.d, desc$
    i = 1
    redim fields$(50)
    numF = 0
    w1$ = word$(flds$, i)
    while w1$ <> ""
        i = i + 1
        w2$ = word$(flds$, i)
        numF = numF + 1
        fields$(numF) = w1$ + " " + w2$
        i = i + 1
        w1$ = word$(flds$, i)
        wend

    for i = 1 to 9
        idx$(i) = "Index: # " + str$(i)
        next i

    for i = 1 to numF
        a$ = word$(fields$(i), 2)
        if mid$(a$, len(a$)-1,1) = "k" then
            knum = val(right$(a$,1))
            idx$(knum) = "Index: " + word$(fields$(i),1)
            end if
        next i
    print #w.f, "reload"
    goto [loop]

[field.click]
    print #w.f, "selectionindex?"
    input #w.f, fldN
    if fldN < 1 or fldN > numF then goto [loop]
    goto [field.update]
    goto [loop]


[set.dialog.pos]
    struct winRect, _
        orgX as uShort, _
        orgY as uShort, _
        cornerX as uShort, _
        cornerY as uShort
    open "user.dll" for dll as #user
    hndl = hwnd(#w)
    calldll #user, "GetWindowRect", _
        hndl as word, _
        winRect as struct, _
        result as void

    x = winRect.orgX.struct
    y = winRect.orgY.struct

    topLeftX = x
    topLeftY = y

    'put the cursor where the origin of the window should be
    calldll #user, "SetCursorPos", _
        topLeftX as ushort, _
        topLeftY as ushort, _
        result as void

    close #user
    return

[get.fields]

    for i = 1 to 9
        idx$(i) = "Index: # " + str$(i)
        next i

    print #w.d, "!contents?"
    input #w.d, desc$

    gosub [set.dialog.pos]

    WindowWidth= 300
    WindowHeight=130

    statictext #wd, "Description:", 10, 10, 90, 20
    textbox #wd.d, 10, 40, 280, 25

    button #wd.default, "OK", [db.desc], UL, 130, 70, 50, 25

    open "Data File description" for dialog_modal as #wd
    print #wd, "trapclose [db.desc]"
    print #wd.d, desc$
    Print #w.status, "Enter a File Description"
    goto [loop]

[db.desc]
    print #wd.d, "!contents?"
    input #wd.d, desc$
    print #w.d, desc$
    close #wd

    gosub [set.dialog.pos]

    statictext #wf, "Fieldname:", 10, 10, 80, 20
    statictext #wf, "Field Len:", 10, 40, 80, 20

    textbox #wf.fn, 100, 10, 150, 25
    textbox #wf.fl, 100, 40, 40, 25

    button #wf.default, "Add", [add.field], UL, 70, 70, 60, 25
    button #wf.x, "Close", [close.field], UL, 170, 70, 60, 25

    open "Add Fields" for dialog_modal as #wf
    print #wf, "trapclose [close.field]"
    Print #w.status, "Enter Fields and lengths - 'Close' when done."
    goto [loop]

[add.field]
    print #wf.fn, "!contents?"
    input #wf.fn, field$
    field$ = trim$(field$)
    if field$ = "" then
        Notice "You must enter a Field Name!"
        goto [loop]
        end if
    print #wf.fl, "!contents?"
    input #wf.fl, fieldl
    if fieldl < 1 then
        Notice "You must enter a valid field length!"
        goto [loop]
        end if
    field$ = field$ + " " + str$(fieldl)
    numF = numF + 1
    fields$(numF) = field$
    print #w.f, "reload"
    print #wf.fn, ""
    print #wf.fl, ""
    print #wf.fn, "!setfocus"
    goto [loop]

[close.field]
    if numF < 1 then [done.field]
    flds$ = ""
    for i = 1 to numF
        flds$ = flds$ + " " + fields$(i)
        next i
    gosub [add.db]
[done.field]
    close #wf
    Print #w.status, "Double-Click on a Field name to Edit or to Define a KEY Field"
    Notice "Add Fields" + Chr$(13) + _
            "To Edit Fields or to specify a KEY field" + chr$(13) + _
            "Double-Click the FieldName for a list of options."
    goto [loop]

[add.db]
    gosub [getrecnum]
    delFlag$ = ""
    delChn = 0
    put #dd, kref
    CallDll #db, "AddKey", hdd as word, dbname$ as ptr, kref as long, result as word
    if result <> 0 then
        Notice "DB Error - unable to add new key!"
        end if
    return

[getrecnum]
    kref = lof(#dd) / 2048 + 1
    return

[open.files]
    open "datadict.dat" for random as #dd len=2048
    field #dd, _
        4 as delChn, _
        8 as dbname$, _
        32 as desc$, _
        2004 as flds$
    if lof(#dd) = 0 then
        delChn = 0
        put #dd, 1
        callDll #db, "CreateIndex",  _
            "datadict.idx" as ptr, _
            8 as word, _
            0 as word, _
            result as word
        end if
    callDll #db, "OpenIndex", "datadict.idx" as ptr, _
        0 as word, 0 as word, hdd as word
    if hdd < 1 then
        Notice "Unable to open Database!"
        goto [close.window]
        end if
    callDll #db, "GetFirst", hdd as word, "" as ptr, kref as long
    if kref > 1 then  gettrim #dd, kref
    return

[generate]
    id$ = "    "
    q$ = chr$(34)
    if dbname$ = "" then
        Notice "No Data File name has been specified."
        goto [loop]
        end if
    if numF = 0 then
        Notice "This file doesn't have and fields"
        goto [loop]
        end if
    dblen = 0
    for i = 1 to numF
        dblen = dblen + val(word$(fields$(i), 2))
        next i
    dblen = dblen + 8

    redim kf$(10,3)
    for i = 1 to numF
        a$ = word$(fields$(i), 2)
        idxSize = val(a$)
        if mid$(a$, len(a$)-1, 1) = "k" then
            j = val(right$(a$,1))
            kf$(j,1) = word$(fields$(i), 1)
            kf$(j,2) = str$(idxSize)
            if mid$(a$, len(a$)-2, 1) = "U" then
                kf$(j,3) = "0"
            else
                kf$(j,3) = "1"
                end if
            end if
        next i
    i = 1
    while (i < 10) and kf$(i,1) = "": i = i + 1: wend
    if i > 9 then
        Notice "Generate Code" + chr$(13) + _
            "No KEY field has been specified" + chr$(13) + _
            "Double-Click a FieldName for options!"
        goto [loop]
        end if

    files DefaultDir$, dbname$ + ".bas", info$(
    if val(info$(0,0)) > 0 then
        Confirm dbname$ + ".bas  Exists!  Is it OK to Overwrite it?";ans$
        if ans$ = "no" then [loop]
        end if

    open dbname$ + ".bas" for output as #f
    print #f, "'  " + dbname$ + ".bas: Generated by Brosco's Data Dictionary."
    print #f, "'"
    print #f, "'  #w" + dbname$ + ": is used for the Window Handle"
    print #f, "'  #" + dbname$ + ":  is the handle of the Data File"
    print #f, "'  h" + dbname$ + "n:  is the handle for the handle for the Index"
    print #f, "'"
    print #f, id$ + "nomainwin"
    print #f, id$ + "WindowWidth = 640"
    print #f, id$ + "WindowHeight = 480"

' The Search Section window code
    print #f, id$ + "TextBox #w" + dbname$ + ".search, 505, 30, 120, 25"
    print #f, id$ + "Button #w" +dbname$ + ".srch, " + q$ + "Search" + q$ + _
            ", [search." + dbname$ + "], UL, 535, 60, 60, 25"
    print #f, id$ + "Button #w" +dbname$ + ".prev, " + q$ + "<-- Prev" + q$ + _
            ", [prev." + dbname$ + "], UL, 505, 90, 60, 25"
    print #f, id$ + "Button #w" +dbname$ + ".next, " + q$ + "Next -->" + q$ + _
            ", [next." + dbname$ + "], UL, 570, 90, 60, 25"
    j = 1
    for i = 1 to 9
        if kf$(i,1) <> "" then
        print #f, id$ + "RadioButton #w" + dbname$ + ".rb" + str$(i) + _
            ", " + q$ + kf$(i,1) + q$ + ", [" + dbname$ + ".setrb" + _
            str$(i) + "], [" + dbname$ + ".resetrb], 510, " + _
            str$((j*30) + 90) + ", 120, 25"
        j = j + 1
        end if
        next i
    print #f, id$ + "CheckBox #w" + dbname$ + ".wild, " + _
            q$ + "Use WildCards" + q$ + ", [" + _
            dbname$ + ".wildset], [" + dbname$ + ".wildreset], 510, " + _
            str$((j*30) + 120) + ", 120, 25"

    print #f, id$ + "GraphicBox #w" + dbname$ + ".gb, 500, 0, 140, 450"
' Generate the default window

    for i = 1 to numF
        print #f, id$ + "StaticText #w" + dbname$ + ".st" + str$(i) + _
            ", " + q$ + word$(fields$(i),1) + q$ + ", 10, " + _
            str$((i-1) * 30 + 10) + ", 130, 20"
        print #f, id$ + "TextBox #w" +dbname$ + ".tb" + str$(i) + _
            ", 150, " + str$((i-1) * 30 + 10) + ", " + _
            str$(val(word$(fields$(i),2))*9) + ", 25"
        next i

    print #f, id$ + "Button #w" + dbname$ + ".add, " + q$ + "Add" + q$ +_
        ", [add." + dbname$ + "], UL, 10, " + _
        str$((i-1) * 30 + 10) + ", 60, 25"
    print #f, id$ + "Button #w" + dbname$ + ".del, " + q$ + "Delete" + q$ +_
        ", [delete." + dbname$ + "], UL, 80, " + _
        str$((i-1) * 30 + 10) + ", 60, 25"
    print #f, id$ + "Button #w" + dbname$ + ".upd, " + q$ + "Update" + q$ +_
        ", [update." + dbname$ + "], UL, 150, " + _
        str$((i-1) * 30 + 10) + ", 60, 25"
    print #f, id$ + "Button #w" + dbname$ + ".quit, " + q$ + "Close" + q$ +_
        ", [close.w" + dbname$ + "], UL, 220, " + _
        str$((i-1) * 30 + 10) + ", 60, 25"
    print #f, id$ + "StaticText #w" + dbname$ + ".status, " + q$ + q$ + ", 10, " + _
        str$(i * 30 + 10) + ", 480, 25"


    print #f, id$ + "Open " + q$ + dbname$ + q$ + " for Dialog as #w" + dbname$
    print #f, id$ + "print #w" + dbname$ + ", " + q$ + _
        "trapclose [close.w" + dbname$ + "]" + q$ 

    print #f, id$ + "print #w" + dbname$ + ".gb, " + _
        q$ + "place 30 20;\Search" + q$

    print #f, id$ + "gosub [open." + dbname$ + "]"
    print #f, id$ + "goto [display." + dbname$ + "]"
    print #f, ""

' Wait for input loop
    print #f, "[loop]"
    print #f, id$ + "input WaitForUser$"
    print #f, id$ + "goto [loop]"
    print #f, ""

' Search code
    print #f, "[" + dbname$ + ".wildset]            ' Allow wildcard searches"
    print #f, id$ + dbname$ + ".wildcard = 1"
    print #f, id$ + "goto [loop]"
    print #f, ""

    print #f, "[" + dbname$ + ".wildreset]          ' Turn OFF wildcard searches"
    print #f, id$ + dbname$ + ".wildcard = 0"
    print #f, id$ + "goto [loop]"
    print #f, ""


    print #f, "[" + dbname$ + ".resetrb]            ' Ignore Index Selection resets"
    print #f, id$ + "goto [loop]"
    print #f, ""

    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, "[" + dbname$ + ".setrb" + str$(i) + "]           ' Index selection to use for searches"
            print #f, id$ + dbname$ + ".index = " + str$(i)
            print #f, id$ + "goto [loop]"
            print #f, ""
            end if
        next i

' Search for First record
    print #f, "[search." + dbname$ + "]             ' Select which index used for searching"
    print #f, id$ + "print #w" + dbname$ + ".search, " + q$ + "!contents?" + q$
    print #f, id$ + "input #w" + dbname$ + ".search, " + dbname$ + ".search$"
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "if " + dbname$ + ".index = " + str$(i) + _
                " then [search." + dbname$ + str$(i) + "]"
            end if
        next i
    print #f, id$ + "goto [loop]"
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, "[search." + dbname$ + str$(i) + "]"
            print #f, id$ + "if " + dbname$ + ".wildcard = 0 then"
            print #f, id$ + id$ + "CallDll #db, " + q$ + "GetFirst" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                dbname$ + ".search$ as ptr, " + _
                dbname$ + ".URN as long"
            print #f, id$ + "else"
            print #f, id$ + id$ + "CallDll #db, " + q$ + "GetWild" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                dbname$ + ".search$ as ptr, " + _
                dbname$ + ".URN as long"
            print #f, id$ + id$ + "end if"
            print #f, id$ + "goto [search." + dbname$ + ".all]"
            end if
        next i
    print #f, "[search." + dbname$ + ".all]             ' Determine if a record was found"
    print #f, id$ + "if " + dbname$ + ".URN < 2 then "
    print #f, id$ + id$ + "print #w" + dbname$ + ".status, " + _
            q$ + "You are at the end of the file!" + q$
    print #f, id$ + id$ + "goto [" + dbname$ + ".blank" + "]"
    print #f, id$ + id$ + "end if"
    print #f, id$ + id$ + "print #w" + dbname$ + ".status, " + q$ + q$
    print #f, id$ + "GetTrim #" + dbname$ + ", " + dbname$ + ".URN"
    print #f, id$ + "goto [display." + dbname$ + "]"
    print #f, ""

' Search for PREVIOUS record
    print #f, "[prev." + dbname$ + "]           ' Determine index used for a PREV command"
    print #f, id$ + "print #w" + dbname$ + ".status, " + q$ + q$
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "if " + dbname$ + ".index = " + str$(i) + _
                " then [prev." + dbname$ + str$(i) + "]"
            end if
        next i
    print #f, id$ + "goto [loop]"
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, "[prev." + dbname$ + str$(i) + "]"
            print #f, id$ + "if " + dbname$ + ".wildcard = 1 then"
            print #f, id$ + id$ + "print #w" + dbname$ + ".status, " + _
                q$ + "Wildcard searches not available for GetPrevious" + q$
            print #f, id$ + id$ + "end if"
            print #f, id$ + "CallDll #db, " + q$ + "GetPrevious" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                dbname$ + ".URN as long"
            print #f, id$ + "goto [prev." + dbname$ + ".all]"
            end if
        next i
    print #f, "[prev." + dbname$ + ".all]                   ' Check if a record was found"
    print #f, id$ + "if " + dbname$ + ".URN < 2 then "
    print #f, id$ + id$ + "print #w" + dbname$ + ".status, " + _
            q$ + "You are at the beginning of the file!" + q$
    print #f, id$ + id$ + "goto [" + dbname$ + ".blank" + "]"
    print #f, id$ + id$ + "end if"
'    print #f, id$ + id$ + "print #w" + dbname$ + ".status, " + q$ + q$
    print #f, id$ + "GetTrim #" + dbname$ + ", " + dbname$ + ".URN"
    print #f, id$ + "goto [display." + dbname$ + "]"
    print #f, ""

' Search for NEXT record
    print #f, "[next." + dbname$ + "]                   ' Determine which index for a NEXT command"
    print #f, id$ + "print #w" + dbname$ + ".status, " + q$ + q$
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "if " + dbname$ + ".index = " + str$(i) + _
                " then [next." + dbname$ + str$(i) + "]"
            end if
        next i
    print #f, id$ + "goto [loop]"
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, "[next." + dbname$ + str$(i) + "]"
            print #f, id$ + "if " + dbname$ + ".wildcard = 0 then"
            print #f, id$ + id$ + "CallDll #db, " + q$ + "GetNext" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                dbname$ + ".URN as long"
            print #f, id$ + "else"
            print #f, id$ + id$ + "CallDll #db, " + q$ + "GetNextWild" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                dbname$ + ".URN as long"
            print #f, id$ + id$ + "end if"
            print #f, id$ + "goto [next." + dbname$ + ".all]"
            end if
        next i
    print #f, "[next." + dbname$ + ".all]               ' Check if a record was found"
    print #f, id$ + "if " + dbname$ + ".URN < 2 then "
    print #f, id$ + id$ + "print #w" + dbname$ + ".status, " + _
            q$ + "You are at the end of the file!" + q$
    print #f, id$ + id$ + "goto [" + dbname$ + ".blank" + "]"
    print #f, id$ + id$ + "end if"
    print #f, id$ + id$ + "print #w" + dbname$ + ".status, " + q$ + q$
    print #f, id$ + "GetTrim #" + dbname$ + ", " + dbname$ + ".URN"
    print #f, id$ + "goto [display." + dbname$ + "]"
    print #f, ""

' Blank out the current record
    print #f, "[" + dbname$ + ".blank]                  ' Sets current record to NULL values"
    for i = 1 to numF
        w$ = word$(fields$(i), 1)
        print #f, id$ + w$ + " = ";
        if right$(w$,1) = "$" then
            print #f, q$ + q$
        else
            print #f, "0"
            end if
        next i

' Display the file code
    print #f, "[display." + dbname$ + "]            ' Displays current record to the screen"
    for i = 1 to numF
        print #f, id$ + "print #w" + dbname$ + ".tb" + str$(i) + _
            ", " + word$(fields$(i), 1)
        next i
    print #f, id$ + "goto [loop]"
    print #f, ""

' Add record to file

    print #f, "[add." + dbname$ + "]                ' ADDing a record to the File"
    for i = 1 to 9
        if kf$(i,3) = "0" then
            print #f, id$ + "print #w" + dbname$ + ".tb" + str$(i) + _
                ", " + q$ + "!contents?" + q$
            print #f, id$ + "input #w" + dbname$ + ".tb" + str$(i) + _
                ", " + kf$(i,1)
            print #f, id$ + "CallDll #db, " + q$ + "GetKey" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                kf$(i,1) + " as ptr, " + dbname$ + ".URN as long"
            print #f, id$ + "if " + dbname$ + ".URN > 1 then Notice " + q$ + _
                "Unique Key: " + q$ + " + " + kf$(i,1) + " + " + _
                q$ + " exists.  Cannot Add!" + q$ + ": goto [loop]"
            end if
        next i
    print #f, "' ****************************************"
    print #f, "' Place any validity checking of input data here"
    print #f, "' ****************************************"
    print #f, id$ + "gosub [GetNextRec." + dbname$ + "]"
    print #f, id$ + "gosub [GetData." + dbname$ + "]"
    print #f, id$ + "Put #" + dbname$ + ", " + dbname$ + ".URN"
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "CallDll #db, " + q$ + "AddKey" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                kf$(i, 1) + " as ptr, " + _
                dbname$ + ".URN as long, result as word"
            end if
        next i
    print #f, id$ + "print #w" + dbname$ + ".status, " + q$ + _
            "Record has been added!" + q$ 
    print #f, id$ + "print #w" + dbname$ + ".tb1, " + q$ + "!setfocus" + q$
    print #f, id$ + "goto [loop]"
    print #f, ""

' Update existing record in file

    print #f, "[update." + dbname$ + "]                 ' Updating an existing record"
    print #f, id$ + "if " + dbname$ + ".URN < 2 or " + dbname$ + ".URN > lof(#" + dbname$ + ") / " + str$(dblen) + " then"
    print #f, id$ + id$ + "Notice " + q$ + "Update error.  No record to update!" + q$
    print #f, id$ + id$ + "goto [loop]"
    print #f, id$ + id$ + "end if"

    for i = 1 to 9
        if kf$(i,3) = "0" then
            print #f, id$ + "print #w" + dbname$ + ".tb" + str$(i) + _
                ", " + q$ + "!contents?" + q$
            print #f, id$ + "input #w" + dbname$ + ".tb" + str$(i) + _
                ", new." + kf$(i,1)
            print #f, id$ + "if new." + kf$(i,1) + " <> " + kf$(i,1) + " then"
            print #f, id$ + id$ +"CallDll #db, " + q$ + "GetKey" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, new." + _
                kf$(i,1) + " as ptr, temp.URN as long"
            print #f, id$ + id$ + "if temp.URN > 1 then Notice " + q$ + _
                "Unique Key: " + q$ + " + " + kf$(i,1) + " + " + _
                q$ + " exists.  Cannot change to this key!" + q$ + ": goto [loop]"
            print #f, id$ + "end if"
            end if
        next i
    print #f, "' ****************************************"
    print #f, "' Place any validity checking of input data here"
    print #f, "' ****************************************"

    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "CallDll #db, " + q$ + "DeleteKey" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                kf$(i,1) + " as ptr, " + dbname$ + ".URN as long, result as word"
            end if
        next i

    print #f, id$ + "gosub [GetData." + dbname$ + "]"
    print #f, id$ + "Put #" + dbname$ + ", " + dbname$ + ".URN"
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "CallDll #db, " + q$ + "AddKey" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                kf$(i, 1) + " as ptr, " + _
                dbname$ + ".URN as long, result as word"
            end if
        next i
    print #f, id$ + "print #w" + dbname$ + ".status, " + q$ + _
            "Record has been updated!" + q$ 
    print #f, id$ + "print #w" + dbname$ + ".tb1, " + q$ + "!setfocus" + q$
    print #f, id$ + "goto [loop]"
    print #f, ""


' Get next available record
    print #f, "[GetNextRec." + dbname$ + "]             ' Get next available rec for an ADD - resuse deleted space"
    print #f, id$ + "get #" + dbname$ + ", 1"
    print #f, id$ + dbname$ + ".URN = delChain"
    print #f, id$ + "if " + dbname$ + ".URN = 0 then"
    print #f, id$ + id$ + dbname$ + ".URN = lof(#" + dbname$ + " ) / " + str$(dblen) + " + 1"
    print #f, id$ + id$ + "return"
    print #f, id$ + id$ + "end if"
    print #f, id$ + "get #" + dbname$ + ", " + dbname$ + ".URN"
    print #f, id$ + "put #" + dbname$ + ", 1"
    print #f, id$ + "return"
    print #f, ""

' Delete a record
    print #f, "[delete." + dbname$ + "]             ' Deleteing a record"
    print #f, id$ + "if " + dbname$ + ".URN < 2 or " + dbname$ + ".URN > lof(#" + dbname$ + ") / " + str$(dblen) + " then"
    print #f, id$ + id$ + "Notice " + q$ + "Delete error.  No record to delete!" + q$
    print #f, id$ + id$ + "goto [loop]"
    print #f, id$ + id$ + "end if"

    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "CallDll #db, " + q$ + "DeleteKey" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                kf$(i,1) + " as ptr, " + _
                dbname$ + ".URN as long, result as word"
            end if
        next i
    print #f, id$ + "get #" + dbname$ + ", 1"
    print #f, id$ + "put #" + dbname$ + ", " + dbname$ + ".URN"
    print #f, id$ + "delChain = " + dbname$ + ".URN"
    print #f, id$ + "put #" + dbname$ + ", 1"
    print #f, id$ + "print #w" + dbname$ + ".status, " + q$ + _
            "Record has been deleted!" + q$ 
    print #f, id$ + "print #w" + dbname$ + ".tb1, " + q$ + "!setfocus" + q$
    print #f, id$ + "goto [" + dbname$ + ".blank]"
    print #f, ""

' Get data from the Dialog Window
    print #f, "[GetData." + dbname$ + "]            ' Retrieve all data entry"
    for i = 1 to numF
        print #f, id$ + "print #w" + dbname$ + ".tb" + str$(i) + _
            ", " + q$ + "!contents?" + q$
        print #f, id$ + "input #w" + dbname$ + ".tb" + str$(i) + _
            ", " + word$(fields$(i),1)
        next i
    print #f, "return"
    print #f, ""


' Open the file and index code
    print #f, "[open." + dbname$ + "]           ' Open the data file and Index files"
    print #f, id$ + "open " + q$ + "dbdll.dll" + q$ + " for dll as #db"
    print #f, id$ + "open " + q$ + dbname$ + ".dat" + q$ + _
                " for random as #" + dbname$ + " len=" + str$(dblen)
    print #f, id$ + "Field #" + dbname$ + ", _"
    for i = 1 to numF
        n$ = word$(fields$(i), 1)
        l$ = str$(val(word$(fields$(i), 2)))
        print #f, id$ + id$ + l$ + " as " + n$ + ", _"
        next i

    idxSize = 8
    unique = 0

    print #f, id$ + id$ + "8 as delChain"
    print #f, id$ + "if lof(#" + dbname$ + ") = 0 then "
    print #f, id$ + id$ + "delChain = 0"
    print #f, id$ + id$ + "put #" + dbname$ + ", 1"


    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + id$ + "CallDll #db, " + _
                q$ + "CreateIndex" + q$ + _
                ", " + q$ + dbname$ + ".ix" + str$(i) + q$ + " as ptr, " + _
                kf$(i,2) + " as word, " + _
                kf$(i,3) + " as word, result as word"
            end if
        next i
    print #f, id$ + id$ + "end if"
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "Calldll #db, " + q$ + "OpenIndex" + q$ + _
                ", " + q$ + dbname$ + ".ix" + str$(i) + q$ + " as ptr, " + _
                   " 0 as word, 0 as word, h" + dbname$ + str$(i) + " as word"
            end if
        next i
    print #f, id$ + dbname$ + ".open = 1"
    i = 1
    while (i < 10) and kf$(i,1) = "": i = i + 1: wend
    print #f, id$ + "print #w" + dbname$ + ".rb" + str$(i) + ", " + _
            q$ + "set" + q$
    print #f, id$ + dbname$ + ".index = " + str$(i)
    print #f, id$ + "callDll #db, " + q$ + "GetFirst" + q$ + _
        ", h" + dbname$ + str$(i) + " as word, " + _
        q$ + q$ + "as ptr, " + dbname$ + ".URN as long"
    print #f, id$ + "if " + dbname$ + ".URN > 1 then"
    print #f, id$ + id$ + "Gettrim #" + dbname$ + ", " + dbname$ + ".URN"
    print #f, id$ + id$ + "end if"

    for i = i + 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "callDll #db, " + q$ + "GetFirst" + q$ + _
                ", h" + dbname$ + str$(i) + " as word, " + _
                q$ + q$ + "as ptr, junk as long"
            end if
        next i
    print #f, id$ + "return"
    print #f, ""

' Close Database code
    print #f, "[close." + dbname$ + "]              ' Close the data file and indexes"
    print #f, id$ + "Close #" + dbname$
    for i = 1 to 9
        if kf$(i,1) <> "" then
            print #f, id$ + "CallDll #db, " + q$ + "CloseIndex" + q$ + _
                   ", h" + dbname$ + str$(i) +" as word, result as word"
            end if
        next i
    print #f, id$ + dbname$ + ".open = 0"
    print #f, id$ + "Return"
    print #f, ""

' Close Window code
    print #f, "[close.w" + dbname$ + "]         ' Close the files - end the program"
    print #f, id$ + "if " + dbname$ + ".open = 1 then gosub [close." + dbname$ + "]"
    print #f, id$ + "close #w" + dbname$
    print #f, id$ + "close #db"
    print #f, id$ + "END"
    close #f
    Notice "Source code has been generated to: " + dbname$ + ".BAS"
    goto [loop]

[display.help]
    WindowWidth = 400
    WindowHeight = 480
    open helpfile$ for input as #fh
    if help.open = 0 then
        open "DD Help" for text as #wh
        print #wh, "!trapclose [close.wh]"
        help.open = 1
        end if
    print #wh, "!cls";
    print #wh, "!contents #fh";
    close #fh
    goto [loop]

[close.wh]
    close #wh
    help.open = 0
    goto [loop]

[field.update]
    knum = 0
    uniqueK$ = "U"
    f$ = word$(fields$(fldN),1)
    a$ = word$(fields$(fldN),2)
    if mid$(a$, len(a$)-1,1) = "k" then
        knum = val(right$(a$,1))
        if mid$(a$, len(a$)-2, 1) = "U" then
            uniqueK$ = "U"
        else
            uniqueK$ = "n"
            end if
        end if
    if knum = 0 then knum = 10
    lenf = val(a$)

    WindowWidth = 584
    WindowHeight = 130

    print #w.status, "Click on Help for more details"

    gosub [set.dialog.pos]

    statictext #wfu.s1, "Field Name:", 14, 16, 88, 20
    textbox #wfu.fn, 110, 11, 100, 25
    statictext #wfu.s3, "Index #", 370, 16, 56, 20
    combobox #wfu.idx, idx$(, [idxClick], 432, 11, 130, 190
    checkBox #wfu.u, " Unique Key?", [uset], [ureset], 432, 40, 130, 25
'    button #wfu.b5, "Make Index", [mIdxClick], UL, 14, 70, 100, 25
    button #wfu.b6, "Insert", [InsertFClick], UL, 128, 70, 88, 25
    button #wfu.b7, "Update", [updateFClick], UL, 230, 70, 80, 25
    button #wfu.b8, "Delete", [deleteFClick], UL, 326, 70, 72, 25
    button #wfu.b9, "Help", [helpFClick], UL, 414, 70, 72, 25
    button #wfu.b10, "Close", [close.wfu], UL, 502, 70, 64, 25
    statictext #wfu.s11, "Length:", 230, 16, 56, 20
    textbox #wfu.len, 302, 11, 48, 25
    open "Field Update:" for dialog_modal as #wfu

    print #wfu, "trapclose [close.wfu]"
    print #wfu.idx, "selectindex ";knum

    print #wfu.fn, f$
    print #wfu.len, lenf

    if uniqueK$ = "U" then
        print #wfu.u, "set"
    else
        print #wfu.u, "reset"
        end if


[wfu.inputLoop]   'wait here for input event
    input aVar$
    goto [wfu.inputLoop]

[helpFClick]
    helpfile$ = "field.txt"
    goto [display.help]



[uset]
    print knum
    uniqueK$ = "U"
    if knum > 0 and knum < 10 then
        fields$(fldN) = left$(fields$(fldN), len(fields$(fldN))-3) + _
            uniqueK$ + right$(fields$(fldN), 2)
        print #w.f, "reload"
        end if
    goto [wfu.inputLoop]

[ureset]
    print knum
    uniqueK$ = "n"
    if knum > 0 and knum < 10 then
        fields$(fldN) = left$(fields$(fldN), len(fields$(fldN))-3) + _
            uniqueK$ + right$(fields$(fldN), 2)
        print #w.f, "reload"
        end if
    goto [wfu.inputLoop]

[get.changes]
    print #wfu.fn, "!contents?"
    input #wfu.fn, f$
    print #wfu.len, "!contents?"
    input #wfu.len, lenf

    fields$(fldN) = f$ + " " + str$(lenf)
    if knum > 0 and knum < 10 then
        fields$(fldN) = fields$(fldN) + uniqueK$ + "k" + str$(knum)
        idx$(knum) = "Index: " + f$
        end if

[update.db]
    flds$ = ""
    for i = 1 to numF
        flds$ = flds$ + " " + fields$(i)
        next i

[close.wfu]
    put #dd, kref
    close #wfu
    print #w.f, "reload"
    Print #w.status, "Double-Click on a Field name to Edit or to Define a KEY Field"
    goto [loop]

[idxClick]
    print #wfu.idx, "selectionindex?"
    input #wfu.idx, temp.knum
    print #wfu.idx, "selection?"
    input #wfu.idx, a$
    a = val(word$(a$,3))
    if (a = 0) and (temp.knum < 10) then
        Notice "This Index is being used by another Field"
        goto [loop]
        end if

    if knum > 0 and knum < 10 then
        idx$(knum) = "Index: # " + str$(knum)
        end if
    print #wfu.idx, "selectionindex?"
    input #wfu.idx, knum
    if knum < 10 and right$(f$,1) <> "$" then
        Notice "Only STRING fileds can be Indexed"
        goto [loop]
        end if
    fields$(fldN) = f$ + " " + str$(lenf)
    if knum > 0 and knum < 10 then
        fields$(fldN) = fields$(fldN) + uniqueK$ + "k" + str$(knum)
        idx$(knum) = "Index: " + f$
        end if

    print #wfu.idx, "reload"
    print #w.f, "reload"
    print #wfu.idx, "selectindex ";knum
    goto [update.db]


[mIdxClick]   'Perform action for the button named 'b5'

    'Insert your own code here

    goto [wfu.inputLoop]


[InsertFClick]
    print #wfu.fn, "!contents?"
    input #wfu.fn, f$
    print #wfu.len, "!contents?"
    input #wfu.len, lenf
    for i = numF+1 to fldN+1 step -1
        fields$(i) = fields$(i-1)
        next i
    numF = numF + 1
    fldN = fldN + 1
    fields$(fldN) = f$ + " " + str$(lenf)
    print #w.f, "reload"
    goto [update.db]

[updateFClick]
    goto [get.changes]

[deleteFClick]
    if knum > 0 and knum < 10 then
        idx$(knum) = "Index: # " + str$(knum)
        end if
    for i = fldN to numF + 1
        fields$(i) = fields$(i+1)
        next i
    numF = numF - 1
    print #w.f, "reload"
    goto [update.db]


[close.window]
    if help.open =  1 then close #wh
    close #w
    close #db
    close #dd
    calldll #ctl3d,"Ctl3dUnregister",0 as short,result as short
    close #ctl3d
    end
