' Demo of Colour Pick DLL
' Brosco August 98 - modified by Alyce
'
'  Uses the CommDlg.dll to access the ChooseColor function.
'  The selected color is returned in 'result'.
'
'  In the Dialog you can define up to 16 Custom colours,
'  These are returned in the 'custcol' STRUCT.
'
cursor hourglass
nomainwin

dim spot(16,3) 'array to hold coords of regions
   'spot(x,1)=x coord
   'spot(x,2)=y coord
   'spot(x,3) is reserved for handle of created region

spot(1,1)=60: spot(1,2)=40   'fill array
spot(2,1)=170: spot(2,2)=40
spot(3,1)=280: spot(3,2)=40
spot(4,1)=390: spot(4,2)=40
spot(5,1)=60: spot(5,2)=100
spot(6,1)=170: spot(6,2)=100
spot(7,1)=280: spot(7,2)=100
spot(8,1)=390: spot(8,2)=100
spot(9,1)=60: spot(9,2)=160
spot(10,1)=170: spot(10,2)=160
spot(11,1)=280: spot(11,2)=160
spot(12,1)=390: spot(12,2)=160
spot(13,1)=60: spot(13,2)=220
spot(14,1)=170: spot(14,2)=220
spot(15,1)=280: spot(15,2)=220
spot(16,1)=390: spot(16,2)=220


WindowWidth=640:WindowHeight=480
UpperLeftX=1:UpperLeftY=1

  button #p.default, "  Colour Choice  ",[paint],UL,10,400
  statictext #p, "Choose up to 16 custom colours.",200,400,400,50
open "Create a Palette" for window_nf as #p

    print #p, "trapclose [quit]"

    hp=hwnd(#p)

    open "gdi" for dll as #gdi
    open "user" for dll as #user

   calldll #user, "GetDC",_
       hp as word,_
       hDC as short

    calldll #gdi, "GetStockObject",_
        _WHITE_BRUSH as word,_
        hWhiteBrush as word


    for i=1 to 16
        gosub [create.region]
        spot(i,3)=hRegn
    next i


    cursor normal
[loop]
    input a$
    goto [loop]


[quit]
    calldll#user,"ReleaseDC",_
        hp as word,_
        hDC as word,_
        result as ushort

    calldll #gdi,"DeleteObject",_
        hBrush as word,_
        r as ushort

close #user:close #gdi
close #p:end


[create.region]'creates elliptical regions to paint later

        UpperLX=spot(i,1):UpperLY=spot(i,2)
        LowerRX=spot(i,1)+100:LowerRY=spot(i,2)+50

    calldll #gdi, "CreateEllipticRgn",_
        UpperLX as short,_
        UpperLY as short,_
        LowerRX as short,_
        LowerRY as short,_
        hRegn as short

    return


[paint]
    open "colorpk.dll" for dll as #cp

    struct custcol, _   ' You can define upto 16 Custom colours
        c1 as long,_
        c2 as long,_
        c3 as long,_
        c4 as long,_
        c5 as long,_
        c6 as long,_
        c7 as long,_
        c8 as long,_
        c9 as long,_
        c10 as long,_
        c11 as long,_
        c12 as long,_
        c13 as long,_
        c14 as long,_
        c15 as long,_
        c16 as long

    CallDll #cp, "ColorPk", custcol as struct, result as long

        textCol=result
    calldll #gdi, "SetTextColor", _
       hDC as word, _
       textCol as long, _
       result as long


        text$="Last Colour Chosen was "+str$(textCol)+SPACE$(15)
        lenText=len(text$)

    calldll#gdi,"TextOut",_
        hDC as word,_
        100 as short,_  'x loc
        350 as short,_  'y loc
        text$ as struct,_
        lenText as short,_
        result as word



    close #cp

[paint.with.colours]
        i=1:spotColor=custcol.c1.struct:gosub [do.it]
        i=2:spotColor=custcol.c2.struct:gosub [do.it]
        i=3:spotColor=custcol.c3.struct:gosub [do.it]
        i=4:spotColor=custcol.c4.struct:gosub [do.it]
        i=5:spotColor=custcol.c5.struct:gosub [do.it]
        i=6:spotColor=custcol.c6.struct:gosub [do.it]
        i=7:spotColor=custcol.c7.struct:gosub [do.it]
        i=8:spotColor=custcol.c8.struct:gosub [do.it]
        i=9:spotColor=custcol.c9.struct:gosub [do.it]
        i=10:spotColor=custcol.c10.struct:gosub [do.it]
        i=11:spotColor=custcol.c11.struct:gosub [do.it]
        i=12:spotColor=custcol.c12.struct:gosub [do.it]
        i=13:spotColor=custcol.c13.struct:gosub [do.it]
        i=14:spotColor=custcol.c14.struct:gosub [do.it]
        i=15:spotColor=custcol.c15.struct:gosub [do.it]
        i=16:spotColor=custcol.c16.struct:gosub [do.it]

    goto [loop]


[do.it] 'set variables for region and brush:
        'black spots or no spots for unfilled spots?
        'if spotColor=0 then spotColor=hexdec("&HFFFFFF")'if no color chosen, use white

        hRegion=spot(i,3)

[delete.prev.brush]

    'first, select a different brush into the dc:
    calldll #gdi,"SelectObject",_
        hDC as word,_
        hWhiteBrush as word,_
        result as word

    'then delete previous brush
    calldll #gdi,"DeleteObject",_
        hBrush as word,_
        r as ushort

[create.new.brush]

    'now you may create a new brush
    calldll #gdi, "CreateSolidBrush",_
        spotColor as dword,_
        hBrush as short

    'select new brush into dc
    calldll #gdi,"SelectObject",_
        hDC as word,_
        hBrush as word,_
        result as word

    'use the new brush to fill the region
   calldll #gdi, "PaintRgn",_
        hDC as word,_
        hRegion as short,_
        result as ushort

return
