' Demo of a Timer CallBack for Animation
    nomainwin
                ' Open the DLL with the Timer Functions
    open "brosco.dll" for dll as #a


' ***********************************************************************
' The following window is used for communications with the TimerDll

    WindowWidth = 100
    WindowHeight = 50
    open "user" for dll as #user
    textbox #wd.tb, 0, 0, 80, 25   ' This will contain a count of "times" called
    open "Callback" for window as #wd
    Print #wd, "trapclose [st.button]"
    Print #wd, "resizehandler [st.button]"  ' This is the [label] activated by timer

'           The following two handles must be passed to the timer
'           They will be used to simulate a Callback
    hst = hwnd(#wd)
    htb = hwnd(#wd.tb)
    CallDll #a, "InitTimer", hst as word, htb as word, r as word

'  When in use you would HIDE this window - but for demo purposes it
' is placed AlwaysOnTop so that you can see what is going on.
'

    calldll #user, "ShowWindow",_
        hst as word,_
        _SW_HIDE as ushort,_
        result As word
' ***********************************************************************


' *****    Here's the real window where stuff happens ******

    WindowWidth = 640
    WindowHeight = 480

    menu #w, "&File", "&Open", [load.file], "E&xit", [close.w]
    menu #w, "&Edit"

    texteditor #w.te, 0, 0, 510, 435

    statictext #w.st, "Speed", 550, 180, 50, 20
    radiobutton #w.m55, "55 mSecs", [55ms], [reset], 520, 210, 90, 25
    radiobutton #w.m110, "110 mSecs", [110ms], [reset], 520, 240, 90, 25
    radiobutton #w.m165, "165 mSecs", [165ms], [reset], 520, 270, 90, 25
    radiobutton #w.m230, "230 mSecs", [230ms], [reset], 520, 300, 90, 25
    radiobutton #w.m285, "285 mSecs", [285ms], [reset], 520, 330, 90, 25

    open "Test Timer CallBack - Animation" for graphics_nsb as #w
    print #w, "trapclose [close.w]"

    hw = hwnd(#w)

    Print #w.te, " ******* Please wait - Loading Images *******"

    LoadBmp "man1", "hman001.bmp"
    LoadBmp "man2", "hman002.bmp"
    LoadBmp "man3", "hman003.bmp"
    LoadBmp "man4", "hman004.bmp"
    LoadBmp "man5", "hman005.bmp"
    LoadBmp "man6", "hman006.bmp"
    LoadBmp "man7", "hman007.bmp"
    LoadBmp "man8", "hman008.bmp"
    LoadBmp "man9", "hman009.bmp"
    LoadBmp "man10", "hman010.bmp"
    LoadBmp "man11", "hman011.bmp"
    LoadBmp "man12", "hman012.bmp"
    LoadBmp "man13", "hman013.bmp"
    LoadBmp "man14", "hman014.bmp"

    print #w.m110, "set"
    speed = 110  ' Activate the CallBack routine every 110 mSeconds
                 ' (1000mSecs = 1 second)
    CallDll #a, "StartTimer", 1 as word, speed as word, r as word

    filename$ = "anim.txt"  'Load something to the text file
    goto [load.readme]

[loop]
    input var$
    goto [loop]

[st.button]         ' this routine is activated after the delay
    image = image + 1
    if image > 14 then image = 1
    Print #w, "drawbmp man"; str$(image); " 515 0;discard"
'
' *** NOTE:  The discard is VERY important.  Every output to a
' graphics screen causes a write to a MetaFile so that the FLUSH
' command can be used.  Without the DISCARD command - you will get
' a MetaFile error because of the number of screen updates without
' the Flush command being used by this program.

    goto [loop]

[reset]
    goto [loop]

[55ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 55 as word, r as word
    goto [loop]

[110ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 110 as word, r as word
    goto [loop]

[165ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 165 as word, r as word
    goto [loop]

[230ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 230 as word, r as word
    goto [loop]

[285ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 285 as word, r as word
    goto [loop]


[load.file]
    filedialog "Open File", "*.txt", filename$
    if filename$ = "" then goto [loop]
[load.readme]
    open filename$ for input as #f
    print #w.te, "!contents #f";
    close #f
    goto [loop]

[close.w]
    CallDll #a, "EndTimer", 1 as word, r as word
    close #a
    close #w
    close #wd
    close #user
    end
