' Demo of a Timer CallBack
    nomainwin
                ' Open the DLL with the Timer Functions
    open "brosco.dll" for dll as #a

' ***********************************************************************
' The following window is used for communications with the TimerDll

    WindowWidth = 100
    WindowHeight = 60
    open "user" for dll as #user
    textbox #wd.tb, 0, 0, 80, 25   ' This will contain a count of "times" called
    open "Callback" for window as #wd
    Print #wd, "trapclose [st.button]"
    Print #wd, "resizehandler [st.button]"  ' This is the [label] activated by timer

'           The following two handles must be passed to the timer
'           They will be used to simulate a Callback
    hst = hwnd(#wd)
    htb = hwnd(#wd.tb)
    CallDll #a, "InitTimer", hst as word, htb as word, r as word

'  When in use you would HIDE this window - but for demo purposes it
' is placed AlwaysOnTop so that you can see what is going on.
'

'    calldll #user, "ShowWindow",_
'        hst as word,_
'        _SW_HIDE as ushort,_
'        result As word

' Place the Callback window 'on top' - demo puposes only

    toTop = (-1 or 0) 'OR the negative number with 0 to call it in an API
    flags = _SWP_NOMOVE or _SWP_NOSIZE


    calldll #user, "SetWindowPos", _
        hst as ushort, _
        toTop as short, _
        0 as short, _
        0 as short, _
        0 as short, _
        0 as short, _
        flags as ushort, _
        result as void
' ***********************************************************************

' *****    Here's the real window where stuff can happen ******

    WindowWidth = 640
    WindowHeight = 480

    menu #w, "&File", "&Open", [load.file], "E&xit", [close.w]
    menu #w, "&Edit"

    texteditor #w.te, 0, 0, 510, 435


    open "Test Timer CallBack" for window as #w
    print #w, "trapclose [close.w]"

    hw = hwnd(#w)


    speed = 5000  ' Activate the CallBack routine every 5 seconds
                  ' (1000Ms = 1 second)
    CallDll #a, "StartTimer", 1 as word, speed as word, r as word

    filename$ = "timercb.txt"  'Load something to the text file
    goto [load.readme]

[loop]
    input var$
    goto [loop]

[st.button]         ' this routine is activated after the delay
    print #wd.tb, "!contents?"
    input #wd.tb, times$
    if val(times$) < 1 then [loop]
                        ' Pause Timer until message processed
    CallDll #a, "PauseTimer", 1 as word, r as word
    notice "Timer #"; word$(times$, 1) + _
            " has been activated "; word$(times$, 2); " times."
                        ' Restart the Timer -
                        ' you can change the Timer Interval
    CallDll #a, "ResumeTimer", 1 as word, 5000 as word, r as word
    goto [loop]

[load.file]
    filedialog "Open File", "*.txt", filename$
    if filename$ = "" then goto [loop]
[load.readme]
    open filename$ for input as #f
    print #w.te, "!contents #f";
    close #f
    goto [loop]

[close.w]
    CallDll #a, "EndTimer", 1 as word, r as word
    close #a
    close #w
    close #wd
    close #user
    end
