' A Notepad written in LB
' Features include:
'   WordWrap
'   Spell Checker
'   Graphic Toolbar
'   by Brosco - May 98
'
    open "user" for dll as #user

    nomainwin
    WindowWidth = 640                   ' *** Note 1
    WindowHeight = 480
    UpperLeftX = 1                      ' *** Note 2
    UpperLeftY = 1

    filename$ = DefaultDir$ + "\untitled.txt"

    menu #w, "&File", _
        "&New", [new.file], _
        "&Open ...", [open.file], _     ' *** Note 3
        "&Save", [save.file], _
        "Save &As ...", [save.as], _
        |, _
        "E&xit", [close.w]
    menu #w, "&Edit"                    ' *** Note 4
    menu #w, "&Options", _
        "&WordWrap", [word.wrap], _
        "&Spell Check", [spell.check]

    menu #w, "&Help", _
        "&About", [about]

    graphicBox #w.tb, 0, 0, 632, 24     ' *** Note 5

    textEditor #w.txt, 0, 24, 632, 407   ' *** Note 6

    open "LB NotePad" for window as #w

    print #w, "trapclose [close.w]"
    print #w.txt, "!autoresize"         ' *** Note 7

    print #w.tb, "fill lightgray;flush"

    gosub [TitleBar]

[loop]
    input var$
    goto [loop]
                                        ' *** Note 8
[new.file]
    gosub [isModified]
    if modified.result = 2 then goto [loop]

    print #w.txt, "!cls";
    gosub [getLastDir]
    filename$ = lastPath$ + "untitled.txt"
    gosub [TitleBar]
    goto [loop]

[open.file]
    gosub [isModified]
    if modified.result = 2 then goto [loop]

    gosub [getLastDir]
    fileDialog "Open File", lastPath$ + "*.txt", newFilename$
    if newFilename$ = "" then goto [loop]

    filename$ = newFilename$
    open filename$ for input as #f
    txt$ = input$(#f, lof(#f))
    close #f

    print #w.txt, "!cls";
    print #w.txt, "!contents txt$";
    gosub [TitleBar]
    goto [loop]

[getLastDir]
    lastPath$ = DefaultDir$
    lastFile$ = filename$
    slash = instr(filename$, "\", 1)
    while slash <> 0
        lastSlash = slash
        slash = instr(filename$, "\", lastSlash + 1)
        wend
    if lastSlash = 0 then return
    lastPath$ = left$(filename$, lastSlash)
    lastFile$ = right$(filename$, len(filename$) - lastSlash)
    return

[isModified]
    modified.result = 0
    print #w.txt, "!modified?";
    input #w.txt, ans$
    if ans$ = "false" then return
    h=hwnd(#w)
    wtype = 4131            ' Yes, No, Cancel
    message$ = "The text in " + filename$ + " has changed." + _
                chr$(13) +"Do you wish to save these changes?"
    title$ = "LB NotePad"
    sound = _MB_ICONQUESTION
    calldll #user, "MessageBeep", _
        sound as word, _
        result as void
    calldll #user, "Messagebox", _
        h as word, _
        message$ as ptr, _
        title$ as ptr, _
        wtype as word, _
        modified.result as short
' Possible Results are
' 2 = Cancel Button Pushed
' 6 = Yes Button Pushed
' 7 = No Button Pushed
    if modified.result = 6 then gosub [save.changes]
    return

[save.changes]
    print #w.txt, "!contents?";
    input #w.txt, txt$
    print #w.txt, "!origin?";
    input #w.txt, row, column

    open filename$ for output as #f
    print #f, txt$
    close #f
'                   Reset the Window's Modified flag
    print #w.txt, "!cls";
    print #w.txt, "!contents txt$";
    print #w.txt, "!origin ";row;" ";column;
    return

[save.file]
    gosub [save.changes]
    goto [loop]

[save.as]
    fileDialog "Open File", filename$, newFilename$
    if newFilename$ = "" then goto [loop]

    filename$ = newFilename$
    gosub [save.changes]
    gosub [TitleBar]
    goto [loop]

[word.wrap]
    notice "Not implemented yet"
    goto [loop]

[spell.check]
    notice "Not implemented yet"
    goto [loop]

[about]
    notice "About LB Notepad" + _
        chr$(13) + "LB Notepad Version 1.00" + _
        chr$(13) + "Demonstration by Brosco" + _
        chr$(13) + "           May 98"
    goto [loop]

[TitleBar]
    title$ = "LB Notepad: " + filename$ 
    h = hwnd(#w)
    calldll #user, "SetWindowText", _
        h as word, _
        title$ as ptr, _
        result as void
    return

[close.w]
    close #w
    close #user
    END

