    'Freeform v2.015 for Liberty BASIC
    'A special thanks for Alyce Watson for her work on this
    'version of Freeform!
    'Modified v 2.025 01/07/01 by David Drake
    'Refer to the Freeform.rtf document for features and tutorials.
    'Copyright 2000 Shoptalk Systems
    'All Rights Reserved

    'This program lets you graphically lay out
    'windows and their controls, and then converts
    'this visual layout to Liberty BASIC source code
    'that you can paste into your Liberty BASIC
    'programming session.

    'set up an arrays to hold control specs

    dim font$(2)    'font$(1)=user chosen font,font$(2)=titlebar font
    dim type$(100)
    dim label$(100)
    dim names$(100)
    dim xOrg(100)
    dim yOrg(100)
    dim width(100)
    dim height(100)
    dim corner$(100)
    dim branchLabel$(100)
    dim segment(100)
    dim handle$(100)
    dim bmpName$(100)
    dim arrayName$(100)
    dim menu$(20)
    dim menuItem$(20, 30)
    dim menuItemLocal$(30)
    dim menuItemCount(20)
    dim winType$(20)
    dim colorType$(20)
    dim info$(10, 10)   'used for getting file listing info

'Function key definitions - Not all keys are used!
    key.delete$ = chr$(32) + chr$(_VK_DELETE)
    key.f1$ = chr$(32) + chr$(_VK_F1)
    key.f2$ = chr$(32) + chr$(_VK_F2)
    key.f3$ = chr$(32) + chr$(_VK_F3)
    key.f4$ = chr$(32) + chr$(_VK_F4)
    key.f5$ = chr$(32) + chr$(_VK_F5)
    key.f6$ = chr$(32) + chr$(_VK_F6)
    key.f7$ = chr$(32) + chr$(_VK_F7)
    key.f8$ = chr$(32) + chr$(_VK_F8)
    key.f9$ = chr$(32) + chr$(_VK_F9)
    key.f10$ = chr$(32) + chr$(_VK_F10)
    key.f11$ = chr$(32) + chr$(_VK_F11)
    key.f12$ = chr$(32) + chr$(_VK_F12)
    key.f13$ = chr$(32) + chr$(_VK_F13)
    key.f14$ = chr$(32) + chr$(_VK_F14)
    key.f15$ = chr$(32) + chr$(_VK_F15)
    key.f16$ = chr$(32) + chr$(_VK_F16)
    key.alt$ = chr$(32) + chr$(_VK_MENU)
    key.shift$ = chr$(32) + chr$(_VK_SHIFT)
    key.home$ = chr$(32) + chr$(_VK_HOME)
    key.end$ = chr$(32) + chr$(_VK_END)
    key.insert$ = chr$(32) + chr$(_VK_INSERT)
    key.numlock$ = chr$(32) + chr$(_VK_NUMLOCK)
    key.up$ = chr$(32) + chr$(_VK_UP)
    key.down$ = chr$(32) + chr$(_VK_DOWN)
    key.left$ = chr$(32) + chr$(_VK_LEFT)
    key.right$ = chr$(32) + chr$(_VK_RIGHT)

    ffVersion$ = "2.025"
    index = 0
    resizeable$ = " combobox textbox listbox graphicbox groupbox statictext windowframe textedit button checkbox radiobutton "   'add more as you go
    newControlNumber = 0  'increment by one each time a new control is added
    qu$ = chr$(34)
    controlsThatBranch$ = " button listbox combobox bmpbutton checkbox radiobutton "
    snapOn = 1
    xInterval = 8
    yInterval = 5
    createInspect = 1
    defaultForegroundColor$ = ForegroundColor$
    defaultBackgroundColor$ = BackgroundColor$
    currentForegroundColor$ = defaultForegroundColor$
    currentBackgroundColor$ = defaultBackgroundColor$
    defaultComboboxColor$ = ComboboxColor$
    defaultListboxColor$ = ListboxColor$
    defaultTextboxColor$ = TextboxColor$
    defaultTexteditorColor$ = TexteditorColor$
    wincolor$ = defaultBackgroundColor$
    textcolor$ = defaultForegroundColor$
    boxcolor$ = "white"
    windowUpperLeftX = 0
    windowUpperLeftY = 0

    formName$ = "untitled.fr2"
    windowXOrigin = 70
    windowYOrigin = 10
    windowXExtent = 550
    windowYExtent = 410
    windowLabel$ = "untitled"
    windowType$ = "window"
    winHandle$ = "#main"
    menuCount = 0

    winType$(0) = "window"
    winType$(1) = "window_nf"
    winType$(2) = "window_popup"
    winType$(3) = "dialog"
    winType$(4) = "dialog_nf"
    winType$(5) = "dialog_modal"
    winType$(6) = "dialog_nf_modal"
    winType$(7) = "dialog_popup"
    winType$(8) = "graphics"
    winType$(9) = "graphics_nsb"
    winType$(10) = "graphics_nsb_nf"

    colorType$(1) = "black"
    colorType$(2) = "blue"
    colorType$(3) = "brown"
    colorType$(4) = "cyan"
    colorType$(5) = "darkblue"
    colorType$(6) = "darkcyan"
    colorType$(7) = "darkgray"
    colorType$(8) = "darkgreen"
    colorType$(9) = "darkpink"
    colorType$(10) = "darkred"
    colorType$(11) = "green"
    colorType$(12) = "lightgray"
    colorType$(13) = "palegray"
    colorType$(14) = "pink"
    colorType$(15) = "red"
    colorType$(16) = "white"
    colorType$(17) = "yellow"
    colorType$(18) = "buttonface"

    gosub [loadIniFile]

    if displayFormat = 1 then loadbmp "systemBox", "bmp\systembx.bmp"
    if displayFormat = 0 and left$(windowType$, 6) = "dialog" then loadbmp "systemBox", "bmp\95sysbxd.bmp"
    if displayFormat = 0 and left$(windowType$, 6) <> "dialog" then loadbmp "systemBox", "bmp\95sysbx.bmp"
    if displayFormat = 1 then loadbmp "minBox", "bmp\minbx.bmp" else loadbmp "minBox", "bmp\95minbx.bmp"
    if displayFormat = 1 then loadbmp "maxBox", "bmp\maxbx.bmp" else loadbmp "maxBox", "bmp\95maxbx.bmp"
    loadbmp "closebox",    "bmp\95exit.bmp"
    loadbmp "comboButton", "bmp\cmbobttn.bmp"
    loadbmp "radioButton", "bmp\radibttn.bmp"
    loadbmp "checkBox",    "bmp\checkbox.bmp"
    loadbmp "scrollUp",    "bmp\scrlup.bmp"
    loadbmp "scrollDown",  "bmp\scrldown.bmp"
    loadbmp "scrollRight", "bmp\scrlrght.bmp"
    loadbmp "scrollLeft",  "bmp\scrlleft.bmp"

[setUpWindowAndOpenIt]
    nomainwin

    menu #form, "&File",_
        "&New	Ctrl+N", [newFile],_
        "&Open	Ctrl+O", [openFile],_
        "&Save	Ctrl+S", [saveFile], |,_
        "Q&uit", [quit]
    menu #form, "&Edit",_
        "&Copy	Ctrl+C", [copyControl],_
        "&Delete	Del", [deleteControl]
    menu #form, "&Control",_
        "&Properties", [inspectControl], |,_
        "Move to &front", [moveToFront],_
        "Move to &back", [moveToBack],|,_
        "Set box colors", [changeBoxColor]
    menu #form, "&Menu",_
        "&Add a Menu", [addAMenu],_
        "&Remove a Menu", [removeMenu],_
        "&Edit Menus", [editMenus]
    menu #form, "&Window",_
        "&Title", [changeTitle],_
         "T&ype", [changeWindowType],_
        "&Handle", [changeHandle],_
        "&Initial Location",[changeInitialLocation],_
        "&Size",[changeWindowSize],_
        "&Background Colour", [changeColorType],_
        "&Foreground Color", [changeForegroundColor],_
        "Fo&nt for controls",[changeControlFont]
    menu #form, "&Output",_
        "&Produce Code", [produceCode],_
        "Produce Code+&Outline", [produceCodeAndOutline],_
        "&Test Code",[testCode]
    menu #form, "O&ptions",_
        "&Auto Snap to Grid", [gridDialog],_
        "&Settings", [settingsDialog],_
        "Select &BMP Path",[selectBmpPath]

    bmpbutton #form.load,   "bmp\loadbttn.bmp", [openFile],           UL, 5, 40
    bmpbutton #form.save,   "bmp\savebttn.bmp", [saveFile],           UL, 35, 40
    bmpbutton #form.static, "bmp\textbttn.bmp", [addStaticText],      UL, 5, 80
    bmpbutton #form.field,  "bmp\efldbttn.bmp", [addField],           UL, 35, 80
    bmpbutton #form.button, "bmp\bttnbttn.bmp", [addButton],          UL, 5, 110
    bmpbutton #form.bmp,    "bmp\usrdbttn.bmp", [addBmpButton],       UL, 35, 110
    bmpbutton #form.list,   "bmp\lboxbttn.bmp", [addListBox],         UL, 5, 140
    bmpbutton #form.combo,  "bmp\cboxbttn.bmp", [addComboBox],        UL, 35, 140
    bmpbutton #form.radio,  "bmp\rdiobttn.bmp", [addRadioButton],     UL, 5, 170
    bmpbutton #form.check,  "bmp\chbxbttn.bmp", [addCheckBox],        UL, 35, 170
    bmpbutton #form.group,  "bmp\gboxbttn.bmp", [addGroupBox],        UL, 5, 200
    bmpbutton #form.edit,   "bmp\tedtbttn.bmp", [addTextEdit],        UL, 35, 200
    bmpbutton #form.graphic,"bmp\grbxbttn.bmp", [addGraphicBox],      UL, 5, 230
    bmpbutton #form.fill,   "bmp\windfill.bmp", [newObjectColor], UL, 35, 230
    bmpbutton #form.inspect,"bmp\check.bmp",    [inspectControl],     UL, 5, 270
    bmpbutton #form.delete, "bmp\checkout.bmp", [deleteControl],      UL, 35, 270
    bmpbutton #form.infront,"bmp\infront.bmp",  [moveToFront],        UL, 5, 300
    bmpbutton #form.inback, "bmp\inback.bmp",   [moveToBack],         UL, 35, 300
    bmpbutton #form.code,   "bmp\compile.bmp",  [produceCode],        UL, 5, 330
    bmpbutton #form.outline,"bmp\compile2.bmp", [produceCodeAndOutline], UL, 35, 330


    open "FreeForm "+ffVersion$+" for Liberty BASIC" for graphics_fs_nsb as #form
    if Platform$ = "OS/2" then font$(1)="systemmonospaced 8 12"
    if Platform$ = "Windows" and displayFormat = 1 then font$(2)="fixedsys 8 15"
    if Platform$ = "Windows" and displayFormat = 0 then font$(2)="system 7 16"
    font$(1)="ms_sans_serif 0 16"
    print #form, "font ";font$(1)
    print #form, "trapclose [quit]";
    print #form, "when characterInput [key.pressed]"

[drawTheWindow]
    gosub [renderWindow]
    gosub [addWindowFrame]

    if displayToolTip = 0 then goto [setForSelection]
    gosub [addTooltips]
    goto [setForSelection]


[addWindowFrame]    'add the window frame as the first object
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 70
    yOrg(idx) = 10
    width(idx) = 550
    height(idx) = 410
    type$(idx) = "windowframe"
    return

'This sub is used when adding any control
sub addControl type$, count, idx, width, height, text$, corner$
    xOrg(idx) = 100-26
    yOrg(idx) = 50-16
    width(idx) = width
    height(idx) = height
    type$(idx) = type$
    names$(idx) = type$+str$(count)
    corner$(idx) = corner$
    label$(idx) = text$
end sub

sub copyControl type$, count, idx, width, height, text$, corner$, x, y
    xOrg(idx) = x
    yOrg(idx) = y
    names$(idx) = type$+str$(count)
    label$(idx) = text$
end sub

'Return a string without quotes
'This is used when getting typed input
function noQuotes$(text$)
    for x = 1 to len(text$)
        if mid$(text$, x, 1) <> chr$(34) then
            noQuotes$ = noQuotes$ + mid$(text$, x, 1)
        end if
    next x
end function

[addButton]     'add a new button to the form
    text$ = "Button Caption"
    prompt "Please enter text for this button"; text$
    text$ = noQuotes$(text$)
    if text$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "button", newControlNumber, idx, 8*len(text$)+10, 25, text$, "UL"
    branchLabel$(idx) = "["+names$(idx)+"Click]"
    gosub [renderButton]
    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]

[changeBmpButton] ' Change bmpbutton bitmap
    changeBitmapFlag = 1
    goto [addBmpButton]

[addBmpButton]     'add a new bmpButton to the form
    bmp$ = ""
    filedialog "Select a bitmap for this button", "*.bmp", bmp$
    if bmp$ = "" then [inputLoop]

    WindowWidth=222:WindowHeight=240
    UpperLeftX=50:UpperLeftY=50
    graphicbox #bb.g, 10,10,200,100
    button #bb.okay, "OKAY",[bmpbuttonOkay],UL,110,120,100,26
    button #bb.cancel "Cancel",[bmpbuttonCancel],UL,110,150,100,26
    button #bb.again "Select Again",[bmpbuttonSelect],UL,110,180,100,26
    open "Bmpbutton Preview" for window_nf as #bb

[displayBmpbutton]
    print #bb.g, "cls";
    loadbmp "bmptest",bmp$
    print #bb.g, "drawbmp bmptest 0 0";
    wait

[bmpbuttonSelect]
    bmp$ = ""
    filedialog "Select a bitmap for this button", "*.bmp", bmp$
    if bmp$ = "" then [inputLoop]
    goto [displayBmpbutton]

[bmpbuttonCancel]
    unloadbmp "bmptest"
    close #bb:goto [inputLoop]

[bmpbuttonOkay]
    gosub [bmpSize]
    close #bb
    if changeBitmapFlag = 0 then
        newControlNumber = newControlNumber + 1
        objectCount = objectCount + 1
        idx = objectCount
        call addControl "bmpbutton", newControlNumber, idx, bmpwidth, bmpheight, "", "UL"
        bmpName$(idx) = bmp$
        loadbmp bmp$, bmp$
        branchLabel$(idx) = "["+names$(idx)+"Click]"
    else
        bmpName$(index) = bmp$
        loadbmp bmp$, bmp$
        idx = index
    end if
    gosub [renderBmpButton]

    if changeBitmapFlag = 0 then
        if createInspect then
            gosub [deselectOnly]
            index = idx
            gosub [selectDeselect]
            goto [inspectControl]
        end if
    else
        changeBitmapFlag = 0
    end if

    goto [inputLoop]

[bmpSize] ' Get the size of a bitmap for a button
    ' Code courtesy Doyle Whisenhunt and Alyce Watson
    open bmp$ for input as #pic
    pic$=input$(#pic,29)
    close #pic

    bmpwidth = asc(mid$(pic$,19,1)) + (asc(mid$(pic$,20,1)) * 256)
    bmpheight = asc(mid$(pic$,23,1)) + (asc(mid$(pic$,24,1)) * 256)
    return

[addField]     'add a new field (textBox) to the form
    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "textbox", newControlNumber, idx, 100, 25, "", ""
    gosub [renderTextBox]
    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]


[addTextEdit]     'add a new field (textBox) to the form
    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "textedit", newControlNumber, idx, 100, 100, "", ""
    gosub [renderTextEdit]
   '$$$$$
    for x = 0 to menuCount - 1
        if instr(menu$(x),"Edit") <> 0 then editMenuFlag = 1
    next x
    if editMenuFlag = 0 then
        result$ = "Edit"
        menu$(menuCount) = result$
        menuCount = menuCount + 1
        notice "Notice!"+chr$(13)+_
            "Freeform has added an EDIT menu because"+chr$(13)+_
            "LB automatically adds one to your window!"
    end if
    gosub [redrawAll]
    editMenuFlag = 0

    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]


[addComboBox]     'add a new combobox to the form
    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "combobox", newControlNumber, idx, 100, 100, "", ""
    branchLabel$(idx) = "["+names$(idx)+"DoubleClick]"
    arrayName$(idx) = "array$("
    gosub [renderComboBox]
    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]


[addListBox]     'add a new listbox to the form
    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "listbox", newControlNumber, idx, 100, 100, "", ""
    branchLabel$(idx) = "["+names$(idx)+"DoubleClick]"
    arrayName$(idx) = "array$("
    gosub [renderListBox]
    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]


[addStaticText]     'add statictext to the form
    text$ = "StaticText Caption"
    prompt "Please enter the text you would like to add:"; text$
    text$ = noQuotes$(text$)
    if text$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "statictext", newControlNumber, idx, 8 * len(text$), 20, text$, ""
    gosub [renderStaticText]
    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]


[addGroupBox]     'add groupbox to the form
    text$ = "GroupBox Caption"
    prompt "Please enter the text this GroupBox :"; text$
    text$ = noQuotes$(text$)
    if text$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "groupbox", newControlNumber, idx, 100, 100, text$, ""
    gosub [renderGroupBox]
    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]

[addGraphicBox]     'add graphicbox to the form
    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "graphicbox", newControlNumber, idx, 100, 100, "", ""
    gosub [renderGraphicBox]
    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]

[addRadioButton]     'add radiobutton to the form
    text$ = "RadioButton Caption"
    prompt "Please enter a label for the radiobutton:"; text$
    text$ = noQuotes$(text$)
    if text$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "radiobutton", newControlNumber, idx, 100, 25, text$, ""
    branchLabel$(idx) = "["+names$(idx)+"Set] ["+names$(idx)+"Reset]"
    gosub [renderRadioButton]
    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]


[addCheckBox]     'add checkbox to the form
    text$ = "CheckBox Caption"
    prompt "Please enter a label for the checkbox"; text$
    text$ = noQuotes$(text$)
    if text$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    call addControl "checkbox", newControlNumber, idx, 100, 25, text$, ""
    branchLabel$(idx) = "["+names$(idx)+"Set] ["+names$(idx)+"Reset]"
    gosub [renderCheckBox]
    if createInspect then gosub [deselectOnly] : index = idx : gosub [selectDeselect] : goto [inspectControl]
    goto [inputLoop]


[inputLoop]
    wait
    goto [inputLoop]


[key.pressed] ' Handle keypresses
    key$ = Inkey$
    if asc(key$) = 3 then [copyControl] ' Ctrl+C
    if asc(key$) = 19 then [saveFile] ' Ctrl+S
    if asc(key$) = 14 then [newFile] ' Ctrl+N
    if asc(key$) = 15 then [openFile] ' Ctrl+O
    if key$ = key.delete$ then [deleteControl] ' Delete key
    if key$ = key.left$ then [moveLeft] ' Left arrow
    if key$ = key.right$ then [moveRight] ' Right arrow
    if key$ = key.up$ then [moveUp] ' Up arrow
    if key$ = key.down$ then [moveDown] ' Down arrow
    goto [inputLoop]

[renderWindow] 'render the window depending on the value of windowType$

    xOrg = windowXOrigin
    yOrg = windowYOrigin
    xExt = windowXExtent
    yExt = windowYExtent

    print #form, "cls; fill 255 250 230";
    gosub [renderToolbox]

    'render gui:
    print #form, "font ";font$(1);

    print #form, "color black ; down ; size 1";
    print #form, "place "; xOrg + 4; " "; yOrg + 4;
    print #form, "backcolor "; wincolor$;"";
    print #form, "boxfilled "; xOrg + xExt - 4; " "; yOrg + yExt - 4;
    if instr(windowType$, "_nf") > 0 or instr(windowType$, "_popup") > 0 then [noResizingFrame]

    'draw resizing frame
    print #form, "color lightgray ; size 3";
    if Platform$ = "OS/2" then print #form, "color yellow";
    if windowType$ = "dialog" then print #form, "color darkgray";
    if windowType$ = "dialog" and Platform$ = "OS/2" then print #form, "color darkcyan";
    print #form, "place "; xOrg + 2; " "; yOrg + 2;
    print #form, "box "; xOrg + xExt - 2; " "; yOrg + yExt - 2;
    print #form, "color black ; backcolor white ; size 1";
    print #form, "place "; xOrg; " "; yOrg;
    print #form, "box "; xOrg + xExt ; " "; yOrg + yExt;

  [noResizingFrame]
    'draw titlebar
    if instr(windowType$,"_popup") > 0 then titlebarOffset = 0: goto [drawMenus] ' - window_popup has no tilebar
    titlebarOffset = 20
    print #form, "color black ; backcolor darkblue";
    if left$(windowType$, 6) = "dialog" then print #form, "backcolor darkgray";
    if Platform$ = "OS/2" then print #form, "color darkgray ; backcolor darkcyan";
    print #form, "place "; 4 + xOrg; " "; 4 + yOrg;
    print #form, "boxfilled "; xOrg + xExt - 4; " "; 4 + yOrg + 20;
    if displayFormat = 1 then print #form, "place "; int(xExt/2) + xOrg - len(windowLabel$) * 4; " "; 18 + yOrg;
    if displayFormat = 0 then print #form, "place "; 20 + xOrg ; " "; 18 + yOrg;
    if Platform$ = "OS/2" then print #form, "place "; 48 + xOrg; " "; 18 + yOrg;
    print #form, "color white; font ";font$(2)
    print #form, "\"; windowLabel$;
    print #form, "font ";font$(1)

    'draw buttons
    if Platform$ = "OS/2" then print #form, "drawbmp systemBox "; xOrg + 5; " "; 4 + yOrg;
    if Platform$ = "Windows" then print #form, "drawbmp systemBox "; xOrg + 4; " "; 4 + yOrg;
    print #form, "backcolor white ; color black ; down ; size 1";
    if windowType$ = "dialog" then print #form, "color white" ;
    if windowType$ = "dialog" and Platform$ = "OS/2" then print #form, "color darkgray" ;
    print #form, "place "; xOrg + 4; " "; yOrg + 4;
    print #form, "box "; xOrg + xExt - 4; " "; yOrg + yExt - 4;
    if left$(windowType$, 6) = "dialog" then [drawMenus]
    if displayFormat = 1 and instr(windowType$, "_nf") then print #form, "drawbmp minBox "; xOrg + xExt - 24 - 1; " "; 4 + yOrg; : goto [drawMenus]
    if displayFormat = 0 and instr(windowType$, "_nf") then print #form, "drawbmp closebox "; xOrg + xExt - 24 - 1; " "; 7 + yOrg; : goto [drawMenus]
    if Platform$ = "OS/2" then print #form, "drawbmp minBox "; xOrg + xExt - 43 - 2; " "; 4 + yOrg;
    if Platform$ = "OS/2" then print #form, "drawbmp maxBox "; xOrg + xExt - 24 - 1; " "; 4 + yOrg;
    if Platform$ = "Windows" and displayFormat = 0 then print #form, "drawbmp minBox "; xOrg + xExt - 60; " "; 7 + yOrg;
    if Platform$ = "Windows" and displayFormat = 1 then print #form, "drawbmp minBox "; xOrg + xExt - 43; " "; 4 + yOrg;
    if Platform$ = "Windows" and displayFormat = 0 then print #form, "drawbmp maxBox "; xOrg + xExt - 44; " "; 7 + yOrg;
    if Platform$ = "Windows" and displayFormat = 1 then print #form, "drawbmp maxBox "; xOrg + xExt - 24; " "; 4 + yOrg;
    if Platform$ = "Windows" and displayFormat = 0 then print #form, "drawbmp closebox "; xOrg + xExt - 24; " "; 7 + yOrg;


  [drawMenus]
    if menuCount = 0 then [dontDrawMenus]
    if left$(windowType$, 6) = "dialog" then menu.offset = 0: goto [dontDrawMenus]
    if instr(windowType$,"_popup") > 0 then menu.offset = 0 else menu.offset = 20 ' window_popup has no titlebar
    if displayFormat = 1 then print #form, "color black ; backcolor buttonface" ;
    if displayFormat = 0 then print #form, "color black ; backcolor buttonface" ;
    if Platform$ = "Windows" then print #form, "place "; 4 + xOrg; " "; menu.offset + yOrg;
    if Platform$ = "OS/2" then print #form, "color darkgray ; place "; 4 + xOrg; " "; 25 + yOrg;
    print #form, "boxfilled "; xOrg + xExt - 4; " "; menu.offset + yOrg + 20 ;
    string$ = ""
    underline$ = ""
    for x = 0 to menuCount - 1
        item$ = menu$(x)
        hkIndex = instr(menu$(x), "&")
        if hkIndex = 0 then [noHotKey]
        item$ = left$(item$, hkIndex - 1) + mid$(item$, hkIndex + 1)
        underline$ = underline$ + chr$(len(string$)+hkIndex)
      [noHotKey]
        string$ = string$ + item$ + "  "
    next x
    if Platform$ = "OS/2" then print #form, "backcolor palegray" ;
    print #form, "place "; xOrg + 10; " "; menu.offset + 15 + yOrg ;
    print #form, "\"; string$;
    if len(underline$) = 0 then [dontDrawMenus]
    for x = 1 to len(underline$)
        print #form, "place "; xOrg + 10 + (asc(mid$(underline$, x, 1)) - 1) * 8; " "; yOrg + menu.offset + 17 ;
        print #form, "north ; turn 90 ; go 8";
    next x

  [dontDrawMenus]
    print #form, "flush" ;
    return

[renderToolbox] 'render toolbox:
    print #form, "color darkgray; down; size 2; backcolor lightgray";
    print #form, "place 2 11; boxfilled 67 362";
    print #form, "color 200 180 110;backcolor 200 180 110";
    print #form, "place 5 13;boxfilled 65 34"
    print #form, "color white; font arial bold 10"
    print #form, "place 8 28;|Toolbox";
    return

[changeTitle] 'change the window's title
    newWindowLabel$ = windowLabel$
    prompt "Specify the window's title"; newWindowLabel$
    if newWindowLabel$ <> "" then windowLabel$ = newWindowLabel$
    gosub [redrawAll]
    goto [inputLoop]

[changeWindowSize] ' Change the size of the window
    if windowXExtent$ <> "" then xresult$ = str$(windowXExtent)
    if windowYExtent$ <> "" then yresult$ = str$(windowYExtent)
    prompt "Set Window Size"+chr$(13)+"Type window width:";xresult$
    prompt "Set Window Size"+chr$(13)+"Type window height:";yresult$
    if xresult$ <> "" then windowXExtent = val(xresult$)
    if yresult$ <> "" then windowYExtent = val(yresult$)
    gosub [redrawAll]
    goto [inputLoop]

[changeInitialLocation] ' Change the window's initial location
    if windowUpperLeftX$ <> "" then lxresult$ = str$(windowUpperLeftX)
    if windowUpperLeftY$ <> "" then lyresult$ = str$(windowUpperLeftY)
    prompt "Set Window Initial Location"+chr$(13)+"Type window upper left X coordinate:";lxresult$
    prompt "Set Window Initial Location"+chr$(13)+"Type window upper left Y coordinate:";lyresult$
    if lxresult$ <> "" then windowUpperLeftX = val(lxresult$)
    if lyresult$ <> "" then windowUpperLeftY = val(lyresult$)
    goto [inputLoop]

[changeWindowType] ' Change the window type
    WindowWidth = 290
    WindowHeight = 140
    UpperLeftX = 10
    UpperLeftY = 10

    'change the window's type
    statictext #type.statictext1, "Select the type of window desired:", 14, 11, 272, 20
    combobox #type.types, winType$(, [selectWinType], 14, 36, 256, 115
    button #type, "Accept", [acceptWinType], UL, 146, 71,100,24
    button #type, "Cancel", [cancelWinType], UL, 30, 71,100,24
    open "Select Window Type" for dialog_modal as #type
    print #type.types, "select "; windowType$ 
    print #type, "trapclose [cancelWinType]"
    defaultType$ = windowType$ 

    goto [inputLoop]


[changeControlFont] ' Change the font of the controls
    fontdialog font$(1),fontChosen$
    font$(1)=word$(fontChosen$,1)+" 0 16"
    gosub [redrawAll]
    goto [inputLoop]


[selectWinType]   'Perform action for the combobox named 'types'
    'select the type of window desired
    print #type.types, "selection?";
    input #type.types, defaultType$

    goto [inputLoop]


[acceptWinType]   'Perform action for the button named 'acceptWinType'
    'accept the selected window type
    close #type
    if windowType$ <> defaultType$ then windowType$ = defaultType$
    if displayFormat = 1 then loadbmp "systemBox", "bmp\systembx.bmp"
    if displayFormat = 0 and left$(windowType$, 6) = "dialog" then loadbmp "systemBox", "bmp\95sysbxd.bmp"
    if displayFormat = 0 and left$(windowType$, 6) <> "dialog" then loadbmp "systemBox", "bmp\95sysbx.bmp"
    gosub [redrawAll]
    goto [inputLoop]


[cancelWinType]   'Perform action for the button named 'cancelWinType'
    'close the window, don't accept type change
    close #type
    goto [inputLoop]

[changeColorType] ' Set the window color (fill color for graphics, BackgroundColor$ for others)
'    if  left$(windowType$, 8) <> "graphics" then notice " Error!" + chr$(13) + " Colored windows only supported in Graphics" : goto [inputLoop]
    WindowWidth = 290
    WindowHeight = 140
    UpperLeftX = 10
    UpperLeftY = 10
    'change the window's color type
    statictext #type.statictext1, "Select the background color desired:", 14, 11, 272, 20
    combobox #type.types, colorType$(, [selectColorType],  14, 36, 256, 115
    button #type, "Accept", [acceptColorType], UL, 146, 71,100,24
    button #type, "Cancel", [cancelColorType], UL, 30, 71,100,24
    open "Select Background Color" for dialog_modal as #type
    print #type.types, "select "; wincolor$ 
    print #type, "trapclose [cancelColorType]"

    if left$(windowType$, 8) = "graphics" then
        colorDefaultType$ = colorType$
            else
        wincolor$ = colorType$
    end if
    goto [inputLoop]


[selectColorType]   'Perform action for the combobox named 'types'
    'select the type of window color desired
    print #type.types, "selection?";
    input #type.types, colorDefaultType$

    goto [inputLoop]


[acceptColorType]   'Perform action for the button named 'acceptColorType'
    'accept the selected window type
    close #type
    if colorType$ <> colorDefaultType$ then colorType$ = colorDefaultType$
    wincolor$ = colorType$
    currentBackgroundColor$ = wincolor$
    gosub [redrawAll]
    goto [inputLoop]


[cancelColorType]   'Perform action for the button named 'cancelColorType'
    'close the window, don't accept type change
    close #type
    goto [inputLoop]

[changeForegroundColor] ' change the value of ForegroundColor$
    WindowWidth = 290
    WindowHeight = 140
    UpperLeftX = 10
    UpperLeftY = 10
    'change the window's foreground color type
    statictext #type.statictext1, "Select the foreground color desired:", 14, 11, 272, 20
    combobox #type.types, colorType$(, [selectForegroundColor],  14, 36, 256, 115
    button #type, "Accept", [acceptForegroundColor], UL, 146, 71,100,24
    button #type, "Cancel", [cancelForegroundColor], UL, 30, 71,100,24
    open "Select Foreground Color" for dialog_modal as #type

    print #type.types, "select "; currentForegroundColor$
    print #type, "trapclose [cancelForegroundColor]"
    goto [inputLoop]


[selectForegroundColor]   'Perform action for the combobox named 'types'
    'select the type of window color desired
    print #type.types, "selection?";
    input #type.types, colorDefaultType$
    goto [inputLoop]


[acceptForegroundColor]   'Perform action for the button named 'acceptColorType'
    'accept the selected window type
    close #type
    if colorType$ <> colorDefaultType$ then colorType$ = colorDefaultType$
    currentForegroundColor$ = colorType$
    gosub [redrawAll]
    goto [inputLoop]


[cancelForegroundColor]   'Perform action for the button named 'cancelColorType'
    'close the window, don't accept type change
    close #type
    goto [inputLoop]

[changeHandle] 'change the window's handle
    prompt "Specify the window's handle (starts with a #)"; result$
    if result$ = "" then [inputLoop]
    winHandle$ = result$
    if left$(winHandle$, 1) <> "#" then winHandle$ = "#" + winHandle$ : notice "Window handle defaults to: " + winHandle$
    goto [inputLoop]

[changeBoxColor] ' Change the colors of text-type controls
    WindowWidth = 210
    WindowHeight = 200

    statictext #colors.statictext1, "Combobox Color", 2, 10, 112, 20
    statictext #colors.statictext2, "Listbox Color", 2,40, 104, 20
    statictext #colors.statictext3, "Textbox Color", 2, 70, 104, 20
    statictext #colors.statictext4, "Text Editor Color", 2, 100, 112, 20
    combobox #colors.combobox5, colorType$(, [selectComboboxColor], 115, 11, 80, 100
    combobox #colors.combobox6, colorType$(, [selectListboxColor], 115, 41, 80, 100
    combobox #colors.combobox7, colorType$(, [selectTextboxColor], 115, 71, 80, 100
    combobox #colors.combobox8, colorType$(, [selectTexteditorColor], 115, 101, 80, 100
    button #colors.button11, "Cancel", [cancelControlColors], UL, 20, 140, 60, 25
    button #colors.button9, "Accept", [acceptControlColors], UL, 100, 140, 60, 25
    open "Special Control Colors" for dialog_modal as #colors
    print #colors, "font arial 0 16"
    print #colors, "trapclose [cancelControlColors]"
    print #colors.combobox5, "select ";windowComboboxColor$
    print #colors.combobox6, "select ";windowListboxColor$
    print #colors.combobox7, "select ";windowTextboxColor$
    print #colors.combobox8, "select ";windowTexteditorColor$
    goto [inputLoop]

[selectComboboxColor]
    print #colors.combobox5, "selection?";
    input #colors.combobox5, comboColor$
    goto [inputLoop]

[selectListboxColor]
    print #colors.combobox6, "selection?";
    input #colors.combobox6, listColor$
    goto [inputLoop]

[selectTextboxColor]
    print #colors.combobox7, "selection?";
    input #colors.combobox7, textbColor$
    goto [inputLoop]

[selectTexteditorColor]
    print #colors.combobox8, "selection?";
    input #colors.combobox8, textedColor$
    goto [inputLoop]

[acceptControlColors]
    windowComboboxColor$ = comboColor$
    windowListboxColor$ = listColor$
    windowTextboxColor$ = textbColor$
    windowTexteditorColor$ = textedColor$
    close #colors
    gosub [redrawAll]
    goto [inputLoop]

[cancelControlColors]
    close #colors
    goto [inputLoop]

[newObjectColor]
    if index = 1 then [changeColorType]
    if type$(index) = "combobox" then [changeComboboxColor]
    if type$(index) = "listbox" then [changeListboxColor]
    if type$(index) = "textbox" then [changeTextboxColor]
    if type$(index) = "textedit" then [changeTexteditorColor]
    goto [inputLoop]

[changeComboboxColor]
    WindowWidth = 210
    WindowHeight = 160
    statictext #colors.statictext, "Combobox Color", 2, 10, 112, 20
    combobox #colors.combobox, colorType$(, [selectControlColor], 115, 11, 80, 100
    button #colors.button1, "Cancel", [cancelControlColors], UL, 20, 100, 60, 25
    button #colors.button2, "Accept", [acceptComboboxColor], UL, 100, 100, 60, 25
    open "Special Control Colors" for dialog_modal as #colors
    print #colors, "font arial 0 16"
    print #colors, "trapclose [cancelControlColors]"
    print #colors.combobox, "select ";windowComboboxColor$
    goto [inputLoop]

[acceptComboboxColor]
    windowComboboxColor$ = comboColor$
    close #colors
    gosub [redrawAll]
    goto [inputLoop]

[changeListboxColor]
    WindowWidth = 210
    WindowHeight = 160
    statictext #colors.statictext, "Listbox Color", 2, 10, 112, 20
    combobox #colors.combobox, colorType$(, [selectControlColor], 115, 11, 80, 100
    button #colors.button1, "Cancel", [cancelControlColors], UL, 20, 100, 60, 25
    button #colors.button2, "Accept", [acceptListboxColor], UL, 100, 100, 60, 25
    open "Special Control Colors" for dialog_modal as #colors
    print #colors, "font arial 0 16"
    print #colors, "trapclose [cancelControlColors]"
    print #colors.combobox, "select ";windowListboxColor$
    goto [inputLoop]

[acceptListboxColor]
    windowListboxColor$ = controlColor$
    close #colors
    gosub [redrawAll]
    goto [inputLoop]

[changeTextboxColor]
    WindowWidth = 210
    WindowHeight = 160
    statictext #colors.statictext, "Textbox Color", 2, 10, 112, 20
    combobox #colors.combobox, colorType$(, [selectControlColor], 115, 11, 80, 100
    button #colors.button1, "Cancel", [cancelControlColors], UL, 20, 100, 60, 25
    button #colors.button2, "Accept", [acceptTextboxColor], UL, 100, 100, 60, 25
    open "Special Control Colors" for dialog_modal as #colors
    print #colors, "font arial 0 16"
    print #colors, "trapclose [cancelControlColors]"
    print #colors.combobox, "select ";windowTextboxColor$
    goto [inputLoop]

[acceptTextboxColor]
    windowTextboxColor$ = controlColor$
    close #colors
    gosub [redrawAll]
    goto [inputLoop]

[changeTexteditorColor]
    WindowWidth = 210
    WindowHeight = 160
    statictext #colors.statictext, "Texteditor Color", 2, 10, 112, 20
    combobox #colors.combobox, colorType$(, [selectControlColor], 115, 11, 80, 100
    button #colors.button1, "Cancel", [cancelControlColors], UL, 20, 100, 60, 25
    button #colors.button2, "Accept", [acceptTexteditorColor], UL, 100, 100, 60, 25
    open "Special Control Colors" for dialog_modal as #colors
    print #colors, "font arial 0 16"
    print #colors, "trapclose [cancelControlColors]"
    print #colors.combobox, "select ";windowTexteditorColor$
    goto [inputLoop]

[acceptTexteditorColor]
    windowTexteditorColor$ = controlColor$
    close #colors
    gosub [redrawAll]
    goto [inputLoop]

[selectControlColor]
    print #colors.combobox, "selection?";
    input #colors.combobox, controlColor$
    goto [inputLoop]

'This function is used at the tail end of rendering any control
function postRender(idx, displayOrdering)
    if displayOrdering then
        print #form, "color white ; backcolor black ; place " + str$(xOrg(idx)-4) + " " + str$(yOrg(idx)+7)
        print #form, "\" + str$(idx - 1)
    end if
    print #form, "up ; flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id
end function


[renderButton] 'render the button at idx.
    'assume an font 8 bits wide
    'type$(idx) = "button"
    xOrgIdx = xOrg(idx)
    yOrgIdx = yOrg(idx)+menu.offset
    print #form, "place "; xOrgIdx; " "; yOrgIdx ;
    print #form, "place "; xOrgIdx; " "; yOrgIdx ;
    print #form, "color black ; backcolor lightgray ; size 1" ;
    print #form, "down ; boxfilled "; xOrgIdx+width(idx); " "; yOrgIdx+height(idx) ;
    print #form, "size 2 ; color darkgray ; place "; xOrgIdx+2; " "; yOrgIdx+2 ;
    print #form, "box "; xOrgIdx+width(idx)-1; " "; yOrgIdx+height(idx)-1 ;
    print #form, "color white" ;
    print #form, "place  "; xOrgIdx+2; " "; yOrgIdx+height(idx)-3 ;
    print #form, "goto "; xOrgIdx+2; " "; yOrgIdx+2 ;
    print #form, "goto "; xOrgIdx+width(idx)-3; " "; yOrgIdx+2 ;
    print #form, "color black ; backcolor lightgray ; size 1" ;
    print #form, "place "; xOrgIdx+int((width(idx)-len(label$(idx))*8)/2); " "; yOrgIdx+int((height(idx)-15)/2)+12 ;
    print #form, "\"; label$(idx);
    result = postRender(idx, displayOrdering)
    return

[renderStaticText] 'render the statictext at idx.
    'assume an font 8 bits wide, 15 high
    'type$(idx) = "statictext"
    print #form, "place "; xOrg(idx); " "; yOrg(idx)+15-3+menu.offset ; " ; place "; xOrg(idx); " "; yOrg(idx)+15-3+menu.offset ;
    print #form, "down ; color ";currentForegroundColor$;" ; backcolor ";currentBackgroundColor$
    if Platform$ = "OS/2" then print #form, "backcolor palegray" ;
    print #form, "\"; label$(idx);
    result = postRender(idx, displayOrdering)
    return


[renderRadioButton] 'render the radiobutton at idx.
    'assume an font 8 bits wide, 15 high
    'type$(idx) = "radiobutton"
    width(idx) = 8 * len(label$(idx)) + 16
    height(idx) = 20
    print #form, "down" ;
    print #form, "place "; xOrg(idx); " "; yOrg(idx)+menu.offset
    print #form, "drawbmp radioButton "; xOrg(idx); " "; yOrg(idx)+menu.offset;
    print #form, "color ";currentForegroundColor$;" ; backcolor ";currentBackgroundColor$;
    if Platform$ = "OS/2" then print #form, "backcolor palegray" ;
    print #form, "place "; xOrg(idx)+16; " "; yOrg(idx)+15-3 +menu.offset;
    print #form, "color ";currentForegroundColor$;";\"; label$(idx);
    result = postRender(idx, displayOrdering)
    return


[renderCheckBox] 'render the checkbox at idx.
    'assume an font 8 bits wide, 15 high
    'type$(idx) = "checkbox"
    width(idx) = 8 * len(label$(idx)) + 16
    height(idx) = 20
    print #form, "place "; xOrg(idx); " "; yOrg(idx) +menu.offset;
    print #form, "down" ;
    print #form, "drawbmp checkBox "; xOrg(idx); " "; yOrg(idx)+menu.offset;
    print #form, "color ";currentForegroundColor$;" ; backcolor ";currentBackgroundColor$ ;
    if Platform$ = "OS/2" then print #form, "backcolor palegray" ;
    print #form, "place "; xOrg(idx)+16; " "; yOrg(idx)+15-3+menu.offset ;
    print #form, "\"; label$(idx);
    result = postRender(idx, displayOrdering)
    return


[renderBmpButton] 'render the bmpbutton at idx.
    'assume an font 8 bits wide
    'type$(idx) = "bmpbutton"
    print #form, "place "; xOrg(idx); " "; yOrg(idx) +menu.offset;
    print #form, "drawbmp "; bmpName$(idx); " "; xOrg(idx); " "; yOrg(idx)+menu.offset;
    result = postRender(idx, displayOrdering)
    return

[renderComboBox] 'render the comboBox at idx.
    'type$(idx) = "combobox"
    boxColor$ = "white"
    if windowComboboxColor$ <> "" then boxColor$ = windowComboboxColor$
    print #form, "place "; xOrg(idx); " "; yOrg(idx) +menu.offset;
    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx)-24; " "; yOrg(idx)+22+menu.offset ;

    print #form, "place "; xOrg(idx)+ 3; " "; yOrg(idx) +menu.offset+ 3;
    print #form, "color ";boxColor$;" ; backcolor white ; size 1" ;
    print #form, "down ; box "; xOrg(idx)+width(idx)-24-3; " "; yOrg(idx)+22+menu.offset-3 ;

    print #form, "drawbmp comboButton "; xOrg(idx)+width(idx)-16 ; " "; yOrg(idx)+menu.offset ;
    result = postRender(idx, displayOrdering)
    return

[renderTextBox] 'render the textbox at idx.
    'type$(idx) = "textbox"
    fillIt$ = "white"
    if windowTextboxColor$ <> "" then fillIt$ = windowTextboxColor$
    print #form, "place "; xOrg(idx); " "; yOrg(idx) +menu.offset; " ; place "; xOrg(idx); " "; yOrg(idx)+menu.offset ;
    print #form, "color black ; backcolor ";fillIt$;" ; size 1" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx)+menu.offset ;
    result = postRender(idx, displayOrdering)
    return

[renderTextEdit] 'render the textedit at idx.
    'type$(idx) = "textedit"
    fillIt$ = "white"
    if windowTexteditorColor$ <> "" then fillIt$ = windowTexteditorColor$
    print #form, "place "; xOrg(idx); " "; yOrg(idx) +menu.offset;
    print #form, "place "; xOrg(idx); " "; yOrg(idx) +menu.offset;
    print #form, "color black ; backcolor ";fillIt$;" ; size 1" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx) +menu.offset;
    print #form, "color black ; backcolor lightgray" ;
    print #form, "place "; xOrg(idx)+width(idx)-17; " "; yOrg(idx)+menu.offset;
    print #form, "boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx)-17 +menu.offset;
    print #form, "drawbmp scrollUp "; xOrg(idx)+width(idx)-17; " "; yOrg(idx)+menu.offset;
    print #form, "drawbmp scrollDown "; xOrg(idx)+width(idx)-17; " "; yOrg(idx)+height(idx)-33+menu.offset;
    print #form, "place "; xOrg(idx); " "; yOrg(idx)+height(idx)-17+menu.offset;
    print #form, "boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx)+menu.offset ;
    print #form, "drawbmp scrollLeft "; xOrg(idx); " "; yOrg(idx)+height(idx)-17+menu.offset;
    print #form, "drawbmp scrollRight "; xOrg(idx)+width(idx)-33; " "; yOrg(idx)+height(idx)-17+menu.offset;
    result = postRender(idx, displayOrdering)
    return

[renderListBox] 'render the listbox at idx.
    'type$(idx) = "listbox"
    fillIt$ = "white"
    if windowListboxColor$ <> "" then fillIt$ = windowListboxColor$
    print #form, "place "; xOrg(idx); " "; yOrg(idx)+menu.offset ;
    print #form, "color black ; backcolor ";fillIt$;" ; size 1" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx)+menu.offset ;
    print #form, "color black ; backcolor lightgray" ;
    print #form, "place "; xOrg(idx)+width(idx)-17; " "; yOrg(idx)+menu.offset;
    print #form, "boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx)+menu.offset ;
    print #form, "drawbmp scrollUp "; xOrg(idx)+width(idx)-17; " "; yOrg(idx)+menu.offset;
    print #form, "drawbmp scrollDown "; xOrg(idx)+width(idx)-17; " "; yOrg(idx)+height(idx)-17+menu.offset;
    result = postRender(idx, displayOrdering)
    return

[renderGraphicBox] 'render the graphicbox at idx.  assume a font 8x15.
    'type$(idx) = "graphicbox"
    print #form, "place "; xOrg(idx); " "; yOrg(idx)+menu.offset;
    print #form, "color black ; backcolor "; boxcolor$ ;"; size 1" ;
    if Platform$ = "OS/2" then print #form, "backcolor palegray" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx)+menu.offset;
    result = postRender(idx, displayOrdering)
    return

[renderGroupBox] 'render the groupbox at idx.  assume a font 8x15.
    'type$(idx) = "groupbox"
    print #form, "place "; xOrg(idx); " "; yOrg(idx)+ 5+menu.offset ;
    print #form, "color ";currentForegroundColor$;" ; backcolor ";currentBackgroundColor$;" ; size 1" ;
    if Platform$ = "OS/2" then print #form, "backcolor palegray" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx)+menu.offset ;
    print #form, "place "; xOrg(idx)+8; " "; yOrg(idx)+10+menu.offset ;
    print #form, "color ";currentForegroundColor$;";\"; label$(idx);
    result = postRender(idx, displayOrdering)
    return

[setForSelection] 'set up event handling for the default behavior (selection)
    print #form, "when leftButtonDown [selectControl]";
    print #form, "when leftButtonDouble [inspectControl]";
    print #form, "when rightButtonUp [popupMenu]";
    print #form, "when leftButtonMove" ;
    print #form, "when leftButtonUp" ;
    goto [inputLoop]

[selectControl] 'set up event handling
        print #form, "when leftButtonUp [setForSelection]" ;
        print #form, "when leftButtonDown" ;
    'highlight the control at the mouse click position
    x = MouseX : y = MouseY

    if index = 0 then [dontDeselect]

    'check to see if the resize handle has been clicked on, if applicable
    if instr(resizeable$, type$(index)) = 0 then [deselect]
    if x < xOrg(index)+width(index)-4 or x > xOrg(index)+ width(index)+4 then [deselect]
    if y < yOrg(index)+height(index)-4+menu.offset or y > yOrg(index)+height(index)+4+menu.offset then [deselect]

    goto [resizeControl]

[deselect]
    print #form, "delsegment "; selectId -1 ;
    gosub [selectDeselect]
    index = 0
    print #form, "delsegment "; selectId - 1 ;

[dontDeselect]
    gosub [determineControl]
    if newIndex = 0 then [setUpMovementEvent]

    index = newIndex
    gosub [selectDeselect]
    lastMouseX = MouseX
    lastMouseY = MouseY

[setUpMovementEvent]
    if type$(newIndex) = "windowframe" then [inputLoop]
    print #form, "when leftButtonMove [beginObjectMove]" ;
    goto [inputLoop]

[determineControl] 'based on x/y, determine which control is selected
    'set newIndex to point to this control, if found
    'otherwise set newIndex to 0

    if objectCount = 0 then return

    newIndex = 0
    for i = objectCount to 1 step -1
        if newIndex > 0 then [skipControl]
        if type$(i) = "" then [skipControl]
        if x < xOrg(i) or x > xOrg(i)+width(i) then [skipControl]
        if y < yOrg(i)+menu.offset or y > yOrg(i)+height(i)+menu.offset then [skipControl]
        newIndex = i
        i = 1
[skipControl]
    next i
    return

[selectDeselect]
    'select or deselect the object at index by drawing handles
    xOrgIdx = xOrg(index)
    yOrgIdx = yOrg(index)+menu.offset
    xow = xOrgIdx+width(index)
    yoh = yOrgIdx+height(index)
    print #form, "rule xor ; down";
    if type$(index) = "windowframe" then [drawSizingHandle]
    print #form, "color black ; backcolor white" ;
    if currentBackgroundColor$ = "black" then print #form, "color yellow ; backcolor white" ;
    print #form, "place "; xOrgIdx-4; " "; yOrgIdx-4 ;
    print #form, "boxfilled "; xOrgIdx+4; " "; yOrgIdx+4 ;
    print #form, "place "; xow-4; " "; yOrgIdx-4 ;
    print #form, "boxfilled "; xow+4; " "; yOrgIdx+4 ;
    print #form, "place "; xOrgIdx-4; " "; yoh-4 ;
    print #form, "boxfilled "; xOrgIdx+4; " "; yoh+4 ;

[drawSizingHandle]
    if instr(resizeable$, type$(index)) > 0 then print #form, "backcolor black" ;
    print #form, "place "; xow-4; " "; yoh-4 ;
    print #form, "boxfilled "; xow+4; " "; yoh+4 ;
    print #form, "rule over ; flush" ;
    print #form, "segment" ;
    input #form, selectId
    return

[deselectOnly]  'if there is a selected control, deselect it
    if index = 0 then return  'nothing is selected, do nothing
    print #form, "delsegment "; selectId -1 ;
    gosub [selectDeselect]
    index = 0
    print #form, "delsegment "; selectId - 1 ;
    return

[beginObjectMove] 'if the mouse has only slightly moved, ignore the event
    if abs(MouseX - x) < 3 and abs(MouseY - y) < 3 then [inputLoop]

    'set up to begin moving the selected object
    print #form, "delsegment "; selectId - 1 ;
    print #form, "when leftButtonMove [additionalObjectMoves]" ;
    print #form, "when leftButtonUp [acceptMovement]" ;

[additionalObjectMoves] 'adjust the position of the selected object, then draw an object frame the size of the
    'selected object at that new position using xor rule.  set event handling to manage
    'additional movements or termination of this object's movement.

    gosub [snapMouse] ' OK
    if MouseX = lastMouseX and MouseY = lastMouseY then [inputLoop]
    gosub [eraseObjectFrame]
    xOrg(index) = xOrg(index) + (MouseX - lastMouseX)
    yOrg(index) = yOrg(index) + (MouseY - lastMouseY)
    gosub [snapXY] ' OK
    lastMouseX = MouseX
    lastMouseY = MouseY

    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "place "; xOrg(index); " "; yOrg(index)+menu.offset;
    print #form, "down ; rule xor ; box "; xOrg(index)+width(index); " "; yOrg(index)+height(index)+menu.offset;
    print #form, "rule over ; up ; flush" ;
    print #form, "segment" : input #form, id
    print #form, "delsegment "; id - 1 ;

    goto [inputLoop]

[eraseObjectFrame] 'erase the object frame (for movement)
    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "place "; xOrg(index); " "; yOrg(index)+menu.offset;
    print #form, "down ; rule xor ; box "; xOrg(index)+width(index); " "; yOrg(index)+height(index)+menu.offset;
    print #form, "rule over ; up ; flush" ;
    print #form, "segment" : input #form, id
    print #form, "delsegment "; id - 1 ;

    return

[acceptResizing]
'    if type$(index) = "bmpbutton" then gosub [bmpButtonResize]

    if width(index) < 25 then width(index) = 25
    if type$(index) <> "textbox" and height(index) < 20 then height(index) = 20
    if type$(index) = "textbox" and height(index) < 25 then height(index) = 25

    if type$(index) <> "windowframe" then [acceptMovement]
    if width(index) < 100 then width(index) = 100
    if height(index) < 50 then height(index) = 50
    windowXExtent = width(index)
    windowYExtent = height(index)

[acceptMovement] 'end the movement phase, and redraw all objects
    print #form, "delsegment "; segment(index) - 1 ;
    gosub [redrawAll]
    gosub [selectDeselect]
    firstObjectMove = false
    goto [setForSelection]

[moveLeft] ' move control left in response to left arrow keypress
    if index < 2 or objectCount < 2 then [inputLoop]
    xOrg(index) = xOrg(index) - xInterval
    oldIndex = index
    gosub [redrawAll]
    index = oldIndex
    gosub [selectDeselect]
    goto [inputLoop]

[moveRight] ' move control right in response to right arrow keypress
    if index < 2 or objectCount < 2 then [inputLoop]
    xOrg(index) = xOrg(index) + xInterval
    oldIndex = index
    gosub [redrawAll]
    index = oldIndex
    gosub [selectDeselect]
    goto [inputLoop]

[moveUp] ' move control up in response to up arrow keypress
    if index < 2 or objectCount < 2 then [inputLoop]
    yOrg(index) = yOrg(index) - yInterval
    oldIndex = index
    gosub [redrawAll]
    index = oldIndex
    gosub [selectDeselect]
    goto [inputLoop]

[moveDown] ' move control down in response to right arrow keypress
    if index < 2 or objectCount < 2 then [inputLoop]
    yOrg(index) = yOrg(index) + yInterval
    oldIndex = index
    gosub [redrawAll]
    index = oldIndex
    gosub [selectDeselect]
    goto [inputLoop]

[resizeControl] 'set up to begin resizing the selected object
    firstObjectMove = true
    oldwidth = width(index)
    oldheight = height(index) ' for bmpbutton stretch only
    print #form, "delsegment "; selectId - 1 ;
    print #form, "when leftButtonMove [additionalResizes]" ;
    print #form, "when leftButtonUp [acceptResizing]" ;
    gosub [snapMouse]
    lastMouseX = MouseX
    lastMouseY = MouseY

[additionalResizes] 'adjust the position of the selected object, then draw an object frame the size of the
    'selected object at that new position using xor rule.  set event handling to manage
    'additional movements or termination of this object's movement.

    if firstObjectMove = false then gosub [eraseObjectFrame]

    gosub [snapMouse]


    width(index) = width(index) + (MouseX - lastMouseX)
    height(index) = height(index) + (MouseY - lastMouseY)
    gosub [snapWH]
    lastMouseX = MouseX
    lastMouseY = MouseY

    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "place "; xOrg(index); " "; yOrg(index) +menu.offset;
    print #form, "down ; rule xor ; box "; xOrg(index)+width(index); " "; yOrg(index)+height(index)+menu.offset;
    print #form, "rule over ; up ; flush" ;
    print #form, "segment" : input #form, id
    print #form, "delsegment "; id - 1 ;

    goto [inputLoop]

[snapMouse]  'if snapOn is selected, then snap the mouse to grid
    if snapOn = 0 then return
    MouseX = int((MouseX + int(xInterval / 2)) / xInterval) * xInterval
    MouseY = int((MouseY + int(yInterval / 2)) / yInterval) * yInterval
    return

[snapWH]  'if snapOn is selected, then snap the width & height to grid
    if snapOn = 0 then return
    width(index)  = int((width(index)  + int(xInterval / 2)) / xInterval) * xInterval
    height(index) = int((height(index) + int(yInterval / 2)) / yInterval) * yInterval
    return

[snapXY]  'if snapOn is selected, then snap the x,y position to grid
    if snapOn = 0 then return
    xOrg(index)   = int((xOrg(index)   + int(xInterval / 2)) / xInterval) * xInterval
    yOrg(index)   = int((yOrg(index)   + int(yInterval / 2)) / yInterval) * yInterval
    return

[redrawAll] 'redraw all controls
    isModified = 1  'the form has been modified
    print #form, "cls";
    index = 0
    gosub [renderWindow]
    if gridVisibleOn = 1 then gosub [displayGrid]
    if objectCount = 0 then return
    'If it is graphic window, foreground and background colors don't work!
    if left$(windowType$,7) = "graphic" then
        oldForegroundColor$ = currentForegroundColor$
        oldBackgroundColor$ = currentBackgroundColor$
        currentForegroundColor$ = "black"
        currentBackgroundColor$ = "white"
    end if

    for idx = 1 to objectCount ' Graphicboxes always on bottom
        typeIdx$ = type$(idx)
        if typeIdx$ = "graphicbox" then gosub [renderGraphicBox]
    next idx

    for idx = 1 to objectCount ' Texteditors always under all controls
        typeIdx$ = type$(idx)
        if typeIdx$ = "textedit" then gosub [renderTextEdit]
    next idx

    for idx = 1 to objectCount ' Groupboxes always under all other controls except texteditors
        typeIdx$ = type$(idx)
        if typeIdx$ = "groupbox" then gosub [renderGroupBox]
    next idx


    for idx = 1 to objectCount
        typeIdx$ = type$(idx)
        if typeIdx$ = "textbox" then gosub [renderTextBox] : goto [redrawNext]
        if typeIdx$ = "statictext" then gosub [renderStaticText] : goto [redrawNext]
        if typeIdx$ = "button" then gosub [renderButton] : goto [redrawNext]
        if typeIdx$ = "combobox" then gosub [renderComboBox] : goto [redrawNext]
        if typeIdx$ = "listbox" then gosub [renderListBox] : goto [redrawNext]
        if typeIdx$ = "bmpbutton" then gosub [renderBmpButton] : goto [redrawNext]
        if typeIdx$ = "radiobutton" then gosub [renderRadioButton] : goto [redrawNext]
        if typeIdx$ = "checkbox" then gosub [renderCheckBox] : goto [redrawNext]
      [redrawNext]
    next idx
    gosub [clipControls]
    if left$(windowType$,7) = "graphic" then ' restore settings in case window type changes
        currentForegroundColor$ = oldForegroundColor$
        currentBackgroundColor$ = oldBackgroundColor$
    end if
    return

[displayGrid] ' Draw a grid on screen that corresponds to snapx and snapy values
    lineColor$ = "white"
    if currentBackgroundColor$ = "white" then lineColor$ = "darkgray"
    titlebarOffset = 20
    for yShowGrid = windowYOrigin+5+menu.offset+titlebarOffset to windowYOrigin+windowYExtent-3 step yInterval*2
            lines$ = "down;size 1;color "+lineColor$+"; line "+str$(windowXOrigin+3)+" "+str$(yShowGrid)+" "+str$(windowXOrigin+windowXExtent-3)+" "+str$(yShowGrid)
            print #form, lines$
    next yShowGrid
        for xShowGrid = windowXOrigin+xInterval+3 to windowXOrigin+windowXExtent-3 step xInterval*2
            lines$ = "down;size 1;color "+lineColor$+"; line "+str$(xShowGrid)+" "+str$(windowYOrigin+5+menu.offset+titlebarOffset)+" "+str$(xShowGrid)+" "+str$(windowYOrigin+windowYExtent-3)
            print #form, lines$
        next xShowGrid
    return

[clipControls] 'erase any controls outside of window:
    xOrg = windowXOrigin
    yOrg = windowYOrigin
    xExt = windowXExtent
    yExt = windowYExtent

    print #form, "down;color 255 250 230";
    print #form, "backcolor 255 250 230";
    print #form, "place 0 ";yExt+yOrg
    print #form, "boxfilled 2000 2000";
    print #form, "place ";xExt+xOrg;" 0"
    print #form, "boxfilled 2000 2000";
    print #form, "place 0 0"
    print #form, "boxfilled ";xOrg;" 2000"
    gosub [renderToolbox]
    return

[moveToBack] 'move the selected control to the back (first item drawn)
    if index < 2 or objectCount < 2 then [inputLoop]
    if index = 2 then gosub [redrawAll] : goto [inputLoop]

    tmpType$ = type$(index)
    tmpLabel$ = label$(index)
    tmpNames$ = names$(index)
    tmpXOrigin = xOrg(index)
    tmpYOrigin = yOrg(index)
    tmpWidth = width(index)
    tmpHeight = height(index)
    tmpCorner$ = corner$(index)
    tmpBranchLabel$ = branchLabel$(index)
    tmpSegment = segment(index)
    tmpHandle$ = handle$(index)
    tmpBmpName$ = bmpName$(index)
    tmpArrayName$ = arrayName$(index)

    for idx = index - 1 to 2 step -1
        type$(idx+1) = type$(idx)
        label$(idx+1) = label$(idx)
        names$(idx+1) = names$(idx)
        xOrg(idx+1) = xOrg(idx)
        yOrg(idx+1) = yOrg(idx)
        width(idx+1) = width(idx)
        height(idx+1) = height(idx)
        corner$(idx+1) = corner$(idx)
        branchLabel$(idx+1) = branchLabel$(idx)
        segment(idx+1) = segment(idx)
        handle$(idx+1) = handle$(idx)
        bmpName$(idx+1) = bmpName$(idx)
        arrayName$(idx+1) = arrayName$(idx)
    next idx

    type$(2) = tmpType$
    label$(2) = tmpLabel$
    names$(2) = tmpNames$
    xOrg(2) = tmpXOrigin
    yOrg(2) = tmpYOrigin
    width(2) = tmpWidth
    height(2) = tmpHeight
    corner$(2) = tmpCorner$
    branchLabel$(2) = tmpBranchLabel$
    segment(2) = tmpSegment
    handle$(2) = tmpHandle$
    bmpName$(2) = tmpBmpName$
    arrayName$(2) = tmpArrayName$
    gosub [redrawAll]
    index = 0 'necessary here

    goto [inputLoop]

[moveToFront] 'move the selected control to the front (last item drawn)
    if index < 2 or objectCount < 2 then [inputLoop]
    if index = objectCount then gosub [redrawAll] : goto [inputLoop]

    tmpType$ = type$(index)
    tmpLabel$ = label$(index)
    tmpNames$ = names$(index)
    tmpXOrigin = xOrg(index)
    tmpYOrigin = yOrg(index)
    tmpWidth = width(index)
    tmpHeight = height(index)
    tmpCorner$ = corner$(index)
    tmpBranchLabel$ = branchLabel$(index)
    tmpSegment = segment(index)
    tmpHandle$ = handle$(index)
    tmpBmpName$ = bmpName$(index)
    tmpArrayName$ = arrayName$(index)

    for idx = index to objectCount - 1
        type$(idx) = type$(idx+1)
        label$(idx) = label$(idx+1)
        names$(idx) = names$(idx+1)
        xOrg(idx) = xOrg(idx+1)
        yOrg(idx) = yOrg(idx+1)
        width(idx) = width(idx+1)
        height(idx) = height(idx+1)
        corner$(idx) = corner$(idx+1)
        branchLabel$(idx) = branchLabel$(idx+1)
        segment(idx) = segment(idx+1)
        handle$(idx) = handle$(idx+1)
        bmpName$(idx) = bmpName$(idx+1)
        arrayName$(idx) = arrayName$(idx+1)
    next idx

    type$(objectCount) = tmpType$
    label$(objectCount) = tmpLabel$
    names$(objectCount) = tmpNames$
    xOrg(objectCount) = tmpXOrigin
    yOrg(objectCount) = tmpYOrigin
    width(objectCount) = tmpWidth
    height(objectCount) = tmpHeight
    corner$(objectCount) = tmpCorner$
    branchLabel$(objectCount) = tmpBranchLabel$
    segment(objectCount) = tmpSegment
    handle$(objectCount) = tmpHandle$
    bmpName$(objectCount) = tmpBmpName$
    arrayName$(objectCount) = tmpArrayName$

    gosub [redrawAll]
    gosub [selectDeselect]

    goto [inputLoop]

[deleteControl] 'delete the selected control
    if index < 2 then [inputLoop]

    'delete graphical segments and clean up display
    print #form, "delsegment "; selectId -1 ;
    gosub [selectDeselect]
    print #form, "delsegment "; selectId - 1 ;

    for idx = index to objectCount
        type$(idx) = type$(idx+1)
        label$(idx) = label$(idx+1)
        names$(idx) = names$(idx+1)
        xOrg(idx) = xOrg(idx+1)
        yOrg(idx) = yOrg(idx+1)
        width(idx) = width(idx+1)
        height(idx) = height(idx+1)
        corner$(idx) = corner$(idx+1)
        branchLabel$(idx) = branchLabel$(idx+1)
        segment(idx) = segment(idx+1)
        handle$(idx) = handle$(idx+1)
        bmpName$(idx) = bmpName$(idx+1)
        arrayName$(idx) = arrayName$(idx+1)
    next idx

    objectCount = objectCount - 1

    gosub [redrawAll]
    index = 0

    print #form, "setfocus";
    goto [inputLoop]

[testCode] ' If user wants to test code with LB compiler, set flag
    testCode = 1

[produceCodeAndOutline] 'set a flag so that an outline will be added
    produceOutline = 1

[produceCode] 'produce code for the controls in the form
    if codeIsOpen = 1 then close #code : codeIsOpen = 0
    WindowWidth=450:WindowHeight=330
    UpperLeftX=100:UpperLeftY=30
    open "Free Form output window" for text as #code
    codeIsOpen = 1
    print #code, ""
    print #code, ""
    if produceOutline = 1 then print #code, "    nomainwin"
    if windowUpperLeftX <> 0 then print #code, "    UpperLeftX = ";windowUpperLeftX
    if windowUpperLeftY <> 0 then print #code, "    UpperLeftY = ";windowUpperLeftY
    print #code, "    WindowWidth = "; windowXExtent
    print #code, "    WindowHeight = "; windowYExtent
    print #code, ""
    print #code, "    BackgroundColor$ = "; qu$; currentBackgroundColor$; qu$; ""
    print #code, "    ForegroundColor$ = "; qu$; currentForegroundColor$; qu$; ""
    if windowComboboxColor$<>"" then print #code, "    ComboboxColor$ = ";qu$;windowComboboxColor$;qu$
    if windowListboxColor$<>"" then print #code, "    ListboxColor$ = ";qu$;windowListboxColor$;qu$
    if windowTextboxColor$<>"" then print #code, "    TextboxColor$ = ";qu$;windowTextboxColor$;qu$
    if windowTexteditorColor$<>"" then print #code, "    TexteditorColor$ = ";qu$;windowTexteditorColor$;qu$
    if left$(windowType$, 8) = "graphics" then print #code, "    nomainwin";chr$(13); ""

    if objectCount < 2 then [menuCode]

    for x = objectCount to 2 step -1' Do graphicbox controls in reverse order so they display right
        code$ = ""
        if type$(x) = "graphicbox" then gosub [codeForGraphicBox]
        if code$ <> "" then print #code, code$
    next x

    for x = objectCount to 2 step -1' Do graphicbox controls in reverse order so they display right
        code$ = ""
        if type$(x) = "textedit" then gosub [codeForTextEdit]
        if code$ <> "" then print #code, code$
    next x

    for x = objectCount to 2 step -1' Do graphicbox controls in reverse order so they display right
        code$ = ""
        if type$(x) = "groupbox" then gosub [codeForGroupBox]
        if code$ <> "" then print #code, code$
    next x

    for x = 2 to objectCount ' Now make code for the rest of controls
        code$ = ""
        if type$(x) = "button" then gosub [codeForButton]
        if type$(x) = "combobox" then gosub [codeForComboBox]
        if type$(x) = "textbox" then gosub [codeForTextBox]
        if type$(x) = "listbox" then gosub [codeForListBox]
        if type$(x) = "bmpbutton" then gosub [codeForBmpButton]
        if type$(x) = "statictext" then gosub [codeForStaticText]
        if type$(x) = "radiobutton" then gosub [codeForRadioButton]
        if type$(x) = "checkbox" then gosub [codeForCheckBox]
        if code$ <> "" then print #code, code$
    next x

[menuCode]   'write menu code
    if menuCount = 0 then [noMenuCode]

    if left$(windowType$, 6) = "dialog" then print #code, "    '*** menus are not supported in windows of type "; windowType$; " ***"

    for x = 0 to menuCount - 1
        print #code, "    menu "; winHandle$; ", "; qu$; menu$(x); qu$;
        if menuItemCount(x) = 0 then print #code, ", "; chr$(34); "&FixMe"; chr$(34); ", [fixMe]  ' <-- this menu has no items!" : goto [produceNextMenu]
        for y = 0 to menuItemCount(x) - 1
            print #code, ", ";
            mi$ = menuItem$(x, y)
            print #code, qu$; left$(mi$, instr(mi$, chr$(0)) - 1) ; qu$;
            print #code, ", "; mid$(mi$, instr(mi$, chr$(0)) + 1) ;
        next y
        print #code, ""
      [produceNextMenu]
    next x


[noMenuCode] 'don't produce menu code
    print #code, "    open "; qu$; windowLabel$; qu$; " for "; windowType$; " as "; winHandle$
    for idx = 1 to objectCount
        if type$(idx) = "graphicbox" then  print #code, "    print ";winHandle$;".";names$(idx);", ";qu$;"fill "; boxcolor$;"; flush";qu$ 
     next idx
    if left$(windowType$, 8) = "graphics" then print #code, "    print ";winHandle$;", ";qu$;"fill "; wincolor$;"; flush";qu$
    print #code, "    print ";winHandle$;", ";qu$;"font "; font$(1);qu$
    if produceOutline = 1 then print #code, "    print ";winHandle$;", ";qu$;"trapclose [quit]";qu$
    if produceOutline = 0 then [doneProducingCode]

[produceOutline] ' produce outline code if flag is set
    inputLoopLabel$ = "[" + mid$(winHandle$, 2) + ".inputLoop]"

    print #code, ""
    print #code, ""
    print #code, inputLoopLabel$; "   'wait here for input event"
    print #code, "    wait"
    print #code, "    goto "; inputLoopLabel$
    print #code, ""

    branchLabels$ = ""

    if objectCount < 2 then [outlineForMenus]

    for x = 2 to objectCount
        if left$(trim$(branchLabel$(x)), 1) <> "[" then [nextOutlineObject]
        if instr(trim$(branchLabel$(x)), " ") > 0 then gosub [handleMultiBranchLabels] : goto [nextOutlineObject]
        if instr(branchLabels$, branchLabel$(x)) > 0 then [nextOutlineObject]
        branchLabels$ = branchLabels$ + " " + branchLabel$(x)
        print #code, ""
        print #code, ""
        print #code, branchLabel$(x); "   'Perform action for the "; type$(x); " named '"; names$(x); "'"
        print #code, ""
        print #code, "    'Insert your own code here"
        print #code, ""
        print #code, "    goto "; inputLoopLabel$

      [nextOutlineObject]
    next x

[outlineForMenus]   'produce outline code for menus
    if menuCount = 0 then [doneProducingCode]

    for x = 0 to menuCount - 1
        if menuItemCount(x) = 0 then [writeNextMenu]
        for y = 0 to menuItemCount(x) - 1
            mi$ = menuItem$(x, y)
            bl$ = mid$(mi$, instr(mi$, chr$(0)) + 1)
            if instr(branchLabels$, bl$) > 0 then [writeNextMenuItem]
            branchLabels$ = branchLabels$ + " " + bl$
            print #code, ""
            print #code, ""
            print #code, bl$; "   'Perform action for menu "; menu$(x); ", item "; left$(mi$, instr(mi$, chr$(0)) - 1)
            print #code, ""
            print #code, "    'Insert your own code here"
        [writeNextMenuItem]
        next y
      [writeNextMenu]
    next x

[doneProducingCode] ' Code creation complete
    if produceOutline = 1 then
        print #code, ""
        print #code, "[quit]"
        print #code, "     close ";winHandle$
        print #code, "     end"
    end if
    produceOutline = 0
    print #code, "!selectall";
    print #code, "!copy";
    print #code, "!origin 1 1";
    if testCode = 0 then
        notice "Done.  This code has been copied to clipboard.  You may paste it into your program."
    else
        testCode = 0
        goto [run]
    end if
    goto [inputLoop]

[handleMultiBranchLabels]   'handle the case where a control has more than 1 branching option
    if instr(branchLabels$, word$(branchLabel$(x), 1)) > 0 then [nextMultiBranchLabel]
    print #code, ""
    print #code, ""
    print #code, word$(branchLabel$(x), 1); "   'Perform action for the "; type$(x); " named '"; names$(x); "'"
    print #code, ""
    print #code, "    'Insert your own code here"
    print #code, ""
    print #code, "    goto "; inputLoopLabel$

    branchLabels$ = branchLabels$ + " " + word$(branchLabel$(x), 1)

   [nextMultiBranchLabel]
    if instr(branchLabels$, word$(branchLabel$(x), 2)) > 0 then [doneMultiBranchLabel]
    print #code, ""
    print #code, ""
    print #code, word$(branchLabel$(x), 2); "   'Perform action for the "; type$(x); " named '"; names$(x); "'"
    print #code, ""
    print #code, "    'Insert your own code here"
    print #code, ""
    print #code, "    goto "; inputLoopLabel$
    branchLabels$ = branchLabels$ + " " + word$(branchLabel$(x), 2)

   [doneMultiBranchLabel]
    return

[codeForButton] 'produce code for a text button
    code$ = "    button "+winHandle$+"."+names$(x)+", "+qu$+label$(x)+qu$+", "+branchLabel$(x)+", "+corner$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[codeForBmpButton] 'produce code for a bmp button
    bmpFileName$ = bmpName$(x)
    if bmpPath$ <> "" then gosub [fileName]:bmpFileName$ = fileName$
    code$ = "    bmpbutton "+winHandle$+"."+names$(x)+", "+qu$+bmpPath$+bmpFileName$+qu$+", "+branchLabel$(x)+", "+corner$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)
    return

[fileName] ' Extract file name from complete file specification
    length = len(bmpFileName$)
    character = length
    slash$ = ""
    while slash$ <> "\"
        slash$ = mid$(bmpFileName$,character,1)
        character = character - 1
    wend
    fileName$ = right$(bmpFileName$,length-character-1)
    return

[filePath] ' Extract file path from complete file specification
    length = len(bmpFileName$)
    character = length
    slash$ = ""
    while slash$ <> "\"
        slash$ = mid$(bmpFileName$,character,1)
        character = character - 1
    wend
    pathName$ = left$(bmpFileName$,character-1)
    return

[codeForTextBox] 'produce code for a text box
    code$ = "    textbox "+winHandle$+"."+names$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[codeForStaticText] 'produce code for a static text
    code$ = "    statictext "+winHandle$+"."+names$(x)+", "+qu$+label$(x)+qu$+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[codeForGroupBox] 'produce code for a group box
    code$ = "    groupbox "+winHandle$+"."+names$(x)+", "+qu$+label$(x)+qu$+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[codeForGraphicBox] 'produce code for a graphic box
    code$ = "    graphicbox "+winHandle$+"."+names$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[codeForListBox] 'produce code for a listbox
    code$ = "    listbox "+winHandle$+"."+names$(x)+", "+arrayName$(x)+", "+branchLabel$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[codeForComboBox] 'produce code for a listbox
    code$ = "    combobox "+winHandle$+"."+names$(x)+", "+arrayName$(x)+", "+branchLabel$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[codeForRadioButton] 'produce code for a radiobutton
    code$ = "    radiobutton "+winHandle$+"."+names$(x)+", "+qu$+label$(x)+qu$+", "+word$(branchLabel$(x), 1)+", "+word$(branchLabel$(x), 2)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[codeForCheckBox] 'produce code for a checkbox
    code$ = "    checkbox "+winHandle$+"."+names$(x)+", "+qu$+label$(x)+qu$+", "+word$(branchLabel$(x), 1)+", "+word$(branchLabel$(x), 2)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[codeForTextEdit] 'produce code for a text edit box
    code$ = "    texteditor "+winHandle$+"."+names$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return

[newFile] 'clear the contents of the form editor and start over

    if isModified = 1 then gosub [formIsModified]

    newControlNumber = 0
    windowLabel$ = "untitled"
    windowType$ = "window"
    objectCount = 0
    winHandle$ = "#main"
    windowXExtent = 550
    windowYExtent = 410
    menu.offset = 0

    defaultForegroundColor$ = ForegroundColor$
    defaultBackgroundColor$ = BackgroundColor$
    currentForegroundColor$ = defaultForegroundColor$
    currentBackgroundColor$ = defaultBackgroundColor$
    windowUpperLeftX = 0
    windowUpperLeftY = 0

    formName$ = "untitled.fr2"
    wincolor$ = defaultBackgroundColor$
    textcolor$ = defaultForegroundColor$
    boxcolor$ = "white"
    windowComboboxColor$ = defaultComboboxColor$
    windowListboxColor$ = defaultListboxColor$
    windowTextboxColor$ = defaultTextboxColor$
    windowTexteditorColor$ = defaultTexteditorColor$

    gosub [clearMenuData]
    gosub [addWindowFrame]
    gosub [redrawAll]

    isModified = 0
    print #form, "setfocus";
    goto [inputLoop]

[saveFile] ' Save the form to a file
    'abort if no controls
    if objectCount < 2 then notice "No controls.  Save aborted" : goto [inputLoop]
'    confirm "Click YES to save in new format, NO to save in old format";answer$


'    if answer$="yes" then
        'save the form into a *.fr2 file
        if formName$ = "" then formName$ = "untitled.fr2"
        filedialog "Save form", "*.fr2", formName$
        if formName$ = "" then [inputLoop]
'    else
'        if formName$ = "" then formName$ = "untitled.fre"
'        filedialog "Save form", "*.fre", formName$
'        if formName$ = "" then [inputLoop]
'    end if

    gosub [saveFormSubroutine]

    notice "Done.  File saved as " + formName$
    print #form, "setfocus";
    goto [inputLoop]

[saveFormSubroutine]   'the subroutine portion of the save routine
    open formName$ for output as #formOut
    print #formOut, currentForegroundColor$
    print #formOut, currentBackgroundColor$
    print #formOut, newControlNumber
    print #formOut, windowLabel$
    print #formOut, windowType$
    print #formOut, objectCount
    print #formOut, winHandle$
    print #formOut, snapOn
    print #formOut, xInterval
    print #formOut, yInterval
    print #formOut, menuCount
    print #formOut, windowXExtent
    print #formOut, windowYExtent
    print #formOut, windowComboboxColor$
    print #formOut, windowListboxColor$
    print #formOut, windowTextboxColor$
    print #formOut, windowTexteditorColor$
    print #formOut, windowUpperLeftX
    print #formOut, windowUpperLeftY
    print #formOut, bmpPath$
    print #formOut, font$(1)

'    if lower$(right$(formName$,3))="fr2" then print #formOut, font$(1)

    for i = 2 to objectCount
        print #formOut, type$(i)
        print #formOut, label$(i)
        print #formOut, names$(i)
        print #formOut, xOrg(i)
        print #formOut, yOrg(i)
        print #formOut, width(i)
        print #formOut, height(i)
        print #formOut, corner$(i)
        print #formOut, branchLabel$(i)
        print #formOut, segment(i)
        print #formOut, handle$(i)
        print #formOut, bmpName$(i)
        print #formOut, arrayName$(i)
    next i

    'Now write the menu information
    if menuCount = 0 then [noMenusToSave]

    for i = 0 to menuCount - 1
        print #formOut, menu$(i)
        print #formOut, menuItemCount(i)
        if menuItemCount(i) = 0 then [noMenuItemsToSave]
        for j = 0 to menuItemCount(i) - 1
            print #formOut, menuItem$(i, j)
        next j
      [noMenuItemsToSave]
    next i

[noMenusToSave]
    close #formOut
    return

[openFile] 'load the form from a *.fr2 file
    if isModified = 1 then gosub [formIsModified]
    filedialog "Load form", "*.fr2;*.fre", formName$
    print #form, "setfocus";
    if formName$ = "" then [inputLoop]

    gosub [clearMenuData]
    objectCount = 0
    gosub [addWindowFrame]

    open formName$ for input as #formIn
    input #formIn, currentForegroundColor$
    input #formIn, currentBackgroundColor$
    input #formIn, newControlNumber
    input #formIn, windowLabel$
    input #formIn, windowType$
    input #formIn, objectCount
    input #formIn, winHandle$
    input #formIn, snapOn
    input #formIn, xInterval
    input #formIn, yInterval
    input #formIn, menuCount
    input #formIn, windowXExtent
    input #formIn, windowYExtent
    input #formIn, windowComboboxColor$
    input #formIn, windowListboxColor$
    input #formIn, windowTextboxColor$
    input #formIn, windowTexteditorColor$
    input #formIn, windowUpperLeftX
    input #formIn, windowUpperLeftY
    input #formIn, bmpPath$

    if lower$(right$(formName$,3))="fr2" then
        input #formIn, fontChosen$
        if fontChosen$<>"" then font$(1)=fontChosen$ 
    end if

    width(1) = windowXExtent
    height(1) = windowYExtent
    wincolor$ = currentBackgroundColor$

    for i = 2 to objectCount
        input #formIn, tmp$ : type$(i) = tmp$
        input #formIn, tmp$ : label$(i) = tmp$
        input #formIn, tmp$ : names$(i) = tmp$
        input #formIn, tmp  : xOrg(i) = tmp
        input #formIn, tmp  : yOrg(i) = tmp
        input #formIn, tmp  : width(i) = tmp
        input #formIn, tmp  : height(i) = tmp
        input #formIn, tmp$ : corner$(i) = tmp$
        input #formIn, tmp$ : branchLabel$(i) = tmp$
        input #formIn, tmp  : segment(i) = tmp
        input #formIn, tmp$ : handle$(i) = tmp$
        input #formIn, tmp$ : bmpName$(i) = tmp$
        if trim$(tmp$) > "" then loadbmp tmp$, tmp$
        input #formIn, tmp$ : arrayName$(i) = tmp$
    next i

    if menuCount = 0 then [noMenusToRead]

    for i = 0 to menuCount - 1
        input #formIn, tmp$ : menu$(i)=tmp$
        input #formIn, tmp : menuItemCount(i) = tmp
        if menuItemCount(i) = 0 then [noMenuItemsToRead]
        for j = 0 to menuItemCount(i) - 1
            input #formIn, tmp$ : menuItem$(i, j) = tmp$
        next j
      [noMenuItemsToRead]
    next i

[noMenusToRead]
    close #formIn
    gosub [redrawAll]

    isModified = 0

    print #form, "setfocus";
    goto [inputLoop]

[gridDialog]  'open a dialog box for selecting & adjusting snap to grid
    WindowWidth = 250
    WindowHeight = 270

    if gridDialogIsOpen = 1 then close #gridDialog

    statictext #gridDialog.statictext2, "Select here whether control positions will", 26, 16, 336, 20
    statictext #gridDialog.statictext5, "automatically snap to gridded positions,", 26, 35, 320, 20
    statictext #gridDialog.statictext6, "and what the interval will be.", 26, 54, 240, 20
    checkbox #gridDialog.snapOnOff, "Snap to Grid", [snapOn], [snapOff], 26, 85, 120, 20
    checkbox #gridDialog.viewGrid, "Visible Grid", [gridVisibleOn], [gridVisibleOff], 26, 110, 120, 20
    statictext #gridDialog.statictext7, "X interval:", 34, 135, 70, 20
    textbox #gridDialog.xIntrvl, 34, 160, 38, 25
    statictext #gridDialog.statictext9, "Y interval:", 124, 135, 70, 20
    textbox #gridDialog.yIntrvl, 124, 160, 38, 25
    button #gridDialog, "OK", [acceptGridDialog], UL, 119, 195,80,24
    button #gridDialog, "Cancel", [cancelGridDialog], UL, 29, 195,80,24
    open "Snap to Grid" for dialog_modal as #gridDialog
    print #gridDialog, "trapclose [cancelGridDialog]"
    gridDialogIsOpen = 1

    if snapOn = 1 then snapOnSelected = 1 : print #gridDialog.snapOnOff, "set"
    if gridVisibleOn = 1 then gridVisibleSelected = 1 : print #gridDialog.viewGrid, "set"
    print #gridDialog.xIntrvl, xInterval
    print #gridDialog.yIntrvl, yInterval

    goto [inputLoop]

[snapOn]   'Perform on action for the checkbox named 'snapOnOff'
    snapOnSelected = 1
    goto [inputLoop]

[snapOff]   'Perform off action for the checkbox named 'snapOnOff'
    snapOnSelected = 0
    goto [inputLoop]

[gridVisibleOn] ' Turn on grid flag
    gridVisibleSelected = 1
    goto [inputLoop]

[gridVisibleOff] ' Turn off grid flag
    gridVisibleSelected = 0
    goto [inputLoop]

[acceptGridDialog]
    snapOn = snapOnSelected
    gridVisibleOn = gridVisibleSelected
    print #gridDialog.xIntrvl, "!contents?"
    input #gridDialog.xIntrvl, xInterval
    print #gridDialog.yIntrvl, "!contents?"
    input #gridDialog.yIntrvl, yInterval
    settingsChanged = 1

[cancelGridDialog]
    gridDialogIsOpen = 0
    close #gridDialog
    if settingsChanged = 1 then settingsChanged = 0 : gosub [redrawAll]
    goto [inputLoop]

[addAMenu]    'add a new menu item
    WindowWidth = 300
    WindowHeight = 200
    listbox #newMenu.menuNames, menu$(, [inputLoop], 14, 38, 120, 120
    statictext #newMenu.statictext2, "Defined Menus", 14, 16, 104, 20
    statictext #newMenu.statictext3, "Enter new menu name:", 150, 16, 200, 20
    textbox #newMenu.newMenuName, 150, 38, 130, 25
    button #newMenu, "Accept", [acceptNewMenu], UL, 150,75,130,24
    button #newMenu, "Cancel", [cancelNewMenu], UL, 150,101,130,24
    open "Add a Menu" for dialog_modal as #newMenu
    print #newMenu, "trapclose [cancelNewMenu]";
    goto [inputLoop]

[cancelNewMenu]   'Perform action for the button named 'cancelNewMenu'
    'close the dialog box
    close #newMenu
    goto [inputLoop]

[clearMenuData]     'reset menu data arrays and indices
    for x = 0 to 20
        menu$(x) = ""
        for y = 0 to 30
            menuItem$(x, y) = ""
        next y
    next x
    menuCount = 0
    return

[acceptNewMenu]   'Perform action for the button named 'acceptNewMenu'
    'add this menu onto the list of menus, and update the display as needed
    print #newMenu.newMenuName, "!contents?";
    input #newMenu.newMenuName, result$
    if result$ = "" then notice "Please type a name for a new menu." : goto [inputLoop]
    close #newMenu
    menu$(menuCount) = result$
    menuCount = menuCount + 1
    if menuCount > 1 then gosub [redrawAll] : goto [inputLoop]

    'since this is the first menu added, reposition all controls 20 pixels down
    if objectCount < 2 then gosub [redrawAll] : goto [inputLoop]
    for x = 2 to objectCount
    next x
    gosub [redrawAll]
    goto [inputLoop]

[removeMenu]   'remove a menu from the list of menus
    if menuCount = 0 then notice "No menus to remove." : goto [inputLoop]

    if removeMenuIsOpen = 1 then close #removeMenu

    WindowWidth = 330
    WindowHeight = 195
    statictext #removeMenu.statictext1, "Select a menu to remove:", 26, 16, 192, 20
    listbox #removeMenu.menusToRemove, menu$(, [acceptRemoveMenu], 22, 41, 180, 100
    button #removeMenu, "Accept", [acceptRemoveMenu], UL, 216, 81,80,24
    button #removeMenu, "Cancel", [cancelRemoveMenu], UL, 216, 111,80,24
    open "Remove a Menu" for dialog_modal as #removeMenu
    print #removeMenu, "trapclose [cancelRemoveMenu]";
    removeMenuIsOpen = 1

    goto [inputLoop]

[acceptRemoveMenu]   'get the name of the selected item, and remove it
    print #removeMenu.menusToRemove, "selectionIndex?"
    input #removeMenu.menusToRemove, result
    close #removeMenu
    removeMenuIsOpen = 0
    if result = 0 then notice "No item selected.  Menu not removed." : goto [inputLoop]

    menuCount = menuCount - 1
    result = result - 1

    if result = menuCount then menu$(result) = "" : goto [checkForEmptyMenuBar]

    for x = result to menuCount
        menu$(x) = menu$(x+1)
    next x

[checkForEmptyMenuBar]  'if there are no more menus, shift controls up 20 pixels

    if menuCount > 0 then gosub [redrawAll] : goto [inputLoop]

    menu.offset = 0

    gosub [redrawAll]
    goto [inputLoop]

[cancelRemoveMenu]   'close the remove menu dialog
    close #removeMenu
    removeMenuIsOpen = 0
    goto [inputLoop]

[editMenus]     'edit menu order and menu contents
    if menuCount = 0 then notice "No menus to edit." : goto [inputLoop]

    if editMenuIsOpen = 1 then close #editMenu

    WindowWidth = 435
    WindowHeight = 360

    listbox #editMenu.menuList, menu$(, [selectMenuToEdit], 14, 31, 288, 105
    listbox #editMenu.menuItems, menuItemLocal$(, [selectMenuItemToEdit], 14, 166, 288, 145
    statictext #editMenu.statictext6, "Menus:", 14, 9, 48, 20
    statictext #editMenu.statictext14, "Menu line items -> Branch labels:", 14, 144, 240, 20
    button #editMenu, "&Close", [closeMenuEdit], UL, 310, 4,100,24
    button #editMenu, "&New Item", [addNewMenuItem], UL, 310, 166,100,24
    button #editMenu, "&Edit", [editMenuItem], UL, 310, 196,100,24
    button #editMenu, "Move &Up", [moveMenuItemUp], UL, 310, 226,100,24
    button #editMenu, "&Move Dn", [moveMenuItemDown], UL, 310, 256,100,24
    button #editMenu, "&Delete", [deleteMenuItem], UL, 310, 286,100,24
    button #editMenu, "&To Top", [moveMenuToTop], UL, 310, 60,100,24
    open "Edit Menus" for dialog_modal as #editMenu
    print #editMenu, "trapclose [closeMenuEdit]";
    print #editMenu.menuList, "singleclickselect";
    print #editMenu.menuItems, "singleclickselect";

    editMenuIsOpen = 1
    menuItemIndex = 0
    result = 0

    goto [inputLoop]

[selectMenuToEdit]   'Perform action for the listbox named 'menuList'
    'populate the listbox named menuItems
    print #editMenu.menuList, "selectionIndex?"
    input #editMenu.menuList, result

    for x = 0 to 29
        mil$ = menuItem$(result - 1, x)
        if mil$ <> "" then mil$ = left$(mil$, instr(mil$, chr$(0)) - 1) + " -> " + mid$(mil$, instr(mil$, chr$(0)) + 1)
        menuItemLocal$(x) = mil$
    next x
    print #editMenu.menuItems, "reload"

    menuItemIndex = 0

    goto [inputLoop]

[moveMenuToTop]   'move the selected menu to the top of the list
    'if there is no selection, or if the selected item is already on top, do nothing
    if result = 0 or result = 1 then [inputLoop]

    menu$(20) = menu$(result - 1)
    for x = 0 to 29
        menuItem$(20, x) = menuItem$(result - 1, x)
    next x

    for x = result - 1 to 1 step -1
        menu$(x) = menu$(x - 1)
        for y = 0 to 29
            menuItem$(x, y) = menuItem$(x - 1, y)
        next y
    next x

    menu$(0) = menu$(20)
    menu$(20) = ""
    for x = 0 to 29
        menuItem$(0, x) = menuItem$(20, x)
        menuItem$(20, x) = ""
    next x

    print #editMenu.menuList, "reload"
    print #editMenu.menuList, "selectIndex 1"
    result = 1

    'now continue on to the next routine!

[selectMenuItemToEdit]   'Perform action for the listbox named 'menuItems'
    'set the selection index for the menu item to edit
    print #editMenu.menuItems, "selectionIndex?"
    input #editMenu.menuItems, menuItemIndex
    goto [inputLoop]

[addNewMenuItem]   'Perform action for the button named 'newItemButton'
    if result = 0 then [inputLoop]

    if editMenuItemIsOpen = 1 then gosub [closeEditMenuItem]

    menuItemCount(result - 1) = menuItemCount(result - 1) + 1
    menuItemIndex = menuItemCount(result - 1)
    editMenuItemAction$ = "ADD"
    goto [editMenuItemProperties]

[editMenuItem]   'Perform action for the button named 'editMenuItem'
    if menuItemIndex = 0 then [inputLoop]

    if editMenuItemIsOpen = 1 then gosub [closeEditMenuItem]

    editMenuItemAction$ = "EDIT"
    goto [editMenuItemProperties]

[moveMenuItemUp]   'Perform action for the button named 'moveMenuItemUp'
    if menuItemIndex = 1 or menuItemIndex = 0 then [inputLoop]

    tmpMi$ = menuItem$(result - 1, menuItemIndex - 1)
    menuItem$(result - 1, menuItemIndex - 1) = menuItem$(result - 1, menuItemIndex - 2)
    menuItem$(result - 1, menuItemIndex - 2) = tmpMi$

    gosub [reloadLocalMenuItems]

    menuItemIndex = menuItemIndex - 1
    print #editMenu.menuItems, "selectIndex "; menuItemIndex

    goto [inputLoop]

[moveMenuItemDown]   'Perform action for the button named 'moveMenuItemDown'
    'Insert your own code here
    if result = 0 then [inputLoop]
    if menuItemIndex = menuItemCount(result - 1) or menuItemIndex = 0 then [inputLoop]

    tmpMi$ = menuItem$(result - 1, menuItemIndex - 1)
    menuItem$(result - 1, menuItemIndex - 1) = menuItem$(result - 1, menuItemIndex)
    menuItem$(result - 1, menuItemIndex) = tmpMi$

    gosub [reloadLocalMenuItems]

    menuItemIndex = menuItemIndex + 1
    print #editMenu.menuItems, "selectIndex "; menuItemIndex

    goto [inputLoop]

[deleteMenuItem]   'Perform action for the button named 'deleteMenuItem'
    if result = 0 then [inputLoop]
    if menuItemCount(result - 1) = 0 or menuItemIndex = 0 then [inputLoop]
    menuItemCount(result-1) = menuItemCount(result - 1) - 1
    for x = menuItemIndex to 30
        menuItem$(result - 1, x - 1) = menuItem$(result - 1, x)
    next x

    gosub [reloadLocalMenuItems]

    menuItemIndex = 0

    goto [inputLoop]

[reloadLocalMenuItems]  'reload the contents of the menu items listbox
    for x = 0 to 29
        mil$ = menuItem$(result - 1, x)
        if mil$ <> "" then mil$ = left$(mil$, instr(mil$, chr$(0)) - 1) + " -> " + mid$(mil$, instr(mil$, chr$(0)) + 1)
        menuItemLocal$(x) = mil$
    next x
    print #editMenu.menuItems, "reload"

    return

[closeMenuEdit]   'Perform action for the button named 'closeMenuEdit'
    'close the menu editing dialog and redraw the form
    for x = 0 to 29 : menuItemLocal$(x) = "" : next x
    close #editMenu
    editMenuIsOpen = 0
    gosub [redrawAll]

    goto [inputLoop]

[editMenuItemProperties]    'open a dialog for editing menu item properties
    WindowWidth = 350
    WindowHeight = 150

    textbox #menuItems.name, 134, 16, 184, 25
    textbox #menuItems.branchLabel, 134, 51, 184, 25
    statictext #menuItems.statictext6, "Name:", 22, 21, 40, 20
    statictext #menuItems.statictext7, "Branch Label:", 22, 56, 104, 20
    button #menuItems, "Accept", [acceptMenuItemProps], UL, 198, 86, 100, 24
    button #menuItems, "Cancel", [cancelMenuItemProps], UL, 48, 86, 100, 24
    open "Menu Item Properties" for dialog_modal as #menuItems
    editMenuItemIsOpen = 1

    print #menuItems.name, "???"
    print #menuItems.branchLabel, "[???]"

    if menuItem$(result - 1, menuItemIndex - 1) = "" then [inputLoop]

    mi$ = menuItem$(result - 1, menuItemIndex - 1)
    print #menuItems.name, left$(mi$, instr(mi$, chr$(0)) - 1)
    print #menuItems.branchLabel, mid$(mi$, instr(mi$, chr$(0)) + 1)

    goto [inputLoop]

[acceptMenuItemProps]   'Perform action for the button named 'acceptMenuItemProps'
    'accept the edited menu item
    print #menuItems.name, "!contents?";
    input #menuItems.name, nResult$
    print #menuItems.branchLabel, "!contents?";
    input #menuItems.branchLabel, blResult$

    if nResult$ = "" or blResult$ = "" then notice "Bad menu item properties." : goto [inputLoop]

    blr$ = blResult$
    if left$(blResult$, 1) <> "[" then blResult$ = "[" + blResult$
    if right$(blResult$, 1) <> "]" then blResult$ = blResult$ + "]"

    if blr$ <> blResult$ then notice "Branch Label was " + blr$ + ", defaulting to " + blResult$

    menuItem$(result - 1, menuItemIndex - 1) = nResult$ + chr$(0) + blResult$
    menuItemLocal$(menuItemIndex - 1) = nResult$ + " -> " + blResult$

    close #menuItems
    editMenuItemIsOpen = 0

    print #editMenu.menuItems, "reload"

    goto [inputLoop]

[cancelMenuItemProps]   'Perform action for the button named 'cancelMenuItemProps'
    'close the window
    gosub [closeEditMenuItem]
    goto [inputLoop]

[closeEditMenuItem]   'close the window before opening it again
    'close the window
    close #menuItems
    if editMenuItemAction$ = "ADD" then menuItemCount(result - 1) = menuItemCount(result - 1) - 1
    editMenuItemIsOpen = 0
    return

[formIsModified]    'the form has been modified, offer to save
    isModified = 0 ' set the isModified flag to be 0
    if objectCount < 2 then return  ' if there are no objects, don't offer to save form
    confirm "Save changes to " + formName$ + "?"; answer$
    if answer$ = "yes" then gosub [saveFormSubroutine]
    return

[settingsDialog]    'edit the settings for FreeForm
    UpperLeftX = 10
    UpperLefyY = 10
    WindowWidth = 300
    WindowHeight = 170

    checkbox #settings.creationInspect, "Inspect each control when created", [creationInspectSet], [creationInspectClear], 22, 10, 280, 19
    checkbox #settings.displayOrdering, "Display control ordering", [displayOrderingSet], [displayOrderingReset], 22, 30, 280, 19
    checkbox #settings.displayFormat, "Screen Layout Displayed for Win3.x Format", [displayFormatSet], [displayFormatReset], 22, 50, 300, 19
    checkbox #settings.displayToolTip, "Always use tooltips", [displayToolTipSet], [displayToolTipReset], 22, 70, 300, 19
    button #settings, "Accept", [settingsAccept], UL, 154, 101,80,24
    button #settings, "Cancel", [settingsCancel], UL, 24, 101,80,24
    open "Settings" for dialog_modal as #settings
    print #settings, "trapclose [settingsCancel]"

    createInspectValue = createInspect
    if createInspect > 0 then print #settings.creationInspect, "set"
    displayOrderingValue = displayOrdering
    if displayOrdering > 0 then print #settings.displayOrdering, "set"
    displayFormatValue = displayFormat
    if displayFormat > 0 then print #settings.displayFormat, "set"
    tooltipFlag = displayToolTip
    if displayToolTip > 0 then print #settings.displayToolTip, "set"

[settings.inputLoop]   'wait here for input event
    input aVar$
    goto [settings.inputLoop]

[displayToolTipSet] 'set value for always using tooltips
    tooltipFlag = 1
    goto [settings.inputLoop]

[displayToolTipReset] ' set value for not always use tooltips
    tooltipFlag = 0
    goto [settings.inputLoop]

[creationInspectSet]   'set value for inspect on create
    createInspectValue = 1
    goto [settings.inputLoop]

[creationInspectClear]   'set value for no inspect on create
    createInspectValue = 0
    goto [settings.inputLoop]

[displayOrderingSet]   'set value for displaying of control ordering
    displayOrderingValue = 1
    goto [settings.inputLoop]

[displayOrderingReset]   'set value for non-displaying of control ordering
    displayOrderingValue = 0
    goto [settings.inputLoop]

[displayFormatSet]
    displayFormatValue = 1
    goto [settings.inputLoop]

[displayFormatReset]
    displayFormatValue = 0
    goto [settings.inputLoop]

[settingsAccept]   'accept the settings
    createInspect = createInspectValue
    displayOrdering = displayOrderingValue
    displayFormat = displayFormatValue
    displayToolTip = tooltipFlag
    close #settings
    if displayFormat = 1 then loadbmp "systemBox", "bmp\systembx.bmp"
    if displayFormat = 0 and left$(windowType$, 6) = "dialog" then loadbmp "systemBox", "bmp\95sysbxd.bmp"
    if displayFormat = 0 and left$(windowType$, 6) <> "dialog" then loadbmp "systemBox", "bmp\95sysbx.bmp"
    if displayFormat = 1 then loadbmp "minBox", "bmp\minbx.bmp" else loadbmp "minBox", "bmp\95minbx.bmp"
    if displayFormat = 1 then loadbmp "maxBox", "bmp\maxbx.bmp" else loadbmp "maxBox", "bmp\95maxbx.bmp"
    print #form, "font ";font$(1)
    gosub [redrawAll]

    goto [inputLoop]

[settingsCancel]   'discard any settings changes
    close #settings
    goto [settings.inputLoop]

[loadIniFile]   'load the user preferences
    if fileExists(DefaultDir$, "ffrm2023.ini") then
        open "ffrm2023.ini" for input as #ini
        input #ini, xInterval   'snap to x
        input #ini, yInterval   'snap to y
        input #ini, snapOn      'snap to on/off
        input #ini, createInspect 'inspect each control when created
        input #ini, displayOrdering 'display control ordering
        input #ini, displayFormat
        input #ini, displayToolTip ' 1 = Use tooltips
        input #ini, libertyexe$
        close #ini
    else
        gosub [saveIniFile]
    end if

    return

[saveIniFile]   'save the user preferences
    open "ffrm2023.ini" for output as #ini

    print #ini, xInterval
    print #ini, yInterval
    print #ini, snapOn
    print #ini, createInspect
    print #ini, displayOrdering
    print #ini, displayFormat
    print #ini, displayToolTip
    print #ini, libertyexe$

    close #ini

    return

[copyControl] ' Copy the selected control
    if index < 2 then [inputLoop]
    gosub [selectDeselect]
    objectCount = objectCount + 1
    idx = index
        type$(objectCount) = type$(idx)
        label$(objectCount) = label$(idx)
        names$(objectCount) = type$(idx)+str$(objectCount-1)
        xOrg(objectCount) = xOrg(idx) + 10
        yOrg(objectCount) = yOrg(idx) + 10
        width(objectCount) = width(idx)
        height(objectCount) = height(idx)
        corner$(objectCount) = corner$(idx)
        segment(objectCount) = segment(idx)
        handle$(objectCount) = handle$(idx)
        bmpName$(objectCount) = bmpName$(idx)
        arrayName$(objectCount) = arrayName$(idx)

    if type$(idx) = "button" then [copyButton]
    if type$(idx) = "textbox" then [copyField]
    if type$(idx) = "textedit" then [copyTextEdit]
    if type$(idx) = "combobox" then [copyComboBox]
    if type$(idx) = "listbox" then [copyListBox]
    if type$(idx) = "statictext" then [copyStaticText]
    if type$(idx) = "groupbox" then [copyGroupBox]
    if type$(idx) = "graphicbox" then [copyGraphicBox]
    if type$(idx) = "radiobutton" then [copyRadioButton]
    if type$(idx) = "checkbox" then [copyCheckBox]
    if type$(idx) = "bmpbutton" then [copyBmpButton]
    goto [inputLoop]

[copyButton]     'copies a button to the form
    branchLabel$(objectCount) = "["+names$(objectCount)+"Click]"
    text$ = label$(objectCount)
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderButton]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyBmpButton]     'copies a new bmpButton to the form
    branchLabel$(objectCount) = "["+names$(objectCount)+"Click]"
    text$ = label$(objectCount)
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderBmpButton]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyField]     'copies a new field (textBox) to the form
    text$ = label$(objectCount)
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderTextBox]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyTextEdit]     'copies a new field (textBox) to the form
    text$ = label$(objectCount)
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderTextEdit]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyComboBox]     'copies a new combobox to the form
    text$ = label$(objectCount)
    branchLabel$(objectCount) = "["+names$(objectCount)+"DoubleClick]"
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderComboBox]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyListBox]     'copies a new listbox to the form
    text$ = label$(objectCount)
    branchLabel$(objectCount) = "["+names$(objectCount)+"DoubleClick]"
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderListBox]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyStaticText]     'copies statictext to the form
    text$ = label$(objectCount)
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderStaticText]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyGroupBox]     'copies groupbox to the form
    text$ = label$(objectCount)
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderGroupBox]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyGraphicBox]     'copies graphicbox to the form
    text$ = label$(objectCount)
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderGraphicBox]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyRadioButton]     'copies radiobutton to the form
    text$ = label$(objectCount)
    branchLabel$(objectCount) = "["+names$(objectCount)+"Set] ["+names$(objectCount)+"Reset]"
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderRadioButton]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[copyCheckBox]     'copies checkbox to the form
    text$ = label$(objectCount)
    branchLabel$(objectCount) = "["+names$(objectCount)+"Set] ["+names$(objectCount)+"Reset]"
    newControlNumber = newControlNumber + 1
    idx = objectCount
    gosub [renderCheckBox]
    gosub [redrawAll]
    index = objectCount
    gosub [selectDeselect]
    goto [inputLoop]

[popupMenu] ' Open context-sensitive popup menus
    if index <= 1 then
        PopupMenu "&Title", [changeTitle],_
                "T&ype", [changeWindowType],_
                "&Handle", [changeHandle],_
                "&Initial Location",[changeInitialLocation],_
                "Si&ze",[changeWindowSize],|,_
                "&Add a Menu", [addAMenu],_
                "&Remove a Menu", [removeMenu],_
                "&Edit Menus", [editMenus],|,_
                "&Background Colour", [changeColorType],_
                "Fore&ground Colour", [changeForegroundColor],_
                "&Font for controls",[changeControlFont],|,_
                "&Auto Snap to Grid", [gridDialog],_
                "&Settings", [settingsDialog],_
                "&Produce Code", [produceCode],_
                "Produce Code + &Outline", [produceCodeAndOutline],_
                "&Test Code",[testCode]
        else
        if type$(index) = "combobox" or type$(index) = "listbox" or type$(index) = "textbox" or type$(index) = "textedit" then
                popupmenu "Copy",[copyControl],"Delete",[deleteControl],"Properties",[inspectControl],"Color",[changeBoxColor],|,"Move to Front",[moveToFront],"Move to Back",[moveToBack]
            else
            if type$(index) = "bmpbutton" then
                popupmenu "Copy",[copyControl],"Delete",[deleteControl],"Properties",[inspectControl],"Change Bitmap",[changeBmpButton],"Move to Front",[moveToFront],"Move to Back",[moveToBack]
            else
                popupmenu "Copy",[copyControl],"Delete",[deleteControl],"Properties",[inspectControl],"Move to Front",[moveToFront],"Move to Back",[moveToBack]
            end if
        end if
    end if
    goto [inputLoop]

function fileExists(path$, filename$) ' Does file exist?
    files path$, filename$, info$(
    fileExists = val(info$(0, 0)) > 0
end function


[addTooltips] ' Add tooltips to Freeform... won't work in Windows NT!
    GWW = _GWW_HINSTANCE or 0
    style           = 0
    CW.USEDEFAULT   = hexdec("8000")
    TTF.IDISHWND    = hexdec("0001")
    TTF.SUBCLASS    = hexdec("0010")
    TTM.ADDTOOL     = _WM_USER+4

    h=hwnd(#form)
    open "user" for dll as #user
    open "commctrl.dll" for dll as #cctl

    calldll #cctl, "InitCommonControls", re as void
    calldll #user, "GetWindowWord", h as word,_
        GWW as word, hInstance as word

    calldll #user, "CreateWindow", _
        "tooltips_class" as ptr, _
        "" as ptr, _
        style as long, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        h as word, _
        0 as word, _
        hInstance as word, _
        "" as ptr, _
        hwndTT as word

    '** MAKE A STRUCT FOR EACH TOOL
    struct toolinfo1, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo2, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo3, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo4, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo5, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo6, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo7, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo8, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo9, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo10, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo11, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo12, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo13, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo14, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo15, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo16, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo17, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo18, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo19, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo20, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo21, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr


    toolinfo1.cbSize.struct = 22
    toolinfo1.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo1.hwnd.struct = h
    toolinfo1.uId.struct = hwnd(#form.load)
    toolinfo1.hInst.struct = hInstance
    toolinfo1.lpstrText$.struct = "Open File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo1 as struct, re as long

    toolinfo2.cbSize.struct = 22
    toolinfo2.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo2.hwnd.struct = h
    toolinfo2.uId.struct = hwnd(#form.save)
    toolinfo2.hInst.struct = hInstance
    toolinfo2.lpstrText$.struct = "Save File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo2 as struct, re as long

    toolinfo3.cbSize.struct = 22
    toolinfo3.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo3.hwnd.struct = h
    toolinfo3.uId.struct = hwnd(#form.static)
    toolinfo3.hInst.struct = hInstance
    toolinfo3.lpstrText$.struct = "Static Text"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo3 as struct, re as long

    toolinfo4.cbSize.struct = 22
    toolinfo4.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo4.hwnd.struct = h
    toolinfo4.uId.struct = hwnd(#form.field)
    toolinfo4.hInst.struct = hInstance
    toolinfo4.lpstrText$.struct = "Text Box"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo4 as struct, re as long

    toolinfo5.cbSize.struct = 22
    toolinfo5.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo5.hwnd.struct = h
    toolinfo5.uId.struct = hwnd(#form.button)
    toolinfo5.hInst.struct = hInstance
    toolinfo5.lpstrText$.struct = "Button"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo5 as struct, re as long

    toolinfo6.cbSize.struct = 22
    toolinfo6.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo6.hwnd.struct = h
    toolinfo6.uId.struct = hwnd(#form.bmp)
    toolinfo6.hInst.struct = hInstance
    toolinfo6.lpstrText$.struct = "BmpButton"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo6 as struct, re as long

    toolinfo7.cbSize.struct = 22
    toolinfo7.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo7.hwnd.struct = h
    toolinfo7.uId.struct = hwnd(#form.list)
    toolinfo7.hInst.struct = hInstance
    toolinfo7.lpstrText$.struct = "Listbox"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo7 as struct, re as long

    toolinfo8.cbSize.struct = 22
    toolinfo8.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo8.hwnd.struct = h
    toolinfo8.uId.struct = hwnd(#form.combo)
    toolinfo8.hInst.struct = hInstance
    toolinfo8.lpstrText$.struct = "Combobox"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo8 as struct, re as long

    toolinfo9.cbSize.struct = 22
    toolinfo9.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo9.hwnd.struct = h
    toolinfo9.uId.struct = hwnd(#form.radio)
    toolinfo9.hInst.struct = hInstance
    toolinfo9.lpstrText$.struct = "Radiobutton"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo9 as struct, re as long

    toolinfo10.cbSize.struct = 22
    toolinfo10.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo10.hwnd.struct = h
    toolinfo10.uId.struct = hwnd(#form.check)
    toolinfo10.hInst.struct = hInstance
    toolinfo10.lpstrText$.struct = "Checkbox"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo10 as struct, re as long

    toolinfo11.cbSize.struct = 22
    toolinfo11.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo11.hwnd.struct = h
    toolinfo11.uId.struct = hwnd(#form.group)
    toolinfo11.hInst.struct = hInstance
    toolinfo11.lpstrText$.struct = "Groupbox"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo11 as struct, re as long

    toolinfo12.cbSize.struct = 22
    toolinfo12.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo12.hwnd.struct = h
    toolinfo12.uId.struct = hwnd(#form.edit)
    toolinfo12.hInst.struct = hInstance
    toolinfo12.lpstrText$.struct = "Texteditor"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo12 as struct, re as long

    toolinfo13.cbSize.struct = 22
    toolinfo13.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo13.hwnd.struct = h
    toolinfo13.uId.struct = hwnd(#form.graphic)
    toolinfo13.hInst.struct = hInstance
    toolinfo13.lpstrText$.struct = "Graphicbox"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo13 as struct, re as long

    toolinfo14.cbSize.struct = 22
    toolinfo14.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo14.hwnd.struct = h
    toolinfo14.uId.struct = hwnd(#form.fill)
    toolinfo14.hInst.struct = hInstance
    toolinfo14.lpstrText$.struct = "Fill Color"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo14 as struct, re as long

    toolinfo15.cbSize.struct = 22
    toolinfo15.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo15.hwnd.struct = h
    toolinfo15.uId.struct = hwnd(#form.inspect)
    toolinfo15.hInst.struct = hInstance
    toolinfo15.lpstrText$.struct = "Inspect Control"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo15 as struct, re as long

    toolinfo16.cbSize.struct = 22
    toolinfo16.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo16.hwnd.struct = h
    toolinfo16.uId.struct = hwnd(#form.delete)
    toolinfo16.hInst.struct = hInstance
    toolinfo16.lpstrText$.struct = "Delete Control"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo16 as struct, re as long

    toolinfo17.cbSize.struct = 22
    toolinfo17.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo17.hwnd.struct = h
    toolinfo17.uId.struct = hwnd(#form.infront)
    toolinfo17.hInst.struct = hInstance
    toolinfo17.lpstrText$.struct = "Bring to Front"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo17 as struct, re as long

    toolinfo18.cbSize.struct = 22
    toolinfo18.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo18.hwnd.struct = h
    toolinfo18.uId.struct = hwnd(#form.inback)
    toolinfo18.hInst.struct = hInstance
    toolinfo18.lpstrText$.struct = "Send to Back"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo18 as struct, re as long

    toolinfo19.cbSize.struct = 22
    toolinfo19.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo19.hwnd.struct = h
    toolinfo19.uId.struct = hwnd(#form.code)
    toolinfo19.hInst.struct = hInstance
    toolinfo19.lpstrText$.struct = "Produce Code"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo19 as struct, re as long

    toolinfo20.cbSize.struct = 22
    toolinfo20.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo20.hwnd.struct = h
    toolinfo20.uId.struct = hwnd(#form.outline)
    toolinfo20.hInst.struct = hInstance
    toolinfo20.lpstrText$.struct = "Produce Code and Outline"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo20 as struct, re as long

    toolinfo21.cbSize.struct = 22
    toolinfo21.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo21.hwnd.struct = h
    toolinfo21.uId.struct = hwnd(#form)
    toolinfo21.hInst.struct = hInstance
    toolinfo21.lpstrText$.struct = "Right Click for Menu"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo21 as struct, re as long

    close #cctl:close #user

    RETURN

'this code lifted from the LB open source editor
[readyRun]' ** MAKE A TEMP FILE TO RUN IN LIBERTY BASIC
    print #code, "!selectall";
    '** GET CONTENTS OF TEXTEDITOR AND SAVE TO TEMPFILE
    if tempfilename$<>"" then kill tempfilename$
    print #code, "!contents?"
    input #code, saveit$ 
    tempfilename$=filePath$+"tempfile.bas"
    open tempfilename$ for output as #temp
    print #temp, saveit$
    close #temp
    close #code
    codeIsOpen = 0
    if libertyexe$="" then gosub [findLiberty]
    RETURN

[findLiberty]'** FIND LIBERTY.EXE
    filedialog "Find Liberty.exe","*.exe",libertyexe$ 
    RETURN

[run]
    gosub [readyRun]
    if libertyexe$ = "" then notice "Liberty BASIC not located!": goto [inputLoop]
    run libertyexe$+" -R -A -M "+tempfilename$ 
    goto [inputLoop]

[debug]
    gosub [readyRun]
    run libertyexe$+" -D -A -M "+tempfilename$
    goto [inputLoop]

[inspectControl] 'pop up a dialog for displaying/modifying control properties
    ' This is slated for improvement soon!

    if index < 1 then [inputLoop]

    if index = 1 then [inspectWindow]

    if inspectIsOpen = 1 then close #inspect
    inspectIsOpen = 1

    WindowWidth =  155
    WindowHeight =  255
    UpperLeftX=100
    UpperLeftY=50
    statictext #inspect.st, "type",    1, 0, 48, 18
    statictext #inspect.sx, "x-org",   1, 21, 48, 18
    statictext #inspect.sy, "y-org",   1, 42, 48, 18
    statictext #inspect.sw, "width",   1, 63, 48, 18
    statictext #inspect.sh, "height",  1, 84, 48, 18
    statictext #inspect.sc, "caption", 1, 105, 48, 18
    statictext #inspect.sb, "branch",  1, 126, 48, 18
    statictext #inspect.se, ".ext",    1, 147, 48, 18
    statictext #inspect.sa, "array(",  1, 168, 48, 18

    statictext #inspect.type, "Type",  50, 0, 90, 18
    textbox #inspect.x,                50, 21, 90, 24
    textbox #inspect.y,                50, 42, 90, 24
    textbox #inspect.w,                50, 63, 90, 24
    textbox #inspect.h,                50, 84, 90, 24
    textbox #inspect.labelField,       50, 105, 90, 24
    textbox #inspect.branchLabelField, 50, 126, 90, 24
    textbox #inspect.nameField,        50, 147, 90, 24
    textbox #inspect.arrayNameField,   50, 168, 90, 24

    button #inspect.default, "Accept",[acceptInspect],UL,74,196,70,24
    button #inspect.cancel, "Cancel",[cancelInspect],UL,  1,196,70,24

    Open "Properties" for dialog as #inspect
    print #inspect, "trapclose [cancelInspect]";
    print #inspect, "font ms_sans_serif 8"
    print #inspect.x, "!setfocus"

    print #inspect.type, upper$(type$(index))

    print #inspect.labelField, label$(index)
    print #inspect.nameField, names$(index)
    print #inspect.branchLabelField, branchLabel$(index)
    print #inspect.arrayNameField, arrayName$(index)
    dummyx$=str$(xOrg(index)-xOrg-4)
    dummyy$=str$(yOrg(index)-yOrg-20-4)
    print #inspect.x, dummyx$
    print #inspect.y, dummyy$
    print #inspect.w, str$(width(index))
    print #inspect.h, str$(height(index))

    if instr(" button statictext checkbox radiobutton graphicbox groupbox ", type$(index)) = 0 then print #inspect.labelField, "n/a"
    if instr(controlsThatBranch$, type$(index)) = 0 then print #inspect.branchLabelField, "n/a"
    if instr(" listbox combobox ", type$(index)) > 0 then print #inspect.arrayNameField, arrayName$(index) else print #inspect.arrayNameField, "n/a"

    goto [inputLoop]

[acceptInspect] 'set the properties as modified by the user
    isModified = 1  'the form has been modified
    print #inspect.nameField, "!contents? names$" : names$(index) = names$
    branches = instr(controlsThatBranch$, type$(index))
    if branches > 0 then print #inspect.branchLabelField, "!contents? bLabel$" : branchLabel$(index) = bLabel$
    usesArray = instr(" listbox combobox ", type$(index))
    if usesArray > 0 then print #inspect.arrayNameField, "!contents? aName$" : arrayName$(index) = aName$

    print #inspect.x, "!contents? dummy$" : xOrg(index)=val(dummy$)+xOrg+4
    print #inspect.y, "!contents? dummy$" : yOrg(index)=val(dummy$)+yOrg+24
    print #inspect.w, "!contents? dummy$" : width(index)=val(dummy$)
    print #inspect.h, "!contents? dummy$" : height(index)=val(dummy$)
    print #inspect.labelField, "!contents? label$" : label$(index) = label$ 

    close #inspect
    inspectIsOpen = 0

    gosub [redrawAll]
    goto [inputLoop]

[cancelInspect] 'close the inspector window
    close #inspect
    inspectIsOpen = 0
    goto [inputLoop]

[inspectWindow]
    UpperLeftX = 10
    UpperLeftY = 10
    WindowWidth = 260
    WindowHeight = 305

    statictext #inspect.statictext1, "Title", 6, 6, 40, 20
    statictext #inspect.statictext2, "Type", 6, 30, 32, 20
    statictext #inspect.statictext3, "Handle", 6, 54, 48, 20
    statictext #inspect.statictext4, "Initial X", 6, 78, 72, 20
    statictext #inspect.statictext5, "Initial Y", 6, 102, 72, 20
    statictext #inspect.statictext6, "Width", 6, 126, 40, 20
    statictext #inspect.statictext7, "Height", 6, 150, 48, 20
    statictext #inspect.statictext9, "BG Color", 6, 178, 64, 20
    statictext #inspect.statictext10, "FG Color", 6, 198, 64, 20
    statictext #inspect.statictext11, "Font", 6, 186+36, 32, 20
    textbox #inspect.title, 61, 1, 165, 20
    combobox #inspect.type, winType$(, [inspectWindowTypeSelect], 61, 21, 165, 100
    textbox #inspect.handle, 61, 41+4, 165, 20
    textbox #inspect.initx, 61, 61+8, 165, 20
    textbox #inspect.inity, 61, 81+12, 165, 20
    textbox #inspect.width, 61, 101+16, 165, 20
    textbox #inspect.height, 61, 121+20, 165, 20
    combobox #inspect.bgcolor, colorType$(, [inspectWindowBGColorSelect], 61, 141+24, 165, 105
    combobox #inspect.fgcolor, colorType$(, [inspectWindowFGColorSelect], 61, 161+28, 165, 105
    statictext #inspect.statictext23, "Font", 61, 186+32, 32, 20
    button #inspect.cancel, "Cancel", [cancelInspectWindow], UL, 46, 221+36, 58, 25
    button #inspect.accept, "Accept", [accpetInspectWindow], UL, 121, 221+36, 58, 25
    open "Window Properties" for dialog_modal as #inspect
    print #inspect, "font ms_sans_serif 0 16"
    print #inspect, "trapclose [cancelInspectWindow]"
    print #inspect.title, windowLabel$
    print #inspect.type, "select ";windowType$
    print #inspect.handle, winHandle$
    print #inspect.initx, windowXOrigin
    print #inspect.inity, windowYOrigin
    print #inspect.width, windowXExtent
    print #inspect.height, windowYExtent
    print #inspect.bgcolor, "select ";currentBackgroundColor$
    print #inspect.fgcolor, "select ";currentForegroundColor$
    goto [inputLoop]

[inspectWindowTypeSelect]
    print #inspect.type, "selection? newWindowType$"
    goto [inputLoop]
[inspectWindowBGColorSelect]
    print #inspect.bgcolor, "selection? newBGColor$"
    goto [inputLoop]
[inspectWindowFGColorSelect]
    print #inspect.fgcolor, "selection? newFGColor$"
    goto [inputLoop]

[accpetInspectWindow]
    if newWindowType$ <> windowType$ then windowType$ = newWindowType$

    if newBGColor$ <> currentBackgroundColor$ then
        currentBackgroundColor$ = newBGColor$
        colorType$ = newBGColor$ 
        if left$(windowType$, 8) = "graphics" then
            colorDefaultType$ = colorType$
                else
            wincolor$ = colorType$
        end if
    end if

    if newFGColor$ <> currentForegroundColor$ then currentForegroundColor$ = newFGColor$
    print #inspect.title, "!contents? newTitle$"
    print #inspect.handle, "!contents? newHandle$"
    print #inspect.initx, "!contents? newXOrigin$"
    print #inspect.inity, "!contents? newYOrigin$"
    print #inspect.width, "!contents? newXExtent$"
    print #inspect.height, "!contents? newYExtent$"

    windowLabel$ = newTitle$
    if newHandle$ <> "" then winHandle$ = newHandle$
    if newXOrigin$ <> "" then windowXOrigin = val(newXOrigin$)
    if newYOrigin$ <> "" then windowYOrigin = val(newYOrigin$)
    if newXExtent$ <> "" then windowXExtent = val(newXExtent$)
    if newYExtent$ <> "" then windowYExtent = val(newYExtent$)


[cancelInspectWindow]
    close #inspect
    gosub [redrawAll]
    goto [inputLoop]

[selectBmpPath] ' User keys in a bitmap path
    if bmpPath$ = "" then bmpPath$ = "proggie\bmp\"
    prompt "Type in bitmap path:";bmpPath$
    if bmpPath$ = "proggie\bmp\" then bmpPath$ = "": goto [inputLoop]
    ok = 0
    if right$(bmpPath$,1) <> "\" then bmpPath$ = bmpPath$+"\"
    if left$(bmpPath$,1) = "\" then bmpPath$ = right$(bmpPath$,len(bmpPath$)-1)
    goto [inputLoop]

[quit]   'exit Freeform
    if isModified = 1 then gosub [formIsModified]

    'quit freeform
    confirm "Are you sure?"; answer$
    if answer$ = "no" then [inputLoop]
    gosub [saveIniFile]
    close #form
    if codeIsOpen then close #code
    end

