'** Open Source Editor v17.0
'** Please add your name to
'** the list of authors:
'**
'** Authors:
'**
'** Alyce Watson
'** Brent Thorn      - tooltip routines and cascading popup menu
'** Thomas Watson    - RGB color choice
'** David Szafranski - launch browser with URL & launch email
'** Cameron Arnott   - code library
'** September 2000   - added recent files menu list by Brent Thorn
'** January 2000     - adding runtime engine for LB2 w/command line
'** Doyle Whisenant  - array-maker similar to LB Workshop tool

    if val(Version$)<2 then
        notice "This program is meant for in LBv2.0!"
        end
    end if

    cursor hourglass
    nomainwin

    gosub [makebmpbutton]

    if FileExist(DefaultDir$,"\qbutton.bmp")<1 then
        notice "Error"+chr$(13)+"Unable to create bmpbutton!"
        end
    end if


    open "user" for dll as #user
    dim info$(10,10)        'for file exist check
    open "commctrl.dll" for dll as #cctl

    dim branch$(20)         'array to hold branch labels
    dim code$(100)          'array to hold code titles
    dim recentfiles$(3)       'array to hold recent files


'variables:
'file$              name of file to open
'title$             titlebar caption
'h                  is window handle
'modflag$           is answer to modified query
'answer$            receiver variable for confirm messages
'tempfilename$      name to use when running and debugging code
'rowVar,columnVar   location of texteditor origin
'fileindex          used for counter in path/file separation
'filelength         used for counter in path/file separation
'shortFile$         just filename without path
'filePath$          path without filename
'saveit$            receiver for input from texteditor
'libertyexe$        path to Liberty.exe for running/tokenizing/debugging
'tknfile$           name of tkn to run
'hInstance          window instance handle
'rowcount           number of lines in editor
'line$              contents of line in editor
'bx                 counter variable for branch label loading
'branchlength       length of branch label
'branchselect$      branch label selection
'picFile$           filename for opened bitmap
'pic$               string to hold bitmap file header
'savebmpfile$       name to save bmp AS
'bmpwidth           width of bitmap
'bmpheight          height of bitmap
'xbmp               x location to draw bitmap in graphibox
'ybmp               y location to draw bitmap in graphibox
'bmploaded          flag to set when a bitmap is loaded
'message$           string variable to hold notice and confirm messages
'printFile$         temporary file for printing with Notepad
'wavPath$           path to last wav played
'wavFile$           name of wav file to play
'slash              counter variable to separate wav path from filename
'setFont$           LB fontname and size info for chosen font
'timemsg$           variable to hold time info
'datemsg$           variable to hold date info
'codeChoice$        for code library
'codeline$          input variable for code library
'codeindex          array index variable for code library
'endmarker          marker for end of snippet in code library
'RunFile$           for ShellExecute
'lpOperation$       for ShellExecute
'lpParameters$      for ShellExecute
'lpDirectory$       for ShellExecute
'nShowCmd           show window flag for ShellExecute
'helpopen           flag for help window opening

'** NEW **
'** array variables
'bString            flag for array string
'bNumeric           flag for array numeric
'i                  index var for general use
'a                  index var for general use
'arrayName$         name of array
'arrayItem$         individual array items
'myarray$()         variable for generating array items
'ArrayFileName$     name of file opened for creating array
'line$              file input variable

'** NEW **
'removed Runtime icon changer, and these vars,
'since icon changer no longer works for LB2:
'hicon              icon handle
'szFile$            runtime engine name
'runtime$           runtime engine name
'icon$              icon file name
'#1icon             icon file handle
'success=0
'ico                used for icon changer
'runpos             used for icon changer
'error              error flag in icon changer
'icopath$           path in icon changer
'hico               handle of icon window
'hicodc             dc of icon window
'hFile              icon file handle
'icont$             buffer for icon file input
'iconlength         length of icon buffer


'for tooltips:
    GWW = _GWW_HINSTANCE or 0
    style           = 0
    CW.USEDEFAULT   = hexdec("8000")
    TTF.IDISHWND    = hexdec("0001")
    TTF.SUBCLASS    = hexdec("0010")
    TTM.ADDTOOL     = _WM_USER+4


    ForegroundColor$=   "darkblue"
    TexteditorColor$=   "lightgray"
    drawcolor$=         "black"     'default color for drawing on bitmaps
    longcol=            0           'default color for drawing on bitmaps
    colorred=           0           'default red value for drawing on bitmaps
    colorgreen=         0           'default green value for drawing on bitmaps
    colorblue=          0           'default blue value for drawing on bitmaps
    decnum$=            "255"       'default starter for number conversion
    decnum=val(decnum$)
    hexnum$=            "FF"        'default starter for number conversion
    btnhigh =           15          'button height value
    btnwide =           30          'button width value
    btnY    =           2           'button y location


menu #1, "&File",_
    "&New",               [new],_
    "&Open",              [open],_
    "&Save",              [save],_
    "Save &As",           [saveas],|,_
    "&Print",             [print],_
    "E&xit",              [quit],_
    "&Recent",            [loop]

menu #1, "&Edit" 'LB supplies the Edit Menu


    Menu #1, "Recent",_
    "File 1",             [File_1],_
    "File 2",             [File_2],_
    "File 3",             [File_3]


menu #1, "&Run",_
    "Ru&n",               [run],_
    "&Debug",             [debug],_
    "&Make TKN",          [maketkn],_
    "Run &TKN",           [runtkn]

menu #1, "E&xternals",_
    "&Paintbrush",        [paint],_
    "&File Manager",      [winfile],_
    "&Notepad",           [notepad],_
    "&Calculator",        [calculator]

'** NEW **
menu #1, "&Tools",_
    "&Branch Labels",        [branchlabels],_
    "Bit&map Preview",       [bmp],_
    "&Wav Preview",          [wav],_
    "&Array Maker",          [makeArrays],_
    "Code &Library",         [code.library],|,_
    "Font &Dialog",          [fontdialog],_
    "&Number Tools	->",      [numbertools],_
    "Time and D&ate	->",     [timetools],|,_
    "Libert&y BASIC Website",[libertyhome],_
    "Email Carl &Gundel",    [emailcarl]


menu #1, "&Help",_
    "&Liberty BASIC Help", [help],_
    "LB &Tutorial",        [tutorial],_
    "&Editor Help",        [edithelp],_
    "&About",              [about]

    texteditor #1.t, 0,40,600,400  'edit window

    button #1.new,     "New",   [new],       UL,3,btnY,btnwide,btnhigh
    button #1.open,    "Open",  [open],      UL,34,btnY,btnwide,btnhigh
    button #1.save,    "Save",  [save],      UL,65,btnY,btnwide,btnhigh
    button #1.saveas,  "..As",  [saveas],    UL,96,btnY,btnwide,btnhigh
    button #1.print,   "Print", [print],     UL,127,btnY,btnwide,btnhigh

    button #1.run,     "Run",   [run],       UL,167,btnY,btnwide,btnhigh
    button #1.debug,   "Debug", [debug],     UL,198,btnY,btnwide,btnhigh
    button #1.token,   "TKN",   [maketkn],   UL,229,btnY,btnwide,btnhigh
    button #1.runtkn,  "R tkn", [runtkn],    UL,260,btnY,btnwide,btnhigh

    button #1.paint,   "Paint", [paint],     UL,300,btnY,btnwide,btnhigh
    button #1.file,    "F Mgr", [winfile],   UL,331,btnY,btnwide,btnhigh
    button #1.note,    "Note",  [notepad],   UL,362,btnY,btnwide,btnhigh
    button #1.calc,    "Calc",  [calculator],UL,393,btnY,btnwide,btnhigh

    button #1.help,    "Help",  [help],      UL,433,btnY,btnwide,btnhigh
    button #1.tutor,   "Tutor", [tutorial],  UL,464,btnY,btnwide,btnhigh

    bmpbutton #1.quit, "qbutton.bmp",[quit],UL,504,btnY


open "Open Source LB Editor" for window as #1

    h=HWND(#1)
    hText=hwnd(#1.t)
    print #1, "trapclose [quit]"
    print #1, "resizehandler [resize]"

    calldll #user, "ShowWindow",h as word,_SW_MAXIMIZE as ushort,result As word

    print #1,     "font arial 0 12"
    print #1.t, "!setfocus";
    gosub [addTooltips]
    gosub [read.ini.file]
    gosub [create.caret]
    gosub [remove.menu]

[check.command]  'if CommandLine$ contains a filename, it will be loaded at startup
    if CommandLine$<>"" then
        CommandLine$=lower$(trim$(CommandLine$))
        if right$(CommandLine$,3)="bas" then
            i=len(CommandLine$)
            while mid$(CommandLine$,i,1)<>" " and i>1
                i=i-1
            wend
            file$=mid$(CommandLine$,i)
            goto [loadFile]
        end if
    end if


[loop]
    cursor normal
    input a$



[quit]
    gosub [isModified]
    CallDLL #user, "DestroyCaret",r as void
    close #user: close #1 : close #cctl
    if tempfilename$<>"" then kill tempfilename$ 
    END


[isModified]'** CHECK TO SEE IF FILE HAS BEEN MODIFIED
    print #1.t, "!modified?":input #1.t, modflag$
    if modflag$="true" then
        confirm "This file has been modified.  Save?";answer$
        if answer$="yes" then gosub [savesub]
    end if
    RETURN


[resize]'** LOCATE TEXT EDITOR
    '** LOCATE TEXTEDITOR 20 PIXELS FROM TOP OF CLIENT AREA
    print #1.t, "!locate 0 20 ";WindowWidth-1;" ";WindowHeight-21
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    '** UPDATE WINDOW
    print #1, "refresh"
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]


[new]'** CLEAR EDITOR CONTENTS, RESET VARIABLES
    gosub [isModified]
    print #1.t, "!cls"
    file$="untitled.bas"
    filePath$=""
    gosub [settext]
    goto [loop]



[open]
    gosub [isModified]
    filedialog "Open file..",filePath$+"*.bas",file$ 
    if file$="" then [loop]
    gosub [recent.files]


[loadFile]'** OPEN FILE AND LOAD INTO TEXTEDITOR
    shortFile$=SeparateFile$(file$)
    filePath$=SeparatePath$(file$)

    if FileExist(filePath$,shortFile$)<1 then
        notice "Error"+chr$(13)+"File does not exist."
        goto [loop]
    end if

    cursor hourglass
    open file$ for input as #file
    print #1.t, "!contents #file"
    close #file
    gosub [settext]
    print #1.t, "!origin 1 1";
    cursor normal
    goto [loop]



[settext]'** ADD FILENAME TO TITLEBAR
    title$="Open Source LB Editor "+file$
    calldll #user, "SetWindowText", h as word, title$ as ptr, result as void
    return



[saveas]'** SAVES CONTENTS AS file$
    filedialog "Save file as..",filePath$+"*.bas",file$ 
      if file$="" then
        notice "You must choose a file name."
        goto [loop]
      end if
    gosub [settext]

[save]'** SAVES CURRENT FILE
    gosub [savesub]
    goto [loop]


[savesub]
    cursor hourglass
    print #1.t, "!contents?";
    input #1.t, saveit$

    '** IF THERE IS NO CURRENT FILENAME, ASK USER FOR ONE
    if (right$(file$,12)="untitled.bas") or (file$="") then
        filedialog "Save file as...",filePath$+"*.bas",file$ 
          if file$="" then
            notice "You must choose a file name."
            RETURN
          end if
    end if

    open file$ for output as #file
    print #file, saveit$
    close #file

    cursor normal
    notice "File saved as "+ file$
    RETURN


[print]
    cursor hourglass
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar
    print #1.t, "!contents?";
    input #1.t, saveit$ 

    open "tempedit.txt" for output as #tprint
        print #tprint, saveit$
    close #tprint

    printFile$ = "tempedit.txt"+chr$(0)

    open "shell.dll" for dll as #shell
    calldll #shell, "ShellExecute", _
        h as word, _
        "print" as ptr, _
        printFile$ as ptr, _
        "" as ptr, _
        DefaultDir$ as ptr, _
        _SW_HIDE as short, _
        result as word
    close #shell

    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    cursor normal
    goto [loop]


[readyRun]'** MAKE A TEMP FILE TO RUN IN LIBERTY BASIC
    '** GET CURRENT TEXTEDIT ORIGIN
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    '** GET CONTENTS OF TEXTEDITOR AND SAVE TO TEMPFILE
    if tempfilename$<>"" then kill tempfilename$
    print #1.t, "!contents?"
    input #1.t, saveit$ 
    tempfilename$=filePath$+"tempfile.bas"
    open tempfilename$ for output as #temp
    print #temp, saveit$
    close #temp

    if libertyexe$="" then gosub [findLiberty]
    RETURN


[findLiberty]'** FIND LIBERTY.EXE
    filedialog "Find Liberty.exe","*.*",libertyexe$ 
    RETURN


[run]
    gosub [readyRun]
    run libertyexe$+" -R -A -M "+tempfilename$ 
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]

[debug]
    gosub [readyRun]
    run libertyexe$+" -D -A -M "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]

[runtkn]
    filedialog "Choose TKN..","*.TKN",tknfile$
    run tknfile$
    goto [loop]

[maketkn]
    gosub [readyRun]
    run libertyexe$+" -T "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]



[paint]
    run "pbrush.exe",SHOWNORMAL
    goto [loop]

[notepad]
    run "notepad.exe",SHOWNORMAL
    goto [loop]

[winfile]
    run "winfile.exe",SHOWNORMAL
    goto [loop]

[calculator]
    run "calc.exe" ,SHOWNORMAL
    goto [loop]



[help]
    run "winhelp liberty.hlp"
    goto [loop]

[tutorial]
    run "winhelp tutorial.hlp"
    goto [loop]



[addTooltips]
    calldll #cctl, "InitCommonControls", re as void
    calldll #user, "GetWindowWord", h as word,_
        GWW as word, hInstance as word

    calldll #user, "CreateWindow", _
        "tooltips_class" as ptr, _
        "" as ptr, _
        style as long, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        h as word, _
        0 as word, _
        hInstance as word, _
        "" as ptr, _
        hwndTT as word

    '** MAKE A STRUCT FOR EACH TOOL
    struct toolinfo1, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo2, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo3, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo4, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo5, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo6, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo7, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo8, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo9, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo10, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo11, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo12, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo13, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo14, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo15, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo16, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo17, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr


    toolinfo1.cbSize.struct = 22
    toolinfo1.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo1.hwnd.struct = h
    toolinfo1.uId.struct = hwnd(#1.new)
    toolinfo1.hInst.struct = hInstance
    toolinfo1.lpstrText$.struct = "New File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo1 as struct, re as long

    toolinfo2.cbSize.struct = 22
    toolinfo2.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo2.hwnd.struct = h
    toolinfo2.uId.struct = hwnd(#1.open)
    toolinfo2.hInst.struct = hInstance
    toolinfo2.lpstrText$.struct = "Open File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo2 as struct, re as long

    toolinfo3.cbSize.struct = 22
    toolinfo3.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo3.hwnd.struct = h
    toolinfo3.uId.struct = hwnd(#1.save)
    toolinfo3.hInst.struct = hInstance
    toolinfo3.lpstrText$.struct = "Save File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo3 as struct, re as long

    toolinfo4.cbSize.struct = 22
    toolinfo4.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo4.hwnd.struct = h
    toolinfo4.uId.struct = hwnd(#1.saveas)
    toolinfo4.hInst.struct = hInstance
    toolinfo4.lpstrText$.struct = "Save File As..."
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo4 as struct, re as long

    toolinfo5.cbSize.struct = 22
    toolinfo5.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo5.hwnd.struct = h
    toolinfo5.uId.struct = hwnd(#1.print)
    toolinfo5.hInst.struct = hInstance
    toolinfo5.lpstrText$.struct = "Print File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo5 as struct, re as long

    toolinfo6.cbSize.struct = 22
    toolinfo6.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo6.hwnd.struct = h
    toolinfo6.uId.struct = hwnd(#1.run)
    toolinfo6.hInst.struct = hInstance
    toolinfo6.lpstrText$.struct = "Run Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo6 as struct, re as long

    toolinfo7.cbSize.struct = 22
    toolinfo7.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo7.hwnd.struct = h
    toolinfo7.uId.struct = hwnd(#1.debug)
    toolinfo7.hInst.struct = hInstance
    toolinfo7.lpstrText$.struct = "Debug Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo7 as struct, re as long

    toolinfo8.cbSize.struct = 22
    toolinfo8.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo8.hwnd.struct = h
    toolinfo8.uId.struct = hwnd(#1.token)
    toolinfo8.hInst.struct = hInstance
    toolinfo8.lpstrText$.struct = "Tokenize Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo8 as struct, re as long

    toolinfo9.cbSize.struct = 22
    toolinfo9.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo9.hwnd.struct = h
    toolinfo9.uId.struct = hwnd(#1.runtkn)
    toolinfo9.hInst.struct = hInstance
    toolinfo9.lpstrText$.struct = "Run an existing TKN"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo9 as struct, re as long

    toolinfo10.cbSize.struct = 22
    toolinfo10.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo10.hwnd.struct = h
    toolinfo10.uId.struct = hwnd(#1.paint)
    toolinfo10.hInst.struct = hInstance
    toolinfo10.lpstrText$.struct = "Run Windows Paintbrush"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo10 as struct, re as long

    toolinfo11.cbSize.struct = 22
    toolinfo11.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo11.hwnd.struct = h
    toolinfo11.uId.struct = hwnd(#1.file)
    toolinfo11.hInst.struct = hInstance
    toolinfo11.lpstrText$.struct = "Run File Manager"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo11 as struct, re as long

    toolinfo12.cbSize.struct = 22
    toolinfo12.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo12.hwnd.struct = h
    toolinfo12.uId.struct = hwnd(#1.note)
    toolinfo12.hInst.struct = hInstance
    toolinfo12.lpstrText$.struct = "Run Notepad"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo12 as struct, re as long

    toolinfo13.cbSize.struct = 22
    toolinfo13.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo13.hwnd.struct = h
    toolinfo13.uId.struct = hwnd(#1.calc)
    toolinfo13.hInst.struct = hInstance
    toolinfo13.lpstrText$.struct = "Run Windows Calculator"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo13 as struct, re as long

    toolinfo14.cbSize.struct = 22
    toolinfo14.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo14.hwnd.struct = h
    toolinfo14.uId.struct = hwnd(#1.help)
    toolinfo14.hInst.struct = hInstance
    toolinfo14.lpstrText$.struct = "Liberty BASIC Help"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo14 as struct, re as long

    toolinfo15.cbSize.struct = 22
    toolinfo15.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo15.hwnd.struct = h
    toolinfo15.uId.struct = hwnd(#1.tutor)
    toolinfo15.hInst.struct = hInstance
    toolinfo15.lpstrText$.struct = "Liberty BASIC Tutorial"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo15 as struct, re as long

    toolinfo16.cbSize.struct = 22
    toolinfo16.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo16.hwnd.struct = h
    toolinfo16.uId.struct = hwnd(#1.t)
    toolinfo16.hInst.struct = hInstance
    toolinfo16.lpstrText$.struct = "Right click here for an edit menu."
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo16 as struct, re as long

    toolinfo17.cbSize.struct = 22
    toolinfo17.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo17.hwnd.struct = h
    toolinfo17.uId.struct = hwnd(#1.quit)
    toolinfo17.hInst.struct = hInstance
    toolinfo17.lpstrText$.struct = "Close Program."
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo17 as struct, re as long

    RETURN



[branchlabels]
    '** OPEN DIALOG, FILL LISTBOX WITH BRANCH LABELS
    cursor hourglass
    WindowWidth=420:WindowHeight=440
    button #2.okay,   "OKAY",  [branch],      UL, 320,10,80,26
    button #2.cancel, "CANCEL",[cancelbranch],UL, 320,40,80,26
    combobox #2.branch, branch$(, [branch],10, 10, 300,380
    open "Branch Labels" for dialog_modal as #2

    print #2.branch,  "font Courier_New 0 16"
    print #2.okay,   "!font Courier_New 0 20"
    print #2.cancel, "!font Courier_New 0 20"

    Print #1.t,"!lines";
    Input #1.t, rowcount
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    rowcount=int(rowcount)
    REDIM branch$(rowcount)
    branch$(0)="<start>"

    bx=1
    for i=1 to rowcount
        print #1.t,"!line ";i;"";
        Input #1.t, line$ 
            if left$(trim$(line$),1)="[" then
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
            if lower$(word$(line$,1))="function" then  'improved by Carl Gundel
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
            if lower$(word$(line$,1))="sub" then  'improved by Carl Gundel
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
    next i

    SORT branch$(,0,bx

    Print #2.branch,"reload"
    print #2.branch, "selectindex 1";
    cursor normal
    print #2.branch, "setfocus"

    '** cause combobox to display in open drop position:
    hBranch=hwnd(#2.branch)
    calldll #user, "SendMessage",_
        hBranch as word,_   'handle of combobox
        _CB_SHOWDROPDOWN as word, _
        1 as word,_         'repaint flag=yes
        0 as long,_         'always 0
        re as long

    goto [loop]


[cancelbranch]
    '** CANCEL, RETURN TO EDITOR
    close #2
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    print #1.t, "!setfocus";
    goto [loop]


[branch]
    '** CHOOSE BRANCH, SET EDITOR TO THAT POSITION
    cursor hourglass
    print #2.branch,"selection?"
    Input #2.branch,branchselect$ 

    if branchselect$="<start>" then
        print #1.t, "!origin 1 1";
        print #1.t, "!setfocus";
        cursor normal
        close #2
        goto [loop]
    end if

    branchlength=len(branchselect$)

    For i = 1 TO rowcount
       print #1.t,"!line ";i;
       Input #1.t,line$
          If trim$(line$)= branchselect$ Then
            Print #1.t, "!origin ";i;" ,0";
            i=rowcount
            close #2
            print #1.t, "!setfocus";
            cursor normal
            goto [loop]
          END If
    Next i
    cursor normal
    goto [loop]




[bmp] '** BITMAP PREVIEWER
    WindowWidth=640:WindowHeight=480

    button #bit.open, "Open",   [openbmp],  UL,350,5,80,26
    button #bit.save, "Save As",[savebmp],  UL,350,35,80,26
    button #bit.exit, "Exit",   [closebit], UL,350,65,80,26

    button #bit.draw, "Choose Pen Color",[colorChoice],UL,450,5,160,26
    statictext #bit.ins, "Click and drag to draw on bitmap.",450,40,150,60
    textbox #bit.t1, 20,35,300,26
    textbox #bit.t2, 20,65,300,26


    graphicbox #bit.box1, 20,100,600,340

    statictext #bit.s, "Bitmap File:",20,5,150,20
    open "Bitmap Preview" for dialog_modal as #bit
    print #bit, "trapclose [closebit]"

    print #bit.t1,   "!font Times_New_Roman 0 16"
    print #bit.t2,   "!font Times_New_Roman 0 16"
    print #bit.save, "!font Times_New_Roman 0 16"
    print #bit.open, "!font Times_New_Roman 0 16"
    print #bit.exit, "!font Times_New_Roman 0 16"
    print #bit.draw, "!font Times_New_Roman 0 16"
    print #bit.s,    "!font Times_New_Roman 0 16"
    print #bit.ins,  "!font Times_New_Roman 0 16"

    print #bit.box1, "down"
    print #bit.box1, "size 2; color ";drawcolor$
    print #bit.box1, "setfocus; when leftButtonMove [drawit]"
    print #bit.box1, "when leftButtonDown [drawit]"

    goto [loop]

[closebit]
    print #bit.box1, "cls"
    close #bit
    if bmploaded=1 then unloadbmp "tempPicture"
    bmploaded=0
    goto [loop]

[drawit]
    if bmploaded=0 then
        notice "You must choose a bitmap first."
        goto [loop]
    end if

    if MouseX>bmpwidth or MouseY>bmpheight then [loop]

    print #bit.box1, "set ";MouseX;" ";MouseY
    goto [loop]



[savebmp]
    if picFile$="" then
        notice "It is not possible to SAVE.  No Bitmap has been chosen."
        goto [loop]
    end if

    filedialog "Save As..","*.bmp",savebmpfile$ 
    if savebmpfile$="" then [loop]

    print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    print #bit.box1, "flush"
    BMPSAVE "tempPicture", savebmpfile$ 

    cursor normal
    notice "Bitmap saved as "+savebmpfile$ 
    goto [loop]


[openbmp]
    filedialog "Open Bitmap","*.bmp", picFile$
    if picFile$ = "" then [loop]

    print #bit.t1, lower$(picFile$)

    bmpheight=HeightBitmap(picFile$)
    bmpwidth=WidthBitmap(picFile$)

    if bmploaded=1 then unloadbmp "tempPicture"
    loadbmp "tempPicture", picFile$
    bmploaded=1

    print #bit.t2, "Width:  ";bmpwidth;"    Height:  ";bmpheight;""

    print #bit.box1, "cls"
    print #bit.box1, "drawbmp tempPicture 0 0"
    print #bit.box1, "flush"
    goto [loop]



[colorChoice]
    print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    print #bit.box1, "flush"

    WindowWidth=320:WindowHeight=350
    button     #color.default,   "Get Color",[get.col],        UL,200,10,100,30
    button     #color.okay,      "Close",    [quitColorChoice],UL,200,50,100,30
    textbox    #color.red,       20, 50, 150, 30
    textbox    #color.green,     20, 150, 150, 30
    textbox    #color.blue,      20, 250, 150, 30
    statictext #color.redtext,   "Red:  (0-255)", 20, 20, 100, 20
    statictext #color.greentext, "Green:  (0-255)", 20, 120, 100, 20
    statictext #color.bluetext,  "Blue:  (0-255)", 20, 220, 100, 20
    statictext #color.colorname, "Color is...", 200, 120, 100, 20
    statictext #color.colornum,  " ", 200, 150, 100, 20
    graphicbox #color.color,     200, 180, 100, 100
    open "RGB Color Choice" for dialog as #color
    print #color, "trapclose [quitColorChoice]"
    print #color.red,   str$(colorred)
    print #color.green, str$(colorgreen)
    print #color.blue,  str$(colorblue)

[get.col]
    print #color.red, "!contents?"
    input #color.red, colorred
    print #color.green, "!contents?"
    input #color.green, colorgreen
    print #color.blue, "!contents?"
    input #color.blue, colorblue

    if colorred>255 then colorred=255
    if colorred<0 then colorred=0
    print #color.red, str$(colorred)

    if colorgreen>255 then colorgreen=255
    if colorgreen<0 then colorgreen=0
    print #color.green, str$(colorgreen)

    if colorblue>255 then colorblue=255
    if colorblue<0 then colorblue=0
    print #color.blue, str$(colorblue)

    longcol=(colorblue*65536)+(colorgreen*256)+colorred
    print #color.colornum, str$(longcol)

    print #color.color, "down; size 200; color ";colorred;" ";colorgreen;" ";colorblue
    print #color.color, "line 50 0 50 100"
    print #color.red, "!setfocus"
    goto [loop]

[quitColorChoice]
    drawcolor$=str$(colorred)+" "+str$(colorgreen)+" "+str$(colorblue)
    print #bit.box1, "color "+drawcolor$
    close #color
    goto [loop]


[about]
    message$="About this editor..."+chr$(13)+_
        chr$(169)+"The Liberty BASIC Community"
    notice message$
    goto [loop]




[wav]
    if wavPath$="" then wavPath$=DefaultDir$
    filedialog "Open WAV file",wavPath$+"\*.WAV",wavFile$
    if wavFile$="" then
        playwave ""
        goto [loop]
    end if

    slash=len(wavFile$)
        while instr(wavFile$, "\", slash)=0
            slash=slash-1
        wend
    wavPath$=left$(wavFile$,slash)
    playwave wavFile$,async
    goto [wav]



[write.ini.file]
    open DefaultDir$ + "\editor.ini" for output as #inifile
        print #inifile, setFont$
    close #inifile
    RETURN



[read.ini.file]
    open DefaultDir$ + "\editor.ini" for append as #inifile
        if lof(#inifile) <> 0 then
            close #inifile
            open DefaultDir$ + "\editor.ini" for input as #inifile
            line input #inifile, setFont$
        end if
    close #inifile

    if setFont$="" then setFont$="Fixedsys 8 15"
    print #1.t, "!font ";setFont$  'set font in texteditor
    RETURN


[create.caret]
    CallDll #user, "CreateCaret",_
        hText as short,_    'text editor handle
        0 as short,_        'bitmap handle, if used
        10 as short,_       'pixel width of new caret
        12 as short,_       'pixel height of new caret
        r as void           'no return

    CallDLL #user, "SetCaretPos",_
        1 AS short,_        'x location
        1 AS short,_        'y location
        r AS void

    CallDll #user, "ShowCaret",_
        hText as short,_    'text editor handle
        r as void           'no return
    return



[numbertools]
    popupMenu "&Decimal to Hex Converter",[dectohex],_
        "&Hex to Decimal Converter",[hextodec]
    goto [loop]

[dectohex]
    prompt "Enter a number...";decnum$
    decnum=val(decnum$)
    notice dechex$(decnum)
    goto [loop]

[hextodec]
    prompt "Enter a hex number...";hexnum$
    notice hexdec(hexnum$)
    goto [loop]



[timetools]
    popupMenu "Current &Time",[timenow],_
        "Today's &Date",[datenow]
    goto [loop]

[timenow]
    timemsg$="Current time is:  "+chr$(13)+_
    time$()+chr$(13)+chr$(13)+_
    "Seconds since midnight:  "+str$(time$("seconds"))+chr$(13)+_
    "Milliseconds since midnight:  "+str$(time$("milliseconds"))
    notice timemsg$
    goto [loop]

[datenow]
    datemsg$="Date is" +chr$(13)+_
    date$() +chr$(13)+_
    date$("mm/dd/yyyy") +chr$(13)+_
    date$("mm/dd/yy") +chr$(13)+_
    date$("yyyy/mm/dd") +chr$(13)+_
    "Days since Jan 1, 1900:  "+ date$("days")
    notice datemsg$
    goto [loop]



[fontdialog]
    fontdialog setFont$,setFont$
    print #1.t, "!font ";setFont$
    gosub [write.ini.file]
    goto [loop]


[makebmpbutton]
    WindowWidth=btnwide+40:WindowHeight=btnhigh+60
    graphicbox #b.g, 0,0,200,100
    open "BmpButton" for window_nf as #b
    print #b, "trapclose [closeb]"

    print #b.g, "font arial 0 12 bold"
    print #b.g, "down;color red ; place 5 10"
    print #b.g, "|Quit"
    print #b.g, "color 230 230 230"
    print #b.g, "line 0 0 29 0;line 0 0 0 14"
    print #b.g, "color darkgray"
    print #b.g, "line 28 1 28 14;line 1 13 28 13"
    print #b.g, "color 45 45 45"
    print #b.g, "line 29 1 29 15;line 1 14 29 14"
    print #b.g, "getbmp quitbutton 0 0 30 15"
    BMPSAVE "quitbutton","qbutton.bmp"
[closeb]
    WindowWidth=600:WindowHeight=480
    close #b:return

[libertyhome]
    CALL RunThis "http://www.libertybasic.com/" ,h
    goto [loop]


[emailcarl]
    CALL RunThis "mailto:carlg@libertybasic.com?Subject=Liberty BASIC" ,h
    goto [loop]


[code.library]
    dim code$(100)
    codeindex=0
    gosub [make.lib]
    open "codelibr.txt" for input as #code
    while eof(#code)=0
    line input #code, codeline$ 
        if left$(trim$(codeline$),2)="'>" then
            code$(codeindex)=codeline$
            codeindex=codeindex+1
        end if
    wend
    close #code

    WindowWidth=400:WindowHeight=450
    combobox #lib.c, code$(,[code.choice],10, 10, 250,400
    button #lib.copy, "Copy",[copy.lib],UL,10,50,100,30
    button #lib.cancel, "Cancel",[quit.lib],UL,150,50,100,30
    texteditor #lib.text, 10, 90, 370,300
    open "Code Library" for dialog as #lib

    print #lib, "trapclose [quit.lib]"
    print #lib.c, "selectindex 1"

[code.choice]
    endmarker=0
    print #lib.c, "selection?"
    input #lib.c, codeChoice$
    open "codelibr.txt" for input as #code
    print #lib.text, "!cls"
    while eof(#code)=0 and endmarker=0
        line input #code, codeline$ 
        if trim$(codeline$)=codeChoice$ then
            print #lib.text, codeline$
            while endmarker=0
            line input #code, codeline$
            print #lib.text, codeline$
            if left$(trim$(codeline$),2)="'}" then endmarker=1
            wend
        end if
    wend
    close #code
    print #lib.text, "!origin 1 1";

[lib.loop]
    input a$


[copy.lib]
    print #lib.text, "!selectall"
    print #lib.text, "!copy"
    notice "Snippet has been copied to clipboard."

[quit.lib]
    close #lib
    goto [loop]


[make.lib]'if library file doesn't exist, create it
    if FileExist(DefaultDir$,"\codelibr.txt")>0 then RETURN

    open "codelibr.txt" for output as #clib

    print #clib, "'>function GetSysColor$(Item)"
    print #clib, "'"
    print #clib, "'Cameron Arnott"
    print #clib, "'blue_steel@globalfreeway.com.au"
    print #clib, "'"
    print #clib, "' Gets the system color for the Windows area referred to by"
    print #clib, "' nIndex.  It returns the color value of that area.  Handy"
    print #clib, "' for setting the system colors back at the end of a program"
    print #clib, "' in which you have changed them."
    print #clib, "'  We use the Windows constants eg: COLOR_MENU,"
    print #clib, "' but of course LB requires that Windows constants"
    print #clib, "' be preceeded by an underscore character IE: _COLOR_MENU"
    print #clib, "'"
    print #clib, "'["
    print #clib, "variable$ = GetSysColor$(Item)"
    print #clib, "']"
    print #clib, "'{"
    print #clib, "function GetSysColor$(Item)"
    print #clib, "'"
    print #clib, "' WHERE Item is one of the following"
    print #clib, "' Windows Constant _COLOR_SCROLLBAR = 0"
    print #clib, "' Windows Constant _COLOR_BACKGROUND = 1"
    print #clib, "' Windows Constant _COLOR_ACTIVECAPTION = 2"
    print #clib, "' Windows Constant _COLOR_INACTIVECAPTION = 3"
    print #clib, "' Windows Constant _COLOR_MENU = 4"
    print #clib, "' Windows Constant _COLOR_WINDOW = 5"
    print #clib, "' Windows Constant _COLOR_WINDOWFRAME = 6"
    print #clib, "' Windows Constant _COLOR_MENUTEXT = 7"
    print #clib, "' Windows Constant _COLOR_WINDOWTEXT = 8"
    print #clib, "' Windows Constant _COLOR_CAPTIONTEXT = 9"
    print #clib, "' Windows Constant _COLOR_ACTIVEBORDER = 10"
    print #clib, "' Windows Constant _COLOR_INACTIVEBORDER  = 11"
    print #clib, "' Windows Constant _COLOR_APPWORKSPACE  = 12"
    print #clib, "' Windows Constant _COLOR_HIGHLIGHT = 13"
    print #clib, "' Windows Constant _COLOR_HIGHLIGHTTEXT = 14"
    print #clib, "' Windows Constant _COLOR_BTNFACE = 15"
    print #clib, "' Windows Constant _COLOR_BTNSHADOW = 16"
    print #clib, "' Windows Constant _COLOR_GRAYTEXT = 17"
    print #clib, "' Windows Constant _COLOR_BTNTEXT = 18"
    print #clib, "' Windows Constant _COLOR_ENDCOLORS = _COLOR_BTNTEXT"
    print #clib, "'"
    print #clib, "    open "+chr$(34)+"user"+chr$(34)+" for dll as #user"
    print #clib, "        calldll #user,  "+chr$(34)+"GetSysColor"+chr$(34)+",_"
    print #clib, "        Item as word,_"
    print #clib, "        ItemColor as long"
    print #clib, "    close #user"
    print #clib, ""
    print #clib, "' ** RETRIEVE VALUES FOR red, green, blue"
    print #clib, "    blue  = int(ItemColor / (256 * 256))"
    print #clib, "    green = int((ItemColor - blue *256*256) / 256)"
    print #clib, "    red   = ItemColor - blue *256 * 256 - green * 256"
    print #clib, ""
    print #clib, "    GetSysColor$="+chr$(34)+"color "+chr$(34)+";red;"+chr$(34)+" "+chr$(34)+";green;"+chr$(34)+" "+chr$(34)+ ";blue"
    print #clib, ""
    print #clib, "end function"
    print #clib, "'"
    print #clib, "'}"
    close #clib
    RETURN


[edithelp]
    if helpopen = 1 then
        notice "Help window is already open!"
        goto [loop]
    end if

    helpopen = 1
    WindowWidth=400:WindowHeight=300
    open "Help" for text as #help
    print #help, "Use this editor to write, edit and run"
    print #help, "Liberty BASIC source code."
    print #help, "Be sure to try out the many"
    print #help, "programming tools provided."
    print #help, "This program is in the public domain."
    print #help, "Feel free to use and modify."
    print #help, "!origin 1 1";
    print #help, "!trapclose [quit.edithelp]";

    input a$ 

    [quit.edithelp]
    close #help
    helpopen = 0
    goto [loop]



'*************** FUNCTION LIBRARY **********************
    function WidthBitmap(name$)
        open name$ for input as #pic
        pic$=input$(#pic,29)
        close #pic
        WidthBitmap = asc(mid$(pic$,19,1)) + (asc(mid$(pic$,20,1)) * 256)
    end function

    function HeightBitmap(name$)
        open name$ for input as #pic
        pic$=input$(#pic,29)
        close #pic
        HeightBitmap = asc(mid$(pic$,23,1)) + (asc(mid$(pic$,24,1)) * 256)
    end function


    function SeparateFile$(f$)
        fileindex=len(f$)
        filelength=len(f$)
          while mid$(f$, fileindex,1)<>"\"
            fileindex=fileindex-1
          wend
        SeparateFile$=right$(f$,filelength-fileindex)
        end function


    function SeparatePath$(f$)
        fileindex=len(f$)
        filelength=len(f$)
          while mid$(f$, fileindex,1)<>"\"
            fileindex=fileindex-1
          wend
        SeparatePath$=left$(f$,fileindex)
        end function


    function FileExist(fPath$,fFile$)
        files fPath$,fFile$,info$(
        FileExist=val(info$(0,0))
        end function


    sub RunThis RunFile$, hWindow
        RunFile$=RunFile$+chr$(0)
        lpOperation$ = "open" + chr$(0)
        lpParameters$ = "" + chr$(0)
        lpDirectory$ = "" + chr$(0)
        nShowCmd = _SW_SHOWNORMAL

        open "shell.dll" for dll as #shell
        calldll #shell, "ShellExecute", _
            hWindow as word, _          'parent window
            lpOperation$ as ptr, _      'open or print
            RunFile$ as ptr, _          'file name
            lpParameters$ as ptr, _     'null
            lpDirectory$ as ptr, _      'default directory
            nShowCmd as short, _        'show window flag
            result as word
        close #shell
        if result <= 32 then notice "Error, Address Failure!"
    end sub


[remove.menu]
    CallDll #user, "GetMenu",_
        h as word,_     'window handle
        hMenu1 as word  'returns handle of menu bar

    CallDll #user, "GetSubMenu",_
        hMenu1 As word,_    'handle of menu bar
        0 As word,_         'position of sub menu desired 0 - first
        hmenuFile As word   'handle of sub menu for File menu

    CallDll #user, "GetSubMenu",_
        hMenu1 As word,_    'handle of menu bar
        2 As word,_         'position of recent menu 2 = third
        hmenuRecent As word 'returns handle of recent menu

    menuflags = _MF_BYPOSITION Or _MF_POPUP Or _MF_STRING
    CallDll #user, "ModifyMenu",_
        hmenuFile As word, _    'handle of menu to modify
        7 As word,_             'position of item to change (8th item)
        menuflags As word, _    'flags for type of change
        hmenuRecent As word,_   'menu to add as a popup
        "&Recent" As ptr, _     'name of menu item
        result As word

    CallDll #user, "RemoveMenu",_   'remove recent menu from view
        hMenu1 As word, _           'handle of menu bar
        2 As word,_                 '2 = position of menu to remove
        _MF_BYPOSITION As word, _   'flag for remove by position
        result As word

    CallDll #user, "DrawMenuBar",_  'must redraw bar after change
        h As word,_                 'window handle
        result As word
       RETURN


[recent.files]
    recentfile$(3)=recentfile$(2)
    recentfile$(2)=recentfile$(1)
    recentfile$(1)=LOWER$(file$)
    RETURN


[File_1]
    if recentfile$(1)="" then [loop]
    file$=recentfile$(1)
    GoTo [loadFile]

[File_2]
    if recentfile$(2)="" then [loop]
    file$=recentfile$(2)
    GoTo [loadFile]

[File_3]
    if recentfile$(3)="" then [loop]
    file$=recentfile$(3)
    GoTo [loadFile]


[makeArrays] 'based on original code by Doyle Whisenant
    DIM myarray$(1000)
    left=int((DisplayWidth-280)/2):top=int((DisplayHeight-215)/2)
    WindowWidth = 280
    WindowHeight = 215
    bString = 0
    bNumeric = 1
    i = 0
    statictext #arraymake.static1, "Array Name:", 6, 11, 88, 20
    statictext #arraymake.static2, "Item to Add:", 6, 71, 96, 20
    groupbox #arraymake.groupbox3, "Type", 150, 11, 110, 70
    radiobutton #arraymake.string, "String$", [stringSet], [loop], 182, 31, 72, 20
    radiobutton #arraymake.numeric, "Numeric", [numericSet], [loop], 182, 56, 72, 20
    button #arraymake.default, "Add Item", [ArrayAdd], UL, 150, 86, 112, 25
    TEXTEDITOR #arraymake.text, 0, 0, 0, 0
    button #arraymake.file, "File", [ArrayFile], UL, 150, 119, 112, 25
    button #arraymake.create, "Create and Exit", [create], UL, 150, 151, 112, 25
    button #arraymake.cancel, "Cancel", [ArrayCancel], UL, 14, 151, 112, 25
    textbox #arraymake.arrayName, 6, 31, 136, 25
    textbox #arraymake.arrayItem, 6, 86, 136, 25
    open "Array Maker" for dialog_nf_modal as #arraymake
    print #arraymake, "font ms_sans_serif 0 8"
    print #arraymake.numeric, "set" 'flag bNumeric = 1
    goto [loop]


[ArrayAdd]   'Perform action for the button named 'add'
    print #arraymake.arrayItem, "!contents?"
    input #arraymake.arrayItem, arrayItem$

    myarray$(i)= arrayItem$ 
    i = i + 1
    print #arraymake.arrayItem, ""
    print #arraymake.arrayItem, "!setfocus"
    goto [loop]

[ArrayFile]
   i = 0
   filedialog "Open file", "*.*", ArrayFileName$
   if ArrayFileName$ = "" then
     notice "You must input a valid file name!"
     goto [loop]
   end if
   print #arraymake.arrayName, "!contents?"
    input #arraymake.arrayName, arrayName$ 
    if bString = 1 and right$(arrayName$, 1) <> "$" then
       arrayName$ = arrayName$ + "$"
    end if
   OPEN ArrayFileName$ for input as #arrayFile
     while eof(#arrayFile) = 0
       line input #arrayFile, ArrayLine$
       myarray$(i)= ArrayLine$ 
       i = i + 1
     wend
     close #arrayFile


[create]   'Perform action for the button named 'create'
    print #arraymake.arrayName, "!contents?"
    input #arraymake.arrayName, arrayName$ 

    if arrayName$="" then arrayName$="MyArray"
    if bString=1 and right$(arrayName$,1)<>"$" then
        arrayName$=arrayName$+"$"
    end if

    print #arraymake.text, "!cls";
    print #arraymake.text, "Dim ";arrayName$;"(";i;")"
    For a = 0 to i-1
    if right$(arrayName$, 1) = "$" then
      Print #arraymake.text, arrayName$;"(";a;") = ";chr$(34);myarray$(a);chr$(34)
    else
      Print #arraymake.text, arrayName$;"(";a;") = ";myarray$(a)
    end if
    Next a

    Print #arraymake.text, "!selectall";
    Print #arraymake.text, "!copy";
    Print #arraymake.text, "!cls";
    notice "Array is copied into clipboard. Paste into your application."
[ArrayCancel]   'Perform action for the button named 'cancel'
    close #arraymake
    goto [loop]

[stringSet]   'Perform action for the radiobutton named 'string'
    bString = 1
    bNumeric = 0
    goto [loop]

[numericSet]   'Perform action for the radiobutton named 'numeric'
    bNumeric = 1
    bString = 0
    goto [loop]



